define([
    'backbone',
    '../models/rule-form',
    'backbone.paginator'
], function(Backbone, LeadModel){

    var FormsCollection = Backbone.Paginator.requestPager.extend({
        model: LeadModel,
        paginator_core: {
            type: 'GET',
            dataType: 'json',
            url: function(){
                return $('#website_url').val() + 'api/leads/ruleforms/';
            }
        },
        paginator_ui: {
            firstPage:    0,
            currentPage:  0,
            perPage:     1000,
            totalPages:  1000
        },
        server_api: {
            count: true,
            limit: function() { return this.perPage; },
            offset: function() { return this.currentPage * this.perPage },
            key: function(){ return this.key; },
            isGrid: function(){ return this.isGrid; },
            forms: function(){ return this.forms; }
        },
        parse: function(response, xhr){
            if (this.server_api.count){
                this.totalRecords = response.totalRecords;
            } else {
                this.totalRecords = response.length;
            }
            this.forms = response;
            this.limitedAccess = response.limitedAccess;
            this.totalPages = Math.floor(this.totalRecords / this.perPage);
            return this.server_api.count ? response.data : response;
        }

    });

    return FormsCollection;
});