define([
    'backbone',
    './lead-form-rules',
    './lead-form-rules-grid',
    './lead-form-main',
    './lead-form-rule-detailed-info',
    '../models/form-rule',
    '../models/lead-workflows-config',
    './lead-event-rule-detailed-info',
    '../models/event-rule',
    './lead-workflow-detailed-view',
    './lead-workflow-form',
    './lead-workflow-grid',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln'
], function(Backbone,
            LeadFormRulesView, LeadFormRulesGridView, LeadFormMainView, LeadFormRuleDetailedView, FormRuleModel, WorkflowModel, LeadEventRuleDetailedView, EventRulesModel, LeadWorkflowsDetailedView, LeadWorkflowsFormView, LeadWorkflowsGridView,i18n){
    var LeadsFormRouter = Backbone.Router.extend({

        routes: {
            ''         : 'index',
            'rule/:id' : 'leadFormRulesDetails',
            'formBuild/:id' : 'leadFormBuildDetails',
            'event/:id' : 'leadEventsDetails',
            'leadworkflow/:id':'leadWorkflowDetails'
        },
        index: function (){

            //init lead form view
            $('#lead-form-block').removeClass('hidden');

            this.LeadWorkflowsForm = new LeadWorkflowsFormView();
            this.LeadWorkflowsForm.render();

            this.LeadWorkflowsGrid = new LeadWorkflowsGridView(this.getParams());
            this.LeadWorkflowsGrid.render();

            this.LeadWorkflowsForm.$el.on('LeadWorkflowFormGrid:created', _.bind(this.LeadWorkflowsGrid.render, this.LeadWorkflowsGrid));

            this.LeadFormRulesForm = new LeadFormRulesView();
            this.LeadFormRulesForm.render();

            this.LeadFormRulesFormGrid = new LeadFormRulesGridView(this.getParams());
            this.LeadFormRulesFormGrid.render();


            this.LeadFormRulesForm.$el.on('LeadFormRulesFormGrid:created', _.bind(this.LeadFormRulesFormGrid.render, this.LeadFormRulesFormGrid));

            this.LeadFormMainView = new LeadFormMainView();
            this.LeadFormMainView.render();
        },
        leadTooltipInfo: function (param) {

            var equal = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'],
                equalDescription = _.isUndefined(i18n['If you only want to match 1 item, like city, then type in its name, like']) ? 'If you only want to match 1 item, like city, then type in its name, like' : i18n['If you only want to match 1 item, like city, then type in its name, like'],
                notEqual = _.isUndefined(i18n['Not Equal']) ? 'Not Equal' : i18n['Not Equal'],
                notEqualDescription = _.isUndefined(i18n['If you want to match all items except one, then type in the name of the item you want to exclude']) ? 'If you want to match all items except one, then type in the name of the item you want to exclude' : i18n['If you want to match all items except one, then type in the name of the item you want to exclude'],
                contains = _.isUndefined(i18n['Contains']) ? 'Contains' : i18n['Contains'],
                containsDescription = _.isUndefined(i18n['If you want to match all items containing some specific word, then type in this specific word here']) ? 'If you want to match all items containing some specific word, then type in this specific word here' : i18n['If you want to match all items containing some specific word, then type in this specific word here'],
                any = _.isUndefined(i18n['Any']) ? 'Any' : i18n['Any'],
                anyDescription = _.isUndefined(i18n['If you want to match any item out of some range, then type in the list of items separated with comma']) ? 'If you want to match any item out of some range, then type in the list of items separated with comma' : i18n['If you want to match any item out of some range, then type in the list of items separated with comma'],
                greaterthan = _.isUndefined(i18n['Greater Than']) ? 'Greater Than' : i18n['Greater Than'],
                greaterthanDescription = _.isUndefined(i18n['Use when you want results that exceed the value you enter']) ? 'Use when you want results that exceed the value you enter' : i18n['Use when you want results that exceed the value you enter'],
                lessthan = _.isUndefined(i18n['Less Than']) ? 'Less Than' : i18n['Less Than'],
                lessthanDescription = _.isUndefined(i18n['Use for results that are less than the value you enter']) ? 'Use for results that are less than the value you enter' : i18n['Use for results that are less than the value you enter'];

            var description = '\'<b>'+equal+'</b>\' - '+equalDescription+' \'Boston\'. <br/>' +
                '\'<b>'+ notEqual +'</b>\' - '+ notEqualDescription +'. <br/>' +
                '\'<b>'+ contains +'</b>\' - '+ containsDescription +'. <br/>' +
                '\'<b>'+ any +'</b>\'- '+ anyDescription +'. <br/>' +
                '\'<b>'+ greaterthan +'</b>\'- '+ greaterthanDescription +'. <br/>' +
                '\'<b>'+ lessthan +'</b>\'- '+ lessthanDescription +'.';

            if(!_.isEmpty(param)){
                if(param == 'equal'){
                    description =  equalDescription +' \'Boston\'.';
                }else if(param == 'notequal'){
                    description = notEqualDescription +'.';
                }else if(param == 'like'){
                    description = containsDescription +'.';
                }else if(param == 'in'){
                    description = anyDescription +'.';
                }else if(param == 'greaterthan'){
                    description = greaterthanDescription +'.';
                }else if(param == 'lessthan'){
                    description = lessthanDescription +'.';
                }
            }

            return description;
        },
        leadWorkflowDetails: function (workflowId) {
            if (!workflowId) {
                return false;
            }

            this.LeadWorkflowModel =  new WorkflowModel();
            this.LeadWorkflowModel.set('id', workflowId);
            this.LeadWorkflowModel.fetch({data: { isGrid: true, detailedInfo:true},
                'success': function(WorkflowModel){
                    if(_.isUndefined(WorkflowModel.get('rule_name'))) {
                        window.location.href = window.location.pathname;
                    } else {
                        if (!_.isUndefined(this.workflowDetailed)) {
                            this.workflowDetailed.$el.unbind();
                        }

                        $('#lead-form-block-tabs-tab').addClass('hidden');
                        $('#lead-form-block-tabs-block').addClass('hidden');
                        $('#lead-workflow-block').removeClass('hidden');
                        this.workflowDetailed = new LeadWorkflowsDetailedView(WorkflowModel);
                        window.workflowDetailed = this.workflowDetailed;
                        this.workflowDetailed.render();
                        if (window.location.hash !== '') {
                            $('#score-grid-back-link').attr('href', $('#website_url').val()+'dashboard/workflows/');
                        }
                    }
                }
            });
        },
        leadFormRulesDetails: function(ruleId)
        {
            if (!ruleId) {
                return false;
            }

            this.LeadFormRuleModel =  new FormRuleModel();
            this.LeadFormRuleModel.set('id', ruleId);
            this.LeadFormRuleModel.fetch({data: { isGrid: true, detailedInfo:true},
                'success': function(LeadFormRuleModel){
                    if(_.isUndefined(LeadFormRuleModel.get('form_name'))) {
                        window.location.href = window.location.pathname;
                    } else {
                        if (!_.isUndefined(this.leadFormRuleDetailed)) {
                            this.leadFormRuleDetailed.$el.unbind();
                        }

                        $('#lead-form-block-tabs-tab').addClass('hidden');
                        $('#lead-form-block-tabs-block').addClass('hidden');
                        $('#lead-form-block').removeClass('hidden');
                        this.leadFormRuleDetailed = new LeadFormRuleDetailedView(LeadFormRuleModel);
                        window.leadFormRuleDetailed = this.leadFormRuleDetailed;
                        this.leadFormRuleDetailed.render();
                        if (window.location.hash !== '') {
                            $('#form-rules-grid-back-link').attr('href', $('#website_url').val()+'dashboard/workflows/');
                        }
                    }
                }
            });
        },
        leadEventsDetails: function(ruleId)
        {
            if (!ruleId) {
                return false;
            }

            this.LeadEventRuleModel =  new EventRulesModel();
            this.LeadEventRuleModel.set('id', ruleId);
            this.LeadEventRuleModel.fetch({data: { isGrid: true, detailedInfo:true},
                'success': function(EventRuleModel){
                    if(_.isUndefined(EventRuleModel.get('event_id'))) {
                        window.location.href = window.location.pathname;
                    } else {
                        if (!_.isUndefined(this.leadEventRuleDetailed)) {
                            this.leadEventRuleDetailed.$el.unbind();
                        }

                        $('#lead-event-block-tabs-tab').addClass('hidden');
                        $('#lead-form-block-tabs-block').addClass('hidden');
                        $('#lead-form-block').removeClass('hidden');
                        this.leadEventRuleDetailed = new LeadEventRuleDetailedView(EventRuleModel);
                        window.leadEventRuleDetailed = this.leadEventRuleDetailed;
                        this.leadEventRuleDetailed.render();
                        if (window.location.hash !== '') {
                            $('#event-rules-grid-back-link').attr('href', $('#website_url').val()+'dashboard/workflows/');
                        }
                    }
                }
            });
        },
        leadFormBuildDetails: function(formId)
        {
            if (!formId) {
                return false;
            }

            this.LeadFormBuilderModel =  new FormBuilderModel();
            this.LeadFormBuilderModel.set('id', formId);
            this.LeadFormBuilderModel.fetch({data: { isGrid: true, detailedInfo:true},
                'success': function(FormBuilderModel){
                    if(_.isUndefined(FormBuilderModel.get('form_name'))) {
                        window.location.href = window.location.pathname;
                    } else {
                        if (!_.isUndefined(this.leadFormBuilderDetailed)) {
                            this.leadFormBuilderDetailed.$el.unbind();
                        }

                        $('#lead-event-block-tabs-tab').addClass('hidden');
                        $('#lead-form-block-tabs-block').addClass('hidden');
                        $('#lead-form-block').removeClass('hidden');
                        this.leadFormBuilderDetailed = new FormBuilderDetailedView(FormBuilderModel);
                        window.leadFormBuilderDetailed = this.leadFormBuilderDetailed;
                        this.leadFormBuilderDetailed.render();
                        if (window.location.hash !== '') {
                            $('#form-builder-grid-back-link').attr('href', $('#website_url').val()+'dashboard/workflows/');
                        }
                    }
                }
            });
        },
        getParams:  function () {
            var result = {},
                tmpData = [];
            location.search
                .substr(1)
                .split("&")
                .forEach(function (item) {
                    tmpData = item.split("=");
                    result[decodeURIComponent(tmpData[0])] = decodeURIComponent(tmpData[1]);
                });
            return result;
        }
    });

    var initialize = function() {
        window.appLeadFormRouter = new LeadsFormRouter;
        Backbone.history.start();
    };

    return {
        initialize: initialize
    };
});