define([
    'backbone',
    'text!../templates/lead-email-detailed-tab.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'tinyMCE',
    'leadshortcode',
    'leadtestemail'
], function(Backbone, LeadEmailTmpl, i18n, tinymce, leadshortcode, leadtestemail){
    var LeadEmailFormView = Backbone.View.extend({
        el: $('#lead-detailed-view-config-tab-email'),
        events: {
            'submit form': 'submit',
            'change #lead-email-file-folder': 'changeFolder',
            'focus #lead-email-file-folder': 'refreshFolderImages',
            'click .full-screen .list-images a':'accordion',
            'click #lead-email-files' : 'chooseFiles',
            'click .insert-file-into-email': 'insertFileLink',
            'change #lead-email-template': 'changeLeadEmailTemplate',
            'focus #lead-email-template': 'keepPreviousTemplateValue',
            'click span.refresh-items' : 'refreshItems'
        },
        templates: {

        },
        initialize: function(leadModel, emailTabDataModel){
            this.leadModel = leadModel;
            this.leadEmailTabData = emailTabDataModel;
        },
        initAccordion:function()
        {
            $('#lead-email-images-block').accordion({
                heightStyle    : "content",
                navigation     : true,
                collapsible    : true,
                active         : false,
                beforeActivate : function(event, ui){
                    if($(event.toElement).hasClass('screen-size')){
                        return false;
                    }

                    if(typeof event.originalEvent !== 'undefined' && $(event.originalEvent.target).hasClass('ticon-refresh')){
                        return false;
                    }
                },
                icons          : {
                    "header"       : "ticon-arrow-right",
                    "activeHeader" : "ticon-arrow-down"
                }
            });
        },
        render: function(){
            tinymce.remove();
            this.$el.empty();
            var websiteUrl = $('#website_url').val(),
                self = this;

            this.$el.append(_.template(LeadEmailTmpl, {'leadModel': this.leadModel, 'emailTabDataModel':  this.leadEmailTabData, 'i18n': i18n}));
            this.$el.find('form').attr('action', websiteUrl+'plugin/leads/run/sendEmail/');

            tinymce.init({
                script_url              : websiteUrl+'system/js/external/tinymce/tinymce.gzip.php',
                selector                : "#lead-email-tab-textarea",
                skin                    : 'seotoaster',
                menubar                 : false,
                browser_spellcheck      : true,
                resize                  : false,
                convert_urls            : false,
                relative_urls           : false,
                statusbar               : false,
                allow_script_urls       : true,
                force_p_newlines        : true,
                forced_root_block       : false,
                entity_encoding         : "raw",
                plugins                 : [
                    "advlist lists link anchor image charmap visualblocks code media table paste textcolor fullscreen leadshortcode leadtestemail autolink"
                ],
                toolbar1                : "leadshortcode bold italic underline alignleft aligncenter alignright alignjustify | bullist numlist forecolor backcolor | link unlink image media hr | formatselect | fontsizeselect | pastetext code | fullscreen | spellcheckbtn | leadtestemail",
                fontsize_formats        : "8px 10px 12px 14px 16px 18px 24px 36px",
                block_formats           : "Block=div;Paragraph=p;Block Quote=blockquote;Cite=cite;Address=address;Code=code;Preformatted=pre;H2=h2;H3=h3;H4=h4;H5=h5;H6=h6",
                image_advtab            : true,
                extended_valid_elements : "a[*],input[*],select[*],textarea[*]",
                setup                   : function(ed){
                    var keyTime = null;
                    ed.on('change blur keyup', function(ed, e){
                        //@see content.js for this function
                        self.dispatchEditorKeyup(ed, e, keyTime);
                        this.save();
                    });

                    ed.addButton('spellcheckbtn', {
                        icon: true,
                        image: websiteUrl+'plugins/leads/web/images/spellcheck.ico',
                        tooltip: _.isUndefined(i18n['How do I enable spell-check in SeoToaster?'])?'How do I enable spell-check in SeoToaster?':i18n['How do I enable spell-check in SeoToaster?'],
                        onclick: function() {
                            window.open('https://www.seotoaster.com/questions-and-answers/crm-faq#lead-spellchecker', '_blank');
                        }
                    })
                }
            });

            $('#lead-email-tab-textarea').html('<span></span>').trigger('keyup');
            this.tinimce = tinymce;
            this.initAccordion();
            $("#lead-email-follow-up-sequences").chosen({
                'disable_search': true
            }).on('chosen:showing_dropdown', function (e) {
                let setElements = $(e.currentTarget.nextSibling).find('li.disabled-result');
                if (setElements.length) {
                    setElements.addClass('tooltip').attr('title', _.isUndefined(i18n['Set in Workflows']) ? 'Set in Workflows' : i18n['Set in Workflows']);
                }
            });
        },
        changeFolder: function(e)
        {
            var chosenFolder = $(e.currentTarget).val(),
                self = this;
            if (!_.isEmpty(chosenFolder)) {
                var el = $('#upload_things_button'),
                    dataUrl = el.data('url').replace(/folder\/.*/, '')+'folder/'+chosenFolder+'/';
                el.data('url', dataUrl);
                $.ajax({
                    url        : $('#website_url').val() + 'plugin/leads/run/loadImages/',
                    type       : 'post',
                    dataType   : 'json',
                    data       : {
                        folderName: chosenFolder
                    },
                    beforeSend : function() {
                    },
                    success : function(response) {
                        $('#lead-email-images-small').find('.images-preview').replaceWith(response.responseText.small);
                        $('#lead-email-images-medium').find('.images-preview').replaceWith(response.responseText.medium);
                        $('#lead-email-images-large').find('.images-preview').replaceWith(response.responseText.large);
                        $('#lead-email-images-original').find('.images-preview').replaceWith(response.responseText.original);
                        self.chooseFiles();

                        var openedTab = $('.ui-accordion-content-active');

                        if(openedTab.length < 1){
                            $('#lead-email-files').trigger('click');
                        }
                    },
                    error: function() {
                        console.log('failed to load');
                    }
                })
            }
        },
        chooseFiles: function()
        {
            var listFiles = $('#list_files');
            $.ajax({
                url        : $('#website_url').val() + 'plugin/leads/run/loadFiles/',
                type       : 'post',
                dataType   : 'json',
                data       : {
                    folder : $('#lead-email-file-folder').val()
                },
                success : function(response) {
                    listFiles.html(response.responseText);
                },
                error: function() {
                    listFiles.html(_.isUndefined(i18n['Unable to load files list'])?'Unable to load files list':i18n['Unable to load files list']);
                }
            });
        },
        refreshFolderImages: function(e){
            var el = $(e.currentTarget);
            var selectedFolder = $('#lead-email-file-folder').val();
            $.get($('#website_url').val()+'plugin/leads/run/refreshfolders/', function(response){
                if(!response.error){
                    el.empty();
                    $.each(response.responseText, function(id, folderName){
                        var selected = '';
                        if(selectedFolder == folderName) {
                            selected = 'selected="selected"';
                        }
                        el.append('<option value="'+folderName+'" '+selected+'>'+folderName+'</option>')
                    });
                }
            });
        },
        insertFileLink: function(e) {
            e.preventDefault();
            var fileName = $(e.currentTarget).data('file-name'),
                fileFolder = $(e.currentTarget).data('file-folder');

            tinymce.activeEditor.execCommand(
                'mceInsertContent',
                false,
                '<a class="file-link-attachment" data-file-name="'+fileName+'" data-file-folder="'+fileFolder+'" href="' + $('#website_url').val() + 'media/' + $('#lead-email-file-folder').val() + '/' + fileName + '" title="' + fileName + '">' + fileName + '</a>'
            );
        },
        accordion: function() {
            $('.closebutton').show();
            $('.screen-size').removeClass('ticon-turn').addClass('ticon-expand');
            $('.show_div').removeClass('full-screen');
        },
        dispatchEditorKeyup: function(editor, event, keyTime) {
            var keyTimer = keyTime;
            if(keyTimer === null) {
                keyTimer = setTimeout(function() {
                    keyTimer = null;
                }, 1000)
            }
        },
        changeLeadEmailTemplate: function(e)
        {
            var templatesEl = $(e.currentTarget),
                templateId = templatesEl.val(),
                leadId = this.leadModel.get('id'),
                self = this;

            if (tinymce.activeEditor.dom.get('email-default-message-template') !== null && typeof self.previousContentEmailMessage !== 'undedfined' &&  tinymce.activeEditor.getContent() !== self.previousContentEmailMessage) {
                showConfirm(_.isUndefined(i18n['Your changes will be discarded. Proceed anyway?'])?'Your changes will be discarded. Proceed anyway?':i18n['Your changes will be discarded. Proceed anyway?'], function(){
                    self.changeTemplate(templatesEl, templateId);
                }, function() {
                    templatesEl.val(self.previousTemplateValue);
                });
            } else {
                this.changeTemplate(templatesEl, templateId, leadId);
            }

        },
        changeTemplate: function(templatesEl, templateId, leadId)
        {
            var  self = this;

            $.ajax({
                'url' :$('#website_url').val()+'plugin/leads/run/getEmailDefaultMessage/',
                'data': {'templateId': templateId, 'leadId':leadId},
                'type': 'GET',
                'dataType' : 'json'
            }).done(function(response){
                if (response.error == 0) {
                    tinymce.activeEditor.dom.remove('email-default-message-template');
                    if (response.responseText.emailDefaultMessage) {
                        tinymce.activeEditor.execCommand(
                            'mceInsertContent',
                            false, '<div id="email-default-message-template">'+response.responseText.emailDefaultMessage+'</div>');

                        self.previousContentEmailMessage = tinymce.activeEditor.getContent();
                    }

                    if (response.responseText.pageUrl !== '') {
                        $('#email-message-preview-link').prop('href', $('#website_url').val()+ response.responseText.pageUrl).removeClass('hidden');
                        templatesEl.removeClass('grid_12').addClass('grid_8');
                    } else {
                        templatesEl.removeClass('grid_8').addClass('grid_12');
                        $('#email-message-preview-link').addClass('hidden');
                    }
                } else {
                    tinymce.activeEditor.execCommand(
                        'mceInsertContent',
                        false, '');

                    self.previousContentEmailMessage = tinymce.activeEditor.getContent();
                }
                //tinymce.activeEditor.getBody().firstChild.scrollIntoView();
                tinymce.activeEditor.selection.setCursorLocation(tinymce.activeEditor.getBody().firstChild, 0);
                tinymce.activeEditor.execCommand(
                    'mceInsertContent',
                    false, ' ');
                $('html, body').animate({
                    scrollTop: $("#lead-email-form").offset().top
                }, 1000);

            });
        },
        keepPreviousTemplateValue: function(e) {
          this.previousTemplateValue = $(e.currentTarget).val();
        },
        submit: function(e){
            e.preventDefault();

            var self = this,
                form = $(e.currentTarget),
                isValid = true;

            _.each(form.find('.required'), function(el){
                if (!$(el).val()){
                    isValid = false;
                }
            });

            if (!isValid){
                showMessage(_.isUndefined(i18n['Missing required field'])?'Missing required field':i18n['Missing required field'], true);
                return false;
            }

            $('#content-of-the-email').val(tinymce.activeEditor.getContent());

            if(form.find('#testEmail').val() != 1) {
                $('#lead-email-now').prop('disabled', true);
            }

            var formParams = form.serialize()+'&secureToken='+$('#lead-grid-token').val(),
                emailSequenceId = form.find('#lead-email-follow-up-sequences').val();

            $.ajax({
                url: form.attr('action'),
                type: 'POST',
                data: formParams,
                dataType: 'json'
            }).done(function(response) {
                $('#lead-email-now').prop('disabled', false);
                if (response.error === 1) {
                    form.find('#testEmail').val(0);
                    showMessage(response.responseText, true, 5000);
                } else {
                    showMessage(response.responseText, false, 5000);
                    if(form.find('#testEmail').val() != 1){
                        self.render();
                    }
                    form.find('#testEmail').val(0);
                    self.initAccordion();
                }
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
            return false;

        },
        refreshItems: function (e) {
            e.preventDefault();
            $('#lead-email-file-folder').trigger('change');
        }
    });

    return LeadEmailFormView;
});
