define([
    'backbone',
    'moment',
    'text!../templates/filter-custom-params-field-row.html',
    'text!../templates/filter-lead-organization-custom-params-field-row.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln'
], function(Backbone, moment, LeadCustomParamFieldRowTmpl, LeadOrganizationCustomParamFieldRowTmpl, i18n){
    var LeadFilterPresetView = Backbone.View.extend({
        el: $('#filter-settings-preset-block'),
        events: {
            'click #save-filter-preset': 'saveFilterPreset',
            'change #lead-predefined-filter-list': 'changeFilterPreset',
            'click #delete-filter-preset': 'deleteFilterPreset'
        },
        templates: {

        },
        initialize: function(){
            this.$el = $('#filter-settings-preset-block');
        },
        render: function(){
            return this;
        },
        saveFilterPreset: function(e)
        {
            e.preventDefault();
            var leadFilterPresetName = $('#lead-filter-preset-name').val(),
                leadFilterPresetDefault = 0,
                leadFilterAllowPreset = 'individual',
                requestType = 'POST',
                leadPresetId = $('#lead-preset-id').val(),
                filterPresetData = {},
                notAllowedSymbols = false,
                self = this;

            if (!_.isEmpty(leadFilterPresetName)) {
                if (leadFilterPresetName.match(/[^\w\s]/)) {
                    notAllowedSymbols = true;
                }

                if(notAllowedSymbols) {
                    showMessage(_.isUndefined(i18n['Special symbols like !.,?-@:; can\'t be used for names'])?'Special symbols like !.,?"@:; can\'t be used for names':i18n['Special symbols like !.,?"@:; can\'t be used for names'], true, 5000);
                    return false;
                }

                if ($('#lead-filter-preset-default').is(':checked')) {
                    leadFilterPresetDefault = 1;
                }
                if ($('#lead-filter-preset-allow').is(':checked')) {
                    leadFilterAllowPreset = 'all';
                }
                if (!_.isEmpty(leadPresetId)) {
                    requestType = 'PUT';
                }

                filterPresetData = {'created_at_from' : ($('#lead-filter-from-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-filter-from-date').datepicker("getDate")): '',
                    'range_creation_option': $('#range-creation-option').val(),
                    'activity_id': $('#lead-filter-by-activity-type').val(),
                    'created_at_to': ($('#lead-filter-to-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-filter-to-date').datepicker("getDate")): '',
                    'last_activity_from': ($('#lead-filter-activity-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-filter-activity-date').datepicker("getDate")): '',
                    'last_activity_to': ($('#lead-filter-activity-to-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-filter-activity-to-date').datepicker("getDate")): '',
                    'range_activity_option': $('#range-activity-option').val(),
                    'stage_id': $('#lead-filter-by-stage').val(),
                    'customer_group_id':$('#lead-filter-by-group').val(),
                    'lead_source_type': $('#lead-filter-by-source-type').val(),
                    'lead_source': $('#lead-filter-by-source').val(),
                    'owner_id': $('#lead-filter-by-owner').val(),
                    'opportunity_owner_id': $('#lead-filter-by-opportunity-owner').val(),
                    'lead_zip': $('#lead-filter-zip').val(),
                    'lead_country': $('#lead-filter-country').val(),
                    'lead_country_state': $('#lead-filter-country-state').val(),
                    'lead_city': $('#lead-filter-city').val(),
                    'lead_filter_total_opportunity_amount_from': $('#lead-filter-total-opportunity-amount-from').val(),
                    'lead_filter_total_opportunity_amount_to': $('#lead-filter-total-opportunity-amount-to').val(),
                    'special_filter_type': $('input[name=leadFilterBySpecialType]:checked').val(),
                    'created_at': $('#switch-created-date:checked').val(),
                    'last_updated': $('#switch-updated-date:checked').val(),
                    'lead_tags': $('#lead-filter-tag').val(),
                    'email_sms_sequences': $('#lead-filter-by-email-sms-sequence').val(),
                    'lead_tags_exclude': $('#lead-filter-tag-exclude').val(),
                    'lead_opportunity_stages': $('#lead-filter-opportunity-stage').val(),
                    'last_interaction_id':$('#lead-filter-by-last-interaction').val(),
                    'opportunity_type_id':$('#lead-filter-by-opportunity-type').val(),
                    'lead_task':$('#lead-filter-task').val(),
                    'more_less_call_duration': $('#more-less-call-duration').val(),
                    'call_duration':$('#call-duration').val(),
                    'opportunity_date_from': ($('#lead-filter-opportunity-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-filter-opportunity-date').datepicker("getDate")): '',
                    'opportunity_date_to': ($('#lead-filter-opportunity-to-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-filter-opportunity-to-date').datepicker("getDate")): '',
                    'expected_at': $('#switch-expected-date:checked').val(),
                    'creation_at': $('#switch-creation-date:checked').val(),
                    'state_change_at': $('#switch-stage-change-date:checked').val(),
                    'interaction_value': $('#lead-filter-by-interaction').val(),
                    'lead_score_from': $('#lead-filter-score-from').val(),
                    'lead_score_to': $('#lead-filter-score-to').val(),
                    'lead_filter_total_spent_purchase_amount_from': $('#lead-filter-total-spent-purchase-amount-from').val(),
                    'lead_filter_total_spent_purchase_amount_to': $('#lead-filter-total-spent-purchase-amount-to').val(),
                    'outbound_emails_sub_type': $('#outbound-emails-sub-types').val(),
                    'industry_id': $('#lead-filter-by-industry').val(),
                    'custom_params_search': self.getCustomParams(),
                    'custom_organization_params_search': self.getOrganizationCustomParams(),
                    'email_status': $('#lead-filter-by-email-status').val(),
                    'lead_titles': $('#lead-filter-title').val(),
                    'lead_title_operator': $('#lead-filter-title-operator').val(),
                    'lead_filter_nps_score_operator': $('#lead-filter-nps-score-operator').val(),
                    'lead_filter_nps_score': $('#lead-filter-nps-score').val(),
                    'email_validation_status': $('#lead-filter-by-email-validation').val(),
                    'email_sequence_type':$('#lead-filter-by-email-sequence-type').val(),
                    'email_sequence_type_action':$('#lead-filter-by-email-sequence-type-action').val(),
                    'email_sms_sequences_type_period':$('#lead-filter-by-email-sequence-type-period').val(),
                    'validated_date_to': ($('#lead-filter-by-email-validated-to-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-filter-by-email-validated-to-date').datepicker("getDate")): '',
                    'switch_last_next_activity_date': ($('#switch-last-activity-date').is(':checked')) ? 'last-activity-date' :'next-activity-date',
                    'lead_source_type_and_utm': $('#lead-filter-by-source-type-and-utm').val(),
                    'lead_utm_source_value_id': $('#lead-filter-by-source-utm-value').val(),
                    'lead_utm_campaign_value_id': $('#lead-filter-by-campaign-utm-value').val(),
                };

                var formParams = {'filter_preset_type': $('#filter-preset-type').val(), 'filter_preset_name':leadFilterPresetName,'is_default': leadFilterPresetDefault,
                    'access': leadFilterAllowPreset, 'filter_preset_data': filterPresetData, 'secureToken': $('#lead-grid-token').val()
                    };
                if (requestType === 'PUT') {
                    formParams.id = leadPresetId;
                    formParams = JSON.stringify(formParams);
                }

                $.ajax({
                    'url': $('#website_url').val() + 'api/leads/leadfilterpreset/',
                    'type' : requestType,
                    'dataType': 'json',
                    'data': formParams
                }).done(function(response){
                    $('#lead-preset-id').val('');
                    $('#lead-filter-preset-default').prop('checked', false);
                    $('#lead-filter-preset-allow').prop('checked', false);
                    $('#lead-filter-preset-name').val('');
                    $('#range-activity-option').val(0);
                    $('#range-creation-option').val(0);
                    $('#lead-filter-by-source-type').closest('div').removeClass('grid_5').addClass('grid_12');
                    $('#lead-filter-by-last-interaction').closest('div').removeClass('grid_6').addClass('grid_12');
                    $('#lead-filter-by-email-validation').removeClass('grid_5').addClass('grid_12').removeClass('field-rule-row-first');
                    if (requestType === 'POST') {
                        $('#lead-predefined-filter-list').append('<option value="' + response.responseText.id + '">' + leadFilterPresetName + '</option>');
                    } else {
                        $('#lead-predefined-filter-list option:selected').text(leadFilterPresetName);
                    }
                    $('#lead-predefined-filter-list').val(0);
                    $('#delete-filter-preset').hide();
                    showMessage(response.responseText.message, false, 5000);
                    $('#lead-filter-reset').trigger('click');
                }).fail(function(response) {
                    showMessage(response.responseJSON, true, 5000);
                });
            }
        },
        getOrganizationCustomParams: function()
        {
            var customParamsData = [],
                fieldType = '',
                year = '',
                month = '',
                day = '',
                value = '';

            $.each($('#custom-organization-attribute-field-row-block').find('.custom-field-row-block'), function () {
                fieldType = $(this).data('field-type'),
                    operator = $(this).find('.field-operator-value').val();

                if (fieldType !== 'date') {
                    customParamsData.push({
                        'name': $(this).data('field-name'),
                        'operator': $(this).find('.field-operator-value').val(),
                        'value': $(this).find('.custom-field-row-value').val(),
                        'type': $(this).data('field-type'),
                        'subtype': $(this).data('field-subtype'),
                        'id': $(this).data('field-id'),
                        'label': $(this).data('field-label')
                    });
                } else {
                    year = $(this).find('.custom-field-row-value-year').val();
                    month = $(this).find('.custom-field-row-value-month').val();
                    day = $(this).find('.custom-field-row-value-day').val();
                    value = JSON.stringify({'year':year, 'month':month, 'day':day});

                    customParamsData.push({
                        'name': $(this).data('field-name'),
                        'operator': $(this).find('.field-operator-value').val(),
                        'value': value,
                        'type': $(this).data('field-type'),
                        'subtype': $(this).data('field-subtype'),
                        'id': $(this).data('field-id'),
                        'label': $(this).data('field-label')
                    });
                }
            });

            return customParamsData;
        },
        getCustomParams: function()
        {
            var customParamsData = [],
                fieldType = '',
                year = '',
                month = '',
                day = '',
                value = '';

            $.each($('#custom-attribute-field-row-block').find('.custom-field-row-block'), function () {
                fieldType = $(this).data('field-type'),
                    operator = $(this).find('.field-operator-value').val();

                if (fieldType !== 'date') {
                    customParamsData.push({
                        'name': $(this).data('field-name'),
                        'operator': $(this).find('.field-operator-value').val(),
                        'value': $(this).find('.custom-field-row-value').val(),
                        'type': $(this).data('field-type'),
                        'subtype': $(this).data('field-subtype'),
                        'id': $(this).data('field-id'),
                        'label': $(this).data('field-label')
                    });
                } else {
                    year = $(this).find('.custom-field-row-value-year').val();
                    month = $(this).find('.custom-field-row-value-month').val();
                    day = $(this).find('.custom-field-row-value-day').val();
                    value = JSON.stringify({'year':year, 'month':month, 'day':day});

                    customParamsData.push({
                        'name': $(this).data('field-name'),
                        'operator': $(this).find('.field-operator-value').val(),
                        'value': value,
                        'type': $(this).data('field-type'),
                        'subtype': $(this).data('field-subtype'),
                        'id': $(this).data('field-id'),
                        'label': $(this).data('field-label')
                    });
                }
            });

            return customParamsData;
        },
        deleteFilterPreset: function(e) {
            var presetId = $('#lead-predefined-filter-list').val();

            if (_.isEmpty(presetId)) {
                return false;
            }

            showConfirm(_.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'], function(){
                $.ajax({
                    url: $('#website_url').val() + 'api/leads/leadfilterpreset/id/' + presetId,
                    type: 'DELETE'
                }).done(function(response){
                    if(response.error == 1) {
                        showMessage(response.responseText, true, 5000);
                    } else {
                        $('#lead-preset-id').val('');
                        $('#lead-filter-preset-default').prop('checked', false);
                        $('#lead-filter-preset-allow').prop('checked', false);
                        $('#lead-filter-preset-name').val('');
                        $('#range-activity-option').val(0);
                        $('#range-creation-option').val(0);
                        $('#lead-filter-by-source-type').closest('div').removeClass('grid_5').addClass('grid_12');
                        $('#lead-filter-by-last-interaction').closest('div').removeClass('grid_6').addClass('grid_12');
                        $('#inbound-emails-sub-types').val(0);
                        $('#lead-predefined-filter-list').val(0);
                        $('#delete-filter-preset').hide();
                        $('#lead-predefined-filter-list option[value="'+ presetId +'"]').remove();
                        $('#lead-filter-by-email-validation').removeClass('grid_5').addClass('grid_12').removeClass('field-rule-row-first');

                        showMessage(response.responseText, false, 5000);
                        $('#lead-filter-reset').trigger('click');
                    }
                });
            });
        },
        changeFilterPreset:function(e)
        {
            var presetId = $(e.currentTarget).val();
            var self = this;
            if (_.isEmpty(presetId)) {
                return false;
            }

            if (presetId == '0') {
                $('#lead-preset-id').val('');
                $('#lead-filter-reset').trigger('click');
                $('#switch-search-filter-label').text((_.isUndefined(i18n['OR'])?'OR':i18n['OR']));
                $('#delete-filter-preset').hide();
                $('#lead-filter-country-state').closest('div').hide();
                return false;
            }

            $('#switch-search-filter-label').text((_.isUndefined(i18n['Modify preset name'])?'Modify preset name':i18n['Modify preset name']));

            $.ajax({
                'url': $('#website_url').val()+'api/leads/leadfilterpreset/',
                'type':'GET',
                'dataType':'json',
                'data': {'id': presetId, 'secureToken': $('#lead-grid-token').val()}
            }).done(function(responseData){
                if (typeof responseData.isDefault !=='undefined' && responseData.isDefault == '1') {
                    $('#lead-filter-preset-default').prop('checked', true);
                } else {
                    $('#lead-filter-preset-default').prop('checked', false);
                }
                if (typeof responseData.access !=='undefined' && responseData.access === 'individual') {
                    $('#lead-filter-preset-allow').prop('checked', false);
                } else {
                    $('#lead-filter-preset-allow').prop('checked', true);
                }
                var filtersData = JSON.parse(responseData.filterPresetData),
                    opportunityDateFrom = '',
                    opportunityDateTo = '',
                    lastActivityFrom = '',
                    lastActivityTo = '',
                    createdAtFrom = '',
                    createdAtTo = '';

                if (!_.isUndefined(filtersData.range_creation_option)) {
                    $('#range-creation-option').val(filtersData.range_creation_option);
                    $('.rangeCreationOptions').trigger('change');
                } else {
                    $('#range-creation-option').val(0);
                }

                if (!_.isUndefined(filtersData.opportunity_date_from) && filtersData.opportunity_date_from !== '') {
                    opportunityDateFrom = $.datepicker.formatDate('d-M-yy', new Date(filtersData.opportunity_date_from));
                }
                if (!_.isUndefined(filtersData.opportunity_date_to) && filtersData.opportunity_date_to !== '') {
                    opportunityDateTo = $.datepicker.formatDate('d-M-yy', new Date(filtersData.opportunity_date_to));
                }

                if (!_.isUndefined(filtersData.last_activity_from) && filtersData.last_activity_from !== '') {
                    lastActivityFrom = $.datepicker.formatDate('d-M-yy', new Date(filtersData.last_activity_from));
                }
                if (!_.isUndefined(filtersData.last_activity_to) && filtersData.last_activity_to !== '') {
                    lastActivityTo = $.datepicker.formatDate('d-M-yy', new Date(filtersData.last_activity_to));
                }

                if (!_.isUndefined(filtersData.created_at_from) && filtersData.created_at_from !== '') {
                    createdAtFrom = $.datepicker.formatDate('d-M-yy', new Date(filtersData.created_at_from));
                }
                if (!_.isUndefined(filtersData.created_at_to) && filtersData.created_at_to !== '') {
                    createdAtTo = $.datepicker.formatDate('d-M-yy', new Date(filtersData.created_at_to));
                }

                if (!_.isUndefined(filtersData.created_at_from)) {
                    $('#lead-filter-from-date').val(createdAtFrom);
                }

                if (!_.isUndefined(filtersData.created_at_to)) {
                    $('#lead-filter-to-date').val(createdAtTo);
                }

                if (!_.isUndefined(filtersData.range_activity_option) && filtersData.range_activity_option != '0') {
                    $('#range-activity-option').val(filtersData.range_activity_option);
                    $('.rangeActivityOptions').trigger('change');
                } else {
                    $('#range-activity-option').val(0);

                    if (!_.isUndefined(filtersData.last_activity_from)) {
                        $('#lead-filter-activity-date').val(lastActivityFrom);
                    }

                    if (!_.isUndefined(filtersData.last_activity_to)) {
                        $('#lead-filter-activity-to-date').val(lastActivityTo);
                    }
                }

                if (!_.isUndefined(filtersData.switch_last_next_activity_date) && filtersData.switch_last_next_activity_date === 'last-activity-date') {
                    $('#switch-last-activity-date').attr('checked', true);
                    $('.last-activity-option').removeClass('hidden');
                    $('.next-activity-option').addClass('hidden');
                }

                if (!_.isUndefined(filtersData.switch_last_next_activity_date) && filtersData.switch_last_next_activity_date === 'next-activity-date') {
                    $('#switch-next-activity-date').attr('checked', true);
                    $('.last-activity-option').addClass('hidden');
                    $('.next-activity-option').removeClass('hidden');
                }

                if (!_.isUndefined(filtersData.stage_id) && !_.isEmpty(filtersData.stage_id)) {
                    $('#lead-filter-by-stage').val(filtersData.stage_id).trigger("chosen:updated");
                } else {
                    $('#lead-filter-by-stage').val(0).trigger("chosen:updated");
                }

                $('#lead-filter-by-group').val(filtersData.customer_group_id);
                $('#lead-filter-by-source').val(filtersData.lead_source);
                $('#lead-filter-total-opportunity-amount').val(filtersData.total_opportunity_amount);
                $('#lead-filter-by-owner').val(filtersData.owner_id);
                $('#lead-filter-by-opportunity-owner').val(filtersData.opportunity_owner_id);
                $('#lead-filter-city').val(filtersData.lead_city);
                $('#lead-filter-zip').val(filtersData.lead_zip);
                $('#lead-filter-score-from').val(filtersData.lead_score_from);
                $('#lead-filter-score-to').val(filtersData.lead_score_to);
                $('#lead-filter-opportunity-date').val(opportunityDateFrom);
                $('#lead-filter-opportunity-to-date').val(opportunityDateTo);
                if (!_.isUndefined(filtersData.lead_task) && !_.isEmpty(filtersData.lead_task)) {
                    $('#lead-filter-task').val(filtersData.lead_task);
                } else {
                    $('#lead-filter-task').val(0);
                }

                if (!_.isUndefined(filtersData.lead_source_type) && !_.isEmpty(filtersData.lead_source_type)) {
                    $('#lead-filter-by-source-type').val(filtersData.lead_source_type);
                    var selectedCallType = $('#lead-filter-by-source-type').find(':selected').data('type-name');

                    if(selectedCallType == 'inbound_call' || selectedCallType == 'outbound_call') {
                        $('#call-duration-filter').removeClass('close').addClass('open').show();
                    } else {
                        $('#call-duration-filter').removeClass('open').addClass('close').hide();
                    }

                    if(!_.isUndefined(filtersData.lead_source_type_name) && !_.isEmpty(filtersData.lead_source_type_name) && filtersData.lead_source_type != 0) {
                        $('#call-duration').val(filtersData.call_duration);
                    } else {
                        $('#call-duration').val('');
                    }
                } else {
                    $('#call-duration').val('');
                    $('#call-duration-filter').removeClass('open').addClass('close').hide();
                }

                var filterBysourceTypeEl = $('#lead-filter-by-source-type').closest('div');

                if(filtersData.more_less_call_duration == 'less') {
                    $('#more-less-call-duration').val('less');
                }

                if(filterBysourceTypeEl.hasClass('grid_12') && $('#call-duration-filter').hasClass('open')) {
                    filterBysourceTypeEl.removeClass('grid_12').addClass('grid_5');
                } else if(filterBysourceTypeEl.hasClass('grid_5') && $('#call-duration-filter').hasClass('close')) {
                    filterBysourceTypeEl.removeClass('grid_5').addClass('grid_12');
                }

                if(!_.isUndefined(filtersData.last_interaction_id) && !_.isEmpty(filtersData.last_interaction_id)) {
                    $('#lead-filter-by-last-interaction').val(filtersData.last_interaction_id);
                    if(!_.isUndefined(filtersData.lead_last_interaction_name) && !_.isEmpty(filtersData.lead_last_interaction_name) && filtersData.outbound_emails_sub_type != 0) {
                        $('#outbound-emails-sub-types').val(filtersData.outbound_emails_sub_type);
                        $('#email-sub-type-filter').removeClass('close').addClass('open').show();
                    } else {
                        $('#outbound-emails-sub-types').val(0);
                        $('#email-sub-type-filter').removeClass('open').addClass('close').hide();
                    }
                } else {
                    $('#outbound-emails-sub-types').val(0);
                    $('#email-sub-type-filter').removeClass('open').addClass('close').hide();
                }

                var filterByLastInteractionEl = $('#lead-filter-by-last-interaction').closest('div');

                if(typeof filtersData.outbound_emails_sub_type !== 'undefined' && !_.isEmpty(filtersData.outbound_emails_sub_type)) {
                    $('#outbound-emails-sub-types').val(filtersData.outbound_emails_sub_type);
                }

                if(filterByLastInteractionEl.hasClass('grid_12') && $('#email-sub-type-filter').hasClass('open')) {
                    filterByLastInteractionEl.removeClass('grid_12').addClass('grid_6');
                } else if(filterByLastInteractionEl.hasClass('grid_6') && $('#email-sub-type-filter').hasClass('close')) {
                    filterByLastInteractionEl.removeClass('grid_6').addClass('grid_12');
                }

                $('#lead-filter-total-opportunity-amount-from').val(filtersData.lead_filter_total_opportunity_amount_from);
                $('#lead-filter-total-opportunity-amount-to').val(filtersData.lead_filter_total_opportunity_amount_to);
                if (filtersData.lead_country) {
                    $('#lead-filter-country').val(filtersData.lead_country);
                } else {
                    $('#lead-filter-country').val(0);
                }

                self.setLeadStateOptions();
                if (filtersData.lead_country_state) {
                    $('#lead-filter-country-state').val(filtersData.lead_country_state).trigger("chosen:updated");
                } else {
                    $('#lead-filter-country-state').val(0).trigger("chosen:updated");
                }
                $('#lead-filter-preset-name').val(responseData.filterPresetName);
                $('#lead-preset-id').val(presetId);

                if (!_.isUndefined(filtersData.special_filter_type) && filtersData.special_filter_type === 'existing_client') {
                    $('#lead-filter-by-special-type-existing-client').prop('checked', true);
                } else  if (!_.isUndefined(filtersData.special_filter_type) && filtersData.special_filter_type === 'prospect') {
                    $('#lead-filter-by-special-type-prospect').prop('checked', true);
                } else if(!_.isUndefined(filtersData.special_filter_type) && filtersData.special_filter_type === 'no_email') {
                    $('#lead-filter-by-special-type-no-email').prop('checked', true);
                } else {
                    $('#lead-filter-by-special-type-existing-client').prop('checked', false);
                    $('#lead-filter-by-special-type-prospect').prop('checked', false);
                    $('#lead-filter-by-special-type-no-email').prop('checked', false);
                }

                if (filtersData.last_interaction_id) {
                    $('#lead-filter-by-last-interaction').val(filtersData.last_interaction_id);
                } else {
                    $('#lead-filter-by-last-interaction').val(0);
                }

                if (filtersData.interaction_value) {
                    $('#lead-filter-by-interaction').val(filtersData.interaction_value);
                } else {
                    $('#lead-filter-by-interaction').val('created_at');
                }

                if (filtersData.opportunity_type_id) {
                    $('#lead-filter-by-opportunity-type').val(filtersData.opportunity_type_id);
                } else {
                    $('#lead-filter-by-opportunity-type').val(0);
                }

                if (!_.isUndefined(filtersData.email_sequence_type) && filtersData.email_sequence_type) {
                    $('#lead-filter-by-email-sequence-type').val(filtersData.email_sequence_type);
                } else {
                    $('#lead-filter-by-email-sequence-type').val('all');
                }

                if (!_.isUndefined(filtersData.email_sequence_type_action) && filtersData.email_sequence_type_action) {
                    $('#lead-filter-by-email-sequence-type-action').val(filtersData.email_sequence_type_action);
                } else {
                    $('#lead-filter-by-email-sequence-type-action').val('all');
                }

                if (!_.isUndefined(filtersData.email_sms_sequences_type_period) && filtersData.email_sms_sequences_type_period) {
                    $('#lead-filter-by-email-sequence-type-period').val(filtersData.email_sms_sequences_type_period);
                } else {
                    $('#lead-filter-by-email-sequence-type-period').val('');
                }

                if (typeof filtersData.email_sms_sequences !== 'undefined' && !_.isNull(filtersData.email_sms_sequences) && filtersData.email_sms_sequences.length > 0) {
                    $('#email-sequence-sub-filter-block').removeClass('hidden');
                    $('#email-sequence-sub-filter-block-second-part').removeClass('hidden');
                } else {
                    $('#email-sequence-sub-filter-block').addClass('hidden');
                    $('#email-sequence-sub-filter-block-second-part').addClass('hidden');
                }

                if ($('#lead-filter-by-email-sequence-type').val() === 'sms') {
                    var leadFilterByEmailSequenceTypeAction = $('#lead-filter-by-email-sequence-type-action').val();
                    if (leadFilterByEmailSequenceTypeAction !== 'all' && leadFilterByEmailSequenceTypeAction !== 'sent') {
                        $('#lead-filter-by-email-sequence-type-action').val('sent');
                        $("#lead-filter-by-email-sequence-type-action option[value*='open']").prop('disabled', true);
                        $("#lead-filter-by-email-sequence-type-action option[value*='click']").prop('disabled', true);
                    }
                } else {
                    $("#lead-filter-by-email-sequence-type-action option[value*='open']").prop('disabled', false);
                    $("#lead-filter-by-email-sequence-type-action option[value*='click']").prop('disabled', false);
                }

                if (!_.isUndefined(filtersData.last_updated) && filtersData.last_updated === 'last_updated') {
                    $('#switch-updated-date').prop('checked', true);
                } else {
                    $('#switch-updated-date').prop('checked', false);
                }

                if (!_.isUndefined(filtersData.created_at) && filtersData.created_at === 'created_at') {
                    $('#switch-created-date').prop('checked', true);
                } else {
                    $('#switch-created-date').prop('checked', false);
                }

                if (!_.isUndefined(filtersData.expected_at) && filtersData.expected_at === 'expected_at') {
                    $('#switch-expected-date').prop('checked', true);
                } else {
                    $('#switch-expected-date').prop('checked', false);
                }

                if (!_.isUndefined(filtersData.creation_at) && filtersData.creation_at === 'creation_at') {
                    $('#switch-creation-date').prop('checked', true);
                } else {
                    $('#switch-creation-date').prop('checked', false);
                }

                if (!_.isUndefined(filtersData.state_change_at) && filtersData.state_change_at === 'state_change_at') {
                    $('#switch-stage-change-date').prop('checked', true);
                } else {
                    $('#switch-stage-change-date').prop('checked', false);
                }

                if(filtersData.special_filter_type === 'existing_client') {
                    $('#spent-purchase-block').show();

                    if (!_.isUndefined(filtersData.lead_filter_total_spent_purchase_amount_from)) {
                        $('#lead-filter-total-spent-purchase-amount-from').val(filtersData.lead_filter_total_spent_purchase_amount_from);
                    } else {
                        $('#lead-filter-total-spent-purchase-amount-from').val('');
                    }

                    if (!_.isUndefined(filtersData.lead_filter_total_spent_purchase_amount_to)) {
                        $('#lead-filter-total-spent-purchase-amount-to').val(filtersData.lead_filter_total_spent_purchase_amount_to);
                    } else {
                        $('#lead-filter-total-spent-purchase-amount-to').val('');
                    }
                } else {
                    $('#spent-purchase-block').hide();
                }

                if (!_.isUndefined(filtersData.lead_tags) && !_.isEmpty(filtersData.lead_tags)) {
                    $('#lead-filter-tag').val(filtersData.lead_tags).trigger("chosen:updated");
                } else {
                    $('#lead-filter-tag').val(0).trigger("chosen:updated");
                }

                if (!_.isUndefined(filtersData.email_sms_sequences) && !_.isEmpty(filtersData.email_sms_sequences)) {
                    $('#lead-filter-by-email-sms-sequence').val(filtersData.email_sms_sequences).trigger("chosen:updated");
                } else {
                    $('#lead-filter-by-email-sms-sequence').val(0).trigger("chosen:updated");
                }

                if (!_.isUndefined(filtersData.lead_tags_exclude) && !_.isEmpty(filtersData.lead_tags_exclude)) {
                    $('#lead-filter-tag-exclude').val(filtersData.lead_tags_exclude).trigger("chosen:updated");
                } else {
                    $('#lead-filter-tag-exclude').val(0).trigger("chosen:updated");
                }

                if (!_.isUndefined(filtersData.lead_titles) && !_.isEmpty(filtersData.lead_titles)) {
                    $('#lead-filter-title').val(filtersData.lead_titles);
                } else {
                    $('#lead-filter-title').val('');
                }

                if (!_.isUndefined(filtersData.lead_title_operator) && !_.isEmpty(filtersData.lead_title_operator)) {
                    $('#lead-filter-title-operator').val(filtersData.lead_title_operator);
                } else {
                    $('#lead-filter-title-operator').val('equal');
                }

                if (!_.isUndefined(filtersData.lead_filter_nps_score_operator) && !_.isEmpty(filtersData.lead_filter_nps_score_operator)) {
                    $('#lead-filter-nps-score-operator').val(filtersData.lead_filter_nps_score_operator);
                } else {
                    $('#lead-filter-nps-score-operator').val('equal');
                }

                if (!_.isUndefined(filtersData.lead_filter_nps_score) && !_.isEmpty(filtersData.lead_filter_nps_score)) {
                    $('#lead-filter-nps-score').val(filtersData.lead_filter_nps_score);
                } else {
                    $('#lead-filter-nps-score').val('');
                }

                if (!_.isUndefined(filtersData.lead_opportunity_stages) && !_.isEmpty(filtersData.lead_opportunity_stages)) {
                    $('#lead-filter-opportunity-stage').val(filtersData.lead_opportunity_stages).trigger("chosen:updated");
                } else {
                    $('#lead-filter-opportunity-stage').val(0).trigger("chosen:updated");
                }

                if (!_.isUndefined(filtersData.industry_id) && filtersData.industry_id) {
                    $('#lead-filter-by-industry').val(filtersData.industry_id);
                } else {
                    $('#lead-filter-by-industry').val(0);
                }

                if (!_.isUndefined(filtersData.email_status) && filtersData.email_status) {
                    $('#lead-filter-by-email-status').val(filtersData.email_status);
                } else {
                    $('#lead-filter-by-email-status').val(0);
                }

                if (!_.isUndefined(filtersData.email_validation_status) && filtersData.email_validation_status != '0') {
                    $('#lead-filter-by-email-validation').val(filtersData.email_validation_status);

                    if(filtersData.email_validation_status == 'valid') {
                        $('#lead-filter-by-email-validation-date-block').removeClass('close').addClass('open').removeClass('hidden');

                        if (!_.isUndefined(filtersData.validated_date_to) && filtersData.validated_date_to !== '') {
                            var validatedDateTo = $.datepicker.formatDate('d-M-yy', new Date(filtersData.validated_date_to));
                            $('#lead-filter-by-email-validated-to-date').val(validatedDateTo);
                        }
                    } else {
                        $('#lead-filter-by-email-validated-to-date').val('');
                        $('#lead-filter-by-email-validation-date-block').addClass('hidden');
                    }
                } else {
                    $('#lead-filter-by-email-validation').val(0);
                    $('#lead-filter-by-email-validated-to-date').val('');
                    $('#lead-filter-by-email-validation-date-block').removeClass('open').addClass('close').addClass('hidden');
                }

                var filterByEmailValidationEl = $('#lead-filter-by-email-validation');

                if(filterByEmailValidationEl.hasClass('grid_12') && $('#lead-filter-by-email-validation-date-block').hasClass('open')) {
                    filterByEmailValidationEl.removeClass('grid_12').addClass('grid_5').addClass('field-rule-row-first');
                } else if(filterByEmailValidationEl.hasClass('grid_5') && $('#lead-filter-by-email-validation-date-block').hasClass('close')) {
                    filterByEmailValidationEl.removeClass('grid_5').addClass('grid_12').removeClass('field-rule-row-first');
                }

                if (!_.isUndefined(filtersData.activity_id) && !_.isEmpty(filtersData.activity_id)) {
                    $('#lead-filter-by-activity-type').val(filtersData.activity_id).trigger("chosen:updated");
                } else {
                    $('#lead-filter-by-activity-type').val(0).trigger("chosen:updated");
                }

                $('#custom-attribute-field-row-block').empty();
                $('#custom-organization-attribute-field-row-block').empty();

                if ($('#lead-filter-by-email-sequence-type').val() === 'all') {
                    $('#lead-filter-by-email-sequence-type-action').attr('disabled', 'true');
                    $('#lead-filter-by-email-sequence-type-action').val('all');
                    $('#lead-filter-by-email-sequence-type-period').attr('disabled', 'true');
                } else {
                    $('#lead-filter-by-email-sequence-type-action').removeAttr('disabled');
                    $('#lead-filter-by-email-sequence-type-period').removeAttr('disabled');
                }

                if (!_.isUndefined(filtersData.custom_params_search) && !_.isEmpty(filtersData.custom_params_search)) {
                    var yearsList = self.generateCustomParamsYears();

                    _.each(filtersData.custom_params_search, function(param) {
                        var fieldName = param.name,
                            fieldLabel = param.label,
                            fieldType = param.type,
                            paramId = param.id,
                            fieldValue = param.value,
                            fieldKey = fieldType + '-' + fieldName.replace(/\s/g, ''),
                            blockFields = false,
                            customComparisonOperators = [],
                            specialElType = [],
                            flagMultiSelect = false,
                            placeholder = '',
                            operator = param.operator;

                        if(fieldType == 'date') {
                            placeholder = 'YYYY-MM-DD';
                            fieldValue = JSON.parse(fieldValue);
                        }

                        $('#custom-attribute-field-row-block').append(_.template(LeadCustomParamFieldRowTmpl, {
                            'fieldKey': fieldKey,
                            'fieldName': fieldName,
                            'fieldLabel': fieldLabel,
                            'fieldType': fieldType,
                            'fieldSubtype': '',
                            'moment': moment,
                            'i18n': i18n,
                            'blockFields': blockFields,
                            'customComparisonOperators': customComparisonOperators,
                            'fieldValue': fieldValue,
                            'specialElType': specialElType,
                            'placeholder': placeholder,
                            'paramId':paramId,
                            'operator': operator,
                            'yearsList':yearsList
                        }));
                    });
                }

                if (!_.isUndefined(filtersData.custom_organization_params_search) && !_.isEmpty(filtersData.custom_organization_params_search)) {
                    _.each(filtersData.custom_organization_params_search, function(param) {
                        var fieldName = param.name,
                            fieldLabel = param.label,
                            fieldType = param.type,
                            paramId = param.id,
                            fieldValue = param.value,
                            fieldKey = fieldType + '-' + fieldName.replace(/\s/g, ''),
                            blockFields = false,
                            customComparisonOperators = [],
                            specialElType = [],
                            flagMultiSelect = false,
                            placeholder = '',
                            operator = param.operator;

                        if(fieldType == 'date') {
                            placeholder = 'YYYY-MM-DD';
                            fieldValue = JSON.parse(fieldValue);
                        }

                        $('#custom-organization-attribute-field-row-block').append(_.template(LeadOrganizationCustomParamFieldRowTmpl, {
                            'fieldKey': fieldKey,
                            'fieldName': fieldName,
                            'fieldLabel': fieldLabel,
                            'fieldType': fieldType,
                            'fieldSubtype': '',
                            'moment': moment,
                            'i18n': i18n,
                            'blockFields': blockFields,
                            'customComparisonOperators': customComparisonOperators,
                            'fieldValue': fieldValue,
                            'specialElType': specialElType,
                            'placeholder': placeholder,
                            'paramId':paramId,
                            'operator': operator,
                            'yearsList':yearsList
                        }));
                    });
                }

                $('#source-utm-value-filter').removeClass('open').addClass('close').hide();
                $('#lead-filter-by-source-utm-value').val('0').trigger('chosen:updated');

                $('#campaign-utm-value-filter').removeClass('open').addClass('close').hide();
                $('#lead-filter-by-campaign-utm-value').val('0').trigger('chosen:updated');

                if (!_.isUndefined(filtersData.lead_source_type_and_utm) && !_.isEmpty(filtersData.lead_source_type_and_utm)) {
                    $('#lead-filter-by-source-type-and-utm').val(filtersData.lead_source_type_and_utm).trigger("chosen:updated");
                    if(filtersData.lead_source_type_and_utm.includes('3')) {
                        $('#source-utm-value-filter').removeClass('close').addClass('open').show();

                        if (!_.isUndefined(filtersData.lead_utm_source_value_id) && !_.isEmpty(filtersData.lead_utm_source_value_id)) {
                            $('#lead-filter-by-source-utm-value').val(filtersData.lead_utm_source_value_id).trigger('chosen:updated');
                        }
                    }
                    if(filtersData.lead_source_type_and_utm.includes('5')) {
                        $('#campaign-utm-value-filter').removeClass('close').addClass('open').show();

                        if (!_.isUndefined(filtersData.lead_utm_campaign_value_id) && !_.isEmpty(filtersData.lead_utm_campaign_value_id)) {
                            $('#lead-filter-by-campaign-utm-value').val(filtersData.lead_utm_campaign_value_id).trigger('chosen:updated');
                        }
                    }
                } else {
                    $('#lead-filter-by-source-type-and-utm').val(0).trigger("chosen:updated");
                }

                $('#delete-filter-preset').show();


                $('#lead-filter-apply').trigger('click');
            }).fail(function(response) {
                showMessage(response.responseJSON, true, 5000);
            });
        },
        setLeadStateOptions : function() {
            let countriesWithStates = JSON.parse($('#countries-with-states').val());
            $('#lead-filter-country-state option').remove();
            if (typeof countriesWithStates[$('#lead-filter-country').val()] !== 'undefined') {
                for (const [key, value] of Object.entries(countriesWithStates[$('#lead-filter-country').val()])) {
                    $('#lead-filter-country-state').append($('<option></option>').val(key).text(value));
                }
                $('#lead-filter-country-state').closest('div').show();
            } else {
                $('#lead-filter-country-state').closest('div').hide();
            }
        },
        generateCustomParamsYears()
        {
            var max = parseInt(new Date().getFullYear()) +10;
            var min = max - 99;
            var years = [];

            for (var i = max; i >= min; i--) {
                years.push(i);
            }

            return years;
        },
    });

    return LeadFilterPresetView;
});
