define([
    'backbone',
    'text!../templates/lead-timeline-filter.html',
    './lead-timeline-log',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln'
], function(Backbone, LeadTimelineFilterTmpl, LeadTimelineLogView, i18n
){
    var LeadsTimelineFilterView = Backbone.View.extend({
        el: $('#lead-timeline-filter-block'),
        events: {
            'click .timeline-filter-by-action-type': 'filterTimeline',
            'click .filter-action-log-type-outbound, .filter-action-log-type-inbound': 'filterTimelineType',
            'click .filter-action-log-type-outbound-email-sub' : 'filterEmailSub'
        },
        templates: {
        },
        initialize: function(options){
            this.isQuizzEnabled = options.isQuizzEnabled;
        },
        render: function(){
            this.$el.empty();
            this.$el.append(_.template(LeadTimelineFilterTmpl, {'i18n': i18n, 'isQuizzEnabled': this.isQuizzEnabled}));
        },
        filterTimeline: function(e){
            var el =  $(e.currentTarget);

            if (el.val() === 'outbound') {
                $('#filter-action-log-type-block-outbound').removeClass('hidden');
                $('#filter-action-log-type-block-inbound').addClass('hidden');
            } else if(el.val() === 'inbound') {
                $('#filter-action-log-type-block-outbound').addClass('hidden');
                $('#filter-action-log-type-block-inbound').removeClass('hidden');
            } else {
                $('#filter-action-log-type-block-outbound').addClass('hidden');
                $('#filter-action-log-type-block-inbound').addClass('hidden');
            }

            $('#filter-action-log-type-block-state').val('');
            $('#filter-action-log-subtype-state').val('');
            $('.filter-action-log-type-outbound').prop('checked', false).removeClass('current');
            $('.filter-action-log-type-inbound').prop('checked', false).removeClass('current');
            $('.filter-action-log-type-outbound-email-sub').prop('checked', false).removeClass('current');

            this.applyFilter();
        },
        filterTimelineType: function(e) {
            var el = $(e.currentTarget),
                actionLogType = el.data('filter-log-type'),
                groupType = el.data('group-type'),
                filterLogSubType = el.data('filter-log-sub-type'),
                current = el.hasClass('current');

            $('.filter-action-log-type-outbound').removeClass('current');
            $('.filter-action-log-type-inbound').removeClass('current');
            $('.filter-action-log-type-outbound-email-sub').removeClass('current');
            if (current) {
                el.removeClass('current');
                $('#filter-action-log-type-block-state').val('');
            } else {
                el.addClass('current');
                $('#filter-action-log-type-block-state').val(actionLogType);
            }

            $('#filter-action-log-subtype-state').val('');

            if (!current && actionLogType === 'email') {
                $('#timeline-email-sub-filter').removeClass('hidden');
                if($('.timeline-filter-by-action-type:checked').val() === 'inbound') {
                    $('#filter-action-log-subtype-state').val('received');
                } else {
                    $('#filter-action-log-subtype-state').val('sent');
                }

            } else {
                $('#timeline-email-sub-filter').addClass('hidden');
            }

            if (!current && filterLogSubType) {
                $('#filter-action-log-subtype-state').val(filterLogSubType);
            }

            e.preventDefault();
            this.applyFilter();

        },
        filterEmailSub: function(e)
        {
            var el = $(e.currentTarget),
                actionLogType = el.data('filter-log-type'),
                current = el.hasClass('current'),
                groupType = el.data('group-type');

            $('.filter-action-log-type-outbound').removeClass('current');
            $('.filter-action-log-type-inbound').removeClass('current');
            $('.filter-action-log-type-outbound-email-sub').removeClass('current');
            $('#filter-action-log-type-block-state').val(groupType);

            if (current) {
                el.removeClass('current');
                $('#filter-action-log-subtype-state').val('');
            } else {
                el.addClass('current');
                $('#filter-action-log-subtype-state').val(actionLogType);
            }

            e.preventDefault();
            this.applyFilter();

        },
        applyFilter: function(){
            this.$el.trigger('TimelineLog:created');
            this.$el.trigger('TimelineToday:created');
            this.$el.trigger('TimelineUpcoming:created');
        }
    });

    return LeadsTimelineFilterView;
});