-- 17/09/2015
-- version: 2.2.0
CREATE TABLE IF NOT EXISTS `plugin_cartstatusemail_subscribe`(
  `user_id` INT(10) UNSIGNED NOT NULL,
  `code` CHAR(40) NOT NULL COMMENT 'Hash for unsubscribe link',
  `status` ENUM('subscribed', 'unsubscribed') NOT NULL DEFAULT 'subscribed',
  PRIMARY KEY(`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

ALTER TABLE `plugin_cartstatusemail_queue` MODIFY `status` ENUM('0', '1', '2') NOT NULL DEFAULT '0';

-- 17/09/2015
-- version: 2.3.0
ALTER TABLE `plugin_cartstatusemail_queue` ADD COLUMN `sentAt` DATETIME DEFAULT NULL;

-- 06/10/2015
-- version: 2.3.1
CREATE TABLE IF NOT EXISTS `plugin_cartstatusemail_restored_cart`(
`id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
`cart_id` INT(10) UNSIGNED NOT NULL COMMENT 'Restored cart id',
`sent_at` DATETIME NOT NULL COMMENT 'sent link date',
`restored_at` DATETIME NOT NULL COMMENT 'restored cart date',
`code` CHAR(40) NOT NULL COMMENT 'Hash for restore cart link',
`user_id` INT(10) UNSIGNED NOT NULL COMMENT 'System user id',
`cart_status` VARCHAR(255) NOT NULL COMMENT 'Cart status',
PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 01/16/2017
-- version: 2.3.2
ALTER TABLE `plugin_cartstatusemail_settings` ADD COLUMN `schedulePeriod` SET('sunday', 'monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday') NOT NULL;
ALTER TABLE `plugin_cartstatusemail_settings` ADD COLUMN `schedulePeriodType` ENUM('operation_hours', 'anytime') DEFAULT 'anytime';
ALTER TABLE `plugin_cartstatusemail_settings` ADD COLUMN `lagType` ENUM('hour', 'day', 'month') DEFAULT 'hour';
ALTER TABLE `plugin_cartstatusemail_settings` ADD COLUMN `sequenceOnly` ENUM('0', '1') DEFAULT '0';
ALTER TABLE `plugin_cartstatusemail_settings` ADD COLUMN `triggerName` VARCHAR(255) DEFAULT NULL;
ALTER TABLE `plugin_cartstatusemail_settings` CHANGE `periodHours` `period` INT(10) UNSIGNED;
ALTER TABLE `plugin_cartstatusemail_queue` ADD COLUMN `delayDelivery` ENUM('0', '1') DEFAULT '0';
ALTER TABLE `plugin_cartstatusemail_queue` ADD COLUMN `delayedTo` DATETIME DEFAULT NULL;
UPDATE `plugin_cartstatusemail_settings` SET `schedulePeriod`='sunday,monday,tuesday,wednesday,thursday,friday,saturday';

-- 02/09/2017
-- version: 2.3.3
INSERT INTO `email_triggers` (`enabled`, `trigger_name`, `observer`) VALUES ('1', 'cartstatusemail_nocart', 'Cartstatusemail_Tools_CartstatusemailMailWatchdog');

-- 02/10/2017
-- version: 2.3.4
ALTER TABLE `plugin_cartstatusemail_queue` ADD COLUMN `externalId` INT(10) UNSIGNED DEFAULT NULL;
ALTER TABLE `plugin_cartstatusemail_queue` ADD COLUMN `externalType` VARCHAR (255) DEFAULT NULL COLLATE 'utf8_unicode_ci';
ALTER TABLE `plugin_cartstatusemail_queue` ADD COLUMN `sequence_id` INT(10) UNSIGNED DEFAULT NULL;

-- 11/08/2017
-- version: 2.3.5
ALTER TABLE `plugin_cartstatusemail_settings` ADD COLUMN `subject` VARCHAR (255) DEFAULT NULL COLLATE 'utf8_unicode_ci';
ALTER TABLE `plugin_cartstatusemail_queue` ADD COLUMN `subject` VARCHAR (255) DEFAULT NULL COLLATE 'utf8_unicode_ci';
ALTER TABLE `plugin_cartstatusemail_settings` CHANGE `emailMessage` `emailMessage` text COLLATE 'utf8_unicode_ci' NULL AFTER `productsRule`;
ALTER TABLE `plugin_cartstatusemail_queue`CHANGE `emailMessage` `emailMessage` text COLLATE 'utf8_unicode_ci' NULL AFTER `userFullName`;

-- 18/09/2017
-- version: 2.3.6
INSERT INTO `email_triggers` (`enabled`, `trigger_name`, `observer`) VALUES ('1', 'cartstatusemail_unsubscribereport', 'Cartstatusemail_Tools_CartstatusemailMailWatchdog');
ALTER TABLE `plugin_cartstatusemail_subscribe` ADD COLUMN `unsubscribed_at` TIMESTAMP NULL;

UPDATE `plugin` SET `version`='2.3.7' WHERE `name`='cartstatusemail';
SELECT version FROM `plugin` WHERE `name` = 'cartstatusemail';

