<?php


class Cartstatusemail_Models_Mapper_CartstatusemailSettingsMapper extends Application_Model_Mappers_Abstract {

    protected $_dbTable = 'Cartstatusemail_Models_Dbtables_CartstatusemailSettingsDbtable';

    protected $_model   = 'Cartstatusemail_Models_Models_CartstatusemailSettingsModel';

    public function save($model) {
        if(!$model instanceof $this->_model) {
            throw new Exceptions_SeotoasterException('Given parameter should be ' . $this->_model . ' instance');
        }
        $data = array(
            'cartStatus'         => $model->getCartStatus(),
            'period'             => $model->getPeriod(),
            'productsIds'        => $model->getProductsIds(),
            'emailTemplate'      => $model->getEmailTemplate(),
            'emailFrom'          => $model->getEmailFrom(),
            'emailMessage'       => $model->getEmailMessage(),
            'productsRule'       => $model->getProductsRule(),
            'schedulePeriod'     => $model->getSchedulePeriod(),
            'schedulePeriodType' => $model->getSchedulePeriodType(),
            'lagType'            => $model->getLagType(),
            'sequenceOnly'       => $model->getSequenceOnly(),
            'triggerName'        => $model->getTriggerName(),
            'subject'            => $model->getSubject()
         );

        $id = $model->getId();
        if (!empty($id)) {
            $where = $this->getDbTable()->getAdapter()->quoteInto('id = ?', $id);
            $this->getDbTable()->update($data, $where);
        } else {
            $id = $this->getDbTable()->insert($data);
            $model->setId($id);
        }

        return $model;

    }

    /**
     * Delete by settings id
     *
     * @param int $id settings id
     * @return mixed
     * @throws Exception
     */
    public function deleteCartStatus($id) {
        $where = $this->getDbTable()->getAdapter()->quoteInto("id=?", $id);
        return $this->getDbTable()->delete($where);
    }

    /**
     * @deprecated system version 2.6.0
     *
     * @param Cartstatusemail_Models_Models_CartstatusemailSettingsModel $model cart status model
     * @param int $id cart status settings id
     * @return mixed
     * @throws Exception
     */
    public function updateCartStatus($model, $id) {
        $data = array(
            'cartStatus'    => $model->getCartStatus(),
            'period'        => $model->getPeriod(),
            'productsIds'   => $model->getProductsIds(),
            'emailTemplate' => $model->getEmailTemplate(),
            'emailFrom'     => $model->getEmailFrom(),
            'emailMessage'  => $model->getEmailMessage(),
            'productsRule'  => $model->getProductsRule()
        );
        $where = $this->getDbTable()->getAdapter()->quoteInto('id = ?', $id);
        return $this->getDbTable()->update($data, $where);
    }

    /**
     * Select all by id
     *
     * @param int $id settings id
     * @return array|null
     * @throws Exception
     */
    public function selectCartStatusById($id) {
        $where = $this->getDbTable()->getAdapter()->quoteInto("id=?", $id);
        return $this->fetchAll($where);
    }

    /**
     * Select config statuses
     *
     * @param string $cartStatus shopping cart status
     * @param string $periodHours
     * @param array $productsIds product ids
     * @param string $productsRule rule
     * @return array|null
     * @throws Exception
     */
    public function selectCartStatus($cartStatus, $period, $productsIds, $productsRule) {
        $where =  $this->getDbTable()->getAdapter()->quoteInto('cartStatus=?', $cartStatus);
        $where .= ' AND '. $this->getDbTable()->getAdapter()->quoteInto('period=?', $period);
        $where .= ' AND '. $this->getDbTable()->getAdapter()->quoteInto('productsIds=?', $productsIds);
        $where .= ' AND '. $this->getDbTable()->getAdapter()->quoteInto('productsRule=?', $productsRule);
        return $this->fetchAll($where);
    }


}

