<?php

class Widgets_Crm_Crm extends Widgets_Abstract
{

    /**
     * Website helper
     *
     * @var null
     */
    protected $_websiteHelper = null;

    /**
     * @var bool
     */
    protected $_cacheable = false;

    /**
     * Session helper
     *
     * @var bool
     */
    protected $_sessionHelper = false;

    /**
     * @var null
     */
    protected $_layout = null;

    protected function _init()
    {
        parent::_init();
        $this->_view = new Zend_View(array(
            'scriptPath' => __DIR__ . '/views/'
        ));


        $this->_layout = new Zend_Layout();
        $this->_layout->setLayoutPath(Zend_Layout::getMvcInstance()->getLayoutPath());

        $this->_websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');
        $this->_view->websiteUrl = $this->_websiteHelper->getUrl();
        $this->_websiteUrl = $this->_websiteHelper->getUrl();
        $this->_translator = Zend_Registry::get('Zend_Translate');

        $this->_view->setHelperPath(APPLICATION_PATH . '/views/helpers/');
        $this->_view->addHelperPath('ZendX/JQuery/View/Helper/', 'ZendX_JQuery_View_Helper');
        $this->_view->addScriptPath($this->_websiteHelper->getPath() . 'seotoaster_core/application/views/scripts/');
        // init helpers
        $this->_configHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('config');
        $this->_sessionHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('session');
    }

    protected function _load()
    {
        if (empty($this->_options[0])) {
            return $this->_translator->translate('Option not specified');
        }
        $methodName = '_render' . ucfirst($this->_options[0]);
        if (method_exists($this, $methodName)) {
            return $this->$methodName();

        }

        return $this->_translator->translate('Method doesn\'t exists');
    }

}
