import merge from 'lodash/merge';
import moment from 'moment';
import orderBy from 'lodash/orderBy';

let defaultState = {
    configDataInfo: [],
    additionalInfo: [],
    oppGoalStats: [],
    globalStats: []
};

let state = {};
merge(state, defaultState);

const actions = {

};

const mutations = {
    setConfigDataInfo : (state, payload) => {
        state.configDataInfo = payload;
    },
    setAdditionalInfo : (state, payload) => {
        state.additionalInfo = payload;
    },
    setOppGoalStats : (state, payload) => {
        state.oppGoalStats  = payload;
    },
    setGlobalStats : (state, payload) => {
        state.globalStats  = payload;
    },
};

const getters = {
    getConfigDataInfo : (state) => {
        return state.configDataInfo
    },
    getAdditionalInfo : (state) => {
        return state.additionalInfo
    },
    getOppGoalStats : (state) => {
        return state.oppGoalStats
    },
    getGlobalStats : (state) => {
        return state.globalStats
    },
    formatDate : (state) => {
        return (date) => {
            return moment(date).format('DD MMM YYYY hh:mm a');
        }
    },
    sortByColumn : (state) => {
        return (data, columnName, reverse) => {
            if (typeof reverse !== 'undefined') {
                return orderBy(data, columnName).reverse();
            }

            return orderBy(data, columnName);
        }
    }
};
export default {
    state,
    actions,
    getters,
    mutations
};
