import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import * as d3 from "d3";
export default {
    data () {
        return {
            loadedScreen: false,
            websiteUrl: $('#website_url').val(),
            queryType: 'amount',
            oppType: '0',
            graphDataExists: false,
            graphDataNotExists: false,
            graphType: 'opportunityPieAmount',
            graphAmountName:'opportunityPieAmount',
            graphCountName:'opportunityPieCount',
            displayRank: 0
        }
    },
    components: {

    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
            sortByColumn: 'sortByColumn',
            truncateText: 'truncateText',
            selectedUserId: 'getSelectedUserId',
            additionalInfo:'getAdditionalInfo',
            filterDateFrom: 'getFilterDateFrom',
            filterDateTo: 'getFilterDateTo',
            changedDate: 'getChangedDate',
            formatDateForGraphs:'formatDateForGraphs',
            opportunityGoalData: 'getOpportunityGoalData',
            toCurrency: 'toCurrency',
            opportunityGoalAdditionalInfo:'getOpportunityGoalAdditionalInfo',
            opportunityGoalGraphData:'getOpportunityGoalGraphData',
            filterPeriodMonths:'getFilterPeriodMonths'
        })
    },
    watch: {
        selectedUserId (newUserId, oldUseId) {
            console.log(`Old user id ${oldUseId} - new user id ${newUserId}`);
            if (newUserId !== oldUseId) {
                this.applyFilter();
            }
        },
        changedDate () {
            this.applyFilter();
        }
    },
    methods: {
        async applyFilter() {
            const result = await this.$store.dispatch('getOpportunityGoalData', {'router':this.$router, 'userId':this.selectedUserId, 'filterDateFrom':this.filterDateFrom, 'filterDateTo':this.filterDateTo, 'queryType':this.queryType, 'oppType':this.oppType, 'filterPeriodMonths':this.filterPeriodMonths});

            this.$store.dispatch('destroyGraph', {
                'elId': '#lead-report-opportunity-goal-graph'
            });

            this.$store.dispatch('deleteCustomLegend', {
                    'legend':'#lead-report-opportunity-goal-graph-legend',
                }
            );

            if(result.status === 'error') {
                showMessage('Please re-login', true, 3000);
            } else {
                this.loadedScreen = true;

                let graphType = this.graphAmountName;
                if (this.queryType === 'count') {
                    graphType = this.graphCountName;
                }

                this.displayRank = this.opportunityGoalAdditionalInfo.displayRank;

                let opportunitySalesGraphData = this.opportunityGoalGraphData,
                    chartData = [],
                    labelsData = {},
                    label = this.$t('message.oppAmount'),
                    graphTitle = this.$t('message.oppStatus'),
                    self = this,
                    queryType = this.queryType;

                if (typeof opportunitySalesGraphData !== 'undefined' && typeof opportunitySalesGraphData[graphType] !== 'undefined' && typeof opportunitySalesGraphData[graphType].data !== 'undefined') {
                    _.each(opportunitySalesGraphData[graphType].data, function(opportunityData, opportunity){
                        if (queryType === 'amount') {
                            chartData.push([opportunityData.stageName + ' ' + self.toCurrency(opportunityData.amount, 0) + ' ' + '(' + opportunityData.percentage + '%)', opportunityData.amount]);
                        } else {
                            chartData.push([opportunityData.stageName + ' ' + opportunityData.count + ' ' + '(' + opportunityData.percentage + '%)', opportunityData.count]);
                        }

                        if (opportunity === '100') {
                            labelsData.Won = 'Won with '+ opportunityData.count +' deals';
                        }

                        if (opportunity === '99') {
                            labelsData.Open = 'Open with '+ opportunityData.count +' deals';
                        }

                        if (opportunity === '1') {
                            labelsData.Lost = 'Lost with '+ opportunityData.count +' deals';
                        }

                    });

                    console.log(labelsData);
                    console.log(chartData);

                    this.graphDataExists = true;
                    this.graphDataNotExists = false;

                    let leadOwnerId = this.selectedUserId;
                    if (this.selectedUserId == '-2') {
                        leadOwnerId = this.additionalInfo.loggedUserId;
                    }

                    if (this.selectedUserId == '-1') {
                        leadOwnerId = 0;
                    }

                    if (this.selectedUserId == '') {
                        leadOwnerId = this.additionalInfo.loggedUserId;
                    }

                    this.$store.dispatch('drawDonutGraph', {
                        'elId': '#lead-report-opportunity-goal-graph',
                        'chartData': chartData,
                        'percentWidth': 15,
                        'customParamsData': {
                            'axesAdditionalInfo': opportunitySalesGraphData[graphType].axesAdditionalInfo,
                            'colorPattern':opportunitySalesGraphData[graphType].colorPattern,
                            //'title':opportunityStagePerSourceGraphData[graphType].title,
                            'title':'',
                            'amountComparison': {
                                'labelsData': labelsData,
                                'sign': ''
                            },
                            'subType':queryType,
                            'showLegend':true,
                            'filterStartDate':this.formatDateForGraphs(opportunitySalesGraphData[graphType].filterStartDate),
                            'filterEndDate':this.formatDateForGraphs(opportunitySalesGraphData[graphType].filterEndDate),
                            'rangeOptions':'custom',
                            'predefinedParams':'total_opportunity_amount_from=1',
                            'defaultFilterFromDateNameField':'change_stage_date_from',
                            'defaultFilterToDateNameField':'change_stage_date_to',
                            'additionalFilter':'',
                            'filterFromDateNameAlternative':'',
                            'filterToDateNameAlternative':'',
                            'filterType':'lead_opportunity_stages',
                            'opportunityTypes':this.oppType,
                            'leadOwnerId':leadOwnerId
                        },
                        'router': this.$router
                    });

                } else {
                    this.graphDataNotExists = true;
                }
            }
        },
        filterByType(queryType) {
            this.queryType = queryType;
            this.applyFilter();
        }
    },
    async created(){

    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    },
    async mounted()  {
        this.loadedScreen = true;
        this.graphDataExists = true;
        this.applyFilter();
    }
}
