import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
export default {
    data () {
        return {
            loadedScreen: false,
            websiteUrl: $('#website_url').val(),
            graphDataExists: false,
            graphDataNotExists: false,
            graphType: 'quoteAttainmentAmount',
            displayRank: 0
        }
    },
    components: {

    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
            sortByColumn: 'sortByColumn',
            truncateText: 'truncateText',
            selectedUserId: 'getSelectedUserId',
            filterDateFrom: 'getFilterDateFrom',
            filterDateTo: 'getFilterDateTo',
            filterPeriodMonths:'getFilterPeriodMonths',
            toCurrency: 'toCurrency',
            changedDate: 'getChangedDate',
            salesGoalData: 'getSalesGoalData',
            formatDateForGraphs:'formatDateForGraphs',
            salesAdditionalInfo: 'getSalesAdditionalInfo',
            salesGoalGraphData:'getSalesGoalGraphData'
        })
    },
    watch: {
        selectedUserId (newUserId, oldUseId) {
            console.log(`Old user id ${oldUseId} - new user id ${newUserId}`);
            if (newUserId !== oldUseId) {
                this.applyFilter();
            }
        },
        changedDate () {
            this.applyFilter();
        }
    },
    methods: {
        async applyFilter() {

            this.graphDataExists = true;
            this.graphDataNotExists = false;

            const result = await this.$store.dispatch('getSalesGoalData', {'router':this.$router, 'userId':this.selectedUserId, 'filterDateFrom':this.filterDateFrom, 'filterDateTo':this.filterDateTo, 'filterPeriodMonths':this.filterPeriodMonths});
            if(result.status === 'error') {
                showMessage('Please re-login', true, 3000);
            } else {
                this.loadedScreen = true;

                this.$store.dispatch('destroyGraph', {
                    'elId': '#lead-sales-goal-graph'
                });

                this.$store.dispatch('deleteCustomLegend', {
                        'legend':'#lead-sales-goal-graph-legend',
                    }
                );

                this.displayRank = this.salesAdditionalInfo.displayRank;

                let salesGoalGraphData = this.salesGoalGraphData,
                    chartData = [],
                    labelsData = {},
                    self = this,
                    graphType = this.graphType,
                    label = this.$t('message.opportunitySold'),
                    quoteGoalLabel = this.$t('message.quoteGoalLabel');

                if (typeof salesGoalGraphData !== 'undefined' && typeof salesGoalGraphData[graphType] !== 'undefined' && typeof salesGoalGraphData[graphType].data !== 'undefined') {

                    _.each(salesGoalGraphData[graphType].data, function(opportunityData, opportunity) {
                        if (opportunity == '100') {
                            chartData.push([opportunityData.percentage + '% '+quoteGoalLabel, opportunityData.amount]);
                        } else {
                            chartData.push([opportunityData.percentage + '%', opportunityData.amount]);
                        }
                    });


                        this.$store.dispatch('drawDonutGraph', {
                            'elId': '#lead-sales-goal-graph',
                            'chartData': chartData,
                            'percentWidth': 20,
                            'customParamsData': {
                                'axesAdditionalInfo': salesGoalGraphData[graphType].axesAdditionalInfo,
                                'colorPattern':salesGoalGraphData[graphType].colorPattern,
                                //'title':opportunityStagePerSourceGraphData[graphType].title,
                                'title':'',
                                'amountComparison': {
                                    'labelsData': labelsData,
                                    'sign': ''
                                },
                                'showLegend':true,
                                'filterStartDate':this.formatDateForGraphs(salesGoalGraphData[graphType].filterStartDate),
                                'filterEndDate':this.formatDateForGraphs(salesGoalGraphData[graphType].filterEndDate),
                                'rangeOptions':'custom',
                                'predefinedParams':'total_opportunity_amount_from=1',
                                'defaultFilterFromDateNameField':'change_stage_date_from',
                                'defaultFilterToDateNameField':'change_stage_date_to',
                                'additionalFilter':'',
                                'filterFromDateNameAlternative':'',
                                'filterToDateNameAlternative':'',
                                'filterType':'lead_opportunity_stages',
                                'opportunityTypes':this.oppType,
                                'disableRedirect':true
                            },
                            'router': this.$router
                        });

                } else {
                    this.graphDataNotExists = true;
                    this.graphDataExists = false;
                }

            }
        }
    },
    async created(){

    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    },
    async mounted()  {
        this.loadedScreen = true;
        this.graphDataExists = true;
        this.applyFilter();
    }
}
