define([
    'backbone',
    'i18n!../../../nls/config_'+$('#lead-opportunity-type-leads-config-system-language').val()+'_ln.js'
], function(Backbone, i18n){
    var LeadOpportunityTypeFormView = Backbone.View.extend({
        el: $('#lead-opportunity-type-form'),
        events: {
            'submit': 'submit',
            'keyup .type_name': 'updateOpportunityTypeLabel'
        },
        templates: {

        },
        initialize: function(){
            this.$el = $('#lead-opportunity-type-form');
            this.$el.attr('action', $('#website_url').val()+'api/leads/leadopportunitytype');
        },
        render: function(){
            return this;
        },
        updateOpportunityTypeLabel: function(e) {
            var currentName = $(e.currentTarget).val();
            $(e.currentTarget).closest('form').find('.type_label').val(currentName);
        },
        submit: function(e){
            e.preventDefault();

            var self = this,
                form = $(e.currentTarget),
                isValid = true;

            _.each(form.find('.required'), function(el){
                if (!$(el).val()){
                    isValid = false;
                }
            });

            if (!isValid){
                showMessage(_.isUndefined(i18n['Missing required field'])?'Missing required field':i18n['Missing required field'], true);
                return false;
            }

            var formParams = form.serialize();

            $.ajax({
                url: form.attr('action'),
                type:  'POST',
                data: formParams,
                dataType: 'json'
            }).done(function(response) {
                 self.$el.trigger('OpportunityTypeForm:created');
                 showMessage(response.responseText.message, false, 5000);
                 form.find('input[type="text"]').val('');
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
            return false;

        }
    });

    return LeadOpportunityTypeFormView;
});