define([
    'backbone',
    '../models/lead-social-service.js',
    'backbone.paginator'
], function(Backbone, LeadSocialServiceModel){

    var LeadSocialServicesCollection = Backbone.Paginator.requestPager.extend({
        model: LeadSocialServiceModel,
        paginator_core: {
            type: 'GET',
            dataType: 'json',
            url: function(){
                return $('#website_url').val() + 'api/leads/leadsocialservices/';
            }
        },
        paginator_ui: {
            firstPage:    0,
            currentPage:  0,
            perPage:     4,
            totalPages:  4
        },
        server_api: {
            count: true,
            limit: function() { return this.perPage; },
            offset: function() { return this.currentPage * this.perPage },
            key: function(){ return this.key; }
        },
        parse: function(response, xhr){
            if (this.server_api.count){
                this.totalRecords = response.totalRecords;
            } else {
                this.totalRecords = response.length;
            }
            this.totalPages = Math.floor(this.totalRecords / this.perPage);
            return this.server_api.count ? response.data : response;
        }

    });

    return LeadSocialServicesCollection;
});