define([
    'backbone',
    'c3',
    './lead-reports',
    './lead-general-reports',
    './lead-reports-filter'
], function(Backbone, c3, LeadReportsView, LeadGeneralReportsView, LeadReportsFilterView){
    var LeadsReportsRouter = Backbone.Router.extend({

        routes: {
            ''         : 'index'
        },
        index: function (){
            this.LeadReportsView = new LeadReportsView();
            this.LeadReportsView.render();

            this.LeadGeneralReportsView = new LeadGeneralReportsView();
            this.LeadGeneralReportsView.render();

            this.LeadReportsFilterView = new LeadReportsFilterView();
            this.LeadReportsFilterView.render();
            this.LeadReportsFilterView.$el.on('LeadReportsFilter:updated', _.bind(this.LeadReportsView.render, this.LeadReportsView));
            this.LeadReportsFilterView.$el.on('LeadGeneralReportsFilter:updated', _.bind(this.LeadGeneralReportsView.render, this.LeadGeneralReportsView));
        }
    });

    var initialize = function() {
        window.appLeadRepostsRouter = new LeadsReportsRouter;
        Backbone.history.start();
    };

    return {
        initialize: initialize
    };
});