define([
    'backbone',
    '../models/lead-opportunity-timeline',
    'backbone.paginator'
], function(Backbone, LeadOpportunityModel){

    var LeadOpportunityTimelineCollection = Backbone.Paginator.requestPager.extend({
        model: LeadOpportunityModel,
        paginator_core: {
            type: 'GET',
            dataType: 'json',
            url: function(){
                return $('#website_url').val() + 'api/leads/opportunitytimeline/';
            }
        },
        paginator_ui: {
            firstPage:    0,
            currentPage:  0,
            perPage:     10,
            totalPages: 10
        },
        server_api: {
            count: true,
            limit: function() { return this.perPage; },
            offset: function() { return this.currentPage * this.perPage },
            key: function(){ return this.key; },
            lead_id:function(){return this.lead_id},
            order: function(){ return this.order;}
        },
        parse: function(response, xhr){
            if (this.server_api.count){
                this.totalRecords = response.totalRecords;
            } else {
                this.totalRecords = response.length;
            }
            this.moneyFormat = response.moneyFormat;
            this.usersList = response.users;
            this.currentUserId = response.currentUserId;
            this.currencySymbol = response.currencySymbol;
            this.opportunityStages = response.opportunityStages;
            this.quoteTemplates = response.quoteTemplates;
            this.leadsData = response.leadsData;
            this.quotesWithoutLeads = response.quotesWithoutLeads;
            this.quoteOwners = response.quoteOwners;
            this.totalPages = Math.floor(this.totalRecords / this.perPage);
            return this.server_api.count ? response.data : response;
        }

    });

    return LeadOpportunityTimelineCollection;
});
