tinymce.PluginManager.add('reviewrequestlinks', function(ed, url) {
    function getReviewValues() {
        var reviewsList = [];
        $.ajax({
            type: 'post',
            url: window.location.protocol+'//'+window.location.host + '/plugin/leads/run/getReviewRequestLinks/',
            dataType: 'json'
        }).done(function(response) {
            if(!response.error) {
                for(var i in response.responseText) {
                    for(var j in response.responseText[i]) {
                        var newReviewCode = {};
                        if(typeof response.responseText[i][j].alias !== 'undefined') {
                            newReviewCode['text'] = response.responseText[i][j].alias;
                            newReviewCode['value'] = response.responseText[i][j].option + ' ';
                            newReviewCode['icon'] = true;
                            newReviewCode['image'] = response.responseText[i][j].iconLink;
                        }
                        else {
                            newReviewCode['text'] = response.responseText[i][j];
                            newReviewCode['value'] = response.responseText[i][j].option + ' ';
                            newReviewCode['icon'] = true;
                            newReviewCode['image'] = response.responseText[i][j].iconLink;
                        }
                        reviewsList.push(newReviewCode)
                    }
                }
            }
            //remove existing menu if it is already rendered
            if(reviewrequestlinksbutton.menu){
                reviewrequestlinksbutton.menu.remove();
                reviewrequestlinksbutton.menu = null;
            }

            if(!reviewsList.length) {
                reviewrequestlinksbutton._disabled = true;
            }
            reviewrequestlinksbutton.settings.values = reviewrequestlinksbutton.settings.menu = reviewsList;
            return reviewsList;
        });

    }

    // Add a button that opens a window
    ed.addButton('reviewrequestlinks', {
        type: 'listbox',
        text: 'Review request links',
        icon : false,
        values: getReviewValues(),
        onselect: function() {
            //insert key
            ed.insertContent(this.value());

            //reset selected value
            this.value(null);
        },
        onPostRender: function() {
            reviewrequestlinksbutton = this;
        }
    });
});
