define([
    'backbone',
    '../collections/lead-email-sequence',
    'text!../templates/email-sequence-tab/email-sequence-list.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'moment'
], function(Backbone, LeadEmailSequenceCollection, LeadEmailSequenceListTmpl,
         i18n, moment
){

    var LeadEmailSequenceSubscribeView = Backbone.View.extend({
        el: $('#lead-email-sequence-list'),
        events: {
            'click .lead-sequence-delete-row': 'deleteSequence',
            'submit #add-email-sequence-to-lead-form': 'assignEmailSequenceToLead',
            'change #lead-subscribed-sequence' : 'unsubscribeLead'
        },
        templates: {
        },
        initialize: function(leadId, currentPage){
            this.emailSequenceSubscribe = new LeadEmailSequenceCollection();
            this.emailSequenceSubscribe.leadId = leadId;
            if (!_.isUndefined(currentPage)) {
                this.emailSequenceSubscribe.currentPage = currentPage;
            }
            this.emailSequenceSubscribe.on('reset', this.renderEmailSequence, this);
            this.emailSequenceSubscribe.on('add', this.renderEmailSequence, this);
            this.emailSequenceSubscribe.on('destroy', this.renderEmailSequence, this);

        },
        render: function(param){
            this.emailSequenceSubscribe.pager();
        },
        assignEmailSequenceToLead: function(e)
        {
            e.preventDefault();

            var form = $(e.currentTarget),
                isValid = true,
                self = this;

            _.each(form.find('.required'), function(el){
                if (!$(el).val()){
                    isValid = false;
                }
            });

            $.ajax({
                'url': $('#website_url').val()+'api/leads/leademailsequence/',
                'data': form.serialize(),
                'dataType':'json',
                'type':'POST'
            }).done(function(response){
                showMessage(response.responseText, false, 5000);
                self.emailSequenceSubscribe.fetch();
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });

        },
        renderEmailSequence: function(){
            this.$el.empty();
            this.$el.append(_.template(LeadEmailSequenceListTmpl, {
                'sequenceModel': this.emailSequenceSubscribe.toJSON(),
                'leadId' :  this.emailSequenceSubscribe.leadId,
                'sequenceList' : this.emailSequenceSubscribe.sequenceList,
                'subscribeInfo' : this.emailSequenceSubscribe.subscribeInfo,
                'subscribeSmsInfo' : this.emailSequenceSubscribe.subscribeSmsInfo,
                'i18n' : i18n
            }));
        },
        unsubscribeLead: function(e) {
            var el = $(e.currentTarget),
                sequenceId = el.data('sequence-id'),
                leadId = $('#lead-detailed-view-statistics-tabs').data('lead-id'),
                self = this;

            if(el.prop('checked')) {
                showConfirm(_.isUndefined(i18n['Are you sure want to unsubscribe'])?'Are you sure want to unsubscribe':i18n['Are you sure want to unsubscribe'], function(){
                    $.ajax({
                        'url': $('#website_url').val()+'api/leads/leademailsequence/lead_id/'+leadId+'/sequence_id/'+sequenceId+'/unsubscribeFlag/unsubscribeFlag',
                        'type':'DELETE',
                        'dataType':'json'
                    }).done(function(responseData){
                        showMessage(responseData.responseText, false, 5000);
                        self.emailSequenceSubscribe.fetch();
                    });
                }, function () {
                    self.emailSequenceSubscribe.fetch();
                });
            } else {
                showConfirm(_.isUndefined(i18n['Are you sure want to subscribe'])?'Are you sure want to subscribe':i18n['Are you sure want to subscribe'], function(){
                    $.ajax({
                        'url': $('#website_url').val()+'plugin/leads/run/subscribe/',
                        'type':'POST',
                        'dataType':'json',
                        'data': {'leadId':leadId, 'secureToken': $('#lead-grid-token').val()}
                    }).done(function(responseData){
                        showMessage(responseData.responseText, false, 5000);
                        self.emailSequenceSubscribe.fetch();
                    });
                }, function () {
                    self.emailSequenceSubscribe.fetch();
                });
            }
        },
        deleteSequence: function(e)
        {
            e.preventDefault();
            var el = $(e.currentTarget),
                sequenceId = el.data('sequence-id'),
                leadId = el.closest('ul').data('lead-id'),
                self = this;

            showConfirm(_.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'], function(){
                $.ajax({
                    'url': $('#website_url').val()+'api/leads/leademailsequence/lead_id/'+leadId+'/sequence_id/'+sequenceId,
                    'type':'DELETE',
                    'dataType':'json'
                }).done(function(responseData){
                   self.emailSequenceSubscribe.fetch();
                });
            });
        }
    });

    return LeadEmailSequenceSubscribeView;
});
