define([
    'backbone',
    '../collections/lead-recently-viewed',
    'text!../templates/recently-viewed-leads-organizations.html',
    'moment',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln'
], function(Backbone,
            LeadRecentlyViewedCollection, LeadRecentlyViewedTmpl, moment, i18n
){

    var LeadsRecentlyViewedView = Backbone.View.extend({
        el: $('#lead-organizations-recently-viewed-block'),
        events: {

        },
        templates: {

        },
        initialize: function(options){
            this.recentlyViewed = new LeadRecentlyViewedCollection();

            this.recentlyViewed.on('reset', this.renderRecentlyViewed, this);
            this.recentlyViewed.on('add', this.renderRecentlyViewed, this);
            this.recentlyViewed.on('destroy', this.renderRecentlyViewed, this);
        },
        render: function(){
            this.recentlyViewed.pager();
        },
        renderRecentlyViewed: function(){
            this.$el.empty();
            this.$el.html(_.template(LeadRecentlyViewedTmpl, {'recentlyViewed': this.recentlyViewed.toJSON(), 'moment': moment, 'i18n': i18n}));
        }
    });

    return LeadsRecentlyViewedView;
});