define([
    'backbone',
    'text!../templates/lead-sms-detailed-tab.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'tinyMCE',
    'leadshortcode',
    'leadtestsms',
    'placeholder',
    'charlimit',
    'reviewrequestlinks',
    'plupload',
    'pluploadhtml5',
    'pluploadflash',
    'pluploadhtml4'
], function(Backbone, LeadSmsTmpl, i18n, tinymce, leadshortcode, leadtestsms, placeholder, charlimit, reviewrequestlinks, plupload, pluploadhtml5, pluploadflash, pluploadhtml4){
    var LeadSmsFormView = Backbone.View.extend({
        el: $('#lead-detailed-view-config-tab-sms'),
        events: {
            'submit form': 'submit',
            'change #call-device-type': 'selectCallDevice',
            'change #switch-send-mms': 'switchSendMms',
            'click .delete-uploaded-mms-file': 'deleteUploadedMmsFile',
        },
        templates: {

        },
        initialize: function(leadModel, smsTabDataModel){
            this.leadModel = leadModel;
            this.leadSmsTabData = smsTabDataModel;
        },
        render: function(){
            if(typeof this.mmsPicturesUploader !== 'undefined') {
                this.mmsPicturesUploader = undefined;
            }
            tinymce.remove();
            this.$el.empty();
            var websiteUrl = $('#website_url').val(),
                self = this;

            this.$el.append(_.template(LeadSmsTmpl, {'leadModel': this.leadModel, 'smsTabDataModel':  this.leadSmsTabData, 'i18n': i18n}));
            this.$el.find('form').attr('action', websiteUrl+'api/leads/leadsms/');

            tinymce.init({
                script_url              : websiteUrl+'system/js/external/tinymce/tinymce.gzip.php',
                selector                : "#lead-sms-tab-textarea",
                skin                    : 'seotoaster',
                menubar                 : false,
                browser_spellcheck      : true,
                resize                  : false,
                convert_urls            : false,
                relative_urls           : false,
                statusbar               : false,
                allow_script_urls       : false,
                force_p_newlines        : false,
                forced_root_block       : false,
                entity_encoding         : "raw",
                plugins                 :  ["fullscreen leadshortcode placeholder charlimit leadtestsms reviewrequestlinks"],
                toolbar1                : "leadshortcode | fullscreen | spellcheckbtn | leadtestsms | reviewrequestlinks",
                image_advtab            : false,
                extended_valid_elements : false,
                setup                   : function(ed){
                    var keyTime = null;
                    ed.on('change blur keyup', function(ed, e){
                        //@see content.js for this function
                        self.dispatchEditorKeyup(ed, e, keyTime);
                        this.save();
                    });

                    ed.addButton('spellcheckbtn', {
                        icon: true,
                        image: websiteUrl+'plugins/leads/web/images/spellcheck.ico',
                        tooltip: _.isUndefined(i18n['How do I enable spell-check in SeoToaster?'])?'How do I enable spell-check in SeoToaster?':i18n['How do I enable spell-check in SeoToaster?'],
                        onclick: function() {
                            window.open('https://www.seotoaster.com/questions-and-answers/crm-faq#lead-spellchecker', '_blank');
                        }
                    })
                }
            });

            $('#lead-sms-tab-textarea').html('<span></span>').trigger('keyup');
            this.tinimce = tinymce;
            $("#lead-sms-follow-up-sequences").chosen({
                'disable_search': true
            }).on('chosen:showing_dropdown', function (e) {
                let setElements = $(e.currentTarget.nextSibling).find('li.disabled-result');
                if (setElements.length) {
                    setElements.addClass('tooltip').attr('title', _.isUndefined(i18n['Set in Workflows']) ? 'Set in Workflows' : i18n['Set in Workflows']);
                }
            });

            var mobileMasks = this.leadModel.get('mobileMasks'),
                mobileCountryCode = this.leadModel.get('lead_mobile_country_code'),
                currentMobileCountryCode = this.attributes.currentMobileCountryCode,
                currentDesktopCountryCode = this.attributes.currentDesktopCountryCode;

            if (typeof mobileMasks[mobileCountryCode] !== 'undefined') {
                $('#lead-call-number').mask(mobileMasks[mobileCountryCode].mask_value, {autoclear: false});
            } else {
                $('#lead-call-number').mask('(999) 999 9999', {autoclear: false});
            }

            if (typeof mobileMasks[currentMobileCountryCode] !== 'undefined') {
                $('#lead-from-call-mobile').mask(mobileMasks[currentMobileCountryCode].mask_value, {autoclear: false});
            } else {
                $('#lead-from-call-mobile').mask('(999) 999 9999', {autoclear: false});
            }
            var mobile = _.isUndefined(i18n['Mobile'])?'Mobile':i18n['Mobile'];
            $('#lead-from-call-mobile-number').text(mobile + ' ' + $('#lead-from-call-mobile').val());

            if (typeof mobileMasks[currentDesktopCountryCode] !== 'undefined') {
                $('#lead-from-call-desktop').mask(mobileMasks[currentDesktopCountryCode].mask_value, {autoclear: false});
            } else {
                $('#lead-from-call-desktop').mask('(999) 999 9999', {autoclear: false});
            }
            var desktop = _.isUndefined(i18n['Desktop'])?'Desktop':i18n['Desktop'];
            $('#lead-from-call-desktop-number').text(desktop + ' ' + $('#lead-from-call-desktop').val());

            var voipPhone = _.isUndefined(i18n['VOIP phone'])?'VOIP phone':i18n['VOIP phone'];
            $('#lead-from-call-voip-phone-number').text(voipPhone + ' ' + $('#lead-from-call-voip-phone').val());

            if(!_.isEmpty(this.leadModel.get('lead_mobile'))) {
                self.initMmsPicturesUploader({'fileSize': 5, 'fileUploads': 1});
            }

        },
        dispatchEditorKeyup: function(editor, event, keyTime) {
            var keyTimer = keyTime;
            if(keyTimer === null) {
                keyTimer = setTimeout(function() {
                    keyTimer = null;
                }, 1000)
            }
        },
        selectCallDevice: function(e)
        {
            var deviceTypeEl = $(e.currentTarget),
                deviceType = deviceTypeEl.val(),
                phoneEl = deviceTypeEl.closest('form').find('input[name="lead-call-number"]'),
                mobile = '',
                mobileCountyCode = '',
                phone = '',
                phoneCountryCode ='',
                desktopMasks = this.leadModel.get('desktopMasks'),
                mobileMasks = this.leadModel.get('mobileMasks'),
                organizationMobile = '',
                organizationPhone = '';

            if (deviceType === 'mobile') {
                if (!_.isNull(this.leadModel.get('lead_mobile'))) {
                    mobile = this.leadModel.get('lead_mobile');
                }
                if (!_.isNull(this.leadModel.get('lead_mobile_country_code'))) {
                    mobileCountyCode = this.leadModel.get('lead_mobile_country_code');
                }
                if (_.isEmpty(mobileCountyCode)) {
                    $('#lead-phone-mobile-country-codes').val('AC');
                } else {
                    $('#lead-phone-mobile-country-codes').val(mobileCountyCode);
                }
                phoneEl.val(mobile);

                if (typeof mobileMasks[mobileCountyCode] !== 'undefined') {
                    phoneEl.mask(mobileMasks[mobileCountyCode].full_mask_value, {autoclear: false}).focus();
                } else {
                    phoneEl.mask('(999) 999 9999', {autoclear: false}).focus();
                }
            }

            if (deviceType === 'desktop') {
                if (!_.isNull(this.leadModel.get('lead_phone'))) {
                    phone = this.leadModel.get('lead_phone');
                }
                if (!_.isNull(this.leadModel.get('lead_phone_country_code'))) {
                    phoneCountryCode = this.leadModel.get('lead_phone_country_code');
                }
                if (_.isEmpty(phoneCountryCode)) {
                    $('#lead-phone-mobile-country-codes').val('AC');
                } else {
                    $('#lead-phone-mobile-country-codes').val(phoneCountryCode);
                }
                phoneEl.val(phone);
                if (typeof desktopMasks[phoneCountryCode] !== 'undefined') {
                    phoneEl.mask(desktopMasks[phoneCountryCode].full_mask_value, {autoclear: false}).focus();
                } else {
                    phoneEl.mask('(999) 999 9999', {autoclear: false}).focus();
                }
            }

            if (deviceType === 'organization-mobile') {
                if (!_.isNull(this.leadModel.get('organization_mobile'))) {
                    organizationMobile = this.leadModel.get('organization_mobile');
                }
                if (!_.isNull(this.leadModel.get('organization_mobile_country_code'))) {
                    mobileCountyCode = this.leadModel.get('organization_mobile_country_code');
                }
                if (_.isEmpty(mobileCountyCode)) {
                    $('#lead-phone-mobile-country-codes').val('AC');
                } else {
                    $('#lead-phone-mobile-country-codes').val(mobileCountyCode);
                }
                phoneEl.val(organizationMobile);
                if (typeof mobileMasks[mobileCountyCode] !== 'undefined') {
                    phoneEl.mask(mobileMasks[mobileCountyCode].full_mask_value, {autoclear: false}).focus();
                } else {
                    phoneEl.mask('(999) 999 9999', {autoclear: false}).focus();
                }
            }

            if (deviceType === 'organization-phone') {
                if (!_.isNull(this.leadModel.get('organization_phone'))) {
                    organizationPhone = this.leadModel.get('organization_phone');
                }
                if (!_.isNull(this.leadModel.get('organization_phone_country_code'))) {
                    phoneCountryCode = this.leadModel.get('organization_phone_country_code');
                }
                if (_.isEmpty(phoneCountryCode)) {
                    $('#lead-phone-mobile-country-codes').val('AC');
                } else {
                    $('#lead-phone-mobile-country-codes').val(phoneCountryCode);
                }
                phoneEl.val(organizationPhone);
                if (typeof desktopMasks[phoneCountryCode] !== 'undefined') {
                    phoneEl.mask(desktopMasks[phoneCountryCode].full_mask_value, {autoclear: false}).focus();
                } else {
                    phoneEl.mask('(999) 999 9999', {autoclear: false}).focus();
                }
            }
        },
        submit: function(e){
            e.preventDefault();

            var self = this,
                form = $(e.currentTarget),
                isValid = true;

            _.each(form.find('.required'), function(el){
                if (!$(el).val()){
                    isValid = false;
                }
            });

            if (!isValid){
                showMessage(_.isUndefined(i18n['Missing required field'])?'Missing required field':i18n['Missing required field'], true);
                return false;
            }

            $('#content-of-the-sms').val(tinymce.activeEditor.getContent());

            if(form.find('#testSms').val() != 1) {
                $('#lead-sms-now').prop('disabled', true);
            }

            var formParams = form.serialize()+'&secureToken='+$('#lead-grid-token').val(),
                emailSequenceId = form.find('#lead-sms-follow-up-sequences').val();

            if(!$('.mms-images-block').hasClass('hide') && this.uploadedFiles.length) {
                var uploadedFiles = this.uploadedFiles.join(',');
                formParams += '&mediaFiles='+uploadedFiles;
            }

            $.ajax({
                url: form.attr('action'),
                type: 'POST',
                data: formParams,
                dataType: 'json'
            }).done(function(response) {
                $('#lead-sms-now').prop('disabled', false);
                if (response.error === 1) {
                    form.find('#testSms').val(0);
                    showMessage(response.responseText, true, 5000);
                } else {
                    showMessage(response.responseText, false, 5000);
                    if(form.find('#testSms').val() != 1){
                        self.render();
                    }
                    form.find('#testSms').val(0);
                }

                self.uploadedFiles = [];
                self.maxUploadedFiles = 0;
                $('#lead-mms-media-files-list').empty();
                $('.uploaded-mms-size-count').text('0');
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
                $('#lead-sms-now').prop('disabled', false);
            });
            return false;

        },
        switchSendMms: function () {
            if($('.mms-images-block').hasClass('hide')) {
                $('.mms-images-block').removeClass('hide').show();
            } else {
                $('.mms-images-block').addClass('hide').hide();
            }
        },
        initMmsPicturesUploader: function(allowedUploadData) {
            this.uploadedFiles = [];
            this.maxUploadedFiles = 0;

            var options = {
                runtimes: 'html5,flash,html4',
                browse_button: 'upload-mms-button',
                container: 'uploader-mms-images-block',
                rename         : true,
                max_file_size  : allowedUploadData.fileSize+'mb',
                max_file_count : allowedUploadData.fileUploads,
                url: $('#website_url').val()+'api/leads/leadmms/',
                multipart_params: {
                    secureToken: $('#lead-grid-token').val(),
                    leadId:      this.leadModel.get('id')
                },
                multi_selection: false,
                unique_names: false,
            };

            if(_.isUndefined(this.mmsPicturesUploader)) {

                this.mmsPicturesUploader = new plupload.Uploader(options);

                this.mmsPicturesUploader.init();

                this.mmsPicturesUploader.bind('BeforeUpload', _.bind(this.beforeUpload, this));
                this.mmsPicturesUploader.bind('FilesAdded', _.bind(this.filesAdded, this));
                this.mmsPicturesUploader.bind('UploadProgress', _.bind(this.uploadProgress, this));
                this.mmsPicturesUploader.bind('FileUploaded', _.bind(this.fileUploaded, this));
                this.mmsPicturesUploader.bind('Error', _.bind(this.handleUploadErrors, this));
                this.mmsPicturesUploader.bind('UploadComplete', _.bind(this.uploadComplete, this));
            }
        },
        beforeUpload: function(up, file) {
            if(this.maxUploadedFiles >= 10) {
                var extraАile = up.getFile(file.id);
                up.removeFile(extraАile);
                up.stop();
                showMessage((_.isUndefined(i18n['Messages can include up to 10 media files!']) ? 'Messages can include up to 10 media files!' : i18n['Messages can include up to 10 media files!']), true, 500);
            }
        },
        filesAdded: function(up, files) {
            var failedFilesUploadAdditionalFiltered = [];

            if(files.length) {
                _.each(this.failedFilesUploadAdditional, function (fileName, key) {
                    _.each(files, function (fileN, k) {
                        if(fileN.id == key) {
                            failedFilesUploadAdditionalFiltered.push(fileName);
                        }
                    });

                });

                if(failedFilesUploadAdditionalFiltered.length) {
                    this.failedFilesUploadAdditional = failedFilesUploadAdditionalFiltered;
                } else {
                    this.failedFilesUploadAdditional = {};
                }
            }

            this.mmsPicturesUploader.settings.multipart_params.multipleFiles = 0;
            if(files.length > 1) {
                this.mmsPicturesUploader.settings.multipart_params.multipleFiles = 1;
            }
            this.mmsPicturesUploader.settings.multipart_params.generalFileSize = $('.uploaded-mms-size-count').text();
            this.mmsPicturesUploader.settings.multipart_params.secureToken = $('#lead-grid-token').val();
            this.failedFilesUpload = [];
            this.mmsPicturesUploader.start();
        },
        uploadProgress: function(up, file) {

        },
        fileUploaded: function(up, file, info) {
            var response = jQuery.parseJSON(info.response),
                self = this,
                leadId = self.leadModel.get('id');

            if (response.error == '0') {
                // if(!this.mmsPicturesUploader.settings.multipart_params.multipleFiles) {
                //     showMessage(response.message, false, 500);
                // }
                var fileEl = '<li><span class="grid_11">'+ file.name +'</span><a class="ticon-remove error icon14 alpha grid_1 delete-uploaded-mms-file" data-role="delete" data-lead-id="'+ leadId +'" data-file-name="'+ response.fileStoredName +'" data-file-size="'+ file.size +'" href="javascript:;"></a></li>';

                $('#lead-mms-media-files-list').append(fileEl);
                $('.uploaded-mms-size-count').text(parseFloat(response.generalFileSize.toFixed(2)));

                self.uploadedFiles.push(response.fileStoredName);
                self.maxUploadedFiles +=1;

            } else {
                var errorMessage = '';
                if(typeof response.fileName !== 'undefined' && response.fileName != '') {
                    if  (typeof(response.message) == 'object') {
                        for (var i in response.message) {
                            errorMessage += '<li>'+response.message[i]+'</li>';
                        }
                    } else {
                        errorMessage += '<li> ' + (_.isUndefined(i18n['File']) ? 'File' : i18n['File']) + ' \'' + response.fileName + '\' (' + response.message + ')'+'</li>';
                    }
                }

                if(response.type = 'mmsMaxSize') {
                    if(errorMessage != '') {
                        errorMessage + '</br>' + response.message;
                    } else {
                        errorMessage = response.message;
                    }
                }

                self.failedFilesUpload.push(errorMessage);
            }
        },
        handleUploadErrors: function(up, err) {
            var errorMessage = '<li> ' + (_.isUndefined(i18n['File']) ? 'File' : i18n['File']) + ' \'' + (err.file ? err.file.name : "") + '\' (' + err.message + ')'+'</li>';
            this.failedFilesUploadAdditional[err.file.id] = errorMessage;
        },
        uploadComplete: function(up, files) {
            if(files.length) {
                if(this.failedFilesUploadAdditional.length) {
                    var msg = _.isUndefined(i18n['Files uploaded']) ? 'Files uploaded' : i18n['Files uploaded'];
                    msg += ' </br>' +(_.isUndefined(i18n['Except:']) ? 'Except:' : i18n['Except:']) + '</br>';
                    msg += '<ul>';
                    _.each(this.failedFilesUploadAdditional, function (fileName, key) {
                        msg += fileName;
                    });

                    if(this.failedFilesUpload.length) {
                        _.each(this.failedFilesUpload, function (fileName, key) {
                            msg += fileName;
                        });
                    }
                    msg += '</ul>';
                    showMessage(msg, true, 500);
                } else {
                    if(this.failedFilesUpload.length) {
                        if(up.files.length == this.failedFilesUpload.length) {
                            if(up.files.length > 1) {
                                var msg = (_.isUndefined(i18n['Files not uploaded.']) ? 'Files not uploaded.' : i18n['Files not uploaded.']) + '</br>';
                            } else {
                                var msg = (_.isUndefined(i18n['File not uploaded.']) ? 'File not uploaded.' : i18n['File not uploaded.']) + '</br>';
                            }

                            msg += '<ul>';
                            _.each(this.failedFilesUpload, function (fileName, key) {
                                msg += fileName;
                            });
                            msg += '</ul>';

                            showMessage(msg, true, 500);
                        } else if (up.files.length > this.failedFilesUpload.length) {
                            var msg = _.isUndefined(i18n['Files uploaded']) ? 'Files uploaded' : i18n['Files uploaded'];
                            msg += ' </br>' +(_.isUndefined(i18n['Except:']) ? 'Except:' : i18n['Except:']) + '</br>';
                            msg += '<ul>';
                            _.each(this.failedFilesUpload, function (fileName, key) {
                                msg += fileName;
                            });
                            msg += '</ul>';
                            showMessage(msg, true, 500);
                        }
                    } else {
                        showMessage(_.isUndefined(i18n['Files uploaded']) ? 'Files uploaded' : i18n['Files uploaded'], false, 500);
                    }
                }

                this.failedFilesUploadAdditional = {};
                this.mmsPicturesUploader.splice();
            }
        },
        deleteUploadedMmsFile: function (e) {
            e.preventDefault();
            var el = $(e.currentTarget),
                fileName = el.data('file-name'),
                leadId = el.data('lead-id'),
                fileSize = el.data('file-size'),
                self = this;

            showConfirm(_.isUndefined(i18n['Are you sure want to delete an uploaded file?'])?'Are you sure want to delete an uploaded file?':i18n['Are you sure want to delete an uploaded file?'], function(){
                $.ajax({
                    'url': $('#website_url').val()+'api/leads/leadmms/leadId/'+leadId+'/fileName/'+fileName+'/fileSize/'+fileSize+'/generalFileSize/'+$('.uploaded-mms-size-count').text(),
                    'type':'DELETE',
                    'dataType':'json'
                }).done(function(response){
                    if (response.error === 1) {
                        showMessage(response.message, true, 5000);
                    } else {
                        showMessage(response.message, false, 3000);
                        _.each(self.uploadedFiles, function (fileName, key) {
                            if(fileName == response.deletedFile) {
                                self.uploadedFiles.splice(key, 1);
                                var elToDelete = $('#lead-mms-media-files-list').find("[data-file-name='" + fileName + "']");
                                if(elToDelete.length) {
                                    $(elToDelete).closest('li').remove();
                                }
                                var generalFileSize = parseFloat(response.generalFileSize.toFixed(2));
                                self.maxUploadedFiles -= 1;
                                $('.uploaded-mms-size-count').text(generalFileSize);
                            }
                        });
                    }
                });
            });
        }
    });

    return LeadSmsFormView;
});
