define([
    'backbone',
    '../collections/organizations-timeline',
    'text!../templates/paginator.html',
    'text!../templates/organization-timeline-log.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'moment',
    'accounting'
], function(Backbone,
            OrganizationTimelineCollection, PaginatorTmpl, OrganizationTimelineLogTmpl, i18n, moment, accounting
){

    var OrganizationsTimelineTodayView = Backbone.View.extend({
        el: $('#organization-timeline-today'),
        events: {
            'blur .add-additional-meeting-info': 'addMeetingAdditionalInfo'
        },
        templates: {
        },
        initialize: function(organizationModel){
            this.timelineToday = new OrganizationTimelineCollection();
            this.timelineToday.timelineType = 'today';
            this.timelineToday.organizationId = organizationModel.get('id');
            this.timelineToday.userTimezoneOffset = organizationModel.get('userTimezoneOffset');
            this.timelineToday.on('reset', this.renderTimeline, this);
            this.timelineToday.on('add', this.renderTimeline, this);
            this.timelineToday.on('destroy', this.renderTimeline, this);
        },
        render: function(){
            var el = $('#lead-contacts'),
                selectedLeads = $(el).val();

            this.timelineToday.server_api = _.extend(this.timelineToday.server_api, {
                'leadId': !_.isEmpty(selectedLeads) ? selectedLeads : [],
                'filter': function() {
                    return {
                        'filter-by-action-type': $('.timeline-filter-by-action-type:checked').val(),
                        'filter-by-type':  $('#filter-action-log-type-block-state').val(),
                        'filter-by-sub-type' : $('#filter-action-log-subtype-state').val()
                    };
                }
            });
            this.timelineToday.pager();
        },
        addMeetingAdditionalInfo: function(e)
        {
            var el = $(e.currentTarget),
                meetingLogId = el.data('meeting-log-id'),
                additionalComment = el.val(),
                oldAdditionalData = el.data('old-additional-data');
            if (oldAdditionalData === additionalComment) {
                return false;
            }

            $.ajax({
                url: $('#website_url').val()+'api/leads/leadmeetinglog/',
                type: 'PUT',
                data: JSON.stringify({'id':meetingLogId, 'additional_content':additionalComment, 'secureToken':$('#lead-organization-grid-token').val()}),
                dataType: 'json'
            }).done(function(response) {
                showMessage(response.responseText, false, 5000);
                el.data('old-additional-data', additionalComment);
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
        },
        renderTimeline: function(){
            this.$el.find('#organization-timeline-today-body').empty();
            this.timelineToday.each(this.renderTimelineItem, this);
            this.timelineToday.info()['i18n'] = i18n;
            if(this.$el.find('style').length > 0) {
                this.$el.find('style').remove();
            }
        },
        renderTimelineItem: function(TimelineItemData) {
            this.$el.find('#organization-timeline-today-body').append( _.template(OrganizationTimelineLogTmpl, {
                'timeLineItem': TimelineItemData, 'monthRow':false, 'users':this.timelineToday.usersList, 'currentUserId':this.timelineToday.currentUserId,
                'currencySymbol':this.timelineToday.currencySymbol,   'logType': 'today',
                'moment': moment,
                'accounting': accounting,
                'moneyFormat': this.timelineToday.moneyFormat,
                'userTimezoneOffset': this.timelineToday.userTimezoneOffset,
                'i18n': i18n,
                'leadInfo' : !_.isEmpty(this.timelineToday.leadInfo) ? this.timelineToday.leadInfo : [],
                'gatewayLabelsList':this.timelineToday.gatewayLabelsList
            }));
        }
    });

    return OrganizationsTimelineTodayView;
});
