<?php

class Tools_NotifierNewsObserver implements Interfaces_Observer
{
    /**
     * @param $object
     * @throws Exceptions_SeotoasterException
     */
    public function notify($object)
    {
        if ($object->getId() && Newslog_Models_Mapper_NewsMapper::getInstance()->find($object->getId())) {
            if ($object->getPageId()) {
                self::updateSwJs();
            }
            $notifierNewsMapper = Notifier_Models_Mappers_NotifierNewsMapper::getInstance();
            if ($object->getPublished()) {
                $metaData = $object->getMetaData();
                if (!empty($metaData)) {
                    $metaData = json_decode($metaData, true);
                    if (!empty($metaData) && !empty($metaData['publishAt'])) {
                        $publishAt = date('Y-m-d', strtotime($metaData['publishAt']));
                        $newsId = $object->getId();

                        $notifierNewsInfoMapper = Notifier_Models_Mappers_NotifierNewsInfoMapper::getInstance();
                        $notifierNewsInfoModel = $notifierNewsInfoMapper->findByNewsId($newsId);
                        if (!$notifierNewsInfoModel instanceof Notifier_Models_Models_NotifierNewsInfoModel) {
                            $notifierNewsInfoModel = new Notifier_Models_Models_NotifierNewsInfoModel();
                            $notifierNewsInfoModel->setNewsId($newsId);
                            $notifierNewsInfoModel->setPublishedAt($publishAt);
                            $notifierNewsInfoMapper->save($notifierNewsInfoModel);
                        } else {
                            $existingNewsPublishAtDate = date('Y-m-d', strtotime($notifierNewsInfoModel->getPublishedAt()));
                            if ($existingNewsPublishAtDate !== $publishAt) {
                                $notifierNewsInfoModel->setPublishedAt($publishAt);
                                $notifierNewsInfoMapper->save($notifierNewsInfoModel);
                            } else {
                                return '';
                            }
                        }

                        $subscriptions = Notifier_Models_Mappers_NotifierSubscriptionsMapper::getInstance()->fetchAll();
                        $notifierConfig = Notifier_Models_Mappers_NotifierConfigMapper::getInstance()->getConfigParams();
                        if ($notifierConfig['cronNotifications'] === 'true') {
                            $pendingNewsMapper = Notifier_Models_Mappers_NotifierPendingNewsMapper::getInstance();
                            $pendingNews = new Notifier_Models_Models_NotifierPendingNewsModel();
                            $pendingNews->setNewsId($object->getId());
                            $pendingNewsMapper->save($pendingNews);
                        } else {
                            foreach ($subscriptions as $sub) {
                                $notifierNewsModel = new Notifier_Models_Models_NotifierNewsModel();
                                $notifierNewsModel->setToken($sub->getToken());
                                $notifierNewsModel->setNewsId($object->getId());
                                $notifierNewsMapper->save($notifierNewsModel);
                            }
                        }
                    }
                }
            } else {
                $notifierNewsMapper->deleteByNewsId($object->getId());
            }
        } elseif ($object->getId()) {
            self::updateSwJs();
        }
    }

    /**
     * Method modifies sw.js adds new routes for pre-caching
     * @throws Exceptions_SeotoasterException
     */
    public static function updateSwJs()
    {
        $filename = 'sw.js';
        if (!file_exists($filename)) {
            throw new Exceptions_SeotoasterException('File ' . $filename . ' doesn\'t exists ');
        }
        $swJs = Tools_Filesystem_Tools::getFile('sw.js');
        $preCachedItems = self::generatePreCachedItemsArray($swJs);
        if ($preCachedItems) {
            $replacementString = self::generateReplacementString($preCachedItems);
            $updatedSwJs = preg_replace('/precacheAndRoute\(\[\n(.*)\s{2}\]\);/is', $replacementString, $swJs);
            try {
                Tools_Filesystem_Tools::saveFile('sw.js', $updatedSwJs);
            } catch (Exception $e) {
                $errData['updateServiceWorkerError'] = $e->getMessage();
            }
        }
    }

    /**
     * Method gets and combines into array
     * urls from the Service Worker file (sw.js)
     * with the latest news urls and
     * with concat.min.css urls from the tmp folder
     * @param $swJs String (sw.js file)
     * @return array|bool
     * @throws Exceptions_SeotoasterException
     */
    public static function generatePreCachedItemsArray($swJs)
    {
        preg_match_all('/"url": "(.*)",\n/i', $swJs, $matches);
        if (!empty($matches[1])) {
            $tmpFolder = Zend_Controller_Action_HelperBroker::getStaticHelper('website')->getTmp();
            $newsFolder = DIRECTORY_SEPARATOR . Newslog_Models_Mapper_ConfigurationMapper::getInstance()->fetchConfigParam('folder') . DIRECTORY_SEPARATOR;
            $threeLatestNews = Newslog_Models_Mapper_NewsMapper::getInstance()->getAllNews('n.published = 1', ['p.publish_at DESC', 'n.created_at DESC'], 3, 0);
            $preCachedItems = array_slice($matches[1], 0, 3);
            // push newsfolder to the precache array
            array_push($preCachedItems, $newsFolder);
            // push all existed concat.min.css paths into precache array
            $tmpFolderFiles = Tools_Filesystem_Tools::scanDirectory($tmpFolder);
            foreach ($tmpFolderFiles as $file) {
                if(false !== strpos($file, 'concat.min.css')) {
                    // exclude offline.concat.min.css
                    // this file is hardcoded into sw.js to allow PWA works without news.
                    if('offline.concat.min.css' === $file) {
                        continue;
                    }
                    array_push($preCachedItems, DIRECTORY_SEPARATOR. $tmpFolder . $file);
                }
            }
            // push 3 latest news to the precache array
            foreach ($threeLatestNews as $news) {
                if (strpos($news->getMetaDataValue('url'), '.html') !== false) {
                    array_push($preCachedItems, $newsFolder . urlencode($news->getMetaDataValue('url')));
                    array_push($preCachedItems, DIRECTORY_SEPARATOR . 'previews' . DIRECTORY_SEPARATOR . urlencode($news->getMetaDataValue('image')));
                }
            }
            return $preCachedItems;
        }
        return false;
    }

    /**
     * Method generate string for replacement in Service Worker.
     * @param $preCachedItems
     * Array that contains URLs for replacement.
     * @return string
     */
    public static function generateReplacementString($preCachedItems)
    {

        $websiteUrl = Zend_Controller_Action_HelperBroker::getStaticHelper('website')->getUrl();
        $websitePath = parse_url($websiteUrl, PHP_URL_PATH);
        $subFolder = '';
        $originalSubfolderName = '';
        if (!empty($websitePath)) {
            $originalSubfolderName = $websitePath;
            $subFolder = rtrim($websitePath, '/');
        }

        $replacementString = 'precacheAndRoute([' . PHP_EOL;
        foreach ($preCachedItems as $cachedItem) {
            $replacementString .= '    {' . PHP_EOL;
            if (!empty($originalSubfolderName) && $originalSubfolderName !== '/' && strpos($cachedItem, $subFolder) !== 0) {
                $replacementString .= '      "url": "' . $subFolder . $cachedItem . '",' . PHP_EOL;
            } else {
                $replacementString .= '      "url": "' . $cachedItem . '",' . PHP_EOL;
            }
            $replacementString .= '      "revision": null,' . PHP_EOL;
            $replacementString .= '    },' . PHP_EOL;
        }
        $replacementString .= '  ]);';
        return $replacementString;
    }

    /**
     * Method fills plugin_notifier_news table after a news creating/modifying
     * if "Process subscriptions via cron script" flag is checked
     */
    public static function processPendingNewsAction()
    {
        $pendingNewsMapper = Notifier_Models_Mappers_NotifierPendingNewsMapper::getInstance();
        $notifierNewsMapper = Notifier_Models_Mappers_NotifierNewsMapper::getInstance();
        $pendingNews = $pendingNewsMapper->getUnprocessedNews();
        $subscriptions = Notifier_Models_Mappers_NotifierSubscriptionsMapper::getInstance()->fetchAll();
        if (!empty($pendingNews) && !empty($subscriptions)) {
            foreach ($pendingNews as $news) {
                foreach ($subscriptions as $sub) {
                    $notifierNewsModel = new Notifier_Models_Models_NotifierNewsModel();
                    $notifierNewsModel->setToken($sub->getToken());
                    $notifierNewsModel->setNewsId($news->getNewsId());
                    $notifierNewsMapper->save($notifierNewsModel);
                }
                $pendingNewsMapper->updateStatus($news);
                $pendingNewsMapper->deleteByNewsId($news->getNewsId());
            }
        }

        return true;
    }

}
