<?php

/**
 * Widcard custom params api
 *
 * Class Api_Widcard_Params
 */
class Api_Widcard_Params extends Api_Service_Abstract
{

    /**
     * Secure token
     */
    const WIDCARD_PARAM_SECURE_TOKEN = 'WidcardParamToken';

    /**
     * Website helper
     *
     * @var null
     */
    private $_websiteHelper = null;

    /**
     * Session helper
     *
     * @var null
     */
    private $_sessionHelper = null;

    /**
     * access list
     *
     * @var array
     */
    protected $_accessList = array(
        Tools_Security_Acl::ROLE_SUPERADMIN => array('allow' => array('get', 'post', 'put', 'delete')),
        Tools_Security_Acl::ROLE_ADMIN => array('allow' => array('get', 'post', 'put', 'delete')),
    );

    public function init()
    {
        $this->_websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');
    }

    public function getAction()
    {
    }

    public function postAction()
    {
        $paramName = filter_var($this->_request->getParam('paramName', false), FILTER_SANITIZE_STRING);
        $paramValue = filter_var($this->_request->getParam('paramValue', false), FILTER_SANITIZE_STRING);
        $secureToken = filter_var($this->_request->getParam('secureToken', false), FILTER_SANITIZE_STRING);
        $tokenValid = Tools_System_Tools::validateToken($secureToken, self::WIDCARD_PARAM_SECURE_TOKEN);
        if (!$tokenValid || !$paramName) {
            exit();
        }

        $widcardParamDbTable = new Widcard_Models_Dbtables_WidcardCustomParamsDbtable();
        $widcardParamDbTable->updateParam($paramName, $paramValue);

        return array('paramName' => $paramName, 'paramValue' => $paramValue);

    }

    public function deleteAction()
    {
    }


    public function putAction()
    {
    }

    /**
     * normalize option set key
     *
     * @param $key
     * @return string
     */
    protected function _normalizeOptionsKey($key)
    {
        $exploded = explode('_', $key);
        $exploded = array_map('ucfirst', $exploded);

        return join('', $exploded);
    }
}
