/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{property as n,customElement as f,state as y,query as b}from"lit/decorators.js";import{LitElement as P,nothing as u,html as d}from"lit";import g from"@typo3/core/ajax/ajax-request.js";import{AjaxResponse as I}from"@typo3/core/ajax/ajax-response.js";import E from"@typo3/backend/viewport.js";import{topLevelModuleImport as T}from"@typo3/backend/utility/top-level-module-import.js";import M,{Sizes as $}from"@typo3/backend/modal.js";import{SeverityEnum as v}from"@typo3/backend/enum/severity.js";var o=function(r,e,s,t){var l=arguments.length,a=l<3?e:t===null?t=Object.getOwnPropertyDescriptor(e,s):t,c;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")a=Reflect.decorate(r,e,s,t);else for(var h=r.length-1;h>=0;h--)(c=r[h])&&(a=(l<3?c(a):l>3?c(e,s,a):c(e,s))||a);return l>3&&a&&Object.defineProperty(e,s,a),a};class i extends P{}o([n({type:String})],i.prototype,"verifyActionUri",void 0),o([n({type:String})],i.prototype,"cancelUri",void 0),o([n({type:Boolean})],i.prototype,"isAjax",void 0),o([n({type:Boolean,attribute:"has-fatal-error"})],i.prototype,"hasFatalError",void 0),o([n({type:Boolean,attribute:"allow-install-tool-password"})],i.prototype,"allowInstallToolPassword",void 0),o([n({type:Object})],i.prototype,"labels",void 0);const w=async r=>{window.location!==window.parent.location&&T("@typo3/backend/security/element/sudo-mode.js");const s=top.document.createElement("typo3-backend-security-sudo-mode");return Object.assign(s,r),top.document.body.append(s),new Promise((t,l)=>{s.addEventListener("typo3:sudo-mode:verified",()=>t()),s.addEventListener("typo3:sudo-mode:finished",()=>l())})};let m=class extends i{render(){return u}async firstUpdated(){if(window.location!==window.parent.location){try{await w(this.getPropertyValues())}catch{history.go(-1)}return}M.advanced({title:this.hasFatalError?this.labels.verificationFailed:this.labels.verifyWithUserPassword,severity:this.hasFatalError?v.error:v.notice,size:$.small,additionalCssClasses:["modal-sudo-mode-verification"],buttons:[this.hasFatalError?{text:this.labels.cancel,btnClass:"btn-default",trigger:()=>{top.location.href=this.cancelUri}}:{text:this.labels.verify,name:"verify",form:"verify-sudo-mode",btnClass:"btn-primary"}],content:d`<typo3-backend-security-sudo-mode-form .labels=${this.labels} .verifyActionUri=${this.verifyActionUri} .cancelUri=${this.cancelUri} .isAjax=${this.isAjax} .hasFatalError=${this.hasFatalError} .allowInstallToolPassword=${this.allowInstallToolPassword} @typo3:sudo-mode:verified=${()=>this.dispatchEvent(new Event("typo3:sudo-mode:verified"))}></typo3-backend-security-sudo-mode-form>`}).addEventListener("typo3-modal-hidden",()=>{this.dispatchEvent(new Event("typo3:sudo-mode:finished")),this.remove()})}getPropertyValues(){const e={},s=this.constructor;for(const t of s.elementProperties.keys())e[t]=this[t];return e}};m=o([f("typo3-backend-security-sudo-mode")],m);let p=class extends i{constructor(){super(...arguments),this.useInstallToolPassword=!1,this.errorMessage=null}createRenderRoot(){return this}render(){return this.hasFatalError?d`<div><div class="alert alert-danger">${this.labels.verificationExpired}</div></div>`:d`<div>${this.errorMessage?d`<div class="alert alert-danger" id=invalid-password>${this.labels[this.errorMessage]||this.errorMessage}</div>`:u}<form method=post class=form id=verify-sudo-mode spellcheck=false @submit=${e=>this.verifyPassword(e)}>${this.useInstallToolPassword?u:d`<input hidden aria-hidden=true type=text autocomplete=username value=${TYPO3.configuration.username}>`}<div class=form-group><label class=form-label for=password>${this.labels.password}</label> <input required class=form-control id=password type=password name=password autofocus autocomplete=${this.useInstallToolPassword?"section-install current-password":"current-password"}></div></form>${this.allowInstallToolPassword?d`<div class=text-end><a href=# @click=${e=>this.toggleUseInstallToolPassword(e)}> ${this.useInstallToolPassword?this.labels.userPasswordMode:this.labels.installToolPasswordMode} </a></div>`:u}</div>`}updated(e){e.has("useInstallToolPassword")&&(this.closest("typo3-backend-modal").modalTitle=this.getModalTitle())}getModalTitle(){return this.hasFatalError?this.labels.verificationFailed:this.useInstallToolPassword?this.labels.verifyWithInstallToolPassword:this.labels.verifyWithUserPassword}async verifyPassword(e){e.preventDefault(),this.errorMessage=null;try{const t=await(await new g(this.verifyActionUri).post({password:this.passwordElement.value,useInstallToolPassword:this.useInstallToolPassword?1:0})).resolve("application/json");this.dispatchEvent(new Event("typo3:sudo-mode:verified")),this.closest("typo3-backend-modal").hideModal(),!this.isAjax&&t.redirect&&E.ContentContainer.setUrl(t.redirect.uri)}catch(s){if(s instanceof I){const t=await s.resolve("application/json");this.errorMessage=t.message}else throw s}}toggleUseInstallToolPassword(e){e.preventDefault(),this.useInstallToolPassword=!this.useInstallToolPassword}};o([y()],p.prototype,"useInstallToolPassword",void 0),o([y()],p.prototype,"errorMessage",void 0),o([b("#password")],p.prototype,"passwordElement",void 0),p=o([f("typo3-backend-security-sudo-mode-form")],p);export{m as SudoMode,p as SudoModeForm,w as initiateSudoModeModal};
