## How to contribute to UVdesk(Community)


### **Bug Reporting**

1. Verify that the bug was not already reported by searching on GitHub in the [Issues section](https://github.com/uvdesk/community-skeleton/issues) or supported dependent repositories [Core Framework](https://github.com/uvdesk/core-framework/issues), [Support Center](https://github.com/uvdesk/support-center-bundle), [Mailbox Component](https://github.com/uvdesk/mailbox-component/issues), [Automation bundle](https://github.com/uvdesk/automation-bundle/issues), [Extension Framework](https://github.com/uvdesk/extension-framework)
If you're unable to find an open issue, [open a new one](https://github.com/uvdesk/community-skeleton/issues/new?assignees=&labels=&template=Bug_report.md).

2. Verify that the bug you are reporting is a general issue and not specific to your individual setup.  
For individual issues please use the [Community Forum](https://forums.uvdesk.com/).

#### **Did you fix a bug?**

1. To provide a code contribution for an issue you will need to set up your own fork of the [community-skeleton repository](https://github.com/uvdesk/community-skeleton) or supported depended repositories ([core](https://github.com/uvdesk/core-framework), support(https://github.com/uvdesk/support-center-bundle) etc)
Make your code changes, commit the changes and make a [Pull Request](https://help.github.com/articles/about-pull-requests/) to the respective repository.
2. Separate each fix into a new branch in your repository and name it with the issue ID e.g. issue-1456.
3. When committing to your individual branch, please try and use the following as your commit message  
```Fixed #1456 - <the subject of the issue>```  
4. Please follow the pull request [template](https://github.com/uvdesk/community-skeleton/blob/master/.github/PULL_REQUEST_TEMPLATE.md) as much as possible.

### **Did you create a new feature or enhancement?**
1. To provide a code contribution for a new feature or enhancement a [feature request](https://github.com/uvdesk/community-skeleton/issues/new?assignees=&labels=&template=2_Feature_request.md) report should be created in case it doesn't exist.
2. To contribute a feature to UVdesk, you must create a forked repository and set up your git and development environment.
3. Make sure your commit messages are relevant and descriptive.
4. Please follow the pull request [template](https://github.com/uvdesk/community-skeleton/blob/master/.github/PULL_REQUEST_TEMPLATE.md) as much as possible.