<?php if (!defined('_VIS_')) die('Error: Call from undefined function');
class subreport
{
	var $error;
	public function __construct()
	{
		$database = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
		$object = new class_setting($database);
		if (!defined("VIS_TIMEZONE")) {
			$dom_vars = $object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', 0, 4);
			if ($dom_vars)
				list($dinfo, $domain) = $dom_vars;
			
			if ($domain != -1)
				$domain = $domain[0];

			if ($domain['timezone_dst'] == 1)
				$domain['timezone'] += 3600;
			
			define('VIS_TIMEZONE', $domain['timezone']);
		} else {
		}
	}

	function get_reset_buttonhtml($operation)
	{
		global $vis_language;
		$resetbtn='';
		$resetbtn .= '<div class="col-sm-1 pull-left"><div class="text-muted pull-center label_page">&nbsp;</div><a id="reset_btn" class="btn btn-primary btn-sm" onclick="$(\'#vis_workpanel_div\').visExecution(\'load_module\', \'Domain\',{\'vis_module\':\'report\', \'vis_operation\': \''.$operation['vis_operation'].'\', \'cache\': true})">'.$vis_language['TXTRESET'].'</a></div></div>';
		echo $resetbtn;
	}

	function domain_report($operation)
	{	
		global $vis_language;
		$report_title = $vis_language['TXTDOMAINREPORT'];
		$export       = 1;
		$filter1	= '';
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type=23;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		$filter     = VIS_TABLE_PREFIX.'domain.is_enabled=1 ';
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$domain     = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'report.php');
		$object = new class_report($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page'])) ? $operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$departments = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		$dept_ids    = '';
		for ($d = 0; $d < count($departments); $d++) {
			$dept_ids .= $departments[$d]['department_id'] . ',';
		}
		if ($dept_ids != '') {
			$dept_ids = substr($dept_ids, 0, -1);
		}
		$dept_id = $dept_ids;
		$filter_condtn = 'is_enabled=1 and (department_access=0 or find_in_set("'.$dept_id.'", department_access)) and '.VIS_TABLE_PREFIX.'ticket_status.status_id=4';
		$status_list = $tkt_object->get_status_list($filter_condtn, $staff_id, VIS_LOCATION_AREA);
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != ''){
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4){
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['domain_id'] == 0){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] == 0){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['domain_id'] != 0){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$dept_acc = $object->get_deptaccess_of_staff($staff_id, $data['domain_id']);
				if($dept_acc!=0 && $dept_acc!=-1 && $dept_acc!=-2){
					$filtr = ' and b.department_id IN ('.$dept_acc.')';
					$filtr1 = ' and a.department_id IN ('.$dept_acc.')';
				} else {
					$filtr = $filtr1 = '';
				}
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = 'b.receive_date between '.$from.' AND '.$to.' and b.domain_id='.$data['domain_id'].' and b.is_deleted=0 and b.is_spam=0 and b.draft_id=0 and b.channel_id!=7 and b.channel_id!='.$lc_chnid.$filtr;
				$filter1 = 'a.receive_date between '.$from.' AND '.$to.' and a.domain_id='.$data['domain_id'].' and a.is_deleted=0 and a.is_spam=0 and a.draft_id=0 and a.channel_id!=7 and a.channel_id!='.$lc_chnid.$filtr1;
				$filter = $filter.'#'.$filter1;					
			}
			
			$temp_filtr = explode('#',$filter);
			$filter = $temp_filtr[0];
			$filter1= $temp_filtr[1];
			list($total, $report, $counts) = $object->get_ticket_count_by_department($filter, $limit, $staff_id, VIS_LOCATION_AREA, $filter1);
			$report_count=($report!=-1) ? count($report) : 0;
			$total_tickets = 0; 
				for($i=0;$i<$report_count;$i++){
				$total_tickets += $report[$i]['total'];
				} 

			$array_summary=array();
			$array_summary['TXTTOTALTICKET']=$total_tickets;
			$array_summary['TXTTOTALOPEN']=$counts['closetotal'];
			$array_summary['TXTTOTALCLOSE']=$counts['opentotal'];
			$array_summary['TXTTOTAL '.strtolower($status_list[0]['status_name'])]=$counts['resolvedtotal'];
			$array_summary['TXTTOTALPROGRESS']=$counts['awaiting'];
			$view_info['page_count']=($total==0) ? 0 : ceil($total/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			$operation['vis_current_operation']='domain_report';
			$operation['vis_current_module']='setting';
			if(isset($operation['vis_export']) && $operation['vis_export'] == 1){
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j = 0;
				$total_tickets = 0;
				foreach ($report as $i){
					foreach ($i as $key => $val){
						if ($key == 'department_name'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'total'){
							$report_exp[$j][$key] = $val;
							$total_tickets += $val;
						} elseif ($key == 'date_created'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'openicket'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'waitticket'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'closeticket'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'resolvedticket'){
							$report_exp[$j][$key] = $val;
						} 
					}
					$report_exp1[$j]['department_name']=$report_exp[$j]['department_name'];
					$report_exp1[$j]['total']=$report_exp[$j]['total'];
					$report_exp1[$j]['open']=$report_exp[$j]['openicket'];
					$report_exp1[$j]['close']=$report_exp[$j]['closeticket'];
					$report_exp1[$j]['resolved']=$report_exp[$j]['resolvedticket'];
					$report_exp1[$j]['other_than_open_and_close']=$report_exp[$j]['waitticket'];
					$j++;
				}
				if($report!=-1){
					$report_exp1[$j]['summary'] = $vis_language['TXTSUMMARY'];
					foreach($array_summary as $key=>$val){ 
						$title=explode(' ',$key);						
				 	$report_exp1[$j][$vis_language[$title[0]].' '.$title[1]]=$vis_language[$title[0]].' '.$title[1].' : '.$val; 
					}
				}
				
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);	
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1){
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE.'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
		
		$database->database_disconnect();
		return true;
	}

	function channel_wise_tickets_report($operation)
	{	
		global $vis_language;
		$report_title = $vis_language['TXTTKTCHNLGRP'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		
		$report_type = 36;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
		$object_staff  = new class_staff($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$staff_filter  = "staff_id =".$staff_id;
		$staff_details = $object_staff->get_staff($staff_filter, $staff_id, VIS_LOCATION_AREA);
		$departments   = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		$channels      = $tkt_object->get_channel($filter='', $staff_id, VIS_LOCATION_AREA);
		$dept_ids      = '';
		for ($d = 0; $d < count($departments); $d++) {
			$dept_ids .= $departments[$d]['department_id'] . ',';
		}
		if ($dept_ids != '') {
			$dept_ids = substr($dept_ids, 0, -1);
		} else {
			$dept_ids = implode(',',$data['department_id']);
		}
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page'])) ? $operation['vis_page'] : 0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='channel_wise_tickets_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != ''){
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}

				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4){
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				$data['department_id'] = (isset($data['department_id']))? $data['department_id']:0;
				if ($data['duration'] != 0 && $data['department_id'] == 0) {
					$dept_id = ($staff_details[0]['department_access'] == '' || $staff_details[0]['department_access'] == 0) ? $dept_ids : $staff_details[0]['department_access'];
				}
				if ($data['duration'] == 0 && $data['department_id'] != '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] != 0 && $data['department_id'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDEPARTMENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 0 && $data['department_id'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = 'receive_date between ' . $from . ' AND ' . $to . ' and is_deleted=0 and t.is_spam=0 and t.draft_id=0 and ';
				if ($data['department_id'] != 0) {
					$dept_ids = implode(',',$data['department_id']);
					$filter = $filter.'c.channel_id=' . $data['channel_id'] . ' and t.department_id in ('.$dept_ids.')';
				} else {
					$filter = $filter.'c.channel_id='.$data['channel_id'].' and t.department_id in ('.$dept_ids.')';
				}
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
			$object_setting = new class_setting($database);
			$custom_filter = ' (location=1 or location=2 or location=11) and is_enabled=1';
			$custom_grouplist = $object_setting->get_custom_group_list($custom_filter, $staff_id, VIS_LOCATION_AREA);
			list($total_count, $totalTicksClosed, $report) = $object->get_channelwise_tickets_report($filter, $limit, $staff_id, VIS_LOCATION_AREA);
			$total =$total_count;
			$view_info['page']=$page;
			$view_info['view_count']= $total_count;
			$report_count=($report!=-1)? count($report) : 0;
			$view_info['page_count']=($total_count==0)?0:ceil($total_count/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			$array_summary=array();
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export         = new export();
				$j=0;
				foreach ($report as $i){
					foreach ($i as $key => $val){
						if($key == 'ticket_hash'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'subject'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'receive_date'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif($key == 'department_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'channel_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'first_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'last_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'group_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'email'){
							$report_exp[$j][$key] = $val;
						}
					}
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash']; 
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['create_date'] = $report_exp[$j]['receive_date'];	
					$report_exp1[$j]['department'] = $report_exp[$j]['department_name'];
					$report_exp1[$j]['channel_name'] = $report_exp[$j]['channel_name']; 				
					$report_exp1[$j]['client_name'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name']; 
					$report_exp1[$j]['email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['Organization'] = $report_exp[$j]['group_name'];
					$j++;
				}
				if($report!=-1){
					$report_exp1[$j]['total_ticket'] = $vis_language['TXTTOTALNOTKT'].": ".count($report);
					$report_exp1[$j]['total_closed'] = $vis_language['TXTTOTALTICKETSCLOSED'].": ".$totalTicksClosed['totalTicksClosed'];
					$report_exp1[$j]['total_resolved'] = $vis_language['TXTTOTALTICKETSRESOLVED'].": ".$totalTicksClosed['totalTicksResolved'];
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);	
				if(isset($operation['slave_db']) && $operation['slave_db'] == 1){
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if(!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else { 
				$array_summary['TXTTOTALNOTKT']=$total;
				$array_summary['TXTTOTALTICKETSCLOSED']=$totalTicksClosed['totalTicksClosed'];
				$array_summary['TXTTOTALTICKETSRESOLVED']=$totalTicksClosed['totalTicksResolved']; 
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total_count,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function first_response_report($operation)
	{	
		global $vis_language;
		$report_title = $vis_language['TXTFIRSTRESPONSE'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		
		$export = 1;
		$report_type = 24;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object       = new class_ticket($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$departments      = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1',$staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database); 
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		//$view_info['page_count']=30;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='first_response_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if((isset($operation['vis_action']) && $operation['vis_action']!='') || isset($operation['vis_submit']) && $operation['vis_submit']!=''){
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				$accessed_departments = '';
				for($m=0;$m<count($departments);$m++){
					$accessed_departments .= $departments[$m]['department_id'].',';
				}
				$accessed_departments = substr($accessed_departments, 0, -1);
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']). '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				$data['department_id'] = (isset($data['department_id']))? $data['department_id']:0;
				if ($data['duration'] == 0 && $data['department_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['department_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDEPARTMENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['department_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s'); 
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}	else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$department_id = ($data['department_id'] == '-2') ? '' : implode(',',$data['department_id']);
				$filter        = VIS_TABLE_PREFIX.'ticket.receive_date between ' . $from . ' AND ' . $to;
				$filter .= ($data['department_id'] != '-2') ? ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN(' . $department_id.')' : ' and  '. VIS_TABLE_PREFIX.'ticket.department_id IN ('.$accessed_departments.')';
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object       = new class_report($database);
			$total_post   = 0;
			$total_ticket = array();
			$total_time   = 0;
			$totalavg_time= 0;
			
			$filter .= ' and '.VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX.'auditlog.operation_id=1 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
			list($total_cnt, $post_details) = $object->get_first_response_report($filter, '', $staff_id, VIS_LOCATION_AREA);
			$total = $total_cnt;
			/*$view_info['page']=$page;
			$report_count=($post_details!=-1) ? count($post_details) : 0;
			$view_info['page_count']=($total_cnt==0)?0:ceil($total_cnt/$view_info['page_count']);
			$view_info['view_count']=count($view_details);*/
			if ($post_details != -1){
				for ($i = 0; $i < count($post_details); $i++) {
					$report[$post_details[$i]['ticket_id']]['count'] = 0;
					if (!isset($report[$post_details[$i]['ticket_id']]['start_time'])){
						$report[$post_details[$i]['ticket_id']]['ticket_hash']  = $post_details[$i]['ticket_hash'];
						$report[$post_details[$i]['ticket_id']]['subject']      = $post_details[$i]['subject'];
						$report[$post_details[$i]['ticket_id']]['ticket_entry'] = $post_details[$i]['ticket_entry'];
						$report[$post_details[$i]['ticket_id']]['first_name']	= $post_details[$i]['first_name'];
						$report[$post_details[$i]['ticket_id']]['last_name']	= $post_details[$i]['last_name'];
						$report[$post_details[$i]['ticket_id']]['email']		= $post_details[$i]['email'];
						$report[$post_details[$i]['ticket_id']]['group_name']	= $post_details[$i]['group_name'];
						$report[$post_details[$i]['ticket_id']]['start_time']   = $post_details[$i]['receive_date'];
						$report[$post_details[$i]['ticket_id']]['ticket_id'] 	= $post_details[$i]['ticket_id'];
						$report[$post_details[$i]['ticket_id']]['slaplan_id'] 	= $post_details[$i]['slaplan_id'];
						$report[$post_details[$i]['ticket_id']]['due_time'] 	= $post_details[$i]['due_time'];
						$report[$post_details[$i]['ticket_id']]['pause_dtime'] 	= $post_details[$i]['pause_dtime'];
						if($post_details[$i]['previousSubmitter']==$post_details[$i]['as_client']){
							$report[$post_details[$i]['ticket_id']]['timestamp']= $post_details[$i]['receive_date'] - $post_details[$i]['ticket_entry'];
							if($report[$post_details[$i]['ticket_id']]['timestamp']!=0){
								$total_post++;
							} else {
								$total_post = 1;
							}
						} else {
							$report[$post_details[$i]['ticket_id']]['timestamp']= 0;
							$total_post += 0;
						}
						$report[$post_details[$i]['ticket_id']]['is_posted'] 	= true;
						$total_ticket[$post_details[$i]['ticket_id']]        	= $post_details[$i]['ticket_id'];
						$total_time  = $report[$post_details[$i]['ticket_id']]['timestamp'];
						$totalavg_time+= $report[$post_details[$i]['ticket_id']]['timestamp'];
					} else {
						if ($report[$post_details[$i]['ticket_id']]['timestamp'] < 0)
							$report[$post_details[$i]['ticket_id']]['timestamp'] = 0;

						$report[$post_details[$i]['ticket_id']]['count']++;
						$total_ticket[$post_details[$i]['ticket_id']] = $post_details[$i]['ticket_id'];
						$total_time += $post_details[$i]['receive_date'] - $report[$post_details[$i]['ticket_id']]['start_time'];
					}
				} 
			} else {
				$report = -1;
			}
			
			$report_new = array();
			//echo "==========".$limit.'======='.$view_info['page_count'].'======'.count($report);
			if(!isset($operation['vis_export']) || $operation['vis_export'] != 1){	
				foreach (array_slice($report, $limit, $view_info['page_count']) as $p){
					$report_new[] = $p;
				}
			}
			$total = count($report);
			$view_info['page']=$page;
			$report_count=($report_new!=-1 || !empty($report_new)) ? count($report_new) : 0;
			$view_info['page_count']=(count($report)==0)? 0 : ceil(count($report)/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			$avgTimeCount = 0;
			$total_post = 0;
			if($report != -1)
			foreach($report as $ticket_id => $details){
				if($details['timestamp']!=0){
					$avgTimeCount += $details['timestamp'];
					$total_post++;
				}else{
					$avgTimeCount += 0;
					$total_post+=0;
				}
			} $avgTimeCount = ($totalavg_time!=0) ? count_remain_time($totalavg_time/$total_post) : 0;
			
			
			$array_summary=array();
			$array_summary['TXTTOTALAVGRESPONSETIME']=($totalavg_time!=0) ? count_remain_time($totalavg_time/$total_post) : 0; 
			if(isset($operation['vis_export']) && $operation['vis_export'] == 1){
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				$total_post = 0;
				foreach ($report as $i) {
					if(!$i['is_posted'])
						continue;

					foreach ($i as $key => $val) {
						if ($key == 'is_posted' && !$val)
							continue;
						if ($key == 'ticket_hash' || $key == 'subject'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'ticket_entry') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'start_time') {
							$report_exp[$j]['reply_date'] = format_datetime_rpt($val,$staff_id);                          
						} elseif ($key == 'timestamp') {
							if ($val != 0){
								$report_exp[$j]['first_response_time'] = count_remain_time($val);
								$total_post++;
							} else {
								$report_exp[$j]['first_response_time'] = '0S';//$vis_language['TXTNOTRESPONDED'];
							}
						} elseif ($key == 'first_name' || $key == 'last_name' || $key == 'email' || $key == 'group_name' || $key == 'response_sla')
							$report_exp[$j][$key] = $val;														
					}
					$report_exp1[$j]['incident_hash']= $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['subject']= $report_exp[$j]['subject'];
					$report_exp1[$j]['client_name']= $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email']= $report_exp[$j]['email'];
					$report_exp1[$j]['organization']= $report_exp[$j]['group_name'];
					$report_exp1[$j]['creation_date']= $report_exp[$j]['ticket_entry'];
					$report_exp1[$j]['reply_date']= $report_exp[$j]['reply_date'];
					$report_exp1[$j]['first_response_time']=$report_exp[$j]['first_response_time'];					
					$j++;
				}
				if($report!=-1){
					$report_exp1[$j]['total_avg_response_time'] = $vis_language['TXTTOTALAVGRESPONSETIME'].": ".(($totalavg_time!=0) ? count_remain_time($totalavg_time/$total_post) : '0S');
				}

				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;	// To display title which shows on report form				
				$filename=$this->export_subreport($operation,$report_exp1);				 
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function response_report($operation)
	{	
		global $vis_language;
		$report_title = $vis_language['TXTAVGRESPONSE'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type = 3;
		$export = 1;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object       = new class_ticket($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$departments      = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1',$staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page'])) ? $operation['vis_page'] : 0;
		$limit=($page*$view_info['page_count']);
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='response_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if((isset($operation['vis_action']) && $operation['vis_action']!='') || isset($operation['vis_submit']) && $operation['vis_submit']!=''){
			if(isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				} 
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				$data['department_id'] = (isset($data['department_id']))? $data['department_id']:'';
				if ($data['duration'] == 0 && $data['department_id'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['department_id'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDEPARTMENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['department_id'] != '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$dept_ids = implode(',',$data['department_id']);
				$chk_dept = ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN('.$dept_ids.')';
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'ticket.receive_date between '.$from.' AND '.$to. $chk_dept .' and ('.VIS_TABLE_PREFIX.'auditlog.operation_id <=2 or '.VIS_TABLE_PREFIX.'auditlog.operation_id=50 or '.VIS_TABLE_PREFIX.'auditlog.operation_id = 51) and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object       = new class_report($database);
			$total_post   = $total_time = $reply_count = $totalavg_time = 0;$maintain_date_nw1 =0;$maintain_date_nw = 0;
			$total_ticket = array();
			$filter .= ' and '.VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 ';
			list($total, $post_details) = $object->get_performance_report($filter, '', $staff_id, VIS_LOCATION_AREA);
			$previous_replier = $first_staffreplytime = $submitter = 0; $old_ticket_id=0; $clientreply = 0; $old_ticket_id_old = 0;
			$report_new = array();
			$array_summary = array();
			if($post_details!=-1){
				for($i=0;$i<count($post_details);$i++){   
					if($old_ticket_id_old != $post_details[$i]['ticket_id']){
						$maintain_date_nw1 = $submitter= $maintain_date_nw = 0;
						$clientreply=0;
						$report[$post_details[$i]['ticket_id']]['count']=0;
						$report[$post_details[$i]['ticket_id']]['post_date']=0;
					}
					$report[$post_details[$i]['ticket_id']]['timestamp'] = 0; 
					if( $post_details[$i]['operation_id']==0 && $post_details[$i]['as_client']==1)$clientreply++;
					if($post_details[$i]['operation_id']==0 && $post_details[$i]['operator']==1){
						$report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date'];
						$submitter = $post_details[$i]['operator'];
						$clientreply++;
					} else if($post_details[$i]['operation_id']==1 && $post_details[$i]['operator']==1) {  
						$report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date']; 
					 	if(($old_ticket_id == $post_details[$i]['ticket_id'] )&& $clientreply>0){
					 	$maintain_date_nw1 = $maintain_date_nw;  }else { $maintain_date_nw1=0; }
						$clientreply++;
					} else if($post_details[$i]['operation_id']==50){
						$report[$post_details[$i]['ticket_id']]['pause_date']=$post_details[$i]['entry_date'];
					} else if($post_details[$i]['operation_id']==51){
						$report[$post_details[$i]['ticket_id']]['resume_date']=$post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['slapause_diff'] += $post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['pause_date'];
					} else if($post_details[$i]['operation_id']==1 && $post_details[$i]['operator']!=1){  
						if($submitter == $post_details[$i]['operator'] && $post_details[$i]['as_client']==0&&(!isset($report[$post_details[$i]['ticket_id']]['count'])||$report[$post_details[$i]['ticket_id']]['count']==0)){
							if (!isset($report[$post_details[$i]['ticket_id']]['maintain_date'])){
								$report[$post_details[$i]['ticket_id']]['maintain_date'] = 0;
								$report[$post_details[$i]['ticket_id']]['count'] = 0;
							}
							else{
								$report[$post_details[$i]['ticket_id']]['maintain_date'] += 0;
								$report[$post_details[$i]['ticket_id']]['count']+=0;
							}
						} //else { 
							$report[$post_details[$i]['ticket_id']]['post_date']=(isset($report[$post_details[$i]['ticket_id']]['post_date']))?$report[	$post_details[$i]['ticket_id']]['post_date']:0; 
							if($report[$post_details[$i]['ticket_id']]['post_date'] > 0)
							{
								$maintain_date = $post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['post_date'];
								if ($post_details[$i]['custsla_count']!=0&&$report[$post_details[$i]['ticket_id']]['count']==0)
								$maintain_date_nw = $post_details[$i]['entry_date'] - $post_details[$i]['applyslarespo_time'];
								else
								$maintain_date_nw = $post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['post_date'];
							}
							$maintain_date_nw = $maintain_date_nw + $maintain_date_nw1;
							
							$report[$post_details[$i]['ticket_id']]['count']++;
						//}
						$old_ticket_id = $post_details[$i]['ticket_id'];
						$submitter = $post_details[$i]['operator'];
						$total_post++;
					} else {
						$submitter = $post_details[$i]['operator'];
					}
					 $old_ticket_id_old = $post_details[$i]['ticket_id'];
					if (!isset($report[$post_details[$i]['ticket_id']]['start_time'])) { 
						$report[$post_details[$i]['ticket_id']]['ticket_hash']		= $post_details[$i]['ticket_hash'];
						$report[$post_details[$i]['ticket_id']]['subject']			= $post_details[$i]['subject'];
						$report[$post_details[$i]['ticket_id']]['ticket_entry']		= $post_details[$i]['receive_date'];
						$report[$post_details[$i]['ticket_id']]['start_time']		= $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['ticket_priority']	= $post_details[$i]['ticket_priority'];
						$report[$post_details[$i]['ticket_id']]['department_name']	= $post_details[$i]['department_name'];
						$report[$post_details[$i]['ticket_id']]['first_name']		= $post_details[$i]['first_name'];
						$report[$post_details[$i]['ticket_id']]['last_name']		= $post_details[$i]['last_name'];
						$report[$post_details[$i]['ticket_id']]['email']			= $post_details[$i]['email'];
						$report[$post_details[$i]['ticket_id']]['group_name']		= $post_details[$i]['group_name'];
						$report[$post_details[$i]['ticket_id']]['ticket_id']		= $post_details[$i]['ticket_id'];
						$report[$post_details[$i]['ticket_id']]['post_date']		= $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['operator']			= $post_details[$i]['operator'];
						$report[$post_details[$i]['ticket_id']]['as_client']	  	= $post_details[$i]['as_client'];
						$report[$post_details[$i]['ticket_id']]['applyslaresol_time'] = $post_details[$i]['applyslaresol_time'];
						$report[$post_details[$i]['ticket_id']]['slaplan_id'] 		= $post_details[$i]['slaplan_id'];
						$report[$post_details[$i]['ticket_id']]['due_time'] 		= $post_details[$i]['due_time'];
						$report[$post_details[$i]['ticket_id']]['last_replier_time'] = $post_details[$i]['last_replier_time'];
						$report[$post_details[$i]['ticket_id']]['pause_dtime'] 		= $post_details[$i]['pause_dtime'];
						$report[$post_details[$i]['ticket_id']]['slapause_diff'] 	= 0;
						$report[$post_details[$i]['ticket_id']]['maintain_date'] 	= 0;
						$report[$post_details[$i]['ticket_id']]['count']         	= 0;
						$total_post= 0;
						$report[$post_details[$i]['ticket_id']]['clientreplycnt']   = $clientreply;
					} elseif($post_details[$i]['old_info']!=''){					
						$total_sla_seconds = ($post_details[$i]['due_time'] - $report[$post_details[$i]['ticket_id']]['post_date']);
						$sla_response_time = round($maintain_date_nw);
						$report[$post_details[$i]['ticket_id']]['used_sla_seconds'] = $sla_response_time;
						$report[$post_details[$i]['ticket_id']]['timestamp'] = $sla_response_time;
						$report[$post_details[$i]['ticket_id']]['clientreplycnt']   = $clientreply;
						$submitter = $post_details[$i]['operator'];
						$total_time += $sla_response_time;
					}
				} 
				if(!isset($operation['vis_export']) || $operation['vis_export'] != 1){	
					foreach (array_slice($report, $limit, $view_info['page_count']) as $p){
						$report_new[] = $p;
					}
				}	
			} else {
				$report = -1;
			}
			$view_info['page']=$page;
			$avgTimeCountt=0;
			$report_count=($report_new!=-1 || !empty($report_new)) ? count($report_new) : 0;
			$view_info['page_count']=($report==-1)? 0 : ceil(count($report)/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			$total_post_count = $avgTimeCount = 0;
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j  =  $replied_ticket_cnt = 0;
				foreach ($report as $i) {
					foreach ($i as $key => $val) {
						if ($key == 'ticket_hash' || $key == 'subject'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'ticket_entry') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);  
						} elseif ($key == 'timestamp'){
							if($val != 0) $report_exp[$j]['avg_response_time'] = (($val - $i['slapause_diff'])/$i['count']);
							else $report_exp[$j]['avg_response_time'] = "0S";
						} elseif ($key == 'first_name' || $key == 'last_name' || $key == 'email' || $key == 'group_name'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'clientreplycnt'){
							$report_exp[$j][$key] = $val;
						}
					}
					$report_exp1[$j]['incident_hash']= $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['subject']= $report_exp[$j]['subject'];
					$report_exp1[$j]['client_name']= $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email']= $report_exp[$j]['email'];
					$report_exp1[$j]['organization']= $report_exp[$j]['group_name'];
					$report_exp1[$j]['creation_date']= $report_exp[$j]['ticket_entry'];
					$report_exp1[$j]['clientreplycnt'] = $report_exp[$j]['clientreplycnt'];
					
					if($report_exp1[$j]['clientreplycnt']!=0) $avgTimeCountt += (int)$report_exp[$j]['avg_response_time'];
					if($i['count']==0&&$i['operator']==2&&$i['as_client']==0){
						$report_exp1[$j]['avg_response_time']= '0S';
					}elseif($i['count']==0){
						$report_exp1[$j]['avg_response_time']= $vis_language['TXTNOTRESPONDED'];
					} else {
						$report_exp1[$j]['avg_response_time']= count_remain_time(round($report_exp[$j]['avg_response_time']));
					}
					if($report_exp1[$j]['clientreplycnt']==0) {$report_exp1[$j]['avg_response_time'] = '0S';}
					if($report_exp1[$j]['clientreplycnt']!=0) $avgTimeCount += round($report_exp[$j]['avg_response_time']);
					if($i['count']!=0){
						$replied_ticket_cnt++;
					}
					$j++;
					$total_post += $i['count'];
					$total_post_count += $i['count'];
				}

				if($report!=-1){
					$total_ticket_cnt=count($total_ticket);
					$avgTimeCount =count_remain_time($avgTimeCount);
					$avgTimeCounttt =count_remain_time(round($avgTimeCountt/$replied_ticket_cnt));
					$report_exp1[$j]['totalpostcount']=$vis_language['TXTTOTALPOSTCOUNT'].": ".$total_post_count;
					$report_exp1[$j]['totalreplied']=$vis_language['TXTTOTALTICKETSREPLIED'].": ".$replied_ticket_cnt;
					$report_exp1[$j]['avgreponsetime']=$vis_language['TXTTOTALAVGRESPONSETIME'].": ".(($avgTimeCounttt=='') ? '0' :$avgTimeCounttt);
					$avgTimeCount =count_remain_time(round($total_time/$replied_ticket_cnt));
				}

				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);	
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
			/* summary count start */
			if($report!=-1) {
				$counter=0;
				$total_time=0;
				$replied_ticket_cnt = 0;
				$total_post_count = 0;
				$submitter = 0;
			    $allpostcount=0;
				foreach($report as $ticket_id => $details) {
					$counter++;
					if(isset($details['slapause_diff'])){ $sla_diff = $details['slapause_diff'];}else{ $sla_diff = 0;}
					if($submitter == $details['operator']){
						if($details['count']==0){
							$total_post_count += 0;
							$replied_ticket_cnt+=0;
						}else{
							$total_post_count += 1;
							$replied_ticket_cnt+=1;
						}
						if($details['clientreplycnt']!=0) $total_time += ($details['timestamp']-$sla_diff);
					}else{
						$total_post_count += $details['count'];
						if($details['count']!=0){
							$replied_ticket_cnt+=1;
							if($details['clientreplycnt']!=0) $total_time += ($details['timestamp']-$sla_diff)/$details['count'];
						}
					}
					 if(($details['timestamp']==0 || $details['timestamp']<0) && $details['count']!=0)
				{  } elseif($details['count']==0) {  }
				else {	$allpostcount+=$details['count'];} 
				}
			    $avgTimeCount =($total_time != '')? count_remain_time(round($total_time/$replied_ticket_cnt)): '';
			    $array_summary['TXTTOTALPOSTCOUNT'] = $allpostcount;
			    $array_summary['TXTTOTALTICKETSREPLIED'] = $replied_ticket_cnt;
			    $array_summary['TXTTOTALAVGRESPONSETIME'] = ($total_time==0 ? '0' :(($avgTimeCount > 0) ? $avgTimeCount : '0 S'));
			}
			/* summary count end */
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function resolution_report($operation)
	{	
		global $vis_language;
		$report_title = $vis_language['TXTAVGRESOLUTIONTIME'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type = 149;
		$export = 1;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object       = new class_ticket($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$departments      = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']);
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='resolution_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				$data['department_id'] = (isset($data['department_id']))? $data['department_id']:0;
				if ($data['duration'] == 0 && $data['department_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['department_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDEPARTMENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['department_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');				 
				$dept_ids = implode(',',$data['department_id']);
				$chk_dept = ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN('.$dept_ids.')';
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];                    
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];                   
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = '(operation_id<=2 or operation_id=50 or operation_id=51) and receive_date between '.$from.' AND '.$to.$chk_dept;
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$filter .= ' and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and ('.VIS_TABLE_PREFIX.'ticket.status_id=3 OR '.VIS_TABLE_PREFIX.'ticket.status_id=4)';
			$post_details    = $object->get_sla_report($filter, '', $staff_id, VIS_LOCATION_AREA);
			$report_avg      = $report_cnt = $resolutionCount =$entry_date = $entry_dateee=0;
			$maintain_date_nw1 = $maintain_date_nw=0;
			$replied         = array();
			$new_info		 = '';
			if ($post_details != -1){				
			for($i=0;$i<count($post_details);$i++){				 
				if (!isset($report[$post_details[$i]['ticket_id']]['start_time'])) {
					$report[$post_details[$i]['ticket_id']]['ticket_hash']    = $post_details[$i]['ticket_hash'];
					$report[$post_details[$i]['ticket_id']]['subject']        = $post_details[$i]['subject'];
					$report[$post_details[$i]['ticket_id']]['ticket_entry']   = $post_details[$i]['receive_date'];
					$report[$post_details[$i]['ticket_id']]['start_time']     = $post_details[$i]['entry_date'];		 
					$report[$post_details[$i]['ticket_id']]['ticket_id']      = $post_details[$i]['ticket_id'];	
					$report[$post_details[$i]['ticket_id']]['status_id']      = $post_details[$i]['status_id'];
					$report[$post_details[$i]['ticket_id']]['remain_resolve'] = $post_details[$i]['remain_resolve'];
					$report[$post_details[$i]['ticket_id']]['resolve_time']   = $post_details[$i]['resolution_time'];
					$report[$post_details[$i]['ticket_id']]['department_name'] = $post_details[$i]['department_name'];	 
					$report[$post_details[$i]['ticket_id']]['closed_time']	  = $post_details[$i]['closed_time'];
					$report[$post_details[$i]['ticket_id']]['pause_rtime']	  = $post_details[$i]['pause_rtime'];
					$report[$post_details[$i]['ticket_id']]['applyslaresol_time'] = $post_details[$i]['applyslaresol_time'];
					$report[$post_details[$i]['ticket_id']]['count']          = 0;
					$report[$post_details[$i]['ticket_id']]['tcount']          = $post_details[$i]['tcount'];
					$report[$post_details[$i]['ticket_id']]['lastrepliertime'] = $post_details[$i]['lastrepliertime'];
					$report[$post_details[$i]['ticket_id']]['solve_time']     = 0;
					$report[$post_details[$i]['ticket_id']]['maintain_date']  = 0;
					$report[$post_details[$i]['ticket_id']]['slapause_diff']  = 0;
					$report[$post_details[$i]['ticket_id']]['total_sla_seconds'] = 0;
					$report[$post_details[$i]['ticket_id']]['used_sla_seconds'] = 0;				 
					$total_post= 0;
				}elseif($post_details[$i]['old_info']!=''){
					$submitter = $post_details[$i]['operator'];
					$new_info = ($post_details[$i]['new_info']!='' && is_string($post_details[$i]['new_info'])) ? $post_details[$i]['new_info'] : '';
					$entry_date = $post_details[$i]['entry_date'];
					$report[$post_details[$i]['ticket_id']]['auditlogentry_date'] = $entry_date;				
				}
			}
		}else{
				$report = -1;
			 }
			$report_new = array();
			$totrepltime=0;
			$avgtotrepltime=array(); 
			$tempResolvedtime=$totalResolvedCount=$totalResolvedtime=$tcount=0;			 
			$responseCount=$ttttcountclosansresolv=0;
			if ($report != -1) { 
				foreach ($report as $ticket_id => $details) { 
					$isUndueSet = 0;				  
						if(isset($details['status_id']) && $details['status_id']==3 && ( isset($details['closed_time']) && $details['closed_time']!='')){
						$totrepltime = $details['closed_time'] - $details['lastrepliertime'];						 
						}					
					if($details['pause_rtime'] == ''){
					if($details['closed_time']=='' && $details['status_id']==4 && is_string($new_info)){
						if($details['applyslaresol_time']>0)
						$calculate_resolve_time = $details['auditlogentry_date'] - $details['applyslaresol_time'];
					} else {
						$calculate_resolve_time = $details['resolve_time'] - (isset($details['closed_time']))? $details['closed_time'] :0;
					}
					if ($details['resolve_time'] < 0 && ($details['status_id'] == 3 || $details['status_id'] == 4)) {
						$isUndueSet = 0;			
						$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTUNDUE'];
					} else if (($details['resolve_time'] < 0 || $details['remain_resolve'] < 0) && $details['status_id'] != 3  && $details['status_id']!=4) {  
						$isUndueSet                                = 0;
						if($details['pause_rtime'] != ''){$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTNOTMAINTAIN'];}else{  
						$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTOVERDUE'];}
					} else if (($details['resolve_time'] > 0 || $details['remain_resolve'] > 0) && $details['status_id']!=3  && $details['status_id']!=4) {
						$isUndueSet                                = 0;
						if($details['count']!= 0){
							$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTUNDUE'];
						} else {
							$report[$ticket_id]['avg_resolution_time'] = $vis_language['MSGNOTRESOLVED'];
						}						 
					} else {
						$isUndueSet = 1;
						if($calculate_resolve_time > 0){
							if($details['count']!=0)
								$resolutionCount++;
						}
						if(isset($details['status_id']) && ($details['status_id']==4 || $details['status_id']==3)){
							if($details['applyslaresol_time']>0){
								$report[$ticket_id]['avg_resolution_time'] = count_remain_time($details['closed_time'] - $details['applyslaresol_time']);
								$tempResolvedtime = $details['closed_time'] - $details['applyslaresol_time'];
							}
							else {
								$report[$ticket_id]['avg_resolution_time'] = count_remain_time($details['closed_time'] - $details['ticket_entry']);
								$tempResolvedtime = $details['closed_time'] - $details['ticket_entry'];
							}
							$totalResolvedtime += $tempResolvedtime;
							$totalResolvedCount+=1;
						}
					}	
				}
				} 
				foreach (array_slice($report, $limit, $view_info['page_count']) as $p) {
					$report_new[] = $p;
				}
			}
			$array_summary=array();
			$array_summary['TXTTOTCLSRESINCIDENT']=$totalResolvedCount;
			$array_summary['TXTTOTALAVGRESOLUTIONTIME']= (($totalResolvedtime==0)?0:count_remain_time($totalResolvedtime/$totalResolvedCount)); 
			$total=$total_cnt = ($report!=-1)? count($report):0;
			$view_info['page']=$page;
			$report_count=($report_new!=-1 || !empty($report_new)) ? count($report_new) : 0;
			$view_info['page_count']=($report==-1||count($report)==0)? 0 : ceil(count($report)/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				$replied_ticket_cnt = 0;
				$replied_ticket_cnttt = 0;
				$tcounttt=0;
				$rescounttt=0;
				$resolvecounttt=0;
				 
				foreach ($report as $i) {
					foreach ($i as $key => $val) {
						 if ($key == 'ticket_hash') {
						 	$report_exp[$j][$key] = $val;							
						}elseif ($key == 'subject'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'ticket_entry') {							
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'avg_resolution_time'){
							$report_exp[$j][$key] = $val;
						}   
					}					 
					$report_exp1[$j]['incident_hash']=$report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['subject']=$report_exp[$j]['subject'];				 					 
					$report_exp1[$j]['Creation_date']=$report_exp[$j]['ticket_entry'];					 
				 	$resolution_flag = ($report_exp[$j]['pause_rtime']!='') ? $report_exp[$j]['pause_rtime'] : '';
				  	$report_exp1[$j]['resolution_time']=$report_exp[$j]['avg_resolution_time'];					  
									  		
					$j++;
				}
				if($report != -1) { 
					$report_exp1[$j]['totalticket']=	$vis_language['TXTTOTCLSRESINCIDENT'].": ".$totalResolvedCount;
					$report_exp1[$j]['totalresulationmainten']=	$vis_language['TXTTOTALAVGRESOLUTIONTIME'].": ".(($totalResolvedtime==0)?0:count_remain_time($totalResolvedtime/$totalResolvedCount));
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database); 
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total_cnt,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE.'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function dept_report($operation)
	{	
		global $vis_language;
		$report_title = $vis_language['TXTTOTALTICKETSRESOLVED'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type = 43;
		$export = 1;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object       = new class_ticket($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$departments      = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$ticket_module=new ticket($database);
		$status=$tkt_object->get_status_list('is_enabled=1 and (status_id=3 or status_id=4)', $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='dept_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if((isset($operation['vis_action']) && $operation['vis_action']!='') || isset($operation['vis_submit']) && $operation['vis_submit']!=''){
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$data['department_id'] = (isset($data['department_id']))? $data['department_id']:'';
				if ($data['department_id'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDEPARTMENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['department_id'] != '' && $data['department_id'] != 0) {
					$dept_ids = implode(',',$data['department_id']);
					$depfilter = ' and ' .VIS_TABLE_PREFIX.'ticket.department_id IN(' .$dept_ids.')';
				} else {
					$dept_access = '(';
					for ($i = 0; $i < count($departments); $i++) {
						$dept_access .= $departments[$i]['department_id'] . ',';
					}
					$dept_access = substr($dept_access, 0, -1);
					$dept_access .= ')';

					$depfilter = ' and ' .VIS_TABLE_PREFIX.'ticket.department_id in ' . $dept_access;
				}
				$data['vis_status'] = (isset($data['vis_status']))? $data['vis_status']:'';
				if ($data['vis_status'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTSTATUS']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];	
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;								
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				if($data['serach_by']==1){						
					$filter = 'operation_id=2 and receive_date between ' . $from . ' AND ' . $to . ' ' . $depfilter.' and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 and is_deleted = 0';
				}else if($data['serach_by']==2){						
					$filter = 'operation_id=2  and entry_date between ' . $from. ' AND ' . $to . ' '. $depfilter.' and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 and is_deleted = 0';
				}

				if ($data['vis_status'] != '' && $data['vis_status'] != 0) {
					$status_ids = implode(',',$data['vis_status']);
					$filter .= ' and ' .VIS_TABLE_PREFIX.'ticket.status_id IN(' .$status_ids.') and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
				}
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
			$object_setting = new class_setting($database);
			$custom_filter = ' (location=1 or location=2 or location=11) and is_enabled=1';
			/*$custom_grouplist = $object_setting->get_custom_group_list($custom_filter, $staff_id, VIS_LOCATION_AREA);*/
			$filter .= ' and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1';
			list($total_cnt, $post_details) = $object->get_dept_report($filter, $limit, $staff_id, VIS_LOCATION_AREA); 
			$total =$total_cnt;
			$view_info['page']=$page;
			$report_count=($post_details!=-1) ? count($post_details) : 0;
			$view_info['page_count']=($total_cnt==0) ? 0 : ceil($total_cnt/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			if ($post_details != -1){
				for ($i = 0; $i < count($post_details); $i++) {
					if (!isset($report[$post_details[$i]['ticket_id']]['start_time'])) {
						$report[$post_details[$i]['ticket_id']]['first_name']   = $post_details[$i]['first_name'];
						$report[$post_details[$i]['ticket_id']]['last_name']   = $post_details[$i]['last_name'];
						$report[$post_details[$i]['ticket_id']]['fname']   = $post_details[$i]['fname'];
						$report[$post_details[$i]['ticket_id']]['lname']   = $post_details[$i]['lname'];
						$report[$post_details[$i]['ticket_id']]['email']   = $post_details[$i]['email'];
						$report[$post_details[$i]['ticket_id']]['group_name']   = $post_details[$i]['group_name'];
						$report[$post_details[$i]['ticket_id']]['applyslaresol_time']   = $post_details[$i]['applyslaresol_time'];
						$report[$post_details[$i]['ticket_id']]['ticket_hash']  = $post_details[$i]['ticket_hash'];
						$report[$post_details[$i]['ticket_id']]['subject']      = $post_details[$i]['subject'];
						$report[$post_details[$i]['ticket_id']]['ticket_entry'] = $post_details[$i]['receive_date'];
						$report[$post_details[$i]['ticket_id']]['closed_time'] = $post_details[$i]['closed_time'];
						$report[$post_details[$i]['ticket_id']]['resolution_time'] = $post_details[$i]['resolution_time'];
						$report[$post_details[$i]['ticket_id']]['ticket_closed'] = $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['ticket_id']    = $post_details[$i]['ticket_id'];
						$report[$post_details[$i]['ticket_id']]['status_id']    = $post_details[$i]['status_id'];
						$report[$post_details[$i]['ticket_id']]['pause_rtime']  = $post_details[$i]['pause_rtime'];
						$report[$post_details[$i]['ticket_id']]['count']        = 0;
						$report[$post_details[$i]['ticket_id']]['status_name']  = $post_details[$i]['status_name']; 
						 
						 
						if($report[$post_details[$i]['ticket_id']]['pause_rtime'] == '' || $report[$post_details[$i]['ticket_id']]['pause_rtime']==null){
							$resolution_time = round($post_details[$i]['resolution_time'] - $post_details[$i]['entry_date']);
							if($resolution_time >= 0){
								$report[$post_details[$i]['ticket_id']]['resolution_sla'] =$vis_language['TXTMAINTAIN'];
							}else{
								$report[$post_details[$i]['ticket_id']]['resolution_sla'] =	$vis_language['TXTNOTMAINTAIN'];
							}					  
						}else {
							$report[$post_details[$i]['ticket_id']]['resolution_sla'] =	$vis_language['MSGNOTRESOLVED'];
						}
					}
				} 
			} else {
				$report = -1;
			}
			$array_summary=array();
			$array_summary['TXTTOTALTICKETSRESOLVED']=$total_cnt;
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j=0;
				$report_exp1=array();
				$report_exp=array();
				if($report != -1)
				{
				foreach ($report as $i){
					foreach ($i as $key => $val){
						if ($key == 'ticket_entry'|| $key == 'ticket_closed' ){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'ticket_hash' || $key == 'subject' || $key == 'closed_time' || $key == 'resolution_time' || $key == 'status_name' || $key == 'first_name' || $key == 'last_name'|| $key == 'fname' || $key == 'lname' || $key == 'email' || $key == 'group_name' || $key == 'resolution_sla'){
							$report_exp[$j][$key] = $val;
						}
					}
					if($report_exp[$j]['first_name']=='' && $report_exp[$j]['last_name']==''){
						$report_exp[$j]['first_name'] = $vis_language['TXTUNASSIGNE'];	
					} 						
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['staff'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['client_name'] = $report_exp[$j]['fname'].' '.$report_exp[$j]['lname'];
					$report_exp1[$j]['email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					$report_exp1[$j]['creation_date'] = $report_exp[$j]['ticket_entry'];
					$report_exp1[$j]['closing_date'] = $report_exp[$j]['ticket_closed'];
					$report_exp1[$j]['status'] = $report_exp[$j]['status_name'];
					
					 
					
					if (($report_exp[$j]['resolution_time']< $report_exp[$j]['closed_time']) && $report_exp[$j]['closed_time']!=0 &&  $report_exp[$j]['resolution_time']!=0){
						$report_exp1[$j]['afteroverdue_time'] = count_remain_time($report_exp[$j]['closed_time']-$report_exp[$j]['resolution_time']);
					}else{
						$report_exp1[$j]['afteroverdue_time']='0s';
					}							 
					$report_exp1[$j]['resolution_sla'] = $report_exp[$j]['resolution_sla'];			
					$j++;
				}
				$report_exp1[$j]['total_ticket_close']=$vis_language['TXTTOTALTICKETSRESOLVED'].': '.count($report);
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);	
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total_cnt,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function not_answered_ticket_report($operation) // not answered ticket
	{	
		global $vis_language;
		$report_title = $vis_language['TXTNOTANSWEREDTICKET'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type = 40;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object  = new class_ticket($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$departments = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page'])) ? $operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='not_answered_ticket_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				$data['department_id'] = (isset($data['department_id'])) ?$data['department_id']:0;
				if ($data['duration'] == 0 && $data['department_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['department_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDEPARTMENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['department_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$dept_ids = implode(',',$data['department_id']);
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = 'receive_date between ' . $from . ' AND ' . $to . ' and department_id IN(' . $dept_ids.') and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$filter .= ' and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1';
			list($total_rec, $report) = $object->get_not_answered_ticket($filter, $limit, $staff_id, VIS_LOCATION_AREA);
			$total =$total_rec;
			$view_info['page']=$page;
			$view_info['view_count']= $total_rec;
			$report_count=($report!=-1)? count($report) : 0;
			$view_info['page_count']=($total_rec==0)?0:ceil($total_rec/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
			$sett_obj = new class_setting($database);
			$custom_filter = ' (location=1 or location=2 or location=11) and is_enabled=1';
			/*$custom_grouplist = $sett_obj->get_custom_group_list($custom_filter, $staff_id, VIS_LOCATION_AREA);*/
			$array_summary = array();
			
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j=0;
				foreach ($report as $i){
					foreach ($i as $key => $val){
						if($key == 'ticket_hash'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'subject'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'contact_number'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'receive_date'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif($key == 'first_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'last_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'email'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'group_name'){
							$report_exp[$j][$key] = $val;
						}
					}
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash']; 
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject']; 
					$report_exp1[$j]['contact_number'] = $report_exp[$j]['contact_number']; 
					$report_exp1[$j]['creation_date'] = $report_exp[$j]['receive_date'];
					$report_exp1[$j]['client_name'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name']; 
					$report_exp1[$j]['email'] = $report_exp[$j]['email']; 
					$report_exp1[$j]['Organization'] = $report_exp[$j]['group_name'];					
					$j++;
				}
				if($report!=-1){
					$report_exp1[$j]['total_unanswered_tickets'] =$vis_language['TXTNOTANSWEREDTICKET'].': '.$total_rec;
				}

				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);	
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				$array_summary['TXTNOTANSWEREDTICKET']=$total_rec;
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total_rec,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function total_unanswered_service_request($operation){
		global $vis_language;
		$report_title = $vis_language['TXTNOTANSSERREQ'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();

		$report_type = 163;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object  = new class_ticket($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$departments = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page'])) ? $operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='total_unanswered_service_request';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				$data['department_id'] = (isset($data['department_id'])) ?$data['department_id']:0;
				if ($data['duration'] == 0 && $data['department_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['department_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDEPARTMENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['department_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$dept_ids = implode(',',$data['department_id']);
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = 'receive_date between ' . $from . ' AND ' . $to . ' and department_id IN(' . $dept_ids.') and '.VIS_TABLE_PREFIX.'ticket.channel_id=7 ';
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$filter .= ' and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1';
			list($total, $report) = $object->get_not_answered_ticket($filter, $limit, $staff_id, VIS_LOCATION_AREA);
			$view_info['page']=$page;
			$view_info['view_count']= $total;
			$report_count=($report!=-1)? count($report) : 0;
			$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j=0;
				foreach ($report as $i){
					foreach ($i as $key => $val){
						if($key == 'ticket_hash'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'subject'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'contact_number'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'receive_date'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif($key == 'first_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'last_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'email'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'group_name'){
							$report_exp[$j][$key] = $val;
						}
					}
					$report_exp1[$j]['service_request_hash'] = $report_exp[$j]['ticket_hash']; 
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject']; 
					$report_exp1[$j]['contact_number'] = $report_exp[$j]['contact_number']; 
					$report_exp1[$j]['creation_date'] = $report_exp[$j]['receive_date'];
					$report_exp1[$j]['client_name'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name']; 
					$report_exp1[$j]['email'] = $report_exp[$j]['email']; 
					$report_exp1[$j]['Organization'] = $report_exp[$j]['group_name'];
					$j++;
				}
				if($report!=-1){
					$report_exp1[$j]['total_unanswered_tickets'] =$vis_language['TXTNOTANSWEREDTICKET'].': '.$total;
				}

				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);	
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function time_tracking_department_report($operation)
	{	   
		global $vis_language;
		$report_title = $vis_language['TXTTRACKINGDEPT'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();

		$export      = 1;
		$report_type = 10;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object  = new class_ticket($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$departments = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		$domain_data     = $tkt_object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id=' . $departments[0]['domain_id'], $staff_id, VIS_LOCATION_AREA);
		$currencyVal           = $domain_data[0]['currency'];
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='time_tracking_department_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if((isset($operation['vis_action']) && $operation['vis_action']!='') || isset($operation['vis_submit']) && $operation['vis_submit']!=''){
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$d_filter = explode('IN',$filter); 
				$dept_ids = str_replace('(','',substr($d_filter[1],0,-1));
				$data = $operation;
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				$data['department_id'] = (isset($data['department_id']))? $data['department_id']:0;
				if ($data['duration'] == 0 && $data['department_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['department_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDEPARTMENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['department_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				
				
				$currentdate = date('Y-m-d H:i:s');
				$dept_ids = implode(',',$data['department_id']);
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = 'created_date between ' . $from . ' AND ' . $to . ' and  department_id  IN(' . $dept_ids.')';
			}
			$department_details = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'department.department_id IN(' . $dept_ids.')', $staff_id, VIS_LOCATION_AREA);
			$domain_details     = $tkt_object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id=' . $department_details[0]['domain_id'], $staff_id, VIS_LOCATION_AREA);
			$currency           = $domain_details[0]['currency'];
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
			$object_setting    = new class_setting($database);
			$module_setting = $object_setting->get_settings(' module_id=2 and title="vis_show_time_track_amount" and domain_id=' . $domain_details[0]['domain_id'], $staff_id, VIS_LOCATION_AREA);
			if (empty($module_setting) || $module_setting == -1) {
				$module_setting = $object_setting->get_settings(' module_id=2 and title="vis_show_time_track_amount" and domain_id=0', $staff_id, VIS_LOCATION_AREA);
			}
			$amountshowflag = 1;
			if ($module_setting != -1) {
				$amountshowflag = $module_setting[0]['content'];
			}
			$custom_filter = ' (location=1 or location=2 or location=11) and is_enabled=1';
			/*$custom_grouplist = $object_setting->get_custom_group_list($custom_filter, $staff_id, VIS_LOCATION_AREA);*/
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object          = new class_report($database);

			$filter .= ' and '.VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
			list($total_cnt, $post_details) = $object->get_time_tracking_department_report($filter, $limit, $staff_id, VIS_LOCATION_AREA);
			$total = ($total_cnt==-1)? 0:count($total_cnt);
			$total_count_report=($total_cnt==-1)? 0:count($total_cnt);
			$total_bill_time=$total_work_time=$total_amount=0;
			for($m = 0; $m < $total; $m++){
				$total_bill_time += $total_cnt[$m]['bill_time'];
				$total_work_time += $total_cnt[$m]['work_time'];
				$total_amount	 += $total_cnt[$m]['amount'];
			}
			$array_summary=array();
			$array_summary['TXTTOTALBILLTIME']=$total_bill_time.' ('.$vis_language['TXTMIN'].')';
			$array_summary['TXTTOTALWORKTIME']=$total_work_time.' ('.$vis_language['TXTMIN'].')';
			$array_summary['TXTTOTALAMOUNT']=number_format($total_amount,2).' '.$currency;

			$view_info['page']=$page;
			$report_count=($post_details!=-1) ? count($post_details) : 0;
			$view_info['page_count']=($total_cnt==-1)?0:ceil(count($total_cnt)/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			if ($post_details != -1){
				for ($i = 0; $i < count($post_details); $i++) {
					$report[$i]['ticket_hash']     = $post_details[$i]['ticket_hash'];
					$report[$i]['subject']     = $post_details[$i]['subject'];
					$report[$i]['ticket_id']       = $post_details[$i]['ticket_id'];
					$report[$i]['client_id']       = $post_details[$i]['client_id'];
					$report[$i]['description']     = $post_details[$i]['description'];
					$report[$i]['first_name']     = $post_details[$i]['first_name'];
					$report[$i]['last_name']     = $post_details[$i]['last_name'];
					$report[$i]['email']     = $post_details[$i]['email'];
					$report[$i]['group_name']     = $post_details[$i]['group_name'];
					$report[$i]['bill_time']       = $post_details[$i]['bill_time'];
					$report[$i]['work_time']       = $post_details[$i]['work_time'];
					$report[$i]['amount']          = $post_details[$i]['amount'];
					$report[$i]['created_date']    = $post_details[$i]['created_date'];
					$report[$i]['staff_name']      = $post_details[$i]['staff_name'];
					$total_bill_time += $post_details[$i]['bill_time'];
					$total_work_time += $post_details[$i]['work_time'];
					$total_amount += $post_details[$i]['amount'];
				} 
			} else {
				$report = -1;
			}

			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
  				$currency = isset($currencyVal)?$currencyVal:'';
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				foreach ($report as $i) {
					foreach ($i as $key => $val) {
						if ($key == 'ticket_hash')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'subject')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'created_date')
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						elseif ($key == 'work_time')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'bill_time')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'amount')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'description')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'staff_name')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'first_name' || $key == 'last_name' || $key == 'email' || $key == 'group_name')
							$report_exp[$j][$key] = $val;
					}
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['description'] = $report_exp[$j]['description'];
					$report_exp1[$j]['staff'] = $report_exp[$j]['staff_name'];
					$report_exp1[$j]['client_name'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					$report_exp1[$j]['creation_date'] = $report_exp[$j]['created_date'];
					$report_exp1[$j]['bill_time'.'('.$vis_language['TXTMIN'].')'] = $report_exp[$j]['bill_time'];
					$report_exp1[$j]['work_time'.'('.$vis_language['TXTMIN'].')'] = $report_exp[$j]['work_time'];
					$report_exp1[$j]['amount'.' ('.$currency.')'] = $report_exp[$j]['amount'];
					$j++;
				}
				if($report!=-1){					
					foreach($array_summary as $key=>$val){
				 $report_exp1[$j][$vis_language[$key]]=$vis_language[$key] . ' : ' . ($vis_language[$key]==$vis_language['TXTTOTALAMOUNT']) ? $val. ' ' . $currency : $val; 
				}
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);	
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total_count_report,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}


	function ticket_activity_report($operation)
	{	
		global $vis_language;
		$report_title = $vis_language['TXTTICKETACTIVITY'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
			
		$report_type = 63;
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		$object=new class_ticket($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$ticket=$object->get_ticket($filter='', $limit='', $page='', $sort_by='', $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='ticket_activity_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$object = new class_report($database);
		if((isset($operation['vis_action']) && $operation['vis_action']!='') || isset($operation['vis_submit']) && $operation['vis_submit']!=''){
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['vis_new_ticket_list_client1'] == "") {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['vis_new_ticket_list_client1'] == "") {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTTICKETHASH']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['vis_new_ticket_list_client1'] != "") {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$dept_acc = $object->get_deptaccess_of_staff($staff_id);
				if($dept_acc!=-1){
					$filtr = ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN ('.$dept_acc.')';
				} else {
					$filtr = '';
				}
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = ''.VIS_TABLE_PREFIX.'auditlog.entry_date  between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'auditlog.ticket_hash='.'"' .$data['vis_new_ticket_list_client1'].'"';
				$filter .= " and ".VIS_TABLE_PREFIX."auditlog.access_id!=1 and ".VIS_TABLE_PREFIX."auditlog.access_id!=2 and ".VIS_TABLE_PREFIX."auditlog.access_id!=3 and ".VIS_TABLE_PREFIX."ticket.channel_id!=7 and ".VIS_TABLE_PREFIX."ticket.draft_id =0 ".$filtr;
			}
			list($total_cnt, $audit_log) = $object->ticket_activity($filter,$filter1='',$limit,$staff_id, VIS_LOCATION_AREA);
			$total =$total_cnt;
			if($audit_log!=-1) {
				$close_time=$audit_log[0]['closed_time'];
				$creation_time=$audit_log[0]['creation_date'];
				if($close_time!=0){
					$total_time=$audit_log[0]['closed_time']-$audit_log[0]['creation_date'];
				} else {
					$total_time='-'; //$vis_language['MSGNOTAPPLICABLE'];
				}
				$avgTimeCount = ($total_time != '-')? count_remain_time($total_time):'-';
			}
			$view_info['page']=$page;
			$view_info['view_count']= $total_cnt;
			$report_count=($audit_log!=-1)? count($audit_log) : 0;
			$view_info['page_count']=($total_cnt==0)?0:ceil($total_cnt/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			$report = $audit_log;
			for($i=0;$i<$report_count;$i++){
				switch($audit_log[$i]['operation_id']) {
					case '0':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGNEWTKTCRT'];
						break;
					case '1':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGTKTRPLD'];
						break;
					case '2':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTSTATUSCHANGEDFROM'].' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info'];
						break;
					case '3':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTPRIORITYCHANGEDFROM'].' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info'];
						break;
					case '4':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTDEPARTMENTCHANGEDFROM'].' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info'];
						break;
					case '5':
						$audit_log[$i]['audit_log_operation'] = ((isset($vis_language['TXTTICKETTYPECHANGEDFROM']))?$vis_language['TXTTICKETTYPECHANGEDFROM'] : '').' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info'];
						break;

					case '6':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTFLAGCHANGEDFROM'].' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info'];
						break;
					case '7':
						include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');  
						$object=new class_setting($database);
						$staff_new_info=$object->get_staff(VIS_TABLE_PREFIX.'staff.staff_id='.$audit_log[$i]['new_info'], '', '', '', $staff_id, VIS_LOCATION_AREA,1);
						$new_info =  $staff_new_info[1][0]['first_name'].' '.$staff_new_info[1][0]['last_name'];
						if($audit_log[$i]['new_info']!=0 && $staff_new_info[1]!=-1){
							$audit_log[$i]['audit_log_operation'] = $vis_language['MSGTKTASSIG'].' '.strtolower($vis_language['TXTTO']).' '. $new_info;
						} elseif($audit_log[$i]['new_info']==0 && $audit_log[$i]['old_info']>0){ 
							$staff_old_info=$object->get_staff(VIS_TABLE_PREFIX.'staff.staff_id='.$audit_log[$i]['old_info'], '', '', '', $staff_id, VIS_LOCATION_AREA,1);
							$old_info =  $staff_old_info[1][0]['first_name'].' '.$staff_old_info[1][0]['last_name'];
							$audit_log[$i]['audit_log_operation'] = $vis_language['TXTTICKETUNASSIGNEDFROM'].' '. $old_info;
						} else {
							$audit_log[$i]['audit_log_operation'] = $vis_language['TXTTICKETASSIGNEDTONOBODY'];
						}
						break;
					case '8':
						include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');  
						$object=new class_setting($database);
						$staff_details=$object->get_staff(VIS_TABLE_PREFIX.'staff.staff_id='.$audit_log[$i]['operator_id'], '', '', '', $staff_id, VIS_LOCATION_AREA);
						$staff_name =  $staff_details[1][0]['first_name'].' '.$staff_details[1][0]['last_name'];
						if($audit_log[$i]['old_info']!=0 ){
							$audit_log[$i]['audit_log_operation']=$vis_language['MSGTKTTRSH'];
						} elseif($audit_log[$i]['old_info']==0 ){ 
							$audit_log[$i]['audit_log_operation']=$vis_language['TXTTKTMOVEINBOCFROMTRASH'];
						}
						break;
					case '9':
						include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');  
						$object=new class_setting($database);
						$staff_details=$object->get_staff(VIS_TABLE_PREFIX.'staff.staff_id='.$audit_log[$i]['operator_id'], '', '', '', $staff_id, VIS_LOCATION_AREA);
						$staff_name =  $staff_details[1][0]['first_name'].' '.$staff_details[1][0]['last_name'];
						$audit_log[$i]['audit_log_operation']=$audit_log[$i+1]['old_info'] .' '.strtolower($vis_language['TXTDELETED']);
						break;
					case '10':
						include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
						$object=new class_ticket($database);
						$audit_log[$i]['audit_log_operation']=$audit_log[$i]['new_info'] .' '.strtolower($vis_language['TXTMERGEDTO']).' '.$audit_log[$i]['old_info'];
						break;
					case '11':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGTKTFRWD'];
						break;
					case '12':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGTKTDELETED'];
						break;
					case '13':
						include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');  
						$object=new class_setting($database);
						$sla_old_info=$object->get_sla(VIS_TABLE_PREFIX.'sla.sla_id='.$audit_log[$i]['old_info'], '', '', '', $staff_id, VIS_LOCATION_AREA);
						$sla_new_info=$object->get_sla(VIS_TABLE_PREFIX.'sla.sla_id='.$audit_log[$i]['new_info'], '', '', '', $staff_id, VIS_LOCATION_AREA);
						$old_info =  $sla_old_info[1][0]['sla_name'];
						$new_info =  $sla_new_info[1][0]['sla_name'];
						if($audit_log[$i]['new_info']!=0 && $audit_log[$i]['old_info']!=0){
							$audit_log[$i]['audit_log_operation'] = $vis_language['TXTSLACHANGEDFROM'].' '. $old_info. ' '.strtolower($vis_language['TXTTO']).' '. $new_info;
						} else if($audit_log[$i]['old_info']==0 && $audit_log[$i]['new_info']!=0){
							$audit_log[$i]['audit_log_operation'] = $vis_language['TXTSLASETTO'].' '. $new_info;
						} else if($audit_log[$i]['new_info']==0){
							$audit_log[$i]['audit_log_operation'] = $vis_language['TXTAPPLIEDCUSTOMSLAPLAN'];
						}
						break;
					case '14':
						if($audit_log[$i]['new_info']!=0 && $audit_log[$i]['old_info']==0){
							$audit_log[$i]['audit_log_operation']=$vis_language['MSGSPAMMRK'];
						} elseif($audit_log[$i]['new_info']==0 && $audit_log[$i]['old_info']!=0){
							$audit_log[$i]['audit_log_operation']=$vis_language['TXTNOTSPAMMARKED'];
						}
						break;
					case '15':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGUNSPAM'];
						break;
					case '16':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTNEWTASKATTACHED'].' '. $audit_log[$i]['old_info'];
						break;
					case '17':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTDETACHEDATTACHEDTASK'].' '. $audit_log[$i]['old_info'];
						break;
					case '18':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTNEWCIATTACHED'].' '. $audit_log[$i]['old_info'];
						break;
					case '19':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTDETACHEDATTACHEDCI'].' '. $audit_log[$i]['old_info'];
						break;
					case '20':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTNEWPROBLEMATTACHED'].' '. $audit_log[$i]['old_info'];
						break;
					case '21':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTDETACHEDATTACHEDPROBLEM'].' '. $audit_log[$i]['old_info'];
						break;
					case '22':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTNEWCHANGEATTACHED'].' '. $audit_log[$i]['old_info'];
						break;
					case '23':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTDETACHEDATTACHEDCHANGE'].' '. $audit_log[$i]['old_info'];
						break;	
					case '24':
						include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
						$object=new class_ticket($database);
						$audit_log[$i]['audit_log_operation']=$audit_log[$i]['new_info'] .' '.$vis_language['TXTLINKEDTO'].' '.$audit_log[$i]['old_info'];
						break;	
					case '25':
						include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
						$object=new class_ticket($database);
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGTICKETPOSTDELETE'];
						break;	
					case '26':
						include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
						$object=new class_ticket($database);
						$audit_log[$i]['audit_log_operation']=$vis_language['TXTTICKETPOSTSPLITWITH'].' '.$audit_log[$i]['new_info'];
						break;	
					case '27':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTCHANNELCHANGEDFROM'].' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info'];
						break;
					case '28':
						$audit_log[$i]['audit_log_operation']=$audit_log[$i]['old_info'] .' '.$vis_language['TXTUNLINKEDFROM'].' '.$audit_log[$i]['new_info'];
						break;	
					case '29':
						$audit_log[$i]['audit_log_operation']=$vis_language['TXTSET'].' '.$audit_log[$i]['new_info'] .' '.$vis_language['TXTLABEL'];
						break;	
					case '30':
						$audit_log[$i]['audit_log_operation']=$vis_language['TXTPINNED'].' '.$audit_log[$i]['old_info'];
						break;
					case '31':
						$audit_log[$i]['audit_log_operation']=$vis_language['TXTREMOVEDLABEL'].' '.$audit_log[$i]['new_info'];
						break;
					case '32':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGTICKETPROPERTYUPDATED'];
						break;
					case '33':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGTICKETNOTEADDED'];
						break;
					case '34':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGTICKETNOTEDELETED'];
						break;
					case '35':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGTICKETCOMMENTADDED'];
						break;
					case '36':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGTICKETCOMMENTDELETED'];
						break;
					case '37':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGTICKETPOSTUPDATED'];
						break;
					case '38':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGADDEDNEWRECIPIENT'].' '.$audit_log[$i]['new_info'];
						break;
					case '39':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGADDEDNEWPEOPLE'].' '.$audit_log[$i]['new_info'];
						break;
					case '40':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGREMOVEDRECIPIENT'].' '.$audit_log[$i]['new_info'];
						break;
					case '41':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGREMOVEDPEOPLE'].' '.$audit_log[$i]['new_info'];
						break;
					case '42':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGADDEDNEWTAG'].' '.$audit_log[$i]['new_info'];
						break;
					case '43':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGREMOVEDTAG'].' '.$audit_log[$i]['new_info'];
						break;
					case '44':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGNEWSCHEDULETKTCRT'];
						break;
					case '45':
						$audit_log[$i]['audit_log_operation']=($audit_log[$i]['old_info'] == '')?$vis_language['MSGTICKETLEVELCHANGED'].' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info']:$vis_language['MSGTICKETLEVELCHANGED'].' '.strtolower($vis_language['TXTFROM']).' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info'];
						break;
					case '46':
						$audit_log[$i]['audit_log_operation']=($audit_log[$i]['old_info'] == '')?$vis_language['MSGTICKETCATEGORYCHANGED'].' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info']:$vis_language['MSGTICKETCATEGORYCHANGED'].' '.strtolower($vis_language['TXTFROM']).' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info'];
						break;
					case '47':
						$audit_log[$i]['audit_log_operation']=($audit_log[$i]['old_info'] == '')?$vis_language['MSGTICKETSUBCATEGORYCHANGED'].' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info']:$vis_language['MSGTICKETSUBCATEGORYCHANGED'].' '.strtolower($vis_language['TXTFROM']).' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info'];
						break;
					case '48':
						$audit_log[$i]['audit_log_operation']=($audit_log[$i]['old_info'] == '')?$vis_language['MSGTICKETITEMCHANGED'].' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info']:$vis_language['MSGTICKETITEMCHANGED'].' '.strtolower($vis_language['TXTFROM']).' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info'];
						break;
					case '49':
						$audit_log[$i]['audit_log_operation']=($audit_log[$i]['old_info'] == '')?$vis_language['MSGITILLOCATIONCHANGED'].' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info']:$vis_language['MSGITILLOCATIONCHANGED'].' '.strtolower($vis_language['TXTFROM']).' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info'];
						break;
					case '50':
						$audit_log[$i]['audit_log_operation']=$vis_language['TXTSLAPAUSED'];
						break;
					case '51':
						$audit_log[$i]['audit_log_operation']=$vis_language['TXTSLARESUMED'];
						break;
					case '52':
						$audit_log[$i]['audit_log_operation']=$vis_language['TXTREADTICKETFORSTAFF'];
						break;
					case '53':
						$audit_log[$i]['audit_log_operation']=$vis_language['TXTSENDTICKETAPPROVAL'].' '.strtolower($vis_language['TXTTO']).' '.$audit_log[$i]['old_info'];
						break;
					case '54':
						$audit_log[$i]['audit_log_operation']=$vis_language['TXTCHANGETICKETAPPROVALSTATUS'].' '.strtolower($vis_language['TXTBY']).' '.$audit_log[$i]['old_info'];
						break;
					case '55':
						$audit_log[$i]['audit_log_operation']=$vis_language['TXTSENDTICKETAPPROVALREMINDER'].' '.strtolower($vis_language['TXTTO']).' '.$audit_log[$i]['old_info'];
						break;
					case '56':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGCUSTOMEFIELDDATAMODIFIED'].' '.strtolower($vis_language['TXTBY']).' '.$audit_log[$i]['old_info'];
						break;
					case '57':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGCUSTOMEFIELDDATAMODIFIED'].' '.strtolower($vis_language['TXTBY']).' '.$audit_log[$i]['old_info'];
						break;
					case '58':
						$audit_log[$i]['audit_log_operation']=($audit_log[$i]['old_info'] == '')? $audit_log[$i]['new_info']: $vis_language['MSGITILLOCATIONCHANGED'].' '.strtolower($vis_language['TXTFROM']).' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info'];
						break;	
					case '59':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTCHANGEURGENCY'].' '.$audit_log[$i]['old_info'].' '.strtolower($vis_language['TXTTO']).' '.$audit_log[$i]['new_info'];
						break;
					case '60':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTCHANGEIMPACT'].' '.$audit_log[$i]['old_info'].' '.strtolower($vis_language['TXTTO']).' '.$audit_log[$i]['new_info'];
						break;
					case '61':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTJUSTPRIORITYCHNG'].' '.strtolower($vis_language['TXTADDED']).' - '.$audit_log[$i]['new_info'];
						break;
					case '62':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTSYMPTONS'].' '.strtolower($vis_language['TXTADDED']).' - '.$audit_log[$i]['new_info'];
						break;
					case '63':
						$audit_log[$i]['audit_log_operation']=$vis_language['TXTCLONE'].' '.strtolower($vis_language['TXTTICKET']).' '.strtolower($vis_language['TXTFROM']).' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info'];
						break;	
					case '64':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTDTSIMPACTCHNG'].' - '.$audit_log[$i]['new_info'];
						break;
					case '65':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTNEWRELATTACHED'].' '. $audit_log[$i]['old_info'];
						break;
					case '66':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTDETTACHATTACHREL'].' '. $audit_log[$i]['old_info'];
						break;
				}
			}
			$array_summary = array();
			$array_summary['TXTTOTAL']= $avgTimeCount = ($total_time != '-')? count_remain_time($total_time):'-'; 
			$array_summary['TXTCREATIONDATE']= format_datetime($audit_log[0]['creation_date']);
			$array_summary['TXTCLOSETICKETDATE']= format_datetime($audit_log[0]['closed_time']);
			$operators=array(1=>$vis_language['TXTCLIENT'], 2=>$vis_language['TXTSTAFF'], 3=>$vis_language['TXTSTAFF'], 4=>$vis_language['TXTSYSTEM']);
			if(isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j = 0; 
				foreach ($audit_log as $i){
					foreach ($i as $key => $val) {
						$name=''; if($i['operator_id']!= -1){ $name = $vis_language['TXTWORKFLOW']; }else { $name =$vis_language['TXTROUNDROBIN']; }
						if ($key == 'ticket_hash') {
							$report_exp[$j][$key] = $val; 
						} elseif ($key == 'subject') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'audit_log_operation') {
							$report_exp[$j][$key] = $val;
						}elseif ($key == 'entry_date') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'operator' ) {
							$report_exp[$j][$key]=(($i['workflow_id']!=0 || (($i['operator']==4 ) && $i['fname']==''))? 
					 ($i['workflow_id']!=0)? $vis_language['TXTSYSTEM'].' ('.$name.' - '.$i['workflow_name'].')': $vis_language['TXTSYSTEM']:($operators[$i['operator']].' ('.$i['operators'].')'));
						} elseif ($key == 'department_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'fname' || $key == 'lname' || $key == 'email' || $key == 'group_name') {
							$report_exp[$j][$key] = $val;
						}																
					}  
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash']; 
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['client_name'] = $report_exp[$j]['fname'].' '.$report_exp[$j]['lname'];
					$report_exp1[$j]['email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					$report_exp1[$j]['operation'] = $report_exp[$j]['audit_log_operation']; 
					$report_exp1[$j]['operator'] = $report_exp[$j]['operator'];
					$report_exp1[$j]['operation_date'] = format_datetime_rpt($report_exp[$j]['entry_date'],$staff_id);
					$report_exp1[$j]['department'] = $report_exp[$j]['department_name'];
					$j++;
				}
				if($audit_log!=-1){
					$report_exp1[$j]['total']=$vis_language['TXTTOTAL'].' :'. $avgTimeCount;
					$report_exp1[$j]['creation_date'] = $vis_language['TXTCREATIONDATE'].':'.format_datetime_rpt($creation_time,$staff_id);
					$report_exp1[$j]['closed_time'] =$vis_language['TXTCLOSETICKETDATE'].':'.format_datetime_rpt($close_time,$staff_id);
				}  

				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);	
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				} else {
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']); 
				if (!$result)
				return false;
				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total_cnt,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function ticket_linking_report($operation)
	{	//ticket linking relation report
		global $vis_language;
		$report_title =$vis_language['TXTTICKETLINKREPORT'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type = 60;
		$export = 1;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$departments   = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page'])) ? $operation['vis_page'] : 0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='ticket_linking_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if((isset($operation['vis_action']) && $operation['vis_action']!='') || isset($operation['vis_submit']) && $operation['vis_submit']!=''){
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if(($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if (!isset($data['department_id']) || (isset($data['department_id']) && $data['department_id'] == '' )) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDEPARTMENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$department_ids = implode(',', $data['department_id']);
				$filter = ' ('.VIS_TABLE_PREFIX.'ticket_link.parent_ticket_id='.VIS_TABLE_PREFIX.'auditlog.ticket_id and '.VIS_TABLE_PREFIX.'auditlog.operation_id=24) and '.VIS_TABLE_PREFIX.'auditlog.entry_date between '.$from.' AND '.$to.' and '.VIS_TABLE_PREFIX.'ticket_link.link_type='.$data['vis_link_type'].' and '.VIS_TABLE_PREFIX.'ticket.department_id IN ('.$department_ids.') and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$filter .= ' and '.VIS_TABLE_PREFIX.'ticket.is_deleted =0 and ' .VIS_TABLE_PREFIX.'ticket.is_spam=0 and ' .VIS_TABLE_PREFIX.'ticket.draft_id=0 ';
			list($total_cnt, $post_details)  = $object->get_ticket_linking_report($filter, $limit, $staff_id, VIS_LOCATION_AREA);
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
			$sett_obj = new class_setting($database);
			$link=array(1=>$vis_language['TXTRELATESTO'],2=>$vis_language['TXTISRELATEDTO'],3=> $vis_language['TXTISAPARENTOF'],4=>$vis_language['TXTISACHILDOF'],5=>$vis_language['TXTDEPENDSON'],6=>$vis_language['TXTISDEPENDEDON'],7=>$vis_language['TXTDUPLICATES'],8=>$vis_language['TXTISADUPLICATEDBY']);
			$total =$total_cnt;
			$report =($post_details!=-1)?$post_details:-1;
			$view_info['page']=$page;
			$view_info['view_count']= $total_cnt;
			$report_count=($post_details!=-1)? count($post_details) : 0;
			$view_info['page_count']=($total_cnt==0)?0:ceil($total_cnt/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j=0;
				foreach ($post_details  as $i){   
					foreach ($i as $key => $val){
						if($key == 'ticket_hash'){ 
							$report_exp[$j][$key] = $val;
						} elseif($key == 'subject'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'receive_date'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif($key == 'first_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'last_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'email'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'group_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'link_hash_tckt'){
							$report_exp[$j][$key] = $val;
						} elseif($key=='link_type'){
							$report_exp[$j][$key] = $link[$val];
							$linktype=$report_exp[$j][$key] ;
						}
					} 
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash']; 
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject']; 
					$report_exp1[$j]['client_name'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name']; 
					$report_exp1[$j]['email'] = $report_exp[$j]['email']; 
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					$report_exp1[$j]['creation_date'] = $report_exp[$j]['receive_date'];
					$report_exp1[$j][$linktype] = $report_exp[$j]['link_hash_tckt']; 
					$j++; 
				}
				$report_exp1['Report_title'] = $report_title;	// To display title 
				$completed_date = date('Y-m-d H:i:s');
				$filename=$this->export_subreport($operation,$report_exp1);	
				if(isset($operation['slave_db']) && $operation['slave_db'] == 1){
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if(!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total_cnt,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function merged_tickets_report($operation)
	{	
		global $vis_language;
		$report_title = $vis_language['TXTMERGEDTICKETS'];
		$export       = 1;
		
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		
		$report_type = 35;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$departments   = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
		$object_staff  = new class_staff($database);
		$staff_filter  = "staff_id =" . $staff_id;
		$staff_details = $object_staff->get_staff($staff_filter, $staff_id, VIS_LOCATION_AREA);
		$dept_ids      = '';
		for ($d = 0; $d < count($departments); $d++) {
			$dept_ids .= $departments[$d]['department_id'].',';
		}
		if ($dept_ids != '') {
			$dept_ids = substr($dept_ids, 0, -1);
		}
		$staff_details= $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA, '', '', ' and staff_id='.$staff_id);
		$staff_dropdwon= $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA);
		$dept_access = $staff_details[0]['department_access'];
		$dept_access_filter = ($dept_access!=0) ? ' and department_access IN ('.$dept_access.')' : '';
		$staff_list= $tkt_object->get_staff_list('', VIS_LOCATION_AREA, '', '', $dept_access_filter);
		for($s=0;$s<count($staff_list);$s++){
			$staff_name = explode(' ', $staff_list[$s]['staff_name']);
			for($m=0;$m<count($staff_name);$m++){
				$staff_list[$s]['first_name'] = $staff_name[0];
				$staff_list[$s]['last_name'] = $staff_name[1];
			}
		}
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='merged_tickets_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		$filter="";
		if((isset($operation['vis_action']) && $operation['vis_action']!='') || isset($operation['vis_submit']) && $operation['vis_submit']!=''){
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				
				if(($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 &&  !isset($data['staff_id']) && empty($data['staff_id'])) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false; 
				} else if ($data['duration'] == 0 && $data['staff_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if (!isset($data['staff_id']) && empty($data['staff_id']) && $data['duration'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTSTAFF']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				} else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				if (isset($data['staff_id']) && ($data['staff_id'] != '' && $data['staff_id'] != 0)) {
					if(is_array($data['staff_id'])){
					$staff_ids = implode(',',$data['staff_id']);
					}else { $staff_ids = $data['staff_id']; }
					$filter = 'a.entry_date between ' . $from . ' AND ' . $to;
					$filter .= ' and operator_id IN(' .$staff_ids.')'; 
					$filter .= ' and staff_id IN(' .$staff_ids.')';
					$filter .= ' and t.is_deleted=0';
				}
			}
			$filter.=' and t.is_spam=0 and t.draft_id=0';
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database); 
			list($total_cnt, $report) = $object->get_merged_tickets_report($filter, $limit, $staff_id, VIS_LOCATION_AREA);
			$total = $total_cnt;
			$view_info['page']=$page;
			$report_count=($report!=-1) ? count($report) : 0;
			$view_info['page_count']=($total_cnt==0)?0:ceil($total_cnt/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export         = new export();
				$j=0;
				foreach ($report as $i){
					foreach ($i as $key => $val){
						if($key == 'ticket_hash'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'subject'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'first_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'last_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'creation_date'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif($key == 'receive_date'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif($key == 'old_info'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'fname' || $key == 'lname' || $key == 'email' || $key == 'group_name'){
							$report_exp[$j][$key] = $val;
						}
					}
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash']; 
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['client_name'] = $report_exp[$j]['fname'].' '.$report_exp[$j]['lname']; 
					$report_exp1[$j]['email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					$report_exp1[$j]['staff_name'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name']; 
					$report_exp1[$j]['creation_date'] = $report_exp[$j]['creation_date']; 
					$report_exp1[$j]['merged_date'] = $report_exp[$j]['receive_date']; 
					$report_exp1[$j]['merge_incident'] = $report_exp[$j]['old_info']; 
					$j++;
				}					
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);	
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if(!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total_cnt,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}
	
	function deleted_tickets_report($operation)
	{	
		global $vis_language;
		$report_title = $vis_language['TXTDELETEDTICKETS'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		
		$report_type = 34;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
		$object_staff  = new class_staff($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='deleted_tickets_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		$departments   = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX .'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		$staff_filter  = "staff_id =" . $staff_id;
		$staff_details = $object_staff->get_staff($staff_filter, $staff_id, VIS_LOCATION_AREA);
		$dept_ids      = '';
		for ($d = 0; $d < count($departments); $d++) {
			$dept_ids .= $departments[$d]['department_id'] . ',';
		}
		if ($dept_ids != '') {
			$dept_ids = substr($dept_ids, 0, -1);
		}
		if((isset($operation['vis_action']) && $operation['vis_action']!='') || isset($operation['vis_submit']) && $operation['vis_submit']!=''){
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				$data['department_id']=isset($data['department_id'])?$data['department_id']:0;
				if ($data['department_id'] == 0) {
					$dept_id = ($staff_details[0]['department_access'] == '' || $staff_details[0]['department_access'] == 0) ? $dept_ids : $staff_details[0]['department_access'];
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if($data['department_id']==0){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDEPARTMENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$dept_ids = implode(',',$data['department_id']);
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				if ($data['department_id'] != 0) {
					$filter = 'entry_date between ' . $from . ' AND ' . $to . ' and a.department_id IN(' . $dept_ids.')';
				} else {
					$filter = 'entry_date between '.$from.' AND '.$to.' and a.department_id in ('.$dept_id.')';
				}
			}
			$filter     .= ' and a.channel_id!=7';
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object      = new class_report($database);
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
			$object_setting = new class_setting($database);
			$custom_filter = ' (location=1 or location=2 or location=11) and is_enabled=1';
			/*$custom_grouplist = $object_setting->get_custom_group_list($custom_filter, $staff_id, VIS_LOCATION_AREA);*/
			list($total_cnt, $report) = $object->get_deleted_tickets_report($filter, $limit, $staff_id, VIS_LOCATION_AREA);
			$total = $total_cnt;		
			$view_info['page']=$page;
			$report_count=($report!=-1) ? count($report) : 0;
			$view_info['page_count']=($total_cnt==0)?0:ceil($total_cnt/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			if(isset($operation['vis_export']) && $operation['vis_export'] == 1){
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export         = new export();
				$j=0;
				foreach ($report as $i){
					foreach ($i as $key => $val){
						if($key == 'ticket_hash'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'subject'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'first_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'last_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'receive_date'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif($key == 'department_name'){
							$report_exp[$j][$key] = $val;
						}
					}
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash']; 
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject']; 
					$report_exp1[$j]['staff_name'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name']; 
					$report_exp1[$j]['deleted_date'] = $report_exp[$j]['receive_date']; 
					$report_exp1[$j]['department'] = $report_exp[$j]['department_name'];
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total_cnt,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function customfield_data_report($operation)
	{	
		global $vis_language;
		$report_title = $vis_language['TXTCSTFLDRPT'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type = 38;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
		$object_staff = new class_staff($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
		$object_setting = new class_setting($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='customfield_data_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		$filter         = 'location in(1,11)';
		$custom_group   = $object_setting->get_custom_group_list($filter, $staff_id, VIS_LOCATION_AREA);
		$customfield_array = array();
		if($custom_group!=-1){
			for($i = 0; $i < count($custom_group); $i++) {
				$filter = ' ' .VIS_TABLE_PREFIX.'customfield.customgroup_id=' . $custom_group[$i]['customgroup_id'] . ' and ' .VIS_TABLE_PREFIX.'customfield.is_enabled=1 ';
				list($customfield_info, $customfield_details) = $object_setting->get_customfield(0, $filter, '', 0, 0, $staff_id, VIS_LOCATION_AREA);
				if($customfield_details!=-1){
					$customfield_array[] = $customfield_details;
				}
			}
		}
		$staff_filter  = "staff_id =" . $staff_id;
		$staff_details = $object_staff->get_staff($staff_filter, $staff_id, VIS_LOCATION_AREA);
		$departments   = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		$dept_ids    = '';
		for ($d = 0; $d < count($departments); $d++) {
			$dept_ids .= $departments[$d]['department_id'] . ',';
		}
		if ($dept_ids != '') {
			$dept_ids = substr($dept_ids, 0, -1);
		}
		$dept_id  = ($staff_details[0]['department_access'] == '' || $staff_details[0]['department_access'] == 0) ? $dept_ids : $staff_details[0]['department_access'];
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$matches= array();
				preg_match("/(?<=field_group in \().*?(?=\))/", $filter, $matches); /*to get the field groups*/
				$fld_grpid = isset($matches[0])? $matches[0]:'';
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				$fld_grpid = (isset($data['field_type'])) ? implode(',', $data['field_type']) : '';

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				$data['department_id'] = (isset($data['department_id']))? $data['department_id']:'';
				if($data['duration'] == 0 && $data['department_id'] == '' && $fld_grpid == ""){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if($data['department_id'] == ''){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDEPARTMENT']). '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if($data['field_type'] == "") {
echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTFIELDNAME']).'");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$dept_ids = implode(',',$data['department_id']);
				$chk_dept = ' and t.department_id IN('.$dept_ids.')';
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				if ($data['department_id'] != 0 && $fld_grpid != 0) {
					$filter = 't.receive_date between ' . $from . ' AND ' . $to . $chk_dept . ' and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and cf.field_group in (' . $fld_grpid.') and cf.is_enabled = 1 ';
				} else if ($data['department_id'] == 0 && $fld_grpid != 0) {
					$filter = 't.receive_date between '.$from.' AND '.$to.' and t.department_id in ('.$dept_id.') and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and cf.field_group in ('.$fld_grpid.') and cf.is_enabled = 1 ';
				} else if ($data['department_id'] != 0 && $fld_grpid == 0) {
					$filter = 't.receive_date between '.$from.' AND '. $to . $chk_dept.' and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and cf.is_enabled = 1 ';
				} else {
					$filter = 't.receive_date between '.$from.' AND '.$to.' and t.department_id in ('.$dept_id.') and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and cf.is_enabled = 1 ';
				}
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object      = new class_report($database);
			$filter     .= ' and cg.location in(1,11)';
			list($total_rec, $report) = $object->get_customfield_data_report($filter, $limit, $staff_id, VIS_LOCATION_AREA);
			$array_summary = array();
			$view_info['page']=$page;
			$view_info['view_count']= $total = ($total_rec!=-1)?count($total_rec):0;
			$report_count=($report!=-1)? count($report) : 0;
			$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			$customData = array();
			if($custom_group!=-1){
				if($fld_grpid==0 && strpos($filter, 'cf.field_group')==false){
					for($s=0;$s<count($customfield_array);$s++){
						for($m=0;$m<count($customfield_array[$s]);$m++){
							$filter = ' '.VIS_TABLE_PREFIX.'customfield.customgroup_id='.$customfield_array[$s][$m]['customgroup_id'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1 and '.VIS_TABLE_PREFIX.'customfield_data.customfield_id='.$customfield_array[$s][$m]['customfield_id'];
							$customData[] = $object->get_custom_fields_data($filter);
						}
					}
				}
			}
			$k=0;
			$tmp = array();
			$totalCustomData = ($customData!=-1)?count($customData):0;
			for($s=0;$s<$totalCustomData;$s++){
				for($m=0;$m<$cnt=($customData[$s]!=-1)?count($customData[$s]):0;$m++){
					$tmp[$k] = $customData[$s][$m]['field_name'];
				}
				$k++;
			}
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export         = new export();
				$j=0;
				foreach ($report as $customs_id=>$i){
					foreach ($i as $key => $val){
						if($key == 'ticket_id'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'ticket_hash'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'receive_date'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif($key == 'field_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'content'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'first_name' || $key == 'last_name' || $key == 'email' || $key == 'group_name'){
							$report_exp[$j][$key] = $val;
						}
					}
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['client_name'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					$report_exp1[$j]['creation_date'] = $report_exp[$j]['receive_date'];
					$report_exp1[$j]['field_name'] = $report_exp[$j]['field_name'];
					$report_exp1[$j]['field_value'] = $report_exp[$j]['content'];
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);	
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function get_department_wise_customfields($operation){
		global $vis_language;
		$database = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
		$object_setting = new class_setting($database);
		$customfield_array = array();
		$department_filter = '';
		if ($operation['operation_name'] == 'customfield_data_report') {
			if(is_array($operation['department_ids'])){
				
				$department_filter = ' and (department_access=0 or department_access IN('.implode(',',$operation['department_ids']).'))';
			}
	        $domain=$object_setting->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1','','','', VIS_STAFF_ID, VIS_LOCATION_AREA);
			$domain=$domain[1];
			$filter         = 'location in(1,11)'.$department_filter;
			$custom_group   = $object_setting->get_custom_group_list($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
			if($custom_group!=-1){
				for($i = 0; $i < count($custom_group); $i++) {
					$filter = ' ' .VIS_TABLE_PREFIX.'customfield.customgroup_id=' . $custom_group[$i]['customgroup_id'] . ' and ' .VIS_TABLE_PREFIX.'customfield.is_enabled=1 ';
					list($customfield_info, $customfield_details) = $object_setting->get_customfield(0, $filter, '', 0, 0, VIS_STAFF_ID, VIS_LOCATION_AREA);
					if($customfield_details!=-1){
						$customfield_array[] = $customfield_details;
					}
				}
			}
			$arr_cnt = (isset($customfield_array[0]) && $customfield_array[0]!=-1)?count($customfield_array[0]):0;
			?>
			<select name="field_type[]" id="field_type" class="form-control selectpicker" multiple data-actions-box="true" <?php if($arr_cnt > 10) echo 'data-live-search="true"';?>>
				<?php
				if($operation['department_ids']!='')
				if(isset($customfield_array[0])&&$customfield_array[0]!=-1){
					for($k=0;$k<count($domain);$k++) {
						for($i=0;$i<count($customfield_array);$i++){
							if($customfield_array[$i]!=-1){
								for($j=0;$j<count($customfield_array[$i]);$j++){
									if($customfield_array[$i][$j]['domain_access']==0 && $k==0)
									echo '<option value="'.$customfield_array[$i][$j]['field_group'].'">All Domain :: '.$customfield_array[$i][$j]['field_name'].'</option>';
									elseif(in_array($domain[$k]['domain_id'], explode(',', $customfield_array[$i][$j]['domain_access'])))
									echo '<option value="'.$customfield_array[$i][$j]['field_group'].'">'.$domain[$k]['domain_name'].' :: '.$customfield_array[$i][$j]['field_name'].'</option>';
								}
							}
						}
					}
				} ?>
			</select>
		<?php
		} 
		
		if ($operation['operation_name'] == 'service_customfield_data_report') {
			if(is_array($operation['department_ids'])){
				$department_filter = VIS_TABLE_PREFIX.'itil_service_item.item_department_id in ('.implode(',',$operation['department_ids']).') and ';
			}
			$filter = $department_filter.VIS_TABLE_PREFIX.'itil_service_item.status=1 and '.VIS_TABLE_PREFIX.'itil_service_category.is_enabled=1 ';
			list($service_info, $service_items)   = $object_setting->get_service_item_list2($filter,'',VIS_STAFF_ID, VIS_LOCATION_AREA,'');
			if($service_items!=-1){
				for($i = 0; $i < count($service_items); $i++) {
					$filter = ' ' .VIS_TABLE_PREFIX.'customfield.customgroup_id=' . $service_items[$i]['item_id'] . ' and ' .VIS_TABLE_PREFIX.'customfield.is_enabled=1 and ' .VIS_TABLE_PREFIX.'customfield.ci_type=2';
					list($customfield_info, $customfield_details) = $object_setting->get_itil_customfield(0, $filter, '', 0, 0, VIS_STAFF_ID, VIS_LOCATION_AREA);
					if($customfield_details!=-1){
						$customfield_array[] = $customfield_details;
					}
				}
			}
		if(count($customfield_array) > 10) $sk = 'data-live-search="true"'; else $sk = '';
			$list_data='';
			$list_data .= '<select name="field_type[]" id="field_type" class="form-control selectpicker" '.$sk.' multiple data-actions-box="true">';
			if($customfield_array!=array()) {
				
				for($i=0;$i<count($customfield_array);$i++) {
					if ($customfield_array[$i]!=-1)
						for ($j=0; $j < count($customfield_array[$i]); $j++)
							$list_data .= '<option value="'.$customfield_array[$i][$j]['field_group'].'"> '.$customfield_array[$i][$j]['field_name'].'</option>';
				}
			}		
			$list_data .= '</select>';
			echo $list_data;
		}
		return true;
	}

	function service_customfield_data_report($operation)
	{	
		global $vis_language;
		$report_title = $vis_language['TXTCSTFLDSRVCRQRPT'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type = 147;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
		$object_staff = new class_staff($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
		$object_setting = new class_setting($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='service_customfield_data_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		$filter = VIS_TABLE_PREFIX.'itil_service_item.status=1 and '.VIS_TABLE_PREFIX.'itil_service_category.is_enabled=1 ';
		list($service_info, $custom_group)   = $object_setting->get_service_item_list2($filter,'',$staff_id, VIS_LOCATION_AREA,'');
		$customfield_array = array();
		if($custom_group!=-1){
			for($i = 0; $i < count($custom_group); $i++) {
				$filter = ' ' .VIS_TABLE_PREFIX.'customfield.customgroup_id=' . $custom_group[$i]['item_id'] . ' and ' .VIS_TABLE_PREFIX.'customfield.is_enabled=1 and ' .VIS_TABLE_PREFIX.'customfield.ci_type=2';
				list($customfield_info, $customfield_details) = $object_setting->get_itil_customfield(0, $filter, '', 0, 0, $staff_id, VIS_LOCATION_AREA);
				if($customfield_details!=-1){
					$customfield_array[] = $customfield_details;
				}
			}
		}
		$staff_filter  = "staff_id =" . $staff_id;
		$staff_details = $object_staff->get_staff($staff_filter, $staff_id, VIS_LOCATION_AREA);
		$departments   = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		$dept_ids    = '';
		for ($d = 0; $d < count($departments); $d++) {
			$dept_ids .= $departments[$d]['department_id'] . ',';
		}
		if ($dept_ids != '') {
			$dept_ids = substr($dept_ids, 0, -1);
		}
		$dept_id  = ($staff_details[0]['department_access'] == '' || $staff_details[0]['department_access'] == 0) ? $dept_ids : $staff_details[0]['department_access'];
		$fld_grps='';
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$array_filter = explode('#', $operation['filter']);
				$filter = $array_filter[0];
				$selected_dept = $array_filter[1];
				$fld_grpid = $operation['department_id'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				$data['department_id'] = (isset($data['department_id']))? $data['department_id']:'';
				if($data['duration'] == 0 && $data['department_id'] == '' && $fld_grpid == ""){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if($data['department_id'] == ''){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDEPARTMENT']). '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if(!isset($data['field_type']) && $operation['vis_form']=='vis_service_customfield_data_report_frm') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTFIELDNAME']).'");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$dept_ids = implode(',',$data['department_id']);
				$chk_dept = ' and t.department_id IN('.$dept_ids.')';
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$fld_grps = implode(',',$data['field_type']);
				$data['field_type']=$fld_grps;
				if( $fld_grps!='' ){
					$fld_grpid = ' and cf.field_group in ('.$fld_grps.') ';
				} else {
					$fld_grpid = '';
				}
				if ($chk_dept != '' && $fld_grpid != '') {
					$filter = 't.receive_date between ' . $from . ' AND ' . $to . $chk_dept . ' and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 ' . $fld_grpid.' and cf.is_enabled = 1 ';
				} else {
					$filter = 't.receive_date between '.$from.' AND '.$to.' and t.department_id in ('.$dept_id.') and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and cf.is_enabled = 1 ';
				}
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object      = new class_report($database);
			$filter     .= ' and t.channel_id=7';
			list($total_rec, $report) = $object->get_service_customfield_data_report($filter, $limit, $staff_id, VIS_LOCATION_AREA);
			$array_summary = array();
			$view_info['page']=$page;
			$view_info['view_count']= $total = ($total_rec==-1)? 0:count($total_rec);
			$report_count=($report!=-1)? count($report) : 0;
			$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			$customData = array();
			if($custom_group!=-1){
				if($fld_grpid==0 && strpos($filter, 'cf.field_group')==false){
					for($s=0;$s<count($customfield_array);$s++){
						for($m=0;$m<count($customfield_array[$s]);$m++){
							$filter = ' '.VIS_TABLE_PREFIX.'customfield.customgroup_id='.$customfield_array[$s][$m]['customgroup_id'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1 and '.VIS_TABLE_PREFIX.'customfield_data.customfield_id='.$customfield_array[$s][$m]['customfield_id'];
							$customData[] = $object->get_service_custom_fields_data($filter);
						}
					}
				}
			}
			$k=0;
			$tmp = array();
			for($s=0;$s<count($customData);$s++){
				if ($customData[$s]!=-1)
					for($m=0;$m<count($customData[$s]);$m++){
						$tmp[$k] = $customData[$s][$m]['field_name'];
					}
				$k++;
			}
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) { 
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export         = new export();
				$j=0;
				$fldname="";
				$fldname_val="";				
				if ($report != -1) {
				foreach ($report as $i){
					$fldname=$i['field_name'];
					$fldname_val=$i['content'];
					foreach ($i as $key => $val){
						if($key == 'ticket_id'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'ticket_hash'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'receive_date'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif($key == 'field_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'content'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'first_name' || $key == 'last_name' || $key == 'email' || $key == 'group_name'){
							$report_exp[$j][$key] = $val;
						}
					}
					$report_exp1[$j]['service_request_hash'] = $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['client_name'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					$report_exp1[$j]['creation_date'] = $report_exp[$j]['receive_date'];
					if($fldname!='' && $fldname_val!='' && $fld_grpid!=0){
					$report_exp1[$j]['field_name'] = $fldname;
					$report_exp1[$j]['field_value'] = $fldname_val;
					}
					if($custom_group!=-1 && $fld_grpid==0){
						$customfield_data = array();
						for($m=0;$m<count($custom_group);$m++){
							$fld_grp_id = ($operation['department_id']!=0) ? VIS_TABLE_PREFIX.'customfield.customgroup_id='.$custom_group[$m]['item_id'] : VIS_TABLE_PREFIX.'customfield.customgroup_id='.$custom_group[$m]['item_id'];
							$filter = $fld_grp_id.' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1 and ' .VIS_TABLE_PREFIX.'customfield.ci_type=2 and '.VIS_TABLE_PREFIX.'itil_service_item.item_department_id in ('.$selected_dept.')';
							$customfield = $object_setting->get_itil_customfield(2, $filter, '', 0, 0, $staff_id, VIS_LOCATION_AREA);
							if($customfield[1]!=-1){
								$fieldcontent = $prevFieldGroup = '';
								$prevContent = '';
								for($s=0;$s<count($customfield[1]);$s++){
									$customfield_data = $tkt_object->get_service_customfield_data($customfield[1][$s]['customfield_id'], $i['ticket_id'], '');
									if($customfield_data!=-1){
										if(isset($customfield_data['content']) && $customfield_data['content']!=''){
											if($prevFieldGroup == $customfield[1][$s]['field_group']){
												if($customfield_data['parent_id'] != $i['ticket_id']){
													$fieldcontent = $customfield_data['content'].'|';
												} else {
													$fieldcontent .= $customfield_data['content'].'|';
												}
												$previousContent = '';
											} elseif($prevContent!='' && $prevFieldGroup == $customfield[1][$s]['field_group']){
												$fieldcontent .= $customfield_data['content'].'|';
											} else {
												$fieldcontent = $customfield_data['content'].'|';
											}
											$report_exp1[$j][$customfield[1][$s]['field_name']] = ($fieldcontent!='') ? substr($fieldcontent,0,-1) : '';
											$previousContent = $customfield_data['content'];
										}
										$customfields_title[] = $customfield[1][$s]['field_name'];
									} else {
										if($fieldcontent!='' && $prevFieldGroup == $customfield[1][$s]['field_group']){
											$report_exp1[$j][$customfield[1][$s]['field_name']] = ($fieldcontent!='') ? substr($fieldcontent,0,-1) : '';
											$prevContent = '';
										} elseif($fieldcontent=='' && $prevFieldGroup != $customfield[1][$s]['field_group']){
											$report_exp1[$j][$customfield[1][$s]['field_name']] = ($customfield_data['content']!='') ? $previousContent : $prevContent;
											$previousContent = '';
										} else {
											$fieldcontent = '';
											$prevContent = '';
											$previousContent = '';
											$report_exp1[$j][$customfield[1][$s]['field_name']] = '';
										}
									}
									$prevContent = $customfield_data['content'];
									$prevFieldGroup = $customfield[1][$s]['field_group'];
								}
							}
						}
					}
					$j++;
				}
				}//if
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);	
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}
	
	function view_custom_report($operation) 
	{	
		$database=new class_database();
		if(isset($operation['vis_action'])){  
			$data=parse_form_array($operation['vis_action']); 
		   	$operation=array_merge($operation,$data);
		}
		$ttotpg=0;
		$operation['custom_show_report']=7; 
		$operation['custom_show_report']=(isset($operation['custom_show_report']))?7:''; 
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view(VIS_STAFF_ID, VIS_LOCATION_AREA);
		$ttotpg = $view_info['page_count'];
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='view_custom_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		$object=new class_ticket($database);
		$accessfilter=(VIS_ADMIN_ACCESS_LEVEL==1)?'':' and owner='.VIS_STAFF_ID;
		$filters_ticketcount=$object->get_filters_details('vscope=1 and is_report=1 '.$accessfilter, VIS_STAFF_ID, VIS_LOCATION_AREA,'','');
		$filters_incidentscount=$object->get_filters_details('vscope=1 and is_report=8'.$accessfilter, VIS_STAFF_ID, VIS_LOCATION_AREA,'','');
		if(defined('AGENTTYPE') && AGENTTYPE=='VIS_ENTSD'){
			$filters_changescount=$object->get_filters_details('vscope=1 and is_report=2 '.$accessfilter, VIS_STAFF_ID, VIS_LOCATION_AREA,'','');
			$filters_problemcount=$object->get_filters_details('vscope=1 and is_report=3 '.$accessfilter, VIS_STAFF_ID, VIS_LOCATION_AREA,'','');
			$filters_releasescount=$object->get_filters_details('vscope=1 and is_report=4 '.$accessfilter, VIS_STAFF_ID, VIS_LOCATION_AREA,'','');
		}
		if(defined('AGENTTYPE') && (AGENTTYPE=='VIS_PROSD' || AGENTTYPE=='VIS_ENTSD')){
			$filters_assetscount=$object->get_filters_details('vscope=1 and is_report=9'.$accessfilter, VIS_STAFF_ID, VIS_LOCATION_AREA,'','');
			$filters_dbassetscount=$object->get_cmdbfilters_details('vscope=1 and is_report=9'.$accessfilter, VIS_STAFF_ID, VIS_LOCATION_AREA,'','');
			$temp = (is_array($filters_assetscount))? $filters_assetscount:[];
			$filters_assetscount = (is_array($filters_dbassetscount))? array_merge($temp, $filters_dbassetscount):$filters_assetscount;
		}
		$filters_ticketcount=is_array($filters_ticketcount)?count($filters_ticketcount):0;
		$filters_incidentscount=(is_array($filters_incidentscount) && isset($filters_incidentscount))?count($filters_incidentscount):0;
		if(defined('AGENTTYPE') && AGENTTYPE=='VIS_ENTSD'){
		$filters_changescount=(is_array($filters_changescount) && isset($filters_changescount))?count($filters_changescount):0;
		$filters_releasescount=(is_array($filters_releasescount) && isset($filters_releasescount))?count($filters_releasescount):0;
		$filters_problemcount=(is_array($filters_problemcount) && isset($filters_problemcount))?count($filters_problemcount):0;

		}else{$filters_changescount=0;$filters_problemcount=0;$filters_releasescount=0;}

		if(defined('AGENTTYPE') && (AGENTTYPE=='VIS_PROSD' || AGENTTYPE=='VIS_ENTSD')){
		$filters_assetscount=(is_array($filters_assetscount) && isset($filters_assetscount))?count($filters_assetscount):0;
		}else {$filters_assetscount=0;}
		$allfilter='vscope=1 and is_report!=0';
		if(defined('AGENTTYPE') && AGENTTYPE=='VIS_ENTSD'){
			$allfilter='vscope=1 and (is_report=1 or is_report=2 or is_report=3 or is_report=4 or is_report=8 or is_report=9)'.$accessfilter;
		}
		else if(defined('AGENTTYPE') && AGENTTYPE=='VIS_PROSD'){
			$allfilter='vscope=1 and (is_report=1 or is_report=8 or is_report=9)'.$accessfilter;
		}
		else{
			$allfilter='vscope=1 and (is_report=1 or is_report=8)'.$accessfilter;
		}
		
		$filters_allcount=$object->get_filters_details($allfilter, VIS_STAFF_ID, VIS_LOCATION_AREA,'','',1);
		$operation['vis_search_for']=isset($operation['vis_search_for'])?$operation['vis_search_for']:0;
		if(isset($operation['vis_search_for']) && $operation['vis_search_for']==0){
			$filter=$allfilter;
		} else if(isset($operation['vis_search_for']) && $operation['vis_search_for']==1){
			$filter='vscope=1 and is_report=1'.$accessfilter;
		} else if(isset($operation['vis_search_for']) && $operation['vis_search_for']==2 && (defined('AGENTTYPE') && AGENTTYPE=='VIS_ENTSD')){
			$filter='vscope=1 and is_report=2 '.$accessfilter;			
		} else if(isset($operation['vis_search_for']) && $operation['vis_search_for']==3 && (defined('AGENTTYPE') && AGENTTYPE=='VIS_ENTSD')){
			$filter='vscope=1 and is_report=3'.$accessfilter;			
		} else if(isset($operation['vis_search_for']) && $operation['vis_search_for']==4 && (defined('AGENTTYPE') && AGENTTYPE=='VIS_ENTSD')){
			$filter='vscope=1 and is_report=4'.$accessfilter;	
		}  else if(isset($operation['vis_search_for']) && $operation['vis_search_for']==8){
				$filter='vscope=1 and is_report=8'.$accessfilter;			
		}  else if(isset($operation['vis_search_for']) && $operation['vis_search_for']==9 && (defined('AGENTTYPE') && (AGENTTYPE=='VIS_PROSD' || AGENTTYPE=='VIS_ENTSD'))){
			$filter='vscope=1 and is_report=9'.$accessfilter;			
		} 
		if(isset($operation['vis_search_for']) && ($operation['vis_search_for']==0 || $operation['vis_search_for']==9) && (defined('AGENTTYPE') && (AGENTTYPE=='VIS_PROSD' || AGENTTYPE=='VIS_ENTSD'))){
			$dbfilters=$object->get_cmdbfilters_details($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,$limit,'',1);
			$dbfilters_info=$object->get_cmdbfilters_details($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,'',1,1);
		}
		if(isset($operation['vis_search_for']) && $operation['vis_search_for']!=9){
			$filters=$object->get_filters_details($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,$limit,'',1);
			$filters_info=$object->get_filters_details($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,'',1,1);
		}

		$temp = (isset($filters) && is_array($filters))? $filters:[];
		$filters = (isset($dbfilters) && is_array($dbfilters))? array_merge($temp, $dbfilters):$temp;

		$temp = (isset($filters_info) && is_array($filters_info))? $filters_info:[];
		$filters_info['total'] = (isset($dbfilters_info) && is_array($dbfilters_info))? ((isset($temp['total'])?$temp['total']:0)+$dbfilters_info['total']):$filters_info['total'];

		$from=($page*$view_info['page_count'])+1;
		$to=($page*$view_info['page_count'])+$view_info['page_count'];
		$view_info['view_count']=count($view_details); 
		$filters_info['changes_count']=(!$filters || $filters==-1)?0:count($filters);
		$filters_info['page']=$page;		 
		$filters_info['count_from']=$from;
		$filters_info['count_to']= $to;
		if($filters_info['count_to']>$filters_info['total'])
			$filters_info['count_to']=$filters_info['total'];
		
		
		
		if(isset($operation['vis_search_for']) && $operation['vis_search_for']==1){
			$view_info['page_count']=($filters_ticketcount==0)?0:ceil($filters_ticketcount/$ttotpg);
		}else if(isset($operation['vis_search_for']) && $operation['vis_search_for']==8){
			$view_info['page_count']=($filters_incidentscount==0)?0:ceil($filters_incidentscount/$ttotpg);
		}else if(isset($operation['vis_search_for']) && $operation['vis_search_for']==2){
			$view_info['page_count']=($filters_changescount==0)?0:ceil($filters_changescount/$ttotpg);
		}else if(isset($operation['vis_search_for']) && $operation['vis_search_for']==3){
			$view_info['page_count']=($filters_problemcount==0)?0:ceil($filters_problemcount/$ttotpg);
		}else if(isset($operation['vis_search_for']) && $operation['vis_search_for']==4){
			$view_info['page_count']=($filters_releasescount==0)?0:ceil($filters_releasescount/$ttotpg);
		}else{
			$view_info['page_count']=($filters_info['total']==0)?0:ceil($filters_info['total']/$view_info['page_count']);
		}	
		if(isset($filters) && $filters!=-1){ 
			for($i=0;$i<count($filters);$i++) {
				if($filters[$i]['is_report']==1){					
					$criteria_detail=$object->get_search_criteria('(FC.base_criteria=16 or FC.base_criteria=12) and FC.filter_id='.$filters[$i]['filter_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
					$durationdate=explode('=',$criteria_detail[0]['content']);
					$filters[$i]['fromdate']=isset($durationdate[0])?$durationdate[0]:'';
					$filters[$i]['todate']=isset($durationdate[1])?$durationdate[1]:'';
				} else if($filters[$i]['is_report']==9&&$filters[$i]['filter']==''){
					$criteria_detail=$object->get_cmdbsearch_criteria('FC.filter_id='.$filters[$i]['filter_id'].' and FC.is_report=9', VIS_STAFF_ID, VIS_LOCATION_AREA,2);
					$filters[$i]['fromdate']=$criteria_detail[0]['from_date'];
					$filters[$i]['todate']=$criteria_detail[0]['to_date'];
				} else {
					$criteria_detail=$object->get_search_criteria('FC.filter_id='.$filters[$i]['filter_id'], VIS_STAFF_ID, VIS_LOCATION_AREA,2);
					$filters[$i]['fromdate']=$criteria_detail[0]['to_date'];
					$filters[$i]['todate']=$criteria_detail[0]['from_date'];
				}
			}
		} 
		
		if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1) || (isset($operation['vis_action']) && $operation['vis_action']=='no_load')){ 
			ob_start();
			include(VIS_PATH_TEMPLATE.'custom_filter_list.php');
			$customreport_list = ob_get_clean();
			echo json_encode( array('total_count'=>$filters_info['total'], 'list_data'=> $customreport_list,'last_count'=>$filters_info['count_to'],'first_count'=>$paging_form_page+1,'page_count'=>$view_info['page_count']));
			return true;
		} else { 
			include(VIS_PATH_TEMPLATE.'custom_filter_list.php');
		}
		$database->database_disconnect();
		return true;
	}		

	function custom_report_detail($operation) 
	{
		global $vis_language;
		$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
		$action=explode($spliter, $operation['vis_action']);
		if(!isset($action[4]) || trim($action[4])=='') {
			$message=$vis_language['MSGFILTIDNTFND'];
			return false;
		}
		if(isset($action[4]) && $action[4]!='' && is_numeric($action[4])) {
			$database=new class_database();
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'client.php');
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			$ticket=new class_ticket($database);
			$client=new class_client($database);
			$setting=new class_setting($database);
			include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'client.php'); 
			include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php'); 
			$object_client = new client();
			$object_ticket = new ticket();
			$ticket_types=$object_ticket->get_properties('get_types', '');
			$domain_list=$object_client->get_domain_access_list();
			$user_groups=$client->get_client_group(' (domain_id in ('.$domain_list.') or domain_id=0 ) and is_enable=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
			$domains=$ticket->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1','','','', VIS_STAFF_ID, VIS_LOCATION_AREA); 
			$departments=$ticket->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA);
			$status=$object_ticket->get_properties('get_status', '');
			$priorities=$object_ticket->get_properties('get_priorities', '');
			$flags=$object_ticket->get_properties('get_flags', '');
			$owner=$object_ticket->get_properties('get_staff', '');
			list($sinfo, $sla)=$setting->get_sla(VIS_TABLE_PREFIX.'sla.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
			$search_details=$ticket->get_search_detail('F.filter_id='.$action[4], VIS_STAFF_ID, VIS_LOCATION_AREA);
			$search_details=$search_details[0];
			$criteria_detail=$ticket->get_search_criteria('FC.filter_id='.$action[4], VIS_STAFF_ID, VIS_LOCATION_AREA);
			$lang_dt=$setting->get_language('language_id!=1 AND is_enabled=1', '', 0, '', 0, VIS_LOCATION_AREA);
			list($info, $client_language)=$lang_dt;
            $status_lang=$setting->get_translation(38, 'language_id!=1 AND data_id='.$action[4],VIS_STAFF_ID, VIS_LOCATION_AREA);
			$label_details=$object_ticket->get_properties('get_labels', ''); // label list 
			$channel_details=$object_ticket->get_properties('get_channel', '');
			$category_details=$object_ticket->get_properties('get_category', '');		
			$subcategory_details=$object_ticket->get_properties('get_subcategory', '');
			$item_details=$object_ticket->get_properties('get_item', '');
			$level_details=$object_ticket->get_properties('get_level', '');
			$location_details=$object_ticket->get_properties('get_location', '');
			$urgency = $ticket->get_urgency_list(VIS_STAFF_ID, VIS_LOCATION_AREA, 'is_enabled=1');
			$impact=$setting->get_properties('get_impacts', 'is_enabled=1'); $impact=$impact[1];
			$database->database_disconnect();
			include(VIS_PATH_TEMPLATE.'filter_update.php');
			return true;
		}
	}					

	function update_custom_report($operation) 
	{
		global $vis_language;
		$data=parse_form_array($operation['vis_action']); 
		if(!isset($data['vis_filter_title']) || $data['vis_filter_title']=='') {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
			return false;
		}
		
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		$object=new class_ticket($database); 
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
		$changes_object=new class_changes($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$setting_object=new class_setting($database);
		$chkcustomup=0;
		if(isset($operation['vis_action'])){  
			$data=parse_form_array($operation['vis_action']); 
		    
		}
		list($ret, $msg) = $this->report_date_range_validation($data['vis_from_date'], $data['vis_to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '"); </script>';
                        return false;
                    }
		if($operation['vis_is_report']==2 || $operation['vis_is_report']==3 || $operation['vis_is_report']==4 || $operation['vis_is_report']==8 || $operation['vis_is_report']==9){
			$ret=$changes_object->update_filter($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
			$chkcustomup=1;	
		}else{
			$ret=$object->update_filter($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		}
		
		if($ret){
			$search_details=$object->get_search_detail('F.filter_id='.$data['vis_filter_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
			$search_details=$search_details[0];
			if($search_details['vscope']==1){
				$msg='Update custom report -'.$search_details['filter_name']; $moduleid=12;
				$setting_object->add_staff_activity_log($msg,VIS_STAFF_ID,$moduleid, VIS_LOCATION_AREA);	
			}
		}
		$database->database_disconnect();
		$operation['vis_current_operation']='report_list';
		$operation['vis_current_module']='report';
		$operation['leftmenu_flag']='2'; 
		$operation['show_report']='2';
		$operation['show_report_active']='2';
		$action=$operation['vis_action'];
		$operation['vis_is_report']=(isset($operation['vis_is_report'])) ? $operation['vis_is_report']:0;		 
		
		if($chkcustomup){
		
		}
		
		if(!$ret) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
			return false;
		} else {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTREPORTS'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'", "vis_form":"vis_search_update_form", "vis_custom": "0", "vis_is_report":1, "leftmenu_flag": "2", "show_report": "2", "show_report_active": "2"}); </script>';
		}
		return true;
	}		

	function new_custom_report($operation) 
	{
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'client.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$ticket=new class_ticket($database);
		$client=new class_client($database);
		$setting=new class_setting($database);
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'client.php'); 
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$object_client = new client();
		$object_ticket = new ticket();
		$operation['show_report']=6;
		$filters=$ticket->get_filters_details('vscope=1 and owner='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$ticket_types=$object_ticket->get_properties('get_types', '');
		$domain_list=$object_client->get_domain_access_list();
		$user_groups=$client->get_client_group(' (domain_id in ('.$domain_list.') or domain_id=0 ) and is_enable=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$domains=$ticket->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA);
		$departments=$ticket->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA);
		$status=$object_ticket->get_properties('get_status', '');
		$priorities=$object_ticket->get_properties('get_priorities', '');
		$flags=$object_ticket->get_properties('get_flags', '');
		$owner=$object_ticket->get_properties('get_staff', '');
		list($sinfo, $sla)=$setting->get_sla(VIS_TABLE_PREFIX.'sla.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$lang_dt=$setting->get_language('is_enabled=1', '', 0, '', 0, VIS_LOCATION_AREA);
		list($info, $client_language)=$lang_dt;
		$label_details=$object_ticket->get_properties('get_labels', '');
		$channel_details=$object_ticket->get_properties('get_channel', '');
		$category_details=$object_ticket->get_properties('get_category', '');
		$subcategory_details=$object_ticket->get_properties('get_subcategory', '');
		$item_details1=$object_ticket->get_properties('get_item', '');
		$item_details=$item_details1;
		if($item_details1!=-1){
			for($i=0;$i<count($item_details1);$i++){
				$item_details[$i]['title']=$item_details1[$i]['subcat_title']."-".$item_details1[$i]['title'];
			}
		}
		$level_details=$object_ticket->get_properties('get_level', '');
		$location_details=$object_ticket->get_properties('get_location', '');
		if(defined('AGENTTYPE') && AGENTTYPE!='VIS_BASEHD') {
			$urgency = $ticket->get_urgency_list(VIS_STAFF_ID, VIS_LOCATION_AREA, 'is_enabled=1');
			$impact=$setting->get_properties('get_impacts', 'is_enabled=1'); $impact=$impact[1];
		}
		$database->database_disconnect();
		include(VIS_PATH_TEMPLATE.'search.php');
		return true;
	}	
	
	function view_incident_custom_report($operation) 
	{	
		$database=new class_database();
		if(isset($operation['vis_action'])){  
			$data=parse_form_array($operation['vis_action']); 
		   	$operation=array_merge($operation,$data);
		}
		$operation['custom_show_report']=8; 
		$operation['custom_show_report']=(isset($operation['custom_show_report']))?8:''; 
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view(VIS_STAFF_ID, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='view_custom_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		$object=new class_ticket($database);
		$filters_ticketcount=$object->get_filters_details('vscope=1 and is_report=1 and owner='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA,'');
		if(defined('AGENTTYPE') && AGENTTYPE=='VIS_ENTSD'){
			$filters_changescount=$object->get_filters_details('vscope=1 and is_report=2 and owner='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA,'');
			$filters_problemcount=$object->get_filters_details('vscope=1 and is_report=3 and owner='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA,'');
			$filters_releasescount=$object->get_filters_details('vscope=1 and is_report=4 and owner='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA,'');
		}
		$filters_allcount=$object->get_filters_details('vscope=1 and is_report!=0 and owner='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA,'');
		if(isset($operation['vis_search_for']) && $operation['vis_search_for']==1){
			$filter='vscope=1 and is_report=1 and owner='.VIS_STAFF_ID;			
		} else if(isset($operation['vis_search_for']) && $operation['vis_search_for']==2 && (defined('AGENTTYPE') && AGENTTYPE=='VIS_ENTSD')){
			$filter='vscope=1 and is_report=2 and owner='.VIS_STAFF_ID;			
		} else if(isset($operation['vis_search_for']) && $operation['vis_search_for']==3 && (defined('AGENTTYPE') && AGENTTYPE=='VIS_ENTSD')){
			$filter='vscope=1 and is_report=3 and owner='.VIS_STAFF_ID;			
		} else if(isset($operation['vis_search_for']) && $operation['vis_search_for']==4 && (defined('AGENTTYPE') && AGENTTYPE=='VIS_ENTSD')){
			$filter='vscope=1 and is_report=4 and owner='.VIS_STAFF_ID;			
		} else {
			$filter='vscope=1 and is_report=1 and owner='.VIS_STAFF_ID;			
		} 
		$filters=$object->get_filters_details($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,$limit);
		$filters_info=$object->get_filters_details($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,'',1);
		$from=($page*$view_info['page_count'])+1;
		$to=($page*$view_info['page_count'])+$view_info['page_count'];
		$view_info['page_count']=($filters_info['total']==0)?0:ceil($filters_info['total']/$view_info['page_count']);
		$view_info['view_count']=count($view_details); 
		$filters_info['changes_count']=(!$filters || $filters==-1)?0:count($filters);
		$filters_info['page']=$page;		 
		$filters_info['count_from']=$from;
		$filters_info['count_to']= $to;
		if($filters_info['count_to']>$filters_info['total'])
			$filters_info['count_to']=$filters_info['total'];
		
		if(isset($filters) && $filters!=-1){ 
			for($i=0;$i<count($filters);$i++) {
				if($filters[$i]['is_report']==1){
					$criteria_detail=$object->get_search_criteria('(FC.base_criteria=16 or FC.base_criteria=12) and FC.filter_id='.$filters[$i]['filter_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
					$durationdate=explode('=',$criteria_detail[0]['content']);
					$filters[$i]['fromdate']=isset($durationdate[0])?$durationdate[0]:'';
					$filters[$i]['todate']=isset($durationdate[1])?$durationdate[1]:'';
				} else {
					$criteria_detail=$object->get_search_criteria('FC.filter_id='.$filters[$i]['filter_id'], VIS_STAFF_ID, VIS_LOCATION_AREA,2);
					$filters[$i]['fromdate']=$criteria_detail[0]['to_date'];
					$filters[$i]['todate']=$criteria_detail[0]['from_date'];
				}
			}
		} 
		if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1) || (isset($operation['vis_action']) && $operation['vis_action']=='no_load')){ 
			ob_start();
			include(VIS_PATH_TEMPLATE.'custom_filter_list.php');
			$customreport_list = ob_get_clean();
			echo json_encode( array('total_count'=>$filters_info['total'], 'list_data'=> $customreport_list,'last_count'=>$filters_info['count_to'],'first_count'=>$paging_form_page+1,'page_count'=>$view_info['page_count']));
			return true;
		} else { 
			include(VIS_PATH_TEMPLATE.'view_incident_custom_report.php');
		}
		$database->database_disconnect();
		return true;
	}		
	function new_incident_custom_report($operation) 
	{
		$database=new class_database(); 
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'client.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$ticket=new class_ticket($database);
		$client=new class_client($database);
		$setting=new class_setting($database);
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'client.php'); 
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$object_client = new client();
		$object_ticket = new ticket();
		$operation['show_report']=6;
		$filters=$ticket->get_filters_details('vscope=1 and owner='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$ticket_types=$object_ticket->get_properties('get_types', '');
		$domain_list=$object_client->get_domain_access_list();
		$user_groups=$client->get_client_group(' (domain_id in ('.$domain_list.') or domain_id=0 ) and is_enable=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$domains=$ticket->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA);
		$departments=$ticket->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA);
		$dept_list=0;
		 if(defined('VIS_ANY_DEPT') && VIS_ANY_DEPT==1){
						$dept_list = $ticket->get_all_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA, VIS_TABLE_PREFIX.'domain.domain_id');
				}
                else { $dept_list = $ticket->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1' ,VIS_STAFF_ID, VIS_LOCATION_AREA, VIS_TABLE_PREFIX.'domain.domain_id');
					 }
        
		$status=$object_ticket->get_properties('get_status', '');
		$priorities=$object_ticket->get_properties('get_priorities', '');
		$flags=$object_ticket->get_properties('get_flags', '');
		$owner=$object_ticket->get_properties('get_staff', '');
		list($sinfo, $sla)=$setting->get_sla(VIS_TABLE_PREFIX.'sla.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$lang_dt=$setting->get_language('is_enabled=1', '', 0, '', 0, VIS_LOCATION_AREA);
		list($info, $client_language)=$lang_dt;
		$label_details=$object_ticket->get_properties('get_labels', '');
		$channel_details=$object_ticket->get_properties('get_channel', '');
		$category_details=$object_ticket->get_properties('get_category', '');
		$subcategory_details=$object_ticket->get_properties('get_subcategory', '');
		$item_details1=$object_ticket->get_properties('get_item', '');
		$item_details=$item_details1;
		if($item_details1!=-1){
			for($i=0;$i<count($item_details1);$i++){
				$item_details[$i]['title']=$item_details1[$i]['subcat_title']."-".$item_details1[$i]['title'];
			}
		}
		$level_details=$object_ticket->get_properties('get_level', '');
		$location_details=$object_ticket->get_properties('get_location', '');
		if(defined('AGENTTYPE') && AGENTTYPE!='VIS_BASEHD') {
			$urgency = $ticket->get_urgency_list(VIS_STAFF_ID, VIS_LOCATION_AREA, 'is_enabled=1');
			$impact=$setting->get_properties('get_impacts', 'is_enabled=1'); $impact=$impact[1];
		}
		$database->database_disconnect();
		include(VIS_PATH_TEMPLATE.'incident_custom_report.php');
		return true;
	}
	function incident_custom_report_details($operation) 
	{
		global $vis_language;
		$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
		$action=explode($spliter, $operation['vis_action']);
		if(!isset($action[4]) || trim($action[4])=='') {
			$message=$vis_language['MSGFILTIDNTFND'];
			return false;
		}
		if(isset($action[4]) && $action[4]!='' && is_numeric($action[4])) {
		$database=new class_database(); 
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'client.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$ticket=new class_ticket($database);
		$client=new class_client($database);
		$setting=new class_setting($database);
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'client.php'); 
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$object_client = new client();
		$object_ticket = new ticket();
		$operation['show_report']=6;
			$criteria_detail=$ticket->get_search_criteria('FC.filter_id='.$action[4], VIS_STAFF_ID, VIS_LOCATION_AREA,2);
			$criteria_detail=$criteria_detail[0]; 
			$search_details=$ticket->get_filters_details('filter_id= '.$action[4],VIS_STAFF_ID, VIS_LOCATION_AREA);
			$search_details=$search_details[0];
		$ticket_types=$object_ticket->get_properties('get_types', '');
		$domain_list=$object_client->get_domain_access_list();
		$user_groups=$client->get_client_group(' (domain_id in ('.$domain_list.') or domain_id=0 ) and is_enable=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$domains=$ticket->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA);
		$departments=$ticket->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA);
		$dept_list=0;
		 if(defined('VIS_ANY_DEPT') && VIS_ANY_DEPT==1){
						$dept_list = $ticket->get_all_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA, VIS_TABLE_PREFIX.'domain.domain_id');
				}
                else { $dept_list = $ticket->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1' ,VIS_STAFF_ID, VIS_LOCATION_AREA, VIS_TABLE_PREFIX.'domain.domain_id');
					 }
        
		$status=$object_ticket->get_properties('get_status', '');
		$priorities=$object_ticket->get_properties('get_priorities', '');
		$flags=$object_ticket->get_properties('get_flags', '');
		$owner=$object_ticket->get_properties('get_staff', '');
		list($sinfo, $sla)=$setting->get_sla(VIS_TABLE_PREFIX.'sla.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$lang_dt=$setting->get_language('is_enabled=1', '', 0, '', 0, VIS_LOCATION_AREA);
		list($info, $client_language)=$lang_dt;
		$label_details=$object_ticket->get_properties('get_labels', '');
		$channel_details=$object_ticket->get_properties('get_channel', '');
		$category_details=$object_ticket->get_properties('get_category', '');
		$subcategory_details=$object_ticket->get_properties('get_subcategory', '');
		$item_details1=$object_ticket->get_properties('get_item', '');
		$item_details=$item_details1;
		if($item_details1!=-1){
			for($i=0;$i<count($item_details1);$i++){
				$item_details[$i]['title']=$item_details1[$i]['subcat_title']."-".$item_details1[$i]['title'];
			}
		}
		$level_details=$object_ticket->get_properties('get_level', '');
		$location_details=$object_ticket->get_properties('get_location', '');
		if(defined('AGENTTYPE') && AGENTTYPE!='VIS_BASEHD') {
			$urgency = $ticket->get_urgency_list(VIS_STAFF_ID, VIS_LOCATION_AREA, 'is_enabled=1');
			$impact=$setting->get_properties('get_impacts', 'is_enabled=1'); $impact=$impact[1];
		}
		$database->database_disconnect();
		include(VIS_PATH_TEMPLATE.'incident_custom_report_details.php');
		return true;
		}
	}
	
	function view_assets_custom_report($operation) 
	{	
		$database=new class_database();
		if(isset($operation['vis_action'])){  
			$data=parse_form_array($operation['vis_action']); 
		   	$operation=array_merge($operation,$data);
		}
		$operation['custom_show_report']=9; 
		$operation['custom_show_report']=(isset($operation['custom_show_report']))?9:''; 
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view(VIS_STAFF_ID, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='view_custom_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		$object=new class_ticket($database);
		$filters_ticketcount=$object->get_filters_details('vscope=1 and is_report=1 and owner='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA,'');
		if(defined('AGENTTYPE') && AGENTTYPE=='VIS_ENTSD'){
			$filters_changescount=$object->get_filters_details('vscope=1 and is_report=2 and owner='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA,'');
			$filters_problemcount=$object->get_filters_details('vscope=1 and is_report=3 and owner='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA,'');
			$filters_releasescount=$object->get_filters_details('vscope=1 and is_report=4 and owner='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA,'');
		}
		$filters_allcount=$object->get_filters_details('vscope=1 and is_report!=0 and owner='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA,'');
		if(isset($operation['vis_search_for']) && $operation['vis_search_for']==1){
			$filter='vscope=1 and is_report=1 and owner='.VIS_STAFF_ID;			
		} else if(isset($operation['vis_search_for']) && $operation['vis_search_for']==2 && (defined('AGENTTYPE') && AGENTTYPE=='VIS_ENTSD')){
			$filter='vscope=1 and is_report=2 and owner='.VIS_STAFF_ID;			
		} else if(isset($operation['vis_search_for']) && $operation['vis_search_for']==3 && (defined('AGENTTYPE') && AGENTTYPE=='VIS_ENTSD')){
			$filter='vscope=1 and is_report=3 and owner='.VIS_STAFF_ID;			
		} else if(isset($operation['vis_search_for']) && $operation['vis_search_for']==4 && (defined('AGENTTYPE') && AGENTTYPE=='VIS_ENTSD')){
			$filter='vscope=1 and is_report=4 and owner='.VIS_STAFF_ID;			
		} else {
			$filter='vscope=1 and is_report=1 and owner='.VIS_STAFF_ID;			
		} 
		$filters=$object->get_filters_details($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,$limit);
		$filters_info=$object->get_filters_details($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,'',1);
		$from=($page*$view_info['page_count'])+1;
		$to=($page*$view_info['page_count'])+$view_info['page_count'];
		$view_info['page_count']=($filters_info['total']==0)?0:ceil($filters_info['total']/$view_info['page_count']);
		$view_info['view_count']=count($view_details); 
		$filters_info['changes_count']=(!$filters || $filters==-1)?0:count($filters);
		$filters_info['page']=$page;		 
		$filters_info['count_from']=$from;
		$filters_info['count_to']= $to;
		if($filters_info['count_to']>$filters_info['total'])
			$filters_info['count_to']=$filters_info['total'];
		
		if(isset($filters) && $filters!=-1){ 
			for($i=0;$i<count($filters);$i++) {
				if($filters[$i]['is_report']==1){
					$criteria_detail=$object->get_search_criteria('(FC.base_criteria=16 or FC.base_criteria=12) and FC.filter_id='.$filters[$i]['filter_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
					$durationdate=explode('=',$criteria_detail[0]['content']);
					$filters[$i]['fromdate']=isset($durationdate[0])?$durationdate[0]:'';
					$filters[$i]['todate']=isset($durationdate[1])?$durationdate[1]:'';
				} else {
					$criteria_detail=$object->get_search_criteria('FC.filter_id='.$filters[$i]['filter_id'], VIS_STAFF_ID, VIS_LOCATION_AREA,2);
					$filters[$i]['fromdate']=$criteria_detail[0]['to_date'];
					$filters[$i]['todate']=$criteria_detail[0]['from_date'];
				}
			}
		} 
		if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1) || (isset($operation['vis_action']) && $operation['vis_action']=='no_load')){ 
			ob_start();
			include(VIS_PATH_TEMPLATE.'custom_filter_list.php');
			$customreport_list = ob_get_clean();
			echo json_encode( array('total_count'=>$filters_info['total'], 'list_data'=> $customreport_list,'last_count'=>$filters_info['count_to'],'first_count'=>$paging_form_page+1,'page_count'=>$view_info['page_count']));
			return true;
		} else { 
			include(VIS_PATH_TEMPLATE.'view_incident_custom_report.php');
		}
		$database->database_disconnect();
		return true;
	}		
	function assets_custom_report($operation) 
	{
		global $vis_language; 
		$edit_search_details='';
		$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
		$action=explode($spliter, $operation['vis_action']);
		if(!isset($action[4]) || trim($action[4])=='') {
			$message=$vis_language['MSGFILTIDNTFND'];
			return false;
		}
					
		$vis_save_filter_title=0;
		
		$filter_name="Search result";
		if((isset($operation['vis_save_filter_title']) && $operation['vis_save_filter_title']==1) && ( isset($operation['vis_save_filerid']) && $operation['vis_save_filerid']!=0))
		{
			if(isset($operation['vis_save_filter_title']) && $operation['vis_save_filter_title']==1)
			{
			$vis_save_filter_title=1;
			}
			
			if(isset($operation['vis_filter_name']) && $operation['vis_filter_name']!=''){
				$filter_name=$operation['vis_filter_name'];
			}
		}
		
		$database=new class_database(); 
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'client.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$ticket=new class_ticket($database);
		$client=new class_client($database);
		$setting=new class_setting($database);
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'client.php'); 
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$object_client = new client();
		$object_ticket = new ticket();
		$operation['show_report']=6;
		$editsearch=array();

		if(isset($action[4]) && $action[4]!='' && is_numeric($action[4]) && ($action[3]!='report' && $action[4]!=9))
		{

			$criteria_detail=$ticket->get_cmdbsearch_criteria('FC.filter_id='.$action[4].' and is_report=9', VIS_STAFF_ID, VIS_LOCATION_AREA, 2);
			if ($criteria_detail==-1) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGACCSSDND'].'"); </script>';
	 			return false;
			}
			$editsearch['fromdate']=$criteria_detail[0]['from_date'];
			$editsearch['todate']=$criteria_detail[0]['to_date'];

			$criteria=$ticket->get_cmdbsearch_criteria('FC.filter_id='.$action[4], VIS_STAFF_ID, VIS_LOCATION_AREA);
			if($criteria!=-1){
				for($c=0; $c<count($criteria);$c++){
					switch ($criteria[$c]['base_criteria']) {
						case 1:
							$operation['ci_type_id']=$editsearch['ci_type_id']=$criteria[$c]['content'];
							break;
						case 2:
							$operation['vis_departmentid']=$editsearch['department_access']=$criteria[$c]['content'];
							break;
						case 3:
							$editsearch['vis_name']=$criteria[$c]['content'];
							break;
						case 4:
							$editsearch['vis_impact']=explode(',', $criteria[$c]['content']);
							break;
						case 5:
							$editsearch['vis_risk_id']=explode(',', $criteria[$c]['content']);
							break;
						case 6:
							$editsearch['vis_lifecycle_id']=explode(',', $criteria[$c]['content']);
							break;
						case 7:
							$editsearch['vis_disposition_id']=explode(',', $criteria[$c]['content']);
							break;
						case 8:
							$editsearch['vis_assetdept_id']=explode(',', $criteria[$c]['content']);
							break;
						case 9:
							$editsearch['location_id']=explode(',', $criteria[$c]['content']);
							break;
						case 10:
							$operation['vis_product_id']=$editsearch['vis_product_id']=explode(',', $criteria[$c]['content']);
							break;
						case 11:
							$operation['vis_vendor_id']=$editsearch['vis_vendor_id']=explode(',', $criteria[$c]['content']);
							break;
						case 12:
							$operation['vis_warranty_year']=$editsearch['warranty_year']=$criteria[$c]['content'];
							break;
						case 13:
							$operation['vis_warranty_month']=$editsearch['warranty_month']=$criteria[$c]['content'];
							break;
						case 14:
							$operation['vis_model_id']=$editsearch['vis_model_id']=explode(',', $criteria[$c]['content']);
							break;
						case 15:
							$operation['vis_installation_date']=$editsearch['vis_installation_date']=$criteria[$c]['content'];
							break;
						case 16:
							$operation['vis_expiry_date']=$editsearch['vis_expiry_date']=$criteria[$c]['content'];
							break;
						case 17:
							$operation['vis_assets_state']=$editsearch['vis_assets_state']=explode(',', $criteria[$c]['content']);
							break;
						case 18:
							$operation['vis_asset_tag']=$editsearch['vis_asset_tag']=$criteria[$c]['content'];
							break;
						case 19:
							$operation['vis_licence_key']=$editsearch['vis_licence_key']=$criteria[$c]['content'];
							break;
						case 20:
							$operation['vis_installation_path']=$editsearch['vis_installation_path']=$criteria[$c]['content'];
							break;
						case 21:
							$editsearch['vis_barcode']=$criteria[$c]['content'];
							break;
						case 22:
							$operation['vis_last_audit_date']=$editsearch['vis_last_audit_date']=$criteria[$c]['content'];
							break;
						case 23:
							$operation['vis_salvage']=$editsearch['vis_salvage']=$criteria[$c]['content'];
							break;
						case 24:
							$operation['vis_depreciation_type']=$editsearch['vis_depreciation_type']=explode(',', $criteria[$c]['content']);
							break;
						case 25:
							$editsearch['vis_useful_life']=$criteria[$c]['content'];
							break;
						case 26:
							$editsearch['vis_ci_property_type']=$criteria[$c]['content'];
							break;
						case 27:
							$operation['vis_software_type']=$editsearch['vis_software_type']=$criteria[$c]['content'];
							break;
						case 28:
							$operation['vis_software_cat']=$editsearch['vis_software_cat']=$criteria[$c]['content'];
							break;
						case 29:
							$operation['vis_manufacturer']=$editsearch['vis_manufacturer']=explode(',', $criteria[$c]['content']);
							break;
						case 30:
							$editsearch['vis_os_installation_date']=$criteria[$c]['content'];
							break;
					}
				}
			}
		}
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'cmdb.php');
		$object_cmdb_fun = new cmdb();
		
		$operation['vis_custom_report_setting']=1;
		$operation['assetflg']='1';
		$operation['vis_config_id']=isset($operation['ci_type_id'])? $operation['ci_type_id']:'';	
		$assets_properties=$object_cmdb_fun->get_assets_properties($operation);

		$filters=$ticket->get_filters_details('vscope=1 and owner='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$ticket_types=$object_ticket->get_properties('get_types', '');
		$domain_list=$object_client->get_domain_access_list();
		$location_assets=$object_ticket->get_properties('get_location', '');
		$user_groups=$client->get_client_group(' (domain_id in ('.$domain_list.') or domain_id=0 ) and is_enable=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
			if(VIS_LOCATION_AREA==4){
				$filter     = VIS_TABLE_PREFIX .'domain.is_enabled=1 ';
				$domain     = $ticket->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
			} else {
				$domains=$ticket->getstaff_domain_mapping('staff_id='.VIS_STAFF_ID,1);
				$domain=$domains['data'];
			}
		$departments=$ticket->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA);
		$dept_list=0;
		 if(defined('VIS_ANY_DEPT') && VIS_ANY_DEPT==1){
						$dept_list = $ticket->get_all_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA, VIS_TABLE_PREFIX.'domain.domain_id');
				}
                else { $dept_list = $ticket->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1' ,VIS_STAFF_ID, VIS_LOCATION_AREA, VIS_TABLE_PREFIX.'domain.domain_id');
					 }
        ////////////////// for ci_type list
		
		$vis_domainid=$domain[0]['domain_id'];
		$filterr = " and is_enabled=1 and (".VIS_TABLE_PREFIX."itil_configuration_item.department_access = 0 OR FIND_IN_SET(".$vis_domainid.", ".VIS_TABLE_PREFIX."itil_configuration_item.department_access)>0)";
		$citype_details_ws=$setting->get_configuration_item($filterr,0, -1, '', VIS_STAFF_ID);
		
		$location_details=$object_ticket->get_properties('get_location', '');
		if(defined('AGENTTYPE') && AGENTTYPE!='VIS_BASEHD') {
			
			$impact=$setting->get_properties('get_impacts', 'is_enabled=1'); $impact=$impact[1];
			list($risk_info, $risk_details)=$setting->get_risk('is_enabled=1', '', '', 'display_order ASC', VIS_STAFF_ID, VIS_LOCATION_AREA);
			list($lifecycle_info, $lifecycle_details)=$setting->get_lifecycle('is_enabled=1', '', '', 'display_order ASC', VIS_STAFF_ID, VIS_LOCATION_AREA);
			list($disposition_info, $disposition_details)=$setting->get_disposition_status('is_enabled=1 ', '', '', 'display_order ASC', VIS_STAFF_ID, VIS_LOCATION_AREA);
			list($assetdept_info, $assetdept_details)=$setting->get_assetdept('is_enabled=1 ', '', '', 'display_order ASC', VIS_STAFF_ID, VIS_LOCATION_AREA);
		}
		$database->database_disconnect();
		include(VIS_PATH_TEMPLATE.'assets_custom_report.php');
		return true;
	}
	
	function ciproperty_assets_custom_report($operation) 
	{
		$database=new class_database(); 		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');		
		$setting=new class_setting($database);		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
        $cmdb_object=new class_cmdb($database);
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'cmdb.php');
		$object_cmdb_fun = new cmdb();
		
		$operation['vis_product_id']='';
		$operation['vis_vendor_id']='';
		$operation['vis_warranty_year']='';
		$operation['vis_warranty_month']='';
		$operation['vis_installation_date']='';
		$operation['vis_expiry_date']='';
		$operation['vis_assets_state']='';
		$operation['vis_asset_tag']='';
		$operation['vis_installation_path']='';
		$operation['vis_licence_key']='';
		$operation['vis_last_audit_date']='';
		$operation['vis_salvage']='';
		$operation['vis_depreciation_type']='';
		$asset_properties='';
		$default_citype='';
		$operation['vis_custom_report_setting']=1;
		$operation['default_citype']=$default_citype;	
		$operation['ci_type_id']=$operation['vis_ci_type_id'];	
		$operation['assetflg']='1';			

		//assets properties		
		$operation['vis_config_id']=$operation['vis_ci_type_id'];	
		$operation['vis_module_section']="add";		
		$operation['vis_departmentid']=$operation['vis_domain_id'];		
		$assets_properties=$object_cmdb_fun->get_assets_properties($operation);		
		echo $assets_properties;
		
		$database->database_disconnect();
		return true;
	}
	function save_customfilter($operation) 
	{
		include(VIS_PATH_TEMPLATE.'save_customfilter.php');
		return true;
	}		

	function custom_search_result($operation) 
	{
		global $vis_language; 
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		if(VIS_LOCATION_AREA==0) $data=$operation;
		else $data=parse_form_array($operation['vis_action']);
		$object=new class_ticket($database);
		if(isset($data['vis_report']) && $data['vis_report']==1){
			$from_date = strtotime($data['vis_from_date']);
			$to_date = strtotime($data['vis_to_date']);
			list($ret, $msg) = $this->report_date_range_validation($data['vis_from_date'], $data['vis_to_date']);
			if (!$ret){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '"); </script>';
				return false;
			}
		}
		$filterid=$object->set_filter($data, 0, VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		$database->database_disconnect();
		if(VIS_LOCATION_AREA==0) {
			if(!$filterid) echo 'error';
			else{
				$operation['vis_filter_id']=$filterid;

				return $this->get_tickets($operation);
			}
		} else {
			if(!$filterid)
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
			else
				echo '<script> $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTREPORTS'].'", {"vis_module":"report", "vis_operation":"custom_report_result", "vis_search":'.$operation['vis_search'].', "vis_filter_id":'.$filterid.', "vis_action":"#/report/custom_report_result/'.$vis_language['TXTSEARCHRESULT'].'/'.$filterid.'", "vis_report":1}); </script>';
		}
		return true;
	}	

	function custom_search_save($operation) 
	{
		global $vis_language;
		$data=parse_form_array($operation['vis_action']);
		if(!isset($operation['vis_filter_title']) || $operation['vis_filter_title']=='') {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGFLRTTTMISS'].'"); </script>';
			return false;
		}
		$data['vis_filter_title']= $operation['vis_filter_title'];
		$data['vis_is_report']= $operation['vis_is_report'];
		$is_report=$data['vis_is_report'];
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		$object=new class_ticket($database);
		if((isset($data['vis_from_date']) && $data['vis_from_date']!='') && (isset($data['vis_to_date']) && $data['vis_to_date']!='')){
			list($ret, $msg) = $this->report_date_range_validation($data['vis_from_date'], $data['vis_to_date']);

			if (!$ret) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '"); </script>';
				return false;
			}
		}
		$opfunction='custom_report_result';
		if(isset($operation['vis_is_report']) && ($operation['vis_is_report']==2 || $operation['vis_is_report']==3 || $operation['vis_is_report']==4 || $operation['vis_is_report']==8 || $operation['vis_is_report']==9)){
			$opfunction=($operation['vis_is_report']==9)? 'custom_report_result_assets':'custom_report_result_itil';
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
			$chng_object=new class_changes($database);
			$filterid=$chng_object->set_filter($data, 1, VIS_STAFF_ID, VIS_LOCATION_AREA);
		} else {
			$filterid=$object->set_filter($data, 1, VIS_STAFF_ID, VIS_LOCATION_AREA);
		}
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$setting_object=new class_setting($database);		
		if ($filterid && $operation['vis_is_report']==9) {
			$search_details=$object->get_cmdbsearch_detail('F.filter_id='.$filterid, VIS_STAFF_ID, VIS_LOCATION_AREA);
			$search_details=$search_details[0];
			if($search_details['vscope']==1){
				$msg='Add custom report -'.$search_details['filter_name']; $moduleid=12;
				$setting_object->add_staff_activity_log($msg,VIS_STAFF_ID,$moduleid, VIS_LOCATION_AREA);	
			}
		}elseif($filterid){
			$search_details=$object->get_search_detail('F.filter_id='.$filterid, VIS_STAFF_ID, VIS_LOCATION_AREA);
			$search_details=$search_details[0];
			if($search_details['vscope']==1){
				$msg='Add custom report -'.$search_details['filter_name']; $moduleid=12;
				$setting_object->add_staff_activity_log($msg,VIS_STAFF_ID,$moduleid, VIS_LOCATION_AREA);	
			}
		}
		$database->database_disconnect();
		if(!$filterid)
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
		else
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution(\'load_module\',\''.$search_details['filter_name'].'\', {\'vis_module\':\'report\', \'vis_operation\':\''.$opfunction.'\', \'vis_filter_id\':\''.$filterid.'\',\'vis_is_report\':\''.$operation['vis_is_report'].'\', \'vis_action\':\'#/report/'.$opfunction.'/'.$search_details['filter_name'].'/'.$filterid.'\'});$(".modal").modal("hide"); </script>';
		return true;
	}

	function custom_report_result($operation) 
	{ 
		global $vis_language;			
		if(isset($operation['vis_filter_id']) && is_numeric($operation['vis_filter_id'])) $filter_id=$operation['vis_filter_id']; 
		else if(isset($operation['vis_action']) && $operation['vis_action'] != ""){
			$action=explode("/", $operation['vis_action']);
			if(isset($action[4]) && is_numeric($action[4])) {
				$operation['vis_filter_id'] = $filter_id=$action[4];
			}
		}
		if(isset($operation['vis_page']) && is_numeric($operation['vis_page'])) {
			$page=$operation['vis_page'];
		} else {
			$page=0;
		}
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$ticket_object=new class_ticket($database); 
		$staff=new class_staff($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$filter=$ticket_object->get_filter($filter_id, $staff_id, VIS_LOCATION_AREA);
		$operation['view_title']=$filter['filter_name'];
		$temp=$staff->get_ticket_view($staff_id ,VIS_LOCATION_AREA);
		list($view_info, $view_details)=$temp;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$ticket_info = array();
		$from=($page*$view_info['page_count'])+1;
		$to=($page*$view_info['page_count'])+$view_info['page_count'];
		list($ticket_info, $ticket_details)=$ticket_object->get_ticket($filter['filter'].' and  avis_ticket.draft_id=0 ', $limit, $page, VIS_TABLE_PREFIX.'ticket.receive_date desc ', $staff_id, VIS_LOCATION_AREA);
		$total_cnt = $ticket_info['total'];	

		 
		$report_count= ($ticket_details!=-1)?count($ticket_details):0;
		$view_info['page_count']=($total_cnt==0)?0:ceil($total_cnt/$view_info['page_count']);
		if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1) || (isset($operation['vis_page']) && is_numeric($operation['vis_page']))){
			ob_start();
			$paging_to_page=$paging_form_page+$report_count;
			include(VIS_PATH_TEMPLATE.'custom_rep_ticket_list.php');
			$tkt_list = ob_get_clean(); 
			if(ob_get_contents()) ob_get_flush();
			echo json_encode( array('total_count'=>$total_cnt, 'list_data'=> $tkt_list, 'filter_id'=>$operation['vis_filter_id'],'page_count'=>$view_info['page_count'],'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page));
		} else {
			include(VIS_PATH_TEMPLATE.'custom_rep_ticket.php');
		}
		$database->database_disconnect();
		return true;
	}

	function get_custom_delete($operation) 
	{
		global $vis_language;
		$message_info['vis_form_title']=$vis_language['TXTDELETE'];
		$message_info['vis_message']=$vis_language['MSGSURE'];
		$message_info['vis_event']="$(this).visExecution('load_operations', {'vis_module':'report', 'vis_operation':'custom_report_delete', 'vis_filter_id':".$operation['vis_filter_id'].", 'vis_is_report':".$operation['vis_is_report'].(isset($operation['vis_filter_type'])? ",'vis_filter_type':'new'":'')."})";
		include(VIS_PATH_TEMPLATE.'confirm_delete.php');
		return true;
	}
	
	function custom_report_delete($operation) 
	{
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		$object=new class_ticket($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$setting_object=new class_setting($database);
		if (isset($operation['vis_filter_type'])) {
			$result = $object->delete_cmdbfilter($operation['vis_filter_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
		} else
		$result=$object->delete_filter($operation['vis_filter_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($result){
			if (isset($operation['vis_filter_type']))
				$search_details=$object->get_cmdbsearch_detail('F.filter_id='.$operation['vis_filter_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);			
			else
				$search_details=$object->get_search_detail('F.filter_id='.$operation['vis_filter_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
			$search_details=$search_details[0];
			if($search_details['vscope']==1){
				$msg= $vis_language['TXTDELETE'].' '.strtolower($vis_language['TXTCUSTOMREPORT']).' -'.$search_details['filter_name']; $moduleid=12; 
				$setting_object->add_staff_activity_log($msg,VIS_STAFF_ID,$moduleid, VIS_LOCATION_AREA);	
			}
		}
		$database->database_disconnect();
		if(!$result){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_filter_delete_area").dialog("close"); </script>';
		} else {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module", "'.$vis_language['TXTCUSTOM'].'", {"vis_module":"report", "vis_operation":"report_list", "show_report": "2", "leftmenu_flag": "2"});</script>'; 
		} 
		return $result;
	}

	function client_sla_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTCLIENTSLA'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();

		$export = 1;
		$report_type=6;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
		$cli_object = new class_client($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$domain     = $tkt_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']);
		$paging_form_page=($page*$view_info['page_count']);
		$operation['set_clientblank'] = 0;
		$operation['vis_current_operation']='client_sla_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		list($clinfo, $clients) = $cli_object->get_client(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', $staff_id, VIS_LOCATION_AREA);
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['vis_client_id'] == 0  && $data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] == 0  && $data['vis_client_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] == 0  && $data['vis_client_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] != 0  && $data['vis_client_id'] == 0 && $operation['set_clientblank']==0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTCLIENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 &&  $data['domain_id'] != 0  &&  $data['vis_client_id'] != 0){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$service='';
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;}
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = '(operation_id<=2 or operation_id=50 or operation_id=51 or operation_id=13) and '.VIS_TABLE_PREFIX.'ticket.receive_date between '.$from.' AND '.$to.' and '.VIS_TABLE_PREFIX.'ticket.client_id='.$data['vis_client_id'].' and '.VIS_TABLE_PREFIX.'ticket.domain_id='.$data['domain_id'].$service;
				$filter1 = $data['service_id'] ;	
				$filter = $filter.'#'.$filter1;	
			}
			$temp_filtr = explode('#',$filter);
			$filter = $temp_filtr[0];
			$filter1= $temp_filtr[1];
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$filter .= ' and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX.'ticket.resolution_time!=0 and '.VIS_TABLE_PREFIX.'ticket.due_time!=0 ';
			// $filter .= ' and '.VIS_TABLE_PREFIX.'ticket.ticket_id=38';
			$post_details    = $object->client_sla_report($filter, '', $staff_id, VIS_LOCATION_AREA);
			$resolutionCount = $responseCount = $report_avg = $report_cnt = $replied = $total_time = $replied_ticket_cnt = $submitter = $entry_date = 0;$maintain_date_nw1 =0;$maintain_date_nw = $as_client_or_clientticket=$old_ticket_id=$last_operation_id =0;
			$report          = array();
			$new_info		 = '';
		  
			if ($post_details != -1){
				for($i=0;$i<count($post_details);$i++){
					 //echo "<br> as_client".$post_details[$i]['as_client'];
					 // echo "<br> submitter".$submitter;
					if($old_ticket_id != $post_details[$i]['ticket_id']){
						$report[$post_details[$i]['ticket_id']]['post_date'] = 0;
						$maintain_date_nw1 = $maintain_date_nw=0;
						$report[$post_details[$i]['ticket_id']]['as_client'] = ''; 
						$report[$post_details[$i]['ticket_id']]['count']=0;
						$report[$post_details[$i]['ticket_id']]['tcount']=0;	
						$as_client_or_clientticket=0;
						$last_operation_id =0;
					} 
					$report[$post_details[$i]['ticket_id']]['as_client'] = '';
					if(isset($post_details[$i]['as_client']) && $post_details[$i]['as_client']!="")
					{
						$report[$post_details[$i]['ticket_id']]['as_client'] = $post_details[$i]['as_client'];
					}
					else
					{
						$report[$post_details[$i]['ticket_id']]['as_client'] = '';
					}

					 if($post_details[$i]['operation_id']==13)	{   
							if(!isset($report[$post_details[$i]['ticket_id']]['customsla'])){
								$report[$post_details[$i]['ticket_id']]['customsla']=1;	
							} 
							else{
								$report[$post_details[$i]['ticket_id']]['customsla']++;	
							}  
						 $report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date'];
					 }
					 
					if($post_details[$i]['operation_id']!=13)	{ 
					if($post_details[$i]['operation_id']==0 && $post_details[$i]['operator']==1){
					  	$report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date'];
						//$submitter = $post_details[$i]['operator'];
						 $last_operation_id = $post_details[$i]['operation_id'];
						$as_client_or_clientticket=1;
					} else if($post_details[$i]['operation_id']==1 &&  $post_details[$i]['operator']==1 && $submitter!=1 ){
						if($last_operation_id ==0 && $submitter==2&&$post_details[$i]['as_client']==1){
						 	$report[$post_details[$i]['ticket_id']]['post_date'] = $report[$post_details[$i]['ticket_id']]['post_date'];
						}else{
						  	$report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date'];	
						}

						$last_operation_id = $post_details[$i]['operation_id'];
						$maintain_date_nw1 = $maintain_date_nw; 
						$as_client_or_clientticket=1; 
					} else if($post_details[$i]['operation_id']==50){
						$report[$post_details[$i]['ticket_id']]['pause_date']=$post_details[$i]['entry_date'];
						$last_operation_id = $post_details[$i]['operation_id'];
					} else if($post_details[$i]['operation_id']==51){
						$report[$post_details[$i]['ticket_id']]['resume_date']=$post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['slapause_diff'] += $post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['pause_date'];
						$last_operation_id = $post_details[$i]['operation_id'];
					} else if($post_details[$i]['operation_id']==1 && $post_details[$i]['operator']!=1){
						$last_operation_id = $post_details[$i]['operation_id'];
						if($post_details[$i]['as_client'] == 1){
							$as_client_or_clientticket=1; 
						}
						/*if($submitter == $post_details[$i]['operator'] && $post_details[$i]['as_client']==0){
							if (!isset($report[$post_details[$i]['ticket_id']]['maintain_date']))
							$report[$post_details[$i]['ticket_id']]['maintain_date'] = 0;
							else
							$report[$post_details[$i]['ticket_id']]['maintain_date'] += 0;
						} else */{
							$report[$post_details[$i]['ticket_id']]['post_date']=(isset($report[$post_details[$i]['ticket_id']]['post_date']) && $report[$post_details[$i]['ticket_id']]['post_date']!='')?$report[$post_details[$i]['ticket_id']]['post_date']:0;  
						 	$maintain_date = $post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['post_date'];
							// echo "<br>2 post date  ".$report[$post_details[$i]['ticket_id']]['post_date']." entry dt ".$post_details[$i]['entry_date'];
							 $maintain_date_nw = $post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['post_date'];
							// echo "<br>old maintain_date_nw1 ".$maintain_date_nw1 ;
							$maintain_date_nw = $maintain_date_nw + $maintain_date_nw1;
							if($report[$post_details[$i]['ticket_id']]['ticket_id'] == $post_details[$i]['ticket_id']){
								//
								$report[$post_details[$i]['ticket_id']]['maintain_date'] += $maintain_date;
								$maintain_date_nw1 = $maintain_date_nw;
							} else {
								$report[$post_details[$i]['ticket_id']]['maintain_date'] = $maintain_date;
								$maintain_date_nw1 = 0;
							}
							$report[$post_details[$i]['ticket_id']]['count']=(isset($report[$post_details[$i]['ticket_id']]['count']) && $report[$post_details[$i]['ticket_id']]['count']!='')?$report[$post_details[$i]['ticket_id']]['count']:0;
							/*  $report[$post_details[$i]['ticket_id']]['count']++; */
						}
						//echo "<br> maintain_date ticket ".$report[$post_details[$i]['ticket_id']]['maintain_date'];
						 if(isset($report[$post_details[$i]['ticket_id']]['maintain_date']) && $report[$post_details[$i]['ticket_id']]['maintain_date'] > 0)
							{  
								$report[$post_details[$i]['ticket_id']]['count']++;
								$report[$post_details[$i]['ticket_id']]['tcount']++;
								$report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date'];
								if($as_client_or_clientticket==0){
									//echo "<br>++++++++".$as_client_or_clientticket;
									$report[$post_details[$i]['ticket_id']]['count']=$report[$post_details[$i]['ticket_id']]['count']-1;
									$report[$post_details[$i]['ticket_id']]['tcount']=$report[$post_details[$i]['ticket_id']]['tcount']-1;
								}
							} 
						$new_info = ($post_details[$i]['new_info']!='' && is_string($post_details[$i]['new_info'])) ? $post_details[$i]['new_info'] : '';
						$entry_date = $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['auditlogentry_date'] = $entry_date;
						$operation_id = $post_details[$i]['operation_id'];
						$total_post++;
						$report_cnt++;
					}else{ 
						$report[$post_details[$i]['ticket_id']]['entry_dateee']  = $post_details[$i]['entry_date']; 
					}  // prev 
					$submitter = $post_details[$i]['operator'];
					if (!isset($report[$post_details[$i]['ticket_id']]['start_time'])) {
						$report[$post_details[$i]['ticket_id']]['ticket_hash']     = $post_details[$i]['ticket_hash'];
						$report[$post_details[$i]['ticket_id']]['subject']         = $post_details[$i]['subject'];
						$report[$post_details[$i]['ticket_id']]['ticket_entry']    = $post_details[$i]['receive_date'];
						$report[$post_details[$i]['ticket_id']]['start_time']      = $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['post_date']	   = $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['ticket_priority'] = $post_details[$i]['ticket_priority'];
						$report[$post_details[$i]['ticket_id']]['department_name'] = $post_details[$i]['department_name'];
						$report[$post_details[$i]['ticket_id']]['first_name'] 	   = $post_details[$i]['first_name'];
						$report[$post_details[$i]['ticket_id']]['last_name']	   = $post_details[$i]['last_name'];
						$report[$post_details[$i]['ticket_id']]['email']		   = $post_details[$i]['email'];
						$report[$post_details[$i]['ticket_id']]['group_name']	   = $post_details[$i]['group_name'];
						$report[$post_details[$i]['ticket_id']]['client_id']       = $post_details[$i]['client_id'];
						$report[$post_details[$i]['ticket_id']]['ticket_id']       = $post_details[$i]['ticket_id'];
						$report[$post_details[$i]['ticket_id']]['status_id']       = $post_details[$i]['status_id'];
						$report[$post_details[$i]['ticket_id']]['remain_resolve']  = $post_details[$i]['remain_resolve'];
						$report[$post_details[$i]['ticket_id']]['pause_rtime']	   = $post_details[$i]['pause_rtime'];
						$report[$post_details[$i]['ticket_id']]['resolve_time']    = $post_details[$i]['resolution_time'];
						$report[$post_details[$i]['ticket_id']]['status_name']     = $post_details[$i]['status_name'];
						$report[$post_details[$i]['ticket_id']]['urgency']     = $post_details[$i]['urgency'];
						$report[$post_details[$i]['ticket_id']]['impact']     = $post_details[$i]['impact'];
						$report[$post_details[$i]['ticket_id']]['flag']     = $post_details[$i]['flag'];
						$report[$post_details[$i]['ticket_id']]['type']     =  (isset($post_details[$i]['type']))? $post_details[$i]['type'] :'';
						$report[$post_details[$i]['ticket_id']]['ticket_category']     =  (isset($post_details[$i]['ticket_category']))? $post_details[$i]['ticket_category'] :'';
						$report[$post_details[$i]['ticket_id']]['ticket_sub_cateogy']     =  (isset($post_details[$i]['ticket_sub_cateogy']))? $post_details[$i]['ticket_sub_cateogy'] :'';
						$report[$post_details[$i]['ticket_id']]['ticket_level']     =  (isset($post_details[$i]['ticket_level']))? $post_details[$i]['ticket_level']:'';
						$report[$post_details[$i]['ticket_id']]['sla_name']        = $post_details[$i]['sla_name'];
						$report[$post_details[$i]['ticket_id']]['operator']		   = $post_details[$i]['operator'];
						$report[$post_details[$i]['ticket_id']]['operation_id']	   = $post_details[$i]['operation_id'];
						$report[$post_details[$i]['ticket_id']]['closed_time']	   = $post_details[$i]['closed_time'];
						$report[$post_details[$i]['ticket_id']]['as_client']	   = $post_details[$i]['as_client'];
						$report[$post_details[$i]['ticket_id']]['new_info']		   = $post_details[$i]['new_info'];
						$report[$post_details[$i]['ticket_id']]['applyslaresol_time'] = $post_details[$i]['applyslaresol_time'];
						if (!isset($report[$post_details[$i]['ticket_id']]['tcount']))
						$report[$post_details[$i]['ticket_id']]['tcount']          = 0;
						else
						$report[$post_details[$i]['ticket_id']]['tcount']          += 0;							
						$report[$post_details[$i]['ticket_id']]['lastrepliertime'] = $post_details[$i]['lastrepliertime'];
						$report[$post_details[$i]['ticket_id']]['solve_time']      = 0;
						$report[$post_details[$i]['ticket_id']]['slapause_diff']   = 0;
						$report[$post_details[$i]['ticket_id']]['maintain_date']   = 0;
						$report[$post_details[$i]['ticket_id']]['count']           = 0;
						$report[$post_details[$i]['ticket_id']]['used_sla_seconds']= 0;
						$report[$post_details[$i]['ticket_id']]['total_sla_seconds'] = 0;
						$report[$post_details[$i]['ticket_id']]['auditlogentry_date'] = 0;
						$total_post= 0;
						$report[$post_details[$i]['ticket_id']]['due_date']  =0;
					} elseif($post_details[$i]['old_info']!=''){
						$total_sla_seconds = ($post_details[$i]['due_time'] - $report[$post_details[$i]['ticket_id']]['start_time']);
						$report[$post_details[$i]['ticket_id']]['due_date']  = ($post_details[$i]['due_time'] - $post_details[$i]['lastrepliertime']); 
						$report[$post_details[$i]['ticket_id']]['as_client']	   = $post_details[$i]['as_client']; 
						$report[$post_details[$i]['ticket_id']]['sla_response_time'] = round($maintain_date_nw);		
						 $report[$post_details[$i]['ticket_id']]['used_sla_seconds'] = $report[$post_details[$i]['ticket_id']]['sla_response_time'];
						 $report[$post_details[$i]['ticket_id']]['timestamp'] = $report[$post_details[$i]['ticket_id']]['sla_response_time'];
						$submitter = $post_details[$i]['operator'];
						$operation_id = $post_details[$i]['operation_id'];
						$new_info = ($post_details[$i]['new_info']!='' && is_string($post_details[$i]['new_info'])) ? $post_details[$i]['new_info'] : '';
						$entry_date = $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['auditlogentry_date'] = $entry_date;
						
						$report_cnt++;
					}
				} 
				$old_ticket_id=$post_details[$i]['ticket_id'];
				}
			} else {
				$report = -1;
			}
			//echo "<pre>"; print_r($report);
			$report_new = array();
			$entry_dateeeplus=0;
			$counttikt=0;
			$totrepltime=0;
			$due_datt='';
			$avgtotrepltime=array(); 
			$tcount=0;
			$ttttcount=$auditlogentry_date=0;
			$ttttcountclosansresolv=0;
			$totlavgresposmaintain=0;
			$tottick_avg_tim=0;
			if ($report != -1) { 
				foreach ($report as $ticket_id => $details) { 
					$isUndueSet = 0;
					/* if($details['tcount']>0){ */
					//echo "<br> ticket_id ".$details['ticket_id'];
					//echo "<br> timestamp ".$details['timestamp'];
					//echo "<br> count ".$details['count'];
					//echo "<br> Tcount ".$details['tcount'];
					$report[$ticket_id]['totlavgresposmaintain']=0;
					if($details['tcount']>0 || ($details['tcount']>=0 && $details['count']>0)){
						if($details['lastrepliertime']>0 && $details['ticket_entry']>0){
							$totrepltime = $details['lastrepliertime'] - $details['ticket_entry']; }
							if(isset($totrepltime) && $totrepltime!=0){
								if ($details['tcount']!=0) {
								$avgtotrepltime = count_remain_time(round($totrepltime / $details['tcount']));
								$report[$ticket_id]['avg_tot_replied_time']=$avgtotrepltime;
								$report[$ticket_id]['tot_post_and_reply_time']=$totrepltime;
								}
								$tcount += $details['tcount']; 
								$ttttcount++;
							}
														
						}else{ 
						if(isset($details['status_id']) && $details['status_id']==3 || $details['status_id']==4 && ( isset($details['closed_time']) && $details['closed_time']!='')){
						$totrepltime = $details['closed_time'] - $details['lastrepliertime'];
						$report[$ticket_id]['tot_post_and_reply_time']=$totrepltime;
						}
					}
					if($details['pause_rtime'] == ''){
					if($details['closed_time']=='' && $details['status_id']==3 || $details['status_id']==4 && is_string($new_info)){
						$calculate_resolve_time = $details['auditlogentry_date'] - $details['applyslaresol_time'];
					} else {
						$calculate_resolve_time = $details['resolve_time'] - (isset($details['closed_time']))? $details['closed_time'] :0;
					}
					if ($details['resolve_time'] < 0 && ($details['status_id'] == 3 || $details['status_id'] == 4)) {
						$isUndueSet   = 0;
			
						$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTUNDUE'];
					} else if (($details['resolve_time'] < 0 || $details['remain_resolve'] < 0) && $details['status_id'] != 3  && $details['status_id']!=4) {
						$isUndueSet                                = 0;
						if($details['pause_rtime'] == ''){$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTNOTMAINTAIN'];}else{
						$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTOVERDUE'];}
					} else if (($details['resolve_time'] > 0 || $details['remain_resolve'] > 0) && $details['status_id']!=3  && $details['status_id']!=4) {
						$isUndueSet                                = 0;
 
						if($details['count']!= 0){
							$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTUNDUE'];
 						} else {
 
							$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTNOTRESPONDED']; 
						}
						if(isset($details['lastrepliertime']) && $details['lastrepliertime']>0){
							$report[$ticket_id]['lastrepliertime'] = $details['lastrepliertime'];
						}
					} else {
						$isUndueSet = 1;
						if($calculate_resolve_time > 0){
							if($details['count']!=0)
								$resolutionCount++;
						}
						if($details['closed_time']=='' && (isset($details['status_id']) && ($details['status_id']==4 || $details['status_id']==3))){				
							if($auditlogentry_date==0){ $auditlogentry_date = $details['entry_dateee'];  }	
								// echo "<br>==applyslaresol_time ".$details['applyslaresol_time'];							
							if($auditlogentry_date>0){
							 $report[$ticket_id]['avg_resolution_time'] = count_remain_time($auditlogentry_date - $details['applyslaresol_time']); }
						} else {
							/* $report[$ticket_id]['avg_resolution_time'] = count_remain_time($details['closed_time'] - $details['applyslaresol_time']); */							
							/* if($report[$ticket_id]['customsla']>1)	{ */
							if($report[$ticket_id]['customsla']>0)	{
								$report[$ticket_id]['avg_resolution_time'] = count_remain_time($details['closed_time'] - $details['applyslaresol_time']);
							}	else	{
								$report[$ticket_id]['avg_resolution_time'] = count_remain_time($details['closed_time'] - $details['ticket_entry']);
							}
						}
						if($details['tcount']>=1){ 
							$responseCount++;
						}
					}
					if($details['tcount']==0 && ($details['status_id']==3 || $details['status_id']==4))
					{
						$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTMAINTAIN'];
					} 
					else if(($details['resolve_time'] < 0 || $details['remain_resolve'] < 0) && $details['status_id']!=3 && $details['status_id']!=4) 
					{
						if($responseCount!=0) { $responseCount--; }else{ $responseCount++;} 
						if($details['tcount'] > 1)
						{ 
							$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTMAINTAIN'];
						} 
						else 
						{  
							$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTRESPONDED'];
						}
					} 
					else if($details['tcount']!= 0 && ($details['status_id']==3 || $details['status_id']==4))
					{
						if($details['resolve_time'] < 0 || $details['remain_resolve'] < 0){
							$responseCount--;
							/* $report[$ticket_id]['response_sla'] = $vis_language['TXTNOTMAINTAIN'];  */
							$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTRESPONDED']; 
						} 
						else 
						{
							$report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
							$report[$ticket_id]['totlavgresposmaintain']++;
						}
					} 
					else if (($details['resolve_time'] > 0 || $details['remain_resolve'] > 0) && ($details['status_id']!=3 && $details['status_id']!=4)) 
					{
						if($details['tcount'] > 1)
						{
							$report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
							$report[$ticket_id]['totlavgresposmaintain']++;
						} 
						else 
						{	if ($details['operation_id']==0 && $details['operator']==2) {
							$report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
								if($details['used_sla_seconds'] > 0)	{
										$report[$ticket_id]['totlavgresposmaintain']++;
									}
							}	else{ 
							$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTRESPONDED'];
							}
						}
					}

						if($details['tcount']!=0 && ($details['status_id']==3 || $details['status_id']==4))
						{
							$report[$ticket_id]['response_sla_stat'] = $vis_language['TXTMAINTAIN'];
						}
						else
						{ 
							$report[$ticket_id]['response_sla_stat'] = $vis_language['TXTNOTRESPONDED'];
						} 
					if($isUndueSet == 1 && $resolutionCount>0){
						if($details['status_id']!=3 && $details['status_id']!=4){
							
							if($details['count']!=0){
								$report[$ticket_id]['resolution_sla']   = $vis_language['MSGNOTRESOLVED'];
							} else {
								$report[$ticket_id]['resolution_sla']   = $vis_language['MSGNOTRESOLVED'];
							}
						} else {
							if($details['resolve_time'] < 0){  
								$report[$ticket_id]['resolution_sla'] = $vis_language['TXTNOTMAINTAIN'];
							} else {
							/* $report[$ticket_id]['resolution_sla'] = $vis_language['TXTMAINTAIN'];  */
								if($details['resolve_time']<$details['closed_time']){
                                    $report[$ticket_id]['resolution_sla'] = $vis_language['TXTNOTMAINTAIN'];
                                }else{
                                $report[$ticket_id]['resolution_sla'] = $vis_language['TXTMAINTAIN'];		
                                $ttttcountclosansresolv++;
                                $report[$ticket_id]['totalmaintcont']=1;
	                            }
							}
						}
					} elseif($details['count']==0 && $details['status_id']!=3 && $details['status_id']!=4){ 
						if($details['remain_resolve'] > 0){	$report[$ticket_id]['resolution_sla']   = $vis_language['MSGNOTRESOLVED'];
						}else{ $report[$ticket_id]['resolution_sla']   = $vis_language['TXTOVERDUE']; }
					} elseif($details['count']!=0 && $details['status_id']!=3 && $details['status_id']!=4){
						if($details['remain_resolve'] > 0){	$report[$ticket_id]['resolution_sla']   = $vis_language['MSGNOTRESOLVED'];
						}else{ $report[$ticket_id]['resolution_sla']   = $vis_language['TXTOVERDUE']; }
					} else {
						if($details['count']==0 && $details['status_id']!=3 && $details['status_id']!=4){
							$report[$ticket_id]['resolution_sla']   = $vis_language['TXTNOTMAINTAIN'];
						} else { 
							if($details['closed_time'] > $details['resolve_time'] && ($details['status_id']==3 || $details['status_id']==4)){
								$report[$ticket_id]['resolution_sla']   = $vis_language['TXTNOTMAINTAIN'];
							}else{
								$report[$ticket_id]['resolution_sla']   = $vis_language['TXTMAINTAIN'];
								 $ttttcountclosansresolv++;
								 $report[$ticket_id]['totalmaintcont']=1;
							}
						}
					}
					$cal_timestamp = (isset($details['timestamp'])&&$details['timestamp']!= '' && $details['count'] != '0')? round(($details['timestamp']/$details['count']),2):''; 
					if($details['count']!=0){
						$replied_ticket_cnt+=1;
					} else {
						$replied_ticket_cnt+=0;
					} 
					$report[$ticket_id]['avg_response_time']=($details['count']!=0) ? count_remain_time($cal_timestamp) : (($details['operation_id']==0 && $details['operator']==2) ? '0S': $vis_language['TXTNOTRESPONDED']); 
					if($details['count']!=0)    {
		                    $report[$ticket_id]['avg_response_time'] = count_remain_time($cal_timestamp);
		                } else {             	
			                $report[$ticket_id]['avg_response_time'] = '0 S';	                	
		                }
				if(isset($report[$ticket_id]['avg_tot_replied_time']) && $report[$ticket_id]['avg_tot_replied_time'] >0 ){	
					
				if($details['due_date'] < 0 && $details['tcount']>=1){ 
					if($details['operator']==1 || $details['as_client']==1) {      
                        $report[$ticket_id]['response_sla'] =  $vis_language['TXTNOTMAINTAIN']; 
                    } elseif ($details['lastrepliertime'] > $details['resolve_time']) { 
                        $report[$ticket_id]['response_sla'] =  $vis_language['TXTNOTMAINTAIN'];
                    } else{
                    $report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
                    $report[$ticket_id]['totlavgresposmaintain']++;              
                    }
				} else {
					$report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
					$report[$ticket_id]['totlavgresposmaintain']++;                

				}			
				}else{  
					if((isset($details['response_sla']) && $details['response_sla']==$vis_language['TXTOVERDUE'] && $details['response_sla']!='')) {
						if($details['operator']==1 || $details['as_client']==1) {     
	                        $report[$ticket_id]['response_sla'] = $details['response_sla'];
	                    }  else {
	                    	$report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
	                    	$report[$ticket_id]['totlavgresposmaintain']++;         

	                    }
					} else {	 
						if($details['operator']==1 || $details['as_client']==1) {     
							if($details['due_date'] > 0 && $details['count']>=1) {  
								$report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
								$report[$ticket_id]['totlavgresposmaintain']++;
								} else {  
								if($details['count'] >=1){  
									  $report[$ticket_id]['response_sla'] =  $vis_language['TXTNOTMAINTAIN']; 
								} else {
									 
	                       		$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTRESPONDED'];								
								}
							}
	                    } elseif($report[$ticket_id]['avg_response_time']=='0 S')  {  
	  	                    	$report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
	  	                } else   {
	  	                	 
	                    $report[$ticket_id]['response_sla'] = $vis_language['TXTNOTRESPONDED'];
	                    }
					}
 
				}
                 if($details['count']!=0)
						$responseCount+=1;	

					if($details['count']==0 && $report[$ticket_id]['totlavgresposmaintain']==1){
						$report[$ticket_id]['totlavgresposmaintain'] =0;
					}		
					if($report[$ticket_id]['totlavgresposmaintain'] > 0) {
							$totlavgresposmaintain++;
						}				
				} else $report[$ticket_id]['response_sla'] = 'NA';

				 
			  } 
				foreach (((isset($operation['vis_export']) && $operation['vis_export'] == 1)? $report :array_slice($report, $limit, $view_info['page_count'])) as $p) { 
					$report_new[] = $p;
				}

			}
			$array_summary=array();
            $array_summary['TXTTOTALTICKETSREPLIED']=$ttttcount;
            $array_summary['TXTTOTALAVGRESPONSESLAMAINTAIN']=(($totlavgresposmaintain==0)?0:round((($totlavgresposmaintain/count($report))*100), 2)).'%';
            $array_summary['TXTTOTALAVGRESOLUTIONSLAMAINTAIN']=(($ttttcountclosansresolv==0)?0:round((($ttttcountclosansresolv/count($report))*100), 2)).'%';
			$total = ($report!=-1)?count($report):0;
			$view_info['page']=$page;
			$report_count=($report_new!=-1 || !empty($report_new)) ? count($report_new) : 0;
			$reportCnt = ($report!=-1)?count($report):0;
			$view_info['page_count']=($reportCnt==0)? 0 : ceil($reportCnt/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				$replied_ticket_cnt = 0;
				foreach ($report as $i) {
					foreach ($i as $key => $val) {
						if ($key == 'sla_time'){
							$report_exp[$j]['SLA'] = count_remain_time($val);
						} elseif ($key == 'ticket_entry'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'due_time'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'resolve_time'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'ticket_hash' || $key == 'subject' || $key == 'department_name' || $key == 'ticket_priority' || $key == 'status_name' ||  $key == 'type' ||  $key == 'impact' ||  $key == 'urgency' ||  $key == 'flag'  ||  $key == 'ticket_category'  ||  $key == 'ticket_sub_cateogy' || $key == 'ticket_level' || $key == 'sla_name' || $key == 'first_name' || $key == 'last_name' || $key == 'email' || $key == 'group_name'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'avg_resolution_time'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'pause_rtime'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'response_sla'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'resolution_sla'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'avg_response_time'){
							$report_exp[$j][$key] = $val;
						}
					}
					$sla_name = ($report_exp[$j]['sla_name']!= '')?$report_exp[$j]['sla_name']:$vis_language['TXTCUSTDUETIME'];
					if($filter1==0)	{
        				$report_exp1[$j]['incident_or_Service_hash'] = $report_exp[$j]['ticket_hash'];
        			}
        			elseif($filter1==2)	{
        				$report_exp1[$j]['Service_request_hash'] = $report_exp[$j]['ticket_hash'];
        			}
        			else {
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash'];
        			}
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['creation_date'] = $report_exp[$j]['ticket_entry'];
					$report_exp1[$j]['department'] = $report_exp[$j]['department_name'];
					$report_exp1[$j]['client_email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					$report_exp1[$j]['sla_plan'] = $sla_name;
					$report_exp1[$j]['priority'] = $report_exp[$j]['ticket_priority'];
					$report_exp1[$j]['status'] = $report_exp[$j]['status_name'];
					$report_exp1[$j]['type'] = $report_exp[$j]['type'];
					$report_exp1[$j]['urgency'] = $report_exp[$j]['urgency'];
					$report_exp1[$j]['flag'] = $report_exp[$j]['flag'];
					$report_exp1[$j]['impact'] = $report_exp[$j]['impact'];
					$report_exp1[$j]['category'] = $report_exp[$j]['ticket_category'];
					$report_exp1[$j]['sub_category'] = $report_exp[$j]['ticket_sub_cateogy'];
					$report_exp1[$j]['level'] = $report_exp[$j]['ticket_level'];

					$report_exp1[$j]['avg_response_time'] = ($report_exp[$j]['pause_rtime']!='') ? 'NA': $report_exp[$j]['avg_response_time'];
				/*$resolution_flag = ($report_exp[$j]['pause_rtime']!='') ? $report_exp[$j]['pause_rtime'] : 'NA';
					$resolution_time = ($resolution_flag!='') ? count_remain_time($resolution_flag) : $report_exp[$j]['avg_resolution_time'];
					$resolution_time = ($resolution_flag!='') ? (($report_exp[$j]['pause_rtime']!='') ? $vis_language['MSGNOTRESOLVED']:count_remain_time($resolution_flag)): $report_exp[$j]['avg_resolution_time'];*/
					//$resolution_time =  ($report_exp[$j]['pause_rtime']!='') ? 'NA': $report_exp[$j]['avg_resolution_time'];
					if(isset($report_exp[$j]['pause_rtime']) && $report_exp[$j]['pause_rtime']!=''){
					    $report_exp1[$j]['avg_resolution_time']='NA';
					}elseif(isset($report_exp[$j]['status_id']) &&($report_exp[$j]['status_id']==4 || $report_exp[$j]['status_id']==3)){
						$report_exp1[$j]['avg_resolution_time'] = (isset($report_exp[$j]['avg_resolution_time']) && $report_exp[$j]['avg_resolution_time'] !='' )? $report_exp[$j]['avg_resolution_time'] :"Not resolved"; //$resolution_time;
					}else{ 
					 $report_exp1[$j]['avg_resolution_time'] = (isset($report_exp[$j]['resolution_sla']) && $report_exp[$j]['resolution_sla'] !='' ) ? $report_exp[$j]['resolution_sla']: $vis_language['TXTNOTMAINTAIN'];
					}

					//$report_exp1[$j]['resolution_time'] = $resolution_time; 
					$report_exp1[$j]['response_sla'] = ($report_exp[$j]['pause_rtime']!='') ? 'NA':(
						(isset($report_exp[$j]['response_sla']) && $report_exp[$j]['response_sla'] !='' ) ? $report_exp[$j]['response_sla']: $vis_language['MSGNOTRESOLVED']
					);
					$report_exp1[$j]['resolution_sla'] = ($report_exp[$j]['pause_rtime']!='') ? 'NA':(
						(isset($report_exp[$j]['resolution_sla']) && $report_exp[$j]['resolution_sla'] !='' ) ? (
					($report_exp[$j]['resolution_sla']==$vis_language['TXTOVERDUE'])? $vis_language['TXTNOTMAINTAIN']:$report_exp[$j]['resolution_sla']
					):$vis_language['MSGNOTRESOLVED']);
					if($i['count']!=0){
						$replied_ticket_cnt+=1;
					} else {
						$replied_ticket_cnt+=0;
					}
					$j++;
				}

				if($report!=-1){
					foreach($array_summary as $key=>$val){ 
					$title=explode(' ',$key);
					$title[1]=isset($title[1])? ' '.$title[1]:'';
					 $report_exp1[$j][$vis_language[$title[0]].$title[1]]=$vis_language[$title[0]].$title[1].' : '.$val; 
					}
				}
 
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE.'report_page.php');
			} 
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function sla_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTDEPTSLAREPORT'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type=2;
		$export = 1;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object       = new class_ticket($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$departments      = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']);
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='sla_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				$data['department_id'] = (isset($data['department_id']))? $data['department_id']:0;
				if ($data['duration'] == 0 && $data['department_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['department_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDEPARTMENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['department_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$service='';
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.
$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';if($data['service_id']==3)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id=0';}
				$dept_ids = implode(',',$data['department_id']);
				$chk_dept = ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN('.$dept_ids.')';
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];                    
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];                   
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = '(operation_id<=2 or operation_id=50 or operation_id=51 or operation_id=13) and receive_date between '.$from.' AND '.$to.$chk_dept;
				$filter1 = $data['service_id'] ;	
				$filter = $filter.'#'.$filter1;	
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$service = isset($service) ? $service :'';
			$temp_filtr = explode('#',$filter);
			$filter = $temp_filtr[0];
			$filter1= $temp_filtr[1];
			$filter .= ' and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX.'ticket.resolution_time!=0 and '.VIS_TABLE_PREFIX.'ticket.due_time!=0'.$service;
			//$filter .= ' and '.VIS_TABLE_PREFIX.'ticket.ticket_id=38';
			$post_details    = $object->get_sla_report($filter, '', $staff_id, VIS_LOCATION_AREA);
			$report_avg      = $report_cnt = $resolutionCount = $responseCount = $total_time = $submitter = $replied_ticket_cnt	= $entry_date = $entry_dateee=0;
			$maintain_date_nw1 = $maintain_date_nw=$as_client_or_clientticket=$old_ticket_id=$last_operation_id =0;
			$replied         = array();
			$new_info		 = '';
			if ($post_details != -1){
				for($i=0;$i<count($post_details);$i++){
					 //echo "<br> as_client".$post_details[$i]['as_client'];
					 // echo "<br> submitter".$submitter;
					if($old_ticket_id != $post_details[$i]['ticket_id']){
						$report[$post_details[$i]['ticket_id']]['post_date'] = 0;
						$maintain_date_nw1 = $maintain_date_nw=0;
						$report[$post_details[$i]['ticket_id']]['as_client'] = ''; 
						$report[$post_details[$i]['ticket_id']]['count']=0;
						$report[$post_details[$i]['ticket_id']]['tcount']=0;	
						$as_client_or_clientticket=0;
						$last_operation_id =0;
					} 
					$report[$post_details[$i]['ticket_id']]['as_client'] = '';
					if(isset($post_details[$i]['as_client']) && $post_details[$i]['as_client']!="")
					{
						$report[$post_details[$i]['ticket_id']]['as_client'] = $post_details[$i]['as_client'];
					}
					else
					{
						$report[$post_details[$i]['ticket_id']]['as_client'] = '';
					}

					 if($post_details[$i]['operation_id']==13)	{   
							if(!isset($report[$post_details[$i]['ticket_id']]['customsla'])){
								$report[$post_details[$i]['ticket_id']]['customsla']=1;	
							} 
							else{
								$report[$post_details[$i]['ticket_id']]['customsla']++;	
							}  
						 $report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date'];
					 }
					 
					if($post_details[$i]['operation_id']!=13)	{ 
					if($post_details[$i]['operation_id']==0 && $post_details[$i]['operator']==1){
					  	$report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date'];
						//$submitter = $post_details[$i]['operator'];
						 $last_operation_id = $post_details[$i]['operation_id'];
						$as_client_or_clientticket=1;
					} else if($post_details[$i]['operation_id']==1 &&  $post_details[$i]['operator']==1 && $submitter!=1 ){
						if($last_operation_id ==0 && $submitter==2&&$post_details[$i]['as_client']==1){
						 	$report[$post_details[$i]['ticket_id']]['post_date'] = $report[$post_details[$i]['ticket_id']]['post_date'];
						}else{
						  	$report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date'];	
						}

						$last_operation_id = $post_details[$i]['operation_id'];
						$maintain_date_nw1 = $maintain_date_nw; 
						$as_client_or_clientticket=1; 
					} else if($post_details[$i]['operation_id']==50){
						$report[$post_details[$i]['ticket_id']]['pause_date']=$post_details[$i]['entry_date'];
						$last_operation_id = $post_details[$i]['operation_id'];
					} else if($post_details[$i]['operation_id']==51){
						$report[$post_details[$i]['ticket_id']]['resume_date']=$post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['slapause_diff'] += $post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['pause_date'];
						$last_operation_id = $post_details[$i]['operation_id'];
					} else if($post_details[$i]['operation_id']==1 && $post_details[$i]['operator']!=1){
						$last_operation_id = $post_details[$i]['operation_id'];
						if($post_details[$i]['as_client'] == 1){
							$as_client_or_clientticket=1; 
						}
						  
							$report[$post_details[$i]['ticket_id']]['post_date']=(isset($report[$post_details[$i]['ticket_id']]['post_date']) && $report[$post_details[$i]['ticket_id']]['post_date']!='')?$report[$post_details[$i]['ticket_id']]['post_date']:0;  
						 	$maintain_date = $post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['post_date'];
							// echo "<br>2 post date  ".$report[$post_details[$i]['ticket_id']]['post_date']." entry dt ".$post_details[$i]['entry_date'];
							 $maintain_date_nw = $post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['post_date'];
							// echo "<br>old maintain_date_nw1 ".$maintain_date_nw1 ;
							$maintain_date_nw = $maintain_date_nw + $maintain_date_nw1;
							if($report[$post_details[$i]['ticket_id']]['ticket_id'] == $post_details[$i]['ticket_id']){
								//
								$report[$post_details[$i]['ticket_id']]['maintain_date'] += $maintain_date;
								$maintain_date_nw1 = $maintain_date_nw;
							} else {
								$report[$post_details[$i]['ticket_id']]['maintain_date'] = $maintain_date;
								$maintain_date_nw1 = 0;
							}
							$report[$post_details[$i]['ticket_id']]['count']=(isset($report[$post_details[$i]['ticket_id']]['count']) && $report[$post_details[$i]['ticket_id']]['count']!='')?$report[$post_details[$i]['ticket_id']]['count']:0;
							/*  $report[$post_details[$i]['ticket_id']]['count']++; */
						 
						//echo "<br> maintain_date ticket ".$report[$post_details[$i]['ticket_id']]['maintain_date'];
						 if(isset($report[$post_details[$i]['ticket_id']]['maintain_date']) && $report[$post_details[$i]['ticket_id']]['maintain_date'] > 0)
							{  
								$report[$post_details[$i]['ticket_id']]['count']++;
								$report[$post_details[$i]['ticket_id']]['tcount']++;
								$report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date'];
								if($as_client_or_clientticket==0){
									//echo "<br>++++++++".$as_client_or_clientticket;
									$report[$post_details[$i]['ticket_id']]['count']=$report[$post_details[$i]['ticket_id']]['count']-1;
									$report[$post_details[$i]['ticket_id']]['tcount']=$report[$post_details[$i]['ticket_id']]['tcount']-1;
								}
							} 
						$new_info = ($post_details[$i]['new_info']!='' && is_string($post_details[$i]['new_info'])) ? $post_details[$i]['new_info'] : '';
						$entry_date = $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['auditlogentry_date'] = $entry_date;
						$operation_id = $post_details[$i]['operation_id'];
						$total_post++;
						$report_cnt++;
					}else{ 
						$report[$post_details[$i]['ticket_id']]['entry_dateee']  = $post_details[$i]['entry_date']; 
					}  // prev 
					$submitter = $post_details[$i]['operator'];
					if (!isset($report[$post_details[$i]['ticket_id']]['start_time'])) {
						$report[$post_details[$i]['ticket_id']]['ticket_hash']     = $post_details[$i]['ticket_hash'];
						$report[$post_details[$i]['ticket_id']]['subject']         = $post_details[$i]['subject'];
						$report[$post_details[$i]['ticket_id']]['ticket_entry']    = $post_details[$i]['receive_date'];
						$report[$post_details[$i]['ticket_id']]['start_time']      = $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['post_date']	   = $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['ticket_priority'] = $post_details[$i]['ticket_priority'];
						$report[$post_details[$i]['ticket_id']]['department_name'] = $post_details[$i]['department_name'];
						$report[$post_details[$i]['ticket_id']]['first_name'] 	   = $post_details[$i]['first_name'];
						$report[$post_details[$i]['ticket_id']]['last_name']	   = $post_details[$i]['last_name'];
						$report[$post_details[$i]['ticket_id']]['email']		   = $post_details[$i]['email'];
						$report[$post_details[$i]['ticket_id']]['group_name']	   = $post_details[$i]['group_name'];
						$report[$post_details[$i]['ticket_id']]['client_id']       = $post_details[$i]['client_id'];
						$report[$post_details[$i]['ticket_id']]['ticket_id']       = $post_details[$i]['ticket_id'];
						$report[$post_details[$i]['ticket_id']]['status_id']       = $post_details[$i]['status_id'];
						$report[$post_details[$i]['ticket_id']]['remain_resolve']  = $post_details[$i]['remain_resolve'];
						$report[$post_details[$i]['ticket_id']]['pause_rtime']	   = $post_details[$i]['pause_rtime'];
						$report[$post_details[$i]['ticket_id']]['resolve_time']    = $post_details[$i]['resolution_time'];
						$report[$post_details[$i]['ticket_id']]['status_name']     = $post_details[$i]['status_name'];
						$report[$post_details[$i]['ticket_id']]['urgency']     = $post_details[$i]['urgency'];
						$report[$post_details[$i]['ticket_id']]['impact']     = $post_details[$i]['impact'];
						$report[$post_details[$i]['ticket_id']]['flag']     = $post_details[$i]['flag'];
						$report[$post_details[$i]['ticket_id']]['type']     =  (isset($post_details[$i]['type']))? $post_details[$i]['type'] :'';
						$report[$post_details[$i]['ticket_id']]['ticket_category']     =  (isset($post_details[$i]['ticket_category']))? $post_details[$i]['ticket_category'] :'';
						$report[$post_details[$i]['ticket_id']]['ticket_sub_cateogy']     =  (isset($post_details[$i]['ticket_sub_cateogy']))? $post_details[$i]['ticket_sub_cateogy'] :'';
						$report[$post_details[$i]['ticket_id']]['ticket_level']     =  (isset($post_details[$i]['ticket_level']))? $post_details[$i]['ticket_level']:'';
						$report[$post_details[$i]['ticket_id']]['sla_name']        = $post_details[$i]['sla_name'];
						$report[$post_details[$i]['ticket_id']]['operator']		   = $post_details[$i]['operator'];
						$report[$post_details[$i]['ticket_id']]['operation_id']	   = $post_details[$i]['operation_id'];
						$report[$post_details[$i]['ticket_id']]['closed_time']	   = $post_details[$i]['closed_time'];
						$report[$post_details[$i]['ticket_id']]['as_client']	   = $post_details[$i]['as_client'];
						$report[$post_details[$i]['ticket_id']]['new_info']		   = $post_details[$i]['new_info'];
						$report[$post_details[$i]['ticket_id']]['applyslaresol_time'] = $post_details[$i]['applyslaresol_time'];
						if (!isset($report[$post_details[$i]['ticket_id']]['tcount']))
						$report[$post_details[$i]['ticket_id']]['tcount']          = 0;
						else
						$report[$post_details[$i]['ticket_id']]['tcount']          += 0;							
						$report[$post_details[$i]['ticket_id']]['lastrepliertime'] = $post_details[$i]['lastrepliertime'];
						$report[$post_details[$i]['ticket_id']]['solve_time']      = 0;
						$report[$post_details[$i]['ticket_id']]['slapause_diff']   = 0;
						$report[$post_details[$i]['ticket_id']]['maintain_date']   = 0;
						$report[$post_details[$i]['ticket_id']]['count']           = 0;
						$report[$post_details[$i]['ticket_id']]['used_sla_seconds']= 0;
						$report[$post_details[$i]['ticket_id']]['total_sla_seconds'] = 0;
						$report[$post_details[$i]['ticket_id']]['auditlogentry_date'] = 0;
						$total_post= 0;
						$report[$post_details[$i]['ticket_id']]['due_date']  =0;
					} elseif($post_details[$i]['old_info']!=''){
						$total_sla_seconds = ($post_details[$i]['due_time'] - $report[$post_details[$i]['ticket_id']]['start_time']);
						$report[$post_details[$i]['ticket_id']]['due_date']  = ($post_details[$i]['due_time'] - $post_details[$i]['lastrepliertime']); 
						$report[$post_details[$i]['ticket_id']]['as_client']	   = $post_details[$i]['as_client'];
						//$maintain_date_nw = !isset($report[$post_details[$i]['ticket_id']]['maintain_date_nw'])? 0:$report[$post_details[$i]['ticket_id']]['maintain_date_nw'];
						$report[$post_details[$i]['ticket_id']]['sla_response_time'] = round($maintain_date_nw);		
						 $report[$post_details[$i]['ticket_id']]['used_sla_seconds'] = $report[$post_details[$i]['ticket_id']]['sla_response_time'];
						 $report[$post_details[$i]['ticket_id']]['timestamp'] = $report[$post_details[$i]['ticket_id']]['sla_response_time'];
						$submitter = $post_details[$i]['operator'];
						$operation_id = $post_details[$i]['operation_id'];
						$new_info = ($post_details[$i]['new_info']!='' && is_string($post_details[$i]['new_info'])) ? $post_details[$i]['new_info'] : '';
						$entry_date = $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['auditlogentry_date'] = $entry_date;
						
						$report_cnt++;
					}
				} 
				$old_ticket_id=$post_details[$i]['ticket_id'];
				}
			} else {
				$report = -1;
			} 
			$report_new = array();
			$entry_dateeeplus=0;
			$counttikt=0;
			$totrepltime=0;
			$due_datt='';
			$avgtotrepltime=array(); 
			$tcount=0;
			$ttttcount=$auditlogentry_date=0;
			$ttttcountclosansresolv=0;
			$totlavgresposmaintain=0;
			$tottick_avg_tim=0;
			if ($report != -1) { 
				foreach ($report as $ticket_id => $details) { 
					$isUndueSet = 0;
					
					$report[$ticket_id]['totlavgresposmaintain']=0;
					if($details['tcount']>0 || ($details['tcount']>=0 && $details['count']>0)){
						if($details['lastrepliertime']>0 && $details['ticket_entry']>0){
							$totrepltime = $details['lastrepliertime'] - $details['ticket_entry']; }
							if(isset($totrepltime) && $totrepltime!=0){
								if ($details['tcount']!=0) {
								$avgtotrepltime = count_remain_time(round($totrepltime / $details['tcount']));
								$report[$ticket_id]['avg_tot_replied_time']=$avgtotrepltime;
								$report[$ticket_id]['tot_post_and_reply_time']=$totrepltime;
								}
								$tcount += $details['tcount']; 
								$ttttcount++;
							}
														
						}else{ 
						if(isset($details['status_id']) && $details['status_id']==3 || $details['status_id']==4 && ( isset($details['closed_time']) && $details['closed_time']!='')){
						$totrepltime = $details['closed_time'] - $details['lastrepliertime'];
						$report[$ticket_id]['tot_post_and_reply_time']=$totrepltime;
						}
					}
					if($details['pause_rtime'] == ''){
					if($details['closed_time']=='' && $details['status_id']==3 || $details['status_id']==4 && is_string($new_info)){
						$calculate_resolve_time = $details['auditlogentry_date'] - $details['applyslaresol_time'];
					} else {
						$calculate_resolve_time = $details['resolve_time'] - (isset($details['closed_time']))? $details['closed_time'] :0;
					}
					if ($details['resolve_time'] < 0 && ($details['status_id'] == 3 || $details['status_id'] == 4)) {
						$isUndueSet   = 0;
			
						$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTUNDUE'];
					} else if (($details['resolve_time'] < 0 || $details['remain_resolve'] < 0) && $details['status_id'] != 3  && $details['status_id']!=4) {
						$isUndueSet                                = 0;
						if($details['pause_rtime'] == ''){$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTNOTMAINTAIN'];}else{
						$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTOVERDUE'];}
					} else if (($details['resolve_time'] > 0 || $details['remain_resolve'] > 0) && $details['status_id']!=3  && $details['status_id']!=4) {
						$isUndueSet                                = 0;
						if($details['count']!= 0){
							$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTUNDUE'];
						} else {
							$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTNOTRESPONDED'];
						}
						if(isset($details['lastrepliertime']) && $details['lastrepliertime']>0){
						$report[$ticket_id]['lastrepliertime'] = $details['lastrepliertime'];
						}
					} else {
						$isUndueSet = 1;
						if($calculate_resolve_time > 0){
							if($details['count']!=0)
								$resolutionCount++;
						}
						if($details['closed_time']=='' && (isset($details['status_id']) && ($details['status_id']==4 || $details['status_id']==3))){				
							if($auditlogentry_date==0){ $auditlogentry_date = $details['entry_dateee'];  }										
							if($auditlogentry_date>0){
							 $report[$ticket_id]['avg_resolution_time'] = count_remain_time($auditlogentry_date - $details['applyslaresol_time']); }
						} else {
							
							if($report[$ticket_id]['customsla']>0)	{
								$report[$ticket_id]['avg_resolution_time'] = count_remain_time($details['closed_time'] - $details['applyslaresol_time']);
							}	else	{
								
								$report[$ticket_id]['avg_resolution_time'] = count_remain_time($details['closed_time'] - $details['ticket_entry']);
							}
						}
						if($details['tcount']>=1){
						
							$responseCount++;
						}
					}
					if($details['tcount']==0 && ($details['status_id']==3 || $details['status_id']==4))
					{
						$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTMAINTAIN'];
					} 
					else if(($details['resolve_time'] < 0 || $details['remain_resolve'] < 0) && $details['status_id']!=3 && $details['status_id']!=4) 
					{
						if($responseCount!=0) { $responseCount--; }else{ $responseCount++;} 
						if($details['tcount'] > 1)
						{ 
							$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTMAINTAIN'];
						} 
						else 
						{  
							$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTRESPONDED'];
						}
					} 
					else if($details['tcount']!= 0 && ($details['status_id']==3 || $details['status_id']==4))
					{
						if($details['resolve_time'] < 0 || $details['remain_resolve'] < 0){
							$responseCount--; 
							/* $report[$ticket_id]['response_sla'] = $vis_language['TXTNOTMAINTAIN'];  */
							$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTRESPONDED']; 
						} 
						else 
						{
							$report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
							$report[$ticket_id]['totlavgresposmaintain']++;
						}
					} 
					else if (($details['resolve_time'] > 0 || $details['remain_resolve'] > 0) && ($details['status_id']!=3 && $details['status_id']!=4)) 
					{
						if($details['tcount'] > 1)
						{
							$report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
							$report[$ticket_id]['totlavgresposmaintain']++;
						} 
						else 
						{	if ($details['operation_id']==0 && $details['operator']==2) {
							$report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
								if($details['used_sla_seconds'] > 0)	{
										$report[$ticket_id]['totlavgresposmaintain']++;
									}
							}	else{ 
							$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTRESPONDED'];
							}
						}
					}
						if($details['tcount']!=0 && ($details['status_id']==3 || $details['status_id']==4))
						{
							$report[$ticket_id]['response_sla_stat'] = $vis_language['TXTMAINTAIN'];
						}
						else
						{
							$report[$ticket_id]['response_sla_stat'] = $vis_language['TXTNOTRESPONDED'];
						} 
					if($isUndueSet == 1 && $resolutionCount>0){
						if($details['status_id']!=3 && $details['status_id']!=4){
							
							if($details['count']!=0){
								$report[$ticket_id]['resolution_sla']   = $vis_language['MSGNOTRESOLVED'];
							} else {
								$report[$ticket_id]['resolution_sla']   = $vis_language['MSGNOTRESOLVED'];
							}
						} else {
							if($details['resolve_time'] < 0){  
								$report[$ticket_id]['resolution_sla'] = $vis_language['TXTNOTMAINTAIN'];
							} else {
							/* $report[$ticket_id]['resolution_sla'] = $vis_language['TXTMAINTAIN'];  */
								if($details['resolve_time']<$details['closed_time']){
                                    $report[$ticket_id]['resolution_sla'] = $vis_language['TXTNOTMAINTAIN'];
                                }else{
                                $report[$ticket_id]['resolution_sla'] = $vis_language['TXTMAINTAIN'];		
                                $ttttcountclosansresolv++;
                                $report[$ticket_id]['totalmaintcont']=1;
	                            }
							}
						}
					} elseif($details['count']==0 && $details['status_id']!=3 && $details['status_id']!=4){ 
						if($details['remain_resolve'] > 0){	$report[$ticket_id]['resolution_sla']   = $vis_language['MSGNOTRESOLVED'];
						}else{ $report[$ticket_id]['resolution_sla']   = $vis_language['TXTOVERDUE']; }
					} elseif($details['count']!=0 && $details['status_id']!=3 && $details['status_id']!=4){
						if($details['remain_resolve'] > 0){	$report[$ticket_id]['resolution_sla']   = $vis_language['MSGNOTRESOLVED'];
						}else{ $report[$ticket_id]['resolution_sla']   = $vis_language['TXTOVERDUE']; }
					} else {
						if($details['count']==0 && $details['status_id']!=3 && $details['status_id']!=4){
							$report[$ticket_id]['resolution_sla']   = $vis_language['TXTNOTMAINTAIN'];
						} else { 
							if($details['closed_time'] > $details['resolve_time'] && ($details['status_id']==3 || $details['status_id']==4)){
								$report[$ticket_id]['resolution_sla']   = $vis_language['TXTNOTMAINTAIN'];
							}else{
								$report[$ticket_id]['resolution_sla']   = $vis_language['TXTMAINTAIN'];
								 $ttttcountclosansresolv++;
								 $report[$ticket_id]['totalmaintcont']=1;
							}
						}
					}
					$cal_timestamp = (isset($details['timestamp'])&&$details['timestamp']!= '' && $details['count'] != '0')? round(($details['timestamp']/$details['count']),2):''; 
					if($details['count']!=0){
						$replied_ticket_cnt+=1;
					} else {
						$replied_ticket_cnt+=0;
					}
					// if($report[$ticket_id]['operator']==1 || $report[$ticket_id]['as_client']==1 && $details['count']!=0)
					
					$report[$ticket_id]['avg_response_time']=($details['count']!=0) ? count_remain_time($cal_timestamp) : (($details['operation_id']==0 && $details['operator']==2) ? '0S': $vis_language['TXTNOTRESPONDED']); 
					if($details['count']!=0)    {
		                    $report[$ticket_id]['avg_response_time'] = count_remain_time($cal_timestamp);
		                }   else       {               	
			                $report[$ticket_id]['avg_response_time'] = '0 S';	                	
		                }
				if(isset($report[$ticket_id]['avg_tot_replied_time']) && $report[$ticket_id]['avg_tot_replied_time'] >0 ){			
				if($details['due_date'] < 0 && $details['tcount']>=1){ 
					if($details['operator']==1 || $details['as_client']==1) {      
                        $report[$ticket_id]['response_sla'] =  $vis_language['TXTNOTMAINTAIN']; 
                    } elseif ($details['lastrepliertime'] > $details['resolve_time']) { 
                        $report[$ticket_id]['response_sla'] =  $vis_language['TXTNOTMAINTAIN'];
                    } else{
                    $report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
                    $report[$ticket_id]['totlavgresposmaintain']++;              
                    }
				} else {
					$report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
					$report[$ticket_id]['totlavgresposmaintain']++;                

				}			
				}else{ 
					if((isset($details['response_sla']) && $details['response_sla']==$vis_language['TXTOVERDUE'] && $details['response_sla']!='')) {
						if($details['operator']==1 || $details['as_client']==1) {       
	                        $report[$ticket_id]['response_sla'] = $details['response_sla'];
	                    }  else {
	                    	$report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
	                    	$report[$ticket_id]['totlavgresposmaintain']++;         

	                    }
					} else {	
						if($details['operator']==1 || $details['as_client']==1) {       
							if($details['due_date'] > 0 && $details['count']>=1) {
								$report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
								$report[$ticket_id]['totlavgresposmaintain']++;
								} else {
								if($details['count'] >=1){  
									  $report[$ticket_id]['response_sla'] =  $vis_language['TXTNOTMAINTAIN']; 
								} else { 
	                       		$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTRESPONDED'];								
								}
							}
	                    } elseif($report[$ticket_id]['avg_response_time']=='0 S')  {
	  	                    	$report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
	  	                } else   { 
	                    $report[$ticket_id]['response_sla'] = $vis_language['TXTNOTRESPONDED'];
	                    }
					}
				}
                	if($details['count']!=0)
						$responseCount+=1;		
					
					if($details['count']==0 && $report[$ticket_id]['totlavgresposmaintain']==1){
						$report[$ticket_id]['totlavgresposmaintain'] =0;
					}
					if($report[$ticket_id]['totlavgresposmaintain'] > 0) {
							$totlavgresposmaintain++;
						}				
				} else $report[$ticket_id]['response_sla'] = 'NA';
				} 
				foreach (((isset($operation['vis_export']) && $operation['vis_export'] == 1)? $report :array_slice($report, $limit, $view_info['page_count'])) as $p) {
					$report_new[] = $p;
				}
			}
			$array_summary=array();
            $array_summary['TXTTOTALTICKETSREPLIED']=$ttttcount;
            $array_summary['TXTTOTALAVGRESPONSESLAMAINTAIN']=(($totlavgresposmaintain==0)?0:round((($totlavgresposmaintain/count($report))*100), 2)).'%';
            $array_summary['TXTTOTALAVGRESOLUTIONSLAMAINTAIN']=(($ttttcountclosansresolv==0)?0:round((($ttttcountclosansresolv/count($report))*100), 2)).'%';
			$total = ($report!=-1)?count($report):0;
			$view_info['page']=$page;
			$report_count=($report_new!=-1 || !empty($report_new)) ? count($report_new) : 0;
			$reportCnt = ($report!=-1)?count($report):0;
			$view_info['page_count']=($reportCnt==0)? 0 : ceil($reportCnt/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				$replied_ticket_cnt = 0;
				$replied_ticket_cnttt = 0;
				$tcounttt=0;
				$rescounttt=0;
				$resolvecounttt=0;
				foreach ($report as $i) {
					foreach ($i as $key => $val) {
						if ($key == 'timestamp'){
							/* $report_exp[$j]['SLA']= ($i['count']!=0) ? count_remain_time($val) : $vis_language['TXTNOTRESPONDED']; */
							$report_exp[$j]['SLA']= ($i['count']!=0) ? count_remain_time($val/$i['count']) : $vis_language['TXTNOTRESPONDED'];
						} elseif ($key == 'ticket_entry') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'ticket_hash' || $key == 'subject' || $key == 'status_name' || $key == 'sla_name' || $key == 'department_name' || $key == 'ticket_priority' || $key == 'type' ||  $key == 'impact' ||  $key == 'urgency' ||  $key == 'flag'  ||  $key == 'ticket_category'  ||  $key == 'ticket_sub_cateogy' || $key == 'ticket_level') {							
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'avg_resolution_time'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'pause_rtime'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'status_id'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'new_info'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'closed_time'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'response_sla'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'resolution_sla'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'tcount'){
							$report_exp[$j][$key] = $val;
						}  elseif ($key == 'avg_tot_replied_time'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'tot_post_and_reply_time'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'totalmaintcont'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'first_name' || $key == 'last_name' || $key == 'email' || $key == 'group_name'){
							$report_exp[$j][$key] = $val;
						}	elseif ($key == 'operator'){
							$report_exp[$j][$key] = $val;
						}	elseif ($key == 'as_client'){
							$report_exp[$j][$key] = $val;
						}	elseif ($key == 'due_date'){
							$report_exp[$j][$key] = $val;
						}	else if ($key == 'avg_response_time'){
							$report_exp[$j][$key] = $val;
						}   else if ($key == 'client_id'){
							$report_exp[$j][$key] = $val;
						}  else if ($key == 'count'){
							$report_exp[$j][$key] = $val;
						}
					}
					$sla_name = ($report_exp[$j]['sla_name']!= '')?$report_exp[$j]['sla_name']:$vis_language['TXTCUSTDUETIME'];
					if($filter1==0)	{
        				$report_exp1[$j]['incident_or_Service_hash'] = $report_exp[$j]['ticket_hash'];
        			}
        			elseif($filter1==2)	{
        				$report_exp1[$j]['Service_request_hash'] = $report_exp[$j]['ticket_hash'];
        			}
        			else {
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash'];
        			}
					$report_exp1[$j]['subject']=$report_exp[$j]['subject'];
					//$report_exp1[$j]['client_name'] = $report_exp[$j]['first_name'].' '. $report_exp[$j]['last_name'];
					$report_exp1[$j]['client_email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['department'] = $report_exp[$j]['department_name'];
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					$report_exp1[$j]['Creation_date']=$report_exp[$j]['ticket_entry'];
					$report_exp1[$j]['status']=$report_exp[$j]['status_name'];
					$report_exp1[$j]['priority'] = $report_exp[$j]['ticket_priority'];
                    $report_exp1[$j]['type'] = $report_exp[$j]['type'];
                    $report_exp1[$j]['urgency'] = $report_exp[$j]['urgency'];
                    $report_exp1[$j]['flag'] = $report_exp[$j]['flag'];
                    $report_exp1[$j]['impact'] = $report_exp[$j]['impact'];
                    $report_exp1[$j]['category'] = $report_exp[$j]['ticket_category'];
                    $report_exp1[$j]['sub_category'] = $report_exp[$j]['ticket_sub_cateogy'];
                    $report_exp1[$j]['level'] = $report_exp[$j]['ticket_level'];
					$report_exp1[$j]['sla_plan']=$sla_name;			

					$resolution_time = (isset($report_exp[$j]['tot_post_and_reply_time']) && $report_exp[$j]['tot_post_and_reply_time'] !=0 )?count_remain_time(round($report_exp[$j]['tot_post_and_reply_time'])): $vis_language['TXTNOTRESPONDED'];
					 
					$cal_timestamp = ($report_exp[$j]['timestamp'] != '' && $report_exp[$j]['count'] != '0')? round(($report_exp[$j]['timestamp']/$report_exp[$j]['count']),2):''; 

					$report[$ticket_id]['avg_response_time']=($report_exp[$j]['count']!=0) ? count_remain_time($cal_timestamp) : (($report_exp[$j]['operation_id']==0 && $report_exp[$j]['operator']==2) ? '0S': $vis_language['TXTNOTRESPONDED']);
					if($report_exp[$j]['count']!=0)    {
		                    $report_exp1[$j]['avg_response_time'] = count_remain_time($cal_timestamp);
		                }   else  {               	
			                $report_exp1[$j]['avg_response_time'] = '0 S';	                	
		                }
	                if(isset($report_exp[$j]['pause_rtime']) && $report_exp[$j]['pause_rtime']!=''){
					    $report_exp1[$j]['avg_response_time']='NA';
					}elseif(isset($report_exp[$j]['avg_response_time']) && $report_exp[$j]['avg_response_time'] !=0)
						{
							$report_exp1[$j]['avg_response_time']=  $report_exp[$j]['avg_response_time'];
						}
					elseif(isset($report_exp[$j]['avg_response_time']) && $report_exp[$j]['avg_response_time'] =='0 S' && $report_exp[$j]['operator']!=1 && $report_exp[$j]['as_client']!=1){ 
						$report_exp1[$j]['avg_response_time']=  '0 S';
					}else{ 
						$report_exp1[$j]['avg_response_time'] = $vis_language['TXTNOTRESPONDED'];
					}

					// $resolution_flag = ($report_exp[$j]['pause_rtime']!='') ? $report_exp[$j]['pause_rtime'] : '';
					if(isset($report_exp[$j]['pause_rtime']) && $report_exp[$j]['pause_rtime']!=''){
					    $report_exp1[$j]['avg_resolution_time']='NA';
					}elseif(isset($report_exp[$j]['status_id']) &&($report_exp[$j]['status_id']==4 || $report_exp[$j]['status_id']==3)){
						$report_exp1[$j]['avg_resolution_time'] = (isset($report_exp[$j]['avg_resolution_time']) && $report_exp[$j]['avg_resolution_time'] !='' )? $report_exp[$j]['avg_resolution_time'] :"Not resolved"; //$resolution_time;
					}else{ 
					 $report_exp1[$j]['avg_resolution_time'] = (isset($report_exp[$j]['resolution_sla']) && $report_exp[$j]['resolution_sla'] !='' ) ? $report_exp[$j]['resolution_sla']: $vis_language['TXTNOTMAINTAIN'];
					}

					if(isset($report_exp[$j]['pause_rtime']) && $report_exp[$j]['pause_rtime']!=''){
					    $report_exp1[$j]['response_sla']='NA';
					}elseif(isset($report_exp[$j]['avg_tot_replied_time']) && $report_exp[$j]['avg_tot_replied_time'] >0 ){
					    $replied_ticket_cnttt+=$report_exp[$j]['tcount'];
					    // $rescounttt++;
					    if($report_exp[$j]['due_date'] < 0 && $report_exp[$j]['tcount']>=1){
					        if($report_exp[$j]['operator']==1 || $report_exp[$j]['as_client']==1){       
					            $report_exp1[$j]['response_sla'] = $vis_language['TXTNOTMAINTAIN'];
					        } else {
					            $report_exp1[$j]['response_sla'] = $report_exp[$j]['response_sla'];
					            // $report_exp1[$j]['response_sla'] = $vis_language['TXTMAINTAIN'];
					            //  $rescounttt++;
					        }
					    } else {
					        $report_exp1[$j]['response_sla'] =  $vis_language['TXTMAINTAIN'];
					         $rescounttt++;
					    }           
					}else{ 
					    if((isset($report_exp[$j]['response_sla'] ) && $report_exp[$j]['response_sla']==$vis_language['TXTOVERDUE']  && $report_exp[$j]['response_sla']!='')){
					        if($report_exp[$j]['operator']==1 || $report_exp[$j]['as_client']==1){
					            $report_exp1[$j]['response_sla']=$report_exp[$j]['response_sla'];
					        }else{
					            $report_exp1[$j]['response_sla']=$vis_language['TXTMAINTAIN'];
					             $rescounttt++;
					        } 
					    }else{
					        if($report_exp[$j]['operator']==1 || $report_exp[$j]['as_client']==1){					            
					            if($report_exp[$j]['due_date'] > 0 && $report_exp[$j]['count']>=1) {
										$report_exp1[$j]['response_sla']=$vis_language['TXTMAINTAIN'];
										 $rescounttt++;
									} else {			                       		
			                       		//$report_exp1[$j]['response_sla']=$vis_language['TXTNOTRESPONDED'];
			                       		if($report_exp[$j]['count'] >=1){
			                       				$report_exp1[$j]['response_sla']=$vis_language['TXTNOTMAINTAIN'];
											}else{
                       							$report_exp1[$j]['response_sla']=$vis_language['TXTNOTRESPONDED'];					
											}
									}
					        } elseif($report_exp[$j]['avg_response_time']=='0 S') {
		  	                    /* if($report_exp[$j]['client_id']== '0') {
		                    		$report_exp1[$j]['response_sla']=$vis_language['TXTNOTRESPONDED'];
		  	                    } else  {  */
		  	                    		$report_exp1[$j]['response_sla']=$vis_language['TXTMAINTAIN'];
								/*  } */
                    		} else{
					            $report_exp1[$j]['response_sla']=$vis_language['TXTNOTRESPONDED'];
					        }
					    }
					}
					if(isset($report_exp[$j]['pause_rtime']) && $report_exp[$j]['pause_rtime']!=''){
					    $report_exp1[$j]['resolution_sla']='NA';
					}elseif((isset($report_exp[$j]['resolution_sla']) && $report_exp[$j]['resolution_sla']==$vis_language['TXTOVERDUE']) || !isset($report_exp[$j]['resolution_sla'])){
					    $report_exp1[$j]['resolution_sla']=$vis_language['TXTNOTMAINTAIN'];
					}else{
					     $report_exp1[$j]['resolution_sla']=(isset($report_exp[$j]['resolution_sla']) && $report_exp[$j]['resolution_sla']!='')?$report_exp[$j]['resolution_sla']:$vis_language['TXTNOTMAINTAIN'];
					}

					if($i['count']!=0)	{
						$replied_ticket_cnt+=1;
					} 	else 	{
						$replied_ticket_cnt+=0;
					}					
					if(isset($report_exp[$j]['totalmaintcont']) && $report_exp[$j]['totalmaintcont']>0)
						$resolvecounttt+=1;					
					$j++;
				}
					
				if($report!=-1){
					foreach($array_summary as $key=>$val){ 
					$title=explode(' ',$key);
					$title[1]=isset($title[1])? ' '.$title[1]:'';
					 $report_exp1[$j][$vis_language[$title[0]].$title[1]]=$vis_language[$title[0]].$title[1].' : '.$val; 
					}
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database); 
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE.'report_page.php');
			} 
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
		$database->database_disconnect();
		return true;
	}
		
	function ticket_escalation_staff_report($operation) 
	{       
		global $vis_language;
		$report_title = $vis_language['TXTTICKETESCGROUPSTAFFOWNER'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type=41;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		if(isset($operation['vis_export']) && $operation['vis_export'] == 1){
			$staff_id = $operation['staff_id'];
		} else {
			$staff_id = VIS_STAFF_ID;
			$staff    = $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA);
		}
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		
		$report_new = $report = array();
		
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']);
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='ticket_escalation_staff_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';			
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && (!isset($data['staff_id']) || $data['staff_id'] == 0)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && (!isset($data['staff_id']) || $data['staff_id'] == 0)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTSTAFF']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && (!isset($data['staff_id']) || $data['staff_id'] == 0)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}					
				$currentdate = date('Y-m-d H:i:s');
				$service='';
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';if($data['service_id']==3)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id=0';}
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$staff_ids = implode(',',$data['staff_id']);
 
				$filter = 'receive_date between '.$from.' AND '.$to.' and staff_id IN('.$staff_ids.') '.$service;
			}				
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$filter .= ' and ' .VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and ' .VIS_TABLE_PREFIX.'ticket.is_spam!=1';
			$report1 = $object->get_ticket_escalation_staff_report($filter, '', $staff_id, $staff_id, VIS_LOCATION_AREA); 
			
			$report = $object->get_ticket_escalation_staff_report($filter, '', $staff_id, $staff_id, VIS_LOCATION_AREA); 
			/*foreach (array_slice($report, $limit, $view_info['page_count']) as $p) {
				$report_new[] = $p;
			}*/
			if(!isset($operation['vis_export']) || $operation['vis_export'] != 1){	
					foreach (array_slice($report, $limit, $view_info['page_count']) as $p){
						$report_new[] = $p;
					}
				}
			$total = count($report);
			$view_info['page']=$page;
			$report_count=($report_new!=-1 || !empty($report_new)) ? count($report_new) : 0;
			$view_info['page_count']=(count($report)==0)? 0 : ceil(count($report)/$view_info['page_count']);
			$view_info['view_count']=count($view_details);


			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
			$sett_obj = new class_setting($database);				
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				foreach ($report1 as $i) {
					foreach ($i as $key => $val) {							
						if ($key == 'ticket_hash'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'subject'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'receive_date'){ 
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);                       
						} elseif ($key == 'new_info'){ 
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'entry_date'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'first_name'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'last_name'){
							$report_exp[$j][$key] = $val;
						}
					}
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['creation_date'] = $report_exp[$j]['receive_date'];
					$report_exp1[$j]['assigned_to'] = $report_exp[$j]['first_name'].''.$report_exp[$j]['last_name'];
					$report_exp1[$j]['assigned_on'] = $report_exp[$j]['entry_date'];
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE.'report_page.php');
			} 
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}


	function ticket_escalation_department_report($operation)
	{ 		
		global $vis_language;
		$report_title = $vis_language['TXTTICKETESCGROUPDEPARTMENT'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type=42;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object  = new class_ticket($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$departments = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='ticket_escalation_department_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				$data['department_id'] = (isset($data['department_id']))? $data['department_id']:0;
				if ($data['duration'] == 0 && $data['department_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['department_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDEPARTMENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['department_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$dept_ids = implode(',',$data['department_id']);
				$chk_dept = ' and '.VIS_TABLE_PREFIX.'department.department_id IN('.$dept_ids.')';
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				$service='';
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';if($data['service_id']==3)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id=0';}
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = 'receive_date between ' . $from . ' AND ' . $to . $chk_dept.$service;
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$filter .= ' and ' .VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX.'ticket.draft_id=0 ';
			$report = $object->get_ticket_escalation_department_report($filter,'', $staff_id, $staff_id, VIS_LOCATION_AREA);
			if($report!=-1){
				$total = ($report!=-1)?count($report):0;
				$report = $object->get_ticket_escalation_department_report($filter,$limit, $staff_id, $staff_id, VIS_LOCATION_AREA);
				$counts['page_count']=(count($report)==0)?0:ceil( count($report)/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($report);
				$report_count=($report!=-1)?count($report):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
			$sett_obj = new class_setting($database);
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j = 0;
				foreach ($report as $i) {
					foreach ($i as $key => $val) {
						if ($key == 'ticket_hash'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'subject'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'receive_date'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);                       
						} elseif ($key == 'new_info'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'entry_date'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						}
					}
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['creation_date'] = $report_exp[$j]['receive_date'];					
					$report_exp1[$j]['assigned_to'] = $report_exp[$j]['new_info'];
					$report_exp1[$j]['assigned_on'] = $report_exp[$j]['entry_date'];
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation); 
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE.'report_page.php');
			} 
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function incident_category_sla_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTCATEGORYSLA'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();

		$export = 1;
		$report_type=194;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
		$setting_object = new class_setting($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$domain     = $tkt_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']);
		$paging_form_page=($page*$view_info['page_count']);
		$operation['set_clientblank'] = 0;
		$operation['vis_current_operation']='incident_category_sla_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		list($ctinfo, $categories) = $setting_object->get_ticket_category_list(VIS_TABLE_PREFIX.'ticket_category.is_enabled=1', '', $staff_id, VIS_LOCATION_AREA,'');
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if(isset($data['vis_category_id']))
				$data['vis_category_id'] = is_array($data['vis_category_id'])? implode(',', $data['vis_category_id']):0;
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if (isset($data['duration'])&&!isset($data['vis_category_id'])) {
					$data['vis_category_id'] = 0;
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['vis_category_id'] == 0  && $data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] == 0  && $data['vis_category_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] == 0  && $data['vis_category_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] != 0  && (!isset($data['vis_category_id'])||$data['vis_category_id'] == 0) && $operation['set_clientblank']==0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTCATEGORIES']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 &&  $data['domain_id'] != 0  &&  $data['vis_category_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$service='';
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;}
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = '(operation_id<=2 or operation_id=50 or operation_id=51 or operation_id=13) and '.VIS_TABLE_PREFIX.'ticket.receive_date between '.$from.' AND '.$to.' and find_in_set('.VIS_TABLE_PREFIX.'ticket.category_id, "'.$data['vis_category_id'].'") and '.VIS_TABLE_PREFIX.'ticket.domain_id='.$data['domain_id'].$service;
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$filter .= ' and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX.'ticket.resolution_time!=0 and '.VIS_TABLE_PREFIX.'ticket.due_time!=0 ';
			$post_details    = $object->incident_category_sla_report($filter, '', $staff_id, VIS_LOCATION_AREA);
			$resolutionCount = $responseCount = $report_avg = $report_cnt = $replied = $total_time = $replied_ticket_cnt = $submitter = $entry_date = 0;$maintain_date_nw1 =0;$maintain_date_nw = 0;
			$report          = array();
			$new_info		 = '';
		    
			if ($post_details != -1){
				for($i=0;$i<count($post_details);$i++){
					 //echo "<br> as_client".$post_details[$i]['as_client'];
					 // echo "<br> submitter".$submitter;
					if($old_ticket_id != $post_details[$i]['ticket_id']){
						$report[$post_details[$i]['ticket_id']]['post_date'] = 0;
						$maintain_date_nw1 = $maintain_date_nw=0;
						$report[$post_details[$i]['ticket_id']]['as_client'] = ''; 
						$report[$post_details[$i]['ticket_id']]['count']=0;
						$report[$post_details[$i]['ticket_id']]['tcount']=0;	
						$as_client_or_clientticket=0;
						$last_operation_id =0;
					} 
					$report[$post_details[$i]['ticket_id']]['as_client'] = '';
					if(isset($post_details[$i]['as_client']) && $post_details[$i]['as_client']!="")
					{
						$report[$post_details[$i]['ticket_id']]['as_client'] = $post_details[$i]['as_client'];
					}
					else
					{
						$report[$post_details[$i]['ticket_id']]['as_client'] = '';
					}

					 if($post_details[$i]['operation_id']==13)	{   
							if(!isset($report[$post_details[$i]['ticket_id']]['customsla'])){
								$report[$post_details[$i]['ticket_id']]['customsla']=1;	
							} 
							else{
								$report[$post_details[$i]['ticket_id']]['customsla']++;	
							}  
						 $report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date'];
					 }
					 
					if($post_details[$i]['operation_id']!=13)	{ 
					if($post_details[$i]['operation_id']==0 && $post_details[$i]['operator']==1){
					  	$report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date'];
						//$submitter = $post_details[$i]['operator'];
						 $last_operation_id = $post_details[$i]['operation_id'];
						$as_client_or_clientticket=1;
					} else if($post_details[$i]['operation_id']==1 &&  $post_details[$i]['operator']==1 && $submitter!=1 ){
						if($last_operation_id ==0 && $submitter==2&&$post_details[$i]['as_client']==1){
						 	$report[$post_details[$i]['ticket_id']]['post_date'] = $report[$post_details[$i]['ticket_id']]['post_date'];
						}else{
						  	$report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date'];	
						}

						$last_operation_id = $post_details[$i]['operation_id'];
						$maintain_date_nw1 = $maintain_date_nw; 
						$as_client_or_clientticket=1; 
					} else if($post_details[$i]['operation_id']==50){
						$report[$post_details[$i]['ticket_id']]['pause_date']=$post_details[$i]['entry_date'];
						$last_operation_id = $post_details[$i]['operation_id'];
					} else if($post_details[$i]['operation_id']==51){
						$report[$post_details[$i]['ticket_id']]['resume_date']=$post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['slapause_diff'] += $post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['pause_date'];
						$last_operation_id = $post_details[$i]['operation_id'];
					} else if($post_details[$i]['operation_id']==1 && $post_details[$i]['operator']!=1){
						$last_operation_id = $post_details[$i]['operation_id'];
						if($post_details[$i]['as_client'] == 1){
							$as_client_or_clientticket=1; 
						}
						/*if($submitter == $post_details[$i]['operator'] && $post_details[$i]['as_client']==0){
							if (!isset($report[$post_details[$i]['ticket_id']]['maintain_date']))
							$report[$post_details[$i]['ticket_id']]['maintain_date'] = 0;
							else
							$report[$post_details[$i]['ticket_id']]['maintain_date'] += 0;
						} else */{
							$report[$post_details[$i]['ticket_id']]['post_date']=(isset($report[$post_details[$i]['ticket_id']]['post_date']) && $report[$post_details[$i]['ticket_id']]['post_date']!='')?$report[$post_details[$i]['ticket_id']]['post_date']:0;  
						 	$maintain_date = $post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['post_date'];
							// echo "<br>2 post date  ".$report[$post_details[$i]['ticket_id']]['post_date']." entry dt ".$post_details[$i]['entry_date'];
							 $maintain_date_nw = $post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['post_date'];
							// echo "<br>old maintain_date_nw1 ".$maintain_date_nw1 ;
							$maintain_date_nw = $maintain_date_nw + $maintain_date_nw1;
							if($report[$post_details[$i]['ticket_id']]['ticket_id'] == $post_details[$i]['ticket_id']){
								//
								$report[$post_details[$i]['ticket_id']]['maintain_date'] += $maintain_date;
								$maintain_date_nw1 = $maintain_date_nw;
							} else {
								$report[$post_details[$i]['ticket_id']]['maintain_date'] = $maintain_date;
								$maintain_date_nw1 = 0;
							}
							$report[$post_details[$i]['ticket_id']]['count']=(isset($report[$post_details[$i]['ticket_id']]['count']) && $report[$post_details[$i]['ticket_id']]['count']!='')?$report[$post_details[$i]['ticket_id']]['count']:0;
							/*  $report[$post_details[$i]['ticket_id']]['count']++; */
						}
						//echo "<br> maintain_date ticket ".$report[$post_details[$i]['ticket_id']]['maintain_date'];
						 if(isset($report[$post_details[$i]['ticket_id']]['maintain_date']) && $report[$post_details[$i]['ticket_id']]['maintain_date'] > 0)
							{  
								$report[$post_details[$i]['ticket_id']]['count']++;
								$report[$post_details[$i]['ticket_id']]['tcount']++;
								$report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date'];
								if($as_client_or_clientticket==0){
									//echo "<br>++++++++".$as_client_or_clientticket;
									$report[$post_details[$i]['ticket_id']]['count']=$report[$post_details[$i]['ticket_id']]['count']-1;
									$report[$post_details[$i]['ticket_id']]['tcount']=$report[$post_details[$i]['ticket_id']]['tcount']-1;
								}
							} 
						  
						$new_info = ($post_details[$i]['new_info']!='' && is_string($post_details[$i]['new_info'])) ? $post_details[$i]['new_info'] : '';
						$entry_date = $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['auditlogentry_date'] = $entry_date;
						$operation_id = $post_details[$i]['operation_id'];
						$total_post++;
						$report_cnt++;
					}else{ 
						$report[$post_details[$i]['ticket_id']]['entry_dateee']  = $post_details[$i]['entry_date']; 
					}  // prev 
					$submitter = $post_details[$i]['operator'];
					if (!isset($report[$post_details[$i]['ticket_id']]['start_time'])) {
						$report[$post_details[$i]['ticket_id']]['ticket_hash']     = $post_details[$i]['ticket_hash'];
						$report[$post_details[$i]['ticket_id']]['subject']         = $post_details[$i]['subject'];
						$report[$post_details[$i]['ticket_id']]['ticket_entry']    = $post_details[$i]['receive_date'];
						$report[$post_details[$i]['ticket_id']]['start_time']      = $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['post_date']	   = $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['ticket_priority'] = $post_details[$i]['ticket_priority'];
						$report[$post_details[$i]['ticket_id']]['department_name'] = $post_details[$i]['department_name'];
						$report[$post_details[$i]['ticket_id']]['first_name'] 	   = $post_details[$i]['first_name'];
						$report[$post_details[$i]['ticket_id']]['last_name']	   = $post_details[$i]['last_name'];
						$report[$post_details[$i]['ticket_id']]['email']		   = $post_details[$i]['email'];
						$report[$post_details[$i]['ticket_id']]['group_name']	   = $post_details[$i]['group_name'];
						$report[$post_details[$i]['ticket_id']]['client_id']       = $post_details[$i]['client_id'];
						$report[$post_details[$i]['ticket_id']]['ticket_id']       = $post_details[$i]['ticket_id'];
						$report[$post_details[$i]['ticket_id']]['status_id']       = $post_details[$i]['status_id'];
						$report[$post_details[$i]['ticket_id']]['remain_resolve']  = $post_details[$i]['remain_resolve'];
						$report[$post_details[$i]['ticket_id']]['pause_rtime']	   = $post_details[$i]['pause_rtime'];
						$report[$post_details[$i]['ticket_id']]['resolve_time']    = $post_details[$i]['resolution_time'];
						$report[$post_details[$i]['ticket_id']]['status_name']     = $post_details[$i]['status_name'];
						$report[$post_details[$i]['ticket_id']]['urgency']     = $post_details[$i]['urgency'];
						$report[$post_details[$i]['ticket_id']]['impact']     = $post_details[$i]['impact'];
						$report[$post_details[$i]['ticket_id']]['flag']     = $post_details[$i]['flag'];
						$report[$post_details[$i]['ticket_id']]['type']     =  (isset($post_details[$i]['type']))? $post_details[$i]['type'] :'';
						$report[$post_details[$i]['ticket_id']]['ticket_category']     =  (isset($post_details[$i]['ticket_category']))? $post_details[$i]['ticket_category'] :'';
						$report[$post_details[$i]['ticket_id']]['ticket_sub_cateogy']     =  (isset($post_details[$i]['ticket_sub_cateogy']))? $post_details[$i]['ticket_sub_cateogy'] :'';
						$report[$post_details[$i]['ticket_id']]['ticket_level']     =  (isset($post_details[$i]['ticket_level']))? $post_details[$i]['ticket_level']:'';
						$report[$post_details[$i]['ticket_id']]['sla_name']        = $post_details[$i]['sla_name'];
						$report[$post_details[$i]['ticket_id']]['operator']		   = $post_details[$i]['operator'];
						$report[$post_details[$i]['ticket_id']]['operation_id']	   = $post_details[$i]['operation_id'];
						$report[$post_details[$i]['ticket_id']]['closed_time']	   = $post_details[$i]['closed_time'];
						$report[$post_details[$i]['ticket_id']]['as_client']	   = $post_details[$i]['as_client'];
						$report[$post_details[$i]['ticket_id']]['new_info']		   = $post_details[$i]['new_info'];
						$report[$post_details[$i]['ticket_id']]['applyslaresol_time'] = $post_details[$i]['applyslaresol_time'];
						if (!isset($report[$post_details[$i]['ticket_id']]['tcount']))
						$report[$post_details[$i]['ticket_id']]['tcount']          = 0;
						else
						$report[$post_details[$i]['ticket_id']]['tcount']          += 0;							
						$report[$post_details[$i]['ticket_id']]['lastrepliertime'] = $post_details[$i]['lastrepliertime'];
						$report[$post_details[$i]['ticket_id']]['solve_time']      = 0;
						$report[$post_details[$i]['ticket_id']]['slapause_diff']   = 0;
						$report[$post_details[$i]['ticket_id']]['maintain_date']   = 0;
						$report[$post_details[$i]['ticket_id']]['count']           = 0;
						$report[$post_details[$i]['ticket_id']]['used_sla_seconds']= 0;
						$report[$post_details[$i]['ticket_id']]['total_sla_seconds'] = 0;
						$report[$post_details[$i]['ticket_id']]['auditlogentry_date'] = 0;
						$total_post= 0;
						$report[$post_details[$i]['ticket_id']]['due_date']  =0;
					} elseif($post_details[$i]['old_info']!=''){
						$total_sla_seconds = ($post_details[$i]['due_time'] - $report[$post_details[$i]['ticket_id']]['start_time']);
						$report[$post_details[$i]['ticket_id']]['due_date']  = ($post_details[$i]['due_time'] - $post_details[$i]['lastrepliertime']); 
						$report[$post_details[$i]['ticket_id']]['as_client']	   = $post_details[$i]['as_client'];
						//$maintain_date_nw = !isset($report[$post_details[$i]['ticket_id']]['maintain_date_nw'])? 0:$report[$post_details[$i]['ticket_id']]['maintain_date_nw'];
						$report[$post_details[$i]['ticket_id']]['sla_response_time'] = round($maintain_date_nw);		
						 $report[$post_details[$i]['ticket_id']]['used_sla_seconds'] = $report[$post_details[$i]['ticket_id']]['sla_response_time'];
						 $report[$post_details[$i]['ticket_id']]['timestamp'] = $report[$post_details[$i]['ticket_id']]['sla_response_time'];
						$submitter = $post_details[$i]['operator'];
						$operation_id = $post_details[$i]['operation_id'];
						$new_info = ($post_details[$i]['new_info']!='' && is_string($post_details[$i]['new_info'])) ? $post_details[$i]['new_info'] : '';
						$entry_date = $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['auditlogentry_date'] = $entry_date;
						
						$report_cnt++;
					}
				} 
				$old_ticket_id=$post_details[$i]['ticket_id'];
				}
			} else {
				$report = -1;
			}
			$report_new = array();
			$responseCounte=0;
			
			$totrepltime=0;
			$avgtotrepltime=0;
			$avgtotrepltime=0; 
			$tcount=0;
			$totalincidentsreplied=$auditlogentry_date=0;
			$totlavgresposmaintain=$totlavgresolmaintain=0;
			if ($report != -1) {
				foreach ($report as $ticket_id => $details) {
					$isUndueSet = 0; 
					/* if($details['tcount']>0){ */
					$report[$ticket_id]['totlavgresposmaintain']=0;
					if($details['tcount']>0 || ($details['tcount']>=0 && $details['count']>0)){
						if($details['lastrepliertime']>0 && $details['ticket_entry']>0){
							$totrepltime = $details['lastrepliertime'] - $details['ticket_entry']; }
							if(isset($totrepltime) && $totrepltime!=0){
								if ($details['tcount']!=0) {
									$avgtotrepltime = count_remain_time(round($totrepltime / $details['tcount']));
									$report[$ticket_id]['avg_tot_replied_time']=$avgtotrepltime;
									$report[$ticket_id]['tot_post_and_reply_time']=$totrepltime;
								}
								$tcount += $details['tcount'];
								$totalincidentsreplied++;
							}
						}else{ 
						if(isset($details['status_id']) && $details['status_id']==3 && ( isset($details['closed_time']) && $details['closed_time']!='')){
						$totrepltime = $details['closed_time'] - $details['lastrepliertime'];
						$report[$ticket_id]['tot_post_and_reply_time']=$totrepltime;
						}
					} 
					if($details['pause_rtime'] == ''){
					if($details['closed_time']=='' && $details['status_id']==4 && is_string($new_info)){
						$calculate_resolve_time = $details['auditlogentry_date'] - $details['applyslaresol_time'];
					} else {
						$calculate_resolve_time = $details['resolve_time'] - (isset($details['closed_time']))? $details['closed_time'] :0;
					}
					if ($details['resolve_time'] < 0 && ($details['status_id'] == 3 || $details['status_id'] == 4)) {
						$isUndueSet                                = 0;
						$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTUNDUE'];
					} else if (($details['resolve_time'] < 0 || $details['remain_resolve'] < 0) && $details['status_id'] != 3  && $details['status_id']!=4) {
						$isUndueSet                                = 0;
						if($details['pause_rtime'] == ''){$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTNOTMAINTAIN'];}else{
						$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTOVERDUE'];}
					} else if (($details['resolve_time'] > 0 || $details['remain_resolve'] > 0) && $details['status_id']!=3  && $details['status_id']!=4) {
						$isUndueSet                                = 0;
						if($details['count']!= 0){
							$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTUNDUE'];
						} else {
							$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTNOTRESPONDED'];
						}
						if(isset($details['lastrepliertime']) && $details['lastrepliertime']>0){
						$report[$ticket_id]['lastrepliertime'] = $details['lastrepliertime'];
						}
					} else {
						$isUndueSet = 1;
						if($calculate_resolve_time > 0){
							if($details['count']!=0)
								$resolutionCount++;
						}
						if($details['closed_time']=='' && (isset($details['status_id']) && ($details['status_id']==4 || $details['status_id']==3))){				
						if($auditlogentry_date==0){ $auditlogentry_date = $details['entry_dateee']; }	
						if($auditlogentry_date>0){
							$report[$ticket_id]['avg_resolution_time'] = count_remain_time($auditlogentry_date - $details['applyslaresol_time']); }
						} else {						
								if($report[$ticket_id]['customsla']>0)	{
								$report[$ticket_id]['avg_resolution_time'] = count_remain_time($details['closed_time'] - $details['applyslaresol_time']);
							}	else	{
								/* $report[$ticket_id]['avg_resolution_time'] = count_remain_time($details['closed_time'] - $details['ticket_entry']); */
								$report[$ticket_id]['avg_resolution_time'] = count_remain_time($details['closed_time'] - $details['ticket_entry']);
							}
						}
						if($details['tcount']>=1){
						 //$totlavgresolmaintain+=1;
						$report[$ticket_id]['totalmaintcont']=1;
							$responseCount++;
						}
					}
					if($details['tcount']==0 && ($details['status_id']==3 || $details['status_id']==4)){
						$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTMAINTAIN'];
					} else if(($details['resolve_time'] < 0 || $details['remain_resolve'] < 0) && $details['status_id']!=3 && $details['status_id']!=4) {
						if($responseCount!=0) { $responseCount--; }else{ $responseCount++;}
						if($details['tcount'] > 1){  
							$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTMAINTAIN'];
						} else {
							$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTRESPONDED'];
						} 
					} else if($details['tcount']!= 0 && ($details['status_id']==3 || $details['status_id']==4)){
						if($details['resolve_time'] < 0 || $details['remain_resolve'] < 0){ 
							$responseCount--;
							$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTRESPONDED'];
						} else {
							$report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
							$report[$ticket_id]['totlavgresposmaintain']++;
						}
					} else if (($details['resolve_time'] > 0 || $details['remain_resolve'] > 0) && ($details['status_id']!=3 && $details['status_id']!=4)) {
						if($details['tcount'] > 1){  
							$report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
							$report[$ticket_id]['totlavgresposmaintain']++;
						} else {
							if ($details['operation_id']==0 && $details['operator']==2) {
							$report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
								if($details['used_sla_seconds'] > 0)	{
										$report[$ticket_id]['totlavgresposmaintain']++;
									}
							}	else{
							$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTRESPONDED'];
							}
						}
					}
					if($details['tcount']!=0 && ($details['status_id']==3 || $details['status_id']==4)){
							$report[$ticket_id]['response_sla_stat'] = $vis_language['TXTMAINTAIN'];
						}else{
							$report[$ticket_id]['response_sla_stat'] = $vis_language['TXTNOTRESPONDED'];
						}
					if($isUndueSet == 1 && $resolutionCount>0){ 
						if($details['status_id']!=3 && $details['status_id']!=4 ){
							
							if($details['count']!=0){
								 $report[$ticket_id]['resolution_sla']   = $vis_language['MSGNOTRESOLVED'] ;
							} else {
								$report[$ticket_id]['resolution_sla']   = $vis_language['MSGNOTRESOLVED'];
							}
						} else {
							if($details['resolve_time'] < 0){ /*|| $details['remain_resolve'] < 0){*/
								$report[$ticket_id]['resolution_sla'] = $vis_language['TXTNOTMAINTAIN'];
							} else { 
								if($details['resolve_time']<$details['closed_time']){
                                    $report[$ticket_id]['resolution_sla'] = $vis_language['TXTNOTMAINTAIN'];
                                }else{
                                $report[$ticket_id]['resolution_sla'] = $vis_language['TXTMAINTAIN'];
								$totlavgresolmaintain++;
	                            }
							}
						}
					} elseif($details['count']==0 && $details['status_id']!=3 && $details['status_id']!=4){ 
						if($details['remain_resolve'] > 0){	  $report[$ticket_id]['resolution_sla']   =$vis_language['MSGNOTRESOLVED'];
						}else{ $report[$ticket_id]['resolution_sla']   = $vis_language['TXTOVERDUE']; }
					} elseif($details['count']!=0 && $details['status_id']!=3 && $details['status_id']!=4 && $details['remain_resolve'] > 0){ 
						 $report[$ticket_id]['resolution_sla']   = $vis_language['MSGNOTRESOLVED'];
					} else if(($details['resolve_time'] < 0 || $details['remain_resolve'] < 0) &&   $details['status_id']!=3 && $details['status_id']!=4){
						$report[$ticket_id]['resolution_sla']   = $vis_language['TXTOVERDUE'];

					}else{
						if($details['count']==0 && $details['status_id']!=3 && $details['status_id']!=4){ 
							$report[$ticket_id]['resolution_sla']   = "NA";
						} else {  
							if($details['closed_time'] > $details['resolve_time'] && ($details['status_id']==3 || $details['status_id']==4)){
								$report[$ticket_id]['resolution_sla']   = $vis_language['TXTNOTMAINTAIN'];
							}else{
								$report[$ticket_id]['resolution_sla']   = $vis_language['TXTMAINTAIN'];
								$totlavgresolmaintain++;
							}
						}
					}
					$cal_timestamp = (isset($details['timestamp']) && $details['timestamp'] != '' && $details['count'] != '0')? round(($details['timestamp']/$details['count']),2):''; 
					if($details['count']!=0){
						$replied_ticket_cnt+=1;
					} else {
						$replied_ticket_cnt+=0;
					}
					$report[$ticket_id]['avg_response_time']=($details['count']!=0) ? count_remain_time($cal_timestamp) : (($details['operation_id']==0 && $details['operator']==2) ? '0S': $vis_language['TXTNOTRESPONDED']);
					if($details['count']!=0)
		                {
		                    $report[$ticket_id]['avg_response_time'] = count_remain_time($cal_timestamp);
		                }
	                else
		                {               	
			                $report[$ticket_id]['avg_response_time'] = '0 S';	                	
		                }
	            if(isset($report[$ticket_id]['avg_tot_replied_time']) && $report[$ticket_id]['avg_tot_replied_time'] >0 ){			
				if($details['due_date'] < 0 && $details['tcount']>=1){ 
					if($details['operator']==1 || $details['as_client']==1) {       
                        $report[$ticket_id]['response_sla'] =   $vis_language['TXTNOTMAINTAIN']; 
                    } elseif ($details['lastrepliertime'] > $details['resolve_time']) {
                        $report[$ticket_id]['response_sla'] =   $vis_language['TXTNOTMAINTAIN'];
                    } else{
                    $report[$ticket_id]['response_sla'] =  $vis_language['TXTMAINTAIN'];
                    $report[$ticket_id]['totlavgresposmaintain']++;
                    }
				} else {
					$report[$ticket_id]['response_sla'] =  $vis_language['TXTMAINTAIN'];
					$report[$ticket_id]['totlavgresposmaintain']++;
				}			
			}else{ 				
				if((isset($details['response_sla']) && $details['response_sla']==$vis_language['TXTOVERDUE'] && $details['response_sla']!='')) {
					if($details['operator']==1 || $details['as_client']==1) {       
                        $report[$ticket_id]['response_sla'] =  $details['response_sla'];
                    }  else {
                    	$report[$ticket_id]['response_sla'] =  $vis_language['TXTMAINTAIN'];
                    	$report[$ticket_id]['totlavgresposmaintain']++;
                    }
				} else {	
					if($details['operator']==1 || $details['as_client']==1) {       
						if($details['due_date'] > 0 && $details['count']>=1) {
							$report[$ticket_id]['response_sla'] =  $vis_language['TXTMAINTAIN'];
							$report[$ticket_id]['totlavgresposmaintain']++;
						}	else {
								if($details['count'] >=1){
								  $report[$ticket_id]['response_sla'] =   $vis_language['TXTNOTMAINTAIN']; 
								}else{
	                       		$report[$ticket_id]['response_sla'] =  $vis_language['TXTNOTRESPONDED'];									
								}
							}
                    } elseif($report[$ticket_id]['avg_response_time']=='0 S')  { 
  	                    	$report[$ticket_id]['response_sla'] =  $vis_language['TXTMAINTAIN'];      
  	                } else   {
                    $report[$ticket_id]['response_sla'] =  $vis_language['TXTNOTRESPONDED'];
                    }
				}
			}
				if($details['count']!=0)
						$responseCount+=1;
				if($report[$ticket_id]['totlavgresposmaintain'] > 0) {
							$totlavgresposmaintain++;
						}

				} else
					$report[$ticket_id]['response_sla'] =  'NA';
				}
				foreach (((isset($operation['vis_export']) && $operation['vis_export'] == 1)? $report:array_slice($report, $limit, $view_info['page_count'])) as $p) {
					$report_new[] = $p;
				}
				$array_summary=array();
	            $array_summary['TXTTOTALTICKETSREPLIED']=$totalincidentsreplied;
	            $array_summary['TXTTOTALAVGRESPONSESLAMAINTAIN']=(($totlavgresposmaintain==0)?0:round((($totlavgresposmaintain/count($report))*100), 2)).'%';
	            $array_summary['TXTTOTALAVGRESOLUTIONSLAMAINTAIN']=(($totlavgresolmaintain==0)?0:round((($totlavgresolmaintain/count($report))*100), 2)).'%';
				$total = count($report);
				$view_info['page']=$page;
				$report_count=($report_new!=-1 || !empty($report_new)) ? count($report_new) : 0;
				$view_info['page_count']=(count($report)==0)? 0 : ceil(count($report)/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				$replied_ticket_cnt = 0;
				foreach ($report as $i) {
					foreach ($i as $key => $val) {
						if ($key == 'sla_time'){
							$report_exp[$j]['SLA'] = count_remain_time($val);
						} 
						elseif ($key == 'timestamp'){							
							$report_exp[$j]['SLA']= ($i['count']!=0) ? count_remain_time($val/$i['count']) : $vis_language['TXTNOTRESPONDED'];
						} 
						elseif ($key == 'ticket_entry'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'due_time'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'resolve_time'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'ticket_hash' || $key == 'subject' || $key == 'department_name' || $key == 'ticket_priority' || $key == 'status_name' ||  $key == 'type' ||  $key == 'impact' ||  $key == 'urgency' ||  $key == 'flag'  ||  $key == 'ticket_category'  ||  $key == 'ticket_sub_cateogy' || $key == 'ticket_level' || $key == 'sla_name' || $key == 'first_name' || $key == 'last_name' || $key == 'email' || $key == 'group_name'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'tot_post_and_reply_time'){
							$report_exp[$j][$key] = $val;
						}else if ($key == 'avg_resolution_time'){
							$report_exp[$j][$key] = $val;
						}elseif ($key == 'totalmaintcont'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'pause_rtime'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'status_id'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'new_info'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'closed_time'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'tcount'){
							$report_exp[$j][$key] = $val;
						}  elseif ($key == 'avg_tot_replied_time'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'operator'){
							$report_exp[$j][$key] = $val;
						}	elseif ($key == 'as_client'){
							$report_exp[$j][$key] = $val;
						}	elseif ($key == 'due_date'){
							$report_exp[$j][$key] = $val;
						}	 else if ($key == 'response_sla'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'resolution_sla'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'avg_response_time'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'client_id'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'count'){
							$report_exp[$j][$key] = $val;
						}
					}
					$sla_name = ($report_exp[$j]['sla_name']!= '')?$report_exp[$j]['sla_name']:$vis_language['TXTCUSTDUETIME'];
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['creation_date'] = $report_exp[$j]['ticket_entry'];
					$report_exp1[$j]['department'] = $report_exp[$j]['department_name'];
					$report_exp1[$j]['client_email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					$report_exp1[$j]['sla_plan'] = $sla_name;
					$report_exp1[$j]['priority'] = $report_exp[$j]['ticket_priority'];
					$report_exp1[$j]['status'] = $report_exp[$j]['status_name'];
					$report_exp1[$j]['type'] = $report_exp[$j]['type'];
					$report_exp1[$j]['urgency'] = $report_exp[$j]['urgency'];
					$report_exp1[$j]['flag'] = $report_exp[$j]['flag'];
					$report_exp1[$j]['impact'] = $report_exp[$j]['impact'];
					$report_exp1[$j]['category'] = $report_exp[$j]['ticket_category'];
					$report_exp1[$j]['sub_category'] = $report_exp[$j]['ticket_sub_cateogy'];
					$report_exp1[$j]['level'] = $report_exp[$j]['ticket_level'];

					$report_exp1[$j]['avg_response_time'] = ($report_exp[$j]['pause_rtime']!='') ? $vis_language['MSGNOTRESOLVED'] : $report_exp[$j]['avg_response_time'];

					$resolution_time = (isset($report_exp[$j]['tot_post_and_reply_time']) && $report_exp[$j]['tot_post_and_reply_time'] !=0 )?count_remain_time(round($report_exp[$j]['tot_post_and_reply_time'])): $vis_language['TXTNOTRESPONDED'];
					

		            $cal_timestamp = ($report_exp[$j]['timestamp'] != '' && $report_exp[$j]['count'] != '0')? round(($report_exp[$j]['timestamp']/$report_exp[$j]['count']),2):''; 

					$report[$ticket_id]['avg_response_time']=($report_exp[$j]['count']!=0) ? count_remain_time($cal_timestamp) : (($report_exp[$j]['operation_id']==0 && $report_exp[$j]['operator']==2) ? '0S': $vis_language['TXTNOTRESPONDED']);
					if($report_exp[$j]['count']!=0)    {
		                    $report_exp1[$j]['avg_response_time'] = count_remain_time($cal_timestamp);
		                }   else  {               	
			                $report_exp1[$j]['avg_response_time'] = '0 S';	                	
		                }
	                if(isset($report_exp[$j]['pause_rtime']) && $report_exp[$j]['pause_rtime']!=''){
					    $report_exp1[$j]['avg_response_time']='NA';
					}elseif(isset($report_exp[$j]['avg_response_time']) && $report_exp[$j]['avg_response_time'] !=0)
						{
							$report_exp1[$j]['avg_response_time']=  $report_exp[$j]['avg_response_time'];
						}
					elseif(isset($report_exp[$j]['avg_response_time']) && $report_exp[$j]['avg_response_time'] =='0 S' && $report_exp[$j]['operator']!=1 && $report_exp[$j]['as_client']!=1){ 
						$report_exp1[$j]['avg_response_time']=  '0 S';
					}else{ 
						$report_exp1[$j]['avg_response_time'] = $vis_language['TXTNOTRESPONDED'];
					}
                	// $resolution_flag = ($report_exp[$j]['pause_rtime']!='') ? $report_exp[$j]['pause_rtime'] : '';
					if(isset($report_exp[$j]['pause_rtime']) && $report_exp[$j]['pause_rtime']!=''){
					    $report_exp1[$j]['avg_resolution_time']='NA';
					}elseif(isset($report_exp[$j]['status_id']) &&($report_exp[$j]['status_id']==4 || $report_exp[$j]['status_id']==3)){
						$report_exp1[$j]['avg_resolution_time'] = (isset($report_exp[$j]['avg_resolution_time']) && $report_exp[$j]['avg_resolution_time'] !='' )? $report_exp[$j]['avg_resolution_time'] :"Not resolved"; //$resolution_time;
						}else{ 
						 $report_exp1[$j]['avg_resolution_time'] = (isset($report_exp[$j]['resolution_sla']) && $report_exp[$j]['resolution_sla'] !='' ) ? $report_exp[$j]['resolution_sla']: $vis_language['TXTNOTMAINTAIN'];
						}

					if(isset($report_exp[$j]['pause_rtime']) && $report_exp[$j]['pause_rtime']!=''){
					    $report_exp1[$j]['response_sla']='NA';
					}elseif(isset($report_exp[$j]['avg_tot_replied_time']) && $report_exp[$j]['avg_tot_replied_time'] >0 ){
					    $replied_ticket_cnttt+=$report_exp[$j]['tcount'];
					    $rescounttt++;
					    if($report_exp[$j]['due_date'] < 0 && $report_exp[$j]['tcount']>=1){
					        if($report_exp[$j]['operator']==1 || $report_exp[$j]['as_client']==1){       
					            $report_exp1[$j]['response_sla'] = $vis_language['TXTNOTMAINTAIN'];
					        } else {
					            $report_exp1[$j]['response_sla'] = $vis_language['TXTNOTMAINTAIN'];
					            // $report_exp1[$j]['response_sla'] = $vis_language['TXTMAINTAIN'];
					        }
					    } else {
					        $report_exp1[$j]['response_sla'] =  $vis_language['TXTMAINTAIN'];
					    }           
					}else{ 
					    if((isset($report_exp[$j]['response_sla'] ) && $report_exp[$j]['response_sla']==$vis_language['TXTOVERDUE']  && $report_exp[$j]['response_sla']!='')){
					        if($report_exp[$j]['operator']==1 || $report_exp[$j]['as_client']==1){
					            $report_exp1[$j]['response_sla']=$report_exp[$j]['response_sla'];
					        }else{
					            $report_exp1[$j]['response_sla']=$vis_language['TXTMAINTAIN'];
					        } 
					    }else{
					        if($report_exp[$j]['operator']==1 || $report_exp[$j]['as_client']==1){					            
					            if($report_exp[$j]['due_date'] > 0 && $report_exp[$j]['count']>=1) {
										$report_exp1[$j]['response_sla']=$vis_language['TXTMAINTAIN'];
									} else {			                       		
			                       		//$report_exp1[$j]['response_sla']=$vis_language['TXTNOTRESPONDED'];
			                       		if($report_exp[$j]['count'] >=1){
			                       				$report_exp1[$j]['response_sla']=$vis_language['TXTNOTMAINTAIN'];
											}else{
                       							$report_exp1[$j]['response_sla']=$vis_language['TXTNOTRESPONDED'];					
											}
									}
					        } elseif($report_exp[$j]['avg_response_time']=='0 S') {	  	                 
	  	                    	$report_exp1[$j]['response_sla']=$vis_language['TXTMAINTAIN'];
                    } else{
					            $report_exp1[$j]['response_sla']=$vis_language['TXTNOTRESPONDED'];
					        }
					    }
					}

					if(isset($report_exp[$j]['pause_rtime']) && $report_exp[$j]['pause_rtime']!=''){
					    $report_exp1[$j]['resolution_sla']='NA';
					}elseif((isset($report_exp[$j]['resolution_sla']) && $report_exp[$j]['resolution_sla']==$vis_language['TXTOVERDUE']) || !isset($report_exp[$j]['resolution_sla'])){
					    $report_exp1[$j]['resolution_sla']=$vis_language['TXTNOTMAINTAIN'];
					}else{
					     $report_exp1[$j]['resolution_sla']=(isset($report_exp[$j]['resolution_sla']) && $report_exp[$j]['resolution_sla']!='')?$report_exp[$j]['resolution_sla']:$vis_language['TXTNOTMAINTAIN'];
					}

					if($i['count']!=0)	{
						$replied_ticket_cnt+=1;
					} 	else 	{
						$replied_ticket_cnt+=0;
					}
					
					$j++;
				}

				if($report!=-1){
					foreach($array_summary as $key=>$val){ 
					$title=explode(' ',$key);
					$title[1]=isset($title[1])? ' '.$title[1]:'';
					 $report_exp1[$j][$vis_language[$title[0]].$title[1]]=$vis_language[$title[0]].$title[1].' : '.$val; 
					}
				}
 
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE.'report_page.php');
			} 
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function incident_type_sla_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTINCTYPESLA'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();

		$export = 1;
		$report_type=196;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$lc_channel_id=$tkt_object->get_channel('default_id=25',$staff_id,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		$domain     = $tkt_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']);
		$paging_form_page=($page*$view_info['page_count']);
		$operation['set_clientblank'] = 0;
		$operation['vis_current_operation']='incident_type_sla_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		list($ctinfo, $incident_type) = $tkt_object->get_ticket_type_list(VIS_TABLE_PREFIX.'ticket_type.is_enabled=1', '', $staff_id, VIS_LOCATION_AREA);
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if(isset($data['field_type']))
				$data['field_type'] = is_array($data['field_type'])? implode(',', $data['field_type']):0;
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if (isset($data['duration'])&&!isset($data['field_type'])) {
					$data['field_type'] = 0;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['field_type'] == 0  && $data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] == 0  && $data['field_type'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] == 0  && $data['field_type'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] != 0  && $data['field_type'] == 0 && $operation['set_clientblank']==0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTTICKETTYPE']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 &&  $data['domain_id'] != 0  &&  $data['field_type'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$service='';
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;}
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = '(operation_id<=2 or operation_id=50 or operation_id=51 or operation_id=13) and '.VIS_TABLE_PREFIX.'ticket.receive_date between '.$from.' AND '.$to.' and find_in_set('.VIS_TABLE_PREFIX.'ticket.type_id, "'.$data['field_type'].'") and '.VIS_TABLE_PREFIX.'ticket.domain_id='.$data['domain_id'].$service;
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$filter .= ' and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX.'ticket.resolution_time!=0 and '.VIS_TABLE_PREFIX.'ticket.due_time!=0 ';
			$post_details    = $object->incident_category_sla_report($filter, '', $staff_id, VIS_LOCATION_AREA);
			$resolutionCount = $responseCount = $report_avg = $report_cnt = $replied = $total_time = $replied_ticket_cnt = $submitter = $entry_date = 0;$maintain_date_nw1 =0;$maintain_date_nw = 0;
			$report          = array();
			$new_info		 = '';
		  	 
			if ($post_details != -1){
				for($i=0;$i<count($post_details);$i++){
					 //echo "<br> as_client".$post_details[$i]['as_client'];
					 // echo "<br> submitter".$submitter;
					if($old_ticket_id != $post_details[$i]['ticket_id']){
						$report[$post_details[$i]['ticket_id']]['post_date'] = 0;
						$maintain_date_nw1 = $maintain_date_nw=0;
						$report[$post_details[$i]['ticket_id']]['as_client'] = ''; 
						$report[$post_details[$i]['ticket_id']]['count']=0;
						$report[$post_details[$i]['ticket_id']]['tcount']=0;	
						$as_client_or_clientticket=0;
						$last_operation_id =0;
					} 
					$report[$post_details[$i]['ticket_id']]['as_client'] = '';
					if(isset($post_details[$i]['as_client']) && $post_details[$i]['as_client']!="")
					{
						$report[$post_details[$i]['ticket_id']]['as_client'] = $post_details[$i]['as_client'];
					}
					else
					{
						$report[$post_details[$i]['ticket_id']]['as_client'] = '';
					}

					 if($post_details[$i]['operation_id']==13)	{   
							if(!isset($report[$post_details[$i]['ticket_id']]['customsla'])){
								$report[$post_details[$i]['ticket_id']]['customsla']=1;	
							} 
							else{
								$report[$post_details[$i]['ticket_id']]['customsla']++;	
							}  
						 $report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date'];
					 }
					 
					if($post_details[$i]['operation_id']!=13)	{ 
					if($post_details[$i]['operation_id']==0 && $post_details[$i]['operator']==1){
					  	$report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date'];
						//$submitter = $post_details[$i]['operator'];
						 $last_operation_id = $post_details[$i]['operation_id'];
						$as_client_or_clientticket=1;
					} else if($post_details[$i]['operation_id']==1 &&  $post_details[$i]['operator']==1 && $submitter!=1 ){
						if($last_operation_id ==0 && $submitter==2&&$post_details[$i]['as_client']==1){
						 	$report[$post_details[$i]['ticket_id']]['post_date'] = $report[$post_details[$i]['ticket_id']]['post_date'];
						}else{
						  	$report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date'];	
						}

						$last_operation_id = $post_details[$i]['operation_id'];
						$maintain_date_nw1 = $maintain_date_nw; 
						$as_client_or_clientticket=1; 
					} else if($post_details[$i]['operation_id']==50){
						$report[$post_details[$i]['ticket_id']]['pause_date']=$post_details[$i]['entry_date'];
						$last_operation_id = $post_details[$i]['operation_id'];
					} else if($post_details[$i]['operation_id']==51){
						$report[$post_details[$i]['ticket_id']]['resume_date']=$post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['slapause_diff'] += $post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['pause_date'];
						$last_operation_id = $post_details[$i]['operation_id'];
					} else if($post_details[$i]['operation_id']==1 && $post_details[$i]['operator']!=1){
						$last_operation_id = $post_details[$i]['operation_id'];
						if($post_details[$i]['as_client'] == 1){
							$as_client_or_clientticket=1; 
						}
						/*if($submitter == $post_details[$i]['operator'] && $post_details[$i]['as_client']==0){
							if (!isset($report[$post_details[$i]['ticket_id']]['maintain_date']))
							$report[$post_details[$i]['ticket_id']]['maintain_date'] = 0;
							else
							$report[$post_details[$i]['ticket_id']]['maintain_date'] += 0;
						} else */{
							$report[$post_details[$i]['ticket_id']]['post_date']=(isset($report[$post_details[$i]['ticket_id']]['post_date']) && $report[$post_details[$i]['ticket_id']]['post_date']!='')?$report[$post_details[$i]['ticket_id']]['post_date']:0;  
						 	$maintain_date = $post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['post_date'];
							// echo "<br>2 post date  ".$report[$post_details[$i]['ticket_id']]['post_date']." entry dt ".$post_details[$i]['entry_date'];
							 $maintain_date_nw = $post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['post_date'];
							// echo "<br>old maintain_date_nw1 ".$maintain_date_nw1 ;
							$maintain_date_nw = $maintain_date_nw + $maintain_date_nw1;
							if($report[$post_details[$i]['ticket_id']]['ticket_id'] == $post_details[$i]['ticket_id']){
								//
								$report[$post_details[$i]['ticket_id']]['maintain_date'] += $maintain_date;
								$maintain_date_nw1 = $maintain_date_nw;
							} else {
								$report[$post_details[$i]['ticket_id']]['maintain_date'] = $maintain_date;
								$maintain_date_nw1 = 0;
							}
							$report[$post_details[$i]['ticket_id']]['count']=(isset($report[$post_details[$i]['ticket_id']]['count']) && $report[$post_details[$i]['ticket_id']]['count']!='')?$report[$post_details[$i]['ticket_id']]['count']:0;
							/*  $report[$post_details[$i]['ticket_id']]['count']++; */
						}
						//echo "<br> maintain_date ticket ".$report[$post_details[$i]['ticket_id']]['maintain_date'];
						 if(isset($report[$post_details[$i]['ticket_id']]['maintain_date']) && $report[$post_details[$i]['ticket_id']]['maintain_date'] > 0)
							{  
								$report[$post_details[$i]['ticket_id']]['count']++;
								$report[$post_details[$i]['ticket_id']]['tcount']++;
								$report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date'];
								if($as_client_or_clientticket==0){
									//echo "<br>++++++++".$as_client_or_clientticket;
									$report[$post_details[$i]['ticket_id']]['count']=$report[$post_details[$i]['ticket_id']]['count']-1;
									$report[$post_details[$i]['ticket_id']]['tcount']=$report[$post_details[$i]['ticket_id']]['tcount']-1;
								}
							} 
						  
						$new_info = ($post_details[$i]['new_info']!='' && is_string($post_details[$i]['new_info'])) ? $post_details[$i]['new_info'] : '';
						$entry_date = $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['auditlogentry_date'] = $entry_date;
						$operation_id = $post_details[$i]['operation_id'];
						$total_post++;
						$report_cnt++;
					}else{ 
						$report[$post_details[$i]['ticket_id']]['entry_dateee']  = $post_details[$i]['entry_date']; 
					}  // prev 
					$submitter = $post_details[$i]['operator'];
					if (!isset($report[$post_details[$i]['ticket_id']]['start_time'])) {
						$report[$post_details[$i]['ticket_id']]['ticket_hash']     = $post_details[$i]['ticket_hash'];
						$report[$post_details[$i]['ticket_id']]['subject']         = $post_details[$i]['subject'];
						$report[$post_details[$i]['ticket_id']]['ticket_entry']    = $post_details[$i]['receive_date'];
						$report[$post_details[$i]['ticket_id']]['start_time']      = $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['post_date']	   = $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['ticket_priority'] = $post_details[$i]['ticket_priority'];
						$report[$post_details[$i]['ticket_id']]['department_name'] = $post_details[$i]['department_name'];
						$report[$post_details[$i]['ticket_id']]['first_name'] 	   = $post_details[$i]['first_name'];
						$report[$post_details[$i]['ticket_id']]['last_name']	   = $post_details[$i]['last_name'];
						$report[$post_details[$i]['ticket_id']]['email']		   = $post_details[$i]['email'];
						$report[$post_details[$i]['ticket_id']]['group_name']	   = $post_details[$i]['group_name'];
						$report[$post_details[$i]['ticket_id']]['client_id']       = $post_details[$i]['client_id'];
						$report[$post_details[$i]['ticket_id']]['ticket_id']       = $post_details[$i]['ticket_id'];
						$report[$post_details[$i]['ticket_id']]['status_id']       = $post_details[$i]['status_id'];
						$report[$post_details[$i]['ticket_id']]['remain_resolve']  = $post_details[$i]['remain_resolve'];
						$report[$post_details[$i]['ticket_id']]['pause_rtime']	   = $post_details[$i]['pause_rtime'];
						$report[$post_details[$i]['ticket_id']]['resolve_time']    = $post_details[$i]['resolution_time'];
						$report[$post_details[$i]['ticket_id']]['status_name']     = $post_details[$i]['status_name'];
						$report[$post_details[$i]['ticket_id']]['urgency']     = $post_details[$i]['urgency'];
						$report[$post_details[$i]['ticket_id']]['impact']     = $post_details[$i]['impact'];
						$report[$post_details[$i]['ticket_id']]['flag']     = $post_details[$i]['flag'];
						$report[$post_details[$i]['ticket_id']]['type']     =  (isset($post_details[$i]['type']))? $post_details[$i]['type'] :'';
						$report[$post_details[$i]['ticket_id']]['ticket_category']     =  (isset($post_details[$i]['ticket_category']))? $post_details[$i]['ticket_category'] :'';
						$report[$post_details[$i]['ticket_id']]['ticket_sub_cateogy']     =  (isset($post_details[$i]['ticket_sub_cateogy']))? $post_details[$i]['ticket_sub_cateogy'] :'';
						$report[$post_details[$i]['ticket_id']]['ticket_level']     =  (isset($post_details[$i]['ticket_level']))? $post_details[$i]['ticket_level']:'';
						$report[$post_details[$i]['ticket_id']]['sla_name']        = $post_details[$i]['sla_name'];
						$report[$post_details[$i]['ticket_id']]['operator']		   = $post_details[$i]['operator'];
						$report[$post_details[$i]['ticket_id']]['operation_id']	   = $post_details[$i]['operation_id'];
						$report[$post_details[$i]['ticket_id']]['closed_time']	   = $post_details[$i]['closed_time'];
						$report[$post_details[$i]['ticket_id']]['as_client']	   = $post_details[$i]['as_client'];
						$report[$post_details[$i]['ticket_id']]['new_info']		   = $post_details[$i]['new_info'];
						$report[$post_details[$i]['ticket_id']]['applyslaresol_time'] = $post_details[$i]['applyslaresol_time'];
						if (!isset($report[$post_details[$i]['ticket_id']]['tcount']))
						$report[$post_details[$i]['ticket_id']]['tcount']          = 0;
						else
						$report[$post_details[$i]['ticket_id']]['tcount']          += 0;							
						$report[$post_details[$i]['ticket_id']]['lastrepliertime'] = $post_details[$i]['lastrepliertime'];
						$report[$post_details[$i]['ticket_id']]['solve_time']      = 0;
						$report[$post_details[$i]['ticket_id']]['slapause_diff']   = 0;
						$report[$post_details[$i]['ticket_id']]['maintain_date']   = 0;
						$report[$post_details[$i]['ticket_id']]['count']           = 0;
						$report[$post_details[$i]['ticket_id']]['used_sla_seconds']= 0;
						$report[$post_details[$i]['ticket_id']]['total_sla_seconds'] = 0;
						$report[$post_details[$i]['ticket_id']]['auditlogentry_date'] = 0;
						$total_post= 0;
						$report[$post_details[$i]['ticket_id']]['due_date']  =0;
					} elseif($post_details[$i]['old_info']!=''){
						$total_sla_seconds = ($post_details[$i]['due_time'] - $report[$post_details[$i]['ticket_id']]['start_time']);
						$report[$post_details[$i]['ticket_id']]['due_date']  = ($post_details[$i]['due_time'] - $post_details[$i]['lastrepliertime']); 
						$report[$post_details[$i]['ticket_id']]['as_client']	   = $post_details[$i]['as_client'];
						//$maintain_date_nw = !isset($report[$post_details[$i]['ticket_id']]['maintain_date_nw'])? 0:$report[$post_details[$i]['ticket_id']]['maintain_date_nw'];
						$report[$post_details[$i]['ticket_id']]['sla_response_time'] = round($maintain_date_nw);		
						 $report[$post_details[$i]['ticket_id']]['used_sla_seconds'] = $report[$post_details[$i]['ticket_id']]['sla_response_time'];
						 $report[$post_details[$i]['ticket_id']]['timestamp'] = $report[$post_details[$i]['ticket_id']]['sla_response_time'];
						$submitter = $post_details[$i]['operator'];
						$operation_id = $post_details[$i]['operation_id'];
						$new_info = ($post_details[$i]['new_info']!='' && is_string($post_details[$i]['new_info'])) ? $post_details[$i]['new_info'] : '';
						$entry_date = $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['auditlogentry_date'] = $entry_date;
						
						$report_cnt++;
					}
				} 
				$old_ticket_id=$post_details[$i]['ticket_id'];
				}
			} else {
				$report = -1;
			}
			$report_new = array();
			$responseCounte=0;
			$filter1 ='';
			$totrepltime=0;
			$avgtotrepltime=0;
			$avgtotrepltime=0; 
			$tcount=0;
			$totalincidentsreplied=$auditlogentry_date=0;
			$totlavgresposmaintain=$totlavgresolmaintain=0;
			if ($report != -1) {
				foreach ($report as $ticket_id => $details) {
					$isUndueSet = 0; 
					$report[$ticket_id]['totlavgresposmaintain']=0;
					if($details['tcount']>0 || ($details['tcount']>=0 && $details['count']>0)){
						if($details['lastrepliertime']>0 && $details['ticket_entry']>0){
							$totrepltime = $details['lastrepliertime'] - $details['ticket_entry']; }
							if(isset($totrepltime) && $totrepltime!=0){
								if ($details['tcount']!=0) {
								$avgtotrepltime = count_remain_time(round($totrepltime / $details['tcount']));
								$report[$ticket_id]['avg_tot_replied_time']=$avgtotrepltime;
								$report[$ticket_id]['tot_post_and_reply_time']=$totrepltime;
							}
								$tcount += $details['tcount']; 
								$totalincidentsreplied++;
							}
					}else{ 
					if(isset($details['status_id']) && $details['status_id']==3 && ( isset($details['closed_time']) && $details['closed_time']!='')){
						$totrepltime = $details['closed_time'] - $details['lastrepliertime'];
						$report[$ticket_id]['tot_post_and_reply_time']=$totrepltime;
						}
					} 
					if($details['pause_rtime'] == ''){
					if($details['closed_time']=='' && $details['status_id']==4 && is_string($new_info)){
						$calculate_resolve_time = $details['auditlogentry_date'] - $details['applyslaresol_time'];
					} else {
						$calculate_resolve_time = $details['resolve_time'] - (isset($details['closed_time']))? $details['closed_time'] :0;
					}
					if ($details['resolve_time'] < 0 && ($details['status_id'] == 3 || $details['status_id'] == 4)) {
						$isUndueSet                                = 0;
						$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTUNDUE'];
					} else if (($details['resolve_time'] < 0 || $details['remain_resolve'] < 0) && $details['status_id'] != 3  && $details['status_id']!=4) {
						$isUndueSet                                = 0;
						if($details['pause_rtime'] == ''){$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTNOTMAINTAIN'];}else{
						$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTOVERDUE'];}
					} else if (($details['resolve_time'] > 0 || $details['remain_resolve'] > 0) && $details['status_id']!=3  && $details['status_id']!=4) {
						$isUndueSet                                = 0;
						if($details['count']!= 0){
							$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTUNDUE'];
						} else {
							$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTNOTRESPONDED'];
						}
						if(isset($details['lastrepliertime']) && $details['lastrepliertime']>0){
						$report[$ticket_id]['lastrepliertime'] = $details['lastrepliertime'];
						}
					} else {
						$isUndueSet = 1;
						if($calculate_resolve_time > 0){
							if($details['count']!=0)
								$resolutionCount++;
						}
						if($details['closed_time']=='' && (isset($details['status_id']) && ($details['status_id']==4 || $details['status_id']==3))){				
						if($auditlogentry_date==0){ $auditlogentry_date = $details['entry_dateee']; }	
						if($auditlogentry_date>0){
							$report[$ticket_id]['avg_resolution_time'] = count_remain_time($auditlogentry_date - $details['applyslaresol_time']); }
						} else {
								if($report[$ticket_id]['customsla']>0)	{
								$report[$ticket_id]['avg_resolution_time'] = count_remain_time($details['closed_time'] - $details['applyslaresol_time']);
							}	else	{
								/* $report[$ticket_id]['avg_resolution_time'] = count_remain_time($details['closed_time'] - $details['ticket_entry']); */
								$report[$ticket_id]['avg_resolution_time'] = count_remain_time($details['closed_time'] - $details['ticket_entry']);
							}
						}
						if($details['tcount']>=1){
						 //$totlavgresolmaintain+=1;
						$report[$ticket_id]['totalmaintcont']=1;
							$responseCount++;
						}
					}
					if($details['tcount']==0 && ($details['status_id']==3 || $details['status_id']==4)){
						$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTMAINTAIN'];
					} else if(($details['resolve_time'] < 0 || $details['remain_resolve'] < 0) && $details['status_id']!=3 && $details['status_id']!=4) {
						if($responseCount!=0) { $responseCount--; }else{ $responseCount++;}
						if($details['tcount'] > 1){  
							$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTMAINTAIN'];
						} else {
							$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTRESPONDED'];
						} 
					} else if($details['tcount']!= 0 && ($details['status_id']==3 || $details['status_id']==4)){
						if($details['resolve_time'] < 0 || $details['remain_resolve'] < 0){ 
							$responseCount--;
							$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTRESPONDED'];
						} else {
							$report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
							$report[$ticket_id]['totlavgresposmaintain']++;
						}
					} else if (($details['resolve_time'] > 0 || $details['remain_resolve'] > 0) && ($details['status_id']!=3 && $details['status_id']!=4)) {
						if($details['tcount'] > 1){  
							$report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
							$report[$ticket_id]['totlavgresposmaintain']++;
						} else {
							if ($details['operation_id']==0 && $details['operator']==2) {
							$report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
								if($details['used_sla_seconds'] > 0)	{
										$report[$ticket_id]['totlavgresposmaintain']++;
									}
							}	else{
							$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTRESPONDED'];
							}
						}
					}
					if($details['tcount']!=0 && ($details['status_id']==3 || $details['status_id']==4)){
							$report[$ticket_id]['response_sla_stat'] = $vis_language['TXTMAINTAIN'];
						}else{
							$report[$ticket_id]['response_sla_stat'] = $vis_language['TXTNOTRESPONDED'];
						}
					if($isUndueSet == 1 && $resolutionCount>0){ 
						if($details['status_id']!=3 && $details['status_id']!=4 ){
							
							if($details['count']!=0){
								 $report[$ticket_id]['resolution_sla']   = $vis_language['MSGNOTRESOLVED'] ;
							} else {
								$report[$ticket_id]['resolution_sla']   = $vis_language['MSGNOTRESOLVED'];
							}
						} else {
							if($details['resolve_time'] < 0){ /*|| $details['remain_resolve'] < 0){*/
								$report[$ticket_id]['resolution_sla'] = $vis_language['TXTNOTMAINTAIN'];
							} else { 
								if($details['resolve_time']<$details['closed_time']){
                                    $report[$ticket_id]['resolution_sla'] = $vis_language['TXTNOTMAINTAIN'];
                                }else{
                                $report[$ticket_id]['resolution_sla'] = $vis_language['TXTMAINTAIN'];
								$totlavgresolmaintain++;
	                            }
							}
						}
					} elseif($details['count']==0 && $details['status_id']!=3 && $details['status_id']!=4){ 
						if($details['remain_resolve'] > 0){	  $report[$ticket_id]['resolution_sla']   =$vis_language['MSGNOTRESOLVED'];
						}else{ $report[$ticket_id]['resolution_sla']   = $vis_language['TXTOVERDUE']; }
					} elseif($details['count']!=0 && $details['status_id']!=3 && $details['status_id']!=4 && $details['remain_resolve'] > 0){ 
						 $report[$ticket_id]['resolution_sla']   = $vis_language['MSGNOTRESOLVED'];
					} else if(($details['resolve_time'] < 0 || $details['remain_resolve'] < 0) &&   $details['status_id']!=3 && $details['status_id']!=4){
						$report[$ticket_id]['resolution_sla']   = $vis_language['TXTOVERDUE'];

					}else{
						if($details['count']==0 && $details['status_id']!=3 && $details['status_id']!=4){ 
							$report[$ticket_id]['resolution_sla']   = "NA";
						} else {  
							if($details['closed_time'] > $details['resolve_time'] && ($details['status_id']==3 || $details['status_id']==4)){
								$report[$ticket_id]['resolution_sla']   = $vis_language['TXTNOTMAINTAIN'];
							}else{
								$report[$ticket_id]['resolution_sla']   = $vis_language['TXTMAINTAIN'];
								$totlavgresolmaintain++;
							}
						}
					}
					$cal_timestamp = (isset($details['timestamp'])&&$details['timestamp']!= '' && $details['count'] != '0')? round(($details['timestamp']/$details['count']),2):''; 
					if($details['count']!=0){
						$replied_ticket_cnt+=1;
					} else {
						$replied_ticket_cnt+=0;
					}
					$report[$ticket_id]['avg_response_time']=($details['count']!=0) ? count_remain_time($cal_timestamp) : (($details['operation_id']==0 && $details['operator']==2) ? '0S': $vis_language['TXTNOTRESPONDED']);
					if($details['count']!=0)
		                {
		                    $report[$ticket_id]['avg_response_time'] = count_remain_time($cal_timestamp);
		                }
	                else
		                {               	
			                $report[$ticket_id]['avg_response_time'] = '0 S';	                	
		                }
	            if(isset($report[$ticket_id]['avg_tot_replied_time']) && $report[$ticket_id]['avg_tot_replied_time'] >0 ){			
				if($details['due_date'] < 0 && $details['tcount']>=1){ 
					if($details['operator']==1 || $details['as_client']==1) {       
                        $report[$ticket_id]['response_sla'] =   $vis_language['TXTNOTMAINTAIN']; 
                    } elseif ($details['lastrepliertime'] > $details['resolve_time']) {
                        $report[$ticket_id]['response_sla'] =   $vis_language['TXTNOTMAINTAIN'];
                    } else {
                    $report[$ticket_id]['response_sla'] =  $vis_language['TXTMAINTAIN'];
                    $report[$ticket_id]['totlavgresposmaintain']++;
                    }
				} else {
					$report[$ticket_id]['response_sla'] =  $vis_language['TXTMAINTAIN'];
					$report[$ticket_id]['totlavgresposmaintain']++;
				}			
			}else{ 				
				if((isset($details['response_sla']) && $details['response_sla']==$vis_language['TXTOVERDUE'] && $details['response_sla']!='')) {
					if($details['operator']==1 || $details['as_client']==1) {       
                        $report[$ticket_id]['response_sla'] =  $details['response_sla'];
                    }  else {
                    	$report[$ticket_id]['response_sla'] =  $vis_language['TXTMAINTAIN'];
                    	$report[$ticket_id]['totlavgresposmaintain']++;
                    }
				} else {	
					if($details['operator']==1 || $details['as_client']==1) {       
						if($details['due_date'] > 0 && $details['count']>=1) {
							$report[$ticket_id]['response_sla'] =  $vis_language['TXTMAINTAIN'];
							$report[$ticket_id]['totlavgresposmaintain']++;
						}	else {
								if($details['count'] >=1){
								  $report[$ticket_id]['response_sla'] =   $vis_language['TXTNOTMAINTAIN']; 
								}else{
	                       		$report[$ticket_id]['response_sla'] =  $vis_language['TXTNOTRESPONDED'];									
								}
							}
                    } elseif($report[$ticket_id]['avg_response_time']=='0 S')  { 
  	                    	$report[$ticket_id]['response_sla'] =  $vis_language['TXTMAINTAIN'];      
  	                } else   {
                    $report[$ticket_id]['response_sla'] =  $vis_language['TXTNOTRESPONDED'];
                    }
				}
			}
				if($details['count']!=0)
						$responseCount+=1;
				if($report[$ticket_id]['totlavgresposmaintain'] > 0) {
							$totlavgresposmaintain++;
						}

				} else {
					$report[$ticket_id]['response_sla']=$report[$ticket_id]['avg_response_time']='NA';
				}
				}
				foreach (((isset($operation['vis_export']) && $operation['vis_export'] == 1)? $report:array_slice($report, $limit, $view_info['page_count'])) as $p) {
					$report_new[] = $p;
				}
				$array_summary=array();
	            $array_summary['TXTTOTALTICKETSREPLIED']=$totalincidentsreplied;
	            $array_summary['TXTTOTALAVGRESPONSESLAMAINTAIN']=(($totlavgresposmaintain==0)?0:round((($totlavgresposmaintain/count($report))*100), 2)).'%';
	            $array_summary['TXTTOTALAVGRESOLUTIONSLAMAINTAIN']=(($totlavgresolmaintain==0)?0:round((($totlavgresolmaintain/count($report))*100), 2)).'%';
				$total = count($report);
				$view_info['page']=$page;
				$report_count=($report_new!=-1 || !empty($report_new)) ? count($report_new) : 0;
				$view_info['page_count']=(count($report)==0)? 0 : ceil(count($report)/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				$replied_ticket_cnt = 0;
				foreach ($report as $i) {
					foreach ($i as $key => $val) {
						if ($key == 'sla_time'){
							$report_exp[$j]['SLA'] = count_remain_time($val);
						} 
						elseif ($key == 'timestamp'){							
							$report_exp[$j]['SLA']= ($i['count']!=0) ? count_remain_time($val/$i['count']) : $vis_language['TXTNOTRESPONDED'];
						} 
						elseif ($key == 'ticket_entry'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'due_time'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'resolve_time'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'ticket_hash' || $key == 'subject' || $key == 'department_name' || $key == 'ticket_priority' || $key == 'status_name' ||  $key == 'type' ||  $key == 'impact' ||  $key == 'urgency' ||  $key == 'flag'  ||  $key == 'ticket_category'  ||  $key == 'ticket_sub_cateogy' || $key == 'ticket_level' || $key == 'sla_name' || $key == 'first_name' || $key == 'last_name' || $key == 'email' || $key == 'group_name'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'avg_resolution_time'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'pause_rtime'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'response_sla'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'resolution_sla'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'avg_response_time'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'tot_post_and_reply_time'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'totalmaintcont'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'pause_rtime'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'status_id'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'new_info'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'closed_time'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'tcount'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'avg_tot_replied_time'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'operator'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'as_client'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'due_date'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'client_id'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'count'){
							$report_exp[$j][$key] = $val;
						}
					}
					$sla_name = ($report_exp[$j]['sla_name']!= '')?$report_exp[$j]['sla_name']:$vis_language['TXTCUSTDUETIME'];
					if($filter1==0)	{
        				$report_exp1[$j]['incident_or_Service_hash'] = $report_exp[$j]['ticket_hash'];
        			}
        			elseif($filter1==2)	{
        				$report_exp1[$j]['Service_request_hash'] = $report_exp[$j]['ticket_hash'];
        			}
        			else {
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash'];
        			}
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['creation_date'] = $report_exp[$j]['ticket_entry'];
					$report_exp1[$j]['department'] = $report_exp[$j]['department_name'];
					$report_exp1[$j]['client_email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					$report_exp1[$j]['sla_plan'] = $sla_name;
					$report_exp1[$j]['priority'] = $report_exp[$j]['ticket_priority'];
					$report_exp1[$j]['status'] = $report_exp[$j]['status_name'];
					$report_exp1[$j]['type'] = $report_exp[$j]['type'];
					$report_exp1[$j]['urgency'] = $report_exp[$j]['urgency'];
					$report_exp1[$j]['flag'] = $report_exp[$j]['flag'];
					$report_exp1[$j]['impact'] = $report_exp[$j]['impact'];
					$report_exp1[$j]['category'] = $report_exp[$j]['ticket_category'];
					$report_exp1[$j]['sub_category'] = $report_exp[$j]['ticket_sub_cateogy'];
					$report_exp1[$j]['level'] = $report_exp[$j]['ticket_level'];

					$report_exp1[$j]['avg_response_time'] = ($report_exp[$j]['pause_rtime']!='') ? 'NA': $report_exp[$j]['avg_response_time'];
				
					$resolution_time = (isset($report_exp[$j]['tot_post_and_reply_time']) && $report_exp[$j]['tot_post_and_reply_time'] !=0 )?count_remain_time(round($report_exp[$j]['tot_post_and_reply_time'])): $vis_language['TXTNOTRESPONDED'];
 
					$resolution_flag = ($report_exp[$j]['pause_rtime']!='') ? $report_exp[$j]['pause_rtime'] : '';
					if($report_exp[$j]['pause_rtime']!=''){
						$report_exp1[$j]['avg_resolution_time'] = "NA";						
					}elseif(isset($report_exp[$j]['status_id']) &&($report_exp[$j]['status_id']==4 || $report_exp[$j]['status_id']==3)){
						$report_exp1[$j]['avg_resolution_time'] = (isset($report_exp[$j]['avg_resolution_time']) && $report_exp[$j]['avg_resolution_time'] !='' )? $report_exp[$j]['avg_resolution_time'] :"Not resolved"; 
						}else{ 
						 $report_exp1[$j]['avg_resolution_time'] = (isset($report_exp[$j]['resolution_sla']) && $report_exp[$j]['resolution_sla'] !='' ) ? $report_exp[$j]['resolution_sla']: $vis_language['TXTNOTMAINTAIN'];
						}
					$report_exp1[$j]['avg_resolution_time'] = $report_exp1[$j]['avg_resolution_time'];
					$report_exp1[$j]['response_sla'] = (isset($report_exp[$j]['response_sla']) && $report_exp[$j]['response_sla'] !='' ) ? $report_exp[$j]['response_sla']: $vis_language['MSGNOTRESOLVED'];//$report_exp[$j]['response_sla'];
					$report_exp1[$j]['resolution_sla'] = (isset($report_exp[$j]['pause_rtime']) && $report_exp[$j]['pause_rtime']!='')? 'NA':((isset($report_exp[$j]['resolution_sla']) && $report_exp[$j]['resolution_sla'] !='' ) ? (($report_exp[$j]['resolution_sla']==$vis_language['TXTOVERDUE'])? $vis_language['TXTNOTMAINTAIN']:$report_exp[$j]['resolution_sla']): $vis_language['MSGNOTRESOLVED']);

					 $cal_timestamp = (isset($report_exp[$j]['timestamp']) && $report_exp[$j]['timestamp'] != '' && $report_exp[$j]['count'] != '0')? round(($report_exp[$j]['timestamp']/$report_exp[$j]['count']),2):''; 

					$report[$ticket_id]['avg_response_time']=($report_exp[$j]['count']!=0) ? count_remain_time($cal_timestamp) : ((isset($report_exp[$j]['operation_id']) && $report_exp[$j]['operation_id']==0 && $report_exp[$j]['operator']==2) ? '0S': $vis_language['TXTNOTRESPONDED']);
					if($report_exp[$j]['count']!=0)    {
		                    $report_exp1[$j]['avg_response_time'] = count_remain_time($cal_timestamp);
		                }   else  {               	
			                $report_exp1[$j]['avg_response_time'] = '0 S';	                	
		                }
	                if(isset($report_exp[$j]['pause_rtime']) && $report_exp[$j]['pause_rtime']!='')
						{
							$report_exp1[$j]['avg_response_time']= 'NA';
						}
					elseif(isset($report_exp[$j]['avg_response_time']) && $report_exp[$j]['avg_response_time'] !=0)
						{
							$report_exp1[$j]['avg_response_time']=  $report_exp[$j]['avg_response_time'];
						}
					elseif(isset($report_exp[$j]['avg_response_time']) && $report_exp[$j]['avg_response_time'] =='0 S' && $report_exp[$j]['operator']!=1 && $report_exp[$j]['as_client']!=1){ 
						$report_exp1[$j]['avg_response_time']=  '0 S';
					}else{ 
						$report_exp1[$j]['avg_response_time'] = $vis_language['TXTNOTRESPONDED'];
					}
					if(isset($report_exp[$j]['pause_rtime']) && $report_exp[$j]['pause_rtime']!='')
						{
							$report_exp1[$j]['response_sla']= 'NA';
						}
					elseif(isset($report_exp[$j]['avg_tot_replied_time']) && $report_exp[$j]['avg_tot_replied_time'] >0 ){
					    $replied_ticket_cnttt+=$report_exp[$j]['tcount'];
					    $rescounttt++;
					    if($report_exp[$j]['due_date'] < 0 && $report_exp[$j]['tcount']>=1){
					        if($report_exp[$j]['operator']==1 || $report_exp[$j]['as_client']==1){       
					            $report_exp1[$j]['response_sla'] = $vis_language['TXTNOTMAINTAIN'];
					        } else {
					            $report_exp1[$j]['response_sla'] = $vis_language['TXTNOTMAINTAIN'];
					            // $report_exp1[$j]['response_sla'] = $vis_language['TXTMAINTAIN'];
					        }
					    } else {
					        $report_exp1[$j]['response_sla'] =  $vis_language['TXTMAINTAIN'];
					    }           
					}else{ 
					    if((isset($report_exp[$j]['response_sla'] ) && $report_exp[$j]['response_sla']==$vis_language['TXTOVERDUE']  && $report_exp[$j]['response_sla']!='')){
					        if($report_exp[$j]['operator']==1 || $report_exp[$j]['as_client']==1){
					            $report_exp1[$j]['response_sla']=$report_exp[$j]['response_sla'];
					        }else{
					            $report_exp1[$j]['response_sla']=$vis_language['TXTMAINTAIN'];
					        } 
					    }else{
					        if($report_exp[$j]['operator']==1 || $report_exp[$j]['as_client']==1){					            
					            if($report_exp[$j]['due_date'] > 0 && $report_exp[$j]['count']>=1) {
										$report_exp1[$j]['response_sla']=$vis_language['TXTMAINTAIN'];
									} else {			                       		
			                       		//$report_exp1[$j]['response_sla']=$vis_language['TXTNOTRESPONDED'];
			                       		if($report_exp[$j]['count'] >=1){
			                       				$report_exp1[$j]['response_sla']=$vis_language['TXTNOTMAINTAIN'];
											}else{
                       							$report_exp1[$j]['response_sla']=$vis_language['TXTNOTRESPONDED'];					
											}
									}
					        } elseif($report_exp[$j]['avg_response_time']=='0 S') {	  	                 
	  	                    	$report_exp1[$j]['response_sla']=$vis_language['TXTMAINTAIN'];
                    } else{
					            $report_exp1[$j]['response_sla']=$vis_language['TXTNOTRESPONDED'];
					        }
					    }
					}

					if(isset($report_exp[$j]['pause_rtime']) && $report_exp[$j]['pause_rtime']!='')
						{
							$report_exp1[$j]['resolution_sla']= 'NA';
						}
					elseif((isset($report_exp[$j]['resolution_sla']) && $report_exp[$j]['resolution_sla']==$vis_language['TXTOVERDUE']) || !isset($report_exp[$j]['resolution_sla'])){
					    $report_exp1[$j]['resolution_sla']=$vis_language['TXTNOTMAINTAIN'];
					}else{
					     $report_exp1[$j]['resolution_sla']=(isset($report_exp[$j]['resolution_sla']) && $report_exp[$j]['resolution_sla']!='')?$report_exp[$j]['resolution_sla']:$vis_language['TXTNOTMAINTAIN'];
					}
					if($i['count']!=0){
						$replied_ticket_cnt+=1;
					} else {
						$replied_ticket_cnt+=0;
					}
					$j++;
				}

				if($report!=-1){
					foreach($array_summary as $key=>$val){ 
					$title=explode(' ',$key);
					$title[1]=isset($title[1])? ' '.$title[1]:'';
					 $report_exp1[$j][$vis_language[$title[0]].$title[1]]=$vis_language[$title[0]].$title[1].' : '.$val; 
					}
				}
 
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE.'report_page.php');
			} 
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function incident_priority_sla_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTINCPRIORITYSLA'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();

		$export = 1;
		$report_type=197;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$domain     = $tkt_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']);
		$paging_form_page=($page*$view_info['page_count']);
		$operation['set_clientblank'] = 0;
		$operation['vis_current_operation']='incident_priority_sla_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		list($ctinfo, $incident_priority) = $tkt_object->get_ticket_priorities_list(VIS_TABLE_PREFIX.'ticket_priority.is_enabled=1', '', $staff_id, VIS_LOCATION_AREA);
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (isset($data['duration'])&&!isset($data['field_type']))
				$data['field_type'] = 0;

				if(isset($data['field_type']))
				$data['field_type'] = is_array($data['field_type'])? implode(',', $data['field_type']):0;

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['field_type'] == 0  && $data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] == 0  && $data['field_type'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] == 0  && $data['field_type'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] != 0  && $data['field_type'] == 0 && $operation['set_clientblank']==0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTTICKETPRIORITY']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 &&  $data['domain_id'] != 0  &&  $data['field_type'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$service='';
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;}
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = '(operation_id<=2 or operation_id=50 or operation_id=51 or operation_id=13) and '.VIS_TABLE_PREFIX.'ticket.receive_date between '.$from.' AND '.$to.' and find_in_set('.VIS_TABLE_PREFIX.'ticket.priority_id, "'.$data['field_type'].'") and '.VIS_TABLE_PREFIX.'ticket.domain_id='.$data['domain_id'].$service;
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$filter .= ' and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX.'ticket.resolution_time!=0 and '.VIS_TABLE_PREFIX.'ticket.due_time!=0 ';
			$post_details    = $object->incident_category_sla_report($filter, '', $staff_id, VIS_LOCATION_AREA);
			$resolutionCount = $responseCount = $report_avg = $report_cnt = $replied = $total_time = $replied_ticket_cnt = $submitter = $entry_date = 0;$maintain_date_nw1 =0;$maintain_date_nw = 0;
			$report          = array();
			$new_info		 = '';
		   	
			if ($post_details != -1){
				for($i=0;$i<count($post_details);$i++){
					 //echo "<br> as_client".$post_details[$i]['as_client'];
					 // echo "<br> submitter".$submitter;
					if($old_ticket_id != $post_details[$i]['ticket_id']){
						$report[$post_details[$i]['ticket_id']]['post_date'] = 0;
						$maintain_date_nw1 = $maintain_date_nw=0;
						$report[$post_details[$i]['ticket_id']]['as_client'] = ''; 
						$report[$post_details[$i]['ticket_id']]['count']=0;
						$report[$post_details[$i]['ticket_id']]['tcount']=0;	
						$as_client_or_clientticket=0;
						$last_operation_id =0;
					} 
					$report[$post_details[$i]['ticket_id']]['as_client'] = '';
					if(isset($post_details[$i]['as_client']) && $post_details[$i]['as_client']!="")
					{
						$report[$post_details[$i]['ticket_id']]['as_client'] = $post_details[$i]['as_client'];
					}
					else
					{
						$report[$post_details[$i]['ticket_id']]['as_client'] = '';
					}

					 if($post_details[$i]['operation_id']==13)	{   
							if(!isset($report[$post_details[$i]['ticket_id']]['customsla'])){
								$report[$post_details[$i]['ticket_id']]['customsla']=1;	
							} 
							else{
								$report[$post_details[$i]['ticket_id']]['customsla']++;	
							}  
						 $report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date'];
					 }
					 
					if($post_details[$i]['operation_id']!=13)	{ 
					if($post_details[$i]['operation_id']==0 && $post_details[$i]['operator']==1){
					  	$report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date'];
						//$submitter = $post_details[$i]['operator'];
						 $last_operation_id = $post_details[$i]['operation_id'];
						$as_client_or_clientticket=1;
					} else if($post_details[$i]['operation_id']==1 &&  $post_details[$i]['operator']==1 && $submitter!=1 ){
						if($last_operation_id ==0 && $submitter==2&&$post_details[$i]['as_client']==1){
						 	$report[$post_details[$i]['ticket_id']]['post_date'] = $report[$post_details[$i]['ticket_id']]['post_date'];
						}else{
						  	$report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date'];	
						}

						$last_operation_id = $post_details[$i]['operation_id'];
						$maintain_date_nw1 = $maintain_date_nw; 
						$as_client_or_clientticket=1; 
					} else if($post_details[$i]['operation_id']==50){
						$report[$post_details[$i]['ticket_id']]['pause_date']=$post_details[$i]['entry_date'];
						$last_operation_id = $post_details[$i]['operation_id'];
					} else if($post_details[$i]['operation_id']==51){
						$report[$post_details[$i]['ticket_id']]['resume_date']=$post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['slapause_diff'] += $post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['pause_date'];
						$last_operation_id = $post_details[$i]['operation_id'];
					} else if($post_details[$i]['operation_id']==1 && $post_details[$i]['operator']!=1){
						$last_operation_id = $post_details[$i]['operation_id'];
						if($post_details[$i]['as_client'] == 1){
							$as_client_or_clientticket=1; 
						}
						/*if($submitter == $post_details[$i]['operator'] && $post_details[$i]['as_client']==0){
							if (!isset($report[$post_details[$i]['ticket_id']]['maintain_date']))
							$report[$post_details[$i]['ticket_id']]['maintain_date'] = 0;
							else
							$report[$post_details[$i]['ticket_id']]['maintain_date'] += 0;
						} else */{
							$report[$post_details[$i]['ticket_id']]['post_date']=(isset($report[$post_details[$i]['ticket_id']]['post_date']) && $report[$post_details[$i]['ticket_id']]['post_date']!='')?$report[$post_details[$i]['ticket_id']]['post_date']:0;  
						 	$maintain_date = $post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['post_date'];
							// echo "<br>2 post date  ".$report[$post_details[$i]['ticket_id']]['post_date']." entry dt ".$post_details[$i]['entry_date'];
							 $maintain_date_nw = $post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['post_date'];
							// echo "<br>old maintain_date_nw1 ".$maintain_date_nw1 ;
							$maintain_date_nw = $maintain_date_nw + $maintain_date_nw1;
							if($report[$post_details[$i]['ticket_id']]['ticket_id'] == $post_details[$i]['ticket_id']){
								//
								$report[$post_details[$i]['ticket_id']]['maintain_date'] += $maintain_date;
								$maintain_date_nw1 = $maintain_date_nw;
							} else {
								$report[$post_details[$i]['ticket_id']]['maintain_date'] = $maintain_date;
								$maintain_date_nw1 = 0;
							}
							$report[$post_details[$i]['ticket_id']]['count']=(isset($report[$post_details[$i]['ticket_id']]['count']) && $report[$post_details[$i]['ticket_id']]['count']!='')?$report[$post_details[$i]['ticket_id']]['count']:0;
							/*  $report[$post_details[$i]['ticket_id']]['count']++; */
						}
						//echo "<br> maintain_date ticket ".$report[$post_details[$i]['ticket_id']]['maintain_date'];
						 if(isset($report[$post_details[$i]['ticket_id']]['maintain_date']) && $report[$post_details[$i]['ticket_id']]['maintain_date'] > 0)
							{  
								$report[$post_details[$i]['ticket_id']]['count']++;
								$report[$post_details[$i]['ticket_id']]['tcount']++;
								$report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date'];
								if($as_client_or_clientticket==0){
									//echo "<br>++++++++".$as_client_or_clientticket;
									$report[$post_details[$i]['ticket_id']]['count']=$report[$post_details[$i]['ticket_id']]['count']-1;
									$report[$post_details[$i]['ticket_id']]['tcount']=$report[$post_details[$i]['ticket_id']]['tcount']-1;
								}
							} 
						  
						$new_info = ($post_details[$i]['new_info']!='' && is_string($post_details[$i]['new_info'])) ? $post_details[$i]['new_info'] : '';
						$entry_date = $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['auditlogentry_date'] = $entry_date;
						$operation_id = $post_details[$i]['operation_id'];
						$total_post++;
						$report_cnt++;
					}else{ 
						$report[$post_details[$i]['ticket_id']]['entry_dateee']  = $post_details[$i]['entry_date']; 
					}  // prev 
					$submitter = $post_details[$i]['operator'];
					if (!isset($report[$post_details[$i]['ticket_id']]['start_time'])) {
						$report[$post_details[$i]['ticket_id']]['ticket_hash']     = $post_details[$i]['ticket_hash'];
						$report[$post_details[$i]['ticket_id']]['subject']         = $post_details[$i]['subject'];
						$report[$post_details[$i]['ticket_id']]['ticket_entry']    = $post_details[$i]['receive_date'];
						$report[$post_details[$i]['ticket_id']]['start_time']      = $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['post_date']	   = $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['ticket_priority'] = $post_details[$i]['ticket_priority'];
						$report[$post_details[$i]['ticket_id']]['department_name'] = $post_details[$i]['department_name'];
						$report[$post_details[$i]['ticket_id']]['first_name'] 	   = $post_details[$i]['first_name'];
						$report[$post_details[$i]['ticket_id']]['last_name']	   = $post_details[$i]['last_name'];
						$report[$post_details[$i]['ticket_id']]['email']		   = $post_details[$i]['email'];
						$report[$post_details[$i]['ticket_id']]['group_name']	   = $post_details[$i]['group_name'];
						$report[$post_details[$i]['ticket_id']]['client_id']       = $post_details[$i]['client_id'];
						$report[$post_details[$i]['ticket_id']]['ticket_id']       = $post_details[$i]['ticket_id'];
						$report[$post_details[$i]['ticket_id']]['status_id']       = $post_details[$i]['status_id'];
						$report[$post_details[$i]['ticket_id']]['remain_resolve']  = $post_details[$i]['remain_resolve'];
						$report[$post_details[$i]['ticket_id']]['pause_rtime']	   = $post_details[$i]['pause_rtime'];
						$report[$post_details[$i]['ticket_id']]['resolve_time']    = $post_details[$i]['resolution_time'];
						$report[$post_details[$i]['ticket_id']]['status_name']     = $post_details[$i]['status_name'];
						$report[$post_details[$i]['ticket_id']]['urgency']     = $post_details[$i]['urgency'];
						$report[$post_details[$i]['ticket_id']]['impact']     = $post_details[$i]['impact'];
						$report[$post_details[$i]['ticket_id']]['flag']     = $post_details[$i]['flag'];
						$report[$post_details[$i]['ticket_id']]['type']     =  (isset($post_details[$i]['type']))? $post_details[$i]['type'] :'';
						$report[$post_details[$i]['ticket_id']]['ticket_category']     =  (isset($post_details[$i]['ticket_category']))? $post_details[$i]['ticket_category'] :'';
						$report[$post_details[$i]['ticket_id']]['ticket_sub_cateogy']     =  (isset($post_details[$i]['ticket_sub_cateogy']))? $post_details[$i]['ticket_sub_cateogy'] :'';
						$report[$post_details[$i]['ticket_id']]['ticket_level']     =  (isset($post_details[$i]['ticket_level']))? $post_details[$i]['ticket_level']:'';
						$report[$post_details[$i]['ticket_id']]['sla_name']        = $post_details[$i]['sla_name'];
						$report[$post_details[$i]['ticket_id']]['operator']		   = $post_details[$i]['operator'];
						$report[$post_details[$i]['ticket_id']]['operation_id']	   = $post_details[$i]['operation_id'];
						$report[$post_details[$i]['ticket_id']]['closed_time']	   = $post_details[$i]['closed_time'];
						$report[$post_details[$i]['ticket_id']]['as_client']	   = $post_details[$i]['as_client'];
						$report[$post_details[$i]['ticket_id']]['new_info']		   = $post_details[$i]['new_info'];
						$report[$post_details[$i]['ticket_id']]['applyslaresol_time'] = $post_details[$i]['applyslaresol_time'];
						if (!isset($report[$post_details[$i]['ticket_id']]['tcount']))
						$report[$post_details[$i]['ticket_id']]['tcount']          = 0;
						else
						$report[$post_details[$i]['ticket_id']]['tcount']          += 0;							
						$report[$post_details[$i]['ticket_id']]['lastrepliertime'] = $post_details[$i]['lastrepliertime'];
						$report[$post_details[$i]['ticket_id']]['solve_time']      = 0;
						$report[$post_details[$i]['ticket_id']]['slapause_diff']   = 0;
						$report[$post_details[$i]['ticket_id']]['maintain_date']   = 0;
						$report[$post_details[$i]['ticket_id']]['count']           = 0;
						$report[$post_details[$i]['ticket_id']]['used_sla_seconds']= 0;
						$report[$post_details[$i]['ticket_id']]['total_sla_seconds'] = 0;
						$report[$post_details[$i]['ticket_id']]['auditlogentry_date'] = 0;
						$total_post= 0;
						$report[$post_details[$i]['ticket_id']]['due_date']  =0;
					} elseif($post_details[$i]['old_info']!=''){
						$total_sla_seconds = ($post_details[$i]['due_time'] - $report[$post_details[$i]['ticket_id']]['start_time']);
						$report[$post_details[$i]['ticket_id']]['due_date']  = ($post_details[$i]['due_time'] - $post_details[$i]['lastrepliertime']); 
						$report[$post_details[$i]['ticket_id']]['as_client']	   = $post_details[$i]['as_client'];
						//$maintain_date_nw = !isset($report[$post_details[$i]['ticket_id']]['maintain_date_nw'])? 0:$report[$post_details[$i]['ticket_id']]['maintain_date_nw'];
						$report[$post_details[$i]['ticket_id']]['sla_response_time'] = round($maintain_date_nw);		
						 $report[$post_details[$i]['ticket_id']]['used_sla_seconds'] = $report[$post_details[$i]['ticket_id']]['sla_response_time'];
						 $report[$post_details[$i]['ticket_id']]['timestamp'] = $report[$post_details[$i]['ticket_id']]['sla_response_time'];
						$submitter = $post_details[$i]['operator'];
						$operation_id = $post_details[$i]['operation_id'];
						$new_info = ($post_details[$i]['new_info']!='' && is_string($post_details[$i]['new_info'])) ? $post_details[$i]['new_info'] : '';
						$entry_date = $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['auditlogentry_date'] = $entry_date;

						$report_cnt++;
					}
				} 
				$old_ticket_id=$post_details[$i]['ticket_id'];
				}
			} else {
				$report = -1;
			}
			$report_new = array();
			$responseCounte=0;
			
			$totrepltime=0;
			$avgtotrepltime=0;
			$avgtotrepltime=0; 
			$tcount=0;
			$totalincidentsreplied=$auditlogentry_date=0;
			$totlavgresposmaintain=$totlavgresolmaintain=0;
			if ($report != -1) {
				foreach ($report as $ticket_id => $details) {
					$isUndueSet = 0; 
					$report[$ticket_id]['totlavgresposmaintain']=0;
					if($details['tcount']>0 || ($details['tcount']>=0 && $details['count']>0)){
						if($details['lastrepliertime']>0 && $details['ticket_entry']>0){
							$totrepltime = $details['lastrepliertime'] - $details['ticket_entry']; }
							if(isset($totrepltime) && $totrepltime!=0){
								if ($details['tcount']!=0) {
								$avgtotrepltime = count_remain_time(round($totrepltime / $details['tcount']));
								$report[$ticket_id]['avg_tot_replied_time']=$avgtotrepltime;
								$report[$ticket_id]['tot_post_and_reply_time']=$totrepltime;
								}
								$tcount += $details['tcount']; 
								$totalincidentsreplied++;
							}
					}else{ 
						if(isset($details['status_id']) && $details['status_id']==3 && ( isset($details['closed_time']) && $details['closed_time']!='')){
						$totrepltime = $details['closed_time'] - $details['lastrepliertime'];
						$report[$ticket_id]['tot_post_and_reply_time']=$totrepltime;
						}
					} 

					if($details['pause_rtime'] == ''){
					if($details['closed_time']=='' && $details['status_id']==4 && is_string($new_info)){
						$calculate_resolve_time = $details['auditlogentry_date'] - $details['applyslaresol_time'];
					} else {
						$calculate_resolve_time = $details['resolve_time'] - (isset($details['closed_time']))? $details['closed_time'] :0;
					}
					if ($details['resolve_time'] < 0 && ($details['status_id'] == 3 || $details['status_id'] == 4)) {
						$isUndueSet                                = 0;
						$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTUNDUE'];
					} else if (($details['resolve_time'] < 0 || $details['remain_resolve'] < 0) && $details['status_id'] != 3  && $details['status_id']!=4) {
						$isUndueSet                                = 0;
						if($details['pause_rtime'] == ''){$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTNOTMAINTAIN'];}else{
						$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTOVERDUE'];}
					} else if (($details['resolve_time'] > 0 || $details['remain_resolve'] > 0) && $details['status_id']!=3  && $details['status_id']!=4) {
						$isUndueSet                                = 0;
						if($details['count']!= 0){
							$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTUNDUE'];
						} else {
							$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTNOTRESPONDED'];
						}
						if(isset($details['lastrepliertime']) && $details['lastrepliertime']>0){
						$report[$ticket_id]['lastrepliertime'] = $details['lastrepliertime'];
						}
					} else {
						$isUndueSet = 1;
						if($calculate_resolve_time > 0){
							if($details['count']!=0)
								$resolutionCount++;
						}
						if($details['closed_time']=='' && (isset($details['status_id']) && ($details['status_id']==4 || $details['status_id']==3))){				
						if($auditlogentry_date==0){ $auditlogentry_date = $details['entry_dateee']; }	
						if($auditlogentry_date>0){
							$report[$ticket_id]['avg_resolution_time'] = count_remain_time($auditlogentry_date - $details['applyslaresol_time']); }
						} else {
								if($report[$ticket_id]['customsla']>0)	{
								$report[$ticket_id]['avg_resolution_time'] = count_remain_time($details['closed_time'] - $details['applyslaresol_time']);
							}	else	{
								/* $report[$ticket_id]['avg_resolution_time'] = count_remain_time($details['closed_time'] - $details['ticket_entry']); */
								$report[$ticket_id]['avg_resolution_time'] = count_remain_time($details['closed_time'] - $details['ticket_entry']);
							}
						}
						if($details['tcount']>=1){
						$report[$ticket_id]['totalmaintcont']=1;
							$responseCount++;
						}
					}
					if($details['tcount']==0 && ($details['status_id']==3 || $details['status_id']==4)){
						$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTMAINTAIN'];
					} else if(($details['resolve_time'] < 0 || $details['remain_resolve'] < 0) && $details['status_id']!=3 && $details['status_id']!=4) {
						if($responseCount!=0) { $responseCount--; }else{ $responseCount++;}
						if($details['tcount'] > 1){  
							$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTMAINTAIN'];
						} else {
							$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTRESPONDED'];
						} 
					} else if($details['tcount']!= 0 && ($details['status_id']==3 || $details['status_id']==4)){
						if($details['resolve_time'] < 0 || $details['remain_resolve'] < 0){ 
							$responseCount--;
							$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTRESPONDED'];
						} else {
							$report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
							$report[$ticket_id]['totlavgresposmaintain']++;
						}
					} else if (($details['resolve_time'] > 0 || $details['remain_resolve'] > 0) && ($details['status_id']!=3 && $details['status_id']!=4)) {
						if($details['tcount'] > 1){  
							$report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
							$report[$ticket_id]['totlavgresposmaintain']++;
						} else {
							if ($details['operation_id']==0 && $details['operator']==2) {
							$report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
								if($details['used_sla_seconds'] > 0)	{
										$report[$ticket_id]['totlavgresposmaintain']++;
									}
							}	else{
							$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTRESPONDED'];
							}
						}
					}
					if($details['tcount']!=0 && ($details['status_id']==3 || $details['status_id']==4)){
							$report[$ticket_id]['response_sla_stat'] = $vis_language['TXTMAINTAIN'];
						}else{
							$report[$ticket_id]['response_sla_stat'] = $vis_language['TXTNOTRESPONDED'];
						}
					if($isUndueSet == 1 && $resolutionCount>0){ 
						if($details['status_id']!=3 && $details['status_id']!=4 ){
							
							if($details['count']!=0){
								 $report[$ticket_id]['resolution_sla']   = $vis_language['MSGNOTRESOLVED'] ;
							} else {
								$report[$ticket_id]['resolution_sla']   = $vis_language['MSGNOTRESOLVED'];
							}
						} else {
							if($details['resolve_time'] < 0){ /*|| $details['remain_resolve'] < 0){*/
								$report[$ticket_id]['resolution_sla'] = $vis_language['TXTNOTMAINTAIN'];
							} else { 
								if($details['resolve_time']<$details['closed_time']){
                                    $report[$ticket_id]['resolution_sla'] = $vis_language['TXTNOTMAINTAIN'];
                                }else{
                                $report[$ticket_id]['resolution_sla'] = $vis_language['TXTMAINTAIN'];
								$totlavgresolmaintain++;
	                            }
							}
						}
					} elseif($details['count']==0 && $details['status_id']!=3 && $details['status_id']!=4){ 
						if($details['remain_resolve'] > 0){	  $report[$ticket_id]['resolution_sla']   =$vis_language['MSGNOTRESOLVED'];
						}else{ $report[$ticket_id]['resolution_sla']   = $vis_language['TXTOVERDUE']; }
					} elseif($details['count']!=0 && $details['status_id']!=3 && $details['status_id']!=4 && $details['remain_resolve'] > 0){ 
						 $report[$ticket_id]['resolution_sla']   = $vis_language['MSGNOTRESOLVED'];
					} else if(($details['resolve_time'] < 0 || $details['remain_resolve'] < 0) &&   $details['status_id']!=3 && $details['status_id']!=4){
						$report[$ticket_id]['resolution_sla']   = $vis_language['TXTOVERDUE'];

					}else{
						if($details['count']==0 && $details['status_id']!=3 && $details['status_id']!=4){ 
							$report[$ticket_id]['resolution_sla']   = "NA";
						} else {  
							if($details['closed_time'] > $details['resolve_time'] && ($details['status_id']==3 || $details['status_id']==4)){
								$report[$ticket_id]['resolution_sla']   = $vis_language['TXTNOTMAINTAIN'];
							}else{
								$report[$ticket_id]['resolution_sla']   = $vis_language['TXTMAINTAIN'];
								$totlavgresolmaintain++;
							}
						}
					}
					$cal_timestamp = (isset($details['timestamp'])&&$details['timestamp'] != '' && $details['count'] != '0')? round(($details['timestamp']/$details['count']),2):''; 
					if($details['count']!=0){
						$replied_ticket_cnt+=1;
					} else {
						$replied_ticket_cnt+=0;
					}
					$report[$ticket_id]['avg_response_time']=($details['count']!=0) ? count_remain_time($cal_timestamp) : (($details['operation_id']==0 && $details['operator']==2) ? '0S': $vis_language['TXTNOTRESPONDED']);
					if($details['count']!=0)
		                {
		                    $report[$ticket_id]['avg_response_time'] = count_remain_time($cal_timestamp);
		                }
	                else
		                {               	
			                $report[$ticket_id]['avg_response_time'] = '0 S';	                	
		                }
	            if(isset($report[$ticket_id]['avg_tot_replied_time']) && $report[$ticket_id]['avg_tot_replied_time'] >0 ){			
				if($details['due_date'] < 0 && $details['tcount']>=1){ 
					if($details['operator']==1 || $details['as_client']==1) {       
                        $report[$ticket_id]['response_sla'] =   $vis_language['TXTNOTMAINTAIN']; 
                    } elseif ($details['lastrepliertime'] > $details['resolve_time']) {
                    	$report[$ticket_id]['response_sla'] =   $vis_language['TXTNOTMAINTAIN'];
                    } else{
                    $report[$ticket_id]['response_sla'] =  $vis_language['TXTMAINTAIN'];
                    $report[$ticket_id]['totlavgresposmaintain']++;
                    }
				} else {
					$report[$ticket_id]['response_sla'] =  $vis_language['TXTMAINTAIN'];
					$report[$ticket_id]['totlavgresposmaintain']++;
				}			
			}else{ 				
				if((isset($details['response_sla']) && $details['response_sla']==$vis_language['TXTOVERDUE'] && $details['response_sla']!='')) {
					if($details['operator']==1 || $details['as_client']==1) {       
                        $report[$ticket_id]['response_sla'] =  $details['response_sla'];
                    }  else {
                    	$report[$ticket_id]['response_sla'] =  $vis_language['TXTMAINTAIN'];
                    	$report[$ticket_id]['totlavgresposmaintain']++;
                    }
				} else {	
					if($details['operator']==1 || $details['as_client']==1) {       
						if($details['due_date'] > 0 && $details['count']>=1) {
							$report[$ticket_id]['response_sla'] =  $vis_language['TXTMAINTAIN'];
							$report[$ticket_id]['totlavgresposmaintain']++;
						}	else {
								if($details['count'] >=1){
								  $report[$ticket_id]['response_sla'] =   $vis_language['TXTNOTMAINTAIN']; 
								}else{
	                       		$report[$ticket_id]['response_sla'] =  $vis_language['TXTNOTRESPONDED'];									
								}
							}
                    } elseif($report[$ticket_id]['avg_response_time']=='0 S')  { 
  	                    	$report[$ticket_id]['response_sla'] =  $vis_language['TXTMAINTAIN'];      
  	                } else   {
                    $report[$ticket_id]['response_sla'] =  $vis_language['TXTNOTRESPONDED'];
                    }
				}
			}
				if($details['count']!=0)
						$responseCount+=1;
				if($report[$ticket_id]['totlavgresposmaintain'] > 0) {
							$totlavgresposmaintain++;
						}

				}
				}
				foreach (((isset($operation['vis_export']) && $operation['vis_export'] == 1)? $report:array_slice($report, $limit, $view_info['page_count'])) as $p) {
					$report_new[] = $p;
				}
				$array_summary=array();
	            $array_summary['TXTTOTALTICKETSREPLIED']=$totalincidentsreplied;
	            $array_summary['TXTTOTALAVGRESPONSESLAMAINTAIN']=(($totlavgresposmaintain==0)?0:round((($totlavgresposmaintain/count($report))*100), 2)).'%';
	            $array_summary['TXTTOTALAVGRESOLUTIONSLAMAINTAIN']=(($totlavgresolmaintain==0)?0:round((($totlavgresolmaintain/count($report))*100), 2)).'%';
				$total = count($report);
				$view_info['page']=$page;
				$report_count=($report_new!=-1 || !empty($report_new)) ? count($report_new) : 0;
				$view_info['page_count']=(count($report)==0)? 0 : ceil(count($report)/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				$replied_ticket_cnt = 0;
				foreach ($report as $i) {
					foreach ($i as $key => $val) {
						if ($key == 'sla_time'){
							$report_exp[$j]['SLA'] = count_remain_time($val);
						} elseif ($key == 'ticket_entry'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'due_time'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'resolve_time'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'ticket_hash' || $key == 'subject' || $key == 'department_name' || $key == 'ticket_priority' || $key == 'status_name' ||  $key == 'type' ||  $key == 'impact' ||  $key == 'urgency' ||  $key == 'flag'  ||  $key == 'ticket_category'  ||  $key == 'ticket_sub_cateogy' || $key == 'ticket_level' || $key == 'sla_name' || $key == 'first_name' || $key == 'last_name' || $key == 'email' || $key == 'group_name'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'avg_resolution_time'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'pause_rtime'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'response_sla'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'resolution_sla'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'avg_response_time'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'timestamp'){							
							$report_exp[$j]['SLA']= ($i['count']!=0) ? count_remain_time($val/$i['count']) : $vis_language['TXTNOTRESPONDED'];
						} elseif ($key == 'tot_post_and_reply_time'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'totalmaintcont'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'status_id'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'new_info'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'closed_time'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'tcount'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'avg_tot_replied_time'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'operator'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'as_client'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'due_date'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'client_id'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'count'){
							$report_exp[$j][$key] = $val;
						}

					}
					$sla_name = ($report_exp[$j]['sla_name']!= '')?$report_exp[$j]['sla_name']:$vis_language['TXTCUSTDUETIME'];
					if($filter1==0)	{
        				$report_exp1[$j]['incident_or_Service_hash'] = $report_exp[$j]['ticket_hash'];
        			}
        			elseif($filter1==2)	{
        				$report_exp1[$j]['Service_request_hash'] = $report_exp[$j]['ticket_hash'];
        			}
        			else {
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash'];
        			}
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['creation_date'] = $report_exp[$j]['ticket_entry'];
					$report_exp1[$j]['department'] = $report_exp[$j]['department_name'];
					$report_exp1[$j]['client_email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					$report_exp1[$j]['sla_plan'] = $sla_name;
					$report_exp1[$j]['priority'] = $report_exp[$j]['ticket_priority'];
					$report_exp1[$j]['status'] = $report_exp[$j]['status_name'];
					$report_exp1[$j]['type'] = $report_exp[$j]['type'];
					$report_exp1[$j]['urgency'] = $report_exp[$j]['urgency'];
					$report_exp1[$j]['flag'] = $report_exp[$j]['flag'];
					$report_exp1[$j]['impact'] = $report_exp[$j]['impact'];
					$report_exp1[$j]['category'] = $report_exp[$j]['ticket_category'];
					$report_exp1[$j]['sub_category'] = $report_exp[$j]['ticket_sub_cateogy'];
					$report_exp1[$j]['level'] = $report_exp[$j]['ticket_level'];

					$report_exp1[$j]['avg_response_time'] = ($report_exp[$j]['pause_rtime']!='') ? $vis_language['MSGNOTRESOLVED'] : $report_exp[$j]['avg_response_time'];
					$resolution_time = (isset($report_exp[$j]['tot_post_and_reply_time']) && $report_exp[$j]['tot_post_and_reply_time'] !=0 )?count_remain_time(round($report_exp[$j]['tot_post_and_reply_time'])): $vis_language['TXTNOTRESPONDED'];
		            $cal_timestamp = ($report_exp[$j]['timestamp'] != '' && $report_exp[$j]['count'] != '0')? round(($report_exp[$j]['timestamp']/$report_exp[$j]['count']),2):''; 

					$report[$ticket_id]['avg_response_time']=($report_exp[$j]['count']!=0) ? count_remain_time($cal_timestamp) : (($report_exp[$j]['operation_id']==0 && $report_exp[$j]['operator']==2) ? '0S': $vis_language['TXTNOTRESPONDED']);
					if($report_exp[$j]['count']!=0)    {
		                    $report_exp1[$j]['avg_response_time'] = count_remain_time($cal_timestamp);
		                }   else  {               	
			                $report_exp1[$j]['avg_response_time'] = '0 S';	                	
		                }
	                if(isset($report_exp[$j]['pause_rtime']) && $report_exp[$j]['pause_rtime']!=''){
					    $report_exp1[$j]['avg_response_time']='NA';
					}elseif(isset($report_exp[$j]['avg_response_time']) && $report_exp[$j]['avg_response_time'] !=0)
						{
							$report_exp1[$j]['avg_response_time']=  $report_exp[$j]['avg_response_time'];
						}
					elseif(isset($report_exp[$j]['avg_response_time']) && $report_exp[$j]['avg_response_time'] =='0 S' && $report_exp[$j]['operator']!=1 && $report_exp[$j]['as_client']!=1){ 
						$report_exp1[$j]['avg_response_time']=  '0 S';
					}else{ 
						$report_exp1[$j]['avg_response_time'] = $vis_language['TXTNOTRESPONDED'];
					}
                	$resolution_flag = ($report_exp[$j]['pause_rtime']!='') ? $report_exp[$j]['pause_rtime'] : '';
					if(isset($report_exp[$j]['pause_rtime']) && $report_exp[$j]['pause_rtime']!=''){
					    $report_exp1[$j]['avg_resolution_time']='NA';
					}elseif(isset($report_exp[$j]['status_id']) &&($report_exp[$j]['status_id']==4 || $report_exp[$j]['status_id']==3)){
						$report_exp1[$j]['avg_resolution_time'] = (isset($report_exp[$j]['avg_resolution_time']) && $report_exp[$j]['avg_resolution_time'] !='' )? $report_exp[$j]['avg_resolution_time'] :"Not resolved"; //$resolution_time;
						}else{ 
						 $report_exp1[$j]['avg_resolution_time'] = (isset($report_exp[$j]['resolution_sla']) && $report_exp[$j]['resolution_sla'] !='' ) ? $report_exp[$j]['resolution_sla']: $vis_language['TXTNOTMAINTAIN'];
						}

					if(isset($report_exp[$j]['pause_rtime']) && $report_exp[$j]['pause_rtime']!=''){
					    $report_exp1[$j]['response_sla']='NA';
					}elseif(isset($report_exp[$j]['avg_tot_replied_time']) && $report_exp[$j]['avg_tot_replied_time'] >0 ){
					    $replied_ticket_cnttt+=$report_exp[$j]['tcount'];
					    $rescounttt++;
					    if($report_exp[$j]['due_date'] < 0 && $report_exp[$j]['tcount']>=1){
					        if($report_exp[$j]['operator']==1 || $report_exp[$j]['as_client']==1){       
					            $report_exp1[$j]['response_sla'] = $vis_language['TXTNOTMAINTAIN'];
					        } else {
					            $report_exp1[$j]['response_sla'] = $vis_language['TXTNOTMAINTAIN'];
					            // $report_exp1[$j]['response_sla'] = $vis_language['TXTMAINTAIN'];
					        }
					    } else {
					        $report_exp1[$j]['response_sla'] =  $vis_language['TXTMAINTAIN'];
					    }           
					}else{ 
					    if((isset($report_exp[$j]['response_sla'] ) && $report_exp[$j]['response_sla']==$vis_language['TXTOVERDUE']  && $report_exp[$j]['response_sla']!='')){
					        if($report_exp[$j]['operator']==1 || $report_exp[$j]['as_client']==1){
					            $report_exp1[$j]['response_sla']=$report_exp[$j]['response_sla'];
					        }else{
					            $report_exp1[$j]['response_sla']=$vis_language['TXTMAINTAIN'];
					        } 
					    }else{
					        if($report_exp[$j]['operator']==1 || $report_exp[$j]['as_client']==1){					            
					            if($report_exp[$j]['due_date'] > 0 && $report_exp[$j]['count']>=1) {
										$report_exp1[$j]['response_sla']=$vis_language['TXTMAINTAIN'];
									} else {		
			                       		if($report_exp[$j]['count'] >=1){
			                       				$report_exp1[$j]['response_sla']=$vis_language['TXTNOTMAINTAIN'];
											}else{
                       							$report_exp1[$j]['response_sla']=$vis_language['TXTNOTRESPONDED'];					
											}
									}
					        } elseif($report_exp[$j]['avg_response_time']=='0 S') {	  	                 
	  	                    	$report_exp1[$j]['response_sla']=$vis_language['TXTMAINTAIN'];
                    } else{
					            $report_exp1[$j]['response_sla']=$vis_language['TXTNOTRESPONDED'];
					        }
					    }
					}

					if(isset($report_exp[$j]['pause_rtime']) && $report_exp[$j]['pause_rtime']!=''){
					    $report_exp1[$j]['resolution_sla']='NA';
					}elseif((isset($report_exp[$j]['resolution_sla']) && $report_exp[$j]['resolution_sla']==$vis_language['TXTOVERDUE']) || !isset($report_exp[$j]['resolution_sla'])){
					    $report_exp1[$j]['resolution_sla']=$vis_language['TXTNOTMAINTAIN'];
					}else{
					     $report_exp1[$j]['resolution_sla']=(isset($report_exp[$j]['resolution_sla']) && $report_exp[$j]['resolution_sla']!='')?$report_exp[$j]['resolution_sla']:$vis_language['TXTNOTMAINTAIN'];
					}

					if($i['count']!=0)	{
						$replied_ticket_cnt+=1;
					} 	else 	{
						$replied_ticket_cnt+=0;
					}
					$j++;
				}

				if($report!=-1){
					foreach($array_summary as $key=>$val){ 
					$title=explode(' ',$key);
					$title[1]=isset($title[1])? ' '.$title[1]:'';
					 $report_exp1[$j][$vis_language[$title[0]].$title[1]]=$vis_language[$title[0]].$title[1].' : '.$val; 
					}
				}
 
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE.'report_page.php');
			} 
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function sla_plan_based_report($operation)
	{	
		global $vis_language;
		$report_title = $vis_language['TXTSLAPLANBASEREPORT'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type= 199;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
		$object_staff = new class_staff($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$domain     = $tkt_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',$staff_id,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];

		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page'])) ? $operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='sla_plan_based_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		$sla_plan=$tkt_object->get_sla_plan($staff_id, VIS_LOCATION_AREA);

		$staff_details= $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA, '', '', ' and staff_id='.$staff_id);
		$dept_access = $staff_details[0]['department_access'];
		$dept_access_filter = ($dept_access!=0) ? ' and department_access IN ('.$dept_access.')' : '';
		$staff_details= $tkt_object->get_staff_list('', VIS_LOCATION_AREA, '', '', $dept_access_filter);
		$csr_staff_dropdwon= $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA);
	 
		$dept_ids    = '';
		for ($d = 0; $d < count($staff_details); $d++) {
			$dept_ids .= $staff_details[$d]['staff_id'] . ',';
		}
		if ($dept_ids != '') {
			$dept_ids = substr($dept_ids, 0, -1); 
		}
		$dept_id  = ($staff_details[0]['staff_id'] == '' || $staff_details[0]['staff_id'] == 0) ? $dept_ids : $staff_details[0]['staff_id'];

		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (isset($data['duration'])&&!isset($data['field_type']))
				$data['field_type'] = -1;
				if(isset($data['field_type'])||isset($data['duration']))
				$data['field_type'] = is_array($data['field_type'])? implode(',', $data['field_type']):-1;

				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['field_type'] == -1  && $data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] == 0  && $data['field_type'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] == 0  && $data['field_type'] != -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] != 0  && $data['field_type'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTSLAPLAN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 &&  $data['domain_id'] != 0  &&  $data['field_type'] != -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}				
				$dept_access = ($dept_access!=0 && $dept_access!=-2) ? ' and t.department_id IN ('.$dept_access.')' : '';
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}

				$service='';
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;}
				$filter = VIS_TABLE_PREFIX.'ticket.receive_date between '.$from.' AND '.$to.' and find_in_set('.VIS_TABLE_PREFIX.'ticket.slaplan_id, "'.$data['field_type'].'") and '.VIS_TABLE_PREFIX.'ticket.domain_id='.$data['domain_id'].' and '.VIS_TABLE_PREFIX.'ticket.is_spam=0 and '.VIS_TABLE_PREFIX.'ticket.is_deleted=0 and '.VIS_TABLE_PREFIX.'ticket.draft_id=0 '.$service;
				// $filter .= $dept_access;
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object      = new class_report($database);
			$filter = $filter.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';
			list($total_rec, $report) = $object->sla_plan_based_report($filter, $limit, $staff_id, VIS_LOCATION_AREA);
			$array_summary = array();
			$view_info['page']=$page;
			$view_info['view_count']= $total = ($total_rec==-1)? 0:count($total_rec);
			$report_count=($report!=-1)? count($report) : 0;
			$view_info['page_count']=($total_rec==-1)?0:ceil($total/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export         = new export();
				$j=0;
				$fldname="";
				$fldname_val="";				
				if ($report != -1) {
				foreach ($report as $i){
					foreach ($i as $key => $val){
						if($key == 'ticket_hash'||$key == 'subject'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'receive_date'||$key == 'entry_date'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'department_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'group_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'email' || $key == 'ticket_priority' || $key == 'status_name' ||  $key == 'type' ||  $key == 'impact' ||  $key == 'urgency' ||  $key == 'flag'  ||  $key == 'ticket_category'  ||  $key == 'ticket_sub_cateogy' || $key == 'ticket_level' || $key == 'sla_name' || $key == 'email' ){
							$report_exp[$j][$key] = $val;
						} 						
					}
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['client_email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['creation_date'] = format_datetime_rpt($report_exp[$j]['receive_date'],$staff_id);
					$report_exp1[$j]['department'] = $report_exp[$j]['department_name'];
					$report_exp1[$j]['organization'] = ($report_exp[$j]['group_name']==NULL)? 'Default':$report_exp[$j]['group_name'];
					$report_exp1[$j]['priority'] = $report_exp[$j]['ticket_priority'];
					$report_exp1[$j]['status'] = $report_exp[$j]['status_name'];
					$report_exp1[$j]['type'] = $report_exp[$j]['type'];
					$report_exp1[$j]['urgency'] = $report_exp[$j]['urgency'];
					$report_exp1[$j]['flag'] = $report_exp[$j]['flag'];
					$report_exp1[$j]['impact'] = $report_exp[$j]['impact'];
					$report_exp1[$j]['category'] = $report_exp[$j]['ticket_category'];
					$report_exp1[$j]['sub_category'] = $report_exp[$j]['ticket_sub_cateogy'];
					$report_exp1[$j]['level'] = $report_exp[$j]['ticket_level'];
					$report_exp1[$j]['sla_plan'] = ($report_exp[$j]['sla_name']!= '') ? $report_exp[$j]['sla_name'] : $vis_language['TXTCUSTDUETIME'];
					$report_exp1[$j]['applied_sla_date'] = ($report_exp[$j]['entry_date']==NULL)? format_datetime_rpt($report_exp[$j]['receive_date'],$staff_id):format_datetime_rpt($report_exp[$j]['entry_date'],$staff_id);
					$j++;
				}
				}//if
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function organization_sla_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTORGANIZATIONSLA'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();

		$export = 1;
		$report_type=195;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
		$setting_object = new class_setting($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
		$client_object = new class_client($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'client.php');
		$object_client = new client();
		if(isset($operation['vis_export']) && $operation['vis_export'] == 1){
			$staff_id =  $operation['staff_id'];
		} else {
			$staff_id = VIS_STAFF_ID;
			$domain_list   = $object_client->get_domain_access_list();
			$clientGroup   = $client_object->get_client_group1(' (domain_id in (' . $domain_list . ') or domain_id=0 ) and is_enable=1', $staff_id, VIS_LOCATION_AREA);
		}
		$domain     = $tkt_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']);
		$paging_form_page=($page*$view_info['page_count']);
		$operation['set_clientblank'] = 0;
		$operation['vis_current_operation']='organization_sla_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit']!=''){
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
			 	$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
				
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '"); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['domain_id'] == "" && $data['group_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']).'");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']).'");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				
				if ($data['domain_id'] == "") {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']).'" );$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				
				if ($data['group_id'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message",  "'.$vis_language['MSQREQ']." ".strtolower($vis_language['TXTORGANIZATION']).'");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}

				if ($data['service_id'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message",  "'.$vis_language['MSQREQ']." ".strtolower('Service').'");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				
				if ($data['domain_id'] == 0) {
					$domainId = " ";
				} else
					$domainId = (VIS_SATELLITE_HELPDESK == 2 || VIS_SATELLITE_HELPDESK == 3) ? ' AND ' .VIS_TABLE_PREFIX.'client.optionB_domain_id = ' . $data['domain_id'] : ' AND ' .VIS_TABLE_PREFIX.'client.domain_id = ' . $data['domain_id'];

				$currentdate = date('Y-m-d H:i:s');
				$service='';
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;}
				if(isset($data['group_id']) && $data['group_id']!=0){
					$group_id = VIS_TABLE_PREFIX.'client.group_id = '.$data['group_id'].' and ';
				} else {
					$group_id = '';
				}
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = '(operation_id<=2 or operation_id=50 or operation_id=51 or operation_id=13) and '.VIS_TABLE_PREFIX.'ticket.receive_date between '.$from.' AND '.$to.' and '.$group_id.VIS_TABLE_PREFIX.'ticket.domain_id='.$data['domain_id'].$service;
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$filter .= ' and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX.'ticket.resolution_time!=0 and '.VIS_TABLE_PREFIX.'ticket.due_time!=0 ';
			$post_details    = $object->organization_sla_report($filter, '', $staff_id, VIS_LOCATION_AREA);
			$resolutionCount = $responseCount = $report_avg = $report_cnt = $replied = $total_time = $replied_ticket_cnt = $submitter = $entry_date = 0;$maintain_date_nw1 =0;$maintain_date_nw = $as_client_or_clientticket=$old_ticket_id=$last_operation_id =0;
			$report          = array();
			$new_info		 = '';
		  
			if ($post_details != -1){
				for($i=0;$i<count($post_details);$i++){
					 //echo "<br> as_client".$post_details[$i]['as_client'];
					 // echo "<br> submitter".$submitter;
					if($old_ticket_id != $post_details[$i]['ticket_id']){
						$report[$post_details[$i]['ticket_id']]['post_date'] = 0;
						$maintain_date_nw1 = $maintain_date_nw=0;
						$report[$post_details[$i]['ticket_id']]['as_client'] = ''; 
						$report[$post_details[$i]['ticket_id']]['count']=0;
						$report[$post_details[$i]['ticket_id']]['tcount']=0;	
						$as_client_or_clientticket=0;
						$last_operation_id =0;
					} 
					$report[$post_details[$i]['ticket_id']]['as_client'] = '';
					if(isset($post_details[$i]['as_client']) && $post_details[$i]['as_client']!="")
					{
						$report[$post_details[$i]['ticket_id']]['as_client'] = $post_details[$i]['as_client'];
					}
					else
					{
						$report[$post_details[$i]['ticket_id']]['as_client'] = '';
					}

					 if($post_details[$i]['operation_id']==13)	{   
							if(!isset($report[$post_details[$i]['ticket_id']]['customsla'])){
								$report[$post_details[$i]['ticket_id']]['customsla']=1;	
							} 
							else{
								$report[$post_details[$i]['ticket_id']]['customsla']++;	
							}  
						 $report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date'];
					 }
					 
					if($post_details[$i]['operation_id']!=13)	{ 
					if($post_details[$i]['operation_id']==0 && $post_details[$i]['operator']==1){
					  	$report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date'];
						//$submitter = $post_details[$i]['operator'];
						 $last_operation_id = $post_details[$i]['operation_id'];
						$as_client_or_clientticket=1;
					} else if($post_details[$i]['operation_id']==1 &&  $post_details[$i]['operator']==1 && $submitter!=1 ){
						if($last_operation_id ==0 && $submitter==2&&$post_details[$i]['as_client']==1){
						 	$report[$post_details[$i]['ticket_id']]['post_date'] = $report[$post_details[$i]['ticket_id']]['post_date'];
						}else{
						  	$report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date'];	
						}

						$last_operation_id = $post_details[$i]['operation_id'];
						$maintain_date_nw1 = $maintain_date_nw; 
						$as_client_or_clientticket=1; 
					} else if($post_details[$i]['operation_id']==50){
						$report[$post_details[$i]['ticket_id']]['pause_date']=$post_details[$i]['entry_date'];
						$last_operation_id = $post_details[$i]['operation_id'];
					} else if($post_details[$i]['operation_id']==51){
						$report[$post_details[$i]['ticket_id']]['resume_date']=$post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['slapause_diff'] += $post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['pause_date'];
						$last_operation_id = $post_details[$i]['operation_id'];
					} else if($post_details[$i]['operation_id']==1 && $post_details[$i]['operator']!=1){
						$last_operation_id = $post_details[$i]['operation_id'];
						if($post_details[$i]['as_client'] == 1){
							$as_client_or_clientticket=1; 
						}
						/*if($submitter == $post_details[$i]['operator'] && $post_details[$i]['as_client']==0){
							if (!isset($report[$post_details[$i]['ticket_id']]['maintain_date']))
							$report[$post_details[$i]['ticket_id']]['maintain_date'] = 0;
							else
							$report[$post_details[$i]['ticket_id']]['maintain_date'] += 0;
						} else */{
							$report[$post_details[$i]['ticket_id']]['post_date']=(isset($report[$post_details[$i]['ticket_id']]['post_date']) && $report[$post_details[$i]['ticket_id']]['post_date']!='')?$report[$post_details[$i]['ticket_id']]['post_date']:0;  
						 	$maintain_date = $post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['post_date'];
							// echo "<br>2 post date  ".$report[$post_details[$i]['ticket_id']]['post_date']." entry dt ".$post_details[$i]['entry_date'];
							 $maintain_date_nw = $post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['post_date'];
							// echo "<br>old maintain_date_nw1 ".$maintain_date_nw1 ;
							$maintain_date_nw = $maintain_date_nw + $maintain_date_nw1;
							if($report[$post_details[$i]['ticket_id']]['ticket_id'] == $post_details[$i]['ticket_id']){
								//
								$report[$post_details[$i]['ticket_id']]['maintain_date'] += $maintain_date;
								$maintain_date_nw1 = $maintain_date_nw;
							} else {
								$report[$post_details[$i]['ticket_id']]['maintain_date'] = $maintain_date;
								$maintain_date_nw1 = 0;
							}
							$report[$post_details[$i]['ticket_id']]['count']=(isset($report[$post_details[$i]['ticket_id']]['count']) && $report[$post_details[$i]['ticket_id']]['count']!='')?$report[$post_details[$i]['ticket_id']]['count']:0;
							/*  $report[$post_details[$i]['ticket_id']]['count']++; */
						}
						//echo "<br> maintain_date ticket ".$report[$post_details[$i]['ticket_id']]['maintain_date'];
						 if(isset($report[$post_details[$i]['ticket_id']]['maintain_date']) && $report[$post_details[$i]['ticket_id']]['maintain_date'] > 0)
							{  
								$report[$post_details[$i]['ticket_id']]['count']++;
								$report[$post_details[$i]['ticket_id']]['tcount']++;
								$report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date'];
								if($as_client_or_clientticket==0){
									//echo "<br>++++++++".$as_client_or_clientticket;
									$report[$post_details[$i]['ticket_id']]['count']=$report[$post_details[$i]['ticket_id']]['count']-1;
									$report[$post_details[$i]['ticket_id']]['tcount']=$report[$post_details[$i]['ticket_id']]['tcount']-1;
								}
							} 
						  
						$new_info = ($post_details[$i]['new_info']!='' && is_string($post_details[$i]['new_info'])) ? $post_details[$i]['new_info'] : '';
						$entry_date = $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['auditlogentry_date'] = $entry_date;
						$operation_id = $post_details[$i]['operation_id'];
						$total_post++;
						$report_cnt++;
					}else{ 
						$report[$post_details[$i]['ticket_id']]['entry_dateee']  = $post_details[$i]['entry_date']; 
					}  // prev 
					$submitter = $post_details[$i]['operator'];
					if (!isset($report[$post_details[$i]['ticket_id']]['start_time'])) {
						$report[$post_details[$i]['ticket_id']]['ticket_hash']     = $post_details[$i]['ticket_hash'];
						$report[$post_details[$i]['ticket_id']]['subject']         = $post_details[$i]['subject'];
						$report[$post_details[$i]['ticket_id']]['ticket_entry']    = $post_details[$i]['receive_date'];
						$report[$post_details[$i]['ticket_id']]['start_time']      = $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['post_date']	   = $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['ticket_priority'] = $post_details[$i]['ticket_priority'];
						$report[$post_details[$i]['ticket_id']]['department_name'] = $post_details[$i]['department_name'];
						$report[$post_details[$i]['ticket_id']]['first_name'] 	   = $post_details[$i]['first_name'];
						$report[$post_details[$i]['ticket_id']]['last_name']	   = $post_details[$i]['last_name'];
						$report[$post_details[$i]['ticket_id']]['email']		   = $post_details[$i]['email'];
						$report[$post_details[$i]['ticket_id']]['group_name']	   = $post_details[$i]['group_name'];
						$report[$post_details[$i]['ticket_id']]['client_id']       = $post_details[$i]['client_id'];
						$report[$post_details[$i]['ticket_id']]['ticket_id']       = $post_details[$i]['ticket_id'];
						$report[$post_details[$i]['ticket_id']]['status_id']       = $post_details[$i]['status_id'];
						$report[$post_details[$i]['ticket_id']]['remain_resolve']  = $post_details[$i]['remain_resolve'];
						$report[$post_details[$i]['ticket_id']]['pause_rtime']	   = $post_details[$i]['pause_rtime'];
						$report[$post_details[$i]['ticket_id']]['resolve_time']    = $post_details[$i]['resolution_time'];
						$report[$post_details[$i]['ticket_id']]['status_name']     = $post_details[$i]['status_name'];
						$report[$post_details[$i]['ticket_id']]['urgency']     = $post_details[$i]['urgency'];
						$report[$post_details[$i]['ticket_id']]['impact']     = $post_details[$i]['impact'];
						$report[$post_details[$i]['ticket_id']]['flag']     = $post_details[$i]['flag'];
						$report[$post_details[$i]['ticket_id']]['type']     =  (isset($post_details[$i]['type']))? $post_details[$i]['type'] :'';
						$report[$post_details[$i]['ticket_id']]['ticket_category']     =  (isset($post_details[$i]['ticket_category']))? $post_details[$i]['ticket_category'] :'';
						$report[$post_details[$i]['ticket_id']]['ticket_sub_cateogy']     =  (isset($post_details[$i]['ticket_sub_cateogy']))? $post_details[$i]['ticket_sub_cateogy'] :'';
						$report[$post_details[$i]['ticket_id']]['ticket_level']     =  (isset($post_details[$i]['ticket_level']))? $post_details[$i]['ticket_level']:'';
						$report[$post_details[$i]['ticket_id']]['sla_name']        = $post_details[$i]['sla_name'];
						$report[$post_details[$i]['ticket_id']]['operator']		   = $post_details[$i]['operator'];
						$report[$post_details[$i]['ticket_id']]['operation_id']	   = $post_details[$i]['operation_id'];
						$report[$post_details[$i]['ticket_id']]['closed_time']	   = $post_details[$i]['closed_time'];
						$report[$post_details[$i]['ticket_id']]['as_client']	   = $post_details[$i]['as_client'];
						$report[$post_details[$i]['ticket_id']]['new_info']		   = $post_details[$i]['new_info'];
						$report[$post_details[$i]['ticket_id']]['applyslaresol_time'] = $post_details[$i]['applyslaresol_time'];
						if (!isset($report[$post_details[$i]['ticket_id']]['tcount']))
						$report[$post_details[$i]['ticket_id']]['tcount']          = 0;
						else
						$report[$post_details[$i]['ticket_id']]['tcount']          += 0;							
						$report[$post_details[$i]['ticket_id']]['lastrepliertime'] = $post_details[$i]['lastrepliertime'];
						$report[$post_details[$i]['ticket_id']]['solve_time']      = 0;
						$report[$post_details[$i]['ticket_id']]['slapause_diff']   = 0;
						$report[$post_details[$i]['ticket_id']]['maintain_date']   = 0;
						$report[$post_details[$i]['ticket_id']]['count']           = 0;
						$report[$post_details[$i]['ticket_id']]['used_sla_seconds']= 0;
						$report[$post_details[$i]['ticket_id']]['total_sla_seconds'] = 0;
						$report[$post_details[$i]['ticket_id']]['auditlogentry_date'] = 0;
						$total_post= 0;
						$report[$post_details[$i]['ticket_id']]['due_date']  =0;
					} elseif($post_details[$i]['old_info']!=''){
						$total_sla_seconds = ($post_details[$i]['due_time'] - $report[$post_details[$i]['ticket_id']]['start_time']);
						$report[$post_details[$i]['ticket_id']]['due_date']  = ($post_details[$i]['due_time'] - $post_details[$i]['lastrepliertime']); 
						$report[$post_details[$i]['ticket_id']]['as_client']	   = $post_details[$i]['as_client'];
						//$maintain_date_nw = !isset($report[$post_details[$i]['ticket_id']]['maintain_date_nw'])? 0:$report[$post_details[$i]['ticket_id']]['maintain_date_nw'];
						$report[$post_details[$i]['ticket_id']]['sla_response_time'] = round($maintain_date_nw);		
						 $report[$post_details[$i]['ticket_id']]['used_sla_seconds'] = $report[$post_details[$i]['ticket_id']]['sla_response_time'];
						 $report[$post_details[$i]['ticket_id']]['timestamp'] = $report[$post_details[$i]['ticket_id']]['sla_response_time'];
						$submitter = $post_details[$i]['operator'];
						$operation_id = $post_details[$i]['operation_id'];
						$new_info = ($post_details[$i]['new_info']!='' && is_string($post_details[$i]['new_info'])) ? $post_details[$i]['new_info'] : '';
						$entry_date = $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['auditlogentry_date'] = $entry_date;
						
						$report_cnt++;
					}
				} 
				$old_ticket_id=$post_details[$i]['ticket_id'];
				}
			} else {
				$report = -1;
			}
			$report_new = array();
			$responseCounte=0;
			
			$totrepltime=0;
			$avgtotrepltime=0;
			$avgtotrepltime=0; 
			$tcount=0;
			$totalincidentsreplied=$auditlogentry_date=0;
			$totlavgresposmaintain=$totlavgresolmaintain=0;
			if ($report != -1) {
				foreach ($report as $ticket_id => $details) {
					$isUndueSet = 0; 
					$report[$ticket_id]['totlavgresposmaintain']=0;
					/* if($details['tcount']>0){ */ 
					if($details['tcount']>0 || ($details['tcount']>=0 && $details['count']>0)){
						if($details['lastrepliertime']>0 && $details['ticket_entry']>0){
							$totrepltime = $details['lastrepliertime'] - $details['ticket_entry']; }
							if(isset($totrepltime) && $totrepltime!=0){
								if($details['tcount']!=0){
									$avgtotrepltime = count_remain_time(round($totrepltime / $details['tcount']));
									$report[$ticket_id]['avg_tot_replied_time']=$avgtotrepltime;
									$report[$ticket_id]['tot_post_and_reply_time']=$totrepltime;
								}
								$tcount += $details['tcount']; 
								$totalincidentsreplied++;
							}
					}else{ 
						if(isset($details['status_id']) && $details['status_id']==3 && ( isset($details['closed_time']) && $details['closed_time']!='')){
						$totrepltime = $details['closed_time'] - $details['lastrepliertime'];
						$report[$ticket_id]['tot_post_and_reply_time']=$totrepltime;
						}
					} 
					if($details['pause_rtime'] == ''){
					if($details['closed_time']=='' && $details['status_id']==4 && is_string($new_info)){
						$calculate_resolve_time = $details['auditlogentry_date'] - $details['applyslaresol_time'];
					} else {
						$calculate_resolve_time = $details['resolve_time'] - (isset($details['closed_time']))? $details['closed_time'] :0;
					}
					if ($details['resolve_time'] < 0 && ($details['status_id'] == 3 || $details['status_id'] == 4)) {
						$isUndueSet                                = 0;
						$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTUNDUE'];
					} else if (($details['resolve_time'] < 0 || $details['remain_resolve'] < 0) && $details['status_id'] != 3  && $details['status_id']!=4) {
						$isUndueSet                                = 0;
						// $report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTOVERDUE'];
						if($details['pause_rtime'] == ''){$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTNOTMAINTAIN'];}else{
						$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTOVERDUE'];}
					} else if (($details['resolve_time'] > 0 || $details['remain_resolve'] > 0) && $details['status_id']!=3  && $details['status_id']!=4) {
						$isUndueSet                                = 0;
						if($details['count']!= 0){
							$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTUNDUE'];
						} else {
							$report[$ticket_id]['avg_resolution_time'] = $vis_language['TXTNOTRESPONDED'];
						}
						if(isset($details['lastrepliertime']) && $details['lastrepliertime']>0){
						$report[$ticket_id]['lastrepliertime'] = $details['lastrepliertime'];
						}
					} else {
						$isUndueSet = 1;
						if($calculate_resolve_time > 0){
							if($details['count']!=0)
								$resolutionCount++;
						}
						if($details['closed_time']=='' && (isset($details['status_id']) && ($details['status_id']==4 || $details['status_id']==3))){				
						if($auditlogentry_date==0){ $auditlogentry_date = $details['entry_dateee']; }	
						if($auditlogentry_date>0){
							$report[$ticket_id]['avg_resolution_time'] = count_remain_time($auditlogentry_date - $details['applyslaresol_time']); }
						} else {
								if($report[$ticket_id]['customsla']>0)	{
								$report[$ticket_id]['avg_resolution_time'] = count_remain_time($details['closed_time'] - $details['applyslaresol_time']);
							}	else	{
								/* $report[$ticket_id]['avg_resolution_time'] = count_remain_time($details['closed_time'] - $details['ticket_entry']); */
								$report[$ticket_id]['avg_resolution_time'] = count_remain_time($details['closed_time'] - $details['ticket_entry']);
							}
						}
						if($details['tcount']>=1){
						// $totlavgresolmaintain+=1;
						$report[$ticket_id]['totalmaintcont']=1;
							$responseCount++;
						}
					}
					if($details['tcount']==0 && ($details['status_id']==3 || $details['status_id']==4)){
						$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTMAINTAIN'];
					} else if(($details['resolve_time'] < 0 || $details['remain_resolve'] < 0) && $details['status_id']!=3 && $details['status_id']!=4) {
						if($responseCount!=0) { $responseCount--; }else{ $responseCount++;}
						if($details['tcount'] > 1){  
							$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTMAINTAIN'];
						} else {
							$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTRESPONDED'];
						} 
					} else if($details['tcount']!= 0 && ($details['status_id']==3 || $details['status_id']==4)){
						if($details['resolve_time'] < 0 || $details['remain_resolve'] < 0){ 
							$responseCount--;
							$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTRESPONDED'];
						} else {
							$report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
							//$totlavgresposmaintain++;
							$report[$ticket_id]['totlavgresposmaintain']++;
						}
					} else if (($details['resolve_time'] > 0 || $details['remain_resolve'] > 0) && ($details['status_id']!=3 && $details['status_id']!=4)) {
						if($details['tcount'] > 1){  
							$report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
							//$totlavgresposmaintain++;
							$report[$ticket_id]['totlavgresposmaintain']++;
						} else {
							if ($details['operation_id']==0 && $details['operator']==2) {
							$report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
								if($details['used_sla_seconds'] > 0)	{
									//$totlavgresposmaintain++;
									$report[$ticket_id]['totlavgresposmaintain']++;
								}							
							}	else{
							$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTRESPONDED'];
							}
						}
					}
						if($details['tcount']!=0 && ($details['status_id']==3 || $details['status_id']==4)){
							$report[$ticket_id]['response_sla_stat'] = $vis_language['TXTMAINTAIN'];
						}else{
							$report[$ticket_id]['response_sla_stat'] = $vis_language['TXTNOTRESPONDED'];
						}
					if($isUndueSet == 1 && $resolutionCount>0){ 
						if($details['status_id']!=3 && $details['status_id']!=4 ){
							
							if($details['count']!=0){
								 $report[$ticket_id]['resolution_sla']   = $vis_language['MSGNOTRESOLVED'] ;
							} else {
								$report[$ticket_id]['resolution_sla']   = $vis_language['MSGNOTRESOLVED'];
							}
						} else {
							if($details['resolve_time'] < 0){ /*|| $details['remain_resolve'] < 0){*/
								$report[$ticket_id]['resolution_sla'] = $vis_language['TXTNOTMAINTAIN'];
							} else { 
								if($details['resolve_time']<$details['closed_time']){
                                    $report[$ticket_id]['resolution_sla'] = $vis_language['TXTNOTMAINTAIN'];
                                }else{
                                $report[$ticket_id]['resolution_sla'] = $vis_language['TXTMAINTAIN'];
								$totlavgresolmaintain++;
	                            }
							}
						}
					} elseif($details['count']==0 && $details['status_id']!=3 && $details['status_id']!=4){ 
						if($details['remain_resolve'] > 0){	  $report[$ticket_id]['resolution_sla']   =$vis_language['MSGNOTRESOLVED'];
						}else{ $report[$ticket_id]['resolution_sla']   = $vis_language['TXTOVERDUE']; }
					} elseif($details['count']!=0 && $details['status_id']!=3 && $details['status_id']!=4 && $details['remain_resolve'] > 0){ 
						 $report[$ticket_id]['resolution_sla']   = $vis_language['MSGNOTRESOLVED'];
					} else if(($details['resolve_time'] < 0 || $details['remain_resolve'] < 0) &&   $details['status_id']!=3 && $details['status_id']!=4){
						$report[$ticket_id]['resolution_sla']   = $vis_language['TXTOVERDUE'];

					}else{
						if($details['count']==0 && $details['status_id']!=3 && $details['status_id']!=4){ 
							$report[$ticket_id]['resolution_sla']   = "NA";
						} else {  
							if($details['closed_time'] > $details['resolve_time'] && ($details['status_id']==3 || $details['status_id']==4)){
								$report[$ticket_id]['resolution_sla']   = $vis_language['TXTNOTMAINTAIN'];
							}else{
								$report[$ticket_id]['resolution_sla']   = $vis_language['TXTMAINTAIN'];
								$totlavgresolmaintain++;
							}
						}
					}
					$cal_timestamp = (isset($details['timestamp']) && $details['timestamp'] != '' && $details['count'] != '0')? round(($details['timestamp']/$details['count']),2):''; 
					if($details['count']!=0){
						$replied_ticket_cnt+=1;
					} else {
						$replied_ticket_cnt+=0;
					}
					$report[$ticket_id]['avg_response_time']=($details['count']!=0) ? count_remain_time($cal_timestamp) : (($details['operation_id']==0 && $details['operator']==2) ? '0S': $vis_language['TXTNOTRESPONDED']);

					if($details['count']!=0)
						$responseCount+=1;
						
					if($details['count']!=0)
		                {
		                    $report[$ticket_id]['avg_response_time'] = count_remain_time($cal_timestamp);
		                }
	                else
		                {               	
			                $report[$ticket_id]['avg_response_time'] = '0 S';	                	
		                }
		    		if(isset($report[$ticket_id]['avg_tot_replied_time']) && $report[$ticket_id]['avg_tot_replied_time'] >0 ){	
						if($details['due_date'] < 0 && $details['tcount']>=1){ 
							if($details['operator']==1 || $details['as_client']==1) {       
                        $report[$ticket_id]['response_sla'] =  $vis_language['TXTNOTMAINTAIN']; 
		                    } elseif ($details['lastrepliertime']>$details['resolve_time']) {
	                        $report[$ticket_id]['response_sla'] =  $vis_language['TXTNOTMAINTAIN']; 
		                    } else{
		                    $report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
		                    $report[$ticket_id]['totlavgresposmaintain']++;
		                    }
						} else {
							$report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
							//$totlavgresposmaintain++;
							$report[$ticket_id]['totlavgresposmaintain']++;
						}			
					}else{ 				
					if((isset($details['response_sla']) && $details['response_sla']==$vis_language['TXTOVERDUE'] && $details['response_sla']!='')) {
						if($details['operator']==1 || $details['as_client']==1) {       
	                        $report[$ticket_id]['response_sla'] = $details['response_sla'];
	                    }  else {
	                    	$report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
	                    	//$totlavgresposmaintain++;
	                    	$report[$ticket_id]['totlavgresposmaintain']++;
	                    }
					} else {	
						 
							if($details['operator']==1 || $details['as_client']==1) {       
								if($details['due_date'] > 0 && $details['count']>=1) {
								
									$report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
									//$totlavgresposmaintain++;
									$report[$ticket_id]['totlavgresposmaintain']++;
								}	else	{
		                       		if($details['count'] >=1){
										  $report[$ticket_id]['response_sla'] =  $vis_language['TXTNOTMAINTAIN']; 
									}else{
										$report[$ticket_id]['response_sla'] = $vis_language['TXTNOTRESPONDED'];									
									}
								}
		                    } elseif($report[$ticket_id]['avg_response_time']=='0 S')  {
		  	                    	$report[$ticket_id]['response_sla'] = $vis_language['TXTMAINTAIN'];
		  	                } else   {
		                    $report[$ticket_id]['response_sla'] = $vis_language['TXTNOTRESPONDED'];
		                    }
						}
					}
						if($details['count']==0 && $report[$ticket_id]['totlavgresposmaintain']==1){
							$report[$ticket_id]['totlavgresposmaintain'] =0;
						} 
						if($report[$ticket_id]['totlavgresposmaintain'] > 0) {
							$totlavgresposmaintain++;
						}
					}else
						$report[$ticket_id]['response_sla'] = 'NA';
				}
				foreach (((isset($operation['vis_export']) && $operation['vis_export'] == 1)? $report:array_slice($report, $limit, $view_info['page_count'])) as $p) {
					$report_new[] = $p;
				}
				$array_summary=array();
	            $array_summary['TXTTOTALTICKETSREPLIED']=$totalincidentsreplied; 
	            $array_summary['TXTTOTALAVGRESPONSESLAMAINTAIN']=(($totlavgresposmaintain==0)?0:round((($totlavgresposmaintain/count($report))*100), 2)).'%';
	            $array_summary['TXTTOTALAVGRESOLUTIONSLAMAINTAIN']=(($totlavgresolmaintain==0)?0:round((($totlavgresolmaintain/count($report))*100), 2)).'%';
				$total = count($report);
				$view_info['page']=$page;
				$report_count=($report_new!=-1 || !empty($report_new)) ? count($report_new) : 0;
				$view_info['page_count']=(count($report)==0)? 0 : ceil(count($report)/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				$replied_ticket_cnt = 0;
				foreach ($report as $i) {
					foreach ($i as $key => $val) {
						if ($key == 'sla_time'){
							$report_exp[$j]['SLA'] = count_remain_time($val);
						}	elseif ($key == 'timestamp'){							
							$report_exp[$j]['SLA']= ($i['count']!=0) ? count_remain_time($val/$i['count']) : $vis_language['TXTNOTRESPONDED'];
						}	elseif ($key == 'tot_post_and_reply_time'){
							$report_exp[$j][$key] = $val;
						}	elseif ($key == 'totalmaintcont'){
							$report_exp[$j][$key] = $val;
						}	elseif ($key == 'status_id'){
							$report_exp[$j][$key] = $val;
						}	elseif ($key == 'new_info'){
							$report_exp[$j][$key] = $val;
						}	elseif ($key == 'closed_time'){
							$report_exp[$j][$key] = $val;
						}	elseif ($key == 'tcount'){
							$report_exp[$j][$key] = $val;
						}	elseif ($key == 'avg_tot_replied_time'){
							$report_exp[$j][$key] = $val;
						}	elseif ($key == 'operator'){
							$report_exp[$j][$key] = $val;
						}	elseif ($key == 'as_client'){
							$report_exp[$j][$key] = $val;
						}	elseif ($key == 'due_date'){
							$report_exp[$j][$key] = $val;
						}	else if ($key == 'client_id'){
							$report_exp[$j][$key] = $val;
						}	elseif ($key == 'ticket_entry'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'due_time'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'resolve_time'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'ticket_hash' || $key == 'subject' || $key == 'department_name' || $key == 'ticket_priority' || $key == 'status_name' ||  $key == 'type' ||  $key == 'impact' ||  $key == 'urgency' ||  $key == 'flag'  ||  $key == 'ticket_category'  ||  $key == 'ticket_sub_cateogy' || $key == 'ticket_level' || $key == 'sla_name' || $key == 'first_name' || $key == 'last_name' || $key == 'email' || $key == 'group_name'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'avg_resolution_time'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'pause_rtime'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'response_sla'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'resolution_sla'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'avg_response_time'){
							$report_exp[$j][$key] = $val;
						} else if ($key == 'count'){
							$report_exp[$j][$key] = $val;
						}
					}
					$sla_name = ($report_exp[$j]['sla_name']!= '')?$report_exp[$j]['sla_name']:$vis_language['TXTCUSTDUETIME'];
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['creation_date'] = $report_exp[$j]['ticket_entry'];
					$report_exp1[$j]['department'] = $report_exp[$j]['department_name'];
					$report_exp1[$j]['client_email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					$report_exp1[$j]['sla_plan'] = $sla_name;
					$report_exp1[$j]['priority'] = $report_exp[$j]['ticket_priority'];
					$report_exp1[$j]['status'] = $report_exp[$j]['status_name'];
					$report_exp1[$j]['type'] = $report_exp[$j]['type'];
					$report_exp1[$j]['urgency'] = $report_exp[$j]['urgency'];
					$report_exp1[$j]['flag'] = $report_exp[$j]['flag'];
					$report_exp1[$j]['impact'] = $report_exp[$j]['impact'];
					$report_exp1[$j]['category'] = $report_exp[$j]['ticket_category'];
					$report_exp1[$j]['sub_category'] = $report_exp[$j]['ticket_sub_cateogy'];
					$report_exp1[$j]['level'] = $report_exp[$j]['ticket_level'];
					$report_exp1[$j]['avg_response_time'] = ($report_exp[$j]['pause_rtime']!='') ? $vis_language['MSGNOTRESOLVED'] : $report_exp[$j]['avg_response_time'];
						$resolution_time = (isset($report_exp[$j]['tot_post_and_reply_time']) && $report_exp[$j]['tot_post_and_reply_time'] !=0 )?count_remain_time(round($report_exp[$j]['tot_post_and_reply_time'])): $vis_language['TXTNOTRESPONDED'];
					
		            $cal_timestamp = ($report_exp[$j]['timestamp'] != '' && $report_exp[$j]['count'] != '0')? round(($report_exp[$j]['timestamp']/$report_exp[$j]['count']),2):''; 

					$report[$ticket_id]['avg_response_time']=($report_exp[$j]['count']!=0) ? count_remain_time($cal_timestamp) : (($report_exp[$j]['operation_id']==0 && $report_exp[$j]['operator']==2) ? '0S': $vis_language['TXTNOTRESPONDED']);
					if($report_exp[$j]['count']!=0)    {
		                    $report_exp1[$j]['avg_response_time'] = count_remain_time($cal_timestamp);
		                }   else  {               	
			                $report_exp1[$j]['avg_response_time'] = '0 S';	                	
		                }
	                if(isset($report_exp[$j]['pause_rtime']) && $report_exp[$j]['pause_rtime']!=''){
					    $report_exp1[$j]['avg_response_time']='NA';
					}elseif(isset($report_exp[$j]['avg_response_time']) && $report_exp[$j]['avg_response_time'] !=0)
						{
							$report_exp1[$j]['avg_response_time']=  $report_exp[$j]['avg_response_time'];
						}
					elseif(isset($report_exp[$j]['avg_response_time']) && $report_exp[$j]['avg_response_time'] =='0 S' && $report_exp[$j]['operator']!=1 && $report_exp[$j]['as_client']!=1){ 
						$report_exp1[$j]['avg_response_time']=  '0 S';
					}else{ 
						$report_exp1[$j]['avg_response_time'] = $vis_language['TXTNOTRESPONDED'];
					}
		            $resolution_flag = ($report_exp[$j]['pause_rtime']!='') ? $report_exp[$j]['pause_rtime'] : '';
					if(isset($report_exp[$j]['pause_rtime']) && $report_exp[$j]['pause_rtime']!=''){
					    $report_exp1[$j]['avg_resolution_time']='NA';
					}elseif(isset($report_exp[$j]['status_id']) &&($report_exp[$j]['status_id']==4 || $report_exp[$j]['status_id']==3)){
						$report_exp1[$j]['avg_resolution_time'] = (isset($report_exp[$j]['avg_resolution_time']) && $report_exp[$j]['avg_resolution_time'] !='' )? $report_exp[$j]['avg_resolution_time'] :"Not resolved"; //$resolution_time;
						}else{ 
						 $report_exp1[$j]['avg_resolution_time'] = (isset($report_exp[$j]['resolution_sla']) && $report_exp[$j]['resolution_sla'] !='' ) ? $report_exp[$j]['resolution_sla']: $vis_language['TXTNOTMAINTAIN'];
						}
					if(isset($report_exp[$j]['pause_rtime']) && $report_exp[$j]['pause_rtime']!=''){
					    $report_exp1[$j]['response_sla']='NA';
					}elseif(isset($report_exp[$j]['avg_tot_replied_time']) && $report_exp[$j]['avg_tot_replied_time'] >0 ){
					    $replied_ticket_cnttt+=$report_exp[$j]['tcount'];
					    $rescounttt++;
					    if($report_exp[$j]['due_date'] < 0 && $report_exp[$j]['tcount']>=1){
					        if($report_exp[$j]['operator']==1 || $report_exp[$j]['as_client']==1){       
					            $report_exp1[$j]['response_sla'] = $vis_language['TXTNOTMAINTAIN'];
					        } else {
					            $report_exp1[$j]['response_sla'] = $vis_language['TXTNOTMAINTAIN'];
					            // $report_exp1[$j]['response_sla'] = $vis_language['TXTMAINTAIN'];
					        }
					    } else {
					        $report_exp1[$j]['response_sla'] =  $vis_language['TXTMAINTAIN'];
					    }           
					}else{ 
					    if((isset($report_exp[$j]['response_sla'] ) && $report_exp[$j]['response_sla']==$vis_language['TXTOVERDUE']  && $report_exp[$j]['response_sla']!='')){
					        if($report_exp[$j]['operator']==1 || $report_exp[$j]['as_client']==1){
					            $report_exp1[$j]['response_sla']=$report_exp[$j]['response_sla'];
					        }else{
					            $report_exp1[$j]['response_sla']=$vis_language['TXTMAINTAIN'];
					        } 
					    }else{
					        if($report_exp[$j]['operator']==1 || $report_exp[$j]['as_client']==1){					            
					            if($report_exp[$j]['due_date'] > 0 && $report_exp[$j]['count']>=1) {
										$report_exp1[$j]['response_sla']=$vis_language['TXTMAINTAIN'];
									} else {			                       		
			                       		//$report_exp1[$j]['response_sla']=$vis_language['TXTNOTRESPONDED'];
										if($report_exp[$j]['count'] >=1){
			                       				$report_exp1[$j]['response_sla']=$vis_language['TXTNOTMAINTAIN'];
											}else{
                       							$report_exp1[$j]['response_sla']=$vis_language['TXTNOTRESPONDED'];					
											}
									}
					        } elseif($report_exp[$j]['avg_response_time']=='0 S') {
  	                	            $report_exp1[$j]['response_sla']=$vis_language['TXTMAINTAIN'];   
                    		} else{
					            $report_exp1[$j]['response_sla']=$vis_language['TXTNOTRESPONDED'];
					        }
					    }
					}
					if(isset($report_exp[$j]['pause_rtime']) && $report_exp[$j]['pause_rtime']!=''){
					    $report_exp1[$j]['resolution_sla']='NA';
					}elseif((isset($report_exp[$j]['resolution_sla']) && $report_exp[$j]['resolution_sla']==$vis_language['TXTOVERDUE']) || !isset($report_exp[$j]['resolution_sla'])){
					    $report_exp1[$j]['resolution_sla']=$vis_language['TXTNOTMAINTAIN'];
					}else{
					     $report_exp1[$j]['resolution_sla']=(isset($report_exp[$j]['resolution_sla']) && $report_exp[$j]['resolution_sla']!='')?$report_exp[$j]['resolution_sla']:$vis_language['TXTNOTMAINTAIN'];
					}
					if($i['count']!=0){
						$replied_ticket_cnt+=1;
					} else {
						$replied_ticket_cnt+=0;
					}
					$j++;
				}
				if($report!=-1){
					foreach($array_summary as $key=>$val){ 
					$title=explode(' ',$key);
					$title[1]=isset($title[1])? ' '.$title[1]:'';
					 $report_exp1[$j][$vis_language[$title[0]].$title[1]]=$vis_language[$title[0]].$title[1].' : '.$val; 
					}
				} 
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE.'report_page.php');
			} 
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function work_report($operation)
	{	
		global $vis_language;
		$report_title = $vis_language['TXTSTAFFWORK'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type = 1;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$wr_staff_dropdwon      = $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
		$object_staff  = new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='work_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		$service='';
		if((isset($operation['vis_action']) && $operation['vis_action']!='') || isset($operation['vis_submit']) && $operation['vis_submit']!=''){
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && (!isset($data['staff_id']) || !empty($data['staff_id']))) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && (!isset($data['staff_id']) || empty($data['staff_id']))) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTSTAFF']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && (isset($data['staff_id']) || !empty($data['staff_id']))) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';if($data['service_id']==3)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id=0';}
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				if (isset($data['staff_id']) && ($data['staff_id'] != '' && $data['staff_id'] != 0)) {
					if(is_array($data['staff_id'])){
					$staff_ids = implode(',',$data['staff_id']);					
					}
				}
				if(VIS_ADMIN_ACCESS_LEVEL==1) {
					$filter = ' '.VIS_TABLE_PREFIX.'auditlog.operation_id!=9 AND '.VIS_TABLE_PREFIX.'auditlog.operation_id<100 and entry_date between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'auditlog.operator!=1 and '.VIS_TABLE_PREFIX.'auditlog.operator_id in('.$staff_ids.')';
				}else{
					$filter = ' '.VIS_TABLE_PREFIX.'auditlog.operation_id!=9 AND '.VIS_TABLE_PREFIX.'auditlog.operation_id<100 and entry_date between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'auditlog.operator!=1 and workflow_id=0 and '.VIS_TABLE_PREFIX.'auditlog.operator_id in('.$staff_ids.')';
				}
			}
			$filter.= ' and '.VIS_TABLE_PREFIX.'ticket.draft_id=0 and '.VIS_TABLE_PREFIX.'ticket.is_spam=0 and '.VIS_TABLE_PREFIX.'ticket.is_deleted=0 and '.VIS_TABLE_PREFIX.'auditlog.access_id=0 '.$service;
			$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
			$status   = $tkt_object->get_status_list('', $staff_id, VIS_LOCATION_AREA);
			for ($i = 0; $i < count($status); $i++){
				$status_list[$status[$i]['status_id']] = $status[$i]['status_name'];
				$priority = $tkt_object->get_priorities_list($staff_id, VIS_LOCATION_AREA, '');
			}
			for ($i = 0; $i < count($priority); $i++){
				$priority_list[$priority[$i]['priority_id']] = $priority[$i]['priority_name'];
				$department = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
			}
			for ($i = 0; $i < count($department); $i++){
				$department_list[$department[$i]['department_id']] = $department[$i]['department_name'];
				$staff_list[0] = $vis_language['TXTUSSIGNED'];
			}
			if(isset($from) && $from!=''){
				$filter.= ' and '.VIS_TABLE_PREFIX.'auditlog.log_id not in(select '.VIS_TABLE_PREFIX.'auditlog.log_id from '.VIS_TABLE_PREFIX.'auditlog where operation_id=13 and new_info!=0 and old_info=0 and entry_date between ' . $from . ' AND ' . $to . ')';
				}

			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			list($total, $report) = $object->get_work_report($filter, $limit, $staff_id, VIS_LOCATION_AREA);
			if($report!=-1) {
				$close_time=$report[0]['closed_time'];
				$creation_time=$report [0]['creation_date'];
				if( $close_time!=0){
					$total_time=$report[0]['closed_time']-$report[0]['creation_date'];
				} else {
					$total_time=$vis_language['MSGNOTAPPLICABLE'];
				} 
				$avgTimeCount =count_remain_time($total_time ) ;
			}
			$view_info['page']=$page;
			$view_info['view_count']= $total;
			$report_count=($report!=-1)? count($report) : 0;
			$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			$array_summary = array(); // MSGTKTASSIG
			for($i=0 ; $i<$report_count;$i++){
				switch($report[$i]['operation_id']){
					case '0':
						$report[$i]['audit_log_operation']= ($report[$i]['channel_id']==7) ? $vis_language['TXTSERVICEREQUESTCREATED'] : $vis_language['MSGNEWTKTCRT'];
						break;
					case '1':
						$servicereqreplied = $vis_language['TXTITILREQUESTSERVICE'].' '.strtolower($vis_language['TXTREPLIED']);
						$report[$i]['audit_log_operation']= ($report[$i]['channel_id']==7) ? $servicereqreplied : $vis_language['MSGTKTRPLD'];
						break;
					case '2':
						$report[$i]['audit_log_operation'] = $vis_language['TXTSTATUSCHANGEDFROM'].' '.$report[$i]['old_info'].' '.strtolower($vis_language['TXTTO']).' '.$report[$i]['new_info'];
						break;
					case '3':
						$report[$i]['audit_log_operation'] = $vis_language['TXTPRIORITYCHANGEDFROM'].' '.$report[$i]['old_info'].' '.strtolower($vis_language['TXTTO']).' '.$report[$i]['new_info'];
						break;
					case '4':
						$report[$i]['audit_log_operation'] = $vis_language['TXTDEPARTMENTCHANGEDFROM'].' '.$report[$i]['old_info'].' '.strtolower($vis_language['TXTTO']).' '.$report[$i]['new_info'];
						break;
					case '5':
						if($report[$i]['channel_id']==7){
										 $report[$i]['audit_log_operation'] = $vis_language['TXTITILREQUESTSERVICE'].' type changed from '. $report[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $report[$i]['new_info'];
									 }else{
									$report[$i]['audit_log_operation'] = $vis_language['TXTTICKETTYPECHANGEDFROM'].' '. $report[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $report[$i]['new_info'];}
						break;
					case '6':
						$report[$i]['audit_log_operation'] = $vis_language['TXTFLAGCHANGEDFROM'].' '.$report[$i]['old_info'].' '.strtolower($vis_language['TXTTO']).' '.$report[$i]['new_info'];
						break;
					case '7':
						include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');  // MSGTKTTRSH
						$object=new class_setting($database);
						$staff_new_info=$object->get_staff(VIS_TABLE_PREFIX.'staff.staff_id='.$report[$i]['new_info'], '', '', '', $staff_id, VIS_LOCATION_AREA,1);
						$new_info =  $staff_new_info[1][0]['first_name'].' '.$staff_new_info[1][0]['last_name'];
						if($report[$i]['new_info']!=0 && $staff_new_info[1]!=-1){
							if($report[$i]['channel_id']==7){
								$report[$i]['audit_log_operation'] = $vis_language['MSGSERASSIG'].' '.strtolower($vis_language['TXTTO']).' '.$new_info;
							}else{
								$report[$i]['audit_log_operation'] = $vis_language['MSGTKTASSIG'].' '.strtolower($vis_language['TXTTO']).' '.$new_info;
							}

						} elseif($report[$i]['new_info']==0 && $report[$i]['old_info']>0){ 
							$staff_old_info=$object->get_staff(VIS_TABLE_PREFIX.'staff.staff_id='.$report[$i]['old_info'], '', '', '', $staff_id, VIS_LOCATION_AREA,1);
							$old_info =  $staff_old_info[1][0]['first_name'].' '.$staff_old_info[1][0]['last_name'];
							$report[$i]['audit_log_operation']= ($report[$i]['channel_id']==7) ? $vis_language['TXTSERVICEUNASSIGNEDFROM'].' '.$old_info : $vis_language['TXTTICKETUNASSIGNEDFROM'].' '.$old_info;
						} else {
							$report[$i]['audit_log_operation']= ($report[$i]['channel_id']==7) ? $vis_language['TXTSERVICEASSIGNEDTONOBODY'] : $vis_language['TXTTICKETASSIGNEDTONOBODY'];
						}
						break;
					case '8':
						include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');  
						$object=new class_setting($database);
						$staff_details=$object->get_staff(VIS_TABLE_PREFIX.'staff.staff_id='.$report[$i]['operator_id'], '', '', '', $staff_id, VIS_LOCATION_AREA);
						$staff_name =  $staff_details[1][0]['first_name'].' '.$staff_details[1][0]['last_name'];
						if($report[$i]['old_info']!=0){
							$report[$i]['audit_log_operation'] = ($report[$i]['channel_id']==7) ? $vis_language['MSGSERTRSH']:$vis_language['MSGTKTTRSH'];
						} elseif($report[$i]['old_info']==0){
							$report[$i]['audit_log_operation'] = ($report[$i]['channel_id']==7) ? $vis_language['TXTSERMOVEINBOCFROMTRASH']:$vis_language['TXTTKTMOVEINBOCFROMTRASH'];
						}
						break;
					case '9':
						include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');  
						$object=new class_setting($database);
						$staff_details=$object->get_staff(VIS_TABLE_PREFIX.'staff.staff_id='.$report[$i]['operator_id'], '', '', '', $staff_id, VIS_LOCATION_AREA);
						$staff_name =  $staff_details[1][0]['first_name'].' '.$staff_details[1][0]['last_name'];
						$report[$i]['audit_log_operation'] = $report[$i+1]['old_info'].' '.strtolower($vis_language['TXTDELETED']);
						break;
					case '10':
						include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php'); /// TXTTICKETPOSTSPLITWITH
						$object=new class_ticket($database);
						$report[$i]['audit_log_operation'] = $report[$i]['new_info'].' '.strtolower($vis_language['TXTMERGEDTO']).' '.$report[$i]['old_info'];
						break;
					case '11':
						$report[$i]['audit_log_operation'] = ($report[$i]['channel_id']==7) ? $vis_language['MSGSRVFRWD']:$vis_language['MSGTKTFRWD'];
						break;
					case '12':
						$report[$i]['audit_log_operation'] = ($report[$i]['channel_id']==7) ? $vis_language['MSGSERDELETED']:$vis_language['MSGTKTDELETED'];
						break;
					case '13':
						include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');  
						$object=new class_setting($database);
						$sla_old_info=$object->get_sla(VIS_TABLE_PREFIX.'sla.sla_id='.$report[$i]['old_info'], '', '', '', $staff_id, VIS_LOCATION_AREA);
						$sla_new_info=$object->get_sla(VIS_TABLE_PREFIX.'sla.sla_id='.$report[$i]['new_info'], '', '', '', $staff_id, VIS_LOCATION_AREA);
						$old_info =  $sla_old_info[1][0]['sla_name'];
						$new_info =  $sla_new_info[1][0]['sla_name'];
						if($report[$i]['new_info']!=0 && $report[$i]['old_info']!=0){
							$report[$i]['audit_log_operation'] = $vis_language['TXTSLACHANGEDFROM'].' '.$old_info.' '.strtolower($vis_language['TXTTO']).' '.$new_info;
								$report[$i]['audit_log_operation_skip'] = 0;
						} else if($report[$i]['old_info']==0 && $report[$i]['new_info']!=0){
							$report[$i]['audit_log_operation'] = $vis_language['TXTSLASETTO'].' '.$new_info;
							$report[$i]['audit_log_operation_skip'] = 'removesla';
							//$report[$i]['audit_log_operation'] = 'removesla';
						} else if($report[$i]['new_info']==0){
							$report[$i]['audit_log_operation'] = $vis_language['TXTAPPLIEDCUSTOMSLAPLAN'];
							$report[$i]['audit_log_operation_skip'] = 0;
						}
						break;
					case '14':
						if($report[$i]['new_info']!=0 && $report[$i]['old_info']==0){
							$report[$i]['audit_log_operation'] = $vis_language['MSGSPAMMRK'];
						} elseif($report[$i]['new_info']==0 && $report[$i]['old_info']!=0){
							$report[$i]['audit_log_operation'] = $vis_language['TXTNOTSPAMMARKED'];
						}
						break;
					case '15':
						$report[$i]['audit_log_operation'] = $vis_language['MSGUNSPAM'];
						break;
					case '16':
						$report[$i]['audit_log_operation'] = $vis_language['TXTNEWTASKATTACHED'].' '.$report[$i]['old_info'];
						break;
					case '17':
						$report[$i]['audit_log_operation'] = $vis_language['TXTDETACHEDATTACHEDTASK'].' '.$report[$i]['old_info'];
						break;
					case '18':
						$report[$i]['audit_log_operation'] = $vis_language['TXTNEWCIATTACHED'].' '.$report[$i]['old_info'];
						break;
					case '19':
						$report[$i]['audit_log_operation'] = $vis_language['TXTDETACHEDATTACHEDCI'].' '.$report[$i]['old_info'];
						break;
					case '20':
						$report[$i]['audit_log_operation'] = $vis_language['TXTNEWPROBLEMATTACHED'].' '.$report[$i]['old_info'];
						break;
					case '21':
						$report[$i]['audit_log_operation'] = $vis_language['TXTDETACHEDATTACHEDPROBLEM'].' '.$report[$i]['old_info'];
						break;
					case '22':
						$report[$i]['audit_log_operation'] = $vis_language['TXTNEWCHANGEATTACHED'].' '.$report[$i]['old_info'];
						break;
					case '23':
						$report[$i]['audit_log_operation'] = $vis_language['TXTDETACHEDATTACHEDCHANGE'].' '.$report[$i]['old_info'];
						break;	
					case '24':
						include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
						$object=new class_ticket($database);
						$report[$i]['audit_log_operation'] = $report[$i]['new_info'].' '.strtolower($vis_language['TXTLINKEDTO']).' '.$report[$i]['old_info'];
						break;	
					case '25':
						include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
						$object=new class_ticket($database);
						$servreqdeleted = $vis_language['TXTITILREQUESTSERVICE'].' '.strtolower($vis_language['TXTPOST']).' '.strtolower($vis_language['TXTDELETED']);
						$report[$i]['audit_log_operation']= ($report[$i]['channel_id']==7) ? $servreqdeleted : $vis_language['MSGTICKETPOSTDELETE'];
						break;	
					case '26':
						include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php'); // MSGTICKETPROPERTYUPDATED
						$object=new class_ticket($database);
						if($report[$i]['channel_id']==7){
							$report[$i]['audit_log_operation'] = $vis_language['TXTSERVICEPOSTSPLITWITH'].' '.$report[$i]['new_info'];
						}else { 
							$report[$i]['audit_log_operation'] = $vis_language['TXTTICKETPOSTSPLITWITH'].' '.$report[$i]['new_info'];
						}
						break;	
					case '27':
						$report[$i]['audit_log_operation'] = $vis_language['TXTCHANNELCHANGEDFROM'].' '.$report[$i]['old_info'].' '.strtolower($vis_language['TXTTO']).' '.$report[$i]['new_info'];
						break;
					case '28':
						$report[$i]['audit_log_operation'] = $report[$i]['old_info'].' '.strtolower($vis_language['TXTUNLINKEDFROM']).' '.$report[$i]['new_info'];
						break;	
					case '29':
						$report[$i]['audit_log_operation'] = $vis_language['TXTSET'].' '.$report[$i]['new_info'].' '.strtolower($vis_language['TXTLABEL']);
						break;	
					case '30':
						$report[$i]['audit_log_operation'] = $vis_language['TXTPINNED'].' '.$report[$i]['old_info'];
						break;
					case '31':
						$report[$i]['audit_log_operation'] = $vis_language['TXTREMOVEDLABEL'].' '.$report[$i]['new_info'];
						break;
					case '32':
						$report[$i]['audit_log_operation'] = ($report[$i]['channel_id']==7)? $vis_language['MSGSERVICEPROPERTYUPDATED']:$vis_language['MSGTICKETPROPERTYUPDATED'];
						break;
					case '33':
						$report[$i]['audit_log_operation'] = ($report[$i]['channel_id']==7)? $vis_language['MSGSERVICENOTEADDED']:$vis_language['MSGTICKETNOTEADDED'];
						break; 
					case '34':
						$report[$i]['audit_log_operation'] = ($report[$i]['channel_id']==7)? $vis_language['MSGSERVICENOTEDELETED']:$vis_language['MSGTICKETNOTEDELETED'];
						break;
					case '35':
						$report[$i]['audit_log_operation'] = ($report[$i]['channel_id']==7)? $vis_language['MSGSERVICECOMMENTADDED']:$vis_language['MSGTICKETCOMMENTADDED'];
						break;
					case '36':
						$report[$i]['audit_log_operation'] = ($report[$i]['channel_id']==7)? $vis_language['MSGSERVICECOMMENTDELETED']:$vis_language['MSGTICKETCOMMENTDELETED'];  
						break;
					case '37':
						$report[$i]['audit_log_operation'] = ($report[$i]['channel_id']==7)? $vis_language['MSGSERVICECPOSTUPDATED']:$vis_language['MSGTICKETPOSTUPDATED'];
						break;
					case '38':
						$report[$i]['audit_log_operation'] = $vis_language['MSGADDEDNEWRECIPIENT'].' '.$report[$i]['new_info'];
						break;
					case '39':
						$report[$i]['audit_log_operation'] = $vis_language['MSGADDEDNEWPEOPLE'].' '.$report[$i]['new_info'];
						break;
					case '40':
						$report[$i]['audit_log_operation'] = $vis_language['MSGREMOVEDRECIPIENT'].' '.$report[$i]['new_info'];
						break;
					case '41':
						$report[$i]['audit_log_operation'] = $vis_language['MSGREMOVEDPEOPLE'].' '.$report[$i]['new_info'];
						break;
					case '42':
						$report[$i]['audit_log_operation'] = $vis_language['MSGADDEDNEWTAG'].' '.$report[$i]['new_info'];
						break;
					case '43':
						$report[$i]['audit_log_operation'] = $vis_language['MSGREMOVEDTAG'].' '.$report[$i]['new_info'];
						break;
					case '44':
						$report[$i]['audit_log_operation'] = $vis_language['MSGNEWSCHEDULETKTCRT'];
						break;
					case '45':
						if($report[$i]['channel_id']==7){
							$report[$i]['audit_log_operation']=($report[$i]['old_info'] == '')?$vis_language['TXTITILREQUESTSERVICE'].' '.lcfirst($vis_language['TXTLEVELCHANGE']).' '. $report[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $report[$i]['new_info']:$vis_language['TXTITILREQUESTSERVICE'].' '.strtolower($vis_language['MSGLEVELCHANGEDFROM']).' '. $report[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $report[$i]['new_info'];
							}else{
						$report[$i]['audit_log_operation'] = ($report[$i]['old_info'] == '')?$vis_language['MSGTICKETLEVELCHANGED'].' '.$report[$i]['old_info'].' '.strtolower($vis_language['TXTTO']).' '.$report[$i]['new_info']:$vis_language['MSGTICKETLEVELCHANGED'].' '.strtolower($vis_language['TXTFROM']).' '.$report[$i]['old_info'].' '.strtolower($vis_language['TXTTO']).' '.$report[$i]['new_info'];
							}
						break;
					case '46':
						$report[$i]['audit_log_operation'] = ($report[$i]['old_info'] == '')?$vis_language['MSGTICKETCATEGORYCHANGED'].' '.$report[$i]['old_info'].' '.strtolower($vis_language['TXTTO']).' '.$report[$i]['new_info']:$vis_language['MSGTICKETCATEGORYCHANGED'].' '.strtolower($vis_language['TXTFROM']).' '. $report[$i]['old_info'].' '.strtolower($vis_language['TXTTO']).' '.$report[$i]['new_info'];
						break;
					case '47':
						$report[$i]['audit_log_operation'] = ($report[$i]['old_info'] == '')?$vis_language['MSGTICKETSUBCATEGORYCHANGED'].' '. $report[$i]['old_info'].' '.strtolower($vis_language['TXTTO']).' '.$report[$i]['new_info']:$vis_language['MSGTICKETSUBCATEGORYCHANGED'].' '.strtolower($vis_language['TXTFROM']).' '.$report[$i]['old_info'].' '.strtolower($vis_language['TXTTO']).' '.$report[$i]['new_info'];
						break;
					case '48':
						$report[$i]['audit_log_operation'] = ($report[$i]['old_info'] == '')?$vis_language['MSGTICKETITEMCHANGED'].' '.$report[$i]['old_info'].' '.strtolower($vis_language['TXTTO']).' '.$report[$i]['new_info']:$vis_language['MSGTICKETITEMCHANGED'].' '.strtolower($vis_language['TXTFROM']).'  '.$report[$i]['old_info'].' '.strtolower($vis_language['TXTTO']).' '.$report[$i]['new_info'];
						break;
					case '49':
						$report[$i]['audit_log_operation'] = ($report[$i]['old_info'] == '')?$vis_language['MSGITILLOCATIONCHANGED'].' '.$report[$i]['old_info'].' '.strtolower($vis_language['TXTTO']).' '.$report[$i]['new_info']:$vis_language['MSGITILLOCATIONCHANGED'].' '.strtolower($vis_language['TXTFROM']).' '.$report[$i]['old_info'].' '.strtolower($vis_language['TXTTO']).' '.$report[$i]['new_info'];
						break;
					case '50':
						$report[$i]['audit_log_operation'] = $vis_language['TXTSLAPAUSED'];
						break;
					case '51':
						$report[$i]['audit_log_operation'] = $vis_language['TXTSLARESUMED'];
						break;
					case '52':
						$report[$i]['audit_log_operation'] = ($report[$i]['channel_id']==7)? $vis_language['TXTREADSERVICEFORSTAFF']:$vis_language['TXTREADTICKETFORSTAFF'];
						break;
					case '53':
					
						if($report[$i]['channel_id']==7){
							$report[$i]['audit_log_operation'] = $vis_language['TXTSENDSERVICEAPPROVAL'].' '.strtolower($vis_language['TXTTO']).' '.$report[$i]['old_info'];
						}else{
							$report[$i]['audit_log_operation'] = $vis_language['TXTSENDTICKETAPPROVAL'].' '.strtolower($vis_language['TXTTO']).' '.$report[$i]['old_info'];
						}

						break;
					case '54':
						if($report[$i]['channel_id']==7){
							$report[$i]['audit_log_operation'] = $vis_language['TXTCHANGESERVICEAPPROVALSTATUS'].' '.strtolower($vis_language['TXTBY']).' '.$report[$i]['old_info'];
						}else{
							$report[$i]['audit_log_operation'] = $vis_language['TXTCHANGETICKETAPPROVALSTATUS'].' '.strtolower($vis_language['TXTBY']).' '.$report[$i]['old_info'];
						}
						break;
					case '55':
					if($report[$i]['channel_id']==7){
						$report[$i]['audit_log_operation'] = $vis_language['TXTSENDSERVICEAPPROVALREMINDER'].' '.strtolower($vis_language['TXTTO']).' '.$report[$i]['old_info'];
					}else{
						$report[$i]['audit_log_operation'] = $vis_language['TXTSENDTICKETAPPROVALREMINDER'].' '.strtolower($vis_language['TXTTO']).' '.$report[$i]['old_info'];
					}
						break;
					case '56':
					if($report[$i]['channel_id']==7){
						$report[$i]['audit_log_operation'] = $vis_language['MSGCUSTOMESERFIELDDATAMODIFIED'].' '.strtolower($vis_language['TXTBY']).' '.$report[$i]['old_info'];
					}else{
						$report[$i]['audit_log_operation'] = $vis_language['MSGCUSTOMEFIELDDATAMODIFIED'].' '.strtolower($vis_language['TXTBY']).' '.$report[$i]['old_info'];
						 }
						break;
					case '57':
					if($report[$i]['channel_id']==7){
						$report[$i]['audit_log_operation'] = $vis_language['MSGCUSTOMESERFIELDDATAMODIFIED'].' '.strtolower($vis_language['TXTBY']).' '.$report[$i]['old_info'];
					}else{
						$report[$i]['audit_log_operation'] = $vis_language['MSGCUSTOMEFIELDDATAMODIFIED'].' '.strtolower($vis_language['TXTBY']).' '.$report[$i]['old_info'];
					}
						break;
					case '58':
						$report[$i]['audit_log_operation'] = $report[$i]['new_info'];
						break;
					case '59':
						$report[$i]['audit_log_operation'] = $vis_language['TXTCHANGEURGENCY'].' '.$report[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '.$report[$i]['new_info'];
						break;
					case '60':
						$report[$i]['audit_log_operation'] = $vis_language['TXTCHANGEIMPACT'].' '.$report[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '.$report[$i]['new_info'];
						break;
					case '61':
						$report[$i]['audit_log_operation'] = $vis_language['TXTADDED'].' '.strtolower($vis_language['TXTJUSTPRIORITYCHNG']).' - '.$report[$i]['new_info'];
						break;
					case '62':
						$report[$i]['audit_log_operation'] = $vis_language['TXTSYMPTONS'].' '.strtolower($vis_language['TXTADDED']).' - '.$report[$i]['new_info'];
						break;
					case '63':
						if($report[$i]['channel_id']==7){
						$report[$i]['audit_log_operation'] = $vis_language['TXTCLONE'].' '.strtolower($vis_language['TXTITILREQUESTSERVICE']).' '.strtolower($vis_language['TXTFROM']).' '.$report[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '.$report[$i]['new_info'];
						}else{
						$report[$i]['audit_log_operation'] = $vis_language['TXTCLONE'].' '.strtolower($vis_language['TXTTICKET']).' '.strtolower($vis_language['TXTFROM']).' '.$report[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '.$report[$i]['new_info'];
						} 
						break;
					case '64':
						$report[$i]['audit_log_operation'] = $vis_language['TXTADDED'].' '.strtolower($vis_language['TXTDTSIMPACTCHNG']).' - '.$report[$i]['new_info'];
						break;
					case '65':
						$report[$i]['audit_log_operation'] = $vis_language['TXTNEWRELATTACHED'].' '. $report[$i]['old_info'];
						break;
					case '66':
						$report[$i]['audit_log_operation'] = $vis_language['TXTDETTACHATTACHREL'].' '. $report[$i]['old_info'];
						break;
					case '67':
						if($report[$i]['old_info']!='')
						$report[$i]['audit_log_operation'] =$vis_language['TXTLIFECYCLESTAGE'].' '. strtolower($vis_language['TXTUPDATED'].' '. $vis_language['TXTFROM']).' '.$report[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $report[$i]['new_info'];
						else
						$report[$i]['audit_log_operation'] =$vis_language['TXTLIFECYCLESTAGE'].' '. strtolower($vis_language['TXTUPDATED']).' - '.$report[$i]['new_info'];
						break;
				}
			}

			/*$serid=""; $removrow=array();
			$jj = 0;
			foreach ($report as $ii){
				foreach ($ii as $key => $value) {
			   		if ($key == 'audit_log_operation_skip' && $value=='removesla') {
			      	  unset($report[$jj]);
			    	}
				}
				$jj++;
			}
			$report = array_values($report);*/
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {				
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$operators=array(1=>$vis_language['TXTCLIENT'], 2=>$vis_language['TXTSTAFF'], 3=>$vis_language['TXTSTAFF']);			
				if($report_count!=0){
					$j = 0;
					foreach ($report as $i){
						foreach ($i as $key => $val) {
							if ($key == 'ticket_hash') {
								$report_exp[$j]['ticket_hash'] = $val; 
							} elseif ($key == 'creation_date') {
								$report_exp[$j]['creation_date'] = format_datetime_rpt($val,$staff_id);
							}elseif ($key == 'entry_date') {
								$report_exp[$j]['entry_date'] = format_datetime_rpt($val,$staff_id);
							} elseif ($key == 'audit_log_operation' ) {
								$report_exp[$j]['operation'] = $val;
							} elseif ($key == 'audit_log_operation_skip' ) {
								$report_exp[$j]['audit_log_operation_skip'] = $val;
							} elseif ($key == 'department_name') {
								$report_exp[$j]['department_name'] = $val;
							}	elseif ($key == 'domain') {
								$report_exp[$j]['domain'] = $val;
							}													
						} 							
							$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash'];
							$report_exp1[$j]['domain'] = $report_exp[$j]['domain'];
							$report_exp1[$j]['department'] = $report_exp[$j]['department_name'];
							$report_exp1[$j]['creation_date'] = $report_exp[$j]['creation_date'];
							$report_exp1[$j]['operation_date'] = $report_exp[$j]['entry_date'];
							$report_exp1[$j]['operation'] = $report_exp[$j]['operation'];
							
						$j++;					

					}
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				
				$filename=$this->export_subreport($operation,$report_exp1);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				} else {
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else{
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function performance_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTSTAFFAVGRESPONSETIME'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type = 4;
		$export = 1;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object       = new class_ticket($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$staff            = $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
		$object_staff  = new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']);
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='performance_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		$service='';
		$data=array();
		if((isset($operation['vis_action']) && $operation['vis_action']!='') || isset($operation['vis_submit']) && $operation['vis_submit']!='')
		{
			if(isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['staff_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['staff_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTSTAFF']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['staff_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.'  and '.VIS_TABLE_PREFIX.'ticket.client_id!=0 ';if($data['service_id']==3)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id=0';}
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				
				$filter = VIS_TABLE_PREFIX.'ticket.receive_date between '.$from.' AND '.$to.' and (operator=1 or (operator=2 and (operator_id='.$data['staff_id'].' or operator_id!='.$data['staff_id'].'))) and ('.VIS_TABLE_PREFIX.'auditlog.operation_id <=2 or '.VIS_TABLE_PREFIX.'auditlog.operation_id=50 or '.VIS_TABLE_PREFIX.'auditlog.operation_id = 51 or '.VIS_TABLE_PREFIX.'auditlog.operation_id=13)';
				$filter .= ' and ' .VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and ' .VIS_TABLE_PREFIX.'ticket.is_spam!=1'.$service; 
			 	//$filter .= ' and avis_ticket.ticket_id=6';
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object       = new class_report($database);
			$total_post   = $total_time = $reply_count = $submitter = 0;//$maintain_date_nw1 =0;$maintain_date_nw = 0;
			$total_ticket = array();
			$temp_filter1 = explode("operator_id=",$filter);
			$temp_filter = explode('or',$temp_filter1[1]);
			$selectstaffid = trim($temp_filter[0]);
			if(isset($data['staff_id']) && $data['staff_id']!=''){ $data['staff_id']; }else{ $selectstaffid; }
			
			$get_domains = $tkt_object->get_domain('', $staff_id, VIS_LOCATION_AREA);
			$domains = '';
			for($m=0;$m<count($get_domains);$m++){
				$domains .= $get_domains[$m]['domain_id'].',';
			}
			$domains = substr($domains, 0, -1);
			$filter .= ' and ' .VIS_TABLE_PREFIX.'ticket.domain_id IN ('.$domains.') ';
			
			list($total, $post_details) = $object->get_staff_performance_report($filter, '', $staff_id, VIS_LOCATION_AREA);
			//echo "<pre>"; print_r($post_details);
			$avgtotrepltime=$array_summary=array();
			$previous_replier = $first_staffreplytime = $ticket_id = $submitter = 0; $old_ticket_id=0;
			$totareplyno=$maintain_date_nw1=$maintain_date_nw=$old_ticket_id=$last_oprationid =0;$old_ticket_id_old = $repflag =  $clientreply = 0;
			$tititiit=0;
			$replied_ticket_cnttttt=0;
			$tot_ticket_avg_time_cnt=0; 
			$old_ticket_id_old = 0;
			$maintain_date = 0;
			$staff_ticket=array();
			$report_new = $tkt_reply_cnt = array();
			
			if($post_details!=-1){
				for($i=0;$i<count($post_details);$i++){ 
					if($old_ticket_id_old != $post_details[$i]['ticket_id']){
						$maintain_date_nw1 = $submitter= $maintain_date_nw = 0;
						$report[$post_details[$i]['ticket_id']]['post_date']=0;
						$report[$post_details[$i]['ticket_id']]['count']=0;
						$tkt_reply_cnt = array();
						$repflag=0;
						$clientreply=0;
						$as_client_or_clientticket=0;
					}
					 
					if($post_details[$i]['operation_id']==13)	{   
							if(!isset($report[$post_details[$i]['ticket_id']]['customsla'])){
								$report[$post_details[$i]['ticket_id']]['customsla']=1;	
							} 
							else{
								$report[$post_details[$i]['ticket_id']]['customsla']++;	
							}  
								$report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date'];
					}
					 
					$report[$post_details[$i]['ticket_id']]['timestamp'] = 0; 
					if( $post_details[$i]['operation_id']==0 && $post_details[$i]['as_client']==1)$clientreply++;
					if($post_details[$i]['operation_id']==0 && $post_details[$i]['operator']==1 ){   
						$report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date'];
						$submitter = $post_details[$i]['operator'];
						$clientreply++;
						$as_client_or_clientticket=1;
					}else if($post_details[$i]['operation_id']==1 && $post_details[$i]['operator']==1) {  
						if(($submitter == $post_details[$i]['operator'] || ($post_details[$i]['as_client']==1 && $submitter == 2)) && $last_oprationid == 0){
							$report[$post_details[$i]['ticket_id']]['post_date'] = $report[$post_details[$i]['ticket_id']]['post_date'];
						}else{  
							$report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date']; 
						} 
					 	if($old_ticket_id == $post_details[$i]['ticket_id'] && $clientreply > 0){ 
					 		$maintain_date_nw1 = $maintain_date_nw;  }else { $maintain_date_nw1=0; } 
						$clientreply++;
						$as_client_or_clientticket=1;
					} else if($post_details[$i]['operation_id']==50){
						$report[$post_details[$i]['ticket_id']]['pause_date']=$post_details[$i]['entry_date'];
					} else if($post_details[$i]['operation_id']==51){
						$report[$post_details[$i]['ticket_id']]['resume_date']=$post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['slapause_diff'] += $post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['pause_date'];
					} else if($post_details[$i]['operation_id']==1 && $post_details[$i]['operator']!=1){ 
						 if($selectstaffid == $post_details[$i]['operator_id']){ 
							$staff_ticket[]=$post_details[$i]['ticket_id'];
							if($post_details[$i]['as_client'] == 1){
								$as_client_or_clientticket=1; 
							}
							$report[$post_details[$i]['ticket_id']]['post_date']=(isset($report[$post_details[$i]['ticket_id']]['post_date']))?$report[$post_details[$i]['ticket_id']]['post_date']:0; 
							$maintain_date = $post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['post_date'];
							if($report[$post_details[$i]['ticket_id']]['post_date'] > 0)
							{
							$maintain_date_nw = $post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['post_date'];
							}
							$maintain_date_nw = $maintain_date_nw + $maintain_date_nw1;
							
							$report[$post_details[$i]['ticket_id']]['post_date']=(isset($post_details[$i]['entry_date']))?$post_details[$i]['entry_date']:0;  
							if($old_ticket_id == $post_details[$i]['ticket_id'] && $clientreply > 0){ 
								$maintain_date_nw1 = $maintain_date_nw; }else { $maintain_date_nw1=0; } 
							if($maintain_date_nw!=0){
								$report[$post_details[$i]['ticket_id']]['count']++;
								if($clientreply > 0){
									$maintain_date_nw = $maintain_date_nw; }else{ 
									$maintain_date_nw = 0;
								}
								/*if($as_client_or_clientticket==0){ 
									$report[$post_details[$i]['ticket_id']]['count']=$report[$post_details[$i]['ticket_id']]['count']-1; 
								}*/
							} 
						} else { 
							if($old_ticket_id != $post_details[$i]['ticket_id']) { $maintain_date_nw1=$maintain_date_nw=0;  } 
							//$report[$post_details[$i]['ticket_id']]['post_date']=$post_details[$i]['entry_date'];
							$maintain_date_nw += 0; 
							if(isset($report[$post_details[$i]['ticket_id']]['count'])){ $report[$post_details[$i]['ticket_id']]['count']+=0; }
						} 		 

						
						$submitter = $post_details[$i]['operator'];
						$total_post++; 
					}	
						if($old_ticket_id>0 && $old_ticket_id == $post_details[$i]['ticket_id'] ){
						   $tkt_reply_cnt[$old_ticket_id] = $report[$post_details[$i]['ticket_id']]['count'];
							 }
						if(count($tkt_reply_cnt)>0){ 
							foreach($tkt_reply_cnt as $key=>$value)
							{
								if($key == $old_ticket_id && $value>0) 
								$repflag = 1;

							}
						}	
						$old_ticket_id = $post_details[$i]['ticket_id'];	
					$last_oprationid = $post_details[$i]['operation_id']; $old_ticket_id_old = $post_details[$i]['ticket_id'];
					if (!isset($report[$post_details[$i]['ticket_id']]['start_time'])) { 
						$report[$post_details[$i]['ticket_id']]['ticket_hash']		= $post_details[$i]['ticket_hash'];
						$report[$post_details[$i]['ticket_id']]['subject']			= $post_details[$i]['subject'];
						$report[$post_details[$i]['ticket_id']]['ticket_entry']		= $post_details[$i]['receive_date'];
						$report[$post_details[$i]['ticket_id']]['start_time']		= $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['ticket_priority']	= $post_details[$i]['ticket_priority'];
						$report[$post_details[$i]['ticket_id']]['department_name']	= $post_details[$i]['department_name'];
						$report[$post_details[$i]['ticket_id']]['first_name']		= $post_details[$i]['first_name'];
						$report[$post_details[$i]['ticket_id']]['last_name']		= $post_details[$i]['last_name'];
						$report[$post_details[$i]['ticket_id']]['email']			= $post_details[$i]['email'];
						$report[$post_details[$i]['ticket_id']]['group_name']		= $post_details[$i]['group_name'];
						$report[$post_details[$i]['ticket_id']]['ticket_id']		= $post_details[$i]['ticket_id'];
						$report[$post_details[$i]['ticket_id']]['post_date']		= $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['operator']			= $post_details[$i]['operator'];
						$report[$post_details[$i]['ticket_id']]['as_client']	  	= $post_details[$i]['as_client'];
						$report[$post_details[$i]['ticket_id']]['applyslaresol_time'] = $post_details[$i]['applyslaresol_time'];
						$report[$post_details[$i]['ticket_id']]['slaplan_id'] 		= $post_details[$i]['slaplan_id'];
						$report[$post_details[$i]['ticket_id']]['due_time'] 		= $post_details[$i]['due_time'];
						$report[$post_details[$i]['ticket_id']]['last_replier_time'] = $post_details[$i]['last_replier_time'];
						$report[$post_details[$i]['ticket_id']]['pause_dtime'] 		= $post_details[$i]['pause_dtime'];
						$report[$post_details[$i]['ticket_id']]['slapause_diff'] 	= 0;
						$report[$post_details[$i]['ticket_id']]['maintain_date'] 	= 0;
						$report[$post_details[$i]['ticket_id']]['count']         	= 0;
						$total_post= 0;
						$report[$post_details[$i]['ticket_id']]['avg_time'] = 0;
					} elseif($post_details[$i]['old_info']!=''){

						 
						$total_sla_seconds = ($post_details[$i]['due_time'] - $report[$post_details[$i]['ticket_id']]['post_date']);
						//$sla_response_time = round($report[$post_details[$i]['ticket_id']]['maintain_date']);
						$report[$post_details[$i]['ticket_id']]['ticket_id'];
						$sla_response_time = round($maintain_date_nw);
						$report[$post_details[$i]['ticket_id']]['used_sla_seconds'] = $sla_response_time;
						$report[$post_details[$i]['ticket_id']]['timestamp'] = $sla_response_time;
						$report[$post_details[$i]['ticket_id']]['avg_time'] = $sla_response_time;
						$report[$post_details[$i]['ticket_id']]['clientreplycnt']   = $clientreply;
						$post_details[$i]['ticket_id'];
						$submitter = $post_details[$i]['operator'];
						$total_time += $sla_response_time;
					}
					// calculate response time
						if($report[$post_details[$i]['ticket_id']]['slaplan_id']== '0' && $report[$post_details[$i]['ticket_id']]['due_time']== 0){
							$report[$post_details[$i]['ticket_id']]['response_sla'] = $vis_language['MSGNOTAPPLICABLE'];
						}else { 
							if($report[$post_details[$i]['ticket_id']]['pause_dtime']!=''){ 
								$report[$post_details[$i]['ticket_id']]['response_sla'] = $vis_language['TXTNOTMAINTAIN'];
							}else {
								if($report[$post_details[$i]['ticket_id']]['due_time'] != '0'){
									if($report[$post_details[$i]['ticket_id']]['ticket_entry'] == $report[$post_details[$i]['ticket_id']]['last_replier_time']){ 
									if($report[$post_details[$i]['ticket_id']]['operator']==2 && $report[$post_details[$i]['ticket_id']]['count']==0 && $report[$post_details[$i]['ticket_id']]['as_client']!=1){ 
											$report[$post_details[$i]['ticket_id']]['response_sla'] = $vis_language['TXTMAINTAIN'];
										}elseif($report[$post_details[$i]['ticket_id']]['count']==0 && ($report[$post_details[$i]['ticket_id']]['as_client']==1 || $report[$post_details[$i]['ticket_id']]['operator']==1)){
											$report[$post_details[$i]['ticket_id']]['response_sla'] = $vis_language['TXTNOTRESPONDED'];
										}else{
											$report[$post_details[$i]['ticket_id']]['response_sla'] = $vis_language['TXTNOTMAINTAIN'];
										} 
									}else{ 
									$resolve_time = $report[$post_details[$i]['ticket_id']]['due_time'] - $report[$post_details[$i]['ticket_id']]['last_replier_time'];
									if($resolve_time < 0 && $clientreply>0){ 
										$report[$post_details[$i]['ticket_id']]['response_sla'] = $vis_language['TXTNOTMAINTAIN'];
									}else
									{  if($repflag==1)
										$report[$post_details[$i]['ticket_id']]['response_sla'] = $vis_language['TXTMAINTAIN'];
										else
										$report[$post_details[$i]['ticket_id']]['response_sla'] = $vis_language['TXTNOTRESPONDED'];}
									
									}
								}else { 
									$report[$post_details[$i]['ticket_id']]['response_sla'] = $vis_language['TXTNOTMAINTAIN'];
								}
							}							
						} 
				}//}
				//  echo "<pre>"; print_r($report);
				if(!isset($operation['vis_export']) || $operation['vis_export'] != 1){	
					foreach (array_slice($report, $limit, $view_info['page_count']) as $p){
						$report_new[] = $p;
					}
				}
				 if(!empty($staff_ticket)){
				$staff_ticket1=array_unique($staff_ticket);
				$report_new1 = array();
				foreach($report as $ticket_id => $details){
					if(in_array($details['ticket_id'], $staff_ticket1))$report_new1[]=$details;
				}				
				$report_new = array();
				$report = array();
				$report = $report_new1;
				$total=($report!=-1) ? count($report) : 0;
				foreach (array_slice($report, $limit, $view_info['page_count']) as $p) {
					$report_new[] = $p;
				}
			  }else{
				$report = -1;
				$report_new = -1;
			  }
			} else {
				$report = -1;
				$report_new = -1;
			}
			$view_info['page']=$page;
			$report_count=($report_new!=-1) ? count($report_new) : 0; 
			$view_info['page_count']=(($report)==-1)? 0 : ceil(count($report)/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			 //echo "<pre>";print_r($report);
			if(isset($operation['vis_export']) && $operation['vis_export'] == 1){
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				$total_post_count = $avgTimeCount = $replied_ticket_cnt = 0;
				foreach ($report as $i) {
					foreach ($i as $key => $val) {
						if ($key == 'ticket_hash' || $key == 'subject'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'ticket_entry'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);  
						} elseif ($key == 'first_name' || $key == 'last_name' || $key == 'email' || $key == 'group_name' || $key == 'response_sla'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'avg_time'){
							if ($val != 0){
								$report_exp[$j]['avg_response_time'] = (($val)/$i['count']);
							} else {
								$report_exp[$j]['avg_response_time'] = '0 S';
							}
						} elseif ($key == 'clientreplycnt'){
							$report_exp[$j][$key] = $val;
						}
					}
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['client_name']= $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email']= $report_exp[$j]['email'];
					$report_exp1[$j]['organization']= $report_exp[$j]['group_name'];
					$report_exp1[$j]['creation_date'] = $report_exp[$j]['ticket_entry'];
					$report_exp1[$j]['clientreplycnt'] = $report_exp[$j]['clientreplycnt'];
						if($i['count']==0){
						if($i['operator'] == 2 && $i['as_client'] != 1){
							$report_exp1[$j]['avg_response_time']=  '0 S';
						}else{
							$report_exp1[$j]['avg_response_time']= $vis_language['TXTNOTRESPONDED'];
						}
					} else {
						$report_exp1[$j]['avg_response_time']= count_remain_time(round($report_exp[$j]['avg_response_time']));
					}
					if($report_exp1[$j]['clientreplycnt']==0) {$report_exp1[$j]['avg_response_time'] = '0 S';}
					if($report_exp1[$j]['clientreplycnt']!=0){
						$avgTimeCount += round($report_exp[$j]['avg_response_time']);
					}else{
						$avgTimeCount +=0;
					}
					
					if($i['count']!=0){
						$replied_ticket_cnt++;
					}
					$report_exp1[$j]['response_sla']=$report_exp[$j]['response_sla'];
					$j++;
					$total_post += $i['count'];
					$total_post_count += $i['count'];
				}
				if($report!=-1) {
				$total_ticket_cnt=count($total_ticket);
				//$avgTimeCount =count_remain_time($avgTimeCount);
				if($replied_ticket_cnt==0){ $avgTimeCount=0; }
				else{ $avgTimeCount =count_remain_time(round($avgTimeCount/$replied_ticket_cnt)); }
					$report_exp1[$j]['total_post']=$vis_language['TXTTOTALPOSTCOUNT'].' :'.$total_post_count;
					$report_exp1[$j]['total_incident_cnt']=$vis_language['TXTTOTALTICKETSREPLIED'].' :'.$replied_ticket_cnt;
					$report_exp1[$j]['avgTimeCount']=$vis_language['TXTTOTALAVGRESPONSETIME'].' :'.($avgTimeCount==0 ? '0' : (($avgTimeCount > 0) ? $avgTimeCount : '0 S'));
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if(!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
			if($report!=-1) {
				$counter=0;
				$total_time=0;
				$replied_ticket_cnt = 0;
				$total_post_count = 0;
				foreach($report as $ticket_id => $details) {
					$counter++; 
					if(isset($details['slapause_diff'])){ $sla_diff = $details['slapause_diff'];}else{ $sla_diff = 0;}   
						$total_post_count += $details['count'];  
					if($details['count']!=0){
						$replied_ticket_cnt+=1;
						if($details['clientreplycnt']!=0){
							$total_time += (($details['timestamp']-$sla_diff)/$details['count']); ///$details['count'];
						}else{
							$total_time +=0;
						}
					}
				} 
			    if($replied_ticket_cnt==0)
				{
					$avgTimeCount=0;
				}else{
					$avgTimeCount =count_remain_time(round($total_time/$replied_ticket_cnt));
				}	 
				$array_summary['TXTTOTALPOSTCOUNT']=$total_post_count;
				$array_summary['TXTTOTALTICKETSREPLIED']=$replied_ticket_cnt;
				$array_summary['TXTTOTALAVGRESPONSETIME']=($avgTimeCount==0 ? '0' :(($avgTimeCount > 0) ? $avgTimeCount : '0 S'));
			}

				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>str_replace(["\n","\r"],"",$report_list),'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function staff_resolution_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTSTAFFAVGRESOLUTIONTIME'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type = 150;//4;
		$export = 1;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object       = new class_ticket($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$staff            = $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
		$object_staff  = new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='staff_resolution_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		$service='';
		if((isset($operation['vis_action']) && $operation['vis_action']!='') || isset($operation['vis_submit']) && $operation['vis_submit']!='')
		{
			if(isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['staff_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['staff_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTSTAFF']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['staff_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';if($data['service_id']==3)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id=0';}
				$dates=$this->getdates(1,$database);
				 
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				$currentdate = date('Y-m-d H:i:s');
				 
				if ($data['duration'] == 1){ //if select Last 30 days duration
				  $from = $dates['thirty_day'];;
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					 $from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				} else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'auditlog.entry_date between '.$from.' AND '.$to.' and operator=2 and operator_id='.$data['staff_id'].' and '.VIS_TABLE_PREFIX.'auditlog.operation_id =2 and ' .VIS_TABLE_PREFIX.'ticket.is_deleted =0 and ' .VIS_TABLE_PREFIX.'ticket.is_spam=0 and ' .VIS_TABLE_PREFIX.'ticket.draft_id=0 and ('.VIS_TABLE_PREFIX.'ticket.status_id=3 or '.VIS_TABLE_PREFIX.'ticket.status_id=4)'.$service;
				$get_domains = $tkt_object->get_domain('', $data['staff_id'], VIS_LOCATION_AREA);
				$domains = '';
				for($m=0;$m<count($get_domains);$m++){
					$domains .= $get_domains[$m]['domain_id'].',';
				}
				$domains = substr($domains, 0, -1);
				$filter .= ' and ' .VIS_TABLE_PREFIX.'ticket.domain_id IN ('.$domains.')';
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object       = new class_report($database); 
			list($total_cnt1, $post_details1) = $object->get_staff_resolution_report($filter, '', $staff_id, VIS_LOCATION_AREA);			
			list($total_cnt, $post_details) = $object->get_staff_resolution_report($filter, $limit, $staff_id, VIS_LOCATION_AREA);
			$tot_resolve_time = 0;
			$report = $report1 = array();
			if($post_details != -1){
				for ($i=0;$i<count($post_details1);$i++) {
						$report1[$post_details1[$i]['ticket_id']]['resoltion_time'] 	= ($post_details1[$i]['entry_date'] - $post_details1[$i]['receive_date']);
				}
				for($i=0;$i<count($post_details);$i++){
					  
						$report[$post_details[$i]['ticket_id']]['ticket_hash']		= $post_details[$i]['ticket_hash'];
						$report[$post_details[$i]['ticket_id']]['subject']			= $post_details[$i]['subject'];
						$report[$post_details[$i]['ticket_id']]['ticket_entry']		= $post_details[$i]['receive_date'];
						$report[$post_details[$i]['ticket_id']]['start_time']		= $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['ticket_priority']	= $post_details[$i]['ticket_priority'];
						$report[$post_details[$i]['ticket_id']]['department_name']	= $post_details[$i]['department_name'];
						$report[$post_details[$i]['ticket_id']]['first_name']		= $post_details[$i]['first_name'];
						$report[$post_details[$i]['ticket_id']]['last_name']		= $post_details[$i]['last_name'];
						$report[$post_details[$i]['ticket_id']]['email']			= $post_details[$i]['email'];
						$report[$post_details[$i]['ticket_id']]['group_name']		= $post_details[$i]['group_name'];
						$report[$post_details[$i]['ticket_id']]['post_date']		= $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['ticket_id']		= $post_details[$i]['ticket_id'];
						$report[$post_details[$i]['ticket_id']]['operator']			= $post_details[$i]['operator'];
						$report[$post_details[$i]['ticket_id']]['as_client']	  	= $post_details[$i]['as_client'];
						$report[$post_details[$i]['ticket_id']]['resoltion_time'] 	= ($post_details[$i]['entry_date'] - $post_details[$i]['receive_date']);
				} 
			} else{
				$report = -1; 
			}
			if ($report1 != -1) { 
				foreach ($report1 as $ticket_id => $details) { 
					$tot_resolve_time +=  $details['resoltion_time']; 
				}
			}
			$view_info['page']=$page;
			$report_count=($report!=-1) ? count($report) : 0;  
			$avg_resolve_time	= ($report!=-1) ?count_remain_time(($tot_resolve_time/$total_cnt)): 0; 
			$view_info['page_count']=($report==-1)? 0 : ceil($total_cnt/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			$total = $total_cnt;
			$array_summary=array();
			$array_summary['TOTALCLOSEDRESOLVEDTICKET']=$total;
			$array_summary['TOTALAVGRESOLUTION']=$avg_resolve_time; 
			if(isset($operation['vis_export']) && $operation['vis_export'] == 1){
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				$total_post_count = $avgTimeCount = $replied_ticket_cnt = 0;
				foreach ($report as $i) {
					foreach ($i as $key => $val) {
						if ($key == 'ticket_hash' || $key == 'subject'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'ticket_entry'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);  
						} elseif ($key == 'first_name' || $key == 'last_name' || $key == 'email' || $key == 'group_name'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'resoltion_time'){
							$report_exp[$j][$key] = $val; 
						}
					}
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['client_name']= $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email']= $report_exp[$j]['email'];
					$report_exp1[$j]['organization']= $report_exp[$j]['group_name'];
					$report_exp1[$j]['creation_date'] = $report_exp[$j]['ticket_entry'];
					$report_exp1[$j]['resolution_time'] = count_remain_time($report_exp[$j]['resoltion_time']);
					$j++;
				}
				if($report!=-1){
					$report_exp1[$j]['summary'] = $vis_language['TXTSUMMARY'];
					foreach($array_summary as $key=>$val){ 
							$title=explode(' ',$key);
							$title[1]=isset($title[1])?''.$title[1]:'';						
					 $report_exp1[$j][$vis_language[$title[0]].' '.$title[1]]=$vis_language[$title[0]].' '.$title[1].' : '.$val; 
					}
				}
				  
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);	
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if(!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>str_replace(["\n","\r"],"",$report_list),'total_count'=>$total_cnt,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function time_tracking_staff_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTTRACKINGSTAFF'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();

		$export      = 1;
		$report_type = 9;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
		$object_staff  = new class_staff($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='time_tracking_staff_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		$staff_filter  = "staff_id =" . $staff_id;
		$staff_details = $object_staff->get_staff($staff_filter, $staff_id, VIS_LOCATION_AREA);
		$staff_details= $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA, '', '', ' and staff_id='.$staff_id);
		$dept_access = $staff_details[0]['department_access'];
		if($dept_access == -2)
		{			
			$team_access = $staff_details[0]['group_id'];
			$department_team_wise_details= $object_staff->get_department_team_wise($team_access);
			$team_wise_dept_access = $department_team_wise_details[0]['department_access'];
			$dept_access_filter = ($team_wise_dept_access!=0) ? ' and department_access IN ('.$team_wise_dept_access.')' : ''; 
		}
		else
		{
			$dept_access_filter = ($dept_access!=0) ? ' and department_access IN ('.$dept_access.')' : '';
		}
		//$staff= $tkt_object->get_staff_list('', VIS_LOCATION_AREA, '', '', $dept_access_filter);
		$staff= $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA, '', '', $dept_access_filter);
		$domain     = $tkt_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		if((isset($operation['vis_action']) && $operation['vis_action']!='') || isset($operation['vis_submit']) && $operation['vis_submit']!=''){
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
				$data = $operation;
				$temp_filter = explode("domain_id=",$filter);
				$dom_id = $temp_filter[1];
				$temp_filter1 = explode("AND",$dom_id);
				$dom_id = $temp_filter1[0];
				$domain_details = $tkt_object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id='.$dom_id, $data['staff_id'], VIS_LOCATION_AREA);
				$currency       = $domain_details[0]['currency'];
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['staff_id'] == 0 && $data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['staff_id'] == 0 && $data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTSTAFF']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['staff_id'] == 0 && $data['domain_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTSTAFF']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['staff_id'] != 0 && $data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['staff_id'] != 0 && $data['domain_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['staff_id'] != 0 && $data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$domain_details = $tkt_object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id=' . $data['domain_id'], $staff_id, VIS_LOCATION_AREA);
				$currency       = $domain_details[0]['currency'];
				include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
				$object_sett    = new class_setting($database);
				$module_setting = $object_sett->get_settings(' module_id=2 and title="vis_show_time_track_amount" and domain_id=' . $domain_details[0]['domain_id'], $staff_id, VIS_LOCATION_AREA);
				if (empty($module_setting) || $module_setting == -1) {
					$module_setting = $object_sett->get_settings(' module_id=2 and title="vis_show_time_track_amount" and domain_id=0', $staff_id, VIS_LOCATION_AREA);
				}
				$amountshowflag = 1;
				if ($module_setting != -1) {
					$amountshowflag = $module_setting[0]['content'];
				}
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = 'created_date between '.$from.' AND '.$to.' and staff_id='.$data['staff_id'].' and '.VIS_TABLE_PREFIX.'domain.domain_id='.$data['domain_id'];
			}
			$filter .= ' AND  '.VIS_TABLE_PREFIX.'ticket.is_deleted=0 AND '.VIS_TABLE_PREFIX.'ticket.is_spam=0 ';
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object          = new class_report($database);
			$total_bill_time = $total_work_time = $total_amount = 0;
			list($total_rec, $post_details) = $object->get_time_tracking_staff_report($filter, $limit, $data['staff_id'], $staff_id, VIS_LOCATION_AREA);
			$view_info['page']=$page;
			$report_count=($post_details!=-1)? count($post_details) : 0;
			$total_rec_cnt=($total_rec!=-1)? count($total_rec) : 0;
			$view_info['page_count']=($total_rec_cnt==0)?0:ceil($total_rec_cnt/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			if ($post_details != -1){
				for ($i = 0; $i < count($post_details); $i++) {
					$report[$i]['ticket_hash']     	= $post_details[$i]['ticket_hash'];
					$report[$i]['ticket_id']       	= $post_details[$i]['ticket_id'];
					$report[$i]['subject']     		= $post_details[$i]['subject'];
					$report[$i]['description']     	= $post_details[$i]['description'];
					$report[$i]['first_name']     	= $post_details[$i]['first_name'];
					$report[$i]['last_name']     	= $post_details[$i]['last_name'];
					$report[$i]['email']     		= $post_details[$i]['email'];
					$report[$i]['group_name']     	= $post_details[$i]['group_name'];
					$report[$i]['bill_time']       	= $post_details[$i]['bill_time'];
					$report[$i]['work_time']       	= $post_details[$i]['work_time'];
					$report[$i]['amount']          	= $post_details[$i]['amount'];
					$report[$i]['created_date']    	= $post_details[$i]['created_date'];
					$report[$i]['staff_name']      	= $post_details[$i]['staff_name'];
					$report[$i]['department_name'] 	= $post_details[$i]['department_name'];
					$total_bill_time += $post_details[$i]['bill_time'];
					$total_work_time += $post_details[$i]['work_time'];
					$total_amount += $post_details[$i]['amount'];
				} 
			} else {
				$report = -1;
			}
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				$min = $vis_language['TXTMIN'];
				foreach ($report as $i) {
					foreach ($i as $key => $val) {
						if ($key == 'ticket_hash'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'subject'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'created_date'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'work_time'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'bill_time'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'amount'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'description'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'staff_name'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'department_name'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'first_name' || $key == 'last_name' || $key == 'email' || $key == 'group_name'){
							$report_exp[$j][$key] = $val;
						}
					}
					$report_exp1[$j]['incident_hash']			= $report_exp[$j]['ticket_hash']; 
					$report_exp1[$j]['subject']					= $report_exp[$j]['subject'];
					$report_exp1[$j]['description']				= $report_exp[$j]['description'];
					$report_exp1[$j]['staff']					= $report_exp[$j]['staff_name']; 
					$report_exp1[$j]['client_name']				= $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email']					= $report_exp[$j]['email'];
					$report_exp1[$j]['organization']			= $report_exp[$j]['group_name'];
					$report_exp1[$j]['creation_date'] 			= $report_exp[$j]['created_date']; 
					$report_exp1[$j]['department_name'] 		= $report_exp[$j]['department_name'];
					$report_exp1[$j]['bill_time'.' ('.$min.')']	= $report_exp[$j]['bill_time'];
					$report_exp1[$j]['work_time'.' ('.$min.')']	= $report_exp[$j]['work_time'];
					$report_exp1[$j]['amount'.'('.$currency.')']= $report_exp[$j]['amount'];
					$j++;
				}
				if($report!=-1){
					$report_exp[$j]['total'] = '';
					$report_exp1[$j]['total_bill_time']   = $vis_language['TXTTOTALBILLTIME'].":". $total_bill_time . ' ' . $vis_language['TXTMIN'];
					$report_exp1[$j]['total_work_time']   = $vis_language['TXTTOTALWORKTIME'].":". $total_work_time . ' ' . $vis_language['TXTMIN'];
					$report_exp1[$j]['total_amount']      = $vis_language['TXTTOTALAMOUNT'].":".$total_amount . ' ' . $currency;
				}
				
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				$total_bill_time = 0;
				$total_work_time = 0;
				$total_amount	 = 0;
				$total = $total_rec_cnt;
				for($m = 0; $m < $total_rec_cnt; $m++){
					$total_bill_time += $total_rec[$m]['bill_time'];
					$total_work_time += $total_rec[$m]['work_time'];
					$total_amount	 += $total_rec[$m]['amount'];
				}
				$array_summary['TXTTOTALBILLTIME']=$total_bill_time.' ('.$vis_language['TXTMIN'].')';
				$array_summary['TXTTOTALWORKTIME']=$total_work_time.' ('.$vis_language['TXTMIN'].')';
				$array_summary['TXTTOTALAMOUNT']=number_format($total_amount,2).' '.$currency;

				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total_rec_cnt,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function staff_leaderboard_first_avgresponse_report($operation)
	{   
		global $vis_language;
		$report_title = $vis_language['TXTSTAFFLEADERFIRSTRESPONSE'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type = 83;
		$export = 1;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
		$object_staff  = new class_staff($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='staff_leaderboard_first_avgresponse_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		$filter     = VIS_TABLE_PREFIX.'domain.is_enabled=1';
		$domain     = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
		$staff_count      = $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA,$status='','');
		if(isset($operation['vis_export']) && $operation['vis_export'] == 1){ $limit = ''; 
		$admin_access=$object_staff->get_staff_access('staff_id='.$staff_id, $staff_id, VIS_LOCATION_AREA);
        if($admin_access!=-1){
            define('VIS_ADMIN_ACCESS_LEVEL',$admin_access[0]['level']);    
        }else{
            define('VIS_ADMIN_ACCESS_LEVEL','');    
        }
		}
		$staff_filter  = "staff_id =" . $staff_id;
		$staff_details = $object_staff->get_staff($staff_filter, $staff_id, VIS_LOCATION_AREA);
		$staff_details= $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA, '', '', ' and staff_id='.$staff_id);
		if(VIS_ADMIN_ACCESS_LEVEL==1){
          $dept_access_filter = '';
       }
       elseif(VIS_ADMIN_ACCESS_LEVEL==0 &&  VIS_ADMIN_ACCESS_LEVEL!=''){
          $dept_access_filter = ' and '.VIS_TABLE_PREFIX.'adminaccess.level ='.VIS_ADMIN_ACCESS_LEVEL;
       }else{
       	VIS_ADMIN_ACCESS_LEVEL;
          $dept_access_filter = ' and '.VIS_TABLE_PREFIX.'staff.staff_id ='.$staff_id;
       }		
		$staff_count= $tkt_object->get_staff_list_data($staff_id, VIS_LOCATION_AREA, '', '', $dept_access_filter);
		$staff= $tkt_object->get_staff_list_data($staff_id, VIS_LOCATION_AREA, '', $limit, $dept_access_filter);

		for($s=0;$s<count($staff);$s++){
			$staff_name = explode(' ', $staff[$s]['staff_name']);
			for($m=0;$m<count($staff_name);$m++){
				$staff[$s]['first_name'] = $staff_name[0];
				$staff[$s]['last_name'] = $staff_name[1];
			}
		}
		$departments      = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		if((isset($operation['vis_action']) && $operation['vis_action']!='') || isset($operation['vis_submit']) && $operation['vis_submit']!=''){
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);					
				
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['domain_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$service='';
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;}
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'ticket.receive_date between '.$from.' AND '.$to.' and '.VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX.'ticket.domain_id='.$data['domain_id'].$service .' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			list($totalTicksClosed,$count_details,$post_details) = $object->get_staff_leaderboard_report1($filter, $limit, $staff_id, VIS_LOCATION_AREA); 
			$report_avg      = 0;
			$report_cnt      = 0;
			$resolutionCount = $responseCount = 0;
			$totalclose      = 0;
			$replied         = array();
			$report  = array();
			$avgFirstresponse=0;				
			$view_info['page']=$page;
			$report_count=($staff!=-1)? count($staff) : 0;
			$view_info['page_count']=(count($staff_count)==0)?0:ceil(count($staff_count)/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			$total = (count($staff_count)==0)?0:count($staff_count);
			foreach($staff as $key=>$Cdetails){
				$totalclosed = 0;
				$avgFirstresponse=0;
				$avgresponsetime=0;
				$avgresponsesla=0;
				$totalavg_time =$total_post=0; 
				$report1=array();
				if($totalTicksClosed!=-1){
					foreach($totalTicksClosed as $key=>$Cntdetails){
						if($Cdetails['staff_id'] == $Cntdetails['staff_id']){
							$totalclosed=  $Cntdetails['total_ticket_count']; 
						}
					}	
					$Cdetails['total_ticket_count'] = $totalclosed;
				} else {
					$Cdetails['total_ticket_count'] = 0;
				} 
				$post_details_cnt = ($post_details!= -1)?count($post_details):0;
				for ($i = 0; $i < $post_details_cnt; $i++){
					if($Cdetails['staff_id'] == $post_details[$i]['submitter_id']){
						if (!isset($report1[$post_details[$i]['ticket_id']]['start_time'])) { 
							$report1[$post_details[$i]['ticket_id']]['ticket_entry'] = $post_details[$i]['ticket_entry'];
							$report1[$post_details[$i]['ticket_id']]['start_time']   = $post_details[$i]['receive_date'];
							$report1[$post_details[$i]['ticket_id']]['ticket_id'] = $post_details[$i]['ticket_id'];
							if($Cdetails['staff_id'] == $post_details[$i]['submitter_id']){
								$report1[$post_details[$i]['ticket_id']]['timestamp']= $post_details[$i]['receive_date'] - $post_details[$i]['ticket_entry'];
								$total_post++;
							} else {
								$report1[$post_details[$i]['ticket_id']]['timestamp']= 0;
								$total_post += 0;
							}
							$report1[$post_details[$i]['ticket_id']]['is_posted'] = true;
							$total_ticket[$post_details[$i]['ticket_id']]        = $post_details[$i]['ticket_id'];
							$total_time                                          = $report1[$post_details[$i]['ticket_id']]['timestamp'];
							$totalavg_time+= $report1[$post_details[$i]['ticket_id']]['timestamp'];
							$avgFirstresponse = ($total_post==0)?0:count_remain_time(abs($totalavg_time)/$total_post) ;
						}
					}
				}
				$Cdetails['avgFirstresponse'] =  $avgFirstresponse;
				$report[] = $Cdetails;
			} 
			//$report=$report_details;
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j = 0;
				foreach ($report as $i) {
					foreach ($i as $key => $val) {
						if ($key == 'staff_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'total_ticket_count') {
							$report_exp[$j][$key] = $val; 
						} elseif ($key == 'avgFirstresponse') {
							$report_exp[$j][$key] = $val; 
						}
					}
					$report_exp1[$j]['staff_name'] = $report_exp[$j]['staff_name'];
					$report_exp1[$j]['solved_incidents'] = $report_exp[$j]['total_ticket_count'];
					$report_exp1[$j]['avg_first_reply_time'] = ucfirst($report_exp[$j]['avgFirstresponse']);
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				$total = count($staff_count);
				if(isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE . 'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					 echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;	
	}
	function billing_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTBILLINGSUMMARY'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();

		$report_type=7;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object       = new class_ticket($database);
		$filter           = VIS_TABLE_PREFIX.'domain.is_enabled=1';
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='billing_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		$domain = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				 
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['vis_client_id'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['domain_id'] == 0||$data['domain_id'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}  
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = ' registration_date between ' . $from . ' AND ' . $to;
				$filter .= ' and '.VIS_TABLE_PREFIX.'client.domain_id=' . $data['domain_id'];
				$filter .= ' AND ' .VIS_TABLE_PREFIX.'client.is_spam=0 AND ' .VIS_TABLE_PREFIX.'client.is_banned=0 '; // reject ban/spam report
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$report = $object->get_billing_report($filter,  $staff_id, VIS_LOCATION_AREA,'');
			$total = ($report!=-1)?count($report):0;
			$report = $object->get_billing_report($filter, $staff_id, VIS_LOCATION_AREA,$limit);
			if($report!=-1){
				$counts['page_count']=($total==0)?0:ceil( count($report)/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=$total;
				$report_count=($report!=-1)?count($report):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j = 0;
				foreach ($report as $i) {
					foreach ($i as $key => $val) {
						if($key == 'first_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'last_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'email'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'group_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'contact_number'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'client_type'){
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTEMAILCLIENT']:$vis_language['TXTCALLCLIENT'];
						} elseif($key == 'credit'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'balance'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'paid_count'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'unpaid_count'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'cancel_count'){
							$report_exp[$j][$key] = $val;
						}
					}
					$report_exp1[$j]['client'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					$report_exp1[$j]['client_type'] = $report_exp[$j]['client_type'];
					$report_exp1[$j]['contact_number'] = $report_exp[$j]['contact_number'];
					$report_exp1[$j]['ticket_credit'] = $report_exp[$j]['balance'];
					$minutes=$report_exp[$j]['credit'];
					$days    = floor($minutes / 1440);
					$hrs   = floor(($minutes - ($days * 1440)) / 60);
					$min = floor($minutes - ($days * 1440) - ($hrs * 60));
					$report_exp1[$j]['time_credit'] = $days.'D '.$hrs.'H '.$min.'M';
					$report_exp1[$j]['total_invoices']=($report_exp[$j]['paid_count']+$report_exp[$j]['unpaid_count']+$report_exp[$j]['cancel_count']);
					$report_exp1[$j]['paid'] = $report_exp[$j]['paid_count'];
					$report_exp1[$j]['unpaid'] = $report_exp[$j]['unpaid_count'];
					$report_exp1[$j]['cancelled'] = $report_exp[$j]['cancel_count'];
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function billing_client_report($operation) 
	{
		global $vis_language;
		$report_title = $vis_language['TXTCLIENTINVOICESREPORT'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();

		$report_type=20;
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='billing_client_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				$filter   = $operation['filter'];
				$limit = '';
				$domainId = $operation['department_id'];
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['vis_client_id'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['vis_client_id'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTCLIENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['vis_client_id'] != '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = ' entry_date between ' . $from . ' AND ' . $to;
				$filter .= ' AND '.VIS_TABLE_PREFIX.'invoice.client_id='.$data['vis_client_id'].' AND '.VIS_TABLE_PREFIX.'client.domain_id='.$data['domain_id'];
				$domainId = $data['domain_id'];
			}
			$filter .= ' AND ' .VIS_TABLE_PREFIX.'client.is_spam=0 AND ' . VIS_TABLE_PREFIX.'client.is_banned=0  ';
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
			$setting = new class_setting($database);
			list($dominfo, $domain) = $setting->get_domain(VIS_TABLE_PREFIX.'domain.domain_id=' . $domainId, '', 0, '', $staff_id, VIS_LOCATION_AREA);
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'billing.php');
			$billing  = new class_billing($database);
			$report = $billing->get_invoice($filter, $staff_id, VIS_LOCATION_AREA,'');
			$total = ($report!=-1)?count($report):0;
			if($report!=-1){
				$total2=0;$paid=0;$unpaid=0;$cancelled=0;
				for ($i = 0; $i < count($report); $i++) {
					if($report[$i]['invoice_status'] == 0)$unpaid +=$report[$i]['total'];
					else if($report[$i]['invoice_status'] == 1)$paid +=$report[$i]['total'];
					else if($report[$i]['invoice_status'] == 2)$cancelled +=$report[$i]['total'];
					$total2 +=$report[$i]['total'];
				}
				$array_summary=array();
				$array_summary['TXTTOTAL']=$total2.' '.$domain[0]['currency'];
				$array_summary['TXTTOTALPAID']=$paid.' '.$domain[0]['currency'];
				$array_summary['TXTTOTALUNPAID']=$unpaid.' '.$domain[0]['currency'];
				$array_summary['TXTCANCELED']=$cancelled.' '.$domain[0]['currency'];
			}
			$report = $billing->get_invoice($filter, $staff_id, VIS_LOCATION_AREA,$limit);
			if($report!=-1){
				$counts['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($report);
				$report_count=($report!=-1)?count($report):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}

			

			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) { 
				include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
				$object_report = new class_report($database);
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export         = new export();
				$invoice_status = array(
					0 => $vis_language['TXTUNPAID'],
					1 => $vis_language['TXTPAID'],
					2 => $vis_language['TXTCANCELED'],
					3 => $vis_language['TXTINPROCESS']
				);
				$j=0;
				$total2=0;$paid=0;$unpaid=0;$cancelled=0;
				for ($i = 0; $i < count($report); $i++) {
					foreach ($report[$i] as $key => $val) {
						if ($key == 'first_name' || $key == 'last_name' || $key == 'email' || $key == 'group_name' || $key == 'total' || $key == 'invoice_hash' || $key == 'entry_date' || $key == 'due_date' || $key == 'invoice_status' || $key == 'paid_date') {
							if ($key == 'entry_date' || $key == 'due_date' || $key == 'paid_date')
								$report_exp[$i][$key] = format_datetime_rpt($val,$staff_id);
							else if ($key == 'invoice_status')
								$report_exp[$i][$key] = $invoice_status[$val];
							else
								$report_exp[$i][$key] = $val;
						}
					}
					$report_exp1[$j]['invoice_hash'] = $report_exp[$i]['invoice_hash'];
					$report_exp1[$j]['client_name'] = $report_exp[$i]['first_name'].' '.$report_exp[$i]['last_name'];
					$report_exp1[$j]['email'] = $report_exp[$i]['email'];
					$report_exp1[$j]['organization'] = $report_exp[$i]['group_name'];
					$report_exp1[$j]['invoice_date'] = $report_exp[$i]['entry_date'];
					$report_exp1[$j]['due_date'] = $report_exp[$i]['due_date'];
					if($report[$i]['paid_date']!=0){
						$report_exp1[$j]['paid_date'] = $report_exp[$i]['paid_date'];
					} else {
						$report_exp1[$j]['paid_date'] = '---';
					}
					$report_exp1[$j]['amount'.'('.$domain[0]['currency'].')'] = $report_exp[$i]['total'];
					$report_exp1[$j]['billing_status'] = $report_exp[$i]['invoice_status'];
					$j++;
					if($report[$i]['invoice_status'] == 0)$unpaid +=$report[$i]['total'];
					else if($report[$i]['invoice_status'] == 1)$paid +=$report[$i]['total'];
					else if($report[$i]['invoice_status'] == 2)$cancelled +=$report[$i]['total'];
					$total2 +=$report[$i]['total'];
				}
				
				$report_exp1[$j]['total_amount']=$vis_language['TXTTOTAL'].':'.$total2.' '.$domain[0]['currency'];
				$report_exp1[$j]['total_paid']=$vis_language['TXTTOTALPAID'].':'.$paid.' '.$domain[0]['currency'];
				$report_exp1[$j]['total_unpaid']=$vis_language['TXTTOTALUNPAID'].':'.$unpaid.' '.$domain[0]['currency'];
				$report_exp1[$j]['total_cancelled']=$vis_language['TXTCANCELED'].':'.$cancelled.' '.$domain[0]['currency'];
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object_report->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			}  else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function billing_invoice_report($operation)
	{ 
		$creater_staff_id = isset($creater_staff_id)?$creater_staff_id:'';
		global $vis_language;
		$report_title = $vis_language['TXTDEPTINVOICERPT'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();

		$report_type=26;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object       = new class_ticket($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
		$object_staff  = new class_staff($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$staff_filter  = "staff_id =".$staff_id;
		$staff_details = $object_staff->get_staff($staff_filter, $staff_id, VIS_LOCATION_AREA);
		$departments   = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		$dept_ids      = '';
		for ($d = 0; $d < count($departments); $d++) {
			$dept_ids .= $departments[$d]['department_id'] . ',';
		}
		if ($dept_ids != '') {
			$dept_ids = substr($dept_ids, 0, -1);
		}
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info,$view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='billing_invoice_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		$domain_details = $tkt_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled = 1', $creater_staff_id, VIS_LOCATION_AREA);
		$currency       = $domain_details[0]['currency'];
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				$data['department_id'] = (isset($data['department_id']))? $data['department_id']:0;
				if ($data['duration'] == 0 && $data['department_id'] == '0' && $data['status_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} 
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['department_id'] == '0') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDEPARTMENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} 
				if ($data['status_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' .$vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTBILLING']) .' ' .strtolower($vis_language['TXTSTATUS']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from  = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to    = strtotime($data['to_date']) - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$department_id = ($data['department_id'] == 0) ? '' : implode(',',$data['department_id']);
				$status_id     = ($data['status_id'] == 3) ? '' : $data['status_id'];
				$filter        = VIS_TABLE_PREFIX.'invoice.entry_date between ' . $from . ' AND ' . $to;
				$filter .= ($data['department_id'] != 0) ? ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN(' . $department_id.')'  : ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN ('.$dept_ids.')';
				$filter .= ($data['status_id'] == 3) ? '' : ' and '.VIS_TABLE_PREFIX.'invoice.invoice_status=' . $data['status_id'];
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$filter .= ' and '.VIS_TABLE_PREFIX.'invoice.ticket_id!=0 ';
			$report1 = $object->get_billing_invoice_report($filter, '', $staff_id, VIS_LOCATION_AREA);
			$total = ($report1!=-1)?count($report1):0;
			$total2=0;$paid=0;$unpaid=0;$cancelled=0;
			$report='';
			if($report1!=-1){
				$report = $object->get_billing_invoice_report($filter,$limit,$staff_id, VIS_LOCATION_AREA);
				$counts['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($report);
				$report_count=($report!=-1)?count($report):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
				foreach ($report1 as $ticket_id => $details) {
					$total2 += $details['amount'];
					if($details['invoice_status'] == 0)$unpaid +=$details['amount'];
					else if($details['invoice_status'] == 1)$paid +=$details['amount'];
					else if($details['invoice_status'] == 2)$cancelled +=$details['amount'];
				}
			}
			$array_summary=array();
			$array_summary['TXTTOTAL']=$total2.' '.$currency;
			$array_summary['TXTTOTALPAID']=$paid.' '.$currency;
			$array_summary['TXTTOTALUNPAID']=$unpaid.' '.$currency;
			$array_summary['TXTTOTALCANCELLED']=$cancelled.' '.$currency;
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				foreach ($report1 as $ticket_id => $i) {
					foreach ($i as $key => $val) {
						if ($key == 'invoice_status') {
							$report_exp[$j][$key] = $val;
							if($val==0){
								$report_exp[$j][$key] = $vis_language['TXTUNPAID'];
							} elseif($val==1){
								$report_exp[$j][$key] = $vis_language['TXTPAID'];
							} elseif($val==2){
								$report_exp[$j][$key] = $vis_language['TXTCANCELED']; 
							} elseif($val==3){
								$report_exp[$j][$key] = $vis_language['TXTINPROCESS'];
							}
						} elseif ($key == 'invoice_hash') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'entry_date') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'first_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'last_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'email') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'group_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'due_date') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'paid_date') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'ticket_hash') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'amount') {
							$report_exp[$j][$key] = $val;
						}
					}
					$report_exp1[$j]['invoice_hash']=$report_exp[$j]['invoice_hash'];
					$report_exp1[$j]['reference_incidents']=$report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['client_name']=$report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email']=$report_exp[$j]['email'];
					$report_exp1[$j]['organization']=$report_exp[$j]['group_name'];
					
					$report_exp1[$j]['invoice_date']=$report_exp[$j]['entry_date'];
					$report_exp1[$j]['due_date']=$report_exp[$j]['due_date'];
					$report_exp1[$j]['paid_date']=$report_exp[$j]['paid_date'];
					$report_exp1[$j]['amount'.'('.$currency.')']=$report_exp[$j]['amount'];
					$report_exp1[$j]['billing_status']=$report_exp[$j]['invoice_status'];
					$j++;
				}
				$report_exp1[$j]['summary'] = $vis_language['TXTSUMMARY'];
				foreach($array_summary as $key=>$val){
				 $report_exp1[$j][$vis_language[$key]]=$vis_language[$key] . ' : ' . $val; 
				}
				/*$report_exp [$j]['total']=$vis_language['TXTTOTAL'].' :'.$total .' '. $currency;
				$report_exp [$j]['paid']=$vis_language['TXTTOTALPAID'].' :'.$paid .' '. $currency;
				$report_exp [$j]['unpaid']=$vis_language['TXTTOTALUNPAID'].' :'.$unpaid .' '. $currency;
				$report_exp [$j]['cancelled']=$vis_language['TXTTOTALCANCELLED'].' :'.$cancelled .' '. $currency;
				$report_exp1[$j]['total']= $report_exp[$j]['total'];
				$report_exp1[$j]['paid']= $report_exp[$j]['paid'];
				$report_exp1[$j]['unpaid']=$report_exp[$j]['unpaid'];
				$report_exp1[$j]['cancelled']=$report_exp[$j]['cancelled'];*/
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function order_report($operation)
	{			
		global $vis_language;
		$report_title = $vis_language['TXTORDERREPORT'];
		$export       = 1;
		$report_type=27;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();

		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object       = new class_ticket($database);
		$creater_staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$staff_id = isset($creater_staff_id) ? $creater_staff_id : '';
		$departments      = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		$domain_details = $tkt_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled = 1', $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$filter_domain = VIS_TABLE_PREFIX.'domain.is_enabled=1';
		$domain = $tkt_object->get_domain($filter_domain, $staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='order_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		$currency       = $domain_details[0]['currency'];
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				$data['domain_id'] = (isset($data['domain_id']))? $data['domain_id']:0;
				if ($data['duration'] == 0 && $data['domain_id'] == 0 && $data['status_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] == 0 && $data['status_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] == 0 && $data['status_id'] != -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['domain_id'] == 0 && $data['status_id'] != -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['domain_id'] != 0 && $data['status_id'] != -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['domain_id'] != 0 && $data['status_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] != 0 && $data['status_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' .strtolower($vis_language['TXTSTATUS']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] == 0 && $data['status_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ']." ".strtolower($vis_language['TXTSTATUS']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				
				$status_id     = ($data['status_id'] == 3) ? '' : $data['status_id'];
				$filter        = VIS_TABLE_PREFIX.'order.entry_date between ' . $from . ' AND ' . $to;
			
				$filter .=  ' and '.VIS_TABLE_PREFIX.'ticket.domain_id ='.$data['domain_id'];
				$filter .= ($data['status_id'] == 4) ? '' : ' and '.VIS_TABLE_PREFIX.'invoice.invoice_status=' . $data['status_id'];
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			list($report1,$domain) = $object->get_order_report($filter, '', $staff_id, VIS_LOCATION_AREA);
			$total = ($report1!=-1)?count($report1):0;
			list($report,$domain) = $object->get_order_report($filter, $limit, $staff_id, VIS_LOCATION_AREA);
			$view_info['page']=$page;
			$report_count=($report!=-1)?count($report):0;
			$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			$total2=0;$paid=0;$unpaid=0;$cancelled=0;
			if($report1!=-1){
				foreach ($report1 as $ticket_id => $details) {
					$total2 += $details['amount'];
					if($details['invoice_status'] == 0)$unpaid +=$details['amount'];
					else if($details['invoice_status'] == 1)$paid +=$details['amount'];
					else if($details['invoice_status'] == 2)$cancelled +=$details['amount'];
				}
			}
			$array_summary=array();
			$array_summary['TXTTOTAL']=$total2.' '.$currency;
			$array_summary['TXTTOTALPAID']=$paid.' '.$currency;
			$array_summary['TXTTOTALUNPAID']=$unpaid.' '.$currency;
			$array_summary['TXTTOTALCANCELLED']=$cancelled.' '.$currency;
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				foreach ($report as $ticket_id => $i) {
					foreach ($i as $key => $val) {
						if ($key == 'invoice_hash') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'entry_date') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$creater_staff_id);
						} elseif ($key == 'first_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'last_name') {
							$report_exp[$j][$key] = $val;
						}  elseif ($key == 'email') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'group_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'paid_date') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$creater_staff_id);
						} elseif ($key == 'amount') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'order_hash') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'invoice_status') {
							$report_exp[$j][$key] = $val;
							if($val==0){
								$report_exp[$j][$key] = $vis_language['TXTUNPAID'];
							} elseif($val==1){
								$report_exp[$j][$key] = $vis_language['TXTPAID'];
							} elseif($val==2){
								$report_exp[$j][$key] = $vis_language['TXTCANCELED']; 
							} elseif($val==3){
								$report_exp[$j][$key] = $vis_language['TXTINPROCESS'];
							}
						} elseif ($key == 'order_status') {
							$report_exp[$j][$key] = $val;
							if($val==1){
								$report_exp[$j][$key] = $vis_language['TXTACTIVE'];
							} elseif($val==2){
								$report_exp[$j][$key] = $vis_language['TXTPENDING'];
							} elseif($val==3){
								$report_exp[$j][$key] = $vis_language['TXTINCOMPLETE']; 
							} elseif($val==4){
								$report_exp[$j][$key] = $vis_language['TXTCANCELED'];
							}							 
						}
					}
					$report_exp1[$j]['order_hash']=$report_exp[$j]['order_hash'];		
					$report_exp1[$j]['invoice_hash']=$report_exp[$j]['invoice_hash'];
					$report_exp1[$j]['client_name']=$report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email']=$report_exp[$j]['email'];
					$report_exp1[$j]['organization']=$report_exp[$j]['group_name'];
					$report_exp1[$j]['paid_date']=$report_exp[$j]['paid_date'];
					$report_exp1[$j]['amount'.'('.$currency.')']=$report_exp[$j]['amount'];
					$report_exp1[$j]['billing_status']=$report_exp[$j]['invoice_status'];
					$report_exp1[$j]['status']=$report_exp[$j]['order_status'];
					$j++;
				}
				$report_exp1[$j]['summary'] = $vis_language['TXTSUMMARY'];
				foreach($array_summary as $key=>$val){
				 $report_exp1[$j][$vis_language[$key]]=$vis_language[$key] . ' : ' . $val; 
				}
				/*$report_exp1[$j]['total']=$vis_language['TXTTOTAL'].' :'.$total.' '. $currency;
				$report_exp1[$j]['paid']=$vis_language['TXTTOTALPAID'].' :'.$paid.' '. $currency;
				$report_exp1[$j]['unpaid']=$vis_language['TXTTOTALUNPAID'].' :'.$unpaid.' '. $currency;
				$report_exp1[$j]['cancelled']=$vis_language['TXTTOTALCANCELLED'].' :'.$cancelled.' '. $currency;*/
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function transaction_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTTRANSACTIONREPORT'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();

		$report_type=28;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
		$object_staff  = new class_staff($database);
		$creater_staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$staff_id = isset($staff_id)?$staff_id:'';
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$staff_filter  = "staff_id =".$staff_id;
		$staff_details = $object_staff->get_staff($staff_filter, $staff_id, VIS_LOCATION_AREA);
		$filter_domain = VIS_TABLE_PREFIX.'domain.is_enabled=1';
		$domain = $tkt_object->get_domain($filter_domain, $staff_id, VIS_LOCATION_AREA);
		$departments   = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		$dept_ids      = '';
		for ($d = 0; $d < count($departments); $d++) {
			$dept_ids .= $departments[$d]['department_id'] . ',';
		}
		if ($dept_ids != '') {
			$dept_ids = substr($dept_ids, 0, -1);
		}
		$domain_details = $tkt_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled = 1', $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($creater_staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='transaction_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';			
		$currency       = $domain_details[0]['currency'];
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}	
				$data['domain_id'] = (isset($data['domain_id']))? $data['domain_id']:0;				
				if ($data['duration'] == 0 && $data['domain_id'] == 0 && $data['status_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] == 0 && $data['status_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';						
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] == 0 && $data['status_id'] != -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';						
					return false;
				} else if ($data['duration'] == 0 && $data['domain_id'] == 0 && $data['status_id'] != -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';						
					return false;
				} else if ($data['duration'] == 0 && $data['domain_id'] != 0 && $data['status_id'] != -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['domain_id'] != 0 && $data['status_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] != 0 && $data['status_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ']." ".strtolower($vis_language['TXTSTATUS']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] == 0 && $data['status_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ']." ".strtolower($vis_language['TXTSTATUS']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$status_id     = ($data['status_id'] == 3) ? '' : $data['status_id'];
				$filter        = VIS_TABLE_PREFIX . 'balance.entry_date between ' . $from . ' AND ' . $to;
				$filter .= ($data['status_id'] == 4) ? '' : ' and '.VIS_TABLE_PREFIX.'invoice.invoice_status=' . $data['status_id'];
				$filter .=' and '.VIS_TABLE_PREFIX.'client.domain_id='.$data['domain_id'];
			}				
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);				
			$report1 = $object->get_transcation_report($filter, '',$staff_id, VIS_LOCATION_AREA);
			$total = ($report1!=-1)?count($report1):0;
			$report = $object->get_transcation_report($filter,$limit, $staff_id , VIS_LOCATION_AREA);
			$view_info['page']=$page;
			$report_count=($report!=-1)?count($report):0;
			$view_info['page_count']=($total==0) ? 0 : ceil($total/$view_info['page_count']);
			$view_info['view_count']=count($view_details);

			$total2=0;$paid=0;$unpaid=0;$cancelled=0;/*$inprocess=0;*/
			if($report1!=-1){
				foreach ($report1 as $ticket_id => $details) {
					$total2 += $details['amount'];
					if($details['invoice_status'] == 0)$unpaid +=$details['amount'];
					else if($details['invoice_status'] == 1)$paid +=$details['amount'];
					else if($details['invoice_status'] == 2)$cancelled +=$details['amount'];
					/*else if($details['invoice_status'] == 3)$inprocess +=$details['amount'];*/
				}
			}
			$array_summary=array();
			$array_summary['TXTTOTAL']=$total2.' '.$currency;
			$array_summary['TXTTOTALPAID']=$paid.' '.$currency;
			$array_summary['TXTTOTALUNPAID']=$unpaid.' '.$currency;
			$array_summary['TXTTOTALCANCELLED']=$cancelled.' '.$currency;
			/*$array_summary['TXTTOTALINPROCESS']=$inprocess.' '.$currency;*/

			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				foreach ($report as $ticket_id => $i) {
					foreach ($i as $key => $val) {
						if ($key == 'transaction_id') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'invoice_status') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'invoice_hash') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'description') {
							$report_exp[$j][$key] = str_replace(array("\n","\r\n","\r"), ' ', $val);
						} elseif ($key == 'first_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'last_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'email') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'group_name') {
							$report_exp[$j][$key] = $val;
						}elseif ($key == 'invoicedate') {								
							$report_exp[$j][$key] = format_datetime_rpt($val,$creater_staff_id);
						}elseif ($key == 'entry_date') {								
							$report_exp[$j][$key] = format_datetime_rpt($val,$creater_staff_id);
						} elseif ($key == 'amount') {
							$report_exp[$j][$key] = $val;
						}
					}
					$report_exp1[$j]['invoice_hash'] = $report_exp[$j]['invoice_hash'];
					$report_exp1[$j]['client_name'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					$report_exp1[$j]['description'] = $report_exp[$j]['description'];
					$report_exp1[$j]['transaction_id'] = $report_exp[$j]['transaction_id'];	
					$report_exp1[$j]['invoice_date'] = $report_exp[$j]['invoicedate'];													
					$report_exp1[$j]['transaction_date'] = $report_exp[$j]['entry_date'];
					$report_exp1[$j]['amount'.' ('.$currency.')'] = $report_exp[$j]['amount'];	
					if($report_exp[$j]['invoice_status']==0){ $status = $vis_language['TXTUNPAID'];}
					elseif($report_exp[$j]['invoice_status']==1){ $status = $vis_language['TXTPAID'];}
					elseif($report_exp[$j]['invoice_status']==2){ $status = $vis_language['TXTCANCELED'];}
					elseif($report_exp[$j]['invoice_status']==3){ $status = $vis_language['TXTINPROGRESS'];}
					elseif($report_exp[$j]['invoice_status']==4){ $status = 'All';}
					else{ $status='---';}						
					$report_exp1[$j]['billing_status'] = $status;
					$j++;
				}
				$report_exp1[$j]['summary'] = $vis_language['TXTSUMMARY'];
				foreach($array_summary as $key=>$val){
				 $report_exp1[$j][$vis_language[$key]]=$vis_language[$key] . ' : ' . $val; 
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);				
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);						
				}					
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;			
	}

	function client_order_report($operation)
	{ 
		global $vis_language;
		$report_title = $vis_language['TXTCLIENTORDERREPORT'];
		$export       = 1;
		$report_type=29;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();

		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$domain_details = $tkt_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled = 1', $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='client_order_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		$currency       = $domain_details[0]['currency'];
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4){
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['vis_client_id'] == '' && $data['status_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['vis_client_id'] == '' && $data['status_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTCLIENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['vis_client_id'] == '' && $data['status_id'] != -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTCLIENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['vis_client_id'] == '' && $data['status_id'] != -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['vis_client_id'] != '' && $data['status_id'] != -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['vis_client_id'] != '' && $data['status_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['vis_client_id'] != '' && $data['status_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ']." ".strtolower($vis_language['TXTSTATUS']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['vis_client_id'] == '' && $data['status_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ']." ".strtolower($vis_language['TXTSTATUS']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$status_id = ($data['status_id'] == 3) ? '' : $data['status_id'];
				$filter    = VIS_TABLE_PREFIX.'invoice.entry_date between ' . $from . ' AND ' . $to;
				$filter .= ' AND ' . VIS_TABLE_PREFIX.'client.client_id=' . $data['vis_client_id'];
				$filter .= ($data['status_id'] == 4) ? '' : ' and '.VIS_TABLE_PREFIX.'invoice.invoice_status=' . $data['status_id'];
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			list($report1,$report_cnt) = $object->get_client_order_report($filter, '', $staff_id, VIS_LOCATION_AREA);
			$total = ($report1!=-1)?count($report1):0;
			list($report,$report_cnt) = $object->get_client_order_report($filter,$limit, $staff_id, VIS_LOCATION_AREA);
			$view_info['page']=$page;
			$report_count=($report!=-1) ? count($report) : 0;
			$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			$total2=0;$paid=0;$unpaid=0;$cancelled=0;$inprocess=0;
			if($report1!=-1){
				foreach ($report1 as $ticket_id => $details) {
					$total2 += $details['amount'];
					if($details['invoice_status'] == 0)$unpaid +=$details['amount'];
					else if($details['invoice_status'] == 1)$paid +=$details['amount'];
					else if($details['invoice_status'] == 2)$cancelled +=$details['amount'];
					else if($details['invoice_status'] == 3)$inprocess +=$details['amount'];
				}
			}
			$array_summary=array();
			$array_summary['TXTTOTAL']=$total2.' '.$currency;
			$array_summary['TXTTOTALPAID']=$paid.' '.$currency;
			$array_summary['TXTTOTALUNPAID']=$unpaid.' '.$currency;
			$array_summary['TXTTOTALCANCELLED']=$cancelled.' '.$currency;
			$array_summary['TXTTOTALINPROCESS']=$inprocess.' '.$currency;

			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				foreach ($report as $ticket_id => $i) {
					foreach ($i as $key => $val) {
						if ($key == 'order_hash') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'invoice_hash') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'first_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'last_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'email') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'group_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'entry_date') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'due_date') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'paid_date') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'amount') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'invoice_status') {
							$report_exp[$j][$key] = $val;
							if($val==0){
								$report_exp[$j][$key] = $vis_language['TXTUNPAID'];
							} elseif($val==1){
								$report_exp[$j][$key] = $vis_language['TXTPAID'];
							} elseif($val==2){
								$report_exp[$j][$key] = $vis_language['TXTCANCELED']; 
							} elseif($val==3){
								$report_exp[$j][$key] = $vis_language['TXTINPROCESS'];
							}
						}
					}
					$report_exp1[$j]['order_hash'] = $report_exp[$j]['order_hash'];
					$report_exp1[$j]['invoice_hash'] = $report_exp[$j]['invoice_hash'];
					$report_exp1[$j]['client_name'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					$report_exp1[$j]['invoice_date'] = $report_exp[$j]['entry_date'];
					$report_exp1[$j]['due_date'] = $report_exp[$j]['due_date'];
					$report_exp1[$j]['paid_date'] = $report_exp[$j]['paid_date'];
					$report_exp1[$j]['amount'.' ('.$currency.')'] = $report_exp[$j]['amount'];
					$report_exp1[$j]['billing_status'] = $report_exp[$j]['invoice_status'];
					$j++;
				}
				$report_exp1[$j]['summary'] = $vis_language['TXTSUMMARY'];
				foreach($array_summary as $key=>$val){
				 $report_exp1[$j][$vis_language[$key]]=$vis_language[$key] . ' : ' . $val; 
				}
				/*$report_exp1[$j]['total']=$vis_language['TXTTOTAL'].' :'.$total.' '.$currency;
				$report_exp1[$j]['paid']=$vis_language['TXTTOTALPAID'].' :'.$paid.' '.$currency;
				$report_exp1[$j]['unpaid']=$vis_language['TXTTOTALUNPAID'].' :'.$unpaid.' '.$currency;
				$report_exp1[$j]['cancelled']=$vis_language['TXTTOTALCANCELLED'].' :'.$cancelled.' '.$currency;
				$report_exp1[$j]['inprocess']=$vis_language['TXTTOTALINPROCESS'].' :'.$inprocess.' '.$currency;*/
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);	
				if(isset($operation['slave_db']) && $operation['slave_db'] == 1){
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function client_transaction_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTCLIENTTRANSACTIONREPORT'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();

		$report_type=30;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$domain_details = $tkt_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled = 1', $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='client_transaction_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		$currency       = $domain_details[0]['currency'];
		if((isset($operation['vis_action']) && $operation['vis_action']!='') || isset($operation['vis_submit']) && $operation['vis_submit']!=''){
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']). '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}

				if ($data['duration'] == 0 && $data['vis_client_id'] == '' && $data['status_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['vis_client_id'] == '' && $data['status_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTCLIENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['vis_client_id'] == '' && $data['status_id'] != -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTCLIENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['vis_client_id'] == '' && $data['status_id'] != -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['vis_client_id'] != '' && $data['status_id'] != -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['vis_client_id'] != '' && $data['status_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['vis_client_id'] != '' && $data['status_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ']." ".strtolower($vis_language['TXTSTATUS']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['vis_client_id'] == '' && $data['status_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ']." ".strtolower($vis_language['TXTSTATUS']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$status_id = ($data['status_id'] == 3) ? '' : $data['status_id'];
				$filter    = VIS_TABLE_PREFIX.'balance.entry_date between ' . $from . ' AND ' . $to;
				$filter .= ' AND ' .VIS_TABLE_PREFIX.'client.client_id=' . $data['vis_client_id'];
				$filter .= ($data['status_id'] == 4) ? '' : ' and ' .VIS_TABLE_PREFIX.'invoice.invoice_status=' . $data['status_id'];
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$report1 = $object->get_client_transaction_report($filter, '', $staff_id, VIS_LOCATION_AREA);
			$total = ($report1!=-1)?count($report1):0;
			$report = $object->get_client_transaction_report($filter,$limit, $staff_id, VIS_LOCATION_AREA);
			$view_info['page']=$page;
			$report_count=($report!=-1)?count($report):0;
			$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			$total2=0;$paid=0;$unpaid=0;$cancelled=0;$inprocess=0;
			if($report1!=-1){
				foreach ($report1 as $ticket_id => $details) {
					$total2 += $details['amount'];
					if($details['invoice_status'] == 0) $unpaid +=$details['amount'];
					else if($details['invoice_status'] == 1) $paid +=$details['amount'];
					else if($details['invoice_status'] == 2) $cancelled +=$details['amount'];
					else if($details['invoice_status'] == 3) $inprocess +=$details['amount'];
				}
			}
			$array_summary=array();
			$array_summary['TXTTOTAL']=$total2.' '.$currency;
			$array_summary['TXTTOTALPAID']=$paid.' '.$currency;
			$array_summary['TXTTOTALUNPAID']=$unpaid.' '.$currency;
			$array_summary['TXTTOTALCANCELLED']=$cancelled.' '.$currency;
			$array_summary['TXTTOTALINPROCESS']=$inprocess.' '.$currency;
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				foreach ($report as $ticket_id => $i){
					foreach ($i as $key => $val){
						if ($key == 'transaction_id'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'invoice_hash'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'description'){
							$report_exp[$j][$key] = str_replace(array("\n","\r\n","\r"), ' ', $val);
						} elseif ($key == 'first_name'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'last_name'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'email'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'group_name'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'entry_date') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'invoice_date') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'amount'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'invoice_status'){
							$report_exp[$j][$key] = $val;
							if($val==0){
								$report_exp[$j][$key] = $vis_language['TXTUNPAID'];
							} elseif($val==1){
								$report_exp[$j][$key] = $vis_language['TXTPAID'];
							} elseif($val==2){
								$report_exp[$j][$key] = $vis_language['TXTCANCELED']; 
							} elseif($val==3){
								$report_exp[$j][$key] = $vis_language['TXTINPROCESS'];
							}
						}
					}
					$report_exp1[$j]['invoice_hash'] = $report_exp[$j]['invoice_hash'];
					$report_exp1[$j]['description'] = $report_exp[$j]['description'];
					$report_exp1[$j]['client_name'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					$report_exp1[$j]['transaction_id'] = $report_exp[$j]['transaction_id'];
					$report_exp1[$j]['invoice_date'] = $report_exp[$j]['invoice_date'];
					$report_exp1[$j]['transaction_date'] = $report_exp[$j]['entry_date'];
					$report_exp1[$j]['amount'.' ('.$currency.')'] = $report_exp[$j]['amount'];
					$report_exp1[$j]['billing_status'] = $report_exp[$j]['invoice_status'];
					$j++;
				}
				$report_exp1[$j]['summary'] = $vis_language['TXTSUMMARY'];
				foreach($array_summary as $key=>$val){
				 $report_exp1[$j][$vis_language[$key]]=$vis_language[$key] . ' : ' . $val; 
				}
				/*$report_exp1[$j]['total']=$vis_language['TXTTOTAL'].' :'.$total.' '.$currency;
				$report_exp1[$j]['paid']=$vis_language['TXTTOTALPAID'].' :'.$paid.' '.$currency;
				$report_exp1[$j]['unpaid']=$vis_language['TXTTOTALUNPAID'].' :'.$unpaid.' '.$currency;
				$report_exp1[$j]['cancelled']=$vis_language['TXTTOTALCANCELLED'].' :'.$cancelled.' '.$currency;
				$report_exp1[$j]['inprocess']=$vis_language['TXTTOTALINPROCESS'].' :'.$inprocess.' '.$currency;*/
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);	
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function client_packages_report($operation){
		global $vis_language;
		$report_title = $vis_language['TXTCLIENT'].' '.lcfirst($vis_language['TXTPACKAGES']);
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();

		$export = 1;
		$report_type= 166;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'billing.php');
		$object        = new class_report($database);
		$tkt_object    = new class_ticket($database);
		$client_object = new class_client($database);
		$billing_object = new class_billing($database);
		include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'client.php');
		$object_client = new client();
		if(isset($operation['vis_export']) && $operation['vis_export'] == 1){
			$staff_id = $operation['staff_id'];
		} else {
			$staff_id = VIS_STAFF_ID;
			$domain_list   = $object_client->get_domain_access_list();
			$clientGroup   = $client_object->get_client_group1(' (domain_id in (' . $domain_list . ') or domain_id=0 ) and is_enable=1', $staff_id, VIS_LOCATION_AREA); //get client group list
		}
		$filter        = VIS_TABLE_PREFIX.'domain.is_enabled=1';
		$domain        = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA); // get domain list
		$currency = $domain[0]['currency'];
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='client_packages_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';			
		$export        = 1;
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}

				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$msg.'");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['domain_id'] == 0 && $data['credit_type'] == 'select') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']).'");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message",  "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']).'");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['credit_type'] == "select") {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTCREDITTYPE']). '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}

				$domainId = ($data['domain_id']==0) ? '' : ' AND '.VIS_TABLE_PREFIX.'client.domain_id = '.$data['domain_id'];
				$credit_type = ($data['credit_type']=='select') ? '' : ' and '.VIS_TABLE_PREFIX.'product.balance_type=' . $data['credit_type'];
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'invoice.entry_date between "'.$from.'" AND "'.$to.'"'.$domainId.$credit_type;
			}
			list($package_details,$package_info) = $object->get_client_packages_report($filter, '', $staff_id, VIS_LOCATION_AREA);
			$total2=0;$paid=0;$unpaid=0;$cancelled=0;
			$report='';
			if($package_details!=-1){
				$total = ($package_details!=-1)?count($package_details):0;
				list($report,$package_info) = $object->get_client_packages_report($filter, $limit, $staff_id, VIS_LOCATION_AREA);
				$counts['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($report);
				$report_count=($report!=-1)?count($report):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
				foreach ($package_details as $ticket_id => $details) {
					$total2 += $details['amount'];
					if($details['invoice_status'] == 0)$unpaid +=$details['amount'];
					else if($details['invoice_status'] == 1)$paid +=$details['amount'];
					else if($details['invoice_status'] == 2)$cancelled +=$details['amount'];
				}
			}
			
			$array_summary=array();
			$array_summary['TXTTOTAL']=$total2.' '.$currency;
			$array_summary['TXTTOTALPAID']=$paid.' '.$currency;
			$array_summary['TXTTOTALUNPAID']=$unpaid.' '.$currency;
			$array_summary['TXTTOTALCANCELLED']=$cancelled.' '.$currency;
			//$array_summary['TXTTOTALPROGRESS']=;

			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				foreach ($package_details as $ticket_id => $i) {
					foreach ($i as $key => $val) {
						if ($key == 'billing_cycle') {
							$report_exp[$j][$key] = $val;
							if($val==0){
								$report_exp[$j][$key] = $vis_language['TXTVALIDITYONETIME'];
							} elseif($val==1){
								$report_exp[$j][$key] = $vis_language['TXTVALIDITYMONTHLY'];
							} elseif($val==2){
								$report_exp[$j][$key] = $vis_language['TXTVALIDITYQUARTERLY']; 
							} elseif($val==3){
								$report_exp[$j][$key] = $vis_language['TXTVALIDITYSEMIANNUALLY'];
							}elseif($val==4){
								$report_exp[$j][$key] = $vis_language['TXTVALIDITYANNUALLY'];
							}
						}elseif ($key == 'product_name') {
							$report_exp[$j][$key] = $val;
						}elseif ($key == 'invoice_hash') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'entry_date') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'first_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'last_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'amount') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'invoice_status') {
							$report_exp[$j][$key] = $val;
							if($val==0){
								$report_exp[$j][$key] = $vis_language['TXTUNPAID'];
							} elseif($val==1){
								$report_exp[$j][$key] = $vis_language['TXTPAID'];
							} elseif($val==2){
								$report_exp[$j][$key] = $vis_language['TXTCANCELED']; 
							} elseif($val==3){
								$report_exp[$j][$key] = $vis_language['TXTINPROCESS'];
							}
						}
					}
					$report_exp1[$j]['billing_cycle']=$report_exp[$j]['billing_cycle'];
					$report_exp1[$j]['package']=$report_exp[$j]['product_name'];
					$report_exp1[$j]['invoice_hash']=$report_exp[$j]['invoice_hash'];
					$report_exp1[$j]['invoice_date']=$report_exp[$j]['entry_date'];
					$report_exp1[$j]['client_name']=$report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['amount'.'('.$currency.')']=$report_exp[$j]['amount'];
					$report_exp1[$j]['billing_status']=$report_exp[$j]['invoice_status'];
					$j++;
				}
				$report_exp1[$j]['summary'] = $vis_language['TXTSUMMARY'];
				foreach($array_summary as $key=>$val){
				 $report_exp1[$j][$vis_language[$key]]=$vis_language[$key] . ' : ' . $val; 
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			}else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function ticket_replied_by_staff_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTTICKETREPLIEDBYSTAFF'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type = 67;
		$export = 1;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object       = new class_ticket($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$staff            = $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page'])) ? $operation['vis_page'] : 0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='ticket_replied_by_staff_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if((isset($operation['vis_action']) && $operation['vis_action']!='') || isset($operation['vis_submit']) && $operation['vis_submit']!=''){
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if(isset($data['staff_id']) && $data['staff_id']!=''){
					$data['staff_id'] = $data['staff_id'];
				} else {
					$data['staff_id'] = $staff_id;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['staff_id'] == 0){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['staff_id'] == 0){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTSTAFF']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['staff_id'] != 0){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$service='';
				if($data['service_id']!=0)
					{
						if($data['service_id']==2)
							$service=' and '.VIS_TABLE_PREFIX.'ticket_post.is_visible=1 and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';
						if($data['service_id']==1)
							$service=' and '.VIS_TABLE_PREFIX.'ticket_post.is_visible=1 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';
						if($data['service_id']==3)
							$service=' and '.VIS_TABLE_PREFIX.'ticket_post.is_visible=0 and '.VIS_TABLE_PREFIX.'ticket.client_id=0';
					}
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX .'ticket_post.receive_date between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'ticket_post.submitter=0 and '.VIS_TABLE_PREFIX.'ticket_post.submitter_id=' . $data['staff_id'] . ' and ' .VIS_TABLE_PREFIX.'ticket_post.draft_id=0 and '.VIS_TABLE_PREFIX.'ticket_post.reply_forward=1'.$service;
			}
			$filter.= ' and '.VIS_TABLE_PREFIX.'ticket.is_deleted =0 and ' .VIS_TABLE_PREFIX.'ticket.is_spam=0 and ' .VIS_TABLE_PREFIX.'ticket.draft_id=0';
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object       = new class_report($database);
			list($total, $report) = $object->ticket_post_by_staff_report($filter, $limit, $staff_id, VIS_LOCATION_AREA);
			$view_info['page']=$page;
			$report_count=($report!=-1) ? count($report) : 0;
			$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			$array_summary = array();
			if(isset($operation['vis_export']) && $operation['vis_export'] == 1){
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j=0;
				foreach ($report as $i){
					foreach ($i as $key => $val){
						if($key == 'ticket_hash' || $key == 'subject'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'fname' || $key == 'lname' || $key == 'email' || $key == 'group_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'create_date'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id); 
						} elseif($key == 'totalpost'){
							$report_exp[$j][$key] = $val;
						}
					}
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['subject'] 	= $report_exp[$j]['subject'];
					$report_exp1[$j]['client_name'] 	= $report_exp[$j]['fname'].' '.$report_exp[$j]['lname'];
					$report_exp1[$j]['email'] 	= $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] 	= $report_exp[$j]['group_name'];
					$report_exp1[$j]['creation_date'] = $report_exp[$j]['create_date'];
					$report_exp1[$j]['reply_count'] = $report_exp[$j]['totalpost'];
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);	
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function ticket_forwarded_by_staff_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTTICKETFORWARDEDBYSTAFF'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type = 68;
		$export = 1;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object       = new class_ticket($database);
		
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$staff            = $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='ticket_forwarded_by_staff_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if((isset($operation['vis_action']) && $operation['vis_action']!='') || isset($operation['vis_submit']) && $operation['vis_submit']!=''){
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['staff_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['staff_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTSTAFF']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['staff_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$service='';
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';if($data['service_id']==3)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id=0';}
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'ticket_post.submitter=0 and '.VIS_TABLE_PREFIX.'ticket_post.submitter_id=' . $data['staff_id'] . ' and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and '.VIS_TABLE_PREFIX.'ticket_post.reply_forward=2'.$service;
			}
			$filter.= ' and '.VIS_TABLE_PREFIX.'ticket.is_deleted =0 and ' .VIS_TABLE_PREFIX.'ticket.is_spam=0 and ' .VIS_TABLE_PREFIX.'ticket.draft_id=0';
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object       = new class_report($database);
			list($total, $report) = $object->ticket_post_by_staff_report($filter, $limit, $staff_id, VIS_LOCATION_AREA);
			$view_info['page']=$page;
			$report_count=($report!=-1) ? count($report) : 0;
			$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			$array_summary = array();
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j=0;
				foreach ($report as $i){
					foreach ($i as $key => $val){
						if($key == 'ticket_hash' || $key == 'subject'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'fname' || $key == 'lname' || $key == 'email' || $key == 'group_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'create_date'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id); 
						} elseif($key == 'totalpost'){
							$report_exp[$j][$key] = $val;
						}
					}
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['subject'] 				= $report_exp[$j]['subject'];
					$report_exp1[$j]['client_name'] 	= $report_exp[$j]['fname'].' '.$report_exp[$j]['lname'];
					$report_exp1[$j]['email'] 	= $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] 	= $report_exp[$j]['group_name'];
					$report_exp1[$j]['creation_date'] = $report_exp[$j]['create_date'];
					$report_exp1[$j]['forward_count'] = $report_exp[$j]['totalpost'];
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);	
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function ticket_viewed_by_staff_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTTICKETVIEWEDBYSTAFF'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();

		$report_type = 69;
		$export = 1;
		$report_type=69;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object       = new class_ticket($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$staff            = $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='ticket_viewed_by_staff_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if((isset($operation['vis_action']) && $operation['vis_action']!='') || isset($operation['vis_submit']) && $operation['vis_submit']!=''){
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['staff_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['staff_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' .strtolower($vis_language['TXTSTAFF']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['staff_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				 $service='';
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'auditlog.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'auditlog.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';if($data['service_id']==3)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id=0';}
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX . 'auditlog.entry_date between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'auditlog.operation_id=52 and '.VIS_TABLE_PREFIX.'auditlog.operator_id=' . $data['staff_id'] . ' and ' .VIS_TABLE_PREFIX .'auditlog.operator=2'.$service;
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object       = new class_report($database);
			list($total, $report) = $object->ticket_viewed_by_staff_report($filter, $limit, $staff_id, VIS_LOCATION_AREA);
			$view_info['page']=$page;
			$report_count=($report!=-1) ? count($report) : 0;
			$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j=0;
				foreach ($report as $i){
					foreach ($i as $key => $val){
						if($key == 'ticket_hash' || $key == 'subject'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'entry_date'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id); 
						}
					}
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['subject'] 				= $report_exp[$j]['subject'];
					$report_exp1[$j]['incident_view_date'] = $report_exp[$j]['entry_date'];
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function assets_linkedto_problems_report($operation)
	{
		global $vis_language;
		$filter1='';
		$report_title = $vis_language['TXTASSETLINKTOPROBLEM'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type=70;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'cmdb.php');
		$cmdb_obj = new class_cmdb($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$setting_object=new class_setting($database);
		if(isset($operation['vis_export']) && $operation['vis_export'] == 1){
			$staff_id =  $operation['staff_id'];
		} else {
			$staff_id =  VIS_STAFF_ID;
			$assets = $cmdb_obj->get_assets('', '', '', '', $staff_id, VIS_LOCATION_AREA);
			$citype_details=$setting_object->get_configuration_item_category('','is_enabled=1');
		}
				
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$filter     = VIS_TABLE_PREFIX.'domain.is_enabled=1 ';
		$domain     = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='changes_resolvedby_staff_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}				
				if ($data['vis_asset_id'] == -1  && $data['vis_ci_type'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTASSETNAME']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}				
				if ($data['vis_asset_id'] == -1 && $data['vis_ci_type'] != '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTASSETNAME']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} 
				if ($data['vis_asset_id'] != -1 && $data['vis_ci_type'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . $vis_language['TXTCITYPE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}				
				if ($data['vis_asset_id'] != -1) {
					$filter = 'rel.child_id= '.$data['vis_asset_id'].' and rel.attach_type = 4 and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'];
					$filter1 =' where  '.VIS_TABLE_PREFIX.'customfield.customgroup_id ='.$data['vis_ci_type']. ' and '.VIS_TABLE_PREFIX.'itil_cmdb_assets.assets_id='.$data['vis_asset_id'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';
				}
				$filter = $filter.'#'.$filter1;
			}
			$new_filter = explode('#',$filter);
			$filter = $new_filter[0];
			$filter1 = $new_filter[1];
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$report=array();
			list($custom_fields_details,$report) = $object->get_assets_linkedto_problems($filter,$filter1,'', $staff_id, VIS_LOCATION_AREA);
			$total = ($report!=-1)?count($report):0;
			list($custom_fields_details,$report) = $object->get_assets_linkedto_problems($filter,$filter1,$limit, $staff_id, VIS_LOCATION_AREA);
			if($report!=-1){
				$counts['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=$total;
				$report_count=($report!=-1)?count($report):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);		
			}
			if($custom_fields_details!=-1){
				$temp=array();
				$temp1=array();		
				$temp2=array();	 
				$a=0;
				for($i=0;$i<count($custom_fields_details);$i++){
					$a=$custom_fields_details[$i]['assets_id'];
					if(isset($temp1[$a]['assets_id'])){
						if(isset($temp1[$a]['assets_id']) && $custom_fields_details[$i]['assets_id']!=$temp1[$a]['assets_id']){
							$temp['assets_id']=$custom_fields_details[$i]['assets_id'];
							$a=$custom_fields_details[$i]['assets_id'];
						}
					}
					$temp[$custom_fields_details[$i]['field_name']]=$custom_fields_details[$i]['content'];
					$temp1[$a]=$temp;			 
				}
				$temp2=reset($temp1);
				if($report!=-1){		     
					foreach($report as $key => $csm){
						if(isset($temp1[$csm['assets_id']])){
							if(in_array($report[$key]['assets_id'],$temp1[$csm['assets_id']])){
								foreach($temp1[$csm['assets_id']] as $keys=>$val){
									if($keys!='assets_id')
									$report[$key][$keys]=$val;
								}
							}
						} else{
							foreach($temp2 as $keys=>$val){
								if($keys!='assets_id')
								$report[$key][$keys]='';
							}
						}																					
					}
				}
			}
			if($report!=-1){
				for($i=0; $i<count($report); $i++){
					$is_expired =0;
					$report[$i]['status']='--';
					if($report[$i]['ci_property_type']==2 || $report[$i]['ci_property_type']==1 || $report[$i]['ci_property_type']==8){
						$current_date = get_time_by_tz(strtotime(date('Y-m-d h:i:s')));
						$expiry_date = get_time_by_tz($report[$i]['expiry_date']);						

						if($expiry_date <= $current_date && $expiry_date!=0){
							$report[$i]['status']=format_datetime_rpt($expiry_date,$staff_id);//date(VIS_EDITDATETIMEPICKER_FORMAT,$expiry_date);
						} 
					} 																				
				}
			}
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export         = new export();
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'report.php');
				$report_obj         = new report();
				$j=0;
				foreach ($report as $assets_id => $i) {
					foreach ($i as $key => $val) 
					{
                if ($key == 'ci_type_id') 
                { $report_exp[$j][$key] = $val;
                } elseif ($key == 'ci_property_type') {
                    $report_exp[$j][$key] = $val;
                } 
                elseif ($key == 'problem_hash') {
                    $report_exp[$j][$key] = $val;
                }
                elseif($key == 'name' || $key == 'CNAME' || $key == 'LNAME' || $key == 'first_name' || $key == 'last_name' || $key == 'usedby' || $key == 'status'|| $key == 'description'){
                    $report_exp[$j][$key] = $val;
                } elseif ($key == 'assigned_on') {
                    $report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
                } elseif($key == 'installation_date'){
                    if($val!=0){
                    $report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
                    }else{
                    $report_exp[$j][$key] = $val;
                    }
                } elseif($key == 'expiry_date'){
                    $report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
                } elseif($key == 'last_audit_date'){
                    $report_exp[$j][$key] = format_datetime_rpt($val,$staff_id); 
                } elseif($key == 'impact_name' || $key == 'product_name' || $key =='vender_name' || $key == 'asset_state' || $key == 'depreciation_type' || $key == 'salvage'  || $key == 'warranty_year'  || $key == 'warranty_month'|| $key == 'asset_tag' || $key == 'licence_key' || $key == 'installation_path' ||  $key == 'email' || $key == 'fname' || $key == 'lname' || $key == 'clnt_fname' || $key == 'clnt_lname' || $key == 'licence_type' || $key == 'ci_name' || $key == 'staff_id' || $key == 'domain_name' || $key == 'risk' || $key == 'lifecycle_status' || $key == 'disposition_status' || $key == 'assetdept_name' || $key == 'department_name' || $key == 'migrated_from' || $key == 'storage_location' || $key == 'physical_location' || $key == 'useful_life' || $key == 'barcode' || $key == 'ip_addr' || $key == 'mac_addr' || $key == 'subnet_mask' || $key == 'osname' || $key == 'version' || $key == 'software_type' || $key == 'software_category' || $key == 'manufacturer_name'
                    || $key == 'vis_hostname' || $key == 'vis_model_id'|| $key == 'vis_model_name'|| $key == 'virtual_memory'|| $key == 'total_memory' || $key == 'service_tag' || $key == 'service_pack' || $key == 'firmware' || $key == 'cpu_mb' || $key == 'ios' || $key == 'flash' || $key == 'nvram'  || $key == 'dram' || $key == 'cpu_type' || $key == 'cpu_revision' || $key == 'config_register'  || $key == 'processor_id' || $key=='rem_warranty' || $key == 'ticket_hash' || $key=='subject') { 
                    $report_exp[$j][$key] = $val;   
                } elseif($key == 'details'){
                    
                    $pattern = "/<p[^>]*><\\/p[^>]*>/"; 
                    $data =  preg_replace($pattern, '', $val); 
                    $report_exp[$j][$key] = preg_replace ('/<[^>]*>|&nbsp;/', ' ', $data); 
                } 
				}
						$report_exp1[$j]['Problem_hash'] = $report_exp[$j]['problem_hash'];
						$report_exp1[$j]['Subject'] = $report_exp[$j]['subject'];
						$report_exp1[$j]['asset_name'] = $report_exp[$j]['name'];
			            $report_exp1[$j]['ci_type'] = $report_exp[$j]['ci_name'];
			            $report_exp1[$j]['description'] = $report_exp[$j]['details'];
			            if($report_exp[$j]['staff_id']===''){
			                $report_exp1[$j]['managed_by'] = '---';
			            } else{
			                $report_exp1[$j]['managed_by'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
			            }
			            if(isset($report_exp[$j]['usedby'])){
			                $report_exp1[$j]['used_by'] = $report_exp[$j]['usedby'];
			            } elseif($report_exp[$j]['clnt_fname']=='' || $report_exp[$j]['clnt_lname']==''){
			                $report_exp1[$j]['used_by'] = '---';
			            } else {
			                $report_exp1[$j]['used_by'] = '---'; 
			            } 
			            $report_exp1[$j]['domain_name'] = $report_exp[$j]['domain_name'];
			            $report_exp1[$j]['assigned_on'] = $report_exp[$j]['assigned_on'];
			            $report_exp1[$j]['location'] = $report_exp[$j]['LNAME'];
			            $report_exp1[$j]['impact'] = $report_exp[$j]['impact_name'];
			            if ($report_exp[$j]['ci_type_id']!=1 && $report_exp[$j]['ci_type_id']!=4 && $report_exp[$j]['ci_type_id']!=5 && $report_exp[$j]['ci_type_id']!=6 && $report_exp[$j]['ci_type_id']!=7)
			            {
			                $report_exp1[$j]['warranty_year'] = $report_exp[$j]['warranty_year'];
			                $report_exp1[$j]['warranty_month'] = $report_exp[$j]['warranty_month'];
			            }
			            if ($report_exp[$j]['ci_type_id']==2 || $report_exp[$j]['ci_type_id']==8 ||$report_exp[$j]['ci_type_id']==9 ||$report_exp[$j]['ci_type_id']==10 || $report_exp[$j]['ci_type_id']==11 ||$report_exp[$j]['ci_type_id']==12 ||$report_exp[$j]['ci_type_id']==13)
			            {                       
			                $report_exp1[$j]['acquisition_date'] = $report_exp[$j]['installation_date'];
			                $report_exp1[$j]['assets_state'] = $report_exp[$j]['asset_state'];
			                $report_exp1[$j]['asset_tag'] = $report_exp[$j]['asset_tag'];
			                $report_exp1[$j]['serial_number'] = $report_exp[$j]['licence_key'];

			            }   
			            if ($report_exp[$j]['ci_type_id']!=1 && $report_exp[$j]['ci_type_id']!=4 && $report_exp[$j]['ci_type_id']!=5 && $report_exp[$j]['ci_type_id']!=6 && $report_exp[$j]['ci_type_id']!=7)
			            {
			                $report_exp1[$j]['expiry_date'] = $report_exp[$j]['expiry_date'];
			            }       
			            $report_exp1[$j]['last_audit_date'] = $report_exp[$j]['last_audit_date'];

			            if ($report_exp[$j]['ci_type_id']!=1 && $report_exp[$j]['ci_type_id']!=4 && $report_exp[$j]['ci_type_id']!=5 && $report_exp[$j]['ci_type_id']!=6 && $report_exp[$j]['ci_type_id']!=7)
			            {
			                //$report_exp1[$j]['cost'] = $report_exp[$j]['installation_path'];
			                $report_exp1[$j]['cost'] = ($report_exp[$j]['ci_type_id'] == 3)? $report_exp[$j]['asset_tag']:$report_exp[$j]['installation_path'];

			                $report_exp1[$j]['installation_date'] = $report_exp[$j]['installation_date'];

			            }
			            if ($report_exp[$j]['ci_type_id']!=1 && $report_exp[$j]['ci_type_id']!=3 && $report_exp[$j]['ci_type_id']!=4 && $report_exp[$j]['ci_type_id']!=5 && $report_exp[$j]['ci_type_id']!=6 && $report_exp[$j]['ci_type_id']!=7)
			            {
			                $report_exp1[$j]['vender'] = $report_exp[$j]['vender_name'];
			                $report_exp1[$j]['salvage'] = $report_exp[$j]['salvage'];
			                $report_exp1[$j]['depreciation_type'] = $report_exp[$j]['depreciation_type'];
			                $report_exp1[$j]['useful_life(in_years)'] = $report_exp[$j]['useful_life'];
			                $report_exp1[$j]['barcode'] = $report_exp[$j]['barcode'];
			                $report_exp1[$j]['ip_address'] = $report_exp[$j]['ip_addr'];
			                $report_exp1[$j]['mac_address'] = $report_exp[$j]['mac_addr'];
			                $report_exp1[$j]['subnet_mask'] = $report_exp[$j]['subnet_mask'];                   
			                $report_exp1[$j]['operating_system'] = $report_exp[$j]['osname'];

			            }
			            if ($report_exp[$j]['ci_type_id']==2)
			            {
			                $report_exp1[$j]['product'] = $report_exp[$j]['product_name'];
			                /* $report_exp1[$j]['warranty_expiry_date'] = $report_exp[$j]['expiry_date']; */
			                $report_exp1[$j]['firmware'] = $report_exp[$j]['firmware'];
			                $report_exp1[$j]['cpu_mb'] = $report_exp[$j]['cpu_mb'];
			                $report_exp1[$j]['ios'] = $report_exp[$j]['ios'];
			                $report_exp1[$j]['flash'] = $report_exp[$j]['flash'];
			                $report_exp1[$j]['nvram'] = $report_exp[$j]['nvram'];
			                $report_exp1[$j]['dram'] = $report_exp[$j]['dram'];
			                $report_exp1[$j]['cpu_type'] = $report_exp[$j]['cpu_type'];
			                $report_exp1[$j]['cpu_revision'] = $report_exp[$j]['cpu_revision'];
			                $report_exp1[$j]['config_register'] = $report_exp[$j]['config_register'];
			                $report_exp1[$j]['processor_id'] = $report_exp[$j]['processor_id'];
			            }   
			            $report_exp1[$j]['risk'] = $report_exp[$j]['risk'];
			            if ($report_exp[$j]['ci_type_id']==3)
			            {
			                $report_exp1[$j]['licence_key'] = $report_exp[$j]['licence_key'];   
			                $report_exp1[$j]['licence_type'] = $report_exp[$j]['licence_type']; 
			                $report_exp1[$j]['version'] = $report_exp[$j]['version'];
			                $report_exp1[$j]['software_type'] = $report_exp[$j]['software_type'];
			                $report_exp1[$j]['software_category'] = $report_exp[$j]['software_category'];
			                $report_exp1[$j]['installation_path'] = $report_exp[$j]['installation_path'];       
			            }
			            $report_exp1[$j]['lifecycle_status'] = $report_exp[$j]['lifecycle_status'];
			            $report_exp1[$j]['disposition_status'] = $report_exp[$j]['disposition_status'];         
			            $report_exp1[$j]['asset_department'] = $report_exp[$j]['assetdept_name'];               
			            $report_exp1[$j]['migrated_from'] = $report_exp[$j]['migrated_from'];
			            $report_exp1[$j]['storage_location'] = $report_exp[$j]['storage_location'];
			            $report_exp1[$j]['physical_location'] = $report_exp[$j]['physical_location'];
			            if ($report_exp[$j]['ci_type_id']!=1 && $report_exp[$j]['ci_type_id']!=2 && $report_exp[$j]['ci_type_id']!=4 && $report_exp[$j]['ci_type_id']!=5 && $report_exp[$j]['ci_type_id']!=6 && $report_exp[$j]['ci_type_id']!=7)
			            {
			                $report_exp1[$j]['manufacturer'] = $report_exp[$j]['manufacturer_name'];    
			            }
			            if ($report_exp[$j]['ci_type_id']==8 || $report_exp[$j]['ci_type_id']==9 || $report_exp[$j]['ci_type_id']==10 || $report_exp[$j]['ci_type_id']==11 ||$report_exp[$j]['ci_type_id']==12 ||$report_exp[$j]['ci_type_id']==13)
			            {
			                $report_exp1[$j]['host_name'] = $report_exp[$j]['vis_hostname'];
			                $report_exp1[$j]['model'] = $report_exp[$j]['vis_model_name'];
			                $report_exp1[$j]['virtual_memory'] = $report_exp[$j]['virtual_memory'];
			                $report_exp1[$j]['total_memory'] = $report_exp[$j]['total_memory'];
			                $report_exp1[$j]['service_tag'] = $report_exp[$j]['service_tag'];
			                $report_exp1[$j]['service_pack'] = $report_exp[$j]['service_pack'];
			            }
					if($custom_fields_details!=-1){
						for($m=0;$m<count($custom_fields_details);$m++){
							if($custom_fields_details[$m]['assets_id'] == $i['assets_id']){
								$report_exp1[$assets_id][$custom_fields_details[$m]['field_name']] = $custom_fields_details[$m]['content'];
							}
						}
					}
					$j++;
				}
				//echo "<pre>";print_r($report_exp1);echo "</pre>";
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);	
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function assets_expiry_report($operation)
	{   
		global $vis_language;
		$report_title = $vis_language['TXTASSETEXPIRYRPT'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type=71;
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$setting_object=new class_setting($database);
		$citype_details=$setting_object->get_configuration_item_category('','is_enabled=1');
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$staff      = $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA);
		$filter     = VIS_TABLE_PREFIX.'domain.is_enabled=1 ';
		$domain     = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='changes_resolvedby_staff_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';		
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}		
				if ($data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} 	
				if ($data['vis_ci_type'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . $vis_language['TXTCITYPE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['status_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTSTATUS']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}				
				if ($data['status_id'] == -1 && $data['vis_ci_type'] != '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTSTATUS']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
							
				if ($data['status_id'] != -1 && $data['vis_ci_type'] != '') {
					$filter = $data['status_id'].' and '.$data['vis_ci_type'].' and '.$data['domain_id']; 
				}
			}			
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$temp = explode('and',$filter);  
 
			$statusid =  $temp[0];
			$ci_type = $temp[1];			
			$domain_id = $temp[2];			
			$data['vis_ci_type']=(isset($ci_type) && $ci_type!='')?$ci_type:$data['vis_ci_type'];
			$data['domain_id']=(isset($domain_id) && $domain_id!='')?$domain_id:$data['domain_id'];
			if($statusid == 1 && $ci_type!=''){ //not expired hardware
				$filter = ' cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'].' and cmast.expiry_date > unix_timestamp() and cmast.expiry_date!=""';
				$filter1 = ' where '.VIS_TABLE_PREFIX.'customfield.customgroup_id ='.$ci_type.' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';
				$custom_order=' group by assets_id order by cmast.expiry_date asc ';
			} elseif($statusid == 2 && $ci_type!= ''){ // expired hardware
				$filter = ' cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'].' and cmast.expiry_date < unix_timestamp() and cmast.expiry_date!=""';
				$filter1 = ' where '.VIS_TABLE_PREFIX.'customfield.customgroup_id ='.$ci_type.' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1 and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1 ';
				$custom_order=' group by assets_id order by cmast.expiry_date desc ';
			}  
			$filter1 = isset($filter1) ? $filter1 : "";
			$custom_order = isset($custom_order) ? $custom_order : "";
			$filter=$filter.'#'.$filter1.'#'.$custom_order;
			$temp_filtr = explode('#',$filter);
			$filter = $temp_filtr[0];
			$filter1= $temp_filtr[1];
			$custom_order= $temp_filtr[2];
			$report=array();
			$report1=array();
			list($custom_fields_details,$report1) = $object->assets_groupby_status($filter,'', $staff_id, VIS_LOCATION_AREA,$filter1,$custom_order);
			$total = ($report1!=-1)?count($report1):0;
			list($custom_fields_details,$report1) = $object->assets_groupby_status($filter,$limit, $staff_id, VIS_LOCATION_AREA,$filter1,$custom_order); 
			if($report!=-1){
				$counts['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=$total;
				$report_count=($report1!=-1)?count($report1):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			if($report1!=-1){
				for($i=0; $i<count($report1); $i++){
					$is_expired =0;
					if($report1[$i]['ci_property_type']==2 || $report1[$i]['ci_property_type']==1 || $report1[$i]['ci_property_type']==8){
						$current_date = get_time_by_tz(strtotime(date('Y-m-d h:i:s')));
						$expiry_date = get_time_by_tz($report1[$i]['expiry_date']);
						if($expiry_date <= $current_date){
							$is_expired=1;
							$report1[$i]['is_expired']=1; 
							$report1[$i]['status']=format_datetime_rpt($expiry_date,$staff_id); //date(VIS_EDITDATETIMEPICKER_FORMAT,$expiry_date);
						} else {
							$is_expired=2;
							$report1[$i]['is_expired']=2; 
							$report1[$i]['status']=format_datetime_rpt($expiry_date,$staff_id); //date(VIS_EDITDATETIMEPICKER_FORMAT,$expiry_date); 
						} 
					} else {
						$report1[$i]['status']='--';
						$report1[$i]['is_expired'] = '';
					}
				}
				$report=array();
				if($report1!=-1 && !empty($report1)){ 
					for($k=0; $k<count($report1); $k++){
						if($report1[$k]['ci_type_id']==$data['vis_ci_type'] || $report1[$k]['ci_type_id']==$data['vis_ci_type']){
							if($report1[$k]['is_expired']!=$statusid){
								$report[]=$report1[$k];
							}
						} else {
							$report[]=$report1[$k];
						}
					} 
				} 
			}  
			if(isset($operation['vis_export']) && $operation['vis_export'] == 1) 
			{
				
				include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'cmdb.php');
				$cmdb_module = new cmdb();
		   	    list($custom_fields_details,$report_exp1) = $cmdb_module->get_assets_data($report,$staff_id,'',$custom_fields_details);		

				$completed_date = date('Y-m-d h:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
				return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function assets_groupby_location_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTASSETGROUPBYLOCATIONS'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type=72; 
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$staff      = $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA);
		$filter     = VIS_TABLE_PREFIX.'domain.is_enabled=1 ';
		$domain     = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='assets_groupby_location_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if(VIS_LOCATION_AREA==2){						
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			$object=new class_setting($database);
			$citype_details=$object->get_configuration_item_category('','is_enabled=1');
			$location='';								
			$filters='';
			$location_details=$object->get_locations($filters,0, -1, '', $staff_id);
			$search = (count($location_details)>10)? 'data-live-search="true"' : '';
			$location .= "<option value=''>".$vis_language['TXTSELECT']."</option>";
			$location .= "<option value='0'>".$vis_language['TXTALL']."</option>";
			$location .= $this->vis_show_subcategories($location_details,'','location');
		}	      
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}				
				if ($data['location_id'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTLOCATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['domain_id'] == 0 || $data['domain_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} 
				if ($data['vis_ci_type'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . $vis_language['TXTCITYPE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}				
				if ($data['location_id'] != -1 && $data['vis_ci_type'] != '') {
					if($data['location_id']!=0){
						$filter = 'cmast.location_id='.$data['location_id'].' and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id']; 
					}else{
						$filter = 'cmast.location_id!='.$data['location_id'].' and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id']; 
					}
				}
				$filter1 =$data['vis_ci_type'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1 ';
				$filter=$filter.'#'.$filter1;
			}				  
			$temp_filtr = explode('#',$filter);					 
			$filter = $temp_filtr[0];
			$filter1= $temp_filtr[1];
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$report=array();

			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'cmdb.php');
            $cmdb_object = new class_cmdb($database);

			list($custom_fields_details, $report) = $cmdb_object->get_cmdb_assets_data($filter,'', $staff_id, VIS_LOCATION_AREA, $filter1);
			$total = ($report!=-1)?count($report):0;
			list($custom_fields_details, $report) = $cmdb_object->get_cmdb_assets_data($filter,$limit, $staff_id, VIS_LOCATION_AREA, $filter1);

			if($report!=-1){
				$counts['page_count']=(count($report)==0)?0:ceil( count($report)/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($report);
				$report_count=($report!=-1)?count($report):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			if($report!=-1){					
				for($i=0; $i<count($report); $i++){						
					$is_expired =0;
					if($report[$i]['ci_property_type']==1 || $report[$i]['ci_property_type']==2 || $report[$i]['ci_property_type']==8){
						$current_date = get_time_by_tz(strtotime(date('Y-m-d h:i:s')));
						$expiry_date = get_time_by_tz($report[$i]['expiry_date']);
						if($expiry_date <= $current_date){
							$report[$i]['status']=format_datetime_rpt($expiry_date,$staff_id); //date(VIS_EDITDATETIMEPICKER_FORMAT,$expiry_date);
						} else {
							$report[$i]['status']=format_datetime_rpt($expiry_date,$staff_id); //date(VIS_EDITDATETIMEPICKER_FORMAT,$expiry_date);
						} 
					} else {
						$report[$i]['status']='--';
					}						
				}
			}				
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {		
				include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'cmdb.php');
				$cmdb_module = new cmdb();
		   	    list($custom_fields_details,$report_exp1) = $cmdb_module->get_assets_data($report,$staff_id,'',$custom_fields_details);		
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);	
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function task_by_status_report($operation)
	{
		global $vis_language;
		$report_type = 73;
		$filter='';
		$report_title = $vis_language['TXTSTATUSTASK'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();

		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$staff      = $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$setting_object=new class_setting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='task_by_status_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		$custom_filter = ' location=13 and is_enabled=1';
		$custom_grouplist = $setting_object->get_custom_group_list($custom_filter, $staff_id, VIS_LOCATION_AREA);
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}

				if($data['vis_status']==0){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] . ' ' . strtolower($vis_language['TXTSTATUS']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;	
				}
				if ($data['vis_status'] == 1){
					$filter = VIS_TABLE_PREFIX.'task.task_status=1 and ('.VIS_TABLE_PREFIX.'task.enddate-unix_timestamp()) > 0 ';
				} elseif ($data['vis_status'] == 2){
					$filter = '('.VIS_TABLE_PREFIX.'task.enddate-unix_timestamp()) <= 0 and ('.VIS_TABLE_PREFIX.'task.task_status!=3 and '.VIS_TABLE_PREFIX.'task.task_status!=4)';
				} elseif ($data['vis_status'] == 3){
					$filter = VIS_TABLE_PREFIX.'task.task_status=3';
				} elseif ($data['vis_status'] == 4){
					$filter = VIS_TABLE_PREFIX.'task.task_status=4';
				} elseif ($data['vis_status'] == 5){
					$filter = '('.VIS_TABLE_PREFIX.'task.enddate-unix_timestamp()) > 0 and '.VIS_TABLE_PREFIX.'task.task_status=5';
				}
				if($data['vis_status'] == -1){
					$filter .= VIS_TABLE_PREFIX.'task.autotask_flag=0';
				} else {
					$filter .= ' and '.VIS_TABLE_PREFIX.'task.autotask_flag=0';
				}
				$filter=($filter!='')?$filter.' and '.VIS_TABLE_PREFIX.'task.staff_id='.VIS_STAFF_ID:' '.VIS_TABLE_PREFIX.'task.staff_id='.VIS_STAFF_ID;
				$data['staff_id']=VIS_STAFF_ID;
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$report = $object->task_groupby_status_report($filter, '', $staff_id, VIS_LOCATION_AREA);
			$total_cnt=($report != -1)?count($report):0;
			$total=$total_cnt;
			$report = $object->task_groupby_status_report($filter, $limit, $staff_id, VIS_LOCATION_AREA);
			if($report!=-1){
				$counts['page_count']=(count($report)==0)?0:ceil( count($report)/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($report);
				$report_count=($report!=-1)?count($report):0;
				$view_info['page_count']=($total_cnt==0)?0:ceil($total_cnt/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filtern=VIS_TABLE_PREFIX.'customgroup.location = 13 and '.VIS_TABLE_PREFIX.'customgroup.is_enabled = 1';
				$custom_fields_details=$object->task_custom_field($filtern);
				$temp=array();
				$temp1=array();		
				$temp2=array();	 
				$a=0;
				if($custom_fields_details!=-1){
					for($i=0;$i<count($custom_fields_details);$i++){
						$a=$custom_fields_details[$i]['task_id'];
						if($custom_fields_details[$i]['task_id']!=$temp1[$a]['task_id']){
							$temp['task_id']=$custom_fields_details[$i]['task_id'];
							$a=$custom_fields_details[$i]['task_id'];
						}
						$temp[$custom_fields_details[$i]['field_name']]=$custom_fields_details[$i]['content'];
						$temp1[$a]=$temp;			 
					}
					$temp2=reset($temp1);
					foreach($report as $key => $csm){
						if(in_array($report[$key]['task_id'],$temp1[$csm['task_id']])){
							foreach($temp1[$csm['task_id']] as $keys=>$val){
								if($keys!='task_id')
									$report[$key][$keys]=$val;
							}
						} else {
							foreach($temp2 as $keys=>$val){
								if($keys!='task_id')
									$report[$key][$keys]='';
							}
						}
					}
				}
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j = 0;
				foreach ($report as $i) {
					foreach ($i as $key => $val) {
						if ($key == 'task_title') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'startdate') {
							$report_exp[$j]['creation_date'] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'enddate') {
							$report_exp[$j]['end_date'] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'title') {
							$report_exp[$j]['priority'] = $val;
						} elseif ($key == 'task_status') {
							if($report[$j]['enddate_diff']<=0){
								if($val!=3 && $val!=4 && $val!=5){
									$report_exp[$j]['status'] =$vis_language['TXTOVERDUE']; 
								} else {
									if($val==1) {
										$report_exp[$j]['status'] =$vis_language['TXTINPROGRESS']; 
									} else if($val==3){
										$report_exp[$j]['status'] =$vis_language['TXTCOMPLETED']; 
									} else if($val==4){ 
										$report_exp[$j]['status'] =$vis_language['TXTCANCELED'];  
									} else if($val==5){ 
										$report_exp[$j]['status'] =$vis_language['TXTNOTSTARTED']; 
									}
								} 
							} else { 
								if($val==1) {
									$report_exp[$j]['status'] =$vis_language['TXTINPROGRESS']; 
								} else if($val==2){
									$report_exp[$j]['status'] =$vis_language['TXTOVERDUE'];  
								} else if($val==3){
									$report_exp[$j]['status'] =$vis_language['TXTCOMPLETED'];  
								} else if($val==4){ 
									$report_exp[$j]['status'] =$vis_language['TXTCANCELED']; 
								} else if($val==5){ 
									$report_exp[$j]['status'] =$vis_language['TXTNOTSTARTED']; 	
								}
							} 
						} elseif($key!='task_title' && $key!='startdate' && $key!='enddate' && $key!='title' && $key!='enddate_diff' && $key!='task_status' && $key!='priority'){
							if($key=='startdate'){
								$key = 'creation_date';
							} elseif($key=='enddate'){
								$key = 'end_date';
							} elseif($key=='title'){
								$key = 'priority';
							} elseif($key=='task_status'){
								$key = 'status';
							}
							$report_exp[$j][$key] = $val;
						}
					}
					if($custom_grouplist!=-1){
						for($m=0;$m<count($custom_grouplist);$m++){
							$filter = VIS_TABLE_PREFIX.'customfield.customgroup_id='.$custom_grouplist[$m]['customgroup_id'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1 ';
							$customfield = $setting_object->get_customfield(2, $filter, '', 0, 0, $staff_id, VIS_LOCATION_AREA);
							if($customfield[1]!=-1){
								$fieldcontent = $prevFieldGroup = '';
								$prevContent = '---';
								for($s=0;$s<count($customfield[1]);$s++){
									$customfield_data = $tkt_object->get_customfield_data($customfield[1][$s]['customfield_id'], $i['task_id'], '');
									if($customfield_data!=-1){
										if(isset($customfield_data['content']) && $customfield_data['content']!=''){
											if($prevFieldGroup == $customfield[1][$s]['field_group']){
												if($customfield_data['parent_id'] != $i['task_id']){
													$fieldcontent = $customfield_data['content'].'|';
												} else {
													$fieldcontent .= $customfield_data['content'].'|';
												}
												$previousContent = '';
											} elseif($prevContent!='' && $prevFieldGroup == $customfield[1][$s]['field_group']){
												$fieldcontent .= $customfield_data['content'].'|';
											} else {
												$fieldcontent = $customfield_data['content'].'|';
											}
											$report_exp[$j][$customfield[1][$s]['field_name']] = ($fieldcontent!='') ? substr($fieldcontent,0,-1) : '';
											$previousContent = $customfield_data['content'];
										}
										$customfields_title[] = $customfield[1][$s]['field_name'];
									} else {
										if($fieldcontent!='' && $prevFieldGroup == $customfield[1][$s]['field_group']){
											$report_exp[$j][$customfield[1][$s]['field_name']] = ($fieldcontent!='') ? substr($fieldcontent,0,-1) : '';
											$prevContent = '';
										} elseif($fieldcontent=='' && $prevFieldGroup != $customfield[1][$s]['field_group']){
											$report_exp[$j][$customfield[1][$s]['field_name']] = ($customfield_data['content']!='') ? $previousContent : $prevContent;
											$previousContent = '';
										} else {
											$fieldcontent = '';
											$prevContent = '';
											$previousContent = '';
											$report_exp[$j][$customfield[1][$s]['field_name']] = '---';
										}
									}
									$prevContent = $customfield_data['content'];
									$prevFieldGroup = $customfield[1][$s]['field_group'];
								}
							}
						}
					}
					unset($report_exp[$j]['task_id']);
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp);	
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total_cnt,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE.'report_page.php');
			}  
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true; 
	}	

	function task_by_priority_report($operation)
	{
		global $vis_language;
		$report_type = 171;
		$filter='';
		$report_title = $vis_language['TXTPRIORITYTASK'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();

		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$staff      = $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$setting_object=new class_setting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='task_by_priority_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		$custom_filter = ' location=13 and is_enabled=1';
		$custom_grouplist = $setting_object->get_custom_group_list($custom_filter, $staff_id, VIS_LOCATION_AREA);
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}

				if($data['vis_priority']==0){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] . ' ' . strtolower($vis_language['TXTPRIORITY']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;	
				}				
			if($data['vis_priority'] == -1)  $filter = VIS_TABLE_PREFIX.'task.autotask_flag=0'; 
			else $filter = VIS_TABLE_PREFIX.'task.priority='.$data['vis_priority'].' and '.VIS_TABLE_PREFIX.'task.autotask_flag=0';
			$filter .=' and '.VIS_TABLE_PREFIX.'task.staff_id='.VIS_STAFF_ID;
			$data['staff_id']=VIS_STAFF_ID;
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$report = $object->task_groupby_status_report($filter, '', $staff_id, VIS_LOCATION_AREA);
			$total_cnt=($report != -1)?count($report):0;
			$total=$total_cnt;
			$report = $object->task_groupby_status_report($filter, $limit, $staff_id, VIS_LOCATION_AREA);
			if($report!=-1){
				$counts['page_count']=(count($report)==0)?0:ceil( count($report)/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($report);
				$report_count=($report!=-1)?count($report):0;
				$view_info['page_count']=($total_cnt==0)?0:ceil($total_cnt/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filtern=VIS_TABLE_PREFIX.'customgroup.location = 13 and '.VIS_TABLE_PREFIX.'customgroup.is_enabled = 1';
				$custom_fields_details=$object->task_custom_field($filtern);
				$temp=array();
				$temp1=array();		
				$temp2=array();	 
				$a=0;
				if($custom_fields_details!=-1){
					for($i=0;$i<count($custom_fields_details);$i++){
						$a=$custom_fields_details[$i]['task_id'];
						if($custom_fields_details[$i]['task_id']!=$temp1[$a]['task_id']){
							$temp['task_id']=$custom_fields_details[$i]['task_id'];
							$a=$custom_fields_details[$i]['task_id'];
						}
						$temp[$custom_fields_details[$i]['field_name']]=$custom_fields_details[$i]['content'];
						$temp1[$a]=$temp;			 
					}
					$temp2=reset($temp1);
					foreach($report as $key => $csm){
						if(in_array($report[$key]['task_id'],$temp1[$csm['task_id']])){
							foreach($temp1[$csm['task_id']] as $keys=>$val){
								if($keys!='task_id')
									$report[$key][$keys]=$val;
							}
						} else {
							foreach($temp2 as $keys=>$val){
								if($keys!='task_id')
									$report[$key][$keys]='';
							}
						}
					}
				}
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j = 0;
				foreach ($report as $i) {
					foreach ($i as $key => $val) {
						if ($key == 'task_title') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'startdate') {
							$report_exp[$j]['creation_date'] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'enddate') {
							$report_exp[$j]['end_date'] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'title') {
							$report_exp[$j]['priority'] = $val;
						}
						
						elseif($key!='task_title' && $key!='startdate' && $key!='enddate' && $key!='title' && $key!='enddate_diff' && $key!='task_status' && $key!='priority'){
							if($key=='startdate'){
								$key = 'creation_date';
							} elseif($key=='enddate'){
								$key = 'end_date';
							} elseif($key=='title'){
								$key = 'priority';
							} elseif($key=='task_status'){
								$key = 'status';
							}
							$report_exp[$j][$key] = $val;
						}
					}
					if($custom_grouplist!=-1){
						for($m=0;$m<count($custom_grouplist);$m++){
							$filter = VIS_TABLE_PREFIX.'customfield.customgroup_id='.$custom_grouplist[$m]['customgroup_id'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1 ';
							$customfield = $setting_object->get_customfield(2, $filter, '', 0, 0, $staff_id, VIS_LOCATION_AREA);
							if($customfield[1]!=-1){
								$fieldcontent = $prevFieldGroup = '';
								$prevContent = '---';
								for($s=0;$s<count($customfield[1]);$s++){
									$customfield_data = $tkt_object->get_customfield_data($customfield[1][$s]['customfield_id'], $i['task_id'], '');
									if($customfield_data!=-1){
										if(isset($customfield_data['content']) && $customfield_data['content']!=''){
											if($prevFieldGroup == $customfield[1][$s]['field_group']){
												if($customfield_data['parent_id'] != $i['task_id']){
													$fieldcontent = $customfield_data['content'].'|';
												} else {
													$fieldcontent .= $customfield_data['content'].'|';
												}
												$previousContent = '';
											} elseif($prevContent!='' && $prevFieldGroup == $customfield[1][$s]['field_group']){
												$fieldcontent .= $customfield_data['content'].'|';
											} else {
												$fieldcontent = $customfield_data['content'].'|';
											}
											$report_exp[$j][$customfield[1][$s]['field_name']] = ($fieldcontent!='') ? substr($fieldcontent,0,-1) : '';
											$previousContent = $customfield_data['content'];
										}
										$customfields_title[] = $customfield[1][$s]['field_name'];
									} else {
										if($fieldcontent!='' && $prevFieldGroup == $customfield[1][$s]['field_group']){
											$report_exp[$j][$customfield[1][$s]['field_name']] = ($fieldcontent!='') ? substr($fieldcontent,0,-1) : '';
											$prevContent = '';
										} elseif($fieldcontent=='' && $prevFieldGroup != $customfield[1][$s]['field_group']){
											$report_exp[$j][$customfield[1][$s]['field_name']] = ($customfield_data['content']!='') ? $previousContent : $prevContent;
											$previousContent = '';
										} else {
											$fieldcontent = '';
											$prevContent = '';
											$previousContent = '';
											$report_exp[$j][$customfield[1][$s]['field_name']] = '---';
										}
									}
									$prevContent = $customfield_data['content'];
									$prevFieldGroup = $customfield[1][$s]['field_group'];
								}
							}
						}
					}
					unset($report_exp[$j]['task_id']);
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp);	
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total_cnt,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE.'report_page.php');
			}  
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true; 
	}

	function report_date_range_validation($from_date, $to_date)
	{
		global $vis_language;
		$vis_from_date = strtotime($from_date);
		$vis_to_date   = strtotime($to_date);
		$datetime1 = new DateTime($from_date);
		$datetime2 = new DateTime($to_date);
		$dateDiff = get_timespan_difference($datetime1, $datetime2);
		if ($vis_from_date > $vis_to_date) {
			return array(false,$vis_language['MSGFROMLESSTHANTO']);
		} else if ($dateDiff['y'] > 0) {
			return array(false,$vis_language['MSGDURATIONLESSTHANTHREEMONTHS']);
		} elseif ($dateDiff['m'] > 3) {
			return array(false,$vis_language['MSGDURATIONLESSTHANTHREEMONTHS']);
		} elseif ($dateDiff['m'] == 3) {
			if ($dateDiff['d'] > 0) {
				return array(false,$vis_language['MSGDURATIONLESSTHANTHREEMONTHS']);
			}
		}
		return array(true,'');
	}	

	function custom_date_diffrence($from_date, $to_date)
	{
		$from_date = strtotime($from_date);
		$to_date   = strtotime($to_date);
		$diff = abs($to_date - $from_date);
		$years = floor($diff / (365*60*60*24));
		$months = floor(($diff - $years * 365*60*60*24) / (30*60*60*24));
		$days = floor(($diff - $years * 365*60*60*24 - $months*30*60*60*24)/ (60*60*24));
		if($from_date > $to_date){
			return array(false, $vis_language['MSGFROMLESSTHANTO']);
		} else if($years>0){
			return array(false, $vis_language['MSGDURATIONLESSTHANTHREEMONTHS']);
		} elseif($months>3){
			return array(false, $vis_language['MSGDURATIONLESSTHANTHREEMONTHS']);
		} elseif($months<=3){
			if($months==3){
				if($days>0){
					return array(false, $vis_language['MSGDURATIONLESSTHANTHREEMONTHS']);
				}	
			}
		}
		return array(true,'');
	}
	
	function email_send_download($operation)
	{
		include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'report.php');
		$report_obj         = new report();
		$report_obj->email_send_download($operation);
	}

	function vis_show_subcategories($config_details,$call,$flag) {
		if($flag=='ci')
			$id='item_id';
		elseif($flag=='location')
			$id='location_id';
		
		$options ='';
		for($i=0;$i<count($config_details);$i++) { 
			$options .='<option value="'.$config_details[$i][$id].'">'.$config_details[$i]['name'].'</option>';
			if(isset($config_details[$i]['subcat']) && $config_details[$i]['subcat']!=NULL) { 
				$options .=$this->vis_show_subcategories($config_details[$i]['subcat'],'sub_cat',$flag); 
			}
		}
		return $options;
	}

	function assets_asset_type_report($operation)
	{
		global $vis_language;
		$report_title = ucfirst(strtolower($vis_language['TXTASSETTYPE']));
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database(); 
		$report_type=74;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$staff      = $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA);
		$filter     = VIS_TABLE_PREFIX.'domain.is_enabled=1 ';
		$domain     = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='changes_resolvedby_staff_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		$cust_ass_report_details=0;
		if(VIS_LOCATION_AREA==2){						
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			$setting_object=new class_setting($database);	
			$config_details=$setting_object->get_configuration_item_category('','is_enabled=1'); 			
			 				
		}
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if ($data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} 
				if ($data['location_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . $vis_language['TXTCITYPE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['location_id'] != -1) {
					$filter = 'cmast.ci_type_id='.$data['location_id'].' and cmast.department_access='.$data['domain_id']; 

				}
				$filter1 =$data['location_id'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';
				$filter=$filter.'#'.$filter1;
			}
			
			$temp_filtr = explode('#',$filter);
			$filter = $temp_filtr[0];
			$filter1= $temp_filtr[1];
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$report = array();
			 
			if(isset($operation['export_id']) && $operation['export_id']!=0){
				
			 $cust_ass_report_details=$object->get_filter_export_download_queue($operation['export_id'], $staff_id, VIS_LOCATION_AREA);
			} 
			$report = array();
			if($cust_ass_report_details!=-1 && $cust_ass_report_details!=0){
				if($cust_ass_report_details[0]['export_name'] == $operation['export_name'])
				{
					$report = $object->assets_custom_report_by_asset_type($cust_ass_report_details[0]['filter'],'', $staff_id, VIS_LOCATION_AREA);
					$total = count($report);
					$custom_fields_details=-1;
					
				}else{
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'cmdb.php');
            		$cmdb_object = new class_cmdb($database);

					list($custom_fields_details, $report) = $cmdb_object->get_cmdb_assets_data($filter,'', $staff_id, VIS_LOCATION_AREA, $filter1);
					$total = ($report!=-1)?count($report):0;
					list($custom_fields_details, $report) = $cmdb_object->get_cmdb_assets_data($filter,$limit, $staff_id, VIS_LOCATION_AREA, $filter1);
				}
			}else{
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'cmdb.php');
            		$cmdb_object = new class_cmdb($database);

					list($custom_fields_details, $report) = $cmdb_object->get_cmdb_assets_data($filter,'', $staff_id, VIS_LOCATION_AREA, $filter1);
					$total = ($report!=-1)?count($report):0;
					list($custom_fields_details, $report) = $cmdb_object->get_cmdb_assets_data($filter,$limit, $staff_id, VIS_LOCATION_AREA, $filter1);
			}
			 
			if($report!=-1){
				$counts['page_count']=(count($report)==0)?0:ceil( count($report)/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($report);
				$report_count=($report!=-1)?count($report):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			if($report!=-1){
				for($i=0; $i<count($report); $i++){ 
					$is_expired =0;
					if($report[$i]['ci_type_id']==2 || $report[$i]['ci_type_id']==3){
						$current_date = get_time_by_tz(strtotime(date('Y-m-d h:i:s'))); 
						$expiry_date = get_time_by_tz($report[$i]['expiry_date']);
						if($expiry_date <= $current_date){
							$report[$i]['status']=format_datetime_rpt($expiry_date,$staff_id); //date(VIS_EDITDATETIMEPICKER_FORMAT,$expiry_date);
						} else {
							$report[$i]['status']=format_datetime_rpt($expiry_date,$staff_id); //date(VIS_EDITDATETIMEPICKER_FORMAT,$expiry_date);
						}
					} else {
						$report[$i]['status']='--';
					} 
				}
			}
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'cmdb.php');
				$cmdb_module = new cmdb();
		   	    list($custom_fields_details,$report_exp1) = $cmdb_module->get_assets_data($report,$staff_id,'',$custom_fields_details);	
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = ucfirst(strtolower($report_title));
				$filename=$this->export_subreport($operation,$report_exp1);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}
	
	function export_assets_custom_report($operation)
	{
		global $vis_language;
		$report_title = ucfirst(strtolower($vis_language['TXTCUSTOMREPORT'].' - '.$vis_language['TXTASSETS']));
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database(); 

		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$staff      = $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='changes_resolvedby_staff_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		$cust_ass_report_details=0;
		if(VIS_LOCATION_AREA==2){						
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			$setting_object=new class_setting($database);	
			$config_details=$setting_object->get_configuration_item_category('','is_enabled=1'); 			
			 				
		}
		if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
			
				$filter = $operation['filter'];
				$limit = '';
			
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'cmdb.php');
			$object_cmdb = new class_cmdb($database);
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$report = array();
			 
			if(isset($operation['export_id']) && $operation['export_id']!=0){
				
			 $cust_ass_report_details=$object->get_filter_export_download_queue($operation['export_id'], $staff_id, VIS_LOCATION_AREA);
			} 
			
			$report = array();
			if($cust_ass_report_details!=-1 && $cust_ass_report_details!=0){
				if($cust_ass_report_details[0]['export_name'] == str_replace("_"," ",$operation['export_name']))
				{
					list($custom_fields_details,$report) = $object_cmdb->get_assets_custom_report($cust_ass_report_details[0]['filter'], '', '', '', $staff_id, VIS_LOCATION_AREA);
					$total_cnt = count($report);
					$custom_fields_details=-1;
					
				}
			}
			if($report!=-1){
				for($i=0; $i<count($report); $i++){ 
					$is_expired =0;
					if($report[$i]['ci_type_id']==2 || $report[$i]['ci_type_id']==3){
						$current_date = get_time_by_tz(strtotime(date('Y-m-d h:i:s'))); 
						$expiry_date = get_time_by_tz($report[$i]['expiry_date']);
						if($expiry_date <= $current_date){
							$report[$i]['status']=format_datetime_rpt($expiry_date,$staff_id); 
						} else {
							$report[$i]['status']=format_datetime_rpt($expiry_date,$staff_id); 
						}
					} else {
						$report[$i]['status']='';
					} 
				}
			}
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export         = new export();
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'report.php');
				$report_obj         = new report();
				$j=0;
				foreach ($report as $assets_id => $i) {
					foreach ($i as $key => $val){
						if ($key == 'ci_type_id') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'assigned_on') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif($key == 'installation_date'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif($key == 'expiry_date'){
							$report_exp[$j][$key] =format_datetime_rpt($val,$staff_id);
						} elseif($key == 'last_audit_date'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'description') {
							$report_exp[$j][$key] = $val;
						} elseif($key == 'name' || $key == 'ci_type' || $key == 'location' ||  $key == 'usedby' || $key == 'status')	{			
							$report_exp[$j][$key] = $val;
						} elseif($key == 'impact_name' || $key == 'product_name' || $key =='vender_name' || $key == 'asset_state' || $key == 'depreciation_type' || $key == 'salvage'  || $key == 'warranty_year'  || $key == 'warranty_month'|| $key == 'asset_tag' || $key == 'licence_key' || $key == 'installation_path' || $key == 'first_name' || $key == 'last_name' || $key == 'email' || $key == 'fname' || $key == 'lname' || $key == 'clnt_fname' || $key == 'clnt_lname' || $key == 'licence_type' || $key == 'usedby' || $key == 'staff_id' || $key == 'barcode' || $key == 'ip_addr' || $key == 'mac_addr' || $key == 'subnet_mask' || $key == 'osname' || $key == 'version' || $key == 'software_type' || $key == 'software_category' || $key == 'manufacturer_name'
                    || $key == 'vis_hostname' || $key == 'vis_model_id'|| $key == 'vis_model_name'|| $key == 'virtual_memory'|| $key == 'total_memory' || $key == 'service_tag' || $key == 'service_pack' || $key == 'firmware' || $key == 'cpu_mb' || $key == 'ios' || $key == 'flash' || $key == 'nvram'  || $key == 'dram' || $key == 'cpu_type' || $key == 'cpu_revision' || $key == 'config_register'  || $key == 'processor_id') {
							$report_exp[$j][$key] = $val;	
						} elseif($key == 'details'){
							$text = $val;
							$new_val =  $report_obj->strip_html_tags($text);
							$report_exp[$j][$key] = $new_val;
						} elseif( $key!='clnt_fname' && $key!='clnt_lname' ) {
							$report_exp[$j][$key] = $val;
						}			
					} 						
					
						$report_exp1[$j]['Asset_name'] = $report_exp[$j]['name'];
						$report_exp1[$j]['CI_Type'] = $report_exp[$j]['description'];
						$report_exp1[$j]['description'] = $report_exp[$j]['details'];
						if($report_exp[$j]['staff_id']===''){
							$report_exp1[$j]['managed_by'] = '---';
						} else {
							$report_exp1[$j]['managed_by'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
						}
						$report_exp1[$j]['email_id'] = $report_exp[$j]['email'];
						if($report_exp[$j]['usedby']!=''){
							$report_exp1[$j]['used_by']	= $report_exp[$j]['usedby'];
						}else if($report_exp[$j]['clnt_fname']=='' || $report_exp[$j]['clnt_lname']==''){
							$report_exp1[$j]['used_by']	= '---'; //$report_exp[$j]['fname'].' '.$report_exp[$j]['lname'];
						} else {
							$report_exp1[$j]['used_by']	= '---'; //$report_exp[$j]['clnt_fname'].' '.$report_exp[$j]['clnt_lname'];	
						}							
						$report_exp1[$j]['Assigned_on'] = $report_exp[$j]['assigned_on'];
						$report_exp1[$j]['Location'] = $report_exp[$j]['location'];
						$report_exp1[$j]['impact'] = $report_exp[$j]['impact_name'];
						if ($report_exp[$j]['ci_type_id']!=1 && $report_exp[$j]['ci_type_id']!=4 && $report_exp[$j]['ci_type_id']!=5 && $report_exp[$j]['ci_type_id']!=6 && $report_exp[$j]['ci_type_id']!=7)
            {
                $report_exp1[$j]['warranty_year'] = $report_exp[$j]['warranty_year'];
                $report_exp1[$j]['warranty_month'] = $report_exp[$j]['warranty_month'];
            }
            if ($report_exp[$j]['ci_type_id']==2 || $report_exp[$j]['ci_type_id']==8 ||$report_exp[$j]['ci_type_id']==9 ||$report_exp[$j]['ci_type_id']==10 || $report_exp[$j]['ci_type_id']==11 ||$report_exp[$j]['ci_type_id']==12 ||$report_exp[$j]['ci_type_id']==13)
            {                       
                $report_exp1[$j]['acquisition_date'] = $report_exp[$j]['installation_date'];
                $report_exp1[$j]['assets_state'] = $report_exp[$j]['description'];
                $report_exp1[$j]['asset_tag'] = $report_exp[$j]['asset_tag'];
                $report_exp1[$j]['serial_number'] = $report_exp[$j]['licence_key'];

            }   
            if ($report_exp[$j]['ci_type_id']!=1 && $report_exp[$j]['ci_type_id']!=4 && $report_exp[$j]['ci_type_id']!=5 && $report_exp[$j]['ci_type_id']!=6 && $report_exp[$j]['ci_type_id']!=7)
            {
                $report_exp1[$j]['expiry_date'] = $report_exp[$j]['expiry_date'];
            }       
            $report_exp1[$j]['last_audit_date'] = $report_exp[$j]['last_audit_date'];

            if ($report_exp[$j]['ci_type_id']!=1 && $report_exp[$j]['ci_type_id']!=4 && $report_exp[$j]['ci_type_id']!=5 && $report_exp[$j]['ci_type_id']!=6 && $report_exp[$j]['ci_type_id']!=7)
            {
                //$report_exp1[$j]['cost'] = $report_exp[$j]['installation_path'];
                $report_exp1[$j]['cost'] = ($report_exp[$j]['ci_type_id'] == 3)? $report_exp[$j]['asset_tag']:$report_exp[$j]['installation_path'];

                $report_exp1[$j]['installation_date'] = $report_exp[$j]['installation_date'];

            }
            if ($report_exp[$j]['ci_type_id']!=1 && $report_exp[$j]['ci_type_id']!=3 && $report_exp[$j]['ci_type_id']!=4 && $report_exp[$j]['ci_type_id']!=5 && $report_exp[$j]['ci_type_id']!=6 && $report_exp[$j]['ci_type_id']!=7)
            {
                $report_exp1[$j]['vender'] = $report_exp[$j]['vender_name'];
                $report_exp1[$j]['salvage'] = $report_exp[$j]['salvage'];
                $report_exp1[$j]['depreciation_type'] = $report_exp[$j]['depreciation_type'];
                $report_exp1[$j]['useful_life(in_years)'] = $report_exp[$j]['useful_life'];
                $report_exp1[$j]['barcode'] = $report_exp[$j]['barcode'];
                $report_exp1[$j]['ip_address'] = $report_exp[$j]['ip_addr'];
                $report_exp1[$j]['mac_address'] = $report_exp[$j]['mac_addr'];
                $report_exp1[$j]['subnet_mask'] = $report_exp[$j]['subnet_mask'];                   
                $report_exp1[$j]['operating_system'] = $report_exp[$j]['osname'];

            }
            if ($report_exp[$j]['ci_type_id']==2)
            {
                $report_exp1[$j]['product'] = $report_exp[$j]['product_name'];
                /* $report_exp1[$j]['warranty_expiry_date'] = $report_exp[$j]['expiry_date']; */
                $report_exp1[$j]['firmware'] = $report_exp[$j]['firmware'];
                $report_exp1[$j]['cpu_mb'] = $report_exp[$j]['cpu_mb'];
                $report_exp1[$j]['ios'] = $report_exp[$j]['ios'];
                $report_exp1[$j]['flash'] = $report_exp[$j]['flash'];
                $report_exp1[$j]['nvram'] = $report_exp[$j]['nvram'];
                $report_exp1[$j]['dram'] = $report_exp[$j]['dram'];
                $report_exp1[$j]['cpu_type'] = $report_exp[$j]['cpu_type'];
                $report_exp1[$j]['cpu_revision'] = $report_exp[$j]['cpu_revision'];
                $report_exp1[$j]['config_register'] = $report_exp[$j]['config_register'];
                $report_exp1[$j]['processor_id'] = $report_exp[$j]['processor_id'];
            }   
            $report_exp1[$j]['risk'] = $report_exp[$j]['risk'];
            if ($report_exp[$j]['ci_type_id']==3)
            {
                $report_exp1[$j]['licence_key'] = $report_exp[$j]['licence_key'];   
                $report_exp1[$j]['licence_type'] = $report_exp[$j]['licence_type']; 
                $report_exp1[$j]['version'] = $report_exp[$j]['version'];
                $report_exp1[$j]['software_type'] = $report_exp[$j]['software_type'];
                $report_exp1[$j]['software_category'] = $report_exp[$j]['software_category'];
                $report_exp1[$j]['installation_path'] = $report_exp[$j]['installation_path'];       
            }
            $report_exp1[$j]['lifecycle_status'] = $report_exp[$j]['lifecycle_status'];
            $report_exp1[$j]['disposition_status'] = $report_exp[$j]['disposition_status'];         
            $report_exp1[$j]['asset_department'] = $report_exp[$j]['assetdept_name'];               
            $report_exp1[$j]['migrated_from'] = $report_exp[$j]['migrated_from'];
            $report_exp1[$j]['storage_location'] = $report_exp[$j]['storage_location'];
            $report_exp1[$j]['physical_location'] = $report_exp[$j]['physical_location'];
            if ($report_exp[$j]['ci_type_id']!=1 && $report_exp[$j]['ci_type_id']!=2 && $report_exp[$j]['ci_type_id']!=4 && $report_exp[$j]['ci_type_id']!=5 && $report_exp[$j]['ci_type_id']!=6 && $report_exp[$j]['ci_type_id']!=7)
            {
                $report_exp1[$j]['manufacturer'] = $report_exp[$j]['manufacturer_name'];    
            }


            if ($report_exp[$j]['ci_type_id']==8 || $report_exp[$j]['ci_type_id']==9 || $report_exp[$j]['ci_type_id']==10 || $report_exp[$j]['ci_type_id']==11 ||$report_exp[$j]['ci_type_id']==12 ||$report_exp[$j]['ci_type_id']==13)
            {
                $report_exp1[$j]['host_name'] = $report_exp[$j]['vis_hostname'];
                $report_exp1[$j]['model'] = $report_exp[$j]['vis_model_name'];
                $report_exp1[$j]['virtual_memory'] = $report_exp[$j]['virtual_memory'];
                $report_exp1[$j]['total_memory'] = $report_exp[$j]['total_memory'];
                $report_exp1[$j]['service_tag'] = $report_exp[$j]['service_tag'];
                $report_exp1[$j]['service_pack'] = $report_exp[$j]['service_pack'];
            }
					$j++;
				}
				
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = ucfirst(strtolower($report_title));
				$filename=$this->export_subreport($operation,$report_exp1);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} 
		} 

		$database->database_disconnect();
		return true;
	}

	function assets_asset_product_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTASSTEPRODUCT'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type=75; 
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$staff      = $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA);
		$filter     = VIS_TABLE_PREFIX.'domain.is_enabled=1 ';
		$domain     = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='changes_resolvedby_staff_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if(VIS_LOCATION_AREA==2){						
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			$object=new class_setting($database);
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');		 
			$sub_object=new class_subsetting($database);
			$citype_details=$object->get_configuration_item_category('','is_enabled=1'); 
			list($ci_product_info, $ci_product_details)=$object->get_ci_product('','','','',$staff_id,VIS_LOCATION_AREA);  
			list($vendor_info, $vendor_details)=$object->get_vendor('','','','',$staff_id,VIS_LOCATION_AREA); 
		}
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if ($data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} 
				if($data['product_id'] == -1  && $data['vendor_id'] == -1){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTCIPRODUCT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['product_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTCIPRODUCT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				 
				if ($data['vendor_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTVENDOR']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['product_id'] != -1 && $data['vendor_id']!=-1  ) {
					$filter = ' cmast.product_id='.$data['product_id']. ' and cmast.vendor_id='.$data['vendor_id'].' and cmast.department_access='.$data['domain_id'].' and cmast.ci_type_id = 2'; 
				}
				$filter1 =' 2 and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';		
				$filter=$filter.'#'.$filter1;
			}
			$temp_filtr = explode('#',$filter);				 
			$filter = $temp_filtr[0];
			$filter1= $temp_filtr[1];
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);			

			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'cmdb.php');
            $cmdb_object = new class_cmdb($database);

			list($custom_fields_details, $report) = $cmdb_object->get_cmdb_assets_data($filter,'', $staff_id, VIS_LOCATION_AREA, $filter1);
			$total = ($report!=-1)?count($report):0;
			list($custom_fields_details, $report) = $cmdb_object->get_cmdb_assets_data($filter,$limit, $staff_id, VIS_LOCATION_AREA, $filter1);

			if($report!=-1){
				$counts['page_count']=(count($report)==0)?0:ceil( count($report)/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($report);
				$report_count=($report!=-1)?count($report):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			if($report!=-1){					
				for($i=0; $i<count($report); $i++){						
					$is_expired =0;
					if($report[$i]['ci_property_type']==1 || $report[$i]['ci_property_type']==2 || $report[$i]['ci_property_type']==8){
						$current_date =get_time_by_tz( strtotime(date('Y-m-d h:i:s')));
						$expiry_date = get_time_by_tz($report[$i]['expiry_date']);
						if($expiry_date <= $current_date){
							$report[$i]['status']=format_datetime_rpt($expiry_date,$staff_id); //date(VIS_EDITDATETIMEPICKER_FORMAT,$expiry_date);
						} else {
							$report[$i]['status']=format_datetime_rpt($expiry_date,$staff_id); //date(VIS_EDITDATETIMEPICKER_FORMAT,$expiry_date); 
						}
					} else {
						$report[$i]['status']='--';
					}						
				}
			}
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {					
				include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'cmdb.php');
				$cmdb_module = new cmdb();
		   	    list($custom_fields_details,$report_exp1) = $cmdb_module->get_assets_data($report,$staff_id,'',$custom_fields_details);		

				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);			
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);						
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function hardware_assets_by_state_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTHARDWREASSETBYSTATE'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type=76; 
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$staff      = $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA);
		$filter     = VIS_TABLE_PREFIX.'domain.is_enabled=1 ';
		$domain     = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='changes_resolvedby_staff_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report'; 
		if(VIS_LOCATION_AREA==2){						
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			$object=new class_setting($database);
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');		 
			$sub_object=new class_subsetting($database);
			$citype_details=$object->get_configuration_item_category('','is_enabled=1');
			list($asset_state_info, $asset_state_details)=$object->get_asset_state(''.VIS_TABLE_PREFIX.'itil_asset_state.is_enabled=1','','','',$staff_id, VIS_LOCATION_AREA);  
		} 
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if ($data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} 
				if ($data['asset_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTASSETSTATE']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} 
				if ($data['asset_id'] != -1) { 
					$filter = 'cmast.assets_state='.$data['asset_id'].' and cmast.department_access='.$data['domain_id'].' and cmast.ci_type_id=2 ';  
				}
				$filter1 =' 2 and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';		
				$filter=$filter.'#'.$filter1;
			}
			$temp_filtr = explode('#',$filter);				 
			$filter = $temp_filtr[0];
			$filter1= $temp_filtr[1];
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);

			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'cmdb.php');
            $cmdb_object = new class_cmdb($database);

			list($custom_fields_details, $report) = $cmdb_object->get_cmdb_assets_data($filter,'', $staff_id, VIS_LOCATION_AREA, $filter1);
			$total = ($report!=-1)?count($report):0;
			list($custom_fields_details, $report) = $cmdb_object->get_cmdb_assets_data($filter,$limit, $staff_id, VIS_LOCATION_AREA, $filter1);

			if($report!=-1){
				$counts['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=$total;
				$report_count=($report!=-1)?count($report):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			if($report!=-1){					
				for($i=0; $i<count($report); $i++){ 						
					$is_expired =0;
					if($report[$i]['ci_type_id']==2){
						$current_date = get_time_by_tz(strtotime(date('Y-m-d h:i:s')));					 
						$expiry_date = get_time_by_tz($report[$i]['expiry_date']);
						if($expiry_date <= $current_date){
							$report[$i]['status']=format_datetime_rpt($expiry_date,$staff_id); //date(VIS_EDITDATETIMEPICKER_FORMAT,$expiry_date);
						} else {
							$report[$i]['status']=format_datetime_rpt($expiry_date,$staff_id);
						}
					} else {
						$report[$i]['status']='--';
					} 
				}
			}			
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) { 
				include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'cmdb.php');
				$cmdb_module = new cmdb();
		   	    list($custom_fields_details,$report_exp1) = $cmdb_module->get_assets_data($report,$staff_id,'',$custom_fields_details);		
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);				
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);					
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function assets_depreciation_report($operation)
	{   
		global $vis_language;
		$report_title = $vis_language['TXTASSETDEPRECIATION'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type = 77;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$staff      = $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA);
		$filter     = VIS_TABLE_PREFIX.'domain.is_enabled=1 ';
		$domain     = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='changes_resolvedby_staff_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if(VIS_LOCATION_AREA==2){						
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			$object=new class_setting($database);
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');		 
			$sub_object=new class_subsetting($database);
			$citype_details=$object->get_configuration_item_category('','is_enabled=1'); 
			$depreciation_details=$object->get_finance_management_list($filter4='',$data='',$staff_id, VIS_LOCATION_AREA,'');
		} 
		
			$setting_object=new class_setting($database);
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if ($data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} 
				if ($data['depr_type_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTITILDEPRECIATIONTYPE']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['vis_ci_type'] == 0 || $data['vis_ci_type'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . $vis_language['TXTCITYPE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} 
				if ($data['depr_type_id'] != -1 && $data['depr_type_id'] != 0) {
					$filter = ' cmast.depreciation_type='.$data['depr_type_id'].' and cmast.department_access='.$data['domain_id'].' and cmast.ci_type_id ='.$data['vis_ci_type'].''; 
				}
				if ($data['depr_type_id'] == 0) {
					$filter = ' cmast.department_access='.$data['domain_id'].' and cmast.depreciation_type!=0 and cmast.ci_type_id ='.$data['vis_ci_type'].'';
				}
				$filter1 = $data['vis_ci_type'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';		
				$filter=$filter.'#'.$filter1;
			}
			$temp_filtr = explode('#',$filter);				 
			$filter = $temp_filtr[0];
			$filter1= $temp_filtr[1];
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'cmdb.php');
            $cmdb_object = new class_cmdb($database);
			
			list($custom_fields_details, $report) = $cmdb_object->get_cmdb_assets_data($filter,'', $staff_id, VIS_LOCATION_AREA, $filter1);
			$total = ($report!=-1)?count($report):0;
			list($custom_fields_details, $report) = $cmdb_object->get_cmdb_assets_data($filter,$limit, $staff_id, VIS_LOCATION_AREA, $filter1);

			if($report!=-1){
				$counts['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=$total;
				$report_count=($report!=-1)?count($report):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			if($report!=-1){ 
				for($i=0; $i<count($report); $i++){ 
					$is_expired =0;
					if($report[$i]['ci_type_id']==2 || $report[$i]['ci_type_id']==8 || $report[$i]['ci_type_id']==9 || $report[$i]['ci_type_id']==10 || $report[$i]['ci_type_id']==11 || $report[$i]['ci_type_id']==12 || $report[$i]['ci_type_id']==13)
					{
						$current_date = get_time_by_tz(strtotime(date('Y-m-d h:i:s'))); 
						$expiry_date = get_time_by_tz($report[$i]['expiry_date']);
						if($expiry_date <= $current_date){ 
							$report[$i]['status']=format_datetime_rpt($expiry_date,$staff_id);
						} else {
							$report[$i]['status']=format_datetime_rpt($expiry_date,$staff_id);
						}
					} else {
						$report[$i]['status']='--';
					} 
				}  
			}	 
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) { 
				include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'cmdb.php');
				$cmdb_module = new cmdb();
		   	    list($custom_fields_details,$report_exp1) = $cmdb_module->get_assets_data($report,$staff_id,'',$custom_fields_details);		
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);	
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			}  else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}
	function asset_department_report($operation)
	{   
		global $vis_language;
		$report_title = $vis_language['TXTASSETBYASSETDEPT'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type=131;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$staff      = $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='asset_department_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report'; 
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			$object=new class_setting($database);
			//include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			$setting_object=new class_setting($database);
		if(VIS_LOCATION_AREA==2){						
			
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');		 
			$sub_object=new class_subsetting($database);
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
			$object_ticket=new class_ticket($database);
			$citype_details=$object->get_configuration_item_category('','is_enabled=1'); 
			$depreciation_details=$object->get_finance_management_list($filter4='',$data='',$staff_id, VIS_LOCATION_AREA,'');
			list($assetdept_info, $assetdept_details)=$object->get_assetdept('is_enabled=1 ', '', '', 'display_order ASC', $staff_id, VIS_LOCATION_AREA);
			$filter     = VIS_TABLE_PREFIX.'domain.is_enabled=1 ';
			$domain     = $object_ticket->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
		} 
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if ($data['domain_id'] == 0 && $data['vis_ci_type'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['vis_ci_type'] == '' && $data['domain_id'] != 0) { 
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . $vis_language['TXTCITYPE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['vis_ci_type'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . $vis_language['TXTCITYPE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['assetdept_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' .$vis_language['MSQREQ'].'-'.$vis_language['TXTASSETDEPARTMENT'].'");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['assetdept_id'] != -1 && $data['assetdept_id'] != 0) {
					$filter = ' cmast.assetdept_id='.$data['assetdept_id'].' and cmast.ci_type_id='.$data['vis_ci_type'].' and cmast.department_access ='.$data['domain_id']; 
				}
				if ($data['assetdept_id'] == 0) {
					$filter = ' cmast.assetdept_id!=0 and cmast.ci_type_id='.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'];
				}
				$filter1 = $data['vis_ci_type'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';		
				$filter=$filter.'#'.$filter1;
			}
			$temp_filtr = explode('#',$filter);				 
			$filter = $temp_filtr[0];
			$filter1= $temp_filtr[1];
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'cmdb.php');
            $cmdb_object = new class_cmdb($database);	

			list($custom_fields_details, $report) = $cmdb_object->get_cmdb_assets_data($filter,'', $staff_id, VIS_LOCATION_AREA, $filter1);
			$total = ($report!=-1)?count($report):0;
			list($custom_fields_details, $report) = $cmdb_object->get_cmdb_assets_data($filter,$limit, $staff_id, VIS_LOCATION_AREA, $filter1);

			if($report!=-1){
				$counts['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=$total;
				$report_count=($report!=-1)?count($report):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			if($report!=-1){ 
				for($i=0; $i<count($report); $i++){ 
					$is_expired =0;
					if($report[$i]['ci_type_id']==2){
						$current_date = get_time_by_tz(strtotime(date('Y-m-d h:i:s'))); 
						$expiry_date = get_time_by_tz($report[$i]['expiry_date']);
						if($expiry_date <= $current_date){ 
							$report[$i]['status']=format_datetime_rpt($expiry_date,$staff_id);
						} else {
							$report[$i]['status']=format_datetime_rpt($expiry_date,$staff_id);
						}
					} else {
						$report[$i]['status']='--';
					} 
				}  
			}	 
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) 
			{ 
				include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'cmdb.php');
				$cmdb_module = new cmdb();
		   	    list($custom_fields_details,$report_exp1) = $cmdb_module->get_assets_data($report,$staff_id,'',$custom_fields_details);	
				
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);	
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			}  else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}
    ###
	function assets_depreciation_notification_report($operation)
	{  
		global $vis_language;
		$report_title = $vis_language['TXTASSETDEPRECIATIONNOTIFY'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type=78;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$staff      = $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA);
		$filter     = VIS_TABLE_PREFIX.'domain.is_enabled=1 ';
		$domain     = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='changes_resolvedby_staff_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if(VIS_LOCATION_AREA==2){						
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			$object=new class_setting($database);
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');		 
			$sub_object=new class_subsetting($database);				
			$citype_details=$object->get_configuration_item_category('','is_enabled=1'); 
			$depreciation_details=$object->get_finance_management_list($filter4='',$data='',$staff_id, VIS_LOCATION_AREA,'');  
		} 
		$setting_object=new class_setting($database);
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if ($data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} 
				if ($data['depr_type_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTITILDEPRECIATIONTYPE']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['vis_ci_type'] == 0 || $data['vis_ci_type'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . $vis_language['TXTCITYPE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} 
				if ($data['depr_type_id'] != -1 && $data['depr_type_id'] != 0) {
					$filter = ' cmast.depreciation_type='.$data['depr_type_id'].' and cmast.department_access='.$data['domain_id'].' and cmast.ci_type_id ='.$data['vis_ci_type'].''; 
				}
				if ($data['depr_type_id'] == 0) {
					$filter = ' cmast.department_access='.$data['domain_id'].' and cmast.depreciation_type!=0 and cmast.ci_type_id ='.$data['vis_ci_type'].'';  
				}
				$filter1 = $data['vis_ci_type'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';		
				$filter=$filter.'#'.$filter1;
			}
			$temp_filtr = explode('#',$filter);				 
			$filter = $temp_filtr[0];
			$filter1= $temp_filtr[1];
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'cmdb.php');
            $cmdb_object = new class_cmdb($database);
			
			list($custom_fields_details, $report) = $cmdb_object->get_cmdb_assets_data($filter,'', $staff_id, VIS_LOCATION_AREA, $filter1);
			$total = ($report!=-1)?count($report):0;
			list($custom_fields_details, $report) = $cmdb_object->get_cmdb_assets_data($filter,$limit, $staff_id, VIS_LOCATION_AREA, $filter1);

			if($report!=-1){
				$counts['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=$total;
				$report_count=($report!=-1)?count($report):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			if($report!=-1){					
				for($i=0; $i<count($report); $i++){						
					$is_expired =0;
					if($report[$i]['ci_property_type']==1 || $report[$i]['ci_property_type']==2 || $report[$i]['ci_property_type']==8){
						$current_date = get_time_by_tz(strtotime(date('Y-m-d h:i:s')));
						$expiry_date = get_time_by_tz($report[$i]['expiry_date']);
						if($expiry_date <= $current_date){
							$report[$i]['status']= format_datetime_rpt($expiry_date,$staff_id);
						} else {
							$report[$i]['status']=format_datetime_rpt($expiry_date,$staff_id);
						}
					} else {
						$report[$i]['status']='--';
					}
					if($report[$i]['expiry_date']!=''){
						$expdate = date('Y-m-d', $report[$i]['expiry_date']);
						$currentdate = date('Y-m-d H:i:s');							
						$diff = abs(strtotime($report[$i]['status']) - strtotime($currentdate));
						$years = floor($diff / (365*60*60*24));
						$months = floor(($diff - $years * 365*60*60*24) / (30*60*60*24));
						$days = floor(($diff - $years * 365*60*60*24 - $months*30*60*60*24)/ (60*60*24));
						if($months==12){
							$months=$months-12;
							$years=$years+1;
						}
						$report[$i]['rem_warranty'] = $years.' '.'years'.' '.$months.' '.'months'.' '.$days.' '.'days';
					} else {
						$report[$i]['rem_warranty'] = '--';
					}						
				}
			}
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {					
				include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'cmdb.php');
				$cmdb_module = new cmdb();
		   	    list($custom_fields_details,$report_exp1) = $cmdb_module->get_assets_data($report,$staff_id,$report_title,$custom_fields_details);		
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);		
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);						
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;			
	}

	function clients_by_organization_report($operation)
	{	
		global $vis_language;
		$report_title = $vis_language['TXTCLIENTBYORGANIZATION'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1){
			$database = new class_database('mysqli', 1);
			}else{
			$database = new class_database();
		}
		$report_type= 81;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$object        = new class_report($database);
		$tkt_object    = new class_ticket($database);
		$client_object = new class_client($database);
		include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'client.php');
		$object_client = new client();
		if(isset($operation['vis_export']) && $operation['vis_export'] == 1){ 
			$staff_id = $operation['staff_id'];
		} else {  
			$staff_id =  VIS_STAFF_ID;
			$domain_list   = $object_client->get_domain_access_list();
			$clientGroup   = $client_object->get_client_group1(' (domain_id in (' . $domain_list . ') or domain_id=0 ) and is_enable=1', $staff_id, VIS_LOCATION_AREA); //get client group list
		}
		$filter        = VIS_TABLE_PREFIX.'domain.is_enabled=1';
		$domain        = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
		$domain_ids = '';
		for($m=0;$m<count($domain);$m++){
			$domain_ids .= $domain[$m]['domain_id'].',';
		}
		$domain_ids = substr($domain_ids, 0, -1);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='clients_by_organization_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		$export        = 1;
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else { 
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != ''){
					$data = $operation;
				}else					
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				$data['group_id'] = (isset($data['group_id']) && $data['group_id']!='')?$data['group_id']:0;
				if ($data['domain_id'] == "" && $data['group_id'] == "") {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['domain_id']!= "" && $data['group_id'] == "") {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTORGANIZATION']). '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['domain_id'] == "" && $data['group_id'] != "") {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['domain_id'] == 0) {
					//$filter = ' ('.VIS_TABLE_PREFIX.'client.domain_id IN ('.$domain_ids.') or '.VIS_TABLE_PREFIX.'client.optionB_domain_id IN ('.$domain_ids.'))';
					$filter ='';
					
				} else{
					//$filter = ' ('.VIS_TABLE_PREFIX.'client.domain_id = '.$data['domain_id'].' or '.VIS_TABLE_PREFIX.'client.optionB_domain_id = '.$data['domain_id'].')';
					if(VIS_SATELLITE_HELPDESK == 2 || VIS_SATELLITE_HELPDESK == 3)
						{
							$filter = VIS_TABLE_PREFIX.'client.optionB_domain_id = '.$data['domain_id'].'';
						}
					else
						{
 							$filter = VIS_TABLE_PREFIX.'client.domain_id = '.$data['domain_id'].'';
						}
				}
				if ($data['group_id'] == '0' || $data['group_id'] == ''){
					//$filter    = "";
				} else {
					$filter   .= ($filter!='')?' and '.VIS_TABLE_PREFIX.'client.group_id = '.$data['group_id'] : VIS_TABLE_PREFIX.'client.group_id = '.$data['group_id'];
				}
			}
			$post_details = $object->get_client_organization_report1($filter, '', $staff_id, VIS_LOCATION_AREA);
			$total = ($post_details!=-1)?count($post_details):0;
			$report = $object->get_client_organization_report1($filter, $limit, $staff_id, VIS_LOCATION_AREA);
			if($report!=-1){
				$counts['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=$total;
				$report_count=($report!=-1) ? count($report):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
			$object_setting = new class_setting($database);
			$custom_filter = ' location=0 and is_enabled=1';
			$custom_grouplist = $object_setting->get_custom_group_list($custom_filter, $staff_id, VIS_LOCATION_AREA);
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				foreach ($report as $i) {
					foreach ($i as $key => $val) {
						if ($key == 'first_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'last_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'email') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'contact_number'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'group_name'){
							$report_exp[$j][$key] = $val;
						}
					}
					$report_exp1[$j]['client'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email'] = $report_exp[$j]['email'];
					if($report_exp[$j]['contact_number']!=''){
						$report_exp1[$j]['contact_number'] = $report_exp[$j]['contact_number'];
					} else {
						$report_exp1[$j]['contact_number'] = '-';
					}
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					if($custom_grouplist!=-1){
						$customfield_data = array();
						for($m=0;$m<count($custom_grouplist);$m++){
							$filter = VIS_TABLE_PREFIX.'customfield.customgroup_id='.$custom_grouplist[$m]['customgroup_id'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1 ';
							$customfield = $object_setting->get_customfield(2, $filter, '', 0, 0, $staff_id, VIS_LOCATION_AREA);
							if($customfield[1]!=-1){
								$fieldcontent = $prevFieldGroup = '';
								$prevContent = '---';
								for($s=0;$s<count($customfield[1]);$s++){
									$customfield_data = $tkt_object->get_customfield_data($customfield[1][$s]['customfield_id'], $i['client_id'], '');
									if($customfield_data!=-1){
										if(isset($customfield_data['content']) && $customfield_data['content']!=''){
											if($prevFieldGroup == $customfield[1][$s]['field_group']){
												if($customfield_data['parent_id'] != $i['client_id']){
													$fieldcontent = $customfield_data['content'].'|';
												} else {
													$fieldcontent .= $customfield_data['content'].'|';
												}
												$previousContent = '';
											} elseif($prevContent!='' && $prevFieldGroup == $customfield[1][$s]['field_group']){
												$fieldcontent .= $customfield_data['content'].'|';
											} else {
												$fieldcontent = $customfield_data['content'].'|';
											}
											$report_exp1[$j][$customfield[1][$s]['field_name']] = ($fieldcontent!='') ? substr($fieldcontent,0,-1) : '';
											$previousContent = $customfield_data['content'];
										}
										$customfields_title[] = $customfield[1][$s]['field_name'];
									} else {
										if($fieldcontent!='' && $prevFieldGroup == $customfield[1][$s]['field_group']){
											$report_exp1[$j][$customfield[1][$s]['field_name']] = ($fieldcontent!='') ? substr($fieldcontent,0,-1) : '';
											$prevContent = '';
										} elseif($fieldcontent=='' && $prevFieldGroup != $customfield[1][$s]['field_group']){
											$report_exp1[$j][$customfield[1][$s]['field_name']] = ($customfield_data['content']!='') ? $previousContent : $prevContent;
											$previousContent = '';
										} else {
											$fieldcontent = '';
											$prevContent = '';
											$previousContent = '';
											$report_exp1[$j][$customfield[1][$s]['field_name']] = '---';
										}
									}
									$prevContent = $customfield_data['content'];
									$prevFieldGroup = $customfield[1][$s]['field_group'];
								}
							}
						}
					}
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
						echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE.'report_page.php');
			} 
		} else 
			include(VIS_PATH_TEMPLATE.'report_form.php');

		$database->database_disconnect();
		return true;
	}
	
	function invoiceby_domain_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTDOMAININVOICERPT'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();

		$export = 1;
		$report_type= 108;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$object        = new class_report($database);
		$tkt_object    = new class_ticket($database);
		$client_object = new class_client($database);
		include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'client.php');
		$object_client = new client();
		if(isset($operation['vis_export']) && $operation['vis_export'] == 1){
			$staff_id = $operation['staff_id'];
		} else {
			$staff_id = VIS_STAFF_ID;
			$domain_list   = $object_client->get_domain_access_list();
			$clientGroup   = $client_object->get_client_group1(' (domain_id in (' . $domain_list . ') or domain_id=0 ) and is_enable=1', $staff_id, VIS_LOCATION_AREA); //get client group list
		}
		$filter        = VIS_TABLE_PREFIX.'domain.is_enabled=1';
		$domain        = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA); // get domain list
		$currency = $domain[0]['currency'];
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='invoiceby_organization_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';			
		$export        = 1;
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$msg.'");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['domain_id'] == 0 && $data['status_id'] == 'select') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']).'");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message",  "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']).'");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['status_id'] == "select") {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTBILLING']).' ' .strtolower($vis_language['TXTSTATUS']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$domainId = ($data['domain_id']==0) ? '' : ' AND '.VIS_TABLE_PREFIX.'client.domain_id = '.$data['domain_id'];
				$status_id = ($data['status_id']!='select' && $data['status_id']==3) ? '' : ' and '.VIS_TABLE_PREFIX.'invoice.invoice_status=' . $data['status_id'];
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'invoice.entry_date between "'.$from.'" AND "'.$to.'"'.$domainId.$status_id;
			}
			list($report1,$domain) = $object->get_invoiceby_domain_report($filter, '', $staff_id, VIS_LOCATION_AREA);
			$total2=0;$paid=0;$unpaid=0;$cancelled=0;
			$report='';
			if($report1!=-1){
				$total = ($report1!=-1)?count($report1):0;
				list($report,$domain) = $object->get_invoiceby_domain_report($filter, $limit, $staff_id, VIS_LOCATION_AREA);
				$counts['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($report);
				$report_count=($report!=-1)?count($report):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
				foreach ($report1 as $ticket_id => $details) {
					$total2 += $details['amount'];
					if($details['invoice_status'] == 0)$unpaid +=$details['amount'];
					else if($details['invoice_status'] == 1)$paid +=$details['amount'];
					else if($details['invoice_status'] == 2)$cancelled +=$details['amount'];
				}
			}
			
			$array_summary=array();
			$array_summary['TXTTOTAL']=$total2.' '.$currency;
			$array_summary['TXTTOTALPAID']=$paid.' '.$currency;
			$array_summary['TXTTOTALUNPAID']=$unpaid.' '.$currency;
			$array_summary['TXTTOTALCANCELLED']=$cancelled.' '.$currency;


			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				foreach ($report1 as $ticket_id => $i) {
					foreach ($i as $key => $val) {
						if ($key == 'invoice_hash') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'entry_date') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'first_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'last_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'email') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'domain_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'due_date') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'paid_date') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'ticket_hash') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'amount') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'invoice_status') {
							$report_exp[$j][$key] = $val;
							if($val==0){
								$report_exp[$j][$key] = $vis_language['TXTUNPAID'];
							} elseif($val==1){
								$report_exp[$j][$key] = $vis_language['TXTPAID'];
							} elseif($val==2){
								$report_exp[$j][$key] = $vis_language['TXTCANCELED']; 
							} elseif($val==3){
								$report_exp[$j][$key] = $vis_language['TXTINPROCESS'];
							}
						}
					}
					if($i['ticket_id']==0 && $i['product_id']!=0){
						$reference = $i['product_name'];
					} elseif($i['ticket_id']!=0 && $i['product_id']==0){
						$reference = ($i['ticket_hash']=='')?'-':$i['ticket_hash'];
					} else {
						$reference = $vis_language['TXTCLIENT'];
					}
					$report_exp1[$j]['invoice_hash']=$report_exp[$j]['invoice_hash'];
					$report_exp1[$j]['reference']=$reference;
					$report_exp1[$j]['client_name']=$report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email']=$report_exp[$j]['email'];
					$report_exp1[$j]['domain']=$report_exp[$j]['domain_name'];					
					$report_exp1[$j]['invoice_date']=$report_exp[$j]['entry_date'];
					$report_exp1[$j]['due_date']=$report_exp[$j]['due_date'];
					$report_exp1[$j]['paid_date']=$report_exp[$j]['paid_date'];
					$report_exp1[$j]['amount'.'('.$currency.')']=$report_exp[$j]['amount'];
					$report_exp1[$j]['billing_status']=$report_exp[$j]['invoice_status'];
					$j++;
				}
				$report_exp1[$j]['summary'] = $vis_language['TXTSUMMARY'];
				foreach($array_summary as $key=>$val){
				 $report_exp1[$j][$vis_language[$key]]=$vis_language[$key] . ' : ' . $val; 
				}
				/*$report_exp [$j]['total']=$vis_language['TXTTOTAL'].' :'.$total2 .' '. $currency;
				$report_exp [$j]['paid']=$vis_language['TXTTOTALPAID'].' :'.$paid .' '. $currency;
				$report_exp [$j]['unpaid']=$vis_language['TXTTOTALUNPAID'].' :'.$unpaid .' '. $currency;
				$report_exp [$j]['cancelled']=$vis_language['TXTTOTALCANCELLED'].' :'.$cancelled .' '. $currency;
				$report_exp1[$j]['total']= $report_exp[$j]['total'];
				$report_exp1[$j]['paid']= $report_exp[$j]['paid'];
				$report_exp1[$j]['unpaid']=$report_exp[$j]['unpaid'];
				$report_exp1[$j]['cancelled']=$report_exp[$j]['cancelled'];*/
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			}else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function invoiceby_organization_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTINVOICEBYORGANIZATION'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();

		$export = 1;
		$report_type= 82;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$object        = new class_report($database);
		$tkt_object    = new class_ticket($database);
		$client_object = new class_client($database);
		include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'client.php');
		$object_client = new client();
		if(isset($operation['vis_export']) && $operation['vis_export'] == 1){
			$staff_id = $operation['staff_id'];
		} else {
			$staff_id = VIS_STAFF_ID;
			$domain_list   = $object_client->get_domain_access_list();
			$clientGroup   = $client_object->get_client_group1(' (domain_id in (' . $domain_list . ') or domain_id=0 ) and is_enable=1', $staff_id, VIS_LOCATION_AREA); //get client group list
		}
		$filter        = VIS_TABLE_PREFIX.'domain.is_enabled=1';
		$domain        = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA); // get domain list
		$currency = $domain[0]['currency'];
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='invoiceby_organization_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';			
		$export        = 1;
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['domain_id'] == "" && $data['group_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['domain_id'] == "") {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message",  "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']).'");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ((!isset($domain) && $data['group_id'] == 0) || (isset($domain) && $data['group_id'] == "")) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' .$vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTORGANIZATION']). '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$domainId = ' AND ' . VIS_TABLE_PREFIX.'client.domain_id = ' . $data['domain_id'];
				if ($data['group_id'] == '0' || $data['group_id'] == ''){
					$groupId    = "";
				} else {
					$groupId   = VIS_TABLE_PREFIX.'client.group_id = ' . $data['group_id'].' AND ';
				}
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = $groupId . VIS_TABLE_PREFIX.'invoice.entry_date between "' . $from . '" AND "' . $to . '"' . $domainId;
			}
			list($report1,$domain) = $object->get_invoiceby_organization_report($filter,'', $staff_id, VIS_LOCATION_AREA); //get invoice by organization report				 
			$total2=0;$paid=0;$unpaid=0;$cancelled=0;
			$report='';
			if($report1!=-1){
				$total = ($report1!=-1)?count($report1):0;
				list($report,$domain) = $object->get_invoiceby_organization_report($filter,$limit, $staff_id, VIS_LOCATION_AREA);
				$counts['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($report);
				$report_count=($report!=-1)?count($report):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
				
				foreach ($report1 as $ticket_id => $details) {
					$total2 += $details['amount'];
					if($details['invoice_status'] == 0)$unpaid +=$details['amount'];
					else if($details['invoice_status'] == 1)$paid +=$details['amount'];
					else if($details['invoice_status'] == 2)$cancelled +=$details['amount'];
				}
			}
			$array_summary=array();
			$array_summary['TXTTOTAL']=$total2.' '.$currency;
			$array_summary['TXTTOTALPAID']=$paid.' '.$currency;
			$array_summary['TXTTOTALUNPAID']=$unpaid.' '.$currency;
			$array_summary['TXTTOTALCANCELLED']=$cancelled.' '.$currency;

			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				foreach ($report as $ticket_id => $i) {
					foreach ($i as $key => $val) {
						if ($key == 'invoice_hash') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'entry_date') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'first_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'last_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'email') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'group_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'due_date') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'paid_date') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'ticket_hash') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'ticket_id') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'amount') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'balance_type') {
							$report_exp[$j][$key] = $val;
						}elseif ($key == 'invoice_status') {
							$report_exp[$j][$key] = $val;
							if($val==0){
								$report_exp[$j][$key] = $vis_language['TXTUNPAID'];
							} elseif($val==1){
								$report_exp[$j][$key] = $vis_language['TXTPAID'];
							} elseif($val==2){
								$report_exp[$j][$key] = $vis_language['TXTCANCELED']; 
							} elseif($val==3){
								$report_exp[$j][$key] = $vis_language['TXTINPROCESS'];
							}
						}
					}
					$report_exp1[$j]['invoice_hash']=$report_exp[$j]['invoice_hash'];
					
					if($report_exp[$j]['ticket_id']!=0){
					$report_exp1[$j]['reference']=($report_exp[$j]['ticket_hash']=='')?'-':$report_exp[$j]['ticket_hash'];
					}elseif($report_exp[$j]['balance_type']!=''){
						if($report_exp[$j]['balance_type']==1) $report_exp1[$j]['reference'] = 'Time credit';
						elseif($report_exp[$j]['balance_type']==0) $report_exp1[$j]['reference'] = 'Incident credit';
					}else{
					$report_exp1[$j]['reference']=$vis_language['TXTCLIENT'];
					}
					///$report_exp1[$j]['reference']=$report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['client_name']=$report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email']=$report_exp[$j]['email'];
					$report_exp1[$j]['organization']=$report_exp[$j]['group_name'];					
					$report_exp1[$j]['invoice_date']=$report_exp[$j]['entry_date'];
					$report_exp1[$j]['due_date']=$report_exp[$j]['due_date'];
					$report_exp1[$j]['paid_date']=$report_exp[$j]['paid_date'];
					$report_exp1[$j]['amount'.'('.$currency.')']=$report_exp[$j]['amount'];
					$report_exp1[$j]['billing_status']=$report_exp[$j]['invoice_status'];
					$j++;
				}
				$report_exp1[$j]['summary'] = $vis_language['TXTSUMMARY'];
				foreach($array_summary as $key=>$val){
				 $report_exp1[$j][$vis_language[$key]]=$vis_language[$key] . ' : ' . $val; 
				}
				/*$report_exp [$j]['total']=$vis_language['TXTTOTAL'].' :'.$total2 .' '. $currency;
				$report_exp [$j]['paid']=$vis_language['TXTTOTALPAID'].' :'.$paid .' '. $currency;
				$report_exp [$j]['unpaid']=$vis_language['TXTTOTALUNPAID'].' :'.$unpaid .' '. $currency;
				$report_exp [$j]['cancelled']=$vis_language['TXTTOTALCANCELLED'].' :'.$cancelled .' '. $currency;
				$report_exp1[$j]['total']= $report_exp[$j]['total'];
				$report_exp1[$j]['paid']= $report_exp[$j]['paid'];
				$report_exp1[$j]['unpaid']=$report_exp[$j]['unpaid'];
				$report_exp1[$j]['cancelled']=$report_exp[$j]['cancelled'];*/
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);	
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function get_domainwise_organizations($operation){
		global $vis_language;
		$domain_id = $_POST['domain_id'];
		$multipleorgflag = '';
		$multipleorgflag = isset($_POST['multipleorgflag']);
		$database = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
		$client_object = new class_client($database);
		include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'client.php');
		$object_client = new client();
		$domain_list   = $object_client->get_domain_access_list();
		$clientGroup   = $client_object->get_client_group1(' (domain_id in (' . $domain_list . ') or domain_id=0 ) and is_enable=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$object = new class_report($database);
		if($domain_id=='' || $domain_id!='0'){ $filter = ' where ((domain_id = '.$domain_id.') or domain_id=0) and is_enable=1';}else{ $filter=" where is_enable=1"; }
		$result = $object->get_orgs_by_domain($filter);
		if(count($clientGroup) > 10) $sk = 'data-live-search="true"'; else $sk = '';
		$list_data = '';
		echo "<script>selectpickerinit('');</script>";
		if( $multipleorgflag == 1 ) {
			$list_data .= '<select id="cltbyorg" name="group_id[]" multiple data-actions-box="true"  class="form-control selectpicker" '.$sk.'>';
			//$list_data .= '<option value="">'.$vis_language['TXTSELORG'].'</option>';
			if($result!= -1){
				for($i=0;$i<count($result);$i++){
					$list_data .= "<option value='".$result[$i]['group_id']."'>".$result[$i]['group_name']."</option>";
				}
			}
		} else {
			$list_data .= '<select id="cltbyorg" name="group_id" class="form-control selectpicker" '.$sk.'>';
			//$list_data .= '<option value="">'.$vis_language['TXTSELORG'].'</option>';
			if($result!= -1){
				$list_data .= '<option value="0">All</option>';
				for($i=0;$i<count($result);$i++){
					$list_data .= "<option value='".$result[$i]['group_id']."'>".$result[$i]['group_name']."</option>";
				}
			}
		}
		$list_data .= '</select></div>';
		echo $list_data;
		return true;
	}


	function get_domainwise_manufacturer($operation){
		global $vis_language;
		$domain_id = $_POST['domain_id'];
		$database = new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$setting_object=new class_setting($database);
		
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$object = new class_report($database);

		if($domain_id!=''){ $filter = ' department_access = '.$domain_id.' OR department_access =0';}else{ $filter=""; }
		list($manufacturer_info, $manufacturer_details) = $setting_object->get_manufacturer($filter);
		if(isset($manufacturer_details) && $manufacturer_details!=''){
			if(count($manufacturer_info) > 10) $sk = 'data-live-search="true"'; else $sk = '';
			$list_data = '';
			echo "<script>selectpickerinit('');</script>";
				$list_data .= '<select id="manufacturer_id" name="manufacturer_id[]" class="form-control selectpicker" multiple data-actions-box="true" '.$sk.'>';
				$cnt=($manufacturer_details!=-1)?count($manufacturer_details):0;
					for($i=0;$i<$cnt;$i++){
						$list_data .= "<option value='".$manufacturer_details[$i]['manufacturer_id']."'>".$manufacturer_details[$i]['name']."</option>";
					}
			$list_data .= '</select>';
			echo $list_data;
			return true;
		}else return false;
	}


	function get_domainwise_asset_department($operation){
		global $vis_language;
		$domain_id = $_POST['domain_id'];
		$database = new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$setting_object=new class_setting($database);
		
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$object = new class_report($database);

		if($domain_id!=''){ $filter = ' department_access = '.$domain_id.' OR department_access =0';}else{ $filter=""; }
		list($assetdept_info, $assetdept_details) = $setting_object->get_assetdept($filter,'', '', '', '', '');
		if(isset($assetdept_details) && $assetdept_details!=''){
			if(count($assetdept_info) > 10) $sk = 'data-live-search="true"'; else $sk = '';
			$list_data = '';
			echo "<script>selectpickerinit('');</script>";
				$list_data .= '<select id="assetdept_id" name="assetdept_id" class="form-control selectpicker" '.$sk.'>';
				$list_data .= '<option value="-1">'.$vis_language['TXTSELECT'].'</option>';
				$cnt=($assetdept_details!=-1)?count($assetdept_details):0;
					for($i=0;$i<$cnt;$i++){
						$list_data .= "<option value='".$assetdept_details[$i]['assetdept_id']."'>".$assetdept_details[$i]['name']."</option>";
					}
			$list_data .= '</select>';
			echo $list_data;
			return true;
		}else return false;
	}
	function get_domainwise_asset_states(){
		global $vis_language;
		$domain_id = $_POST['domain_id'];
		$database = new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$setting_object=new class_setting($database);
		
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$object = new class_report($database);

		if($domain_id!=''){ $filter = ' '.VIS_TABLE_PREFIX.'itil_asset_state.department_access = '.$domain_id.' OR '.VIS_TABLE_PREFIX.'itil_asset_state.department_access =0 GROUP BY '.VIS_TABLE_PREFIX.'itil_asset_state.description ';}else{ $filter=""; }
		list($asset_state_info, $asset_state_details)=$setting_object->get_asset_state($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(isset($asset_state_details) && $asset_state_details!=''){
			if(count($asset_state_info) > 10) $sk = 'data-live-search="true"'; else $sk = '';
			$list_data = '';
			echo "<script>selectpickerinit('');</script>";
				$list_data .= '<select id="asset_id" name="asset_id" class="form-control selectpicker" '.$sk.'>';
				$list_data .= '<option value="-1">'.$vis_language['TXTSELECT'].'</option>';
				$cnt=($asset_state_details!=-1)?count($asset_state_details):0;
					for($i=0;$i<$cnt;$i++){
						$list_data .= "<option value='".$asset_state_details[$i]['asset_id']."'>".$asset_state_details[$i]['description']."</option>";
					}
			$list_data .= '</select>';
			echo $list_data;
			return true;
		}else return false;
	}

	function get_domainwise_asset_products(){
		global $vis_language;
		$domain_id = $_POST['domain_id'];
		$database = new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$setting_object=new class_setting($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$object = new class_report($database);
		if($domain_id!=''){ $filter = ' '.VIS_TABLE_PREFIX.'itil_ci_product.department_access = '.$domain_id.' OR '.VIS_TABLE_PREFIX.'itil_ci_product.department_access =0 ';}else{ $filter=""; }
		list($ci_product_info, $ci_product_details)=$setting_object->get_ci_product($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(isset($ci_product_details) && $ci_product_details!=''){
			if(count($ci_product_info) > 10) $sk = 'data-live-search="true"'; else $sk = '';
			$list_data = '';
			echo "<script>selectpickerinit('');</script>";
				$list_data .= '<select id="product_id" name="product_id" class="form-control selectpicker" '.$sk.'>';
				$list_data .= '<option value="-1">'.$vis_language['TXTSELECT'].'</option>';
				$cnt=($ci_product_details!=-1)?count($ci_product_details):0;
					for($i=0;$i<$cnt;$i++){
						$list_data .= "<option value='".$ci_product_details[$i]['product_id']."'>".$ci_product_details[$i]['name']."</option>";
					}
			$list_data .= '</select>';
			echo $list_data;
			return true;
		}else return false;
	}

	function get_domainwise_asset_vendors(){
		global $vis_language;
		$domain_id = $_POST['domain_id'];
		$database = new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$setting_object=new class_setting($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$object = new class_report($database);
		if($domain_id!=''){ $filter = ' '.VIS_TABLE_PREFIX.'itil_vendor.department_access = '.$domain_id.' OR '.VIS_TABLE_PREFIX.'itil_vendor.department_access =0 ';}else{ $filter=""; }
		list($vendor_info, $vendor_details)=$setting_object->get_vendor($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(isset($vendor_details) && $vendor_details!=''){
			if(count($vendor_info) > 10) $sk = 'data-live-search="true"'; else $sk = '';
			$list_data = '';
			echo "<script>selectpickerinit('');</script>";
				$list_data .= '<select id="vendor_id" name="vendor_id" class="form-control selectpicker" '.$sk.'>';
				$list_data .= '<option value="-1">'.$vis_language['TXTSELECT'].'</option>';
				$cnt=($vendor_details!=-1)?count($vendor_details):0;
					for($i=0;$i<$cnt;$i++){
						$list_data .= "<option value='".$vendor_details[$i]['vendor_id']."'>".$vendor_details[$i]['name']."</option>";
					}
			$list_data .= '</select>';
			echo $list_data;
			return true;
		}else return false;
	}
	
	function get_domainwise_dropdown($operation){
		global $vis_language;
		$domain_id = $operation['domain_id'];
		$database = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
		$client_object = new class_client($database);
		include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'client.php');
		$object_client = new client();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
		$domain_list   = $object_client->get_domain_access_list();		
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$object = new class_report($database);
			$script = '';
			if (isset($operation['visreport']) && $operation['visreport']=='assets_baseline_report') {
				$script = 'onchange="chnge_type(this.value);"';
			} 
			if (isset($operation['visreport']) && ($operation['visreport']=='assets_linkedto_problems_report' || $operation['visreport']=='assets_linkedto_tickets_report' || $operation['visreport']=='assets_linkedto_changes_report' || $operation['visreport']=='assets_linkedto_releases_report')) {
				$script = 'onchange="selAssets(this.value);"';
			}

			if(isset($operation['alldomain']) && $operation['alldomain']=='1' && $domain_id=='0'){  $filter = VIS_TABLE_PREFIX.'itil_configuration_item.department_access=0 or ' . VIS_TABLE_PREFIX.'itil_configuration_item.department_access in('.$domain_id.')'; $result = $setting_object->get_configuration_item_category('',$filter); }
			elseif($domain_id=='' || $domain_id!='-1')
				{
					if (isset($operation['visreport']) && $operation['visreport']=='unauthchange_report') 
						{
							$filter = VIS_TABLE_PREFIX.'itil_configuration_item.item_id=3 and '.VIS_TABLE_PREFIX.'itil_configuration_item.department_access=0 or ' . VIS_TABLE_PREFIX.'itil_configuration_item.department_access in('.$domain_id.')'; 
						}
						elseif (isset($operation['visreport']) && $operation['visreport']=='asset_manufacturer_report') 
                        {
                            $filter = VIS_TABLE_PREFIX.'itil_configuration_item.item_id IN(3,8,9,10,11,12,13) and '.VIS_TABLE_PREFIX.'itil_configuration_item.department_access=0 or ' . VIS_TABLE_PREFIX.'itil_configuration_item.department_access in('.$domain_id.')'; 
                        }
                        elseif (isset($operation['visreport']) && $operation['visreport']=='assets_expiry_report' || $operation['visreport']=='asset_report') 
						{
						    $filter = VIS_TABLE_PREFIX.'itil_configuration_item.item_id IN(2,3,8,9,10,11,12,13) and '.VIS_TABLE_PREFIX.'itil_configuration_item.department_access=0 or ' . VIS_TABLE_PREFIX.'itil_configuration_item.department_access in('.$domain_id.')'; 
						}
                        elseif (isset($operation['visreport']) && ($operation['visreport']=='assets_groupby_status_report' || $operation['visreport']=='assets_depreciation_report' || $operation['visreport']=='assets_depreciation_notification_report')) 
                        {
                            $filter = VIS_TABLE_PREFIX.'itil_configuration_item.item_id IN(2,8,9,10,11,12,13) and '.VIS_TABLE_PREFIX.'itil_configuration_item.department_access=0 or ' . VIS_TABLE_PREFIX.'itil_configuration_item.department_access in('.$domain_id.')'; 
                        }
						else
						{
							$filter = VIS_TABLE_PREFIX.'itil_configuration_item.department_access=0 or ' . VIS_TABLE_PREFIX.'itil_configuration_item.department_access in('.$domain_id.')'; 
						}				
					$result = $setting_object->get_configuration_item_category('',$filter); 
				}
			else{ $filter=""; $result = -1;}
			
			if(count($result) > 10) $sk = 'data-live-search="true"'; else $sk = '';
			$list_data = '';
			//echo "<script>selectpickerinit('');</script>";
			$list_data .= '<select id="' .$operation['selectname']. '" name="' .$operation['selectname']. '" class="form-control selectpicker" '.$sk.' ' .$script. '>';
			$list_data .= '<option value="' .$operation['selectvalue']. '">'.$vis_language['TXTSELECT'].'</option>';
			if($result!= -1){
				//$list_data .= '<option value="0">All</option>';
				for($i=0;$i<count($result);$i++){
					$list_data .= "<option value='".$result[$i]['item_id']."'>".$result[$i]['name']."</option>";
				}
			}
			$list_data .= '</select>';
		echo $list_data;
		return true;
	}
	function get_citypewise_dropdown($operation){
		global $vis_language;
		$domain_id = $operation['domain_id'];
		$ci_type_id = $operation['ci_type_id'];
		$database = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
		$client_object = new class_client($database);
		include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'client.php');
		$object_client = new client();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
		$domain_list   = $object_client->get_domain_access_list();		
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$object = new class_report($database);		
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'cmdb.php');
		$cmdb_obj = new class_cmdb($database); 
			/*$checkdm = explode(",",$domain_list);
			if (in_array($domain_id,$checkdm)){
				if($domain_id==1){
				$domain_id=0;
				}else{
				$domain_id=$domain_id;
				}
			}*/
			if($ci_type_id!='' && $domain_id!='-1'){   $filter = VIS_TABLE_PREFIX.'itil_cmdb_assets.department_access='.$domain_id.' and ' . VIS_TABLE_PREFIX.'itil_cmdb_assets.ci_type_id ='.$ci_type_id; $result = $cmdb_obj->get_assets($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA); }else{ $filter=""; $result = -1;}
			
			if($result!=-1&&count($result) > 10) $sk = 'data-live-search="true"'; else $sk = '';
			$list_data = '';
			//echo "<script>selectpickerinit('');</script>";
			$list_data .= '<select id="vis_asset_id" name="vis_asset_id" class="form-control selectpicker" '.$sk.'>';
			$list_data .= '<option value="-1">'.$vis_language['TXTSELECT'].'</option>';
			if($result!= -1){
				//$list_data .= '<option value="0">All</option>';
				for($i=0;$i<count($result);$i++){
					$list_data .= "<option value='".$result[$i]['assets_id']."'>".$result[$i]['name']."</option>";
				}
			}
			$list_data .= '</select>';
		
		echo $list_data;
		return true;
	}
	
	function overdue_tickets_report($operation)
	{	
		global $vis_language;
		$report_title = $vis_language['TXTOVERDUETICKET'];
		$export       = 1;
		if(isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();

		$report_type = 86;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
		$object_staff  = new class_staff($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page'])) ? $operation['vis_page'] : 0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='overdue_tickets_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		$departments   = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		if((isset($operation['vis_action']) && $operation['vis_action']!='') || isset($operation['vis_submit']) && $operation['vis_submit']!=''){
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$data['department_id']= (isset($data['department_id']))?$data['department_id']:'';
				  
				if($data['department_id']==''){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDEPARTMENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
					
				}
			 if ($data['duration'] != 0 && $data['department_id']==''){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDEPARTMENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}  
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ // previous 1 month
					$currentdate = date('Y-m-d H:i:s');
					$from = $dates['thirty_day'];
				} elseif ($data['duration'] == 2){ // previous 1 week
					$from = $dates['seven_day'];
				} else if($data['duration'] == 3){ //previous 1 day
					$from = $dates['one_day'];
				} elseif ($data['duration'] == 4){ // custom date range
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}
				$filter    = VIS_TABLE_PREFIX.'ticket.receive_date between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and ';
				
				if(!empty($data['department_id'])){
					$dept_ids = implode(',',$data['department_id']);
					$filter .= ' d.department_id IN ('.$dept_ids.') and ';
				}
				$filter_arr = $tkt_object->get_filter($data['filter_id'], $staff_id, VIS_LOCATION_AREA);
				$filter    .= $filter_arr['filter'];
			}
			$array_summary=array();
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object      = new class_report($database);
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
			$object_setting = new class_setting($database);
			$custom_filter = ' (location=1 or location=2 or location=11) and is_enabled=1';
			// $custom_grouplist = $object_setting->get_custom_group_list($custom_filter, $staff_id, VIS_LOCATION_AREA);
			list($total_rec, $report) = $object->get_overdue_ticket_reports($filter, $limit, $staff_id, VIS_LOCATION_AREA);
			$total= ($total_rec==-1)? 0:count($total_rec);
			$view_info['page']=$page;
			$view_info['view_count']= ($total_rec==-1)? 0:count($total_rec);
			$report_count=($report!=-1)? count($report) : 0;
			$view_info['page_count']=($total_rec==-1)?0:ceil(count($total_rec)/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export         = new export();
				$j=0;
				foreach ($report as $i){
					foreach ($i as $key => $val){
						if($key == 'ticket_hash'){
							$report_exp[$j][$key] = $val;
						} else if($key == 'subject'){
							$report_exp[$j][$key] = $val;
						} else if($key == 'first_name' || $key == 'last_name' || $key == 'email' || $key == 'group_name'){
							$report_exp[$j][$key] = $val;
						} else if($key == 'receive_date'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} else if($key == 'due_time'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} 
					}
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['client_name'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					$report_exp1[$j]['creation_date'] = $report_exp[$j]['receive_date'];
					$report_exp1[$j]['overdue_since'] = $report_exp[$j]['due_time'];
					$j++;
				}
				if($report == -1){ $report_exp1[$j][$vis_language['TXTTOTALNOTKT']] =  0; 
				}else { $report_exp1[$j]['total_number_of_tickets'] = $vis_language['TXTTOTALNOTKT'].': '.count($total_rec); }
				
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);
				if(isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else { 
				if ($total_rec!=-1)
				$array_summary['TXTTOTALNOTKT'] = count($total_rec);
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>count($total_rec),'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function get_domainwise_departments($operation){
		global $vis_language;
		$domain_id = $_POST['domain_id'];
		$database = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
		$client_object = new class_client($database);
		include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'client.php');
		$object_client = new client();
		$domain_list   = $object_client->get_domain_access_list();
		$clientGroup   = $client_object->get_client_group1(' (domain_id in (' . $domain_list . ') or domain_id=0 ) and is_enable=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$object = new class_report($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		if($domain_id=='' || $domain_id!='0'){ $filter = VIS_TABLE_PREFIX.'department.domain_id = '.$domain_id;}else{ $filter=""; }
		echo "<script>selectpickerinit('');</script>";
		$result = $tkt_object->get_department($filter, VIS_STAFF_ID, VIS_LOCATION_AREA, $order_by='');
		if(count($clientGroup) > 10) $sk = 'data-live-search="true"'; else $sk = '';
		$list_data='';
		$list_data .= '<label>'.$vis_language['TXTDEPARTMENT'].'</label>';
		$list_data .= '<select class="form-control selectpicker" name="department_id[]" '.$sk.'  multiple data-actions-box="true">';
		if($result!= -1){
			for($i=0;$i<count($result);$i++){
				$list_data .= "<option value='".$result[$i]['department_id']."'>".$result[$i]['department_name']."</option>";
			}
		}
		$list_data .= '</select>';
		echo $list_data;
		return true;
	}
	
	function get_department_wise_service_itme($operation){
		global $vis_language;
		$deparid=0;
		if(is_array($operation['department_ids'])){
		$deparid = implode(',',$operation['department_ids']);
		}else{
			$deparid=0;
		}
		$database = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
		$object = new class_setting($database);
		$filter1 = VIS_TABLE_PREFIX.'itil_service_item.status=1 and '.VIS_TABLE_PREFIX.'itil_service_category.is_enabled=1 ';
		list($service_info, $service_details)=$object->get_service_dep_wise_item($filter1,$deparid,VIS_STAFF_ID, VIS_LOCATION_AREA,'');
		if(count($service_info) > 10) $sk = 'data-live-search="true"'; else $sk = '';
		$list_data='';
		$list_data .= '<select name="item_id[]" id="item_id" class="form-control selectpicker ticketowner"  '.$sk.'  multiple data-actions-box="true">';		
		if($service_details!=-1) {
			for($i=0;$i<count($service_details);$i++) {						 
				$list_data .= '<option value="'.$service_details[$i]['item_id'].'"> '.$service_details[$i]['category_name'].' : '.$service_details[$i]['name'].'</option>';
			}
		}		
		$list_data .= '</select>';
		echo $list_data;
		return true;
	}
	
	function unoverdue_ticket_report($operation)
	{	
		global $vis_language;
		$report_title = $vis_language['TXTUNDUEREPORT'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();

		$report_type = 87;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
		$object_staff = new class_staff($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
		$object_setting = new class_setting($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];		
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='unoverdue_ticket_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		$filter         = 'location in(1,11)';
		$staff_filter   = "staff_id =" . $staff_id;
		$staff_details = $object_staff->get_staff($staff_filter, $staff_id, VIS_LOCATION_AREA);
		$departments   = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		$dept_ids    = '';
		for ($d = 0; $d < count($departments); $d++) {
			$dept_ids .= $departments[$d]['department_id'] . ',';
		}
		if ($dept_ids != '') {
			$dept_ids = substr($dept_ids, 0, -1);
		}
		$dept_id  = ($staff_details[0]['department_access'] == '' || $staff_details[0]['department_access'] == 0) ? $dept_ids : $staff_details[0]['department_access'];
		if((isset($operation['vis_action']) && $operation['vis_action']!='') || isset($operation['vis_submit']) && $operation['vis_submit']!=''){
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				$data['department_id'] = (isset($data['department_id']))? $data['department_id']:0;
				if ($data['duration'] == 0 && $data['department_id'] == '0') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 0 && $data['department_id'] != '0') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] != 0 && $data['department_id'] == '0') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDEPARTMENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$dept_ids = implode(',',$data['department_id']);
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;

			if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day']; 
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				if($data['department_id']!='' && $data['department_id']!=0){
					$filter = ' receive_date between ' . $from . ' AND ' . $to . ' and ' .VIS_TABLE_PREFIX.'ticket.department_id IN (' . $dept_ids.') and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' AND '.VIS_TABLE_PREFIX.'ticket.draft_id=0';
				} else {
					$filter    = ' receive_date between ' . $from . ' AND ' . $to.' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' AND '.VIS_TABLE_PREFIX.'ticket.draft_id=0';
				}
			}

			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object      = new class_report($database);
			$custom_filter = ' (location=1 or location=2 or location=11) and is_enabled=1';
			/*$custom_grouplist = $object_setting->get_custom_group_list($custom_filter, $staff_id, VIS_LOCATION_AREA);*/			
			list($total_rec, $report) = $object->get_unoverdue_ticket($filter, $limit, $staff_id, VIS_LOCATION_AREA);
			$total= $total_rec;
			$view_info['page']=$page;
			$view_info['view_count']= $total_rec;
			$report_count=($report!=-1)? count($report) : 0;
			$view_info['page_count']=($total_rec==0) ? 0 : ceil($total_rec/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export         = new export();
				$j=0;
				foreach ($report as $i){
					foreach ($i as $key => $val){
						if($key == 'ticket_hash'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'subject'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'department_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'receive_date'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif($key == 'status_name'){
							$report_exp[$j][$key] = $val;
						}
					}
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];	
					$report_exp1[$j]['department_name'] = $report_exp[$j]['department_name'];
					$report_exp1[$j]['creation_date'] = $report_exp[$j]['receive_date']; 									
					$report_exp1[$j]['status'] = $report_exp[$j]['status_name'];
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total_rec,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}
	
	function ticket_activity_by_department_report($operation)
	{	
		global $vis_language;
		$report_title =  $vis_language['TXTTICKETACTIVITYBYDEPTREP'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type = 88;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$departments   = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
		$object_staff  = new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page'])) ? $operation['vis_page'] : 0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='ticket_activity_by_department_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
				
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				$data['department_id'] = (isset($data['department_id']) && $data['department_id']!='')?$data['department_id']:0;
				if ($data['duration'] == 0 && $data['department_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['department_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDEPARTMENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['department_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$dept_ids = implode(',',$data['department_id']);
				$chk_dept = ' and '.VIS_TABLE_PREFIX.'auditlog.department_id IN('.$dept_ids.')';
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = ''.VIS_TABLE_PREFIX.'auditlog.entry_date  between ' . $from . ' AND ' . $to . $chk_dept;
				$filter .= " and ".VIS_TABLE_PREFIX."auditlog.access_id!=1 and ".VIS_TABLE_PREFIX."auditlog.access_id!=2 and ".VIS_TABLE_PREFIX."auditlog.access_id!=3 and ".VIS_TABLE_PREFIX."ticket.channel_id!=7 and ".VIS_TABLE_PREFIX."ticket.channel_id!='.$lc_chnid.' and ".VIS_TABLE_PREFIX."ticket.draft_id =0";
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$audit_log = array();
			list($total_cnt, $audit_log) = $object->ticket_activity_by_department_report($filter,$filter1='',$limit, $staff_id, VIS_LOCATION_AREA);
			$total = $total_cnt;
			/*if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				$filtern=VIS_TABLE_PREFIX.'customgroup.is_enabled = 1 and '.VIS_TABLE_PREFIX.'customfield.is_enabled = 1 and '.VIS_TABLE_PREFIX.'customfield_data.group_type = 1 and '.VIS_TABLE_PREFIX.'ticket.ticket_id IN(select DISTINCT ticket_id from '.VIS_TABLE_PREFIX.'auditlog where '.$filter.')';
				$custom_fields_details=$object->get_custom_fields_data($filtern);  
			}*/
			if($audit_log!=-1) {
				$close_time=$audit_log[0]['closed_time'];
				$creation_time=$audit_log [0]['creation_date'];
				if( $close_time!=0){
					$total_time=$audit_log[0]['closed_time']-$audit_log[0]['creation_date'];
				} else {
					$total_time=" ";
				} 
				$avgTimeCount =count_remain_time($total_time ) ;
			}
			$view_info['page']=$page;
			$view_info['view_count']= $total_cnt;
			$report_count=($audit_log!=-1)? count($audit_log) : 0;
			$view_info['page_count']=($total_cnt==0) ? 0 : ceil($total_cnt/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			$report = $audit_log;
			for($i=0 ; $i<$report_count ; $i++){	
				switch($audit_log[$i]['operation_id']) {
					case '0':
						$audit_log[$i]['audit_log_operation']= ($audit_log[$i]['channel_id']==7) ? $vis_language['TXTSERVICEREQUESTCREATED'] : $vis_language['MSGNEWTKTCRT'];
						break;
					case '1':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGTKTRPLD'];
						break;
					case '2':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTSTATUSCHANGEDFROM'].' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info'];
						break;
					case '3':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTPRIORITYCHANGEDFROM'].' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info'];
						break;
					case '4':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTDEPARTMENTCHANGEDFROM'].' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info'];
						break;
					case '5':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTTICKETTYPECHANGEDFROM'].' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info'];
						break;
					case '6':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTFLAGCHANGEDFROM'].' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info'];
						break;
					case '7':
						include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');  
						$object=new class_setting($database);
						$staff_new_info=$object->get_staff(VIS_TABLE_PREFIX.'staff.staff_id='.$audit_log[$i]['new_info'], '', '', '', $staff_id, VIS_LOCATION_AREA,1);
						$new_info =  $staff_new_info[1][0]['first_name'].' '.$staff_new_info[1][0]['last_name'];
						if($audit_log[$i]['new_info']!=0 && $staff_new_info[1]!=-1){
							$audit_log[$i]['audit_log_operation'] = $vis_language['MSGTKTASSIG'].' '.strtolower($vis_language['TXTTO']).' '. $new_info;
						} elseif($audit_log[$i]['new_info']==0 && $audit_log[$i]['old_info']>0){ 
							$staff_old_info=$object->get_staff(VIS_TABLE_PREFIX.'staff.staff_id='.$audit_log[$i]['old_info'], '', '', '', $staff_id, VIS_LOCATION_AREA,1);
							$old_info =  $staff_old_info[1][0]['first_name'].' '.$staff_old_info[1][0]['last_name'];
							$audit_log[$i]['audit_log_operation'] = $vis_language['TXTTICKETUNASSIGNEDFROM'].' '. $old_info;
						} else {
							$audit_log[$i]['audit_log_operation'] = $vis_language['TXTTICKETASSIGNEDTONOBODY'];
						}
						break;
					case '8':
						include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');  
						$object=new class_setting($database);
						$staff_details=$object->get_staff(VIS_TABLE_PREFIX.'staff.staff_id='.$audit_log[$i]['operator_id'], '', '', '', $staff_id, VIS_LOCATION_AREA);
						$staff_name =  $staff_details[1][0]['first_name'].' '.$staff_details[1][0]['last_name'];
						if($audit_log[$i]['old_info']!=0){
							$audit_log[$i]['audit_log_operation']=$vis_language['MSGTKTTRSH'];
						} elseif($audit_log[$i]['old_info']==0 ){
							$audit_log[$i]['audit_log_operation']=$vis_language['TXTTKTMOVEINBOCFROMTRASH'];
						}
						break;
					case '9':
						include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');  
						$object=new class_setting($database);
						$staff_details=$object->get_staff(VIS_TABLE_PREFIX.'staff.staff_id='.$audit_log[$i]['operator_id'], '', '', '', $staff_id, VIS_LOCATION_AREA);
						$staff_name =  $staff_details[1][0]['first_name'].' '.$staff_details[1][0]['last_name'];
						$audit_log[$i]['audit_log_operation']=$audit_log[$i+1]['old_info'] .strtolower($vis_language['TXTDELETED']);
						break;
					case '10':
						include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
						$object=new class_ticket($database);
						$audit_log[$i]['audit_log_operation']=$audit_log[$i]['new_info'] .' '.strtolower($vis_language['TXTMERGEDTO']).' '.$audit_log[$i]['old_info'];
						break;
					case '11':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGTKTFRWD'];
						break;
					case '12':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGTKTDELETED'];
						break;
					case '13':
						include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');  
						$object=new class_setting($database);
						$sla_old_info=$object->get_sla(VIS_TABLE_PREFIX.'sla.sla_id='.$audit_log[$i]['old_info'], '', '', '', $staff_id, VIS_LOCATION_AREA);
						$sla_new_info=$object->get_sla(VIS_TABLE_PREFIX.'sla.sla_id='.$audit_log[$i]['new_info'], '', '', '', $staff_id, VIS_LOCATION_AREA);
						$old_info =  $sla_old_info[1][0]['sla_name'];
						$new_info =  $sla_new_info[1][0]['sla_name'];
						if($audit_log[$i]['new_info']!=0 && $audit_log[$i]['old_info']!=0){
							$audit_log[$i]['audit_log_operation'] = $vis_language['TXTSLACHANGEDFROM'].' '. $old_info. ' '.strtolower($vis_language['TXTTO']).' '. $new_info;
						} else if($audit_log[$i]['old_info']==0 && $audit_log[$i]['new_info']!=0){
							$audit_log[$i]['audit_log_operation'] = $vis_language['TXTSLASETTO'].' '. $new_info;
						} else if($audit_log[$i]['new_info']==0){
							$audit_log[$i]['audit_log_operation'] = $vis_language['TXTAPPLIEDCUSTOMSLAPLAN'];
						}
						break;
					case '14':
						if($audit_log[$i]['new_info']!=0 && $audit_log[$i]['old_info']==0){
							$audit_log[$i]['audit_log_operation']=$vis_language['MSGSPAMMRK'];
						} elseif($audit_log[$i]['new_info']==0 && $audit_log[$i]['old_info']!=0){
							$audit_log[$i]['audit_log_operation']=$vis_language['TXTNOTSPAMMARKED'];
						}
						break;
					case '15':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGUNSPAM'];
						break;
					case '16':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTNEWTASKATTACHED'].' '. $audit_log[$i]['old_info'];
						break;
					case '17':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTDETACHEDATTACHEDTASK'].' '. $audit_log[$i]['old_info'];
						break;
					case '18':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTNEWCIATTACHED'].' '. $audit_log[$i]['old_info'];
						break;
					case '19':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTDETACHEDATTACHEDCI'].' '. $audit_log[$i]['old_info'];
						break;
					case '20':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTNEWPROBLEMATTACHED'].' '. $audit_log[$i]['old_info'];
						break;
					case '21':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTDETACHEDATTACHEDPROBLEM'].' '. $audit_log[$i]['old_info'];
						break;
					case '22':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTNEWCHANGEATTACHED'].' '. $audit_log[$i]['old_info'];
						break;
					case '23':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTDETACHEDATTACHEDCHANGE'].' '. $audit_log[$i]['old_info'];
						break;	
					case '24':
						include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
						$object=new class_ticket($database);
						$audit_log[$i]['audit_log_operation']=$audit_log[$i]['new_info'] .' '.$vis_language['TXTLINKEDTO'].' '.$audit_log[$i]['old_info'];
						break;	
					case '25':
						include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
						$object=new class_ticket($database);
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGTICKETPOSTDELETE'];
						break;	
					case '26':
						include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
						$object=new class_ticket($database);
						$audit_log[$i]['audit_log_operation']=$vis_language['TXTTICKETPOSTSPLITWITH'].' '.$audit_log[$i]['new_info'];
						break;	
					case '27':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTCHANNELCHANGEDFROM'].' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info'];
						break;
					case '28':
						$audit_log[$i]['audit_log_operation']=$audit_log[$i]['old_info'].' '.strtolower($vis_language['TXTUNLINKEDFROM']).' '.$audit_log[$i]['new_info'];
						break;	
					case '29':
						$audit_log[$i]['audit_log_operation']=$vis_language['TXTSET'].' '.$audit_log[$i]['new_info'].' '.strtolower($vis_language['TXTLABEL']);
						break;	
					case '30':
						$audit_log[$i]['audit_log_operation']=$vis_language['TXTPINNED'].' '.$audit_log[$i]['old_info'];
						break;
					case '31':
						$audit_log[$i]['audit_log_operation']=$vis_language['TXTREMOVEDLABEL'].' '.$audit_log[$i]['new_info'];
						break;
					case '32':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGTICKETPROPERTYUPDATED'];
						break;
					case '33':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGTICKETNOTEADDED'];
						break;
					case '34':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGTICKETNOTEDELETED'];
						break;
					case '35':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGTICKETCOMMENTADDED'];
						break;
					case '36':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGTICKETCOMMENTDELETED'];
						break;
					case '37':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGTICKETPOSTUPDATED'];
						break;
					case '38':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGADDEDNEWRECIPIENT'].' '.$audit_log[$i]['new_info'];
						break;
					case '39':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGADDEDNEWPEOPLE'].' '.$audit_log[$i]['new_info'];
						break;
					case '40':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGREMOVEDRECIPIENT'].' '.$audit_log[$i]['new_info'];
						break;
					case '41':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGREMOVEDPEOPLE'].' '.$audit_log[$i]['new_info'];
						break;
					case '42':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGADDEDNEWTAG'].' '.$audit_log[$i]['new_info'];
						break;
					case '43':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGREMOVEDTAG'].' '.$audit_log[$i]['new_info'];
						break;
					case '44':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGNEWSCHEDULETKTCRT'];
						break;
					case '45':
						$audit_log[$i]['audit_log_operation']=($audit_log[$i]['old_info'] == '')?$vis_language['MSGTICKETLEVELCHANGED'].' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info']:$vis_language['MSGTICKETLEVELCHANGED'].' '.strtolower($vis_language['TXTFROM']).' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info'];
						break;
					case '46':
						$audit_log[$i]['audit_log_operation']=($audit_log[$i]['old_info'] == '')?$vis_language['MSGTICKETCATEGORYCHANGED'].' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info']:$vis_language['MSGTICKETCATEGORYCHANGED'].' '.strtolower($vis_language['TXTFROM']).' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info'];
						break;
					case '47':
						$audit_log[$i]['audit_log_operation']=($audit_log[$i]['old_info'] == '')?$vis_language['MSGTICKETSUBCATEGORYCHANGED'].' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info']:$vis_language['MSGTICKETSUBCATEGORYCHANGED'].' '.strtolower($vis_language['TXTFROM']).' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info'];
						break;
					case '48':
						$audit_log[$i]['audit_log_operation']=($audit_log[$i]['old_info'] == '')?$vis_language['MSGTICKETITEMCHANGED'].' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info']:$vis_language['MSGTICKETITEMCHANGED'].' '.strtolower($vis_language['TXTFROM']).' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info'];
						break;
					case '49':
						$audit_log[$i]['audit_log_operation']=($audit_log[$i]['old_info'] == '')?$vis_language['MSGITILLOCATIONCHANGED'].' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info']:$vis_language['MSGITILLOCATIONCHANGED'].' '.strtolower($vis_language['TXTFROM']).' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info'];
						break;
					case '50':
						$audit_log[$i]['audit_log_operation']=$vis_language['TXTSLAPAUSED'];
						break;
					case '51':
						$audit_log[$i]['audit_log_operation']=$vis_language['TXTSLARESUMED'];
						break;
					case '52':
						$audit_log[$i]['audit_log_operation']=$vis_language['TXTREADTICKETFORSTAFF'];
						break;
					case '53':
						$audit_log[$i]['audit_log_operation']=$vis_language['TXTSENDTICKETAPPROVAL'].' '.strtolower($vis_language['TXTTO']).' '.$audit_log[$i]['old_info'];
						break;
					case '54':
						$audit_log[$i]['audit_log_operation']=$vis_language['TXTCHANGETICKETAPPROVALSTATUS'].' '.strtolower($vis_language['TXTBY']).' '.$audit_log[$i]['old_info'];
						break;
					case '55':
						$audit_log[$i]['audit_log_operation']=$vis_language['TXTSENDTICKETAPPROVALREMINDER'].' '.strtolower($vis_language['TXTBY']).' '.$audit_log[$i]['old_info'];
						break;
					case '56':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGCUSTOMEFIELDDATAMODIFIED'].' '.strtolower($vis_language['TXTBY']).' '.$audit_log[$i]['old_info'];
						break;
					case '57':
						$audit_log[$i]['audit_log_operation']=$vis_language['MSGCUSTOMEFIELDDATAMODIFIED'].' '.strtolower($vis_language['TXTBY']).' '.$audit_log[$i]['old_info'];
						break;
					case '58':
						$audit_log[$i]['audit_log_operation']=($audit_log[$i]['old_info'] == '')?$audit_log[$i]['new_info']:$vis_language['MSGITILLOCATIONCHANGED'].' '.strtolower($vis_language['TXTFROM']).' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info'];
						break;
					case '59':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTCHANGEURGENCY'].' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info'];
						break;
					case '60':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTCHANGEIMPACT'].' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info'];
						break;
					case '61':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTADDED'].' '.strtolower($vis_language['TXTJUSTPRIORITYCHNG']).' - '.$audit_log[$i]['new_info'];
						break;
					case '62':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTSYMPTONS'].' '.strtolower($vis_language['TXTADDED']).' - '.$audit_log[$i]['new_info'];
						break;
					case '63':
						$audit_log[$i]['audit_log_operation']=$vis_language['TXTCLONE'].' '.strtolower($vis_language['TXTTICKET']).' '.strtolower($vis_language['TXTFROM']).' '. $audit_log[$i]['old_info']. ' '.strtolower($vis_language['TXTTO']).' '. $audit_log[$i]['new_info'];
						break;
					case '64':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTADDED'].' '.strtolower($vis_language['TXTDTSIMPACTCHNG']).' - '.$audit_log[$i]['new_info'];
						break;
					case '65':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTNEWRELATTACHED'].' '. $audit_log[$i]['old_info'];
						break;
					case '66':
						$audit_log[$i]['audit_log_operation'] = $vis_language['TXTDETTACHATTACHREL'].' '. $audit_log[$i]['old_info'];
						break;
				}
				$audit_log1=$audit_log;
			}
			$operators=array(1=>$vis_language['TXTCLIENT'], 2=>$vis_language['TXTSTAFF'], 3=>$vis_language['TXTSTAFF'],4=>$vis_language['TXTSYSTEM']);
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$operators=array(1=>$vis_language['TXTCLIENT'], 2=>$vis_language['TXTSTAFF'], 3=>$vis_language['TXTSTAFF'],0=>$vis_language['TXTSYSTEM']);
				$j = 0;		 
				foreach ($audit_log as $i){
					foreach ($i as $key => $val) {
						$name=''; if($i['operator_id']!= -1){ $name = $vis_language['TXTWORKFLOW']; }else { $name =$vis_language['TXTROUNDROBIN']; }
						if ($key == 'ticket_hash') {
							$report_exp[$j]['incident_hash'] = $val; 
						} elseif ($key == 'subject') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'audit_log_operation') {
							$report_exp[$j]['operation'] = $val;
						} elseif ($key == 'operator' ) {
							//$report_exp[$j][$key]=($i['operator_id']==0?$vis_language['TXTSYSTEM']:($operators[$i['operator']].' ('.$i['operators'].')'));   && $i['fname']==''
								$report_exp[$j][$key]=(($i['workflow_id']!=0 || (($i['operator']==4 )))? 
						 ($i['workflow_id']!=0)? $vis_language['TXTSYSTEM'].' ('.$name.' - '.$i['workflow_name'].')': $vis_language['TXTSYSTEM']:($operators[$i['operator']].' ('.$i['operators'].')'));	
						} elseif ($key == 'operation_date') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'department_name') {
							$report_exp[$j]['department'] = $val;
						} 
						/*elseif ($key == 'creation_date') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						}    elseif ($key == 'status') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'type_title') {
							$key = 'type';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'owner') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'level_title') {
							$key = 'level';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'category_title') {
							$key = 'category';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'subcategory_title') {
							$key = 'subcategory';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'item_title') {
							$key = 'item';
							$report_exp[$j][$key] = $val;
						} elseif ($key != 'workflow_id' && $key != 'ticket_id' && $key != 'old_info' && $key != 'new_info' && $key != 'closed_time' && $key != 'item_id' && $key != 'operation_id' && $key != 'department_id' && $key != 'operator_id' && $key != 'operator' && $key != 'ticket_entry' && $key != 'entry_date' && $key != 'receive_date' && $key != 'access_id' && $key != 'workflow_name') {
							$report_exp[$j][$key] = $val;
						}*/																				
					}
					unset($report_exp[$j]['channel_id']);
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				} else {
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total_cnt,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function ticket_ci_relation_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTTICKETCIRELATION'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type=89;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object      = new class_ticket($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$departments     = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		$filter     = VIS_TABLE_PREFIX.'domain.is_enabled=1 ';
		$domain     = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='ticket_ci_relation_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';	
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['domain_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
                $dates=$this->getdates(1,$database);
                $currentdated=$dates['current_date'];
                $to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					 $from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					 $from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from  = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to    = strtotime($data['to_date']) - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'auditlog.entry_date between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'ticket.domain_id=' . $data['domain_id'] .' and '.VIS_TABLE_PREFIX.'ticket.draft_id=0 and '.VIS_TABLE_PREFIX. 'itil_relation.attach_type=0 ';
				$filter .=' and '.VIS_TABLE_PREFIX.'auditlog.ticket_id = '.VIS_TABLE_PREFIX.'itil_relation.parent_id and ('.VIS_TABLE_PREFIX.'auditlog.operation_id =18 and '.VIS_TABLE_PREFIX.'auditlog.access_id = 0 )';
			}
			$filter .= ' and ' .VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and ' .VIS_TABLE_PREFIX.'ticket.is_spam!=1';
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object       = new class_report($database);
			$report = $object->get_ticket_ci_relation_report($filter,'', $staff_id, VIS_LOCATION_AREA);
			$total = ($report!=-1)?count($report):0;
			$report = $object->get_ticket_ci_relation_report($filter,$limit, $staff_id, VIS_LOCATION_AREA);
			if($report!=-1){
				$counts['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=$total;
				$totalCnt = ($report!=-1)?count($report):0;
				$report_count=$totalCnt;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']= count($view_details);
			}
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'report.php');
				$report_obj         = new report();
				$j      = 0;
				foreach ($report as $i) {
					foreach ($i as $key => $val) {
						if ($key == 'ticket_hash' || $key == 'subject'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'receive_date') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);  
						} elseif ($key == 'first_name' || $key == 'last_name' || $key == 'email' || $key == 'group_name' || $key == 'ci_name' || $key == 'ci_type'){
							$report_exp[$j][$key] = $val;
						}
						elseif($key == 'LNAME' || $key == 'usedby' || $key == 'description' || $key == 'stf_fname' || $key == 'stf_lname'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'assigned_on') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif($key == 'installation_date'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif($key == 'expiry_date'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif($key == 'last_audit_date'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif($key == 'impact_name' || $key == 'product_name' || $key == 'domain_name' || $key == 'ip_addr' || $key == 'mac_addr' || $key == 'subnet_mask' || $key == 'barcode' || $key == 'usefullife'  || $key == 'storage_loc' || $key == 'physical_loc' || $key == 'os' || $key == 'migrated_from' || $key == 'asset_dept' || $key == 'disposition_status'  || $key == 'risk'  || $key == 'lifecycle_status' || $key =='vendor_name' || $key == 'asset_state' || $key == 'depreciation_type' || $key == 'salvage'  || $key == 'warranty_year'  || $key == 'warranty_month'|| $key == 'asset_tag' || $key == 'licence_key' || $key == 'installation_path' || $key == 'clnt_fname' || $key == 'clnt_lname' || $key == 'staff_id') {
							$report_exp[$j][$key] = $val;	
						} elseif($key == 'details'){
							$text = $val;
							$new_val =  $report_obj->strip_html_tags($text);
							$report_exp[$j][$key] = $new_val;
						}	
					}

					if($report_exp[$j]['ci_name']==''){ $report_exp[$j]['ci_name'] = '-';}				
					$report_exp1[$j]['incident_hash']= $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['subject']= $report_exp[$j]['subject'];
					 $report_exp1[$j]['client_name']= $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email']= $report_exp[$j]['email'];
					$report_exp1[$j]['organization']= $report_exp[$j]['group_name'];
					$report_exp1[$j]['creation_date']= $report_exp[$j]['receive_date'];					
					$report_exp1[$j]['attach_ci']= $report_exp[$j]['ci_name'];
					/*
					$report_exp1[$j]['domain'] = $report_exp[$j]['domain_name'];
					$report_exp1[$j]['CI_Type'] = $report_exp[$j]['ci_type'];
					$report_exp1[$j]['impact'] = $report_exp[$j]['impact_name'];
					$report_exp1[$j]['Location'] = $report_exp[$j]['LNAME'];
					$report_exp1[$j]['risk'] = $report_exp[$j]['risk'];
					$report_exp1[$j]['lifecycle_status'] = $report_exp[$j]['lifecycle_status'];
					$report_exp1[$j]['disposition_status'] = $report_exp[$j]['disposition_status'];
					$report_exp1[$j]['asset_department'] = $report_exp[$j]['asset_dept'];
					$report_exp1[$j]['migrated_from'] = $report_exp[$j]['migrated_from'];
					$report_exp1[$j]['last_audit_date'] = $report_exp[$j]['last_audit_date'];
					$report_exp1[$j]['storage_location'] = $report_exp[$j]['storage_loc'];
					$report_exp1[$j]['physical_location'] = $report_exp[$j]['physical_loc'];
					$report_exp1[$j]['description'] = $report_exp[$j]['details'];
					if($report_exp[$j]['staff_id']===''){
						$report_exp1[$j]['managed_by'] = '---';
					} else{
						$report_exp1[$j]['managed_by'] = $report_exp[$j]['stf_fname'].' '.$report_exp[$j]['stf_lname'];
					}
					$report_exp1[$j]['used by'] = $report_exp[$j]['usedby'];
					// if(isset($report_exp[$j]['usedby'])){
					// 	$report_exp1[$j]['used by'] = $report_exp[$j]['usedby'];

					// } elseif($report_exp[$j]['clnt_fname']=='' || $report_exp[$j]['clnt_lname']==''){
					// 	$report_exp1[$j]['used by']	= $report_exp[$j]['fname'].' '.$report_exp[$j]['lname'];
					// } else {
					// 	$report_exp1[$j]['used by']	= $report_exp[$j]['clnt_fname'].' '.$report_exp[$j]['clnt_lname'];	
					// } 
					$report_exp1[$j]['Assigned_on'] = $report_exp[$j]['assigned_on'];
					$report_exp1[$j]['installation_date'] = $report_exp[$j]['installation_date'];
					$report_exp1[$j]['warranty_year'] = $report_exp[$j]['warranty_year'];
					$report_exp1[$j]['warranty_month'] = $report_exp[$j]['warranty_month'];
					$report_exp1[$j]['expiry_date'] = $report_exp[$j]['expiry_date'];
					// $report_exp1[$j]['License_expiry_date'] = $report_exp[$j]['expiry_date'];
					$report_exp1[$j]['cost'] = ($report_exp[$j]['ci_type_id'] == 3)? $report_exp[$j]['asset_tag']:$report_exp[$j]['installation_path'];
					$report_exp1[$j]['vendor'] = $report_exp[$j]['vendor_name'];
					$report_exp1[$j]['asset_state'] = $report_exp[$j]['asset_state'];
					$report_exp1[$j]['asset_tag'] = ($report_exp[$j]['ci_type_id'] != 3)? $report_exp[$j]['asset_tag']:'';
					$report_exp1[$j]['serial_no'] = ($report_exp[$j]['ci_type_id'] != 3)? $report_exp[$j]['licence_key']:'';//$report_exp[$j]['licence_key'];
					$report_exp1[$j]['acquisition_date'] = ($report_exp[$j]['ci_type_id'] == 2)? $report_exp[$j]['installation_date']:'';
					$report_exp1[$j]['depreciation_type'] = $report_exp[$j]['depreciation_type'];
					$report_exp1[$j]['salvage'] = $report_exp[$j]['salvage'];
					$report_exp1[$j]['usefullife'] = $report_exp[$j]['usefullife'];
					$report_exp1[$j]['product'] = $report_exp[$j]['product_name'];
					$report_exp1[$j]['barcode'] = $report_exp[$j]['barcode'];
					$report_exp1[$j]['ip_address'] = $report_exp[$j]['ip_addr'];
					$report_exp1[$j]['mac_address'] = $report_exp[$j]['mac_addr'];
					$report_exp1[$j]['subnet_mask'] = $report_exp[$j]['subnet_mask'];
					$report_exp1[$j]['operating system'] = $report_exp[$j]['os'];
					*/
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_subreport($operation,$report_exp1);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
			} else {
				$array_summary = array();
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function problem_ci_relation_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTPROBLEMCIRELATION'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		
		$report_type=90;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object      = new class_ticket($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		if(VIS_LOCATION_AREA==4){
			$filter     = VIS_TABLE_PREFIX.'domain.is_enabled=1 ';
			$domain     = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
		} else {
			$domains=$tkt_object->getstaff_domain_mapping('staff_id='.VIS_STAFF_ID,1);
			$domain=$domains['data'];
		}
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='problem_ci_relation_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInte