(function($)
{
	$R.add('plugin', 'vs', {
        translations: {
            en: {
                "vs": "Vs"
            }
        },
        init: function(app)
        {
            this.app = app;
            this.lang = app.lang;
            this.toolbar = app.toolbar;
			this.uuid=app.uuid;
			this.$toolbar=$('<div class="dropdown-menu m-l" id="subtoolbar_'+this.uuid+'" >');
			
			
        },
        start: function()
        {
			//$toolbar=$('<div class="dropdown-menu" id="subtoolbar_'+this.uuid+'" >');
			
            // create the button data
            var buttonData = {
                title: this.lang.get('vs'),
                icon: '<i class="vh vh vh-text-color"></i>',
                api: 'plugin.vs.toggle'
            };

            // create the button
            var $button = this.toolbar.addButtonAfter('html','vs', buttonData);
			
			$($button.nodes).attr({'data-toggle':'class:show','href':'#subtoolbar_'+this.uuid});
			$($button.nodes).parent('.redactor-toolbar').append(this.$toolbar);
			
			var icons = {
					'html': '<i class="vh vh-html"></i>',
					'format': '<i class="vh vh-paragraph"></i>',
					'bold': '<i class="vh vh-bold"></i>',
					'italic': '<i class="vh vh-italic"></i>',
					'deleted': '<i class="vh vh vh-strikethrough"></i>',
					'unorderedlist': '<i class="vh vh-unorderedlist"></i>',
					'orderedlist': '<i class="vh vh-orderedlist"></i>',
					'outdent': '<i class="vh vh-outdent"></i>',
					'indent': '<i class="vh vh-indent"></i>',
					'image': '<i class="vh vh-image"></i>',
					'link': '<i class="vh vh-link"></i>',
					'alignment': '<i class="vh vh-alignment"></i>',
					'horizontalrule': '<i class="vh vh-breakline"></i>',
					'lists': '<i class="vh vh-unordered-list"></i>',
					'undo':'<i class="vh vh-undo"></i>', 
					'redo':'<i class="vh vh-redo"></i>',
					'sup':'<i class="vh vh-superscript"></i>', 
					'sub':'<i class="vh vh-subscript"></i>'
                };
 
                $.each(this.toolbar.getButtons(), $.proxy(function(i,s)
                {
					
                    var key = $(s).attr('rel');
                    if (typeof icons[s.name] !== 'undefined')
                    {
                        var icon = icons[s.name];
                        var button = this.toolbar.getButton(s.name);
                        button.setIcon(icon);
					}
 
                }, this));
			this.load();
		},
		toggle: function()
		{
			
			
		},
		load: function()
		{
			var iconsall = {
					'html': '<i class="vh vh-html"></i>',
					'format': '<i class="vh vh-paragraph"></i>',
					'bold': '<i class="vh vh-bold"></i>',
					'italic': '<i class="vh vh-italic"></i>',
					'deleted': '<i class="vh vh vh-strikethrough"></i>',
					'unorderedlist': '<i class="vh vh-unorderedlist"></i>',
					'orderedlist': '<i class="vh vh-orderedlist"></i>',
					'outdent': '<i class="vh vh-outdent"></i>',
					'indent': '<i class="vh vh-indent"></i>',
					'image': '<i class="vh vh-image"></i>',
					'link': '<i class="vh vh-link"></i>',
					'alignment': '<i class="vh vh-alignment"></i>',
					'horizontalrule': '<i class="vh vh-breakline"></i>',
					'lists': '<i class="vh vh-unordered-list"></i>',
					'undo':'<i class="vh vh-undo"></i>', 
					'redo':'<i class="vh vh-redo"></i>',
					'sup':'<i class="vh vh-superscript"></i>', 
					'sub':'<i class="vh vh-subscript"></i>'
                };
		
					this.toolbarsButtons = this.toolbar.getButtons();
			
					var buttons1 = ['format', 'bold', 'italic', 'deleted', 'lists'];
					$.each(buttons1, $.proxy(function(i, btnName)
					{ 
						/*if (!this.toolbarsButtons[btnName] || (btnName === 'file') || (btnName === 'image'))
						{
							return;
						}*/
						$button=this.toolbar.addButton(btnName, $R.buttons[btnName], false, false, true);
						//var button = this.toolbar.getButton(s.name);
                        $button.setIcon(iconsall[btnName]);
						this.$toolbar.append($button.nodes);
					}, this));
			
		}
    });
	
	$R.add('plugin', 'attach', {
        translations: {
            en: {
                "attach": "Attach file"
            }
        },
        init: function(app)
        {
            this.app = app;
            this.lang = app.lang;
            this.toolbar = app.toolbar;
			intupload();
        },
        start: function()
        {
            // create the button data
            var buttonData = {
                title: this.lang.get('vs'),
                icon: '<i class="vh vh-attachment"></i>',
                api: 'plugin.attach.showupload'
            };

            // create the button
            var $button = this.toolbar.addButton('attach', buttonData);
		},
		showupload: function()
		{
var visnode=this.app.element.rootElement.getAttribute('data-attach');
            if(visnode===undefined || visnode=='' || visnode==null){
			 $('.filestyle:not(.assetfileupload)').trigger('click');
            }else{
             $('#'+visnode).trigger('click');
            }
			 //$('.filestyle:not(.assetfileupload)').trigger('click');
		}
    });
	
	$R.add('plugin', 'drive', {
        translations: {
            en: {
                "drive": "Drive"
            }
        },
        init: function(app)
        {
            this.app = app;
            this.lang = app.lang;
            this.toolbar = app.toolbar;
        },
        start: function()
        {
            // create the button data
            var buttonData = {
                title: this.lang.get('drive'),
                icon: '<i class="vh vh-my-drive"></i>',
                api: 'plugin.drive.toggle'
            };

            // create the button
            var $button = this.toolbar.addButton('drive', buttonData);
		},
		toggle: function()
		{
			var vis_editorid=this.app.element.rootElement.id;
    		$('.re-drive').attr('data-toggle','ajaxModal');
			$('.re-drive').attr('data-modal-arguments','vis_module=ticket&vis_operation=drive_search&vis_action='+vis_editorid+'&vis_tab=1');
		}
    });
	
    $R.add('plugin', 'fullscreen', {
        translations: {
            en: {
    			"fullscreen": "Fullscreen"
    		}
        },
        init: function(app)
        {
            this.app = app;
            this.opts = app.opts;
            this.lang = app.lang;
            this.$win = app.$win;
            this.$doc = app.$doc;
            this.$body = app.$body;
            this.editor = app.editor;
            this.toolbar = app.toolbar;
            this.container = app.container;
            this.selection = app.selection;

            // local
            this.isOpen = false;
        },
        // public
        start: function()
        {
            var data = {
                title: this.lang.get('fullscreen'),
                api: 'plugin.fullscreen.toggle'
            };

            var button = this.toolbar.addButton('fullscreen', data);
            button.setIcon('<i class="vh vh-full-screen"></i>');

            this.isTarget = (this.opts.toolbarFixedTarget !== document);
            this.$target = (this.isTarget) ? $R.dom(this.opts.toolbarFixedTarget) : this.$body;

			if (this.opts.fullscreen) this.toggle();

        },
        toggle: function()
		{
			return (this.isOpen) ? this.close() : this.open();
		},
		open: function()
		{
            this._createPlacemarker();
            this.selection.save();

            var $container = this.container.getElement();
            var $editor = this.editor.getElement();
            var $html = (this.isTarget) ? $R.dom('body, html') : this.$target;

            if (this.opts.toolbarExternal) this._buildInternalToolbar();

            this.$target.prepend($container);
			this.$target.addClass('redactor-body-fullscreen');

            $container.addClass('redactor-box-fullscreen');
            if (this.isTarget) $container.addClass('redactor-box-fullscreen-target');

            $html.css('overflow', 'hidden');

            if (this.opts.maxHeight) $editor.css('max-height', '');
            if (this.opts.minHeight) $editor.css('min-height', '');

            this._resize();
            this.$win.on('resize.redactor-plugin-fullscreen', this._resize.bind(this));
			this.$doc.scrollTop(0);

            var button = this.toolbar.getButton('fullscreen');
            button.setIcon('<i class="vh vh-normal-screen"></i>');

            this.selection.restore();
			this.isOpen = true;
			this.opts.zindex = 1051;
		},
		close: function()
		{
    		this.isOpen = false;
			this.opts.zindex = false;
            this.selection.save();

            var $container = this.container.getElement();
            var $editor = this.editor.getElement();
            var $html = $R.dom('body, html');

            if (this.opts.toolbarExternal) this._buildExternalToolbar();

            this.$target.removeClass('redactor-body-fullscreen');
    		this.$win.off('resize.redactor-plugin-fullscreen');
            $html.css('overflow', '');

			$container.removeClass('redactor-box-fullscreen redactor-box-fullscreen-target');
			$editor.css('height', 'auto');

			if (this.opts.minHeight) $editor.css('minHeight', this.opts.minHeight);
			if (this.opts.maxHeight) $editor.css('maxHeight', this.opts.maxHeight);

            var button = this.toolbar.getButton('fullscreen');
            button.setIcon('<i class="vh vh-full-screen"></i>');

    		this._removePlacemarker($container);
            this.selection.restore();

		},

		// private
		_resize: function()
		{
            var $editor = this.editor.getElement();
    		var height = this.$win.height();

    		$editor.height(height);
		},
		_buildInternalToolbar: function()
		{
			var $wrapper = this.toolbar.getWrapper();
			var $toolbar = this.toolbar.getElement();

			$wrapper.addClass('redactor-toolbar-wrapper');
			$wrapper.append($toolbar);

			$toolbar.removeClass('redactor-toolbar-external');
			$container.prepend($wrapper);
		},
		_buildExternalToolbar: function()
		{
			var $wrapper = this.toolbar.getWrapper();
			var $toolbar = this.toolbar.getElement();

            this.$external = $R.dom(this.opts.toolbarExternal);

            $toolbar.addClass('redactor-toolbar-external');
            this.$external.append($toolbar);

            $wrapper.remove();
		},
		_createPlacemarker: function()
		{
    		var $container = this.container.getElement();

    		this.$placemarker = $R.dom('<span />');
    		$container.after(this.$placemarker);
		},
		_removePlacemarker: function($container)
		{
    		this.$placemarker.before($container);
            this.$placemarker.remove();
		}
    });
	
	$R.add('plugin', 'fontcolor', {
        translations: {
            en: {
                "fontcolor": "Text Color",
                "text": "Text",
                "highlight": "Highlight"
            }
        },
        init: function(app)
        {
            this.app = app;
            this.opts = app.opts;
            this.lang = app.lang;
            this.inline = app.inline;
            this.toolbar = app.toolbar;
            this.selection = app.selection;
			this.uuid=app.uuid;
			
            // local
    		this.colors = (this.opts.fontcolors) ? this.opts.fontcolors : [
    			'#ffffff', '#000000', '#eeece1', '#1f497d', '#4f81bd', '#c0504d', '#9bbb59', '#8064a2', '#4bacc6', '#f79646', '#ffff00',
    			'#f2f2f2', '#7f7f7f', '#ddd9c3', '#c6d9f0', '#dbe5f1', '#f2dcdb', '#ebf1dd', '#e5e0ec', '#dbeef3', '#fdeada', '#fff2ca',
    			'#d8d8d8', '#595959', '#c4bd97', '#8db3e2', '#b8cce4', '#e5b9b7', '#d7e3bc', '#ccc1d9', '#b7dde8', '#fbd5b5', '#ffe694',
    			'#bfbfbf', '#3f3f3f', '#938953', '#548dd4', '#95b3d7', '#d99694', '#c3d69b', '#b2a2c7', '#b7dde8', '#fac08f', '#f2c314',
    			'#a5a5a5', '#262626', '#494429', '#17365d', '#366092', '#953734', '#76923c', '#5f497a', '#92cddc', '#e36c09', '#c09100',
    			'#7f7f7f', '#0c0c0c', '#1d1b10', '#0f243e', '#244061', '#632423', '#4f6128', '#3f3151', '#31859b',  '#974806', '#7f6000'
    		];
        },
        // messages
        onfontcolor: {
            set: function(rule, value)
            {
                this._set(rule, value);
            },
            remove: function(rule)
            {
                this._remove(rule);
            }
        },

        // public
        start: function()
        {
            var btnObj = {
                title: this.lang.get('fontcolor')
            };

            var $dropdown = this._buildDropdown();

            this.$button = this.toolbar.addButton('fontcolor', btnObj);
			this.$button.setIcon('<i class="vh vh-text-bg-color"></i>');
			this.$button.setDropdown($dropdown);
			$('#subtoolbar_'+this.uuid).append(this.$button.nodes);
				
        },

        // private
        _buildDropdown: function()
        {
            var $dropdown = $R.dom('<div class="redactor-dropdown-cells">');

            this.$selector = this._buildSelector();
            this.$selectorText = this._buildSelectorItem('text', this.translations.en['text']);
            this.$selectorText.addClass('active');

            this.$selectorBack = this._buildSelectorItem('back', this.translations.en['highlight']);

            this.$selector.append(this.$selectorText);
            this.$selector.append(this.$selectorBack);

            this.$pickerText = this._buildPicker('textcolor');
            this.$pickerBack = this._buildPicker('backcolor');

            $dropdown.append(this.$selector);
            $dropdown.append(this.$pickerText);
            $dropdown.append(this.$pickerBack);

            this._buildSelectorEvents();

            $dropdown.width(242);
$dropdown.css('top', '106px');
            return $dropdown;
        },
        _buildSelector: function()
        {
            var $selector = $R.dom('<div>');
            $selector.addClass('redactor-dropdown-selector');

			return $selector;
        },
        _buildSelectorItem: function(name, title)
        {
            var $item = $R.dom('<span>');
            $item.attr('rel', name).html(title);
            $item.addClass('redactor-dropdown-not-close');

            return $item;
        },
        _buildSelectorEvents: function()
        {
			this.$selectorText.on('mousedown', function(e)
			{
				e.preventDefault();

                this.$selector.find('span').removeClass('active');
				this.$pickerBack.hide();
				this.$pickerText.show();
				this.$selectorText.addClass('active');

			}.bind(this));

			this.$selectorBack.on('mousedown', function(e)
			{
				e.preventDefault();

                this.$selector.find('span').removeClass('active');
				this.$pickerText.hide();
				this.$pickerBack.show();
				this.$selectorBack.addClass('active');

			}.bind(this));
        },
        _buildPicker: function(name)
		{
			
			var $box = $R.dom('<div class="re-dropdown-box-' + name + '">');
			var rule = (name == 'backcolor') ? 'background-color' : 'color';
			
			var len = this.colors.length;
			var self = this;
			var func = function(e)
			{
				e.preventDefault();

				var $el = $R.dom(e.target);
				self._set($el.data('rule'), $el.attr('rel'));
			};

			for (var z = 0; z < len; z++)
			{
				var color = this.colors[z];

				var $swatch = $R.dom('<span>');
				$swatch.attr({ 'rel': color, 'data-rule': rule });
				$swatch.css({ 'background-color': color, 'font-size': 0, 'border': '2px solid #fff', 'width': '22px', 'height': '22px' });
				$swatch.on('mousedown', func);

				$box.append($swatch);
			}

			var $el = $R.dom('<a>');
			$el.attr({ 'href': '#' });
			$el.css({ 'display': 'block', 'clear': 'both', 'padding': '8px 5px', 'font-size': '12px', 'line-height': 1 });
			$el.html(this.lang.get('none'));

			$el.on('click', function(e)
			{ 
				e.preventDefault();
				self._remove(rule);
			});

			$box.append($el);

			if (name == 'backcolor') $box.hide();

            return $box;
		},
		_set: function(rule, value)
		{
    		var style = {};
    		style[rule] = value;

    		var args = {
        	    tag: 'span',
        	    style: style,
        	    type: 'toggle'
    		};

			this.inline.format(args);
		},
		_remove: function(rule)
		{
			this.inline.remove({ style: rule });
		}
    });
	
	$R.add('plugin', 'fontfamily', {
        translations: {
            en: {
                "fontfamily": "Font",
                "remove-font-family":  "Remove Font Family"
            }
        },
        init: function(app)
        {
            this.app = app;
            this.lang = app.lang;
            this.inline = app.inline;
            this.toolbar = app.toolbar;
			this.uuid=app.uuid;
            // local
    		this.fonts = ['Arial', 'Helvetica', 'Georgia', 'Times New Roman', 'Monospace'];
        },
        // public
        start: function()
        {
            var dropdown = {};
			for (var i = 0; i < this.fonts.length; i++)
			{
    			var font = this.fonts[i];
				dropdown[i] = {
    				title: font,
    				api: 'plugin.fontfamily.set',
    				args: font
                };
			}

			dropdown.remove = {
    			title: this.lang.get('remove-font-family'),
    			api: 'plugin.fontfamily.remove'
            };

            var $button = this.toolbar.addButton('fontfamily', { title: this.lang.get('fontfamily') });
            $button.setIcon('<i class="vh vh-font"></i>');
			$button.setDropdown(dropdown);
			$('#subtoolbar_'+this.uuid).append($button.nodes);
        },
        set: function(value)
		{
    		var args = {
        	    tag: 'span',
        	    style: { 'font-family': value },
        	    type: 'toggle'
    		};

			this.inline.format(args);
		},
		remove: function()
		{
			this.inline.remove({ style: 'font-family' });
		}
    });
})(jQuery);	
//})(Redactor);

function callEidtor(id,driveset,parma1,param2,dire){
	var plgarr=['vs']; if(driveset==1)plgarr.push('drive');
	plgarr.push('fontcolor');
	plgarr.push('fontfamily');	
	if(parma1!='profile'){
	plgarr.push('attach');
	}
	plgarr.push('fullscreen');
	
	var btnarr=['html'];
	btnarr.push('link');
	btnarr.push('undo');
	btnarr.push('redo');
	if(param2==undefined || param2=='' || param2==0){
		btnarr.push('image');
	}

	$(function(){
		$R('#'+id, { 
		minHeight: '180px', 
      maxHeight: '180px',
		focus: false,
		imageUpload: "index.php?vis_tmpst=" + new Date().getTime() + "&vis_module=ticket&vis_operation=upload_file&vis_static_area=editor_image_upload&uploadtype=1&uploadmodule="+parma1,
		/*fileUpload:  "index.php?vis_tmpst="+new Date().getTime()+"&vis_module=ticket&vis_operation=upload_file&vis_static_area=editor_file_upload&uploadtype=2&uploadmodule="+parma1, */
        fileUpload:false,
		imageUploadParam: 'files',
		linkSize: 1500,
		buttons: btnarr,
        direction: dire,
		callbacks:{
				keydown: function(e){
						//if(e.keyCode==13)this.keydown.insertParagraph(e);
					}, 
				image: {
					uploadError: function(json)
					{	
					try {
						 if(json.location!="1"){
						$("#vis_global_msg_div").show();
						 document.getElementById("vis_global_msg_div").innerHTML = json.message;
						 setTimeout( function(){ $("#vis_global_msg_div").hide().html(''); }, 10000);
						 }else if(json.location=="1"){
						this.module.modal.app.api('module.modal.close');	 
						$("#vis_submit_err_div").show(); 	 
						$("#vis_submit_err_div").html(json.message); window.scrollTo(0,0);
						setTimeout(function(){$("#vis_submit_err_div").hide();},10000); 
						 }
						 } catch(e){
							 alert(json.message);
						 }
					}
				},
				keyup:function(e){
					var button_vs = this.toolbar.getButton('vs');
					$(button_vs.nodes[0].hash).hide('slow').removeClass('show');
					$(button_vs.nodes[0]).removeClass('active');
				},
				focus: function(e){
					if(parma1=='reply'){
        		 	$('#emailtextdiv').show('slow');
				 	$('#sender').removeClass('in');
					}
					var button_vs = this.toolbar.getButton('vs');
					$(button_vs.nodes[0].hash).hide('slow').removeClass('show');
					$(button_vs.nodes[0]).removeClass('active');
				},
				pasted: function(html)
				{
				    //return html;
				    var templaturl = $("#templaturl").val();
					if(templaturl!=""){
						$('p').find("a").each(function()
						{
							var findtextfromeditor= $(this).text();
							if(findtextfromeditor=="{link}"){
								var hrflnval2 = templaturl+findtextfromeditor;
								$('a[href^="'+hrflnval2+'"]').attr('href',findtextfromeditor);
							}
							if(findtextfromeditor=="{resetlink}"){
								var hrflnval2 = templaturl+findtextfromeditor;
								$('a[href^="'+hrflnval2+'"]').attr('href',findtextfromeditor);
							}
							if(findtextfromeditor=="{login_url}"){
								var hrflnval2 = templaturl+findtextfromeditor;
								$('a[href^="'+hrflnval2+'"]').attr('href',findtextfromeditor);
							}
							if(findtextfromeditor=="{manage_portal_link}"){
								var hrflnval2 = templaturl+findtextfromeditor;
								$('a[href^="'+hrflnval2+'"]').attr('href',findtextfromeditor);
							}
							if(findtextfromeditor=="{verification_link}"){
								var hrflnval2 = templaturl+findtextfromeditor;
								$('a[href^="'+hrflnval2+'"]').attr('href',findtextfromeditor);
							}
							if(findtextfromeditor=="{changes_details_link}"){
								var hrflnval2 = templaturl+findtextfromeditor;
								$('a[href^="'+hrflnval2+'"]').attr('href',findtextfromeditor);
							}
							if(findtextfromeditor=="{contract_approval_link}"){
								var hrflnval2 = templaturl+findtextfromeditor;
								$('a[href^="'+hrflnval2+'"]').attr('href',findtextfromeditor);
							}
							if(findtextfromeditor=="{releases_approval_link}"){
								var hrflnval2 = templaturl+findtextfromeditor;
								$('a[href^="'+hrflnval2+'"]').attr('href',findtextfromeditor);
							}
							if(findtextfromeditor=="{contract_link}"){
								var hrflnval2 = templaturl+findtextfromeditor;
								$('a[href^="'+hrflnval2+'"]').attr('href',findtextfromeditor);
							}
							if(findtextfromeditor=="{download_report_link}"){
								var hrflnval2 = templaturl+findtextfromeditor;
								$('a[href^="'+hrflnval2+'"]').attr('href',findtextfromeditor);
							}
							if(findtextfromeditor=="{ticket_approval_link}"){
								var hrflnval2 = templaturl+findtextfromeditor;
								$('a[href^="'+hrflnval2+'"]').attr('href',findtextfromeditor);
							}
				
						}); 
					}
				}
			},
		  plugins: plgarr 
		});
	});
}
