<?php

/*
 * tnef_mailinfo.php
 *
 *  Bernd Wiegmann <bernd@wib-software.de>
 *  (c) 2003 (GNU GPL - see ../../COPYING)
 *
 */

/*
 *   $Header: /storage/repository/attachment_tnef/tnef_mailinfo.php,v 1.4 2003/09/19 15:51:27 bernd Exp $
 *
 *   $Log: tnef_mailinfo.php,v $
 *   Revision 1.4  2003/09/19 15:51:27  bernd
 *   First working version of the compressed RTF decoder.
 *
 *   Revision 1.3  2003/09/11 11:36:45  bernd
 *   Preparations for beta release.
 *
 *
 *   Revision 1.1  2003/07/31 15:24:25  bernd
 *   Complete rework of tnef decoder
 *
 *
 */

include_once(VIS_PATH_PLUGINS.'attachment_tnef/tnef_date.php');

class TnefMailinfo {

  var $subject;
  var $topic;
  var $from;
  var $from_name;
  var $date_sent;

  function __construct() {
  }

  function getTopic() {
    return $this->topic;
  }

  function getSubject() {
    return $this->subject;
  }

  function getFrom() {
    return $this->from;
  }

  function getFromName() {
    return $this->from_name;
  }

  function getDateSent() {
    return $this->date_sent;
  }

  function receiveTnefAttribute($attribute, $value, $length) {
    switch($attribute) {
    case TNEF_ASUBJECT:
      $this->subject = substr($value, 0, $length - 1);
      break;

    case TNEF_ADATERECEIVED:
      if (!$this->date_sent) {
	$this->date_sent = new TnefDate;
	$this->date_sent->setTnefBuffer($value);
      }

    case TNEF_ADATESENT:
      $this->date_sent = new TnefDate;
      $this->date_sent->setTnefBuffer($value);
    }
  }

  function receiveMapiAttribute($attr_type, $attr_name, $value, $length) {
    switch($attr_name) {
    case TNEF_MAPI_CONVERSATION_TOPIC:
      $this->topic = $value;
      break;

    case TNEF_MAPI_SENT_REP_EMAIL_ADDR:
      $this->from = $value;
      break;

    case TNEF_MAPI_SENT_REP_NAME:
      $this->from_name = $value;
      break;
    }
  }

}

?>