<?php
	const AUTHORITY_URL = 'https://login.microsoftonline.com/';
	const AUTHORIZE_ENDPOINT = '/oauth2/v2.0/authorize';
	const TOKEN_ENDPOINT = '/oauth2/v2.0/token';
	const RESOURCE_ID = 'https://graph.microsoft.com';
	const SENDMAIL_ENDPOINT = '/v1.0/me/sendmail';
	const CONTACTS_ENDPOINT = '/v1.0/me/contacts?$top=1000'; //?$select=EmailAddresses,GivenName,Surname,jobTitle,companyName,manager,department,homeAddress,businessAddress,mobilePhone,businessPhones,homePhones
	const CREATE_CONTACTS_ENDPOINT = '/v1.0/me/contacts';
	const PEOPLE_ENDPOINT = '/beta/me/people?$top=1000';
	const CALENDER_ENDPOINT = '/v1.0/me/calendar';
	const CALENDERGROUP_ENDPOINT = '/v1.0/me/calendargroups';
	const CALENDER_EVENT_ENDPOINT ='/beta/me/events';
	const SCOPES='openid offline_access profile user.read mail.send Contacts.Read people.read Calendars.Read';
	const SENDMAIL_DRAFT = '/v1.0/me/messages';
    const SENDMAIL_CREATEUPLOADSESSION = '/attachments/createUploadSession';

    class class_outlook{

    	function GenerateOauthUrl($client_id,$redirect_uri,$tenantid,$login_hint,$state='OT1rOIgyaQBY819i1OAhb6Nz2JjLuzxF',$scope=SCOPES){
			$tenantid = ($tenantid!='')?$tenantid:'common';
    		return $auth_url = AUTHORITY_URL.$tenantid.AUTHORIZE_ENDPOINT.'?state='.$state.'&scope='.urlencode($scope).'&response_type=code&approval_prompt=auto&client_id='.$client_id.'&redirect_uri='.urlencode($redirect_uri).'&login_hint='.$login_hint;  
    	}

    	function GetRefreshedAccessToken($client_id, $refresh_token, $client_secret,$redirect_uri,$tenantid) {  
		    $tenantid = ($tenantid!='')?$tenantid:'common';
    	    $url_token =  'https://login.microsoftonline.com/'.$tenantid.'/oauth2/v2.0/token'; 	     
    	    $curlPost = 'client_id=' . $client_id . '&client_secret=' . $client_secret.'&redirect_uri='.urlencode("$redirect_uri").'&refresh_token='.$refresh_token.'&grant_type=refresh_token&scope= openid offline_access profile user.read mail.send Contacts.Read people.read Calendars.Read ';
    		$headers = array(
    			'content-type' => 'application/x-www-form-urlencoded',
    			'content-length' => strlen($curlPost)
    		);

    	    $ch = curl_init();      
    	    curl_setopt($ch, CURLOPT_URL, $url_token);      
    	    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);        
    	    curl_setopt($ch, CURLOPT_POST, 1);      
    	    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
    	    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    	    curl_setopt($ch, CURLOPT_POSTFIELDS, $curlPost);    
    	    $data = json_decode(curl_exec($ch), true);
    	    $http_code = curl_getinfo($ch,CURLINFO_HTTP_CODE);      
    	    if($http_code != 200){ 
    	        //throw new Exception('Error : Failed to refresh access token');
    	        $info = curl_getinfo($ch);
    	        $info_log = json_encode($info);	        
    	    }
    	    //print_r($info_log);
    	    return $data;
    	}
     
    	function GetAccessToken($client_id, $refresh_token, $client_secret,$redirect_url,$tenantid) {  
			$tenantid = ($tenantid!='')?$tenantid:'common';
    	    $url_token =  'https://login.microsoftonline.com/'.$tenantid.'/oauth2/v2.0/token'; 	
    	 	$curlPost = 'client_id=' . $client_id . '&client_secret=' . $client_secret.'&redirect_uri='.urlencode("$redirect_url").'&grant_type=authorization_code&code='.$_REQUEST['code'];
    		$headers = array(
    			'content-type' => 'application/x-www-form-urlencoded',
    			'content-length' => strlen($curlPost)
    		);

    	    $ch = curl_init();      
    	    curl_setopt($ch, CURLOPT_URL, $url_token);      
    	    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);        
    	    curl_setopt($ch, CURLOPT_POST, 1);      
    	    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);  
    	    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    	    curl_setopt($ch, CURLOPT_POSTFIELDS, $curlPost);    
    	    $data = json_decode(curl_exec($ch), true);  //print_r($data);
    	    $http_code = curl_getinfo($ch,CURLINFO_HTTP_CODE);      
    	    if($http_code != 200){ 
    	        //throw new Exception('Error : Failed to refresh access token');
    	        $info = curl_getinfo($ch);
    	        $info_log = json_encode($info);	        
    	    }
    	    // print_r( $info_log);
    	    return $data;
    	}

    	function sendOutlookMailWithToken($subject='',$recipient, $accessToken,$emailBody='',$cc_recipient='',$bcc_recipient='',$replyto_recipient='',$attachments=array(), $givenName='', $preferredUsername=''){

            if(trim($recipient)!=''){  $recipient_arr = explode(',', $recipient); }
            if(trim($cc_recipient)!=''){  $cc_recipient_arr = explode(',', $cc_recipient); }
            if(trim($bcc_recipient)!=''){ $bcc_recipient_arr = explode(',', $bcc_recipient); }
            if(trim($replyto_recipient)!=''){ $replyto_recipient = (trim(strstr($replyto_recipient,'<')))?trim(str_replace(array('<','>'), '', trim(strstr($replyto_recipient,'<')))):$replyto_recipient; }

            $greetingName = isset($givenName)
                            ? $givenName
                            : explode('@',$preferredUsername)[0];

            $emailBody = str_replace(
                '{given_name}',
                $greetingName,
                $emailBody
            );
            $email = "{
                'Message': {
                    'Subject': '{$subject}',
                    'Body': {
                                'ContentType': 'HTML',
                                'Content': '".addslashes($emailBody)."'
                            }
                    ";

                if($recipient!='' && count($recipient_arr)>0){
                    $email .= ",
                    'ToRecipients': [ ";
                                for($r=0;$r<count($recipient_arr);$r++){
                                    $email .= "     {
                                            'EmailAddress': {'Address': '".trim($recipient_arr[$r])."'}
                                        } ";
                                        if($r<(count($recipient_arr)-1)){ $email .= ", ";  }
                                }                               
                            $email .= "  ]";
                } 
                if($cc_recipient!='' && count($cc_recipient_arr)>0){
                    $email .= ",
                    'CcRecipients': [ ";
                                for($c=0;$c<count($cc_recipient_arr);$c++){
                                    $email .= "     {
                                            'EmailAddress': {'Address': '".trim($cc_recipient_arr[$c])."'}
                                        } ";
                                        if($c<(count($cc_recipient_arr)-1)){ $email .= ", ";  }
                                }                               
                            $email .= "  ]";
                }
                if($bcc_recipient!=''  && count($bcc_recipient_arr)>0){
                    $email .= ",
                    'BccRecipients': [ ";
                                        for($bc=0;$bc<count($bcc_recipient_arr);$bc++){
                                    $email .= "     {
                                            'EmailAddress': {'Address': '".trim($bcc_recipient_arr[$bc])."'}
                                        } ";
                                    if($bc<(count($bcc_recipient_arr)-1)){ $email .= ", ";  }
                                }    
                              $email .= "  ]";
                }
                if($replyto_recipient!=''){
                   $email .= ",
                   'ReplyTo':   [
                                    {
                                        'EmailAddress': {'Address': '{$replyto_recipient}'}
                                    }
                                ]";
                }
                if(is_array($attachments) && count($attachments)>0){
                            $email .= ",
                                'Attachments': [ ";
                                for($att=0;$att<count($attachments);$att++){
                                    $email .= "
                                            {
                                                '@odata.type': '#Microsoft.graph.FileAttachment',
                                                'Name': '".$attachments[$att]['Name']."',
                                                'ContentBytes': '".$attachments[$att]['ContentBytes']."'
                                            },";                                      
                                }
                                          
                                $email .=    " ] ";
                                        
                }       
                $email .=    " },";
                $email .= "'SaveToSentItems': true
                },";
                //echo '=='.$accessToken.'+++'.$email;
               	// echo $email; die;
    			// Send the email request to the sendmail endpoint,
    			// which is in the following URI:
    			// https://graph.microsoft.com/v1.0/me/sendmail
    			// Note that the access token is attached in the Authorization header
            	return $this->sendPostRequest(RESOURCE_ID.SENDMAIL_ENDPOINT,array("User-Agent: php-tutorial/1.0",'Authorization: Bearer '.$accessToken,'Content-Type: application/json;'.'odata.metadata=minimal;'.'odata.streaming=true'),$email);
        }

    	function sendPostRequest($endpoint, $headers, $body){   
            $err ='';
            $curl = curl_init();
            json_encode($body);        
            curl_setopt_array(
                $curl,
                array(
                    CURLOPT_RETURNTRANSFER => 1,
                    CURLOPT_URL => $endpoint,
                    CURLOPT_POST => true,
                    CURLOPT_HTTPHEADER => $headers,
                    CURLOPT_POSTFIELDS => $body,
                    CURLOPT_SSL_VERIFYPEER=>FALSE,
                    CURLOPT_HEADER=>0,
                    CURLOPT_FAILONERROR => false
                )
            );  /*  Fixed errot "[error setting certificate verify locations:
      CAfile: /etc/pki/tls/certs/ca-bundle.crt
      CApath: none-0] 
        useing
            CURLOPT_SSL_VERIFYPEER=>FALSE,
            CURLOPT_HEADER=>0,
      */  
            // The following curl options can be used in development to debug the code.
            // Option to disable certificate verification. Do not use on production env.
            // curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
            // Option to set a proxy for curl to use.
            // Useful if you want to review traffic with a tool like Fiddler.
            // curl_setopt($curl, CURLOPT_PROXY, '127.0.0.1:8888');        
            // Send the request & save response to a variable
            $response = curl_exec($curl);
            $info = curl_getinfo($curl);
            //print_r($info);
            // Check for errors
            if (curl_errno($curl)) {
                //throw new \RuntimeException(curl_error($curl));
               $err = curl_error($curl);
            }
            //$message = $info['http_code'];
            // Check for errors
            if ($info['http_code'] >= 400) {
                $response = json_decode($response, true);                      
            }
            $re = (isset($response['error']))?": ".json_encode($response['error'],true):'';
            $message = $info['http_code'].$re;        
            // Close request and clear some resources
            curl_close($curl);        
            return array("response"=>$response,"error"=>$err,"message"=>$message,"curl_info"=>$info);
        }
        function sendPutRequest($endpoint, $headers, $body){   
            $err ='';
            $curl = curl_init();
            json_encode($body);        
            curl_setopt_array(
                $curl,
                array(
                    CURLOPT_RETURNTRANSFER => 1,
                    CURLOPT_URL => $endpoint,
                    CURLOPT_CUSTOMREQUEST => "PUT",
                    CURLOPT_HTTPHEADER => $headers,
                    CURLOPT_POSTFIELDS => $body,
                    CURLOPT_SSL_VERIFYPEER=>FALSE,
                    CURLOPT_HEADER=>0,
                    CURLOPT_FAILONERROR => false
                )
            );  
            $response = curl_exec($curl);
            $info = curl_getinfo($curl);
            //print_r($info);
            // Check for errors
            if (curl_errno($curl)) {
                //throw new \RuntimeException(curl_error($curl));
               $err = curl_error($curl);
            }
            //$message = $info['http_code'];
            // Check for errors
            if ($info['http_code'] >= 400) {
                $response = json_decode($response, true);                      
            }
            $re = (isset($response['error']))?": ".json_encode($response['error'],true):'';
            $message = $info['http_code'].$re;        
            // Close request and clear some resources
            curl_close($curl);        
            return array("response"=>$response,"error"=>$err,"message"=>$message,"curl_info"=>$info);
        }
        
    function GetRefreshedAccessToken_msteam($client_id, $refresh_token, $client_secret,$redirect_uri,$tenantid) {  
        $tenantid = ($tenantid!='')?$tenantid:'common';
        $url_token =  'https://login.microsoftonline.com/'.$tenantid.'/oauth2/v2.0/token';
		$curlPost = 'client_id=' . $client_id . '&client_secret=' . $client_secret.'&redirect_uri='.urlencode("$redirect_uri").'&refresh_token='.$refresh_token.'&grant_type=refresh_token&scope=openid offline_access profile user.read';
		$headers = array(
			'content-type' => 'application/x-www-form-urlencoded',
			'content-length' => strlen($curlPost)
		);

		$ch = curl_init();      
		curl_setopt($ch, CURLOPT_URL, $url_token);      
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);        
		curl_setopt($ch, CURLOPT_POST, 1);      
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $curlPost);    
		$data = json_decode(curl_exec($ch), true);
		$http_code = curl_getinfo($ch,CURLINFO_HTTP_CODE);      
		if($http_code != 200){ 
			//throw new Exception('Error : Failed to refresh access token');
			$info = curl_getinfo($ch);
			$info_log = json_encode($info);	        
		}
		//print_r($info_log);
		return $data;
	}    
    
	//custom

    function sendOutlookDraftMailWithToken($subject='',$recipient, $accessToken,$emailBody='',$cc_recipient='',$bcc_recipient='',$replyto_recipient='',$attachments=array(), $givenName='', $preferredUsername=''){

            if(trim($recipient)!=''){  $recipient_arr = explode(',', $recipient); }
            if(trim($cc_recipient)!=''){  $cc_recipient_arr = explode(',', $cc_recipient); }
            if(trim($bcc_recipient)!=''){ $bcc_recipient_arr = explode(',', $bcc_recipient); }
            if(trim($replyto_recipient)!=''){ $replyto_recipient = (trim(strstr($replyto_recipient,'<')))?trim(str_replace(array('<','>'), '', trim(strstr($replyto_recipient,'<')))):$replyto_recipient; }

            $greetingName = isset($givenName)
                            ? $givenName
                            : explode('@',$preferredUsername)[0];

            $emailBody = str_replace(
                '{given_name}',
                $greetingName,
                $emailBody
            );
            $email = "{
                    'Subject': '{$subject}',
                    'Body': {
                                'ContentType': 'HTML',
                                'Content': '".addslashes($emailBody)."'
                            }";

                if($recipient!='' && count($recipient_arr)>0){
                    $email .= ",
                    'ToRecipients': [ ";
                                for($r=0;$r<count($recipient_arr);$r++){
                                    $email .= "     {
                                            'EmailAddress': {'Address': '".trim($recipient_arr[$r])."'}
                                        } ";
                                        if($r<(count($recipient_arr)-1)){ $email .= ", ";  }
                                }                               
                            $email .= "  ]";
                } 
                if($cc_recipient!='' && count($cc_recipient_arr)>0){
                    $email .= ",
                    'CcRecipients': [ ";
                                for($c=0;$c<count($cc_recipient_arr);$c++){
                                    $email .= "     {
                                            'EmailAddress': {'Address': '".trim($cc_recipient_arr[$c])."'}
                                        } ";
                                        if($c<(count($cc_recipient_arr)-1)){ $email .= ", ";  }
                                }                               
                            $email .= "  ]";
                }
                if($bcc_recipient!=''  && count($bcc_recipient_arr)>0){
                    $email .= ",
                    'BccRecipients': [ ";
                                        for($bc=0;$bc<count($bcc_recipient_arr);$bc++){
                                    $email .= "     {
                                            'EmailAddress': {'Address': '".trim($bcc_recipient_arr[$bc])."'}
                                        } ";
                                    if($bc<(count($bcc_recipient_arr)-1)){ $email .= ", ";  }
                                }    
                              $email .= "  ]";
                }
                if($replyto_recipient!=''){
                   $email .= ",
                   'ReplyTo':   [
                                    {
                                        'EmailAddress': {'Address': '{$replyto_recipient}'}
                                    }
                                ]";
                }
                /*if(is_array($attachments) && count($attachments)>0){
                            $email .= ",
                                'Attachments': [ ";
                                for($att=0;$att<count($attachments);$att++){
                                    $email .= "
                                            {
                                                '@odata.type': '#Microsoft.graph.FileAttachment',
                                                'Name': '".$attachments[$att]['Name']."',
                                                'ContentBytes': '".$attachments[$att]['ContentBytes']."'
                                            },";                                      
                                }
                                          
                                $email .=    " ] ";
                                        
                }*/       
                //$email .=    " },";
                //$email .= ",'SaveToSentItems': true";
                $email .= " },";
                //echo '=='.$accessToken.'+++'.$email;
                //echo $email; 
                // Send the email request to the sendmail endpoint,
                // which is in the following URI:
                // https://graph.microsoft.com/v1.0/me/sendmail
                // Note that the access token is attached in the Authorization header
                
                $draftmessage=$this->sendPostRequest(RESOURCE_ID.SENDMAIL_DRAFT,array("User-Agent: php-tutorial/1.0",'Authorization: Bearer '.$accessToken,'Content-Type: application/json;'.'odata.metadata=minimal;'.'odata.streaming=true'),$email);
                $draftresponse=json_decode($draftmessage['response']);
                //echo '<pre>'; print_r($draftresponse);
                //echo "***************************************<br>";
                //echo $draftresponse->id;
                //die;
                //$data = fopen('output.txt','a');
                //fwrite($data,$draftmessage['response']['id']);
                //if($draftresponse->id!=''){

                if(is_array($attachments) && count($attachments)>0){				for($att=0;$att<count($attachments);$att++){
                  $startsessionbody='{
                  "AttachmentItem": {
                    "attachmentType": "file",
                    "name": "'.$attachments[$att]['Name'].'", 
                    "size": '.$attachments[$att]['Size'].'
                    
                  }
                }';  


               
                //echo '++++++++++++++++'.$draftmessage['response']['id'];

                

                $uploadsession=$this->sendPostRequest(RESOURCE_ID.SENDMAIL_DRAFT.'/'.$draftresponse->id.SENDMAIL_CREATEUPLOADSESSION,array("User-Agent: php-tutorial/1.0",'Authorization: Bearer '.$accessToken,'Content-Type: application/json;'),$startsessionbody);
                
                $attachments[$att]['Filepath']=str_replace("../attachment/../attachment/","../attachment/",$attachments[$att]['Filepath']);
                $handle = fopen($attachments[$att]['Filepath'], 'rb');
                $fileSize = $attachments[$att]['Size'];
                $prevBytesRead = 0;
                //echo $draftresponse->id;
                //echo "&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&<br>";
                //echo '<pre>'; print_r($uploadsessionres);
                //echo '@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@<br>';
                $uploadsessionres=json_decode($uploadsession['response']);
                //die;
                //fwrite($data,print_r($uploadsession));
                //echo "+++++++++++++++++++<pre>";print_r($uploadsession);die;
                //echo '<pre>'; print_r($uploadsessionres);
                $chunkSize = 1024 * 1024;
                while (!feof($handle)) {
                    $bytes = fread($handle, $chunkSize);
                    $bytesRead = ftell($handle);

                    if($prevBytesRead==0){
                        $biterange=ceil((($bytesRead-1)/$fileSize));
                    }else{
                        $biterange=ceil((($prevBytesRead-($bytesRead-1))/$fileSize));
                    }

                    $chunkuploadsession=$this->sendPutRequest($uploadsessionres->uploadUrl,
                        array("User-Agent: php-tutorial/1.0",
                            'Connection: keep-alive',
                            'Content-Length: '.($bytesRead-$prevBytesRead),
                            'Content-Range: bytes'.'bytes ' . $prevBytesRead . '-' . ($bytesRead-1) . '/' . $fileSize),$bytes);

                    //echo '***'.'Content-Length: '.($bytesRead-$prevBytesRead).'<br>';
                    //echo '+++++ '.$biterange.'=='.$prevBytesRead. '-' . ($bytesRead-1) . '/' . $fileSize.'<br>';

                    $prevBytesRead = $bytesRead;
                    //echo '<pre>'; print_r($chunkuploadsession);
                }//while end
                fclose($handle);
				}
            }// atachment check


             return $sendmailsession=$this->sendPostRequest(RESOURCE_ID.SENDMAIL_DRAFT.'/'.$draftresponse->id.'/send',array("User-Agent: php-tutorial/1.0",'Authorization: Bearer '.$accessToken,'Content-Type: application/json;'),'');
             //echo '<pre>'; print_r(json_decode($sendmailsession));

        //}

        }    

}

?>
