 <?php

global $vis_language;

switch ($operation['vis_operation']) {
 
case 'domain_report':
?>
		<table class="table table-hover table-striped">
			<thead>
				<tr role="row">
					<th><?php echo $vis_language['TXTDEPARTMENTNAME'];?></th>
					<th><?php echo $vis_language['TXTTOTAL'];?></th>
					<th><?php echo $vis_language['TXTOPEN'];?></th>
					<th><?php echo $vis_language['TXTCLOSE'];?></th>
					<th><?php echo $status_list[0]['status_name'];?></th>
					<th><?php echo $vis_language['TXTPROINPROGRESS'];?></th>
				</tr>
			</thead>
			<tbody>
				<?php
				for($i=0;$i<count($report);$i++){ ?>
					<tr role="row">
						<td><?php echo $report[$i]['department_name'];?></td>
						<td><?php echo $report[$i]['total'];?></td>
						<td><?php echo $report[$i]['openicket'];?></td>
						<td><?php echo $report[$i]['closeticket'];?></td>
						<td><?php echo $report[$i]['resolvedticket'];?></td>
						<td><?php echo $report[$i]['waitticket'];?></td>
					</tr><?php
				}
				?>
			</tbody>
		</table>
<?php
break;
case 'ticket_ci_relation_report':
?>
		<table class="table table-hover table-striped">
			<thead>
				<tr role="row">
					<th ><?php echo $vis_language['TXTTICKETHASH'];?></th>
					<th ><?php echo $vis_language['TXTSUBJECT'];?></th>
					<th ><?php echo $vis_language['TXTCLIENTNAME'];?></th>
					<th ><?php echo $vis_language['TXTEMAIL'];?> </th>
					<th ><?php echo $vis_language['TXTORGANIZATION'];?></th>
					<th ><?php echo $vis_language['TXTCREATIONDATE'];?></th>
					<th ><?php echo $vis_language['TXTATTACHCI'];?></th>
				</tr>
			</thead>
			<tbody>
				<?
				 $html= '';
				for($i=0;$i<count($report);$i++) {
					if($report[$i]['ci_name']==''){ $report[$i]['ci_name'] = '-';}	 $html.='<tr><td><a href="#/ticket/ticket_details/'.$report[$i]['ticket_hash'].'/'. $report[$i]['ticket_id'].'" target = "_blank" >'.$report[$i]['ticket_hash'].'</a>'.'</td><td>'.$report[$i]['subject'].'</td><td>'.$report[$i]['first_name'].' '.$report[$i]['last_name'].'</td><td>'.$report[$i]['email'].'</td><td>'.$report[$i]['group_name'].'</td><td>'.format_datetime($report[$i]['receive_date']).'</td><td>'.str_replace(',',',</br>',$report[$i]['ci_name']).'</td>';
						$html.='</tr></span>';
					}  echo $html;?>
			</tbody>
		</table>
<?php
break;
case 'assets_usedby_client_report':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTASSETNAME'];?></th>
			<th><?php echo $vis_language['TXTCITYPE'];?></th>
			<th><?php echo $vis_language['TXTASSIGNEDON'];?></th>
			<th><?php echo $vis_language['TXTLOCATION'];?></th>
			<th><?php echo $vis_language['TXTUSEDBY'];?></th>
			<th><?php echo $vis_language['TXTEXPIRYDATE'];?></th>
		</tr>
	</thead>
	<tbody>
	<?php  
		$html ='';
		for($i=0;$i<count($report);$i++) {
		$html.='<tr><td><a href="#/cmdb/assets_details/' .$report[$i]['name'].'/'.$report[$i]['assets_id'].'" target="_blank" >'.$report[$i]['name'].'</a></td><td>'.$report[$i]['ci_name'].'</td><td>'.format_datetime($report[$i]['assigned_on']).'</td><td>'.$report[$i]['LNAME'].'</td><td>'.$report[$i]['usedby'].'</td> '; 
			if($report[$i]['expiry_date'] != 0 && $report[$i]['expiry_date']!='--' && ($report[$i]['expiry_date'] < strtotime(date('Y-m-d H:i:s'))))
			{
				$html.='<td><span style="background-color: #e33244; color: #fff; font-weight: normal" class="btn-xs l-h-1x text-xs">'.format_datetime($report[$i]['expiry_date']).'</span></td>';
			}
			else
			{
				$html.='<td>'.format_datetime($report[$i]['expiry_date']).'</td>';
			}
			$html.='</tr></span>';
	 } echo $html;?>
	</tbody>
	</table>

<?php 
break;
case 'all_guest_asset_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTASSETNAME'];?></th>
				<th><?php echo $vis_language['TXTCITYPE'];?></th>
				<th><?php echo $vis_language['TXTLOCATION'];?></th>
				<th><?php echo $vis_language['TXTMANAGEDBY'];?></th>
				<th><?php echo $vis_language['TXTUSEDBY'];?></th>
				<th><?php echo $vis_language['TXTEXPIRYDATE'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
				$html ='';
				for($i=0;$i<count($report);$i++) {
					if($report[$i]['staff_id']===''){
						$managed_by = '---';
						}else{
						$managed_by = $report[$i]['first_name'].' '.$report[$i]['last_name'];
					}
					$html.='<tr><td><a target="_blank" href="#/cmdb/cmdb_details/'.str_replace('/', ' ', $report[$i]['name']).'/'.$report[$i]['assets_id'].'">'.$report[$i]['name'].'</a></td><td>'.$report[$i]['ci_name'].'</td><td>'.$report[$i]['LNAME'].'</td><td>'.$managed_by.'</td>';
					if($report[$i]['usedby']!='') {                      	
                      	$html.='<td>'.$report[$i]['usedby'].'</td>';
                      } else if($report[$i]['usedbytype']==3) {
  		                    	$html.='<td> Guest</td>';
  		              } else {
	                  	$html.='<td> ---- </td>';
	                  }
					if($report[$i]['expiry_date']!='--' && ($report[$i]['expiry_date'] < strtotime(date('Y-m-d H:i:s'))))
					{
						$html.='<td><span style="background-color: #e33244; color: #fff; font-weight: normal" class="btn-xs l-h-1x text-xs">'.format_datetime($report[$i]['expiry_date']).'</span></td>';
					}
					else
					{
						$html.='<td>'.format_datetime($report[$i]['expiry_date']).'</td>';
					}

					$html.='</tr>';
				} echo $html;?>
		</tbody>
	</table>
<?php
break;
case 'assets_managedby_staff_report':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTASSETNAME'];?></th>
			<th><?php echo $vis_language['TXTCITYPE'];?></th>
			<th><?php echo $vis_language['TXTASSIGNEDON'];?></th>
			<th><?php echo $vis_language['TXTLOCATION'];?></th>
			<th><?php echo $vis_language['TXTMANAGEDBY'];?></th>
			<th><?php echo $vis_language['TXTEXPIRYDATE'];?></th>
		</tr>
	</thead>
	<tbody>
		  <?php
		  $html ='';
	for($i=0;$i<count($report);$i++) {
		if($report[$i]['staff_id']===''){
			$managed_by = '---';
		}else{
			$managed_by = $report[$i]['first_name'].' '.$report[$i]['last_name'];
		}
		$html.='<tr><td><a href=#/cmdb/assets_details/'.rawurlencode(str_replace('.', '',str_replace('/', '', $report[$i]['name']))).'/'.$report[$i]['assets_id'].' target="_blank">'.$report[$i]['name'].'</a>
		</td><td>'.$report[$i]['ci_name'].'</td><td>'.format_datetime($report[$i]['assigned_on']).'</td><td>'.$report[$i]['LNAME'].'</td><td>'.$managed_by.'</td>';
		if($report[$i]['expiry_date']!='--'  && ($report[$i]['expiry_date'] < strtotime(date('Y-m-d H:i:s'))))
			{
				$html.='<td><span style="background-color: #e33244; color: #fff; font-weight: normal" class="btn-xs l-h-1x text-xs">'.format_datetime($report[$i]['expiry_date']).'</span></td>';
			}
			else
			{
				$html.='<td>'.format_datetime($report[$i]['expiry_date']).'</td>';
			}
		$html.='</tr></span>';
	 } echo $html;
	 ?>
	</tbody>
	</table>
<?php
break;
case 'assets_linkedto_tickets_report':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
			<th><?php echo $vis_language['TXTSUBJECT'];?></th>
			<th><?php echo $vis_language['TXTASSETNAME'];?></th>
			<th><?php echo $vis_language['TXTCITYPE'];?></th>
			<th><?php echo $vis_language['TXTUSEDBY'];?></th>
			<th><?php echo $vis_language['TXTMANAGEDBY'];?></th>
			<th><?php echo $vis_language['TXTEXPIRYDATE'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php
			$html ='';
			for($i=0;$i<count($report);$i++) {
				if($report[$i]['staff_id']===''){
					$managed_by = '---';
					}else{
					$managed_by = $report[$i]['first_name'].' '.$report[$i]['last_name'];
				}
				$html.='<tr><td><a href="#/ticket/ticket_details/'.$report[$i]['ticket_hash'].'/'.$report[$i]['ticket_id'].'" target="_blank">'.$report[$i]['ticket_hash'].'</a></td><td>'.$report[$i]['subject'].'</td><td><a href="#/cmdb/cmdb_details/'.$report[$i]['name'].'/'.$report[$i]['assets_id'].'" target="_blank">'.$report[$i]['name'].'</a></td><td>'.$report[$i]['ci_name'].'</td><td>'.$report[$i]['used_by'].'</td><td>'.$managed_by.'</td>';

				if($report[$i]['expiry_date']!='--' && ($report[$i]['expiry_date'] < strtotime(date('Y-m-d H:i:s'))))
				{
					$html.='<td><span style="background-color: #e33244; color: #fff; font-weight: normal" class="btn-xs l-h-1x text-xs">'.format_datetime($report[$i]['expiry_date']).'</span></td>';
				}
				else
				{
					$html.='<td>'.format_datetime($report[$i]['expiry_date']).'</td>';
				}
				$html.='</tr></span>';

			} echo $html;?>
	</tbody>
	</table>
<?php
break;
case 'assets_linkedto_problems_report':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTPROBLEMHASH'];?></th>
			<th><?php echo $vis_language['TXTSUBJECT'];?></th>
			<th><?php echo $vis_language['TXTASSETNAME'];?></th>
			<th><?php echo $vis_language['TXTCITYPE'];?></th>
			<th><?php echo $vis_language['TXTUSEDBY'];?></th>
			<th><?php echo $vis_language['TXTMANAGEDBY'];?></th>
			<th><?php echo $vis_language['TXTEXPIRYDATE'];?></th>
		</tr>
	</thead>
	<tbody>
		 <?php
		 $html ='';
		for($i=0;$i<count($report);$i++) {
			if($report[$i]['staff_id']===''){
				$managed_by = '---';
			}else{
				$managed_by = $report[$i]['first_name'].' '.$report[$i]['last_name'];
			}
			$html.='<tr><td><a href="#/problem/problems_details/'.$report[$i]['problem_hash'].'/'.$report[$i]['problem_id'].'" target="_blank">'.$report[$i]['problem_hash'].'</a></td><td>'.$report[$i]['subject'].'</td><td><a href="#/cmdb/cmdb_details/'.$report[$i]['name'].'/'.$report[$i]['assets_id'].'" target="_blank">'.$report[$i]['name'].'</a></td><td>'.$report[$i]['ci_name'].'</td><td>'.$report[$i]['usedby'].'</td><td>'.$managed_by.'</td>'; 
			if($report[$i]['expiry_date']!='0' && $report[$i]['expiry_date']!='--' && ($report[$i]['expiry_date'] < strtotime(date('Y-m-d H:i:s'))))
			{
				$html.='<td><span style="background-color: #e33244; color: #fff; font-weight: normal" class="btn-xs l-h-1x text-xs">'.format_datetime($report[$i]['expiry_date']).'</span></td>';
			}
			else
			{
				$html.='<td>'.format_datetime($report[$i]['expiry_date']).'</td>';
			}
		  $html.='</tr></span>';

		 } echo $html;?>
	</tbody>
	</table>
<?php
break;
case 'assets_linkedto_changes_report':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
			<th><?php echo $vis_language['TXTSUBJECT'];?></th>
			<th><?php echo $vis_language['TXTASSETNAME'];?></th>
			<th><?php echo $vis_language['TXTCITYPE'];?></th>
			<th><?php echo $vis_language['TXTUSEDBY'];?></th>
			<th><?php echo $vis_language['TXTMANAGEDBY'];?></th>
			<th><?php echo $vis_language['TXTEXPIRYDATE'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php
			$html ='';
			for($i=0;$i<count($report);$i++) {
				if($report[$i]['staff_id']===''){
					$managed_by = '---';
					}else{
					$managed_by = $report[$i]['first_name'].' '.$report[$i]['last_name'];
				}
				$html.='<tr><td><a href="#/changes/changes_details/'.$report[$i]['changes_hash'].'/'.$report[$i]['changes_id'].'" target="_blank">'.$report[$i]['changes_hash'].'</a></td><td>'.$report[$i]['subject'].'</td><td><a href="#/cmdb/cmdb_details/'.$report[$i]['name'].'/'.$report[$i]['assets_id'].'" target="_blank">'.$report[$i]['name'].'</a></td><td>'.$report[$i]['ci_name'].'</td><td>'.$report[$i]['used_by'].'</td><td>'.$managed_by.'</td>';

				if($report[$i]['expiry_date']!='--' && $report[$i]['expiry_date']!=0 && ($report[$i]['expiry_date'] < strtotime(date('Y-m-d H:i:s'))))
				{
					$html.='<td><span style="background-color: #e33244; color: #fff; font-weight: normal" class="btn-xs l-h-1x text-xs">'.format_datetime($report[$i]['expiry_date']).'</span></td>';
				}
				else
				{
					$html.='<td>'.format_datetime($report[$i]['expiry_date']).'</td>';
				}
				$html.='</tr></span>';

			} echo $html;?>
	</tbody>
	</table>
<?php 
break;
case 'assets_linkedto_releases_report':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
			<th><?php echo $vis_language['TXTSUBJECT'];?></th>
			<th><?php echo $vis_language['TXTASSETNAME'];?></th>
			<th><?php echo $vis_language['TXTCITYPE'];?></th>
			<th><?php echo $vis_language['TXTUSEDBY'];?></th>
			<th><?php echo $vis_language['TXTMANAGEDBY'];?></th>
			<th><?php echo $vis_language['TXTEXPIRYDATE'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php
			$html ='';
			for($i=0;$i<count($report);$i++) {
				if($report[$i]['staff_id']===''){
					$managed_by = '---';
					}else{
					$managed_by = $report[$i]['first_name'].' '.$report[$i]['last_name'];
				}
				$html.='<tr><td><a href="#/releases/releases_details/'.$report[$i]['release_hash'].'/'.$report[$i]['release_id'].'" target="_blank">'.$report[$i]['release_hash'].'</a></td><td>'.$report[$i]['subject'].'</td><td><a href="#/cmdb/cmdb_details/'.$report[$i]['name'].'/'.$report[$i]['assets_id'].'" target="_blank">'.$report[$i]['name'].'</a></td><td>'.$report[$i]['ci_name'].'</td><td>'.$report[$i]['usedby'].'</td><td>'.$managed_by.'</td>';

				if($report[$i]['expiry_date']!='--' && $report[$i]['expiry_date']!=0 && ($report[$i]['expiry_date'] < strtotime(date('Y-m-d H:i:s'))))
				{
					$html.='<td><span style="background-color: #e33244; color: #fff; font-weight: normal" class="btn-xs l-h-1x text-xs">'.format_datetime($report[$i]['expiry_date']).'</span></td>';
				}
				else
				{
					$html.='<td>'.format_datetime($report[$i]['expiry_date']).'</td>';
				}
				$html.='</tr></span>';

			} echo $html;?>
	</tbody>
	</table>
<?php
break;
case 'assets_expiry_report':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTASSETNAME'];?></th>
			<th><?php echo $vis_language['TXTCITYPE'];?></th>
			<th><?php echo $vis_language['TXTLOCATION'];?></th>
			<th><?php echo $vis_language['TXTMANAGEDBY'];?></th>
			<th><?php echo $vis_language['TXTUSEDBY'];?></th>
			<th><?php echo $vis_language['TXTEXPIRYDATE'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php
		echo $html='';
		for($i=0;$i<count($report);$i++) {
			if($report[$i]['staff_id']===''){
				$managed_by = '---';
				}else{
				$managed_by = $report[$i]['first_name'].' '.$report[$i]['last_name'];
			}
			$html.='<tr><td><a target="_blank" href="#/cmdb/cmdb_details/'.str_replace('/', ' ', $report[$i]['name']).'/'.$report[$i]['assets_id'].'">'.$report[$i]['name'].'</a></td><td>'.$report[$i]['CNAME'].'</td><td>'.$report[$i]['LNAME'].'</td><td>'.$managed_by.'</td><td>'.$report[$i]['usedby'].'</td>';
			if($report[$i]['expiry_date']!='--' && ($report[$i]['expiry_date'] < strtotime(date('Y-m-d H:i:s'))))
			{
				$html.='<td><span style="background-color: #e33244; color: #fff; font-weight: normal" class="btn-xs l-h-1x text-xs">'.format_datetime($report[$i]['expiry_date']).'</span></td>';
			}
			else
			{
				$html.='<td>'.format_datetime($report[$i]['expiry_date']).'</td>';
			}
			$html.='</tr>';
		} echo $html;?>
	</tbody>
	</table>
<?php
break;
case 'assets_groupby_status_report':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTASSETNAME'];?></th>
			<th><?php echo $vis_language['TXTCITYPE'];?></th>
			<th><?php echo $vis_language['TXTLOCATION'];?></th>
			<th><?php echo $vis_language['TXTMANAGEDBY'];?></th>
			<th><?php echo $vis_language['TXTUSEDBY'];?></th>
			<th><?php echo $vis_language['TXTEXPIRYDATE'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php
		echo $html='';
		for($i=0;$i<count($report);$i++) {
			if($report[$i]['staff_id']===''){
				$managed_by = '---';
				}else{
				$managed_by = $report[$i]['first_name'].' '.$report[$i]['last_name'];
			}
			$html.='<tr><td><a target="_blank" href="#/cmdb/cmdb_details/'.str_replace('/', ' ', $report[$i]['name']).'/'.$report[$i]['assets_id'].'">'.$report[$i]['name'].'</a></td><td>'.$report[$i]['CNAME'].'</td><td>'.$report[$i]['LNAME'].'</td><td>'.$managed_by.'</td><td>'.$report[$i]['usedby'].'</td>';
			if($report[$i]['expiry_date']!='--' && ($report[$i]['expiry_date'] < strtotime(date('Y-m-d H:i:s'))))
			{
				$html.='<td><span style="background-color: #e33244; color: #fff; font-weight: normal" class="btn-xs l-h-1x text-xs">'.format_datetime($report[$i]['expiry_date']).'</span></td>';
			}
			else
			{
				$html.='<td>'.format_datetime($report[$i]['expiry_date']).'</td>';
			}
			$html.='</tr>';
		} echo $html;?>
	</tbody>
	</table>
<?php
break;
case 'assets_groupby_location_report':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTNAME'];?></th>
			<th><?php echo $vis_language['TXTCITYPE'];?></th>
			<th><?php echo $vis_language['TXTLOCATION'];?></th>
			<th><?php echo $vis_language['TXTMANAGEDBY'];?></th>
			<th><?php echo $vis_language['TXTUSEDBY'];?></th>
			<th><?php echo $vis_language['TXTEXPIRYDATE'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php
			$html ='';
			for($i=0;$i<count($report);$i++) {
			if($report[$i]['staff_id']===''){
				$managed_by = '---';
				}else{
				$managed_by = $report[$i]['first_name'].' '.$report[$i]['last_name'];
			}
			$html.='<tr><td><a href="#/cmdb/cmdb_details/'.str_replace('/', ' ', $report[$i]['name']).'/'.$report[$i]['assets_id'].'" target="_blank">'.$report[$i]['name'].'</a></td><td>'.$report[$i]['CNAME'].'</td><td>'.$report[$i]['LNAME'].'</td><td>'.$managed_by.'</td><td>'.$report[$i]['usedby'].'</td>';

			if($report[$i]['expiry_date']!='--' && ($report[$i]['expiry_date'] < strtotime(date('Y-m-d H:i:s'))))
			{
				$html.='<td><span style="background-color: #e33244; color: #fff; font-weight: normal" class="btn-xs l-h-1x text-xs">'.format_datetime($report[$i]['expiry_date']).'</span></td>';
			}
			else
			{
				$html.='<td>'.format_datetime($report[$i]['expiry_date']).'</td>';
			}

			$html.='</tr>';

		} echo $html;?>
	</tbody>
	</table>
<?php
break;
case 'assets_asset_type_report':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTNAME'];?></th>
			<th><?php echo $vis_language['TXTCITYPE'];?></th>
			<th><?php echo $vis_language['TXTLOCATION'];?></th>
			<th><?php echo $vis_language['TXTMANAGEDBY'];?></th>
			<th><?php echo $vis_language['TXTUSEDBY'];?></th>
			<th><?php echo $vis_language['TXTEXPIRYDATE'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php
			$html ='';
			for($i=0;$i<count($report);$i++) {
				if($report[$i]['staff_id']===''){
					$managed_by = '---';
					}else{
					$managed_by = $report[$i]['first_name'].' '.$report[$i]['last_name'];
				}
				$html.='<tr><td><a href="#/cmdb/cmdb_details/'.str_replace('/', ' ', $report[$i]['name']).'/'.$report[$i]['assets_id'].'" target="_blank">'.$report[$i]['name'].'</a></td><td>'.$report[$i]['ci_name'].'</td><td>'.$report[$i]['LNAME'].'</td><td>'.$managed_by.'</td><td>'.$report[$i]['usedby'].'</td>';
				if($report[$i]['expiry_date']!='--' && ($report[$i]['expiry_date'] < strtotime(date('Y-m-d H:i:s'))))
				{
					$html.='<td><span style="background-color: #e33244; color: #fff; font-weight: normal" class="btn-xs l-h-1x text-xs">'.format_datetime($report[$i]['expiry_date']).'</span></td>';
				}
				else
				{
					$html.='<td>'.format_datetime($report[$i]['expiry_date']).'</td>';
				}

				$html.='</tr>';
			} echo $html;?>
	</tbody>
	</table>
<?php
break;
case 'assets_asset_product_report':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTASSETNAME'];?></th>
			<th><?php echo $vis_language['TXTCITYPE'];?></th>
			<th><?php echo $vis_language['TXTLOCATION'];?></th>
			<th><?php echo $vis_language['TXTMANAGEDBY'];?></th>
			<th><?php echo $vis_language['TXTCIPRODUCT'].' '.strtolower($vis_language['TXTNAME']);?></th>
			<th><?php echo $vis_language['TXTVENDOR'].' '.strtolower($vis_language['TXTNAME']);?></th>
			<th><?php echo $vis_language['TXTEXPIRYDATE'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php
			$html='';
			for($i=0;$i<count($report);$i++) {
			if($report[$i]['staff_id']===''){
				$managed_by = '---';
				}else{
				$managed_by = $report[$i]['first_name'].' '.$report[$i]['last_name'];
			}
			$html.='<tr><td><a target="_blank" href="#/cmdb/cmdb_details/'.str_replace('/', ' ', $report[$i]['name']).'/'.$report[$i]['assets_id'].'">'.$report[$i]['name'].'</a></td><td>'.$report[$i]['CNAME'].'</td><td>'.$report[$i]['LNAME'].'</td><td>'.$managed_by.'</td><td>'.$report[$i]['product_name'].'</td><td>'.$report[$i]['vender_name'].'</td>';
			if($report[$i]['expiry_date']!='--' && ($report[$i]['expiry_date'] < strtotime(date('Y-m-d H:i:s'))))
			{
				$html.='<td><span style="background-color: #e33244; color: #fff; font-weight: normal" class="btn-xs l-h-1x text-xs">'.format_datetime($report[$i]['expiry_date']).'</span></td>';
			}
			else
			{
				$html.='<td>'.format_datetime($report[$i]['expiry_date']).'</td>';
			}
			$html.='</tr>';
		} echo $html;?>
	</tbody>
	</table>

<?php
break;
case 'hardware_assets_by_state_report':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTASSETNAME'];?></th>
			<th><?php echo $vis_language['TXTCITYPE'];?></th>
			<th><?php echo $vis_language['TXTLOCATION'];?></th>
			<th><?php echo $vis_language['TXTMANAGEDBY'];?></th>
			<th><?php echo $vis_language['TXTASSETSTATE'];?></th>
			<th><?php echo $vis_language['TXTEXPIRYDATE'];?></th>
		</tr>
	</thead>
	<tbody>
	<?php
	$html ='';
	for($i=0;$i<count($report);$i++) {
		if($report[$i]['staff_id']===''){
			$managed_by = '---';
		}else{
			$managed_by = $report[$i]['first_name'].' '.$report[$i]['last_name'];
		}
		$html.='<tr><td><a target="_blank" href="#/cmdb/cmdb_details/'.str_replace('/', ' ', $report[$i]['name']).'/'.$report[$i]['assets_id'].'">'.$report[$i]['name'].'</a></td><td>'.$report[$i]['CNAME'].'</td><td>'.$report[$i]['LNAME'].'</td><td>'.$managed_by.'</td><td>'.$report[$i]['description'].'</td>';
		if($report[$i]['expiry_date']!='--' && ($report[$i]['expiry_date'] < strtotime(date('Y-m-d H:i:s'))))
		{
			$html.='<td><span style="background-color: #e33244; color: #fff; font-weight: normal" class="btn-xs l-h-1x text-xs">'.format_datetime($report[$i]['expiry_date']).'</span></td>';
		}
		else
		{
			$html.='<td>'.format_datetime($report[$i]['expiry_date']).'</td>';
		}
		$html.='</tr>';
	} echo $html;?>
	</tbody>
	</table>
<?php
break;
case 'assets_depreciation_report':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTNAME'];?></th>
			<th><?php echo $vis_language['TXTCITYPE'];?></th>
			<th><?php echo $vis_language['TXTMANAGEDBY'];?></th>
			<th><?php echo $vis_language['TXTUSEDBY'];?></th>
			<th><?php echo $vis_language['TXTASSETSTATE'];?></th>
			<th><?php echo $vis_language['TXTITILDEPRECIATIONTYPE'];?></th>
			<th><?php echo $vis_language['TXTUSEFULLIFE'];?></th>
			<th><?php echo $vis_language['TXTEXPIRYDATE'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php
			$html = '';
			for($i=0;$i<count($report);$i++) {
			if($report[$i]['staff_id']===''){
				$managed_by = '---';
				}else{
				$managed_by = $report[$i]['first_name'].' '.$report[$i]['last_name'];
			}
			$html.='<tr><td><a href="#/cmdb/cmdb_details/'.str_replace('/', ' ', $report[$i]['name']).'/'.$report[$i]['assets_id'].'" target="_blank">'.$report[$i]['name'].'</a></td><td>'.$report[$i]['CNAME'].'</td><td>'.$managed_by.'</td><td>'.$report[$i]['usedby'].'</td><td>'.$report[$i]['description'].'</td><td>'.$report[$i]['depreciation_type'].'</td><td>'.$report[$i]['useful_life'].'</td>';

			if($report[$i]['expiry_date']!='--' && ($report[$i]['expiry_date'] < strtotime(date('Y-m-d H:i:s'))))
			{
				$html.='<td><span style="background-color: #e33244; color: #fff; font-weight: normal" class="btn-xs l-h-1x text-xs">'.format_datetime($report[$i]['expiry_date']).'</span></td>';
			}
			else
			{
				$html.='<td>'.format_datetime($report[$i]['expiry_date']).'</td>';
			}

			$html.='</tr>';

		} echo $html;?>
	</tbody>
	</table>
<?php
break;
case 'assets_depreciation_notification_report':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			 <th><?php echo $vis_language['TXTNAME'];?></th>
			<th><?php echo $vis_language['TXTCITYPE'];?></th>
			<th><?php echo $vis_language['TXTMANAGEDBY'];?></th>
			<th><?php echo $vis_language['TXTUSEDBY'];?></th>
			<th><?php echo $vis_language['TXTASSETSTATE'];?></th>
			<th><?php echo $vis_language['TXTITILDEPRECIATIONTYPE'];?></th>
			<th><?php echo $vis_language['TXTREMAININGWARRANTY'];?></th>
			<th><?php echo $vis_language['TXTITILACQUISITIONDATE'];?></th>
			<th><?php echo $vis_language['TXTEXPIRYDATE'];?></th>
		</tr>
	</thead>
	<tbody>
			 <?php
		$html ='';
		for($i=0;$i<count($report);$i++) {
		if($report[$i]['staff_id']===''){
			$managed_by = '---';
		}else{
			$managed_by = $report[$i]['first_name'].' '.$report[$i]['last_name'];
		}

		$html.='<tr><td><a href="#/cmdb/cmdb_details/'.str_replace('/', ' ', $report[$i]['name']).'/'.$report[$i]['assets_id'].'" target="_blank">'.$report[$i]['name'].'</a></td><td>'.$report[$i]['CNAME'].'</td><td>'.$managed_by.'</td><td>'.$report[$i]['usedby'].'</td><td>'.$report[$i]['description'].'</td><td>'.$report[$i]['depreciation_type'].'</td><td>'.$report[$i]['rem_warranty'].'</td><td>'.date(VIS_EDITDATETIMEPICKER_FORMAT,$report[$i]['installation_date']).'</td>';

		if($report[$i]['expiry_date']!='--' && ($report[$i]['expiry_date'] < strtotime(date('Y-m-d H:i:s'))))
		{
			$html.='<td><span style="background-color: #e33244; color: #fff; font-weight: normal" class="btn-xs l-h-1x text-xs">'.format_datetime($report[$i]['expiry_date']).'</span></td>';
		}
		else
		{
			$html.='<td>'.format_datetime($report[$i]['expiry_date']).'</td>';
		}
		$html.='</tr>';

	 } echo $html;?>
	</tbody>
	</table>
<?php
break;
case 'asset_manufacturer_report':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTASSETNAME'];?></th>
			<th><?php echo $vis_language['TXTCITYPE'];?></th>
			<th><?php echo $vis_language['TXTLOCATION'];?></th>
			<th><?php echo $vis_language['TXTMANAGEDBY'];?></th>
				<?php
			if ($report[0]['ci_type_id']==2 || $report[0]['ci_type_id']==8 ||$report[0]['ci_type_id']==9 ||$report[0]['ci_type_id']==10 || $report[0]['ci_type_id']==11 ||$report[0]['ci_type_id']==12 ||$report[0]['ci_type_id']==13)
            {
            ?>
            <th><?php echo  $vis_language['TXTASSETSTATE'];?></th>
        <?php   
         }
        ?>
			<th><?php echo $vis_language['TXTEXPIRYDATE'];?></th>
		</tr>
	</thead>
	<tbody>
	<?php
	$html ='';
	for($i=0;$i<count($report);$i++) {
		if($report[$i]['staff_id']===''){
			$managed_by = '---';
		}else{
			$managed_by = $report[$i]['first_name'].' '.$report[$i]['last_name'];
		}
		$html.='<tr><td><a target="_blank" href="#/cmdb/cmdb_details/'.str_replace('/', ' ', $report[$i]['name']).'/'.$report[$i]['assets_id'].'">'.$report[$i]['name'].'</a></td><td>'.$report[$i]['CNAME'].'</td><td>'.$report[$i]['LNAME'].'</td><td>'.$managed_by.'</td>';
		if ($report[$i]['ci_type_id']==2 || $report[$i]['ci_type_id']==8 ||$report[$i]['ci_type_id']==9 ||$report[$i]['ci_type_id']==10 || $report[$i]['ci_type_id']==11 ||$report[$i]['ci_type_id']==12 ||$report[$i]['ci_type_id']==13)
		{ $html.='<td>'.$report[$i]['description'].'</td>'; }
		if($report[$i]['expiry_date']!='--' && ($report[$i]['expiry_date'] < strtotime(date('Y-m-d H:i:s'))))
		{
			$html.='<td><span style="background-color: #e33244; color: #fff; font-weight: normal" class="btn-xs l-h-1x text-xs">'.format_datetime($report[$i]['expiry_date']).'</span></td>';
		}
		else
		{
			$html.='<td>'.format_datetime($report[$i]['expiry_date']).'</td>';
		}
		$html.='</tr>'; 
	   
	 } echo $html;?>
	</tbody>
	</table>
<?php
break;
case 'assets_baseline_report':
?>
	<table class="table table-hover table-striped1">
	<thead>
		<tr role="row">
			<th><? echo $vis_language['TXTPROPERTY']; ?></th>
			<th><? echo $vis_language['TXTBASEVALUE']; ?></th>
			<th><? echo $vis_language['TXTCURRENTVALUE']; ?></th> 
		</tr>
	</thead>
	<tbody>
		<? foreach($report as $log){ ?>
		<tr <? if($log[3]==1) echo 'class="info"';?>>
			<td><?=$log[0];?></td>
			<td><?=$log[2]?></td>
			<td><?=$log[1];?></td>
		</tr>
	<? } ?>
	</tbody>
	</table>
<?php
break;
case 'asset_department_report':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTNAME'];?></th>
			<th><?php echo $vis_language['TXTCITYPE'];?></th>
			<th><?php echo $vis_language['TXTMANAGEDBY'];?></th>
			<th><?php echo $vis_language['TXTUSEDBY'];?></th>

			<?php
			if ($report[0]['ci_type_id']==2 || $report[0]['ci_type_id']==8 ||$report[0]['ci_type_id']==9 ||$report[0]['ci_type_id']==10 || $report[0]['ci_type_id']==11 ||$report[0]['ci_type_id']==12 ||$report[0]['ci_type_id']==13)
            {
            ?>
            <th><?php echo $vis_language['TXTASSETSTATE'];?></th>
        <?php   
         }
        ?>
			<th><?php echo $vis_language['TXTASSETDEPARTMENT'];?></th> 
			<th><?php echo $vis_language['TXTEXPIRYDATE'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php
			$html = '';
			for($i=0;$i<count($report);$i++) {
			if($report[$i]['staff_id']===''){
				$managed_by = '---';
				}else{
				$managed_by = $report[$i]['first_name'].' '.$report[$i]['last_name'];
			}
			$html.='<tr><td><a href="#/cmdb/cmdb_details/'.str_replace('/', ' ', $report[$i]['name']).'/'.$report[$i]['assets_id'].'" target="_blank">'.$report[$i]['name'].'</a></td><td>'.$report[$i]['CNAME'].'</td><td>'.$managed_by.'</td><td>'.$report[$i]['usedby'].'</td>';
			if ($report[$i]['ci_type_id']==2 || $report[$i]['ci_type_id']==8 ||$report[$i]['ci_type_id']==9 ||$report[$i]['ci_type_id']==10 || $report[$i]['ci_type_id']==11 ||$report[$i]['ci_type_id']==12 ||$report[$i]['ci_type_id']==13)
				{ 
					$html.='<td>'.$report[$i]['description'].'</td>'; 
				}
			$html.='<td>'.$report[$i]['assetdept_name'].'</td>';
			if($report[$i]['expiry_date']!='--' && ($report[$i]['expiry_date'] < strtotime(date('Y-m-d H:i:s'))))
			{
				$html.='<td><span style="background-color: #e33244; color: #fff; font-weight: normal" class="btn-xs l-h-1x text-xs">'.format_datetime($report[$i]['expiry_date']).'</span></td>';
			}
			else
			{
				$html.='<td>'.format_datetime($report[$i]['expiry_date']).'</td>';
			}
			$html.='</tr>';

		} echo $html;?>
	</tbody>
	</table>
<?php
break;
case 'asset_report':
?>
	<table class="table table-hover table-striped" id="datatable">
		<thead>
			<tr role="row">
				<th><? echo $vis_language['TXTNAME']?></th>
				<th><?php echo $vis_language['TXTCITYPE'];?></th>		 
				<th><?php echo $vis_language['TXTEXPIRYDATE'];?></th>
				<th><? echo $vis_language['TXTCOST']?></th>
			</tr>
		</thead>
		<tbody>
			<?php $cost= 0;
			for($i=0;$i<count($report_new);$i++) 
			{ 			
				$cost=($report_new[$i]['ci_type_id'] == 3)? $report_new[$i]['asset_tag']:$report_new[$i]['installation_path'];
			?>
				<tr role="row">
					 <td><a target="_blank" href="#/cmdb/cmdb_details/<?php echo $report_new[$i]['name'];?>/<?php echo $report_new[$i]['assets_id'];?>"><?php echo $report_new[$i]['name'];?></a></td>
					<td><?php echo $report_new[$i]['ci_name'];?></td> 
					<?php 
					if($report_new[$i]['expiry_date']!='--' && ($report_new[$i]['expiry_date'] < strtotime(date('Y-m-d H:i:s'))))
					{ ?>
						<td><span style="background-color: #e33244; color: #fff; font-weight: normal" class="btn-xs l-h-1x text-xs">'.<?php echo        format_datetime($report_new[$i]['expiry_date']) ?></span></td>
					<?}
					else
					{  ?>
						<td><?php echo format_datetime($report_new[$i]['expiry_date']) ?></td>
				<?	} ?>	 
					<td><?php echo $cost;?> <?php echo ($cost != 0)? $domain[0]['currency'] :'0 '.$domain[0]['currency'] ;?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>
<?php
break;
case 'migrated_asset_report':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTNAME'];?></th>
			<th><?php echo $vis_language['TXTCITYPE'];?></th>
			<th><?=$vis_language['TXTMIGRATEDFROM']?></th>
			<th><?php echo $vis_language['TXTLOCATION'];?></th>
			<th><?php echo $vis_language['TXTMANAGEDBY'];?></th>
			<th><?php echo $vis_language['TXTUSEDBY'];?></th>
			<th><?php echo $vis_language['TXTEXPIRYDATE'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php
			$html ='';
			for($i=0;$i<count($report);$i++) {
				if($report[$i]['staff_id']===''){
					$managed_by = '---';
					}else{
					$managed_by = $report[$i]['first_name'].' '.$report[$i]['last_name'];
				}
				$html.='<tr><td><a href="#/cmdb/cmdb_details/'.str_replace('/', ' ', $report[$i]['name']).'/'.$report[$i]['assets_id'].'" target="_blank">'.$report[$i]['name'].'</a></td><td>'.$report[$i]['ci_name'].'</td><td>'.$report[$i]['migrated_from'].'</td><td>'.$report[$i]['LNAME'].'</td><td>'.$managed_by.'</td><td>'.$report[$i]['usedby'].'</td>';
				if($report[$i]['expiry_date']!='--' && ($report[$i]['expiry_date'] < strtotime(date('Y-m-d H:i:s'))))
				{
					$html.='<td><span style="background-color: #e33244; color: #fff; font-weight: normal" class="btn-xs l-h-1x text-xs">'.format_datetime($report[$i]['expiry_date']).'</span></td>';
				}
				else
				{
					$html.='<td>'.format_datetime($report[$i]['expiry_date']).'</td>';
				}  
				$html.='</tr>';
			} echo $html;?>
	</tbody>
	</table>
<?php
break;
case 'contract_report':
?>
	<table class="table table-hover table-striped" id="datatable">
		<thead>
			<tr role="row">
				<th><? echo $vis_language['TXTCONTRACTNUMBER']?></th>
				<th><? echo $vis_language['TXTNAME']?></th>							
				<th><? echo $vis_language['TXTCONTRACTTYPE']?></th>
				<th><? echo $vis_language['TXTCIPRODUCT']?></th>
				<th><? echo $vis_language['TXTVENDOR']?></th>
				<th><? echo $vis_language['TXTLICENSECOUNT']?></th>
				<th><? echo $vis_language['TXTCOST']?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++) { ?>
				<tr role="row">
					<td><?php echo $report[$i]['contract_number']?></td>
					<td><?php echo $report[$i]['name'];?></td>
					<td><?php echo $report[$i]['contract_type_name'];?></td>
					<td><?php echo $report[$i]['product_name'];?></td>
					<td><?php echo $report[$i]['vendor_name'];?></td>
					<td><?php echo $report[$i]['license_count'];?></td>
					<td><?php echo $report[$i]['total_cost'];?> <?php echo $domain[0]['currency'] ;?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>
<?php
break;
case 'problem_ci_relation_report':
?>
	<table class="table table-hover table-striped" id="datatable">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTPROBLEMHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTPRBFRM'];?></th>
				<th><?php echo $vis_language['TXTDOMAIN'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTATTACHCI'];?></th>
			</tr>
		</thead>
		<tbody> 
		<?php
			$html ='';
			for($i=0;$i<count($report);$i++) {
			if($report[$i]['ci_name']==''){ $report[$i]['ci_name'] = '-';}
			$html.='<tr><td><a href="#/problem/problems_details/'.$report[$i]['problem_hash'].'/'.$report[$i]['problem_id'].'" target="_blank" >'.$report[$i]['problem_hash'].'</a>'.'</td><td>'.$report[$i]['subject'].'</td><td>'.$report[$i]['first_name'].' '.$report[$i]['last_name'].'</td><td>'.$report[$i]['domain_name'].'</td><td>'.format_datetime($report[$i]['date_created']).'</td><td>'.str_replace(',',',</br>',$report[$i]['ci_name']).'</td>';
			$html.='</tr></span>';
			} echo $html;?>
		</tbody>
	</table>	
<?php
break;
case 'problem_ticket_trend_analysis':
?>
	<table class="table table-hover table-striped" id="datatable">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTPROBLEMHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTTICKETCOUNT'];?></th>
				<th><?php echo $vis_language['TXTPRBFRM'];?></th>
				<th><?php echo $vis_language['TXTDOMAIN'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
			</tr>
		</thead>
		<tbody> 
		<?php
		$html ='';
		for($i=0;$i<count($report);$i++) {
		$report[$i]['ticket_count'] = ($report[$i]['ticket_count']!='')?$report[$i]['ticket_count']:'-';
		$html.='<tr><td><a href="#/problem/problems_details/'.$report[$i]['problem_hash'].'/'.$report[$i]['problem_id'].'" target="_blank">'.$report[$i]['problem_hash'].'</a>'.'</td><td>'.$report[$i]['subject'].'</td><td>'.$report[$i]['ticket_count'].'</td><td>'.$report[$i]['first_name'].' '.$report[$i]['last_name'].'</td><td>'.$report[$i]['domain_name'].'</td><td>'.format_datetime($report[$i]['date_created']).'</td>';
		$html.='</tr></span>';
		} echo $html;?>
		</tbody>
	</table>
<?php
break;
case 'problem_ticket_relation':
?>
	<table class="table table-hover table-striped" id="datatable">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTPROBLEMHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTLINKTICKET'];?></th>
				<th><?php echo $vis_language['TXTPRBFRM'];?></th>
				<th><?php echo $vis_language['TXTDOMAIN'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
			</tr>
		</thead>
		<tbody> 
		<?php
			$html ='';
			for($i=0;$i<count($report);$i++) {
			$html.='<tr><td><a href="#/problem/problems_details/'.$report[$i]['problem_hash'].'/'.$report[$i]['problem_id'].'" target="_blank">'.$report[$i]['problem_hash'].'</a>'.'</td><td>'.$report[$i]['subject'].'</td><td>'.$report[$i]['ticket_count'].'</td><td>'.$report[$i]['first_name'].' '.$report[$i]['last_name'].'</td><td>'.$report[$i]['domain_name'].'</td><td>'.format_datetime($report[$i]['date_created']).'</td>';
			$html.='</tr></span>';
			} echo $html;?>
		</tbody>
	</table>
<?php
break;
case 'problems_report':
?>
	<table class="table table-hover table-striped" id="datatable">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTPROBLEMHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTDOMAIN'];?></th>
				<th><?php echo $vis_language['TXTCREATEDBY'];?></th>
				<th><?php echo $vis_language['TXTIMPACT'];?></th>
				<th><?php echo $vis_language['TXTPRIORITY'];?></th>
				<th><?php echo $vis_language['TXTSTATUS'];?></th>
			</tr>
		</thead>
		<tbody> 
		<?php 
			for($i=0;$i<count($problems_details);$i++) {
				echo '<tr><td><a href="#/problem/problems_details/'.str_replace('/', ' ', $problems_details[$i]['problem_hash']).'/'.$problems_details[$i]['problem_id'].'" target="_blank">'.$problems_details[$i]['problem_hash'].'</a></td>';
				echo '<td >'.$problems_details[$i]['subject'].'</td>';
				echo '<td >'.format_datetime($problems_details[$i]['date_created']).'</td>';
				echo '<td >'.$problems_details[$i]['domain_name'].'</td>';
				echo '<td >'.$problems_details[$i]['first_name'].' '.$problems_details[$i]['last_name'].'</td>';
				echo '<td >'.$problems_details[$i]['impact_name'].'</td>';
				echo '<td >'.$problems_details[$i]['priority_name'].'</td>';
				echo '<td >'.$problems_details[$i]['status_name'].'</td></tr>';
			} ?>
		</tbody>
	</table>
<?php
break;
case 'itil_problemsolved_report':
?>
	<table class="table table-hover table-striped" id="datatable">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTPROBLEMHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTCREATEDBY'];?></th>
				<th><?php echo $vis_language['TXTASSIGNTO'];?> </th>
				<th><?php echo $vis_language['TXTRSLVDATE'];?></th>
				<th><?php echo $vis_language['TXTRESOLVEDBY'];?> </th>
			</tr>
		</thead>
		<tbody> 
		<?php
			$html = '';
			for($i=0;$i<count($report);$i++) {
				if($report[$i]['first_name']==''){ $report[$i]['first_name']= $vis_language['TXTUNASSIGNED'];}
				$html.='<tr><td><a href="#/problem/problems_details/'.$report[$i]['problem_hash'].'/'.$report[$i]['problem_id'].'" target="_blank">'.$report[$i]['problem_hash'].'</a></td><td>'.$report[$i]['subject'].'</td><td>'.$report[$i]['fname'].' '.$report[$i]['lname'].'</td><td>'.$report[$i]['first_name'].' '.$report[$i]['last_name'].'</td><td>'.format_datetime($report[$i]['receive_date']).'</td><td>'.$report[$i]['fst_name'].' '.$report[$i]['lst_name'] .'</td>';
				$html.='</tr></span>';
			} echo $html;?>
		</tbody>
	</table>	
<?php
break;
case 'itil_problems_groupby_status_report':
case 'itil_problems_groupby_priority_report':
case 'itil_problems_groupby_impact_report':
?>
	<table class="table table-hover table-striped" id="datatable">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTPROBLEMHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTPRBFRM'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTDOMAIN'];?></th>
				<th><?php echo $vis_language['TXTIMPACT'];?></th>
				<th><?php echo $vis_language['TXTPRIORITY'];?></th>
				<th><?php echo $vis_language['TXTSTATUS'];?></th>
			</tr>
		</thead>
		<tbody> 
		<?php
				$html='';
				for($i=0;$i<count($report);$i++) {
				$html.='<tr><td><a href="#/problem/problems_details/'.str_replace('/', ' ', $report[$i]['problem_hash']).'/'.$report[$i]['problem_id'].'" target="_blank" >'.$report[$i]['problem_hash'].'</a></td><td>'.$report[$i]['subject'].'</td><td>'.$report[$i]['first_name'].' '.$report[$i]['last_name'].'</td><td>'.format_datetime($report[$i]['date_created']).'</td><td>'.$report[$i]['domain_name'].'</td><td>'.$report[$i]['impact_name'].'</td><td>'.$report[$i]['priority_name'].'</td><td>'.$report[$i]['status_name'].'</td>';
				$html.='</tr></span>';
			} echo $html;?>
		</tbody>
	</table>
<?php
break;
case 'rating_report':
?>
	<table class="table table-hover table-striped" id="datatable">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTRATING'];?></th>
				<?php echo ($custom_grouplist!= -1)?'<th>'.$vis_language['TXTUSERFEEDBACK'].'</th>':'';	?>
			</tr>
		</thead>
		<tbody> 
		<?php
				$html ='';
				for($i=0;$i<count($report);$i++) {
				if($report[$i]['first_name'] =='' && $report[$i]['last_name']=='')
				$client_name = '-';
				else
				$client_name = $report[$i]['first_name'].' '.$report[$i]['last_name'];
				$html.='<tr><td><a target="_blank" href="#/ticket/ticket_details/'.$report[$i]['ticket_hash'].'/'.$report[$i]['ticket_id'].'" target="_blank">'.$report[$i]['ticket_hash'].'</a></td><td>'.$report[$i]['subject'].'</td><td>'.$client_name.'</td><td><a href="#/client/client_details/'.$report[$i]['first_name'].'/'.$report[$i]['client_id'].'" target="_blank">'.$report[$i]['email'].'</a></td><td>'.$report[$i]['group_name'].'</td><td>'.format_datetime($report[$i]['receive_date']).'</td><td>';
				$html.= '<span class="vh-yellow m-l-xs">';
				for($cn=0;$cn<5;$cn++)
				$html.=($cn<$report[$i]['rating'])?'<i class="vh vh-star"></i>':'<i class="vh vh-star-empty"></i>';
				if(isset($rates[$report[$i]['rating']])) $rates[$report[$i]['rating']]++;
				$html.='</td>';
				if($custom_grouplist!= -1) {if(isset($report[$i]['content']) && $report[$i]['content']!=-1) { $html.='<td><a class="link m-l-xs" href="javascript:void(0);" data-toggle="ajaxModal" data-modal-arguments="vis_module=ticket&vis_operation=get_ticket_feedback&vis_static_area=vis_feedback_popup_form&vis_ticket_id='.$report[$i]['ticket_id'] .'&vis_department_id='.$report[$i]['department_id'].'">view</a></td>';}
					else $html.='<td>-</td>';
				}
				$html.='</tr></span>';
			}  		echo $html;?>
		</tbody>
	</table>
<?php
break;
case 'rating_client_report':
?>
	<table class="table table-hover table-striped" id="datatable">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTRATING'];?></th>
				<?php echo ($custom_grouplist!= -1)?'<th>'.$vis_language['TXTUSERFEEDBACK'].'</th>':'';	?>
			</tr>
		</thead>
		<tbody> 
		<?php $html='';  $rates=array();
				for($i=0;$i<count($report);$i++) {
				if($report[$i]['first_name'] =='' && $report[$i]['last_name']=='')
				$client_name = '-';
				else
				$client_name = $report[$i]['first_name'].' '.$report[$i]['last_name'];
				$html.='<tr><td><a target="_blank" href="#/ticket/ticket_details/'.$report[$i]['ticket_hash'].'/'.$report[$i]['ticket_id'].'" target="_blank">'.$report[$i]['ticket_hash'].'</a></td><td>'. $report[$i]['subject'].'</td><td>'.$client_name.'</td><td><a href="#/client/client_details/'.$report[$i]['first_name'].'/'.$report[$i]['client_id'].'" target="_blank">'.$report[$i]['email'].'</a></td><td>'.$report[$i]['group_name'].'</td><td>'.format_datetime($report[$i]['receive_date']).'</td><td>';
				$html.= '<span class="vh-yellow m-l-xs">';
				for($cn=0;$cn<5;$cn++)
				$html.=($cn<$report[$i]['rating'])?'<i class="vh vh-star"></i>':'<i class="vh vh-star-empty"></i>';
				if(isset($rates[$report[$i]['rating']])) $rates[$report[$i]['rating']]++;
				$html.='</td>';
				if($custom_grouplist!= -1) {if(isset($report[$i]['content']) && $report[$i]['content']!=-1) { $html.='<td><a class="link m-l-xs" href="javascript:void(0);" data-toggle="ajaxModal" data-modal-arguments="vis_module=ticket&vis_operation=get_ticket_feedback&vis_static_area=vis_feedback_popup_form&vis_ticket_id='.$report[$i]['ticket_id'] .'&vis_department_id='.$report[$i]['department_id'].'">view</a></td>';}
					else $html.='<td>-</td>';
				}
				$html.='</tr></span>';
			}  		echo $html;?>
		</tbody>
	</table>
<?php
break;
case 'get_survey_report':
?>
	<table class="table table-hover table-striped" id="datatable">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTCLIENT'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
				<th><?php echo $vis_language['TXTSURVEY'];?></th>
				<th><?php echo $vis_language['TXTSURVEYDATE'];?></th>
				<th><?php echo $vis_language['TXTSURVEYFIELD'];?></th>
				<th></th>
			</tr>
		</thead>
		<tbody> 
		<?php
			if($client_details!=-1){
			for($i=0;$i<count($client_details);$i++) {
				?><tr><?php echo '<td target="_blank" class="txt_nowrap"><a href="#/client/client_details/'.$client_details[$i]['first_name'].' '.$client_details[$i]['last_name'].'/'.$client_details[$i]['client_id'].'">'.$client_details[$i]['first_name'].' '.$client_details[$i]['last_name'].'</a></td><td class="txt_nowrap"><a target="_blank" href="#/client/client_details/'.$client_details[$i]['first_name'].' '.$client_details[$i]['last_name'].'/'.$client_details[$i]['client_id'].'">'.$client_details[$i]['email'].'</a></td><td class="txt_nowrap">'.$client_details[$i]['group_name'].'</td><td class="txt_nowrap">'.$custom_group_details_select[0]['customgroup_name'].'</td><td class="txt_nowrap">'.format_datetime($client_details[$i]['entry_date']).'</td>';?>
				<td class="txt_nowrap"><a class="text-muted link" data-toggle="ajaxModal" data-modal-arguments="vis_module=report&vis_operation=display_client_survey&vis_client_id=<?php echo $client_details[$i]['client_id'];?>&vis_survey_id=<?php echo $survey_id;?>&vis_static_area=vis_survey_display_form&vis_dataids='<?php echo base64_encode($client_details[$i]['dataids']);?>'" title="<?php echo $vis_language['TXTVIEW'];?>" href="javascript:void(0);" ><?php  echo $vis_language['TXTVIEW'];?></a></td><td class="txt_nowrap"><a href="index.php?vis_module=report&vis_operation=export_survey&vis_type=pdf&vis_client_id=<?php echo $client_details[$i]['client_id'];?>&vis_survey_id=<?php echo $survey_id;?>&vis_survey_dt=<?php echo format_datetime($dataArr[$client_details[$i]['client_id']]);?>&vis_dataids='<?php echo base64_encode($client_details[$i]['dataids']);?>'" target="_blank" class="link"><?php echo $vis_language['TXTEXPORTTOPDF'];?></a>
				</td></tr>
		   <?php }
			}?>
		</tbody>
	</table>	
<?php
break;
case 'get_client_survey_report':
?>
	<table class="table table-hover table-striped" id="datatable">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTCLIENT'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
				<th><?php echo $vis_language['TXTSURVEY'];?></th>
				<th><?php echo $vis_language['TXTSURVEYDATE'];?></th>
				<th></th>
				<th></th>
			</tr>
		</thead>
		<tbody> 
		<?php
        for($i=0;$i<count($surveyList);$i++) {
            ?><tr><?php echo '<td><a target="_blank" href="#/client/client_details/'.$surveyList[$i]['first_name'].' '.$surveyList[$i]['last_name'].'/'.$surveyList[$i]['client_id'].'">'.$surveyList[$i]['first_name'].' '.$surveyList[$i]['last_name'].'</a> </td><td><a   target="_blank" href="#/client/client_details/'.$surveyList[$i]['first_name'].' '.$surveyList[$i]['last_name'].'/'.$surveyList[$i]['client_id'].'">'.$surveyList[$i]['email'].'</a></td><td>'.$surveyList[$i]['group_name'].'</td><td>'.$surveyList[$i]['customgroup_name'].'</td><td>'.format_datetime($surveyList[$i]['entry_date']).'</td>';?>
					<td><a class="text-muted link" data-toggle="ajaxModal" data-modal-arguments="vis_module=report&vis_operation=display_client_survey&vis_client_id=<?php echo $clientId ?>&vis_survey_id=<?php echo $surveyList[$i]['customgroup_id'];?>&vis_static_area=vis_survey_display_form&vis_dataids='<?php echo base64_encode($surveyList[$i]['dataids']);?>'" title="<?php echo $vis_language['TXTVIEW'];?>" href="javascript:void(0);" ><?php  echo $vis_language['TXTVIEW'];?></a></td>
					<td><a href="index.php?vis_module=report&vis_operation=export_survey&vis_type=pdf&vis_client_id=<?php echo $clientId;?>&vis_survey_id=<?php echo $surveyList[$i]['customgroup_id'];?>&vis_survey_dt=<?php echo format_datetime($surveyList[$i]['entry_date']);?>&vis_dataids='<?php echo base64_encode($surveyList[$i]['dataids']);?>'" target="_blank" class="link"><?php echo $vis_language['TXTEXPORTTOPDF'];?></a>
			</td>
				</tr>
       <?php } ?>
		</tbody>
	</table>							
<?php
break;
case 'releases_report':
?>
	<table class="table table-hover table-striped" id="datatable">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTRELEASEHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTDOMAIN'];?></th>
				<th><?php echo $vis_language['TXTRELEASETYPE'];?></th>
				<th><?php echo $vis_language['TXTPRIORITY'];?></th>
				<th><?php echo $vis_language['TXTSTATUS'];?></th>
			</tr>
		</thead>
		<tbody> 
		<?php for($i=0;$i<count($releases_details);$i++) {
				echo '<tr><td><a href="#/releases/releases_details/'.str_replace('/', ' ', $releases_details[$i]['release_hash']).'/'.$releases_details[$i]['release_id'].'" target="_blank">'.$releases_details[$i]['release_hash'].'</a></td>';
				echo '<td>'.$releases_details[$i]['subject'].'</td>';
				echo '<td>'.format_datetime($releases_details[$i]['date_created']).'</td>';
				echo '<td>'.$releases_details[$i]['domain_name'].'</td>';
				echo '<td>'.$releases_details[$i]['release_type'].'</td>';
				echo '<td>'.$releases_details[$i]['priority_name'].'</td>';
				echo '<td>'.$releases_details[$i]['status_name'].'</td></tr>';
			} ?>
		</tbody>
	</table>	
<?php
break;
case 'releases_linkedto_changes_report':
?>
	<table class="table table-hover table-striped" id="datatable">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTCHANGEHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTRELEASEHASH'];?></th>
				<th><?php echo $vis_language['TXTCREATEDBY'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
			</tr>
		</thead>
		<tbody> 
		<?php
			$html ='';
			for($i=0;$i<count($report);$i++) {
				$html.='<tr><td><a href="#/changes/changes_details/'.$report[$i]['changes_hash'].'/'.$report[$i]['changes_id'].'" target="_blank">'.$report[$i]['changes_hash'].'</a></td><td>'.$report[$i]['subject'].'</td><td><a href="#/releases/releases_details/'.$report[$i]['release_hash'].'/'.$report[$i]['release_id'].'" target="_blank">'.$report[$i]['release_hash'].'</td><td>'.$report[$i]['first_name'].' '.$report[$i]['last_name'].'</td><td>'.format_datetime($report[$i]['date_created']).'</td>';
				$html.='</tr></span>';

			} echo $html;?>
		</tbody>
	</table>
<?php
break;
case 'release_ticket_trend_analysis':
?>
	<table class="table table-hover table-striped" id="datatable">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTRELEASEHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTTICKETCOUNT'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTDOMAIN'];?></th>
				<th><?php echo $vis_language['TXTRELEASETYPE'];?></th>
				<th><?php echo $vis_language['TXTPRIORITY'];?></th>
				<th><?php echo $vis_language['TXTSTATUS'];?></th>
			</tr>
		</thead>
		<tbody> 
		<?php for($i=0;$i<count($releases_details);$i++) {
			echo '<tr><td><a href="#/releases/releases_details/'.str_replace('/', ' ', $releases_details[$i]['release_hash']).'/'.$releases_details[$i]['release_id'].'" target="_blank">'.$releases_details[$i]['release_hash'].'</a></td>';
			echo '<td class="txt_nowrap">'.$releases_details[$i]['subject'].'</td>';
			echo '<td class="txt_nowrap">'.$releases_details[$i]['ticket_count'].'</td>';
			echo '<td class="txt_nowrap">'.format_datetime($releases_details[$i]['date_created']).'</td>';
			echo '<td class="txt_nowrap">'.$releases_details[$i]['domain_name'].'</td>';
			echo '<td class="txt_nowrap">'.$releases_details[$i]['release_type'].'</td>';
			echo '<td class="txt_nowrap">'.$releases_details[$i]['priority_name'].'</td>';
			echo '<td class="txt_nowrap">'.$releases_details[$i]['status_name'].'</td></tr>';
		} ?>
		</tbody>
	</table>
<?php
break;
case 'itil_releases_groupby_status_report':
case 'itil_releases_groupby_priority_report':
case 'itil_releases_groupby_impact_report':
?>
	<table class="table table-hover table-striped" id="datatable">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTRELEASEHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTDOMAIN'];?></th>
				<th><?php echo $vis_language['TXTRELEASETYPE'];?></th>
				<th><?php echo $vis_language['TXTIMPACT'];?></th>
				<th><?php echo $vis_language['TXTPRIORITY'];?></th>
				<th><?php echo $vis_language['TXTRISK'];?></th>
				<th><?php echo $vis_language['TXTSTATUS'];?></th>
				<th><?php echo $vis_language['TXTURGENCY'];?></th>
			</tr>
		</thead>
		<tbody> 
		<?php   for($i=0;$i<count($releases_details);$i++) {
				echo '<tr><td><a href="#/releases/releases_details/'.str_replace('/', ' ', $releases_details[$i]['release_hash']).'/'.$releases_details[$i]['release_id'].'" target="_blank">'.$releases_details[$i]['release_hash'].'</a></td>';
				echo '<td>'.$releases_details[$i]['subject'].'</td>';
				echo '<td>'.format_datetime($releases_details[$i]['date_created']).'</td>';
				echo '<td>'.$releases_details[$i]['domain_name'].'</td>';
				echo '<td>'.$releases_details[$i]['release_type'].'</td>';
				echo '<td>'.$releases_details[$i]['impact_name'].'</td>';
				echo '<td>'.$releases_details[$i]['priority_name'].'</td>';
				echo '<td>'.$releases_details[$i]['risk_name'].'</td>';
				echo '<td>'.$releases_details[$i]['status_name'].'</td>';
				echo '<td>'.$releases_details[$i]['urgency_type'].'</td>';
				echo '</tr>';
				} ?>
		</tbody>
	</table>
<?php
break;
case 'changes_report':
?>
	<table class="table table-hover table-striped" id="datatable">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTCHANGEHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTDOMAIN'];?></th>
				<th><?php echo $vis_language['TXTCHANGETYPE'];?></th>
				<th><?php echo $vis_language['TXTIMPACT'];?></th>
				<th><?php echo $vis_language['TXTPRIORITY'];?></th>
				<th><?php echo $vis_language['TXTRISK'];?></th>
				<th><?php echo $vis_language['TXTSTATUS'];?></th>
				<th><?php echo $vis_language['TXTURGENCY'];?></th>
				<th><?php echo $vis_language['TXTLOCATION'];?></th>
				<th> <? echo $vis_language['TXTITILREQUEST'].' '.strtolower($vis_language['TXTTIME']); ?></th>
				<th><?php echo $vis_language['TXTCLOSINGTIME'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php   
			for($i=0;$i<count($changes_details);$i++) {
				echo '<tr><td><a href="#/changes/changes_details/'.str_replace('/', ' ', $changes_details[$i]['changes_hash']).'/'.$changes_details[$i]['changes_id'].'" target="_blank">'.$changes_details[$i]['changes_hash'].'</a></td>';
				echo '<td>'.$changes_details[$i]['subject'].'</td>';
				echo '<td>'.format_datetime($changes_details[$i]['date_created']).'</td>';
				echo '<td>'.$changes_details[$i]['domain_name'].'</td>';
				echo '<td>'.$changes_details[$i]['change_type'].'</td>';
				echo '<td>'.$changes_details[$i]['impact_name'].'</td>';
				echo '<td>'.$changes_details[$i]['priority_name'].'</td>';
				echo '<td>'.$changes_details[$i]['risk_name'].'</td>';
				echo '<td>'.$changes_details[$i]['status_name'].'</td>';
				echo '<td>'.$changes_details[$i]['urgency_type'].'</td>';
				if(defined('AGENTTYPE') && (AGENTTYPE=='VIS_PROSD' || AGENTTYPE=='VIS_ENTSD'))
					echo '<td>'.$changes_details[$i]['location_name'].'</td>';
				echo '<td>'.format_datetime($changes_details[$i]['request_time']).'</td>';
				echo '<td>'.format_datetime($changes_details[$i]['closing_time']).'</td>';
				echo '</tr>';
			} ?>
	</tbody>
	</table>
<?php
break;
case 'changes_resolvedby_staff_report':
?>
	<table class="table table-hover table-striped" id="datatable">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTCHANGEHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTCREATEDBY'];?></th>
				<th><?php echo $vis_language['TXTASSIGNTO'];?> </th>
				<th><?php echo $vis_language['TXTRSLVDATE'];?></th>
				<th><?php echo $vis_language['TXTRESOLVEDBY'];?> </th>
			</tr>
		</thead>
		<tbody>
			<?php
			$html = '';
			for($i=0;$i<count($report);$i++) {
				if($report[$i]['first_name']==''){ $report[$i]['first_name']= $vis_language['TXTUNASSIGNED'];}
				$html.='<tr><td><a href="#/changes/changes_details/'.$report[$i]['changes_hash'].'/'.$report[$i]['changes_id'].'" target="_blank">'.$report[$i]['changes_hash'].'</a></td><td>'.$report[$i]['subject'].'</td><td>'.$report[$i]['fname'].' '.$report[$i]['lname'].'</td><td>'.$report[$i]['first_name'].' '.$report[$i]['last_name'].'</td><td>'.format_datetime($report[$i]['receive_date']).'</td><td>'.$report[$i]['frst_name'].' '.$report[$i]['lst_name'] .'</td>';
				$html.='</tr></span>';
			}  		echo $html;?>
	</tbody>
	</table>
<?php
break;
case 'itil_changes_groupby_status_report':
case 'itil_changes_groupby_priority_report':
case 'itil_changes_groupby_impact_report':
?>
	<table class="table table-hover table-striped" id="datatable">
		<thead>
			<tr role="row">
				<tr role="row">
				<th><?php echo $vis_language['TXTCHANGEHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTDOMAIN'];?></th>
				<th><?php echo $vis_language['TXTCHANGETYPE'];?></th>
				<th><?php echo $vis_language['TXTIMPACT'];?></th>
				<th><?php echo $vis_language['TXTPRIORITY'];?></th>
				<th><?php echo $vis_language['TXTRISK'];?></th>
				<th><?php echo $vis_language['TXTSTATUS'];?></th>
				<th><?php echo $vis_language['TXTURGENCY'];?></th>
				<th><?php echo $vis_language['TXTLOCATION'];?></th>
				<th> <? echo $vis_language['TXTITILREQUEST'].' '.strtolower($vis_language['TXTTIME']); ?></th>
				<th><?php echo $vis_language['TXTCLOSINGTIME'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php   for($i=0;$i<count($changes_details);$i++) {
					echo '<tr><td><a href="#/changes/changes_details/'.str_replace('/', ' ', $changes_details[$i]['changes_hash']).'/'.$changes_details[$i]['changes_id'].'" target="_blank">'.$changes_details[$i]['changes_hash'].'</a></td>';
					echo '<td>'.$changes_details[$i]['subject'].'</td>';
					echo '<td>'.format_datetime($changes_details[$i]['date_created']).'</td>';
					echo '<td>'.$changes_details[$i]['domain_name'].'</td>';
					echo '<td>'.$changes_details[$i]['change_type'].'</td>';
					echo '<td>'.$changes_details[$i]['impact_name'].'</td>';
					echo '<td>'.$changes_details[$i]['priority_name'].'</td>';
					echo '<td>'.$changes_details[$i]['risk_name'].'</td>';
					echo '<td>'.$changes_details[$i]['status_name'].'</td>';
					echo '<td>'.$changes_details[$i]['urgency_type'].'</td>';
					echo '<td>'.$changes_details[$i]['location_name'].'</td>';
					if(defined('AGENTTYPE') && (AGENTTYPE=='VIS_PROSD' || AGENTTYPE=='VIS_ENTSD'))
					echo '<td>'.format_datetime($changes_details[$i]['request_time']).'</td>';
					echo '<td>'.format_datetime($changes_details[$i]['closing_time']).'</td>';
					echo '</tr>';
					} ?>
	</tbody>
	</table>
<?php
break;
case 'changes_ci_relation_report':
?>
	<table class="table table-hover table-striped" id="datatable">
		<thead>
			<tr role="row">
				<tr role="row">
				<th><?php echo $vis_language['TXTCHANGEHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTFROM'];?></th>
				<th><?php echo $vis_language['TXTDOMAIN'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTATTACHCI'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			$html ='';
			for($i=0;$i<count($report);$i++) {
				if($report[$i]['ci_name']==''){ $report[$i]['ci_name'] = '-';}
				$html.='<tr><td><a href="#/changes/changes_details/'.$report[$i]['changes_hash'].'/'.$report[$i]['changes_id'].'" target="_blank">'.$report[$i]['changes_hash'].'</a>'.'</td><td>'.$report[$i]['subject'].'</td><td>'.$report[$i]['first_name'].' '.$report[$i]['last_name'].'</td><td>'.$report[$i]['domain_name'].'</td><td>'.format_datetime($report[$i]['date_created']).'</td><td>'.str_replace(',',',</br>',$report[$i]['ci_name']).'</td>';
				$html.='</tr></span>';
			}  	echo $html;?>
	</tbody>
	</table>
<?php
break;
case 'change_ticket_trend_analysis':
?>
	<table class="table table-hover table-striped" id="datatable">
		<thead>
			<tr role="row">
				<tr role="row">
				<th><?php echo $vis_language['TXTCHANGEHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTTICKETCOUNT'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTDOMAIN'];?></th>
				<th><?php echo $vis_language['TXTCHANGETYPE'];?></th>
				<th><?php echo $vis_language['TXTIMPACT'];?></th>
				<th><?php echo $vis_language['TXTPRIORITY'];?></th>
				<th><?php echo $vis_language['TXTRISK'];?></th>
				<th><?php echo $vis_language['TXTSTATUS'];?></th>
				<th><?php echo $vis_language['TXTURGENCY'];?></th>
				<th><?php echo $vis_language['TXTLOCATION'];?></th>
				<th> <? echo $vis_language['TXTITILREQUEST'].' '.strtolower($vis_language['TXTTIME']); ?></th>
				<th><?php echo $vis_language['TXTCLOSINGTIME'];?></th>
			</tr>
		</thead>
		<tbody>
	<?php   for($i=0;$i<count($changes_details);$i++) {
			echo '<tr><td><a href="#/changes/changes_details/'.str_replace('/', ' ', $changes_details[$i]['changes_hash']).'/'.$changes_details[$i]['changes_id'].'" target="_blank">'.$changes_details[$i]['changes_hash'].'</a></td>';
			echo '<td>'.$changes_details[$i]['subject'].'</td>';
			echo '<td>'.$changes_details[$i]['ticket_count'].'</td>';
			echo '<td>'.format_datetime($changes_details[$i]['date_created']).'</td>';
			echo '<td>'.$changes_details[$i]['domain_name'].'</td>';
			echo '<td>'.$changes_details[$i]['change_type'].'</td>';
			echo '<td>'.$changes_details[$i]['impact_name'].'</td>';
			echo '<td>'.$changes_details[$i]['priority_name'].'</td>';
			echo '<td>'.$changes_details[$i]['risk_name'].'</td>';
			echo '<td>'.$changes_details[$i]['status_name'].'</td>';
			echo '<td>'.$changes_details[$i]['urgency_type'].'</td>';
			echo '<td>'.$changes_details[$i]['location_name'].'</td>';
			echo '<td>'.format_datetime($changes_details[$i]['request_time']).'</td>';
			echo '<td>'.format_datetime($changes_details[$i]['closing_time']).'</td>';
			echo '</tr>';
			} ?>
	</tbody>
	</table>					
<?php
break;
case 'response_report':
?>
	<table class="table table-hover table-striped" id="datatable">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTAVGRESPONSE'];?></th>
				<!--<th><?php //echo $vis_language['TXTRESPONSESLA'];?></th>--->
			</tr>
		</thead>
		<tbody><?php
		foreach($report_new as $ticket_id => $details){ ?><tr role="row"><td><a target="_blank" href="#/ticket/ticket_details/<?php echo $details['ticket_hash'];?>/<?php echo $details['ticket_id'];?>"><?php echo $details['ticket_hash'];?></a></td><td><?php echo (strlen($details['subject'])>60) ? mb_substr($details['subject'], 0, 60).'...' : $details['subject'];?></td><td><?php echo format_datetime($details['ticket_entry']);?></td><td><?php
		if(isset($details['slapause_diff'])){ $sla_diff = $details['slapause_diff'];}else{ $sla_diff=0;}
		if(($details['timestamp']==0 || $details['timestamp']<0) && $details['count']!=0){
			$timestamp = '0S';
		}elseif($details['count']==0&&$details['operator']==2&&$details['as_client']==0){
			$timestamp = '0S';
		}elseif($details['count']==0){
			$timestamp = $vis_language['TXTNOTRESPONDED'];
		}else{
			$timestamp = count_remain_time(round(($details['timestamp']-$sla_diff)/$details['count']));
		}
		if(isset($details['clientreplycnt']) && $details['clientreplycnt']==0) $timestamp = '0S';
		echo $timestamp;
		?></td>
		<!-----<td><?php //if($details['count']==0){ echo "NA"; }else{ echo $details['response_sla']; } ?></td>---->
		</tr><?php
	} ?>
	</tbody>
	</table>
<?php
break;
case 'resolution_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTRESOLUTIONTIME'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php   
			foreach($report_new as $ticket_id => $details){ 							 	 
				echo '<tr><td ><a href="#/ticket/ticket_details/'.$details['ticket_hash'].'/'.$details['ticket_id'].'" target="_blank">'.$details['ticket_hash'].'</a> </td><td >'.$details['subject'].'</td>  <td>'.format_datetime($details['ticket_entry']).'</td> <td>';
				if(isset($details['status_id']) &&($details['status_id']==4 || $details['status_id']==3)){
					echo (isset($details['avg_resolution_time']) && $details['avg_resolution_time'] !='' )?$details['avg_resolution_time']:"Not resolved";  
				} 	else{
					echo $details['avg_resolution_time'] ;

				}
				echo '</td> </tr>';
			} ?>
		</tbody>
	</table>
<?php
break;
case 'performance_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
			<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
			<th><?php echo $vis_language['TXTSUBJECT'];?></th>
			<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
			<th><?php echo $vis_language['TXTAVGRESPONSE'];?></th>
			<th><?php echo $vis_language['TXTRESPONSESLA'];?></th>
			</tr>
		</thead>
		<tbody><?php 
			foreach($report_new as $ticket_id => $details){ ?><tr role="row"><td><a target="_blank" href="#/ticket/ticket_details/<?php echo $details['ticket_hash'];?>/<?php echo $details['ticket_id'];?>"><?php echo $details['ticket_hash'];?></a></td><td><?php echo (strlen($details['subject'])>60) ? mb_substr($details['subject'], 0, 60).'...' : $details['subject'];?></td><td><?php echo format_datetime($details['ticket_entry']);?></td><td><?php
					if(isset($details['slapause_diff'])){ $sla_diff = $details['slapause_diff'];}else{ $sla_diff=0;}
						if(isset($details['avg_time']) && $details['avg_time']!=0 && $details['count']!=0){
								$timestamp = count_remain_time(round(abs($details['avg_time']/$details['count'])));	
							}else{
							 if($details['count']==0){
								if($details['operator'] == 2 && $details['as_client'] != 1){
									$timestamp = '0 S';
								}else{
									$timestamp = $vis_language['TXTNOTRESPONDED'];
								}
							 }else{$timestamp = '0 S';}
							}
							if(isset($details['clientreplycnt']) && $details['clientreplycnt']==0) {$timestamp = '0 S';}
					echo $timestamp;						   
				?></td>
			<td><?php echo $details['response_sla'];?></td></tr><?php
			} ?>
		</tbody>
	</table>
<?php
break;
case 'first_response_report':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
			<th><?php echo $vis_language['TXTSUBJECT'];?></th>
			<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
			<th><?php echo $vis_language['TXTREPLYDATE'];?></th>
			<th><?php echo $vis_language['TXTFIRSTRESPONSE'];?></th>
			<!-- <th><?php echo $vis_language['TXTRESPONSESLA'];?></th> -->
		</tr>
	</thead>
	<tbody>
		<?php
		foreach($report_new as $ticket_id => $details){ ?>
			<tr role="row">
				<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $details['ticket_hash'];?>/<?php echo $details['ticket_id'];?>"><?php echo $details['ticket_hash'];?></a></td>
				<td><?php echo $details['subject'];?></td>
				<td><?php echo format_datetime($details['ticket_entry']);?></td>
				<td><?php echo format_datetime($details['start_time']);?></td>
				<td><?php
					$time=$details['timestamp'];
					echo ($details['timestamp']!=0) ? count_remain_time($time, true) : '0S';//$vis_language['TXTNOTRESPONDED'];?>
				</td>
				<!-- <td><?php echo $details['response_sla'];?></td> -->
			</tr><?php
		}
		?>
	</tbody>
</table>	
<?php
break;
case 'dept_report':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
			<th><?php echo $vis_language['TXTSUBJECT'];?></th>
			<th><?php echo $vis_language['TXTSTAFF'];?></th>
			<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
			<th><?php echo $vis_language['TXTCLOSINGDATE'];?></th>
			<th><?php echo $vis_language['TXTSTATUS'];?></th>
			<th><?php echo $vis_language['TXTRESOLUTIONTSLA'];?></th>
			<th><?php echo $vis_language['TXTAFTER'].' '.$vis_language['TXTOVERDUETIME'];?></th>     
		</tr>
	</thead>
	<tbody>
		<?php
		foreach($report as $ticket_id => $details){ ?>
			<tr role="row">
				<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $details['ticket_hash'];?>/<?php echo $details['ticket_id'];?>"><?php echo $details['ticket_hash'];?></a></td>
				<td><?php echo $details['subject'];?></td>
				<td><?php echo $details['first_name'].' '.$details['last_name'];?></td>
				<td><?php echo format_datetime($details['ticket_entry']);?></td>
				<td><?php echo format_datetime($details['ticket_closed']);?></td>
				<td><?php echo $details['status_name'];?></td>
				<td><?php 
					echo (isset($details['resolution_sla']) && $details['resolution_sla'] !='' ) ? $details['resolution_sla']: $vis_language['TXTNOTMAINTAIN']; 
				?></td>
				<td><?php   
				 echo (($details['resolution_time']< $details['closed_time']) && $details['closed_time']!='' &&  $details['resolution_time']!=0) ? count_remain_time($details['closed_time']-$details['resolution_time']):'0s'; ?></td>
			</tr><?php
		}
		?>
	</tbody>
</table>								
<?php
break;
case 'work_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTDOMAIN'];?></th>
				<th><?php echo $vis_language['TXTDEPARTMENT'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTOPERATION'].' '.strtolower($vis_language['TXTDATE']);?></th>
				<th><?php echo $vis_language['TXTOPERATION'];?></th>
			</tr>
		</thead>
		<tbody><?php
			for($i=0;$i<count($report);$i++){ ?>
				<tr role="row">
					<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $report[$i]['ticket_hash'];?>/<?php echo $report[$i]['ticket_id'];?>"><?php echo $report[$i]['ticket_hash'];?></a></td>
					<td><?php echo $report[$i]['domain'];?></td>
					<td><?php echo $report[$i]['department_name'];?></td>
					<td><?php echo format_datetime($report[$i]['creation_date']);?></td>
					<td><?php echo format_datetime($report[$i]['entry_date']);?></td>
					<td><?php echo (strlen($report[$i]['audit_log_operation'])>60) ? mb_substr($report[$i]['audit_log_operation'], 0, 60).'...' : $report[$i]['audit_log_operation'];?></td>
				</tr><?php
			} ?>
		</tbody>
	</table>
<?php
break;
case 'staff_resolution_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTRESOLUTIONTIME'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
				foreach($report as $ticket_id => $details) { ?>
					<tr role="row">
						<td><a href="#/ticket/ticket_details/<?php echo $details['ticket_hash'];?>/<?php echo $details['ticket_id'];?>" target="_blank"><?php echo $details['ticket_hash'];?></a></td>
						<td><?php echo (strlen($details['subject'])>60) ? mb_substr($details['subject'], 0, 60).'...' : $details['subject'];?></td>
						<td><?php echo format_datetime($details['ticket_entry']);?></td>
						<td><?php echo  count_remain_time($details['resoltion_time']); ?></td>							
					</tr><?php
					}
				?>
		</tbody>
	</table>
<?php
break;
case 'not_answered_ticket_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTCONTACTNUMBER'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++){
				if($report[$i]['first_name'] =='' && $report[$i]['last_name']=='')
					$client_name = '-';
				else
					$client_name = $report[$i]['first_name'].' '.$report[$i]['last_name'];

				$contact_number = ($report[$i]['contact_number']!='') ? $report[$i]['contact_number'] : '---';
				?>
				<tr role="row">
					<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $report[$i]['ticket_hash'];?>/<?php echo $report[$i]['ticket_id'];?>"><?php echo $report[$i]['ticket_hash'];?></a></td>
					<td><?php echo $report[$i]['subject'];?></td>
					<td><?php echo $contact_number;?></td>
					<td><?php echo format_datetime($report[$i]['receive_date']);?></td>
					<td><?php echo $client_name;?></td>
					<td><?php echo $report[$i]['email'];?></td>
					<td><?php echo $report[$i]['group_name'];?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>
<?php
break;
case 'channel_wise_tickets_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTCREATEDATE'];?></th>
				<th><?php echo $vis_language['TXTDEPARTMENT'];?></th>
				<th><?php echo $vis_language['CHNLNAME'];?></th>
				<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++) { ?>
				<tr role="row">
					<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $report[$i]['ticket_hash']?>/<?php echo $report[$i]['ticket_id']?>"><?php echo $report[$i]['ticket_hash']?></a></td>
					<td><?php echo $report[$i]['subject'];?></td>
					<td><?php echo format_datetime($report[$i]['receive_date']);?></td>
					<td><?php echo $report[$i]['department_name'];?></td>
					<td><?php echo $report[$i]['channel_name'];?></td>
					<td><?php echo $report[$i]['first_name'].' '.$report[$i]['last_name'];?></td>
					<td><?php echo $report[$i]['email'];?></td>
					<td><?php echo $report[$i]['group_name'];?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>
<?php
break;
case 'unoverdue_ticket_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTDEPARTMENTNAME'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTSTATUS'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++){
				$setUndue = 0;
				?>
				<tr role="row">
					<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $report[$i]['ticket_hash'];?>/<?php echo $report[$i]['ticket_id'];?>"><?php echo $report[$i]['ticket_hash'];?></a></td>
					<td><?php echo $report[$i]['subject'];?></td>
					<td><?php echo $report[$i]['department_name'];?></td>
					<td><?php echo format_datetime($report[$i]['receive_date']);?></td>
					<td><?php echo $report[$i]['status_name'];?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>
<?php
break;
case 'ticket_replied_by_staff_report':
?>
	<table class="table table-hover table-striped" id="datatable">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th class="txt_nowrap"><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['vis_ticket_post_count'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			foreach($report as $ticket_id => $details){ ?>
				<tr role="row">
					<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $details['ticket_hash'];?>/<?php echo $details['ticket_id'];?>"><?php echo $details['ticket_hash']?></a></td>
					<td><?php echo (strlen($details['subject'])>60) ? mb_substr($details['subject'], 0, 60).'...' : $details['subject'];?></td>
					<td><?php echo $details['fname'].' '.$details['lname'];?></td>
					<td><?php echo $details['email'];?></td>
					<td><?php echo $details['group_name'];?></td>
					<td><?php echo format_datetime($details['create_date']);?></td>
					<td><?php echo $details['totalpost'];?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>
<?php
break;
case 'staff_leaderboard_first_avgresponse_report':
?>
	<table class="table table-hover table-striped" id="datatable">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTSTAFFNAME'];?></th>
				<th><?php echo $vis_language['TXTSOLVEDTICKETS'];?></th>
				<th><?php echo $vis_language['AVGFIRSTREPLY'];?></th>
			</tr>
		</thead>
		<tbody><?php
			foreach($report as $report_row){ ?>
				<tr role="row">
					<td><?php echo $report_row['staff_name'];?></td>
					<td><?php echo $report_row['total_ticket_count'];?></td>
					<td><?php echo $report_row['avgFirstresponse'];?></td>
				</tr><?php
			} ?></tbody>
		</table>
<?php
break;
case 'ticket_forwarded_by_staff_report':
?>
	<table class="table table-hover table-striped" id="datatable">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTFORWARDCOUNT'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			foreach($report as $ticket_id => $details){ ?>
				<tr role="row">
					<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $details['ticket_hash'];?>/<?php echo $details['ticket_id'];?>"><?php echo $details['ticket_hash']?></a></td>
					<td><?php echo (strlen($details['subject'])>60) ? mb_substr($details['subject'], 0, 60).'...' : $details['subject'];?></td>
					<td><?php echo $details['fname'].' '.$details['lname'];?></td>
					<td><?php echo $details['email'];?></td>
					<td><?php echo $details['group_name'];?></td>
					<td><?php echo format_datetime($details['create_date']);?></td>
					<td><?php echo $details['totalpost'];?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>
<?php
break;
case 'time_tracking_department_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTDESCRIPTION'];?></th>
				<th><?php echo $vis_language['TXTSTAFF'];?></th>
				<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTBILLTIME'].' ('.$vis_language['TXTMIN'].')';?></th>
				<th><?php echo $vis_language['TXTWORKTIME'].' ('.$vis_language['TXTMIN'].')';?></th>
				<th><?php echo $vis_language['TXTAMOUNT'].' ('.$currency.')';?></th>
			</tr>
		</thead>
		<tbody>
			<?php  
			foreach($report as $ticket_id => $details){ ?>
				<tr role="row">
					<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $details['ticket_hash'];?>/<?php echo $details['ticket_id'];?>" target="_blank"><?php echo $details['ticket_hash']?></a></td>
					<td><?php echo $details['subject'];?></td>
					<td><?php echo $details['description'];?></td>
					<td><?php echo $details['staff_name'];?></td>
					<td><?php echo $details['first_name'].' '.$details['last_name'];?></td>
					<td><a href="#/client/client_details/<?php echo $details['first_name'].'/'.$details['client_id']; ?>" target="_blank" ><?php echo $details['email'];?></a></td>
					<td><?php echo $details['group_name'];?></td>
					<td><?php echo format_datetime($details['created_date']);?></td>
					<td><?php echo $details['bill_time'];?></td>
					<td><?php echo $details['work_time'];?></td>
					<td><?php echo $details['amount'];?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>		
<?php
break;
case 'ticket_activity_report':
?>
	<table class="table table-hover table-striped" id="datatable">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTOPERATION'];?></th>
				<th><?php echo $vis_language['TXTOPERATOR'];?></th>
				<th><?php echo $vis_language['TXTOPERATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTDEPARTMENT'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($audit_log);$i++){
				$name=''; if($audit_log[$i]['operator_id']!= -1){ $name = $vis_language['TXTWORKFLOW']; }else { $name =$vis_language['TXTROUNDROBIN']; }
				 ?>
				<tr role="row">
					<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $audit_log[$i]['ticket_hash'];?>/<?php echo $audit_log[$i]['ticket_id'];?>"><?php echo $audit_log[$i]['ticket_hash'];?></a></td>
					<td><?php echo $audit_log[$i]['subject'];?></td>
					<td><?php echo $audit_log[$i]['audit_log_operation'];?></td>
					<td><?php echo (($audit_log[$i]['workflow_id']!=0 || (($audit_log[$i]['operator']==4 )))? 
		 ($audit_log[$i]['workflow_id']!=0)? $vis_language['TXTSYSTEM'].' ('.$name.' - '.$audit_log[$i]['workflow_name'].')': $vis_language['TXTSYSTEM']:($operators[$audit_log[$i]['operator']].' ('.$audit_log[$i]['operators'].')')); ?>
					</td>
					<td><?php echo format_datetime($audit_log[$i]['entry_date']);?></td>
					<td><?php echo $audit_log[$i]['department_name'];?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>
<?php
break;
case 'ticket_linking_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
				<th><?php echo $link[$post_details[0]['link_type']];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($post_details);$i++) {
				if($post_details[$i]['first_name'] =='' && $post_details[$i]['last_name']=='')
					$client_name = '-';
				else
					$client_name = $post_details[$i]['first_name'].' '.$post_details[$i]['last_name'];
				?>
				<tr role="row">
					<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $post_details[$i]['ticket_hash'];?>/<?php echo $post_details[$i]['ticket_id'];?>"><?php echo $post_details[$i]['ticket_hash'];?></a></td>
					<td><?php echo $post_details[$i]['subject'];?></td>
					<td><?php echo format_datetime($post_details[$i]['receive_date']);?></td>
					<td><?php echo $client_name;?></td>
					<td><?php echo $post_details[$i]['email'];?></td>
					<td><?php echo $post_details[$i]['group_name'];?></td>
					<td><?php echo $post_details[$i]['link_ticket_hash'];?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>	
<?php
break;
case 'deleted_tickets_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTSTAFFNAME'];?></th>
				<th><?php echo $vis_language['TXTDELETEDATE'];?></th>
				<th><?php echo $vis_language['TXTDEPARTMENT'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++){ ?>
				<tr role="row">
					<td><?php echo $report[$i]['ticket_hash'];?></td>
					<td><?php echo $report[$i]['subject'];?></td>
					<td><?php echo $report[$i]['first_name'].' '.$report[$i]['last_name'];?></td>
					<td><?php echo format_datetime($report[$i]['receive_date']);?></td>
					<td><?php echo $report[$i]['department_name'];?>
					</td>
				</tr><?php
			}
			?>
		</tbody>
	</table>
<?php
break;
case 'overdue_tickets_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTOVERDUE'].' '.strtolower($vis_language['TXTSINCE']);?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++){
				if($report[$i]['first_name'] =='' && $report[$i]['last_name']=='')
					$client_name = '-';
				else
					$client_name = $report[$i]['first_name'].' '.$report[$i]['last_name'];
				?>
				<tr role="row">
					<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $report[$i]['ticket_hash'];?>/<?php echo $report[$i]['ticket_id'];?>"><?php echo $report[$i]['ticket_hash'];?></a></td>
					<td><?php echo $report[$i]['subject'];?></td>
					<td><?php echo $client_name;?></td>
					<td><?php echo $report[$i]['email'];?></td>
					<td><?php echo $report[$i]['group_name'];?></td>
					<td><?php echo format_datetime($report[$i]['receive_date']);?></td>
					<td><?php echo format_datetime($report[$i]['due_time']);?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>	
<?php
break;
case 'total_unresolved_incidents':
?>
<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTSTATUS'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			foreach($report as $ticket_id => $details){
				if($details['fname'] =='' && $details['lname']=='')
					$client_name = '-';
				else
					$client_name = $details['fname'].' '.$details['lname'];
				?>
				<tr role="row">
					<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $details['ticket_hash'];?>/<?php echo $details['ticket_id'];?>"><?php echo $details['ticket_hash'];?></a></td>
					<td><?php echo $details['subject'];?></td>
					<td><?php echo $client_name;?></td>
					<td><?php echo $details['email'];?></td>
					<td><?php echo $details['group_name'];?></td>
					<td><?php echo format_datetime($details['ticket_entry']);?></td>
					<td><?php echo $details['status_name'];?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>	

<?php
break;
case 'ticket_count_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th> 			  
				<th><?php echo $vis_language['TXTCLOSE'];?></th>
				<th><?php echo $vis_language['TXTRPTRRESOLVED'];?></th>
				<th><?php echo $vis_language['TXTPENDING'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<$report_count;$i++){ ?>
				<tr role="row">
					<td><?php echo $report_new[$i]['week_date'];?></td>
					<td><?php echo $report_new[$i]['close'];?></td>
					<td><?php echo $report_new[$i]['resolved'];?></td>
					<td><?php echo $report_new[$i]['pending_user'];?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>
<?php
break;
case 'category_total_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTRPTRCATGRYTITLE'];?></th> 		 
				<th><?php echo $vis_language['TXTTOTAL'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report_new);$i++){ ?>
				<tr role="row">
					<td><?php echo $report_new[$i]['category_title'];?></td>
					<td><?php echo $report_new[$i]['ticketcategoryCnt'];?></td>
				</tr><?php
			} ?>
		</tbody>
	</table>
<?php
break;
case 'incident_count_by_priority':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTRPTRPRIORITYTITLE'];?></th> 		 
				<th><?php echo $vis_language['TXTTOTAL'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++){ ?>
				<tr role="row">
					<td><?php echo $report[$i]['priority_title'];?></td>
					<td><?php echo $report[$i]['total'];?></td>
				</tr><?php
			} ?>
		</tbody>
	</table>	
<?php
break;
case 'incident_count_by_type':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTRPTRTYPETITLE'];?></th> 		 
				<th><?php echo $vis_language['TXTTOTAL'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++){ ?>
				<tr role="row">
					<td><?php echo $report[$i]['type_title'];?></td>
					<td><?php echo $report[$i]['total'];?></td>
				</tr><?php
			} ?>
		</tbody>
	</table>										
<?php
break;
case 'merged_tickets_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTSTAFFNAME'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTMERGEDDATE'];?></th>
				<th><?php echo $vis_language['TXTMERGETICKET'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++){ ?>
				<tr role="row">
					<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $report[$i]['ticket_hash'];?>/<?php echo $report[$i]['ticket_id'];?>"><?php echo $report[$i]['ticket_hash'];?></a></td>
					<td><?php echo $report[$i]['subject'];?></td>
					<td><?php echo $report[$i]['first_name'].' '.$report[$i]['last_name'];?></td>
					<td><?php echo format_datetime($report[$i]['creation_date']);?></td>
					<td><?php echo format_datetime($report[$i]['receive_date']);?></td>
					<td><?php echo $report[$i]['old_info'];?>
					</td>
				</tr><?php
			}
			?>
		</tbody>
	</table>		
<?php
break;
case 'ticket_activity_by_department_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTDEPARTMENT'];?></th>
				<th><?php echo $vis_language['TXTOPERATOR'];?></th>
				<th><?php echo $vis_language['TXTOPERATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTOPERATION'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($audit_log);$i++){
				$name=''; if($audit_log[$i]['operator_id']!= -1){ $name = $vis_language['TXTWORKFLOW']; }else { $name =$vis_language['TXTROUNDROBIN']; }
				 ?>
				<tr role="row">
					<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $audit_log[$i]['ticket_hash'];?>/<?php echo $audit_log[$i]['ticket_id'];?>"><?php echo $audit_log[$i]['ticket_hash'];?></a></td>
					<td><?php echo $audit_log[$i]['subject'];?></td>
					<td><?php echo $audit_log[$i]['department_name'];?></td>

					<td><?php echo (($audit_log[$i]['workflow_id']!=0 || (($audit_log[$i]['operator']==4 )))? ($audit_log[$i]['workflow_id']!=0)? $vis_language['TXTSYSTEM'].' ('.$name.' - '.$audit_log[$i]['workflow_name'].')': $vis_language['TXTSYSTEM']:($operators[$audit_log[$i]['operator']].' ('.$audit_log[$i]['operators'].')')); ?>
					<?php /*echo ($audit_log[$i]['operator_id']==0 ? $vis_language['TXTSYSTEM'] : ($operators[$audit_log[$i]['operator']].' ('.$audit_log[$i]['operators'].')'));*/ // remove name  && (isset($audit_log[$i]['operators']) && $audit_log[$i]['operators']=='') ?>
					</td>
					<td><?php echo format_datetime($audit_log[$i]['entry_date']);?></td>
					<td><?php echo $audit_log[$i]['audit_log_operation'];?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>							
<?php
break;
case 'incident_count_by_priority':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTRPTRPRIORITYTITLE'];?></th> 		 
			<th><?php echo $vis_language['TXTTOTAL'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php
		for($i=0;$i<count($report);$i++){ ?>
			<tr role="row">
				<td><?php echo $report[$i]['priority_title'];?></td>
				<td><?php echo $report[$i]['total'];?></td>
				</tr><?php
			} ?>
		</tbody>
	</table>
<?php
break;
case 'incident_count_by_status':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTRPTRSTATUSTITLE'];?></th> 		 
				<th><?php echo $vis_language['TXTTOTAL'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++){ ?>
				<tr role="row">
					<td><?php echo $report[$i]['status_title'];?></td>
					<td><?php echo $report[$i]['total'];?></td>
				</tr><?php
			} ?>
		</tbody>
	</table>		
<?php 
break;
case 'assigned_staffavgresponse':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
			<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
			<th><?php echo $vis_language['TXTSUBJECT'];?></th>
			<th><?php echo $vis_language['TXTSTAFF'];?></th>
			<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
			<th><?php echo $vis_language['TXTREASSIGNEDDATE'];?></th>
			<th><?php echo $vis_language['TXTAVGRESPONSE'];?></th>
			</tr>
		</thead>
		<tbody><?php
			for($i=0;$i<count($report);$i++){$details=$report[$i]; ?><tr role="row">
				<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $details['ticket_hash'];?>/<?php echo $details['ticket_id'];?>"><?php echo $details['ticket_hash'];?></a></td>
				<td><?php echo (strlen($details['subject'])>60) ? mb_substr($details['subject'], 0, 60).'...' : $details['subject'];?></td>
				<td><?php echo $details['staff_name'];?></td>
				<td><?php echo format_datetime($details['receive_date']);?></td><td><?php echo format_datetime($details['reassigndate']);?></td><td><?php
				echo ($details['avg_resp']<=0)?'0 s':count_remain_time($details['avg_resp']);?></td></tr><?php
			} ?>
		</tbody>
	</table>
<?php
break;
case 'time_tracking_staff_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTDESCRIPTION'];?></th>
				<th><?php echo $vis_language['TXTSTAFF'];?></th>
				<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTBILLTIME'].' ('.$vis_language['TXTMIN'].')';?></th>
				<th><?php echo $vis_language['TXTWORKTIME'].' ('.$vis_language['TXTMIN'].')';?></th>
				<th><?php echo $vis_language['TXTAMOUNT'].' ('.$currency.')';?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			foreach($report as $ticket_id => $details){ ?>
				<tr role="row">
					<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $details['ticket_hash'];?>/<?php echo $details['ticket_id'];?>"><?php echo $details['ticket_hash']?></a></td>
					<td><?php echo $details['subject'];?></td>
					<td><?php echo $details['description'];?></td>
					<td><?php echo $details['staff_name'];?></td>
					<td><?php echo $details['first_name'].' '.$details['last_name'];?></td>
					<td><?php echo $details['email'];?></td>
					<td><?php echo $details['group_name'];?></td>
					<td><?php echo format_datetime($details['created_date']);?></td>
					<td><?php echo $details['bill_time'];?></td>
					<td><?php echo $details['work_time'];?></td>
					<td><?php echo $details['amount'];?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>
<?php
break;
case 'assigned_staffavgresolution':
?>
		<table class="table table-hover table-striped">
			<thead>
				<tr role="row">
					<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
					<th><?php echo $vis_language['TXTSUBJECT'];?></th>
					<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
					<th><?php echo $vis_language['TXTRESOLUTIONTIME'];?></th>
				</tr>
			</thead>
			<tbody>
				<?php
					foreach($report as $ticket_id => $details) { ?>
						<tr role="row">
							<td><a href="#/ticket/ticket_details/<?php echo $details['ticket_hash'];?>/<?php echo $details['ticket_id'];?>" target="_blank"><?php echo $details['ticket_hash'];?></a></td>
							<td><?php echo (strlen($details['subject'])>60) ? mb_substr($details['subject'], 0, 60).'...' : $details['subject'];?></td>
							<td><?php echo format_datetime($details['ticket_entry']);?></td>
							<td><?php echo  count_remain_time($details['resolved_time']); ?></td>							
						</tr><?php
						}
					?>
			</tbody>
		</table>
<?php
break;
case 'customfield_data_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTFIELDNAME'];?></th>
				<th><?php echo $vis_language['TXTFLDVAL'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++){ ?>
				<tr role="row">
					<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $report[$i]['ticket_hash'];?>/<?php echo $report[$i]['ticket_id'];?>"><?php echo $report[$i]['ticket_hash'];?></a></td>
					<td><?php echo format_datetime($report[$i]['receive_date']);?></td>
					<td><?php echo $report[$i]['field_name'];?></td>
					<td><?php echo $report[$i]['content'];?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>
<?php
break;
case 'service_request_activity_report':
?>
	<table class="table table-hover table-striped" id="datatable">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTSERVICEREQHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTOPERATION'];?></th>
				<th><?php echo $vis_language['TXTOPERATOR'];?></th>
				<th><?php echo $vis_language['TXTOPERATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTDEPARTMENT'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++){
				$name=''; if($report[$i]['operator_id']!= -1){ $name = $vis_language['TXTWORKFLOW']; }else { $name =$vis_language['TXTROUNDROBIN']; }
				 ?>
				<tr role="row">
					<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $report[$i]['ticket_hash'];?>/<?php echo $report[$i]['ticket_id'];?>"><?php echo $report[$i]['ticket_hash'];?></a></td>
					<td><?php echo $report[$i]['subject'];?></td>
					<td><?php echo $report[$i]['audit_log_operation'];?></td>
					<td><?php echo (($report[$i]['workflow_id']!=0 || (($report[$i]['operator']==4 )))? 
		 ($report[$i]['workflow_id']!=0)? $vis_language['TXTSYSTEM'].' ('.$name.' - '.$report[$i]['workflow_name'].')': $vis_language['TXTSYSTEM']:($operators[$report[$i]['operator']].' ('.$report[$i]['operators'].')')); ?>
					</td>
					<td><?php echo format_datetime($report[$i]['entry_date']);?></td>
					<td><?php echo $report[$i]['department_name'];?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>
<?php
break;
case 'service_customfield_data_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTSERVICEREQHASH'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTFIELDNAME'];?></th>
				<th><?php echo $vis_language['TXTFLDVAL'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++){ ?>
				<tr role="row">
					<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $report[$i]['ticket_hash'];?>/<?php echo $report[$i]['ticket_id'];?>"><?php echo $report[$i]['ticket_hash'];?></a></td>
					<td><?php echo format_datetime($report[$i]['receive_date']);?></td>
					<td><?php echo $report[$i]['field_name'];?></td>
					<td><?php echo $report[$i]['content'];?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>
<?php
break;
case 'service_request_dept_report':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTSERVICEREQHASH'];?></th>
			<th><?php echo $vis_language['TXTSUBJECT'];?></th>
			<th><?php echo $vis_language['TXTSTAFF'];?></th>
			<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
			<th><?php echo $vis_language['TXTCLOSINGDATE'];?></th>
			<th><?php echo $vis_language['TXTSTATUS'];?></th>
			<th><?php echo $vis_language['TXTRESOLUTIONTSLA'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php
		foreach($report as $ticket_id => $details){ ?>
			<tr role="row">
				<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $details['ticket_hash'];?>/<?php echo $details['ticket_id'];?>"><?php echo $details['ticket_hash'];?></a></td>
				<td><?php echo $details['subject'];?></td>
				<td><?php echo $details['first_name'].' '.$details['last_name'];?></td>
				<td><?php echo format_datetime($details['ticket_entry']);?></td>
				<td><?php echo format_datetime($details['ticket_closed']);?></td>
				<td><?php echo $details['status_name'];?></td>
				<td><?php 
					echo (isset($details['resolution_sla']) && $details['resolution_sla'] !='' ) ? $details['resolution_sla']: $vis_language['TXTNOTMAINTAIN']; 
				?></td>
			</tr><?php
		}
		?>
	</tbody>
</table>
<?php
break;
case 'service_item_wise_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTSERVICEREQHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTSTATUS'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			foreach($report as $ticket_id => $details){ ?>
				<tr role="row">
					<td><a href="#/ticket/ticket_details/<?php echo $details['ticket_hash'];?>/<?php echo $details['ticket_id'];?>" target="_blank"><?php echo $details['ticket_hash'];?></a></td>
					<td><?php echo $details['subject'];?></td>
					<td><?php echo $details['status_name'];?></td>
					<td><?php echo format_datetime($details['ticket_entry']);?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>
<?php
break;
case 'service_customfield_staff_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTSERVICEREQHASH'];?></th>
				<th><?php echo $vis_language['TXTFIRSTNAME'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTFIELDNAME'];?></th>
				<th><?php echo $vis_language['TXTFLDVAL'];?></th>
				<th><?php echo $vis_language['TXTSTAFF'].' '.strtolower($vis_language['TXTEMAIL']);?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++){ ?>
				<tr role="row">
					<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $report[$i]['ticket_hash'];?>/<?php echo $report[$i]['ticket_id'];?>"><?php echo $report[$i]['ticket_hash'];?></a></td>
					<td><?php echo $report[$i]['first_name'];?></td>
					<td><?php echo format_datetime($report[$i]['receive_date']);?></td>
					<td><?php echo $report[$i]['field_name'];?></td>
					<td><?php echo $report[$i]['content'];?></td>
					<td><?php echo $report[$i]['email'];?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>
<?php
break;
case 'serivce_request_overview_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTDEPARTMENTNAME'];?></th>
				<th><?php echo $vis_language['TXTTOTAL'];?></th>
				<th><?php echo $vis_language['TXTOPEN'];?></th>
				<th><?php echo $vis_language['TXTCLOSE'];?></th>
				<th><?php echo $status_list[0]['status_name'];?></th>
				<th><?php echo $vis_language['TXTPROINPROGRESS'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++){ ?>
				<tr role="row">
					<td><?php echo $report[$i]['department_name'];?></td>
					<td><?php echo $report[$i]['total'];?></td>
					<td><?php echo $report[$i]['openicket'];?></td>
					<td><?php echo $report[$i]['closeticket'];?></td>
					<td><?php echo $report[$i]['resolvedticket'];?></td>
					<td><?php echo $report[$i]['waitticket'];?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>
<?php
break;
case 'service_request_first_response_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTSERVICEREQHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTREPLYDATE'];?></th>
				<th><?php echo $vis_language['TXTFIRSTRESPONSE'];?></th>
				<!-- <th><?php echo $vis_language['TXTRESPONSESLA'];?></th> -->
			</tr>
		</thead>
		<tbody>
			<?php
			foreach($report_new as $ticket_id => $details){ ?>
				<tr role="row">
					<td><a href="#/ticket/ticket_details/<?php echo $details['ticket_hash'];?>/<?php echo $details['ticket_id'];?>" target="_blank"><?php echo $details['ticket_hash'];?></a></td>
					<td><?php echo $details['subject'];?></td>
					<td><?php echo format_datetime($details['ticket_entry']);?></td>
					<td><?php echo format_datetime($details['start_time']);?></td>
					<td><?php
						$time=$details['timestamp'];
						echo ($details['timestamp']!=0) ? count_remain_time($time, true) : '0S';?>
					</td>
					<!-- <td><?php echo $details['response_sla'];?></td> -->
				</tr><?php
			}
			?>
		</tbody>
	</table>
<?php
break;
case 'service_request_response_report':
?>
	<table class="table table-hover table-striped" id="datatable">
		<thead>
			<tr role="row">
			<th><?php echo $vis_language['TXTSERVICEREQHASH'];?></th>
			<th><?php echo $vis_language['TXTSUBJECT'];?></th>
			<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
			<th><?php echo $vis_language['TXTAVGRESPONSE'];?></th>
			<!-- <th><?php echo $vis_language['TXTRESPONSESLA'];?></th> -->
			</tr>
		</thead>
		<tbody><?php 
			foreach($report_new as $ticket_id => $details){ ?><tr role="row"><td><a href="#/ticket/ticket_details/<?php echo $details['ticket_hash'];?>/<?php echo $details['ticket_id'];?>" target="_blank"><?php echo $details['ticket_hash'];?></a></td><td><?php echo (strlen($details['subject'])>60) ? mb_substr($details['subject'], 0, 60).'...' : $details['subject'];?></td><td><?php echo format_datetime($details['ticket_entry']);?></td><td><?php
					if(isset($details['slapause_diff'])){ $sla_diff = $details['slapause_diff'];}else{ $sla_diff=0;}
					if(($details['timestamp']==0 || $details['timestamp']<0) && $details['count']!=0){
						$timestamp = '0 S';
					}elseif($details['count']==0){
						if($details['operator'] == 2 && $details['as_client'] != 1){
							$timestamp = '0 S';
						}else{
							$timestamp = $vis_language['TXTNOTRESPONDED'];
						} 
					}else{
						$timestamp = count_remain_time(round(($details['timestamp']-$sla_diff)/$details['count']));
					}
					if(isset($details['clientreplycnt']) && $details['clientreplycnt']==0) $timestamp = '0S';
					echo $timestamp;
				?></td>
				<td><?php /*echo $details['response_sla'];*/ ?></td>
				</tr><?php
			} ?>
		</tbody>
	</table>
<?php
break;
case 'service_request_staff_performance_report':
?>
	<table class="table table-hover table-striped">
				<thead>
					<tr role="row">
					<th><?php echo $vis_language['TXTSERVICEREQHASH'];?></th>
					<th><?php echo $vis_language['TXTSUBJECT'];?></th>
					<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
					<th><?php echo $vis_language['TXTAVGRESPONSE'];?></th>
					</tr>
				</thead>
				<tbody><?php
					foreach($report_new as $ticket_id => $details){ ?><tr role="row"><td><a href="#/ticket/ticket_details/<?php echo $details['ticket_hash'];?>/<?php echo $details['ticket_id'];?>" target="_blank"><?php echo $details['ticket_hash'];?></a></td><td><?php echo (strlen($details['subject'])>60) ? mb_substr($details['subject'], 0, 60).'...' : $details['subject'];?></td><td><?php echo format_datetime($details['ticket_entry']);?></td><td><?php

							if(isset($details['slapause_diff'])){ $sla_diff = $details['slapause_diff'];}else{ $sla_diff=0;}

							if(isset($details['avg_time']) && $details['avg_time']!=0){
								$timestamp = count_remain_time(round(abs($details['avg_time']/$details['count'])));	
							}else{
							 if($details['count']==0){
								if($details['operator'] == 2 && $details['as_client'] != 1){
									$timestamp = '0 S';
								}else{
									$timestamp = $vis_language['TXTNOTRESPONDED'];
								}
							 }
							}
							echo $timestamp;							   
						?></td></tr><?php
					} ?>
				</tbody>
	</table>
<?php
break;
case 'customfield_staff_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTFIRSTNAME'];?></th>
				<th><?php echo $vis_language['TXTCREATEDATE'];?></th>
				<th><?php echo $vis_language['TXTFIELDNAME'];?></th>
				<th><?php echo $vis_language['TXTFLDVAL'];?></th>
				<th><?php echo $vis_language['TXTSTAFF'].' '.strtolower($vis_language['TXTEMAIL']);?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++){ ?>
				<tr role="row">
					<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $report[$i]['ticket_hash'];?>/<?php echo $report[$i]['ticket_id'];?>"><?php echo $report[$i]['ticket_hash'];?></a></td>
					<td><?php echo $report[$i]['first_name'];?></td>
					<td><?php echo format_datetime($report[$i]['receive_date']);?></td>
					<td><?php echo $report[$i]['field_name'];?></td>
					<td><?php echo $report[$i]['content'];?></td>
					<td><?php echo $report[$i]['email'];?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>
<?php
break;

case 'ci_customfield_report':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTNAME'];?></th>
			<th><?php echo $vis_language['TXTCITYPE'];?></th>
			<th><?php echo $vis_language['TXTLOCATION'];?></th>
			<th><?php echo $vis_language['TXTFIELDNAME'];?></th>
				<th><?php echo $vis_language['TXTFLDVAL'];?></th>
			<th><?php echo $vis_language['TXTEXPIRYDATE'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php
			$html ='';
			for($i=0;$i<count($report);$i++) {
				if($report[$i]['staff_id']===''){
					$managed_by = '---';
					}else{
					$managed_by = $report[$i]['first_name'].' '.$report[$i]['last_name'];
				}
				$html.='<tr><td><a href="#/cmdb/cmdb_details/'.str_replace('/', ' ', $report[$i]['name']).'/'.$report[$i]['assets_id'].'" target="_blank">'.$report[$i]['name'].'</a></td><td>'.$report[$i]['ci_name'].'</td><td>'.$report[$i]['LNAME'].'</td><td>'.$report[$i]['field_name'].'</td><td>'.$report[$i]['content'].'</td>';
				if($report[$i]['expiry_date']!='--' && ($report[$i]['expiry_date'] < strtotime(date('Y-m-d H:i:s'))))
				{
					$html.='<td><span style="background-color: #e33244; color: #fff; font-weight: normal" class="btn-xs l-h-1x text-xs">'.format_datetime($report[$i]['expiry_date']).'</span></td>';
				}
				else
				{
					$html.='<td>'.format_datetime($report[$i]['expiry_date']).'</td>';
				}

				$html.='</tr>';
			} echo $html;?>
	</tbody>
	</table>
<?php
break;

case 'customfield_task_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTASKTITLE'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTENDDATE'];?></th>
				<th><?php echo $vis_language['TXTSTATUS'];?></th>
				<th><?php echo $vis_language['TXTFIELDNAME'];?></th>
				<th><?php echo $vis_language['TXTFLDVAL'];?></th>
				<th><?php echo $vis_language['TXTSTAFF'].' '.strtolower($vis_language['TXTEMAIL']);?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			$status=array(1 => $vis_language['TXTINPROGRESS'],2 => $vis_language['TXTOVERDUE'],3 => $vis_language['TXTCOMPLETED'],4 => $vis_language['TXTCANCELED'],5 => $vis_language['TXTNOTSTARTED']);
			for($i=0;$i<count($report);$i++){ ?>
				<tr role="row">
					<td><a target="_blank" href="#/home/view_update_tasks/<?php echo $report[$i]['task_title'];?>/<?php echo $report[$i]['task_id'];?>"><?php echo $report[$i]['task_title'];?></a></td>
					<td><?php echo format_datetime($report[$i]['startdate']);?></td>
					<td><?php echo format_datetime($report[$i]['enddate']);?></td>
				<?php
				if(isset($report[$i]['enddate_diff']) && $report[$i]['enddate_diff']<=0){ if($report[$i] ['task_status']!=3 && $report[$i] ['task_status']!=4){ 
				$ovedue_status = $vis_language['TXTNOTMAINTAIN']; 	?>
				<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-danger-bg"><?php echo $vis_language['TXTOVERDUE'];?></label></td>
				<?php } else
				{ if($report[$i]['task_status']==1) { $ovedue_status = $vis_language['TXTMAINTAIN']; ?>
					<td>	<label id="vis_task_status" class="btn-xs wrapper-xxs vh-success-bg"><?php echo $status[$report[$i]['task_status']];?></label></td>
					<?php }else if($report[$i]['task_status']==3){ $ovedue_status = $vis_language['TXTMAINTAIN']; ?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-info-bg"><?php echo $status[$report[$i]['task_status']];?></label></td>
					<?php }else if($report[$i]['task_status']==4){ $ovedue_status = $vis_language['TXTMAINTAIN']; ?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-grey-bg"><?php echo $status[$report[$i]['task_status']];?></label></td><?php }
					else if($report[$i]['task_status']==5){ $ovedue_status = $vis_language['TXTNOTMAINTAIN'];?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xs label label-default" style="text-align:left;"  ><?php echo $status[$report[$i] ['task_status']];?></label></td><?php }
				} ?>
				<?php }else { $ovedue_status = $vis_language['TXTMAINTAIN'];  if($report[$i]['task_status']==1) {?>
					<td><label id="vis_task_status" class="btn-xs wrapper-xxs vh-success-bg"><?php echo $status[$report[$i]['task_status']];?></label></td>
					<?php }else if($report[$i]['task_status']==3){?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-info-bg"><?php echo $status[$report[$i]['task_status']];?></label></td>
					<?php }else if($report[$i]['task_status']==4){ ?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-grey-bg"><?php echo $status[$report[$i]['task_status']];?></label></td><?php }
					else if($report[$i]['task_status']==5){ ?>
					<td><label id="vis_task_status" class="btn-xs wrapper-xs label label-default" style="text-align:left;"><?php echo $status[$report[$i]['task_status']];?></label></td><?php } } ?>
					<td><?php echo $report[$i]['field_name'];?></td>
					<td><?php echo $report[$i]['content'];?></td>
					<td><?php echo $report[$i]['email'];?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>
<?php
break;
case 'incident_count_by_level':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTRPTRLEVELTITLE'];?></th> 		 
				<th><?php echo $vis_language['TXTTOTAL'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++){ ?>
				<tr role="row">
					<td><?php echo $report[$i]['level_title'];?></td>
					<td><?php echo $report[$i]['total'];?></td>
				</tr><?php
			} ?>
		</tbody>
	</table>
<?php
break;
 case 'service_request_resolution_avg_report': ?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTSERVICEREQHASH'];?></th>
			<th><?php echo $vis_language['TXTSUBJECT'];?></th>
			<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
			<th><?php echo $vis_language['TXTRESOLUTIONTIME'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php   
		foreach($report_new as $ticket_id => $details){ 							 	 
			echo '<tr><td ><a href="#/ticket/ticket_details/'.$details['ticket_hash'].'/'.$details['ticket_id'].'" target="_blank">'.$details['ticket_hash'].'</a> </td><td >'.$details['subject'].'</td>  <td>'.format_datetime($details['ticket_entry']).'</td> <td>';
			if(isset($details['status_id']) &&($details['status_id']==4 || $details['status_id']==3)){
				echo (isset($details['avg_resolution_time']) && $details['avg_resolution_time'] !='' )?$details['avg_resolution_time']:"Not resolved";  
			} 	else{
					echo $details['avg_resolution_time'] ;

			}
			echo '</td> </tr>';
			} ?>
	</tbody>
	</table>
<?php
break;
case 'incident_count_by_urgency':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTRPTRURGENCYTITLE'];?></th>
				<th><?php echo $vis_language['TXTTOTAL'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++){ ?>
				<tr role="row">
					<td><?php echo $report[$i]['urgency_title'];?></td>
					<td><?php echo $report[$i]['total'];?></td>
				</tr><?php
			} ?>
		</tbody>
	</table>
<?php
break;

case 'service_request_activity_by_department_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTSERVICEREQHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTOPERATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTOPERATION'];?></th>
				<th><?php echo $vis_language['TXTOPERATOR'];?></th>
				<th><?php echo $vis_language['TXTDEPARTMENT'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
				for($i=0;$i<count($audit_log);$i++){
					$name=''; if($audit_log[$i]['operator_id']!= -1){ $name = $vis_language['TXTWORKFLOW']; }else { $name =$vis_language['TXTROUNDROBIN']; }
					?>
					<tr role="row">
						<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $audit_log[$i]['ticket_hash'];?>/<?php echo $audit_log[$i]['ticket_id'];?>"><?php echo $audit_log[$i]['ticket_hash'];?></a></td>
						<td><?php echo $audit_log[$i]['subject'];?></td>
						<td><?php echo format_datetime($audit_log[$i]['creation_date']);?></td>
						<td><?php echo format_datetime($audit_log[$i]['operation_date']);?></td>
						<td><?php echo $audit_log[$i]['audit_log_operation'];?></td>
						<td><?php echo (($audit_log[$i]['workflow_id']!=0 || (($audit_log[$i]['operator']==4 ) && (isset($audit_log[$i]['name']) && $audit_log[$i]['name']=='')))? 
			 ($audit_log[$i]['workflow_id']!=0)? $vis_language['TXTSYSTEM'].' ('.$name.' - '.$audit_log[$i]['workflow_name'].')': $vis_language['TXTSYSTEM']:($operators[$audit_log[$i]['operator']].' ('.$audit_log[$i]['operators'].')')); ?>
							<?php /*echo ($audit_log[$i]['operator_id']==0?$vis_language['TXTSYSTEM']:($operators[$audit_log[$i]['operator']].' ('.$audit_log[$i]['operators'].')'));*/?></td>
						<td><?php echo $audit_log[$i]['department_name'];?></td>
					</tr><?php
				}
				?>
		</tbody>
	</table>
<?php 
break;

case 'service_request_staff_resolution_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTSERVICEREQHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTRESOLUTIONTIME'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
				foreach($report as $ticket_id => $details) { ?>
					<tr role="row">
						<td><a href="#/ticket/ticket_details/<?php echo $details['ticket_hash'];?>/<?php echo $details['ticket_id'];?>" target="_blank"><?php echo $details['ticket_hash'];?></a></td>
						<td><?php echo (strlen($details['subject'])>60) ? mb_substr($details['subject'], 0, 60).'...' : $details['subject'];?></td>
						<td><?php echo format_datetime($details['ticket_entry']);?></td>
						<td><?php echo  count_remain_time($details['resoltion_time']); ?></td>							
					</tr><?php
					}
				?>
		</tbody>
	</table>
<?php 
break;
case 'staff_leaderboard_avgresolution_report': 
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTSTAFFNAME'];?></th>
				<th><?php echo $vis_language['TXTSOLVEDTICKETS'];?></th>
				<th><?php echo $vis_language['TXTTOTALTICKETS'];?></th>
				<th><?php echo $vis_language['TXTAVGRESOLUTIONTIME'];?></th>
				<th><?php echo $vis_language['TXTAVGSLATIME'];?></th>
			</tr>
		</thead>
		<tbody>
		<?php 
			foreach($report as $report1){  ?>
				<tr role="row">
					<td><?php echo $report1['staff_name'];?></td>
					<td><?php echo $report1['total_ticket_count'];?></td>
					<td><?php echo $report1['total_rec_all'];?></td>
					<td><?php echo $report1['avgresolutiontime'];?></td>
					<td><?php echo $report1['avgresponsesla'];?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>
<?php 
break; 
		
case 'overdue_service_request_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTSERVICEREQHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
				<th><?php echo $vis_language['TXTCREATEDATE'];?></th>
				<th><?php echo $vis_language['TXTOVERDUE'].' '.strtolower($vis_language['TXTSINCE']);?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++){
				if($report[$i]['first_name'] =='' && $report[$i]['last_name']=='')
					$client_name = '-';
				else
					$client_name = $report[$i]['first_name'].' '.$report[$i]['last_name'];
				?>
				<tr role="row">
					<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $report[$i]['ticket_hash'];?>/<?php echo $report[$i]['ticket_id'];?>"><?php echo $report[$i]['ticket_hash'];?></a></td>
					<td><?php echo $report[$i]['subject'];?></td>
					<td><?php echo $client_name;?></td>
					<td><?php echo $report[$i]['email'];?></td>
					<td><?php echo $report[$i]['group_name'];?></td>
					<td><?php echo format_datetime($report[$i]['receive_date']);?></td>
					<td><?php echo format_datetime($report[$i]['due_time']);?></td>
				</tr><?php
			}
		?>
		</tbody>
	</table>
<?php 
break; 
case 'deleted_service_request_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTSERVICEREQHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTSTAFFNAME'];?></th>
				<th><?php echo $vis_language['TXTDELETEDATE'];?></th>
				<th><?php echo $vis_language['TXTDEPARTMENT'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++){ ?>
				<tr role="row">
					<td><?php echo $report[$i]['ticket_hash'];?></td>
					<td><?php echo $report[$i]['subject'];?></td>
					<td><?php echo $report[$i]['first_name'].' '.$report[$i]['last_name'];?></td>
					<td><?php echo format_datetime($report[$i]['receive_date']);?></td>
					<td><?php echo $report[$i]['department_name'];?>
					</td>
				</tr><?php
			}
			?>
		</tbody>
	</table>
<?php 
break;
		// case ('incident_count_flag' || 'incident_count_label' || 'incident_count_subcategory' || 'incident_count_item' || 'incident_count_impact' || 'incident_count_channel' || 'changes_count_by_risk' || 'incident_count_by_location'):
		case 'incident_count_flag':
		case 'incident_count_label':
		case 'incident_count_subcategory':
		case 'incident_count_item':
		case 'incident_count_impact':
		case 'incident_count_channel':
		case 'changes_count_by_risk':
		case 'incident_count_by_location':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $title;?></th>
				<th><?php echo $vis_language['TXTTOTAL'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
				for($i=0;$i<count($report);$i++){ ?>
					<tr role="row">
						<td><?php echo $report[$i]['title'];?></td>
						<td><?php echo $report[$i]['total'];?></td>
					</tr>
				<?php
				}
				?>
		</tbody>
	</table>
<?php 
break;
case 'total_unanswered_service_request':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTSERVICEREQHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTCONTACTNUMBER'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++){
				if($report[$i]['first_name'] =='' && $report[$i]['last_name']=='')
					$client_name = '-';
				else
					$client_name = $report[$i]['first_name'].' '.$report[$i]['last_name'];

				$contact_number = ($report[$i]['contact_number']!='') ? $report[$i]['contact_number'] : '---';
				?>
				<tr role="row">
					<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $report[$i]['ticket_hash'];?>/<?php echo $report[$i]['ticket_id'];?>"><?php echo $report[$i]['ticket_hash'];?></a></td>
					<td><?php echo $report[$i]['subject'];?></td>
					<td><?php echo $contact_number;?></td>
					<td><?php echo format_datetime($report[$i]['receive_date']);?></td>
					<td><?php echo $client_name;?></td>
					<td><?php echo $report[$i]['email'];?></td>
					<td><?php echo $report[$i]['group_name'];?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>
<?php 
break;
case 'assign_staff_task_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTASKTITLE'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTENDDATE'];?></th>
				<th><?php echo $vis_language['TXTPRIORITY'];?></th>
				<th><?php echo $vis_language['TXTSTATUS'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php $status=array(1 => $vis_language['TXTINPROGRESS'],2 => $vis_language['TXTOVERDUE'],3 => $vis_language['TXTCOMPLETED'],4 => $vis_language['TXTCANCELED'],5 => $vis_language['TXTNOTSTARTED']);
				foreach($report as $ticket_id => $details) {
					echo '<tr><td class="txt_nowrap"><a href="#/home/view_update_tasks/'.$details['task_title'].'/'.$details['task_id'].'" target="_blank">'.$details['task_title'].'</a></td> <td class="txt_nowrap">'.format_datetime($details['startdate']).'</td><td class="txt_nowrap">'.format_datetime($details['enddate']).'</td><td class="txt_nowrap">'.$details['title'].'</td>';
					if($details['enddate_diff']<=0){ if($details ['task_status']!=3 && $details ['task_status']!=4){?>
						<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-danger-bg"><?php echo $vis_language['TXTOVERDUE'];?></label></td>
						<?} else
						{ if($details['task_status']==1) {?>
							<td>	<label id="vis_task_status" class="btn-xs wrapper-xxs vh-success-bg"><?php echo $status[$details['task_status']];?></label></td>
							<?}else if($details['task_status']==3){?>
							<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-info-bg"><?php echo $status[$details['task_status']];?></label></td>
							<?}else if($details['task_status']==4){ ?>
							<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-grey-bg"><?php echo $status[$details['task_status']];?></label></td><?php }
							else if($details['task_status']==5){ ?>
							<td> <label id="vis_task_status" class="btn-xs wrapper-xs label label-default"><?php echo $status[$details ['task_status']];?></label></td><?php }
						} ?>
						<?}else { if($details['task_status']==1) {?>
							<td><label id="vis_task_status" class="btn-xs wrapper-xxs vh-success-bg"><?php echo $status[$details['task_status']];?></label></td>
							<?}else if($details['task_status']==3){?>
							<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-info-bg"><?php echo $status[$details['task_status']];?></label></td>
							<?}else if($details['task_status']==4){ ?>
							<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-grey-bg"><?php echo $status[$details['task_status']];?></label></td><?php }
							else if($details['task_status']==5){ if($details['startdate'] <= strtotime($currentdate) && $details['enddate_diff']>=0){  ?>
							<td><label id="vis_task_status" class="btn-xs wrapper-xxs vh-success-bg"><?php echo $vis_language['TXTINPROGRESS'];?></label></td>
							<?php } else { ?>		
							<td><label id="vis_task_status" class="btn-xs wrapper-xs label label-default"><?php echo $status[$details ['task_status']];?></label></td><?php } }
						} echo '</tr>'; } ?>
		</tbody>
	</table>
<?php 
break;
case 'overdue_task_report':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTTASKTITLE'];?></th>
			<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
			<th><?php echo $vis_language['TXTENDDATE'];?></th>
			<th><?php echo $vis_language['TXTPRIORITY'];?></th>
			<th><?php echo $vis_language['TXTSTATUS'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php $status = array( 1 => $vis_language['TXTINPROGRESS'], 2 => $vis_language['TXTOVERDUE'], 3 => $vis_language['TXTCOMPLETED'], 4 => $vis_language['TXTCANCELED'] );
			foreach($report as $ticket_id => $details) {
				echo '<tr><td ><a href="#/home/view_update_tasks/'.$details['task_title'].'/'.$details['task_id'].'" target="_blank">'.$details['task_title'].'</a></td> <td >'.format_datetime($details['startdate']).'</td><td >'.format_datetime($details['enddate']).'</td><td >'.$details['title'].'</td>        ';
				if($details['enddate_diff']<=0){ if($details ['task_status']!=3 && $details ['task_status']!=4){?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-danger-bg" ><?php echo $vis_language['TXTOVERDUE'];?></label></td>
					<?} else  { if($details['task_status']==1) {?>
						<td>	<label id="vis_task_status" class="btn-xs wrapper-xxs vh-success-bg"><?php echo $status[$details['task_status']];?></label></td>
						<?}else if($details['task_status']==3){?>
						<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-info-bg"><?php echo $status[$details['task_status']];?></label></td>
						<?}else if($details['task_status']==4){ ?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-grey-bg"><?php echo $status[$details['task_status']];?></label></td><?php }} ?>
					<?}else { if($details['task_status']==1) {?>
						<td><label id="vis_task_status" class="btn-xs wrapper-xxs vh-success-bg"><?php echo $status[$details['task_status']];?></label></td>
						<?}else if($details['task_status']==3){?>
						<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-info-bg"><?php echo $status[$task_details['task_status']];?></label></td>
						<?}else if($details['task_status']==4){ ?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-grey-bg"><?php echo $status[$details['task_status']];?></label></td><?php }} echo '</tr>'; } ?>
	</tbody>
	</table>
<?php 
break;
case 'task_commented_report':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTTASKTITLE'];?></th>
			<th><?php echo $vis_language['TXTCOMMENTDATE'];?></th>
			<th><?php echo $vis_language['TXTCONTENT'];?></th>
			<th><?php echo $vis_language['TXTSTATUS'];?></th>
			<th><?php echo $vis_language['TXTOVERDUE'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php $status=array(1 => $vis_language['TXTINPROGRESS'],2 => $vis_language['TXTOVERDUE'],3 => $vis_language['TXTCOMPLETED'],4 => $vis_language['TXTCANCELED'],5 => $vis_language['TXTNOTSTARTED']); 
			foreach($report as $ticket_id => $details) {  $ovedue_status = '';
				echo '<tr><td class="txt_nowrap"><a href="#/home/view_update_tasks/'.$details['task_title'].'/'.$details['task_id'].'" target="_blank">'.$details['task_title'].'</a></td> <td class="txt_nowrap">'.format_datetime($details['entry_date']).'</td><td class="txt_nowrap">'.$details['content'].'</td> '; if($details['enddate_diff']<=0){ if($details ['task_status']!=3 && $details ['task_status']!=4){  $ovedue_status = $vis_language['TXTNOTMAINTAIN']; ?>
				<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-danger-bg"><?php echo $vis_language['TXTOVERDUE'];?></label></td>
				<?} else
				{ if($details['task_status']==1) { $ovedue_status = $vis_language['TXTMAINTAIN']; ?>
					<td>	<label id="vis_task_status" class="btn-xs wrapper-xxs vh-success-bg"><?php echo $status[$details['task_status']];?></label></td>
					<?}else if($details['task_status']==3){ $ovedue_status = $vis_language['TXTMAINTAIN']; ?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-info-bg"><?php echo $status[$details['task_status']];?></label></td>
					<?}else if($details['task_status']==4){ $ovedue_status = $vis_language['TXTMAINTAIN']; ?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-grey-bg"><?php echo $status[$details['task_status']];?></label></td><?php }
					else if($details['task_status']==5){ $ovedue_status = $vis_language['TXTNOTMAINTAIN'];  ?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xs label label-default"><?php echo $status[$details ['task_status']];?></label>
					</td><?php } } ?>
					<?}else { $ovedue_status = $vis_language['TXTMAINTAIN']; if($details['task_status']==1) {?>
						<td><label id="vis_task_status" class="btn-xs wrapper-xxs vh-success-bg"><?php echo $status[$details['task_status']];?></label></td>
						<?}else if($details['task_status']==3){?>
						<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-info-bg"><?php echo $status[$details['task_status']];?></label></td>
						<?}else if($details['task_status']==4){ ?>
						<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-grey-bg"><?php echo $status[$details['task_status']];?></label></td><?php }
						else if($details['task_status']==5){ ?>
					<td>  <label id="vis_task_status" class="btn-xs wrapper-xs label label-default" style="text-align:left;"><?php echo $status[$details ['task_status']];?></label></td><?php } } ?>
					<td  class="txt_nowrap"> <?php echo $ovedue_status; ?></td>
				<?  echo '</tr>'; }	?>
	</tbody>
	</table>
<?php 
break;
case 'task_linkedto_ticket_report':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
			<th><?php echo $vis_language['TXTSUBJECT'];?></th>
			<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
			<th><?php echo $vis_language['TXTTASK'];?></th>
			<th><?php echo $vis_language['TXTSTATUS'];?></th>
			<th><?php echo $vis_language['TXTOVERDUE'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php $status=array(1 => $vis_language['TXTINPROGRESS'],2 => $vis_language['TXTOVERDUE'],3 => $vis_language['TXTCOMPLETED'],4 => $vis_language['TXTCANCELED'],5 => $vis_language['TXTNOTSTARTED']);
			foreach($report as $ticket_id => $details) {  $ovedue_status = '';
				echo '<tr><td><a href="#/ticket/ticket_details/'.$details['ticket_hash'].'/'.$details['ticket_id'].'" target="_blank">'.$details['ticket_hash'].'</a>'.'</td> <td>'.$details['subject'].'</td><td>'.format_datetime($details['receive_date']).'</td> <td><a href="#/home/view_update_tasks/'.$details['task_title'].'/'.$details['task_id'].'" target="_blank">'.$details['task_title'].'</a></td>';
				if(isset($details['enddate_diff']) && $details['enddate_diff']<=0){ if($details ['task_status']!=3 && $details ['task_status']!=4){ 
				$ovedue_status = $vis_language['TXTNOTMAINTAIN']; 	?>
				<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-danger-bg"><?php echo $vis_language['TXTOVERDUE'];?></label></td>
				<?php } else
				{ if($details['task_status']==1) { $ovedue_status = $vis_language['TXTMAINTAIN']; ?>
					<td>	<label id="vis_task_status" class="btn-xs wrapper-xxs vh-success-bg"><?php echo $status[$details['task_status']];?></label></td>
					<?php }else if($details['task_status']==3){ $ovedue_status = $vis_language['TXTMAINTAIN']; ?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-info-bg"><?php echo $status[$details['task_status']];?></label></td>
					<?php }else if($details['task_status']==4){ $ovedue_status = $vis_language['TXTMAINTAIN']; ?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-grey-bg"><?php echo $status[$details['task_status']];?></label></td><?php }
					else if($details['task_status']==5){ $ovedue_status = $vis_language['TXTNOTMAINTAIN'];?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xs label label-default" style="text-align:left;"  ><?php echo $status[$details ['task_status']];?></label></td><?php }
				} ?>
				<?php }else { $ovedue_status = $vis_language['TXTMAINTAIN'];  if($details['task_status']==1) {?>
					<td><label id="vis_task_status" class="btn-xs wrapper-xxs vh-success-bg"><?php echo $status[$details['task_status']];?></label></td>
					<?php }else if($details['task_status']==3){?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-info-bg"><?php echo $status[$details['task_status']];?></label></td>
					<?php }else if($details['task_status']==4){ ?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-grey-bg"><?php echo $status[$details['task_status']];?></label></td><?php }
					else if($details['task_status']==5){ ?>
					<td><label id="vis_task_status" class="btn-xs wrapper-xs label label-default" style="text-align:left;"><?php echo $status[$details ['task_status']];?></label></td><?php } } ?>
					<td  class="txt_nowrap"> <?php echo $ovedue_status; ?></td>
					<? echo '</tr>'; } ?>
	</tbody>
	</table>
<?php 
break;
case 'task_linkedto_problem_report':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTPROBLEMHASH'];?></th>
			<th><?php echo $vis_language['TXTSUBJECT'];?></th>
			<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
			<th><?php echo $vis_language['TXTTASK'];?></th>
			<th><?php echo $vis_language['TXTSTATUS'];?></th>
			<th><?php echo $vis_language['TXTOVERDUE'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php $status=array(1 => $vis_language['TXTINPROGRESS'],2 => $vis_language['TXTOVERDUE'],3 => $vis_language['TXTCOMPLETED'],4 => $vis_language['TXTCANCELED'],5 => $vis_language['TXTNOTSTARTED']);
			foreach($report as $details) {  $ovedue_status = '';
				echo '<tr><td><a href="#/problem/problem_details/'.$details['problem_hash'].'/'.$details['problem_id'].'" target="_blank">'.$details['problem_hash'].'</a>'.'</td> <td>'.$details['subject'].'</td><td>'.format_datetime($details['date_created']).'</td> <td><a href="#/home/view_update_tasks/'.$details['task_title'].'/'.$details['task_id'].'" target="_blank">'.$details['task_title'].'</a></td>';
				if(isset($details['enddate_diff']) && $details['enddate_diff']<=0){ if($details ['task_status']!=3 && $details ['task_status']!=4){ 
				$ovedue_status = $vis_language['TXTNOTMAINTAIN']; 	?>
				<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-danger-bg"><?php echo $vis_language['TXTOVERDUE'];?></label></td>
				<?php } else
				{ if($details['task_status']==1) { $ovedue_status = $vis_language['TXTMAINTAIN']; ?>
					<td>	<label id="vis_task_status" class="btn-xs wrapper-xxs vh-success-bg"><?php echo $status[$details['task_status']];?></label></td>
					<?php }else if($details['task_status']==3){ $ovedue_status = $vis_language['TXTMAINTAIN']; ?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-info-bg"><?php echo $status[$details['task_status']];?></label></td>
					<?php }else if($details['task_status']==4){ $ovedue_status = $vis_language['TXTMAINTAIN']; ?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-grey-bg"><?php echo $status[$details['task_status']];?></label></td><?php }
					else if($details['task_status']==5){ $ovedue_status = $vis_language['TXTNOTMAINTAIN'];?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xs label label-default" style="text-align:left;"  ><?php echo $status[$details ['task_status']];?></label></td><?php }
				} ?>
				<?php }else { $ovedue_status = $vis_language['TXTMAINTAIN'];  if($details['task_status']==1) {?>
					<td><label id="vis_task_status" class="btn-xs wrapper-xxs vh-success-bg"><?php echo $status[$details['task_status']];?></label></td>
					<?php }else if($details['task_status']==3){?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-info-bg"><?php echo $status[$details['task_status']];?></label></td>
					<?php }else if($details['task_status']==4){ ?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-grey-bg"><?php echo $status[$details['task_status']];?></label></td><?php }
					else if($details['task_status']==5){ ?>
					<td><label id="vis_task_status" class="btn-xs wrapper-xs label label-default" style="text-align:left;"><?php echo $status[$details ['task_status']];?></label></td><?php } } ?>
					<td  class="txt_nowrap"> <?php echo $ovedue_status; ?></td>
					<? echo '</tr>'; } ?>
	</tbody>
	</table>
<?php 
break;
case 'task_linkedto_changes_report':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTCHANGEHASH'];?></th>
			<th><?php echo $vis_language['TXTSUBJECT'];?></th>
			<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
			<th><?php echo $vis_language['TXTTASK'];?></th>
			<th><?php echo $vis_language['TXTSTATUS'];?></th>
			<th><?php echo $vis_language['TXTOVERDUE'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php $status=array(1 => $vis_language['TXTINPROGRESS'],2 => $vis_language['TXTOVERDUE'],3 => $vis_language['TXTCOMPLETED'],4 => $vis_language['TXTCANCELED'],5 => $vis_language['TXTNOTSTARTED']);
			foreach($report as $details) {  $ovedue_status = '';
				echo '<tr><td><a href="#/changes/changes_details/'.$details['changes_hash'].'/'.$details['changes_id'].'" target="_blank">'.$details['changes_hash'].'</a>'.'</td> <td>'.$details['subject'].'</td><td>'.format_datetime($details['date_created']).'</td> <td><a href="#/home/view_update_tasks/'.$details['task_title'].'/'.$details['task_id'].'" target="_blank">'.$details['task_title'].'</a></td>';
				if(isset($details['enddate_diff']) && $details['enddate_diff']<=0){ if($details ['task_status']!=3 && $details ['task_status']!=4){ 
				$ovedue_status = $vis_language['TXTNOTMAINTAIN']; 	?>
				<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-danger-bg"><?php echo $vis_language['TXTOVERDUE'];?></label></td>
				<?php } else
				{ if($details['task_status']==1) { $ovedue_status = $vis_language['TXTMAINTAIN']; ?>
					<td>	<label id="vis_task_status" class="btn-xs wrapper-xxs vh-success-bg"><?php echo $status[$details['task_status']];?></label></td>
					<?php }else if($details['task_status']==3){ $ovedue_status = $vis_language['TXTMAINTAIN']; ?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-info-bg"><?php echo $status[$details['task_status']];?></label></td>
					<?php }else if($details['task_status']==4){ $ovedue_status = $vis_language['TXTMAINTAIN']; ?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-grey-bg"><?php echo $status[$details['task_status']];?></label></td><?php }
					else if($details['task_status']==5){ $ovedue_status = $vis_language['TXTNOTMAINTAIN'];?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xs label label-default" style="text-align:left;"  ><?php echo $status[$details ['task_status']];?></label></td><?php }
				} ?>
				<?php }else { $ovedue_status = $vis_language['TXTMAINTAIN'];  if($details['task_status']==1) {?>
					<td><label id="vis_task_status" class="btn-xs wrapper-xxs vh-success-bg"><?php echo $status[$details['task_status']];?></label></td>
					<?php }else if($details['task_status']==3){?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-info-bg"><?php echo $status[$details['task_status']];?></label></td>
					<?php }else if($details['task_status']==4){ ?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-grey-bg"><?php echo $status[$details['task_status']];?></label></td><?php }
					else if($details['task_status']==5){ ?>
					<td><label id="vis_task_status" class="btn-xs wrapper-xs label label-default" style="text-align:left;"><?php echo $status[$details ['task_status']];?></label></td><?php } } ?>
					<td  class="txt_nowrap"> <?php echo $ovedue_status; ?></td>
					<? echo '</tr>'; } ?>
	</tbody>
	</table>
<?php 
break;
case 'task_linkedto_releases_report':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTRELEASEHASH'];?></th>
			<th><?php echo $vis_language['TXTSUBJECT'];?></th>
			<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
			<th><?php echo $vis_language['TXTTASK'];?></th>
			<th><?php echo $vis_language['TXTSTATUS'];?></th>
			<th><?php echo $vis_language['TXTOVERDUE'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php $status=array(1 => $vis_language['TXTINPROGRESS'],2 => $vis_language['TXTOVERDUE'],3 => $vis_language['TXTCOMPLETED'],4 => $vis_language['TXTCANCELED'],5 => $vis_language['TXTNOTSTARTED']);
			foreach($report as $details) {  $ovedue_status = '';
				echo '<tr><td><a href="#/releases/releases_details/'.$details['release_hash'].'/'.$details['release_id'].'" target="_blank">'.$details['release_hash'].'</a>'.'</td> <td>'.$details['subject'].'</td><td>'.format_datetime($details['date_created']).'</td> <td><a href="#/home/view_update_tasks/'.$details['task_title'].'/'.$details['task_id'].'" target="_blank">'.$details['task_title'].'</a></td>';
				if(isset($details['enddate_diff']) && $details['enddate_diff']<=0){ if($details ['task_status']!=3 && $details ['task_status']!=4){ 
				$ovedue_status = $vis_language['TXTNOTMAINTAIN']; 	?>
				<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-danger-bg"><?php echo $vis_language['TXTOVERDUE'];?></label></td>
				<?php } else
				{ if($details['task_status']==1) { $ovedue_status = $vis_language['TXTMAINTAIN']; ?>
					<td>	<label id="vis_task_status" class="btn-xs wrapper-xxs vh-success-bg"><?php echo $status[$details['task_status']];?></label></td>
					<?php }else if($details['task_status']==3){ $ovedue_status = $vis_language['TXTMAINTAIN']; ?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-info-bg"><?php echo $status[$details['task_status']];?></label></td>
					<?php }else if($details['task_status']==4){ $ovedue_status = $vis_language['TXTMAINTAIN']; ?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-grey-bg"><?php echo $status[$details['task_status']];?></label></td><?php }
					else if($details['task_status']==5){ $ovedue_status = $vis_language['TXTNOTMAINTAIN'];?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xs label label-default" style="text-align:left;"  ><?php echo $status[$details ['task_status']];?></label></td><?php }
				} ?>
				<?php }else { $ovedue_status = $vis_language['TXTMAINTAIN'];  if($details['task_status']==1) {?>
					<td><label id="vis_task_status" class="btn-xs wrapper-xxs vh-success-bg"><?php echo $status[$details['task_status']];?></label></td>
					<?php }else if($details['task_status']==3){?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-info-bg"><?php echo $status[$details['task_status']];?></label></td>
					<?php }else if($details['task_status']==4){ ?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-grey-bg"><?php echo $status[$details['task_status']];?></label></td><?php }
					else if($details['task_status']==5){ ?>
					<td><label id="vis_task_status" class="btn-xs wrapper-xs label label-default" style="text-align:left;"><?php echo $status[$details ['task_status']];?></label></td><?php } } ?>
					<td  class="txt_nowrap"> <?php echo $ovedue_status; ?></td>
					<? echo '</tr>'; } ?>
	</tbody>
	</table>
<?php 
break;
case 'task_by_status_report':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTTASKTITLE'];?></th>
			<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
			<th><?php echo $vis_language['TXTENDDATE'];?></th>
			<th><?php echo $vis_language['TXTPRIORITY'];?></th>
			<th><?php echo $vis_language['TXTSTATUS'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php $status = array( 1 => $vis_language['TXTINPROGRESS'], 2 => $vis_language['TXTOVERDUE'], 3 => $vis_language['TXTCOMPLETED'], 4 => $vis_language['TXTCANCELED'], 5 => $vis_language['TXTNOTSTARTED']);
			foreach($report as $ticket_id => $details)
			{
				echo '<tr><td ><a href="#/home/view_update_tasks/'.$details['task_title'].'/'.$details['task_id'].'" target="_blank">'.$details['task_title'].'</a></td> <td >'.format_datetime($details['startdate']).'</td><td >'.format_datetime($details['enddate']).'</td><td >'.$details['title'].'</td>        ';
				if($details['enddate_diff']<=0){ if($details ['task_status']!=3 && $details ['task_status']!=4){?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-danger-bg" ><?php echo $vis_language['TXTOVERDUE'];?></label></td>
					<?php } else { if($details['task_status']==1){ ?>
						<td>	<label id="vis_task_status" class="btn-xs wrapper-xxs vh-success-bg"><?php echo $status[$details['task_status']];?></label></td>
						<?php }else if($details['task_status']==3){?>
						<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-info-bg"><?php echo $status[$details['task_status']];?></label></td>
						<?php }else if($details['task_status']==4){ ?>
						<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-grey-bg"><?php echo $status[$details['task_status']];?></label></td><?php }
						else if($details['task_status']==5){ ?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xs label label-default"><?php echo $status[$details['task_status']];?></label></td><?php } } }
					else { if($details['task_status']==1) {?>
						<td><label id="vis_task_status" class="btn-xs wrapper-xxs vh-success-bg"><?php echo $status[$details['task_status']];?></label></td>
						<?php }else if($details['task_status']==3){?>
						<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-info-bg"><?php echo $status[$details['task_status']];?></label></td>
						<?php }else if($details['task_status']==4){ ?>
						<td> <label id="vis_task_status" class="btn-xs wrapper-xxs vh-grey-bg"><?php echo $status[$details['task_status']];?></label></td><?php }
						else if($details['task_status']==5){ ?>
					<td> <label id="vis_task_status" class="btn-xs wrapper-xs label label-default"><?php echo $status[$details['task_status']];?></label></td><?php } } echo '  </tr>'; } ?>
	</tbody>
	</table>
<?php 
break;
case 'task_by_priority_report':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTTASKTITLE'];?></th>
			<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
			<th><?php echo $vis_language['TXTENDDATE'];?></th>
			<th><?php echo $vis_language['TXTPRIORITY'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php $status = array( 1 => $vis_language['TXTINPROGRESS'], 2 => $vis_language['TXTOVERDUE'], 3 => $vis_language['TXTCOMPLETED'], 4 => $vis_language['TXTCANCELED'], 5 => $vis_language['TXTNOTSTARTED']);
			foreach($report as $ticket_id => $details)
			echo '<tr><td ><a href="#/home/view_update_tasks/'.$details['task_title'].'/'.$details['task_id'].'" target="_blank">'.$details['task_title'].'</a></td> <td >'.format_datetime($details['startdate']).'</td><td >'.format_datetime($details['enddate']).'</td><td >'.$details['title'].'</td></tr>';
		?>
	</tbody>
	</table>
<?php 
break;
case 'most_commented_article_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTARTICLE'];?></th>
			<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
			<th><?php echo $vis_language['TXTTICKETCATEGORY'];?></th>
			<th><?php echo "Comment Count";?></th>
		</tr>
	</thead>
	<tbody>
		<?php  foreach($report as $ticket_id => $details) {
			echo '<tr>
			<td><a href="#/solutions/view_article/'.$details['article_title'].'/'.$details['article_id'].'" target="_blank">'.$details['article_title'].'</a></td>
			<td>'.format_datetime($details['article_entry_date']).'</td>
			<td>'.$details['selfhelp_title'].'</td>
			<td>'.$details['article_count'].'</td></tr>';
		} ?>
	</tbody>
	</table>
<?php 
break;
case 'most_rated_articles_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTARTICLE'];?></th>
			<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
			<th><?php echo $vis_language['TXTTICKETCATEGORY'];?></th>
			<th><?php echo $vis_language['TXTTOTAL'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php  foreach($report as $ticket_id => $details) {
			echo '<tr>
			<td><a href="#/solutions/view_article/'.$details['article_title'].'/'.$details['article_id'].'" target="_blank">'.$details['article_title'].'</a></td>
			<td>'.format_datetime($details['entry_date']).'</td>
			<td>'.$details['selfhelp_title'].'</td>
			<td>'.$details['like_count'].'</td></tr>';
		} ?>
	</tbody>
	</table>
<?php 
break;
case 'most_view_articles_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTARTICLE'];?></th>
			<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
			<th><?php echo $vis_language['TXTTICKETCATEGORY'];?></th>
			<th><?php echo $vis_language['TXTTOTAL'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php  foreach($report as $ticket_id => $details) {
			echo '<tr><td><a href="#/solutions/view_article/'.$details['article_title'].'/'.$details['article_id'].'" target="_blank">'.$details['article_title'].'</a></td>
			<td>'.format_datetime($details['entry_date']).'</td>
			<td>'.$details['selfhelp_title'].'</td>
		<td>'.$details['view_count'].'</td></tr>'; } ?>
	</tbody>
	</table>
<?php 
break;
case 'login_act_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTNAME'];?></th>
			<th><?php echo $vis_language['TXTCONTENT'];?></th>
			<th><?php echo $vis_language['TXTDATE'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php
		$start = isset($start)?$start:' ';
		for($i=0;$i<count($report);$i++) {
		if($start!=date('n', $report[$i]['activity_date'])) {
		$start=date('n', $report[$i]['activity_date']);
		}
		echo '<tr><td>'.$report[$i]['first_name'].' '.$report[$i]['last_name'].'</td><td>'.$report[$i]['content'].'</td><td>'.format_datetime($report[$i]['activity_date']).' </td></tr>';
		} ?>
	</tbody>
	</table>
<?php 
break;
case 'staff_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTNAME'];?></th>
			<th><?php echo $vis_language['TXTCONTENT'];?></th>
			<th><?php echo $vis_language['TXTDATE'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php
		$start = isset($start)?$start:' ';
		for($i=0;$i<count($report);$i++) {
			if($start!=date('n', $report[$i]['activity_date'])) {
				$start=date('n', $report[$i]['activity_date']);
			}
			echo '<tr><td>'.$report[$i]['first_name'].' '.$report[$i]['last_name'].'</td><td>'.$report[$i]['content'].'</td><td>'.format_datetime($report[$i]['activity_date']).' </td></tr>';
		}
		?>
	</tbody>
	</table>
<?php 
break;
case 'staff_activity_search_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTNAME'];?></th>
			<th><?php echo $vis_language['TXTCONTENT'];?></th>
			<th><?php echo $vis_language['TXTDATE'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php
			$start = isset($start)?$start:' ';
			for($i=0;$i<count($report);$i++) {
				if($start!=date('n', $report[$i]['activity_date'])) {
					$start=date('n', $report[$i]['activity_date']);
				}
				echo '<tr><td>'.$report[$i]['first_name'].' '.$report[$i]['last_name'].'</td><td>'.$report[$i]['content'].'</td><td>'.format_datetime($report[$i]['activity_date']).' </td></tr>';
			}
		?>
	</tbody>
	</table>
<?php 
break;
case 'staff_point_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><? echo $vis_language['TXTSTAFFNAME']; ?></th>
			<th><? echo $vis_language['TXTTOTALPOINT']; ?></th>
			<th><? echo $vis_language['TXTCURRENTRANK']; ?></th>
			<th><? echo $vis_language['TXTDURATIONPOINT']; ?></th>
		</tr>
	</thead>
		<tbody>
		<? $total=0;
		foreach($result1 as $ticket_id => $details) {
		echo '<tr><td >'.$details['first_name'].' '.$details['last_name'].'</td> <td >'.$details['staff_point'].'</td> <td >';
		$status=$details['level_id'];
		if($status==0 ){ echo '-';}else{
		echo ($status==1)?'<label><i class="vh vh-3x vh-pawn" style="cursor:context-menu;;" title="Pawn"></i></label>':'';
		echo ($status==2)? '<label><i class="vh vh-3x vh-knight" style="cursor:context-menu;;"  title="Knight"></i></label>':'';
		echo ($status==3)?'<label><i class="vh vh-3x vh-bishop" style="cursor:context-menu;;"  title="Bishop" ></i></label>':'';
		echo ($status==4)?'<label><i class="vh vh-3x vh-rook" style="cursor:context-menu;;"  title="Rook"></i></label>':'';
		echo ($status==5)?'<label><i class="vh vh-3x vh-queen" style="cursor:context-menu;;"  title="Queen"></i></label>':'';
		echo ($status==6)?'<label><i class="vh vh-3x vh-king" style="cursor:context-menu;;"  title="King"></i></label>':'';
		}
		$last_month=($details['fastreply_total'] * $report[0]['points'])+($details['slatime_total'] * $report[1]['points'])+($details['overduereply_total'] * $report[2]['points']);
		//$last_month= $total_time;
		echo'  <td >'.$last_month.'</td>';
		echo '  </td>  </tr>';					}
		?>
	</tbody>
	</table>
<?php 
break;
case 'staff_bonus_point_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTSTAFFNAME'];?></th>
			<th><?php echo $vis_language['TXTTOTALPOINT'];?></th>
			<th><?php echo $vis_language['TXTCURRENTRANK'];?></th>
			<th><?php echo $vis_language['TXTARTICLE'];?></th>						
			<!--<th><?php //echo $vis_language['TXTCOMMENT'];?></th>-->
			<th><?php echo $vis_language['TXTHAPPYCUSTOMER'];?></th>
			<th><?php echo $vis_language['TXTUNHAPPYCUSTOMER'];?></th>
			<th><?php echo $vis_language['TXTFORUMTOPIC'];?></th>
			<th><?php echo $vis_language['TXTFORUMTOPIC']." ".strtolower($vis_language['TXTREPLY']);?></th>						
			<th><?php echo $vis_language['TXTNOTE'];?></th>
			<th><?php echo $vis_language['TXTBONUSPOINT'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php $total=0;
	 
			foreach($result1 as $ticket_id => $details) {
				echo '<tr><td >'.$details['first_name'].' '.$details['last_name'].'</td> <td >'.$details['staff_point'].'</td> <td >';
				$status=$details['level_id'];
				if($status==0 ){ echo '-';}else{
					echo ($status==1)?'<a><i class="vh vh-2x vh-pawn" style="cursor:context-menu;;" title="Pawn"></i></a>':'';
					echo ($status==2)? '<a><i class="vh vh-2x vh-knight" style="cursor:context-menu;;"  title="Knight"></i></a>':'';
					echo ($status==3)?'<a><i class="vh vh-2x vh-bishop" style="cursor:context-menu;;"  title="Bishop" ></i></a>':'';
					echo ($status==4)?'<a><i class="vh vh-2x vh-rook" style="cursor:context-menu;;"  title="Rook"></i></a>':'';
					echo ($status==5)?'<a><i class="vh vh-2x vh-queen" style="cursor:context-menu;;"  title="Queen"></i></a>':'';
				echo ($status==6)?'<a><i class="vh vh-2x vh-king" style="cursor:context-menu;;"  title="King"></i></a>':'';}
				echo '</td>';
				echo'<td >'.$details['total_article'].'</td>';
				//echo'<td >'.$details['total_comment'].'</td>';
				echo '<td >'.$details['happy_customer'].'</td>';
				echo '<td >'.$details['unhappy_customer'].'</td>';
				echo '<td >'.$details['total_forumtopic'].'</td>';
				echo '<td >'.$details['total_forumtopic_reply'].'</td>';						
				echo'<td >'.$details['total_notes'].'</td>';							
				echo'<td >'.$details['Bonuspoint'].'</td>';
				echo '</tr>';
			}
		?>
	</tbody>
	</table>
<?php 
break;
case 'quest1_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTQUESTTYPE'];?></th>
			<th><?php echo $vis_language['TXTTOTAL'];?></th>
			<th><?php echo $vis_language['TXTPOINTS'];?></th>
			<th><?php echo $vis_language['TXTRATING'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php if($staff_info!=-1) foreach($staff_info as $ticket_id => $details)
			{
				echo '<tr>';
				if($details ['quest_type'] == 1) $quest_type = $vis_language['TXTRESOLVINGTYPE'];
				elseif($details ['quest_type'] == 2) $quest_type = $vis_language['TXTSELFHELFARTICLE'];
				echo '<td>'.$quest_type.'</td> ';
				if($details ['quest_type'] == 1)
				{
					echo '<td>'.$count_ticket.' </td>';
					echo '<td>'.$details['quest_points'].' </td> ';
					echo '<td>'.$ticket_rating.'</td>';
				}
				if($details ['quest_type'] == 2)
				{
					echo '<td>'.$artical.' </td>';
					echo '<td>'.$details['quest_points'].' </td>';
					echo '<td>'.$article_rating.'</td>';
				}
				echo'</tr>';
			}  ?>
	</tbody>
	</table>
<?php 
break;
case 'ticket_flag_by_user':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
			<th><?php echo $vis_language['TXTSUBJECT'];?></th>
			<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
			<th><?php echo $vis_language['TXTDEPARTMENT'];?></th>
			<th><?php echo $vis_language['TXTFLAG'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php
		for($i=0;$i<count($report);$i++){ ?>
			<tr role="row">
				<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $report[$i]['ticket_hash'];?>/<?php echo $report[$i]['ticket_id'];?>"><?php echo $report[$i]['ticket_hash'];?></a></td>
				<td><?php echo $report[$i]['subject'];?></td>
				<td><?php echo format_datetime($report[$i]['Creation_date']);?></td>
				<td><?php echo $report[$i]['department_name'];?></td>
				<td><?php echo $report[$i]['flag_name'];?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>
<?php 
break;
case 'client_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTCLIENT'];?></th>
				<th><?php echo $vis_language['TXTCLIENTTYPE'];?> </th>
				<th><?php echo $vis_language['TXTEMAIL'];?>  </th>
				<?/*?><th><?php echo $vis_language['TXTTOTALCLOSE'];?> </th><?*/?>
				<th><?php echo $vis_language['TXTCONTACTNUMBER'];?> </th>
				<th><?php echo $vis_language['TXTORGANIZATION'];?> </th>
				<th><?php echo $vis_language['TXTTICKETCOUNT'];?> </th>
				<th><?php echo $vis_language['TXTRPTRRESOLVED']. ' / '. $vis_language['TXTCLOSETKT'];?> </th>
			</tr>
		</thead>
		<tbody>
		 <?php
		for($i=0;$i<count($report);$i++) {
			if($report[$i]['first_name'] =='' && $report[$i]['last_name']=='')
				$client_name = '-';
			else
				$client_name = $report[$i]['first_name'].' '.$report[$i]['last_name'];

			$contactDetails = ($report[$i]['client_type'] == 0)?$report[$i]['email']:$report[$i]['contact_number'];
			
			if($report[$i]['client_type'] == 0) $clientType = $vis_language['TXTEMAILCLIENT'];
			else if($report[$i]['client_type'] == 2) $clientType = $vis_language['TXTCHAT'].' '.$vis_language['TXTCLIENT'];
			else $clientType = $vis_language['TXTCALLCLIENT'];
			echo '<tr>';
			echo '<td>'.$client_name.'</td>';
			echo '<td>'.$clientType.'</td>';
			echo '<td><a href="#/client/client_details/'.$report[$i]['first_name'].' '.$report[$i]['last_name'].'/'.$report[$i]['client_id'].'" target="blank">'.$report[$i]['email'].'</a></td>';
			//echo '<td></td>';
			echo '<td>'.$report[$i]['contact_number'].'</td>';
			echo '<td>'.$report[$i]['organization'].'</td><td>'.$report[$i]['ticket_count'].'</td>';
			echo '<td class="text-nowrap">'.($report[$i]['close_ticket_count'] + $report[$i]['resolv_ticket_count']).'</td></tr>';
		}          ?>
		</tbody>
	</table>
<?php 
break;
case 'time_tracking_client_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTDESCRIPTION'];?></th>
				<th><?php echo $vis_language['TXTSTAFF'];?></th>
				<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTBILLTIME'].' ('.$vis_language['TXTMIN'].')';?></th>
				<th><?php echo $vis_language['TXTWORKTIME'].' ('.$vis_language['TXTMIN'].')';?></th>
				<th><?php echo $vis_language['TXTAMOUNT'].' ('.$currency.')';?></th>
				<!-- <th><?php //echo $vis_language['TXTRPTRRESOLVED']. ' / '. $vis_language['TXTCLOSETKT'];?> </th> -->
			</tr>
		</thead>
		<tbody>
		 <?php   foreach($report as $ticket_id => $details) {
			echo '<tr><td> <a href="#/ticket/ticket_details/'.$details['ticket_hash'].'/'.$details['ticket_id'].'" target="_blank" >'.$details['ticket_hash'].'</a> </td><td>'.$details['subject'].'</td><td>'.$details['description'].'</td><td>'.$details['staff_name'].'</td><td>'.$details['first_name'].' '.$details['last_name'].'</td><td><a href="#/client/client_details/'.$details['first_name'].'/'.$details['client_id'].'" target="_blank" >'.$details['email'].'</a></td><td>'.$details['group_name'].'</td><td>'.format_datetime($details['created_date']).'</td><td>'.$details['bill_time'].'</td><td>'.$details['work_time'].'</td><td>'.$details['amount'].'</td></tr>';
			} ?>
		</tbody>
	</table>
<?php 
break;
case 'clients_by_organization_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTCLIENT'];?></th>
			<th><?php echo $vis_language['TXTEMAIL'];?></th>
			<th><?php echo $vis_language['TXTCONTACTNUMBER'];?></th>
			<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
		</tr>
	</thead>
	<tbody>
	 <?php  
		foreach($report as $details) {
			if($details['contact_number']!=''){
				$contact_number = $details['contact_number'];
				}else{
				$contact_number = '-';
			}
			echo '<tr>';
			echo '<td>'.$details['first_name'].' '.$details['last_name'].'</a></td>';
			echo '<td><a href="#/client/client_details/'.$details['first_name'].'/'.$details['client_id'].'" target="_blank" >'.$details['email'].'</a></td>';
			echo '<td>'.$contact_number.'</td>';
			echo '<td>'.$details['group_name'].'</td>';
			echo '</tr>';
		}		
	?>	
	</tbody>
</table>
<?php 
break;
case 'client_group_ticket_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
			<th><?php echo $vis_language['TXTSUBJECT'];?></th>
			<th><?php echo $vis_language['TXTEMAIL'];?></th>
			<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
			<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
			<th><?php echo $vis_language['TXTAVGSLA'];?></th>
			<th><?php echo $vis_language['TXTRESOLUTIONTIME'];?></th>
		</tr>
	</thead>
	<tbody>
	 <?php
		 foreach($report_new as $ticket_id => $details) {
			echo '<tr>
			<td> <a href="#/ticket/ticket_details/'.$details['ticket_hash'].'/'.$details['ticket_id'].'" target="_blank">'.$details['ticket_hash'].'</a> </td>
			<td>'.$details['subject'].'</td>
			<td><a href="#/client/client_details/'.$details['first_name'].'/'.$details['client_id'].'" target="_blank" >'.$details['email'].'</a></td>
			<td>'.$details['group_name'].'</td>
			<td>'.format_datetime($details['ticket_entry']).'</td>
			<td>';
			$resolution_flag = ($details['pause_rtime']!='') ? $details['pause_rtime']:'';

			if(isset($details['slapause_diff'])){ $sla_diff = $details['slapause_diff'];}else{ $sla_diff=0;}

		 	/* if(isset($details['avg_time']) && $details['avg_time']!=0){
		 	echo (isset($details['avg_time']) && $details['avg_time']!=0)?count_remain_time(round($details['avg_time'])):$vis_language['TXTNOTRESPONDED'];
		 	}else{ echo $vis_language['TXTNOTRESPONDED']; }*/
			 if(isset($details['avg_time']) && $details['avg_time']!=0)
                {   
                    if(($details['operation_id']==0 && ($details['operator']==2 && $details['as_client']!=1)))
                    {
                        echo '0S';
                    }
                    else
                    {
                        echo count_remain_time(round($details['avg_time']));
                    }
                }
                else
                {                    
                    if($details['operator']==2 && $details['as_client']!=1)
                    {
                        echo '0S';
                    }
                    else
                    {
                        echo $vis_language['TXTNOTRESPONDED'];
                    }
                }
			echo '</td>
			<td>';
			if($details['solve_time'] < 0 && ($details['status_id'] == 3 || $details['status_id'] == 4)){
				$resolution_time = $vis_language['TXTUNDUE'];
			}else if (($details['solve_time'] < 0 || $details['remain_resolve'] < 0) && ($details['status_id'] != 3 && $details['status_id'] != 4)) {
				$resolution_time = $vis_language['TXTOVERDUE'];
			} else if (($details['solve_time'] > 0 || $details['remain_resolve'] > 0) && ($details['status_id'] != 3 && $details['status_id'] != 4)) 
			{
				/* if($details['count']!= 0) //if replied.
				{
					$resolution_time = $vis_language['TXTUNDUE'];
				}
				else
				{ */
					$resolution_time = $vis_language['MSGNOTRESOLVED'];
				/* } */
			} else{
				$calculate_resolve_time = $details['solve_time'] - $details['closed_time'];
				if($calculate_resolve_time > 0){
					$resolution_time = count_remain_time($details['closed_time'] - $details['applyslaresol_time']);
				}else{
					$resolution_time = $vis_language['TXTOVERDUE'];
				}
			}
			$resolution_time = ($details['pause_rtime']!='') ? $vis_language['TXTSLAPAUSED']:$resolution_time;
			echo $resolution_time;
			
			echo '</td></tr>';
		} ?>
	</tbody>
</table>
<?php 
break;
case 'organization_count_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTORGNAME'];?></th>
			<th><?php echo $vis_language['TXTTOTALTICKETS'];?></th>
			<th><?php echo $vis_language['TXTTOTALCLIENT'];?></th>
			<th><?php echo $vis_language['TXTTOTALOPEN'];?></th>
			<th><?php echo $vis_language['TXTTOTALCLOSE']."/".$vis_language['TXTTOTALRESOLVED'];?></th>
		</tr>
	</thead>
	<tbody>
	 <?php 
		$i = 0;
		foreach($post_details['group'] as $key => $details) {
			echo '<tr>
			<td>'.$details['group_name'].'</td>
			<td>'.$details['ticket_cnt'].'</td>
			<td>'.$details['client_cnt'].'</td>';
				    if($post_details['closed'][$i]['group_name'] == $details['group_name'] ) {
				        echo '<td>'.($details['ticket_cnt'] - $post_details['closed'][$i]['closed_cnt']).'</td>';
				        echo '<td>'.$post_details['closed'][$i]['closed_cnt'].'</td>';
				        $i++;
				    } else {
				        echo '<td>'.$details['ticket_cnt'].'</td>';
				        echo '<td>0</td>';
				    }
                       
			echo '</tr>';
		} ?>
	</tbody>
</table>
<?php 
break;
case 'client_with_maximum_ticket_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTCLIENT'];?></th>
			<th><?php echo $vis_language['TXTCLIENTTYPE'];?></th>
			<th><?php echo $vis_language['TXTEMAIL'];?></th>
			<th><?php echo $vis_language['TXTCONTACT'];?></th>
			<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
			<th><?php echo $vis_language['TXTTOTALOPENTICKET'];?></th>
			<th><?php echo $vis_language['TXTTOTALTICKET'];?></th>
		</tr>
	</thead>
	<tbody>
	 <?php  
	 foreach($report as $ticket_id => $details) {
		echo '<tr>
		<td> '.$details['first_name'].' '.$details['last_name'].'</td>';
		if($details['client_type']==0){
			echo '<td> '.$vis_language['TXTEMAILCLIENT'] .' </td>';
			}else{
			echo '<td> '.$vis_language['TXTCALLCLIENT'] .' </td>';
		}
		echo '<td class="txt_nowrap"><a href="#/client/client_details/'.$details['first_name'].'/'.$details['client_id'].'" target="_blank">'.$details['email'].'</a></td>
		<td>'.$details['contact_number'].'</td>
		<td>'.$details['organizations'].'</td>
		<td>'.$details['openc'].'</td>
		<td>'.$details['ticket_count'].'</td></tr>';
	 } ?>
	</tbody>
</table>
<?php 
break;
case 'customfield_data_userreg_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
			<th><?php echo $vis_language['TXTEMAIL'];?></th>
			<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
			<th><?php echo $vis_language['TXTFIELDNAME'];?></th>
			<th><?php echo $vis_language['TXTFLDVAL'];?> </th>
		</tr>
	</thead>
	<tbody>
	 <?php
		$html ='';
		for($i=0;$i<count($report);$i++) {
		$html.='<tr><td>'.$report[$i]['first_name'].' '.$report[$i]['last_name'].'</td><td>'.$report[$i]['email'].'</td><td>'.$report[$i]['group_name'].'</td><td>'.$report[$i]['field_name'].'</td>'.'<td>'.$report[$i]['content'].'</td>';
		$html.='</tr></span>';
		}  		
		echo $html;
	?>
	</tbody>
</table>
<?php 
break;
case 'customfield_data_orgreg_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
			<th><?php echo $vis_language['TXTEMAIL'];?></th>
			<th><?php echo $vis_language['TXTDOMAIN'];?></th>
			<th><?php echo $vis_language['TXTFIELDNAME'];?></th>
			<th><?php echo $vis_language['TXTFLDVAL'];?> </th>
		</tr>
	</thead>
	<tbody>
	<?php
		$html ='';
		for($i=0;$i<count($report);$i++) {
			$html.='<tr><td>'.$report[$i]['group_name'].' </td><td>'.$report[$i]['office_email'].'</td><td>'.$report[$i]['domain_name'].'</td><td>'.$report[$i]['field_name'].'</td>'.'<td>'.$report[$i]['content'].'</td>';
			$html.='</tr></span>';
		}  		
		echo $html;
		?>
	</tbody>
</table>
<?php 
break;
case 'billing_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTCLIENT'];?></th>
			<th><?php echo $vis_language['TXTEMAIL'];?></th>
			<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
			<th><?php echo $vis_language['TXTCLIENTTYPE'];?></th>
			<th><?php echo $vis_language['TXTCONTACTNUMBER'];?></th>
			<th><?php echo $vis_language['TXTTKTBAL'];?></th>
			<th><?php echo $vis_language['TXTTIMECREDIT'];?></th>
			<th><?php echo $vis_language['TXTTOTALINVOICEID'];?></th>
			<th><?php echo $vis_language['TXTPAID'];?></th>
			<th><?php echo $vis_language['TXTUNPAID'];?></th>
			<th><?php echo $vis_language['TXTCANCELED'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php
		for($i=0;$i<count($report);$i++) {
			if($report[$i]['first_name'] =='' && $report[$i]['last_name']=='')
				$client_name = '-';
			else
				$client_name = $report[$i]['first_name'].' '.$report[$i]['last_name'];

			$minutes=$report[$i]['credit'];
			$days    = floor($minutes / 1440);
			$hrs   = floor(($minutes - ($days * 1440)) / 60);
			$min = floor($minutes - ($days * 1440) - ($hrs * 60));
			$time_credit = $days.'D '.$hrs.'H '.$min.'M';

			$clientType = ($report[$i]['client_type'] == 0)?$vis_language['TXTEMAILCLIENT']:$vis_language['TXTCALLCLIENT'];
			echo '<tr>';
			echo '<td > '.$client_name.' </td>';
			echo '<td ><a href="#/client/client_details/'.$report[$i]['first_name'].' '.$report[$i]['last_name'].'/'.$report[$i]['client_id'].'" target="blank">'.$report[$i]['email'].'</a></td>';
			echo '<td >'.$report[$i]['group_name'].'</td>';
			echo '<td > '.$clientType.' </td>';
			echo '<td >'.$report[$i]['contact_number'].'</td>';
			echo '<td >'.$report[$i]['balance'].'</td><td>'.$time_credit.'</td><td >'.($report[$i]['paid_count']+$report[$i]['unpaid_count']+$report[$i]['cancel_count']).'</td><td >'.$report[$i]['paid_count'].'</td><td >'.$report[$i]['unpaid_count'].'</td><td >'.$report[$i]['cancel_count'].'</td></tr>';
		} ?>
	</tbody>
</table>
<?php 
break;
case 'invoiceby_domain_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTINVOICEHASH'];?></th>
			<th><?php echo $vis_language['TXTREFERENCE'];?></th>
			<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
			<th><?php echo $vis_language['TXTEMAIL'];?></th>
			<th><?php echo $vis_language['TXTDOMAIN'];?></th>
			
			<th><?php echo $vis_language['TXTINVOICEDATE'];?></th>
			<th><?php echo $vis_language['TXTDUEDATE'];?></th>
			<th><?php echo $vis_language['TXTPAIDDATE'];?></th>
			<th><?php echo $vis_language['TXTAMOUNT'].' ('.$currency.')';?></th>
			<th><?php echo $vis_language['TXTBILLINGSTATUS'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php 
			$invoice_status = array( 0 => $vis_language['TXTUNPAID'], 1 => $vis_language['TXTPAID'], 2 => $vis_language['TXTCANCELED'], 3 => $vis_language['TXTINPROCESS'] );
			foreach($report as $ticket_id => $details) {
				if($details ['invoice_status'] == 0){
					$lableCol = 'vh-danger-bg';
				}else if($details ['invoice_status'] == 1){
					$lableCol = 'label vh-green-bg';
				}else{
					$lableCol = 'label label-default';
				}

				if($details['ticket_id']==0 && $details['product_id']!=0){
					$reference = $details['product_name'];
				}elseif($details['ticket_id']!=0 && $details['product_id']==0){
					$ticket_hash = ($details['ticket_hash']=='')?'-':$details['ticket_hash'];
					$reference = '<a href="#/ticket/ticket_details/'.$details['ticket_hash'].'/'.$details['ticket_id'].'" target="blank">'.$ticket_hash.'</a>';
				}else{
					$reference = $vis_language['TXTCLIENT'];
				}

				echo '<tr><td><a href="#/billing/edit_invoice/invoices/'.$details['invoice_id'].'" target="blank">'.$details['invoice_hash'].'</a></td><td>'.$reference.'</td><td>'.$details['first_name'].' '.$details['last_name'].'</td><td><a  href="#/client/client_details/'.$details['first_name'].'/'.$details['client_id'].'" target="blank">'.$details['email'].'</a></td><td>'.$details['domain_name'].'</td><td >'.format_datetime($details['entry_date']).'</td><td>'.format_datetime($details['due_date']).'</td><td>'.format_datetime($details['paid_date']).'</td><td>'.$details['amount'].'</td>';
				echo '<td><span class="label '.$lableCol.'">'.$invoice_status[$details['invoice_status']].'</span></td>';
				echo '  </tr>';
			}
		?>
	</tbody>
</table>
<?php 
break;
case 'client_packages_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTBILLINGCYCLE'];?></th>
			<th><?php echo substr($vis_language['TXTPACKAGES'],0,-1);?></th>
			<th><?php echo $vis_language['TXTINVOICEHASH'];?></th>
			<th><?php echo $vis_language['TXTINVOICEDATE'];?></th>
			<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
			<th><?php echo $vis_language['TXTAMOUNT'].' ('.$currency.')';?></th>
			<th><?php echo $vis_language['TXTBILLINGSTATUS'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php 
			$invoice_status = array( 0 => $vis_language['TXTUNPAID'], 1 => $vis_language['TXTPAID'], 2 => $vis_language['TXTCANCELED'], 3 => $vis_language['TXTINPROCESS'] );
			foreach($report as $ticket_id => $details) {
				if($details ['billing_cycle'] ==0){
					$billing_cycle = $vis_language['TXTVALIDITYONETIME'];
				}else if($details ['billing_cycle'] ==1){
					$billing_cycle = $vis_language['TXTVALIDITYMONTHLY'];
				}else if($details ['billing_cycle'] ==2){
					$billing_cycle = $vis_language['TXTVALIDITYQUARTERLY'];
				}else if($details ['billing_cycle'] ==3){
					$billing_cycle = $vis_language['TXTVALIDITYSEMIANNUALLY'];
				}else if($details ['billing_cycle'] ==4){
					$billing_cycle = $vis_language['TXTVALIDITYANNUALLY'];
				}

				if($details ['invoice_status'] == 0){
					$lableCol = 'vh-danger-bg';
				}else if($details ['invoice_status'] == 1){
					$lableCol = 'label vh-green-bg';
				}else{
					$lableCol = 'label label-default';
				}

				if($details['ticket_id']==0 && $details['product_id']!=0){
					$reference = $details['product_name'];
				}elseif($details['ticket_id']!=0 && $details['product_id']==0){
					$ticket_hash = ($details['ticket_hash']=='')?'-':$details['ticket_hash'];
					$reference = '<a href="#/ticket/ticket_details/'.$details['ticket_hash'].'/'.$details['ticket_id'].'" target="blank">'.$ticket_hash.'</a>';
				}else{
					$reference = $vis_language['TXTCLIENT'];
				}

				echo '<tr><td>'.$billing_cycle.'</td><td>'.$details['product_name'].'</td><td><a href="#/billing/edit_invoice/invoices/'.$details['invoice_id'].'" target="blank">'.$details['invoice_hash'].'</a></td><td >'.format_datetime($details['entry_date']).'</td><td>'.$details['first_name'].' '.$details['last_name'].'</td><td>'.$details['amount'].'</td>';
				echo '<td><span class="label '.$lableCol.'">'.$invoice_status[$details['invoice_status']].'</span></td>';
				echo '  </tr>';
			}
		?>
	</tbody>
</table>
<?php 
break;
case 'billing_invoice_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTINVOICEHASH'];?></th>
			<th><?php echo $vis_language['TXTREFERENCETICKET'];?></th>
			<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
			<th><?php echo $vis_language['TXTEMAIL'];?></th>
			<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
			<th><?php echo $vis_language['TXTINVOICEDATE'];?></th>
			<th><?php echo $vis_language['TXTDUEDATE'];?></th>
			<th><?php echo $vis_language['TXTPAIDDATE'];?></th>
			<th><?php echo $vis_language['TXTAMOUNT'].'('.$currency.')';?></th>
			<th><?php echo $vis_language['TXTBILLINGSTATUS'];?></th>
		</tr>
	</thead>
	<tbody>
	<?php 
	$invoice_status = array( 0 => $vis_language['TXTUNPAID'], 1 => $vis_language['TXTPAID'], 2 => $vis_language['TXTCANCELED'], 3 => $vis_language['TXTINPROCESS'] );
	foreach($report as $ticket_id => $details) {
	if($details ['invoice_status'] == 0)
	{
		$lableCol = 'vh-danger-bg';
	}
	else if($details ['invoice_status'] == 1)
	{
		$lableCol = 'label vh-green-bg';
	}
	else
	{
		$lableCol = 'label label-default';
	}
	if($details['paid_date']==0){
		$paid_date = '-';
	}else{
		$paid_date = date(VIS_EDITDATETIMEPICKER_FORMAT,$details['paid_date']);
	}
		$fulnam = $details['first_name'];
		if($details['first_name']!=''){
		$fulnam .= ' '.$details['last_name'];
		}
	echo '<tr><td><a href="#/billing/edit_invoice/invoices/'.$details['invoice_id'].'" target="blank">'.$details['invoice_hash'].'</a></td><td><a href="#/ticket/ticket_details/'.$details['ticket_hash'].'/'.$details['ticket_id'].'" target="blank">'.$details['ticket_hash'].'</a></td><td>'.$details['first_name'].' '.$details['last_name'].'</td><td><a href="#/client/client_details/'.$fulnam.'/'.$details['client_id'].'" target="blank">'.$details['email'].'</a></td><td>'.$details['group_name'].'</td><td >'.date(VIS_EDITDATETIMEPICKER_FORMAT,$details['entry_date']).'</td><td>'.date(VIS_EDITDATETIMEPICKER_FORMAT,$details['due_date']).'</td><td>'.$paid_date.'</td><td>'.$details['amount'].'</td><td><span class="label '.$lableCol.'">'.$invoice_status[$details['invoice_status']].'</span></td>';
	echo ' </tr>';
	}
	?>
	</tbody>
</table>
<?php 
break;
case 'billing_client_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTINVOICE']." hash";?></th>
			<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
			<th><?php echo $vis_language['TXTEMAIL'];?></th>
			<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
			<th><?php echo $vis_language['TXTINVOICEDATE'];?></th>
			<th><?php echo $vis_language['TXTDUEDATE'];?></th>
			<th><?php echo $vis_language['TXTPAIDDATE'];?></th>
			<th><?php echo $vis_language['TXTAMOUNT'].' ('.$domain[0]['currency'].')';?></th>
			<th><?php echo $vis_language['TXTBILLINGSTATUS'];?></th>
		</tr>
	</thead>
	<tbody>
	<?
		$total2=0;$paid=0;$unpaid=0;
		for($i=0;$i<count($report);$i++) {
			if($report[$i]['invoice_status'] == 0)$unpaid +=$report[$i]['total'];
            else if($report[$i]['invoice_status'] == 1)$paid +=$report[$i]['total'];
			$total2 +=$report[$i]['total'];
		}
		$invoice_status = array( 0 => $vis_language['TXTUNPAID'], 1 => $vis_language['TXTPAID'], 2 => $vis_language['TXTCANCELED'], 3 => $vis_language['TXTINPROCESS'] );

		for($i=0;$i<count($report);$i++) {
			$clientContact = ($report[$i]['client_type']==0)?$report[$i]['email']:$report[$i]['contact_number'];
			echo '<tr>';
			$lableCol = '';
			if($report[$i]['invoice_status'] == 0){
				$lableCol = 'vh-danger-bg';
			} else if($report[$i]['invoice_status'] == 1){
				$lableCol = 'label vh-green-bg';
			}else{
				$lableCol = 'label label-default';
			}

			// Newly added code to check paid date empty or not and show value
			if($report[$i]['paid_date']==0){
				$paid_date = '---';
			}else{
				$paid_date = format_datetime($report[$i]['paid_date']);
			}
		?>

		<td class="vis-pointer"><a href="#/billing/edit_invoice/invoices/<?php echo $report[$i]['invoice_id']?>" target="blank"><? echo $report[$i]['invoice_hash'];?></a></td>
		<td class="vis-pointer"><a href="#/client/client_details/<? echo $report[$i]['first_name']; ?>/<? echo $report[$i]['client_id'];?>" target="blank"><? echo $report[$i]['first_name'].' '.$report[$i]['last_name'];?></a></td>


		<td class="vis-pointer"><a href="#/client/client_details/<? echo $report[$i]['first_name']; ?>/<? echo $report[$i]['client_id'];?>" target="blank"><? echo $clientContact ;?></a></td><? echo '<td>'.$report[$i]['group_name'].'</td><td>'.format_datetime($report[$i]['entry_date']).'</td><td>'.format_datetime($report[$i]['due_date']).'</td><td>'.$paid_date.'</td><td>'.$report[$i]['total'].'</td><td><span class="label '.$lableCol.'">'.$invoice_status[$report[$i]['invoice_status']].'</span></td>';
		} ?>
	</tbody>
</table>
<?php 
break;
case 'invoiceby_organization_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTINVOICEHASH'];?></th>
			<th><?php echo $vis_language['TXTREFERENCE'];?></th>
			<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
			<th><?php echo $vis_language['TXTEMAIL'];?></th>
			<th><?php echo $vis_language['TXTORGANIZATION'];?></th>			
			<th><?php echo $vis_language['TXTINVOICEDATE'];?></th>
			<th><?php echo $vis_language['TXTDUEDATE'];?></th>
			<th><?php echo $vis_language['TXTPAIDDATE'];?></th>
			<th><?php echo $vis_language['TXTAMOUNT'].'('.$currency.')';?></th>
			<th><?php echo $vis_language['TXTBILLINGSTATUS'];?></th>
		</tr>
	</thead>
	<tbody>
	<?php 
		$invoice_status = array( 0 => $vis_language['TXTUNPAID'], 1 => $vis_language['TXTPAID'], 2 => $vis_language['TXTCANCELED'], 3 => $vis_language['TXTINPROCESS'] );
		foreach($report as $ticket_id => $details) {
			if($details ['invoice_status'] == 0)
			{
				$lableCol = 'vh-danger-bg';
			}
			else if($details ['invoice_status'] == 1)
			{
				$lableCol = 'label vh-green-bg';
			}
			else
			{
				$lableCol = 'label label-default';
			}
			$fulnam = $details['first_name'];
			if($details['first_name']!=''){
			$fulnam .= ' '.$details['last_name'];
			}
			if($details['ticket_id']!=0 ){
				$ticket_hash = ($details['ticket_hash']=='')?'-':$details['ticket_hash'];
				$reference = '<a href="#/ticket/ticket_details/'.$details['ticket_hash'].'/'.$details['ticket_id'].'" target="blank">'.$ticket_hash.'</a>';
			}elseif($details['balance_type']!=''){
				if($details['balance_type']==1) $reference = 'Time credit';
				elseif($details['balance_type']==0) $reference = 'Incident credit';
			}else{
				$reference = $vis_language['TXTCLIENT'];
			}
			echo '<tr><td><a href="#/billing/edit_invoice/invoices/'.$details['invoice_id'].'" target="blank">'.$details['invoice_hash'].'</a></td><td>'.$reference.'</td><td>'.$details['first_name'].' '.$details['last_name'].'</td><td><a href="#/client/client_details/'.$fulnam.'/'.$details['client_id'].'" target="blank" >'.$details['email'].'</a></td><td>'.$details['group_name'].'</td><td >'.format_datetime($details['entry_date']).'</td><td>'.format_datetime($details['due_date']).'</td><td>'.format_datetime($details['paid_date']).'</td><td>'.$details['amount'].'</td>';
			echo '<td><span class="label '.$lableCol.'">'.$invoice_status[$details['invoice_status']].'</span></td>';
			echo '  </tr>';
		}
		?>
	</tbody>
</table>
<?php 
break;
case 'order_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTORDERHASH'];?></th>
			<th><?php echo $vis_language['TXTINVOICEHASH'];?></th>
			<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
			<th><?php echo $vis_language['TXTEMAIL'];?></th>
			<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
			<th><?php echo $vis_language['TXTPAIDDATE'];?></th>
			<th><?php echo $vis_language['TXTAMOUNT'].' ('. $currency .')';?></th>
			<th><?php echo $vis_language['TXTBILLINGSTATUS'];?></th>
			<th><?php echo $vis_language['TXTSTATUS'];?></th>
		</tr>
	</thead>
	<tbody>
	<?php
	foreach($report as $ticket_id => $details) {
		$fulnam = $details['first_name'];
		if($details['first_name']!=''){
		$fulnam .= ' '.$details['last_name'];
		}
		if($details ['invoice_status'] == 0)
		    {
		        $lableCol = 'vh-danger-bg';
		    }
		    else if($details ['invoice_status'] == 1)
		    {
		        $lableCol = 'label vh-green-bg';
		    }
		    else
		    {
		        $lableCol = 'label label-default';
		    }
		echo '<tr><td>'.$details['order_hash'].'</td> <td><a href="#/billing/edit_invoice/invoices/'.$details['invoice_id'].'" target="blank">'.$details['invoice_hash'].'</a></td><td>'.$details['first_name'].' '.$details['last_name'].'</td><td><a href="#/client/client_details/'.$fulnam.'/'.$details['client_id'].'" target="blank" >'.$details['email'].'</a></td><td>'.$details['group_name'].'</td><td>'.format_datetime($details['paid_date']).'</td> <td>'.$details['amount'].'</td>  <td> <span class="label '.$lableCol.'"> ';
		$status=$details['invoice_status'];
		echo ($status==0)?$vis_language['TXTUNPAID']:'';
		echo ($status==1)? $vis_language['TXTPAID']:'';
		echo ($status==2)?$vis_language['TXTCANCELED']:'';
		echo ($status==3)?$vis_language['TXTINPROCESS']:'';
		echo '</span> </td> ';
		echo ' <td> ';
		$status=$details['order_status'];
		echo ($status==1)?$vis_language['TXTACTIVE']:'';
		echo ($status==2)? $vis_language['TXTPENDING']:'';
		echo ($status==3)? $vis_language['TXTINCOMPLETE']:'';
		echo ($status==4)?$vis_language['TXTCANCELED']:'';
		echo '</td> </tr>';
	}	 
	?>
	</tbody>
</table>
<?php 
break;
case 'transaction_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTINVOICEHASH'];?></th>
			<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
			<th><?php echo $vis_language['TXTEMAIL'];?></th>
			<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
			<th><?php echo $vis_language['TXTDESCRIPTION'];?></th>
			<th><?php echo $vis_language['TXTTRANSACTIONID'];?></th>
			<th><?php echo $vis_language['TXTINVOICE'].' '.$vis_language['TXTDATE'];?></th>
			<th><?php echo $vis_language['TXTTRANSACTIONDATE'];?></th>
			<th><?php echo $vis_language['TXTAMOUNT'].' ('.$currency.')';?></th>
			<th><?php echo $vis_language['TXTBILLINGSTATUS'];?></th>
		</tr>
	</thead>
	<tbody>
	<?php 
	$invoice_status = array( 0 => $vis_language['TXTUNPAID'], 1 => $vis_language['TXTPAID'], 2 => $vis_language['TXTCANCELED'], 3 => $vis_language['TXTINPROCESS'] );
	foreach($report as $ticket_id => $details) {
	if($details ['invoice_status'] == 0){
	$lableCol = 'vh-danger-bg';
	}else if($details ['invoice_status'] == 1){
	$lableCol = 'label vh-green-bg';
	}else{
	$lableCol = 'label label-default';
	}
	$fulnam = $details['first_name'];
	if($details['first_name']!=''){
	$fulnam .= ' '.$details['last_name'];
	}
	echo '<tr><td> <a href="#/billing/edit_invoice/invoices/'.$details['invoice_id'].'" target="blank">'.$details['invoice_hash'].'</a></td><td>'.$details['first_name'].' '.$details['last_name'].'</td><td><a href="#/client/client_details/'.$fulnam.'/'.$details['client_id'].'" target="blank" >'.$details['email'].'</a></td><td>'.$details['group_name'].'</td><td>'.$details['description'].'</td><td>'.$details['transaction_id'].'</td> <td>'.format_datetime($details['invoicedate']).'</td><td>'.format_datetime($details['entry_date']).'</td><td>'.$details['amount'].'</td>   ';
	echo '<td><span class="label '.$lableCol.'">'.$invoice_status[$details['invoice_status']].'</span></td>';
	echo '  </tr>';
	} ?>
	</tbody>
</table>
<?php 
break;
case 'client_order_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
		<th><?php echo $vis_language['TXTORDERHASH'];?></th>
		<th><?php echo $vis_language['TXTINVOICEHASH'];?></th>
		<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
		<th><?php echo $vis_language['TXTEMAIL'];?></th>
		<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
		<th><?php echo $vis_language['TXTINVOICEDATE'];?></th>
		<th><?php echo $vis_language['TXTDUEDATE'];?></th>
		<th><?php echo $vis_language['TXTPAIDDATE'];?></th>
		<th><?php echo $vis_language['TXTAMOUNT'].' ('.$currency.')';?></th>
		<th><?php echo $vis_language['TXTBILLINGSTATUS'];?></th>
		</tr>
	</thead>
	<tbody>
	<?php 
	$invoice_status = array( 0 => $vis_language['TXTUNPAID'], 1 => $vis_language['TXTPAID'], 2 => $vis_language['TXTCANCELED'], 3 => $vis_language['TXTINPROCESS'] );
	foreach($report as $ticket_id => $details) {
		 if($details ['invoice_status'] == 0)
	    {
			$lableCol = 'vh-danger-bg';
		}
		else if($details ['invoice_status'] == 1)
		{
			$lableCol = 'label vh-green-bg';
		}
		else
		{
			$lableCol = 'label label-default';
		}
		$fulnam = $details['first_name'];
		if($details['first_name']!=''){
		$fulnam .= ' '.$details['last_name'];
		}
		echo '<tr><td>'.$details['order_hash'].'</td><td><a href="#/billing/edit_invoice/invoices/'.$details['invoice_id'].'" target="blank">'.$details['invoice_hash'].'</a></td><td>'.$details['first_name'].' '.$details['last_name'].'</td><td><a href="#/client/client_details/'.$fulnam.'/'.$details['client_id'].'" target="blank" >'.$details['email'].'</a></td><td>'.$details['group_name'].'</td><td>'.format_datetime($details['entry_date']).'</td></td><td>'.format_datetime($details['due_date']).'</td><td>'.format_datetime($details['paid_date']).'</td>   <td>'.$details['amount'].'</td>    ';

		echo '<td><span class="label '.$lableCol.'">'.$invoice_status[$details['invoice_status']].'</span></td>';

		echo '<td></td></tr>';
	}  ?>
	</tbody>
</table>
<?php 
break;
case 'client_transaction_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
		<th><?php echo $vis_language['TXTINVOICEHASH'];?></th>
		<th><?php echo $vis_language['TXTDESCRIPTION'];?></th>
		<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
		<th><?php echo $vis_language['TXTEMAIL'];?></th>
		<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
		<th><?php echo $vis_language['TXTTRANSACTIONID'];?></th>
		<th><?php echo $vis_language['TXTINVOICEDATE'];?></th>
		<th><?php echo $vis_language['TXTTRANSACTIONDATE'];?></th>
		<th><?php echo $vis_language['TXTAMOUNT'].' ('.$currency.')';?></th>
		<th><?php echo $vis_language['TXTBILLINGSTATUS'];	 ?></th>
		</tr>
	</thead>
	<tbody>
	<?php 
	$invoice_status = array( 0 => $vis_language['TXTUNPAID'], 1 => $vis_language['TXTPAID'], 2 => $vis_language['TXTCANCELED'], 3 => $vis_language['TXTINPROCESS'] );
	foreach($report as $ticket_id => $details) {
		if($details ['invoice_status'] == 0)
		{
			$lableCol = 'vh-danger-bg';
		}else if($details ['invoice_status'] == 1){
			$lableCol = 'label vh-green-bg';
		}else{
			$lableCol = 'label label-default';
		}
		$fulnam = $details['first_name'];
		if($details['first_name']!=''){
		$fulnam .= ' '.$details['last_name'];
		}
		echo '<tr><td><a href="#/billing/edit_invoice/invoices/'.$details['invoice_id'].'" target="blank">'.$details['invoice_hash'].'</a></td> <td>'.$details['description'].'</td><td>'.$details['first_name'].' '.$details['last_name'].'</td><td><a href="#/client/client_details/'.$fulnam.'/'.$details['client_id'].'" target="blank" >'.$details['email'].'</a></td><td>'.$details['group_name'].'</td><td>'.$details['transaction_id'].'</td><td>'.format_datetime($details['invoice_date']).'</td><td>'.format_datetime($details['entry_date']).'</td><td>'.$details['amount'].'</td>';
		echo '<td><span class="label '.$lableCol.'">'.$invoice_status[$details['invoice_status']].'</span></td>';
		echo '</tr>';
	}	
	?>
	</tbody>
</table>
<?php 
break;
case 'time_tracking_organization_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
		<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
		<th><?php echo $vis_language['TXTSUBJECT'];?></th>
		<th><?php echo $vis_language['TXTDESCRIPTION'];?></th>
		<th><?php echo $vis_language['TXTSTAFF'];?></th>
		<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
		<th><?php echo $vis_language['TXTEMAIL'];?></th>
		<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
		<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
		<th><?php echo $vis_language['TXTBILLTIME'].' ('.$vis_language['TXTMIN'].')';?></th>
		<th><?php echo $vis_language['TXTWORKTIME'].' ('.$vis_language['TXTMIN'].')';?></th>
		<th><?php echo $vis_language['TXTAMOUNT'].' ('.$currency.')';?></th>
		</tr>
	</thead>
	<tbody>
	<?php  
	foreach($report as $ticket_id => $details){ ?>
	<tr role="row">
		<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $details['ticket_hash'];?>/<?php echo $details['ticket_id'];?>" target="_blank"><?php echo $details['ticket_hash']?></a></td>
		<td><?php echo $details['subject'];?></td>
		<td><?php echo $details['description'];?></td>
		<td><?php echo $details['staff_name'];?></td>
		<td><?php echo $details['first_name'].' '.$details['last_name'];?></td>
		<td><a href="#/client/client_details/<?php echo $details['first_name'].'/'.$details['client_id']; ?>" target="_blank" ><?php echo $details['email'];?></a></td>
		<td><?php echo $details['group_name'];?></td>
		<td><?php echo format_datetime($details['created_date']);?></td>
		<td><?php echo $details['bill_time'];?></td>
		<td><?php echo $details['work_time'];?></td>
		<td><?php echo $details['amount'];?></td>
	</tr><?php
	}
	?>
	</tbody>
</table>
<?php 
break;
case 'client_sla_report':
?>
<table class="table table-hover table-striped">
<thead>
    <tr role="row">
        <th><?php if($filter1==0) {	echo $vis_language['TXTINCISERVICEHASH']; }			
        		  elseif($filter1==2) { echo $vis_language['TXTSERVICEREQHASH']; }
				  else { echo $vis_language['TXTTICKETHASH']; } ?></th>
        <th><?php echo $vis_language['TXTSUBJECT'];?></th>
        <th><?php echo $vis_language['TXTCREATIONDATE'];?></th>                     
        <th><?php echo $vis_language['TXTCLIENT'].' '.$vis_language['TXTEMAIL'];?></th>
        <th><?php echo $vis_language['TXTORGANIZATION'];?></th>
        <th><?php echo $vis_language['TXTSLAPLAN'];?></th>
        <th><?php echo $vis_language['TXTSTATUS'];?></th>
        <th><?php echo $vis_language['TXTAVGRESPONSE'];?></th>
        <th><?php echo $vis_language['TXTRESOLUTIONTIME'];?></th>
        <th><?php echo $vis_language['TXTRESPONSESLA'];?></th>
        <th><?php echo $vis_language['TXTRESOLUTIONTSLA'];?></th>
    </tr>
</thead>
<tbody>
    <?php  
        foreach($report_new as $ticket_id => $details)
        {                            
            $resolution_flag = ($details['pause_rtime']!='') ? $details['pause_rtime']:'';
            if(isset($details['slapause_diff'])){ $sla_diff = $details['slapause_diff'];}else{ $sla_diff=0;}
            if(($details['timestamp']==0 || $details['timestamp']<0) && $details['count']!=0){
                $timestamp = count_remain_time(round(($details['timestamp']-$sla_diff)));
             
            }elseif($details['count']==0){
                $timestamp = $vis_language['TXTNOTRESPONDED'];
            }else{
                $timestamp = count_remain_time(round(($details['timestamp']-$sla_diff) ));
            }
            if($details['pause_rtime']!=''){  $timestamp = "NA"; }else { $timestamp  = $timestamp;}
            $setUndue =0;
            $sla_name = ($details['sla_name']!= '') ? $details['sla_name'] : $vis_language['TXTCUSTDUETIME'];
            echo '<tr><td><a href="#/ticket/ticket_details/'.$details['ticket_hash'].'/'.$details['ticket_id'].'" target="_blank">'.$details['ticket_hash'].'</a></td><td>'.$details['subject'].'</td><td>'.format_datetime($details['ticket_entry']).'</td><td><a href="#/client/client_details/'.$details['first_name'].'/'.$details['client_id'].'" target="_blank">'.$details['email'].'</a></td><td>'.$details['group_name'].'</td><td>'.$sla_name.'</td>
            <td>'.$details['status_name'].'</td><td>';
           // echo $details['avg_response_time'];

            if($details['pause_rtime']!=''){  echo 'NA'; }
			elseif(isset($details['avg_response_time']) && $details['avg_response_time'] !=0)
			{
				echo $details['avg_response_time'];
			}
			elseif(isset($details['avg_response_time']) && $details['avg_response_time'] =='0 S' && $details['operator']!=1 && $details['as_client']!=1){ 
				echo '0 S';
			}else{ 
				echo $vis_language['TXTNOTRESPONDED'];
			}
            echo '</td><td>';
            if(isset($details['status_id']) && ($details['status_id']==4 || $details['status_id']==3)){
			echo (isset($details['avg_resolution_time']) && $details['avg_resolution_time'] !='')? $details['avg_resolution_time']:$vis_language['MSGNOTRESOLVED'];
            }else{
            echo  (isset($details['resolution_sla']) && $details['resolution_sla'] !='' ) ? $details['resolution_sla']: (($details['pause_rtime']!='')?'NA':$vis_language['TXTOVERDUE']);
            }
            echo '</td><td>';
            echo (isset($details['response_sla']) && $details['response_sla']!='')?$details['response_sla']:"NA";
            echo "</td><td>";                          
            if((isset($details['resolution_sla']) && $details['resolution_sla']==$vis_language['TXTOVERDUE']) || !isset($details['resolution_sla'])){
                if($details['pause_rtime']!=''){ echo "NA";}else{ echo $vis_language['TXTNOTMAINTAIN'];}
            }else{  
                echo (isset($details['resolution_sla']) && $details['resolution_sla'] !='' ) ? $details['resolution_sla']:(($details['pause_rtime']!='')?"NA":'');
            }
            echo "</td></tr>";
        } ?>
</tbody>
</table>
<?php
break;
case 'incident_category_sla_report':
?>
<table class="table table-hover table-striped">
<thead>
    <tr role="row">
        <th><?php echo $vis_language['TXTTICKETHASH'];?></th>
        <th><?php echo $vis_language['TXTSUBJECT'];?></th>
        <th><?php echo $vis_language['TXTCREATIONDATE'];?></th>                     
        <th><?php echo $vis_language['TXTCLIENT'].' '.$vis_language['TXTEMAIL'];?></th>
        <th><?php echo $vis_language['TXTDEPARTMENT'];?></th>
        <th><?php echo $vis_language['TXTTICKETCATEGORY'];?></th>
        <th><?php echo $vis_language['TXTSLAPLAN'];?></th>
        <th><?php echo $vis_language['TXTSTATUS'];?></th>
        <th><?php echo $vis_language['TXTAVGRESPONSE'];?></th>
        <th><?php echo $vis_language['TXTRESOLUTIONTIME'];?></th>
        <th><?php echo $vis_language['TXTRESPONSESLA'];?></th>
        <th><?php echo $vis_language['TXTRESOLUTIONTSLA'];?></th>
    </tr>
</thead>
<tbody>
    <?php  
        foreach($report_new as $ticket_id => $details)
        {                            
            $resolution_flag = ($details['pause_rtime']!='') ? $details['pause_rtime']:'';
            if(isset($details['slapause_diff'])){ $sla_diff = $details['slapause_diff'];}else{ $sla_diff=0;}
            if(isset($details['timestamp'])&&($details['timestamp']==0 || $details['timestamp']<0) && $details['count']!=0){
                $timestamp = count_remain_time(round(($details['timestamp']-$sla_diff)));
             
            }elseif($details['count']==0){
                $timestamp = $vis_language['TXTNOTRESPONDED'];
            }else{
                $timestamp = count_remain_time(round(($details['timestamp']-$sla_diff) ));
            }
            if($details['pause_rtime']!=''){  $timestamp = "NA"; }else { $timestamp  = $timestamp;}
            $setUndue =0;
            $sla_name = ($details['sla_name']!= '') ? $details['sla_name'] : $vis_language['TXTCUSTDUETIME'];
            echo '<tr><td><a href="#/ticket/ticket_details/'.$details['ticket_hash'].'/'.$details['ticket_id'].'" target="_blank">'.$details['ticket_hash'].'</a></td><td>'.$details['subject'].'</td><td>'.format_datetime($details['ticket_entry']).'</td><td><a href="#/client/client_details/'.$details['first_name'].'/'.$details['client_id'].'" target="_blank">'.$details['email'].'</a></td><td>'.$details['department_name'].'</td><td>'.$details['ticket_category'].'</td><td>'.$sla_name.'</td>
            <td>'.$details['status_name'].'</td><td>';
            // if(isset($details['avg_response_time']) && $details['avg_response_time'] !=0 ){
                /*    echo $details['avg_response_time'];    */
            // }else{ 
            //     echo $vis_language['TXTNOTRESPONDED'];
            // }
            $resolution_time = (isset($details['tot_post_and_reply_time']) && $details['tot_post_and_reply_time'] !=0 )?count_remain_time(round($details['tot_post_and_reply_time'])): $vis_language['TXTNOTMAINTAIN'];
			if($details['pause_rtime']!=''){
            	echo "NA";
            }elseif(isset($details['avg_response_time']) && $details['avg_response_time'] !=0)
			{
				echo $details['avg_response_time'];
			}
			elseif(isset($details['avg_response_time']) && $details['avg_response_time'] =='0 S' && $details['operator']!=1 && $details['as_client']!=1){ 
				echo '0 S';
			}else{ 
				echo $vis_language['TXTNOTRESPONDED'];
			}
            echo '</td><td>';
            if($details['pause_rtime']!=''){
            	echo "NA";
            }elseif(isset($details['status_id']) &&($details['status_id']==4 || $details['status_id']==3)){
			echo (isset($details['avg_resolution_time']) && $details['avg_resolution_time'] !='' )?$details['avg_resolution_time']:$vis_language['MSGNOTRESOLVED']; //$resolution_time;
			} else { 
			echo  (isset($details['resolution_sla']) && $details['resolution_sla'] !='' ) ? $details['resolution_sla']: $vis_language['TXTNOTMAINTAIN'];
			}	
            echo '</td><td>';
                   echo $details['response_sla'];
            echo "</td><td>";                      
            if($details['pause_rtime']!=''){
            	echo "NA";
            }elseif((isset($details['resolution_sla']) && $details['resolution_sla']==$vis_language['TXTOVERDUE']) || !isset($details['resolution_sla'])){
				echo $vis_language['TXTNOTMAINTAIN'];
			}else{	
				echo (isset($details['resolution_sla']) && $details['resolution_sla'] !='' ) ? $details['resolution_sla']: $vis_language['TXTNOTMAINTAIN'];
			}			
            echo "</td></tr>";
        } ?>
</tbody>
</table>
<?php
break;
case 'incident_type_sla_report':
?>
<table class="table table-hover table-striped">
<thead>
    <tr role="row">
        <th><?php echo $vis_language['TXTTICKETHASH'];?></th>
        <th><?php echo $vis_language['TXTSUBJECT'];?></th>
        <th><?php echo $vis_language['TXTCREATIONDATE'];?></th>                     
        <th><?php echo $vis_language['TXTCLIENT'].' '.$vis_language['TXTEMAIL'];?></th>
        <th><?php echo $vis_language['TXTDEPARTMENT'];?></th>
        <th><?php echo $vis_language['TXTTICKETTYPE'];?></th>
        <th><?php echo $vis_language['TXTSLAPLAN'];?></th>
        <th><?php echo $vis_language['TXTSTATUS'];?></th>
        <th><?php echo $vis_language['TXTAVGRESPONSE'];?></th>
        <th><?php echo $vis_language['TXTRESOLUTIONTIME'];?></th>
        <th><?php echo $vis_language['TXTRESPONSESLA'];?></th>
        <th><?php echo $vis_language['TXTRESOLUTIONTSLA'];?></th>
    </tr>
</thead>
<tbody>
    <?php  
        foreach($report_new as $ticket_id => $details)
        {                            
            $resolution_flag = ($details['pause_rtime']!='') ? $details['pause_rtime']:'';
            if(isset($details['slapause_diff'])){ $sla_diff = $details['slapause_diff'];}else{ $sla_diff=0;}
            if((isset($details['timestamp'])&&($details['timestamp']==0 || $details['timestamp']<0)) && $details['count']!=0){
                $timestamp = count_remain_time(round(($details['timestamp']-$sla_diff)));
             
            }elseif($details['count']==0){
                $timestamp = $vis_language['TXTNOTRESPONDED'];
            }else{
                $timestamp = count_remain_time(round(($details['timestamp']-$sla_diff) ));
            }
            if($details['pause_rtime']!=''){  $timestamp = "NA"; }else { $timestamp  = $timestamp;}
            $setUndue =0;
            $sla_name = ($details['sla_name']!= '') ? $details['sla_name'] : $vis_language['TXTCUSTDUETIME'];
            echo '<tr><td><a href="#/ticket/ticket_details/'.$details['ticket_hash'].'/'.$details['ticket_id'].'" target="_blank">'.$details['ticket_hash'].'</a></td><td>'.$details['subject'].'</td><td>'.format_datetime($details['ticket_entry']).'</td><td><a href="#/client/client_details/'.$details['first_name'].'/'.$details['client_id'].'" target="_blank">'.$details['email'].'</a></td><td>'.$details['department_name'].'</td><td>'.$details['type'].'</td><td>'.$sla_name.'</td>
            <td>'.$details['status_name'].'</td><td>';
                //echo $details['avg_response_time'];
           $resolution_time = (isset($details['tot_post_and_reply_time']) && $details['tot_post_and_reply_time'] !=0 )?count_remain_time(round($details['tot_post_and_reply_time'])): $vis_language['TXTNOTMAINTAIN'];
			if(isset($details['avg_response_time']) && ($details['avg_response_time'] !=0 || $details['avg_response_time']=='NA'))
			{
				echo $details['avg_response_time'];
			}
			elseif(isset($details['avg_response_time']) && $details['avg_response_time'] =='0 S' && $details['operator']!=1 && $details['as_client']!=1){ 
				echo '0 S';
			}else{ 
				echo $vis_language['TXTNOTRESPONDED'];
			}
            echo '</td><td>';
            if($details['pause_rtime']!=''){
				echo 'NA';
			}elseif(isset($details['status_id']) &&($details['status_id']==4 || $details['status_id']==3)){
			echo (isset($details['avg_resolution_time']) && $details['avg_resolution_time'] !='' )?$details['avg_resolution_time']:$vis_language['MSGNOTRESOLVED']; //$resolution_time;
			} else { 
			echo  (isset($details['resolution_sla']) && $details['resolution_sla'] !='' ) ? $details['resolution_sla']: $vis_language['TXTNOTMAINTAIN'];
			}	
            echo '</td><td>';
            echo $details['response_sla'];
            echo "</td><td>";                          
            if($details['pause_rtime']!=''){
				echo 'NA';
			}elseif((isset($details['resolution_sla']) && $details['resolution_sla']==$vis_language['TXTOVERDUE']) || !isset($details['resolution_sla'])){
				echo $vis_language['TXTNOTMAINTAIN'];
			}else{	
				echo (isset($details['resolution_sla']) && $details['resolution_sla'] !='' ) ? $details['resolution_sla']: $vis_language['TXTNOTMAINTAIN'];
			}			
            echo "</td></tr>";
        } ?>
</tbody>
</table>
<?php
break;
case 'incident_priority_sla_report':
?>
<table class="table table-hover table-striped">
<thead>
    <tr role="row">
        <th><?php if(isset($filter1)&&$filter1==0) {	echo $vis_language['TXTINCISERVICEHASH']; }			
        		  elseif(isset($filter1)&&$filter1==2) { echo $vis_language['TXTSERVICEREQHASH']; }
				  else { echo $vis_language['TXTTICKETHASH']; } ?></th>
        <th><?php echo $vis_language['TXTSUBJECT'];?></th>
        <th><?php echo $vis_language['TXTCREATIONDATE'];?></th>                     
        <th><?php echo $vis_language['TXTCLIENT'].' '.$vis_language['TXTEMAIL'];?></th>
        <th><?php echo $vis_language['TXTDEPARTMENT'];?></th>
        <th><?php echo $vis_language['TXTTICKETPRIORITY'];?></th>
        <th><?php echo $vis_language['TXTSLAPLAN'];?></th>
        <th><?php echo $vis_language['TXTSTATUS'];?></th>
        <th><?php echo $vis_language['TXTAVGRESPONSE'];?></th>
        <th><?php echo $vis_language['TXTRESOLUTIONTIME'];?></th>
        <th><?php echo $vis_language['TXTRESPONSESLA'];?></th>
        <th><?php echo $vis_language['TXTRESOLUTIONTSLA'];?></th>
    </tr>
</thead>
<tbody>
    <?php  
        foreach($report_new as $ticket_id => $details)
        {                            
            $resolution_flag = ($details['pause_rtime']!='') ? $details['pause_rtime']:'';
            if(isset($details['slapause_diff'])){ $sla_diff = $details['slapause_diff'];}else{ $sla_diff=0;}
            if((isset($details['timestamp'])&&($details['timestamp']==0 || $details['timestamp']<0)) && $details['count']!=0){
                $timestamp = count_remain_time(round(($details['timestamp']-$sla_diff)));
             
            }elseif($details['count']==0){
                $timestamp = $vis_language['TXTNOTRESPONDED'];
            }else{
                $timestamp = count_remain_time(round(($details['timestamp']-$sla_diff) ));
            }
            if($details['pause_rtime']!=''){  $timestamp = "NA"; }else { $timestamp  = $timestamp;}
            $setUndue =0;
            $sla_name = ($details['sla_name']!= '') ? $details['sla_name'] : $vis_language['TXTCUSTDUETIME'];
            echo '<tr><td><a href="#/ticket/ticket_details/'.$details['ticket_hash'].'/'.$details['ticket_id'].'" target="_blank">'.$details['ticket_hash'].'</a></td><td>'.$details['subject'].'</td><td>'.format_datetime($details['ticket_entry']).'</td><td><a href="#/client/client_details/'.$details['first_name'].'/'.$details['client_id'].'" target="_blank">'.$details['email'].'</a></td><td>'.$details['department_name'].'</td><td>'.$details['ticket_priority'].'</td><td>'.$sla_name.'</td>
            <td>'.$details['status_name'].'</td><td>';
            $resolution_time = (isset($details['tot_post_and_reply_time']) && $details['tot_post_and_reply_time'] !=0 )?count_remain_time(round($details['tot_post_and_reply_time'])): $vis_language['TXTNOTMAINTAIN'];
			if($details['pause_rtime']!=''){
            	echo "NA";
            }elseif(isset($details['avg_response_time']) && $details['avg_response_time'] !=0)
			{
				echo $details['avg_response_time'];
			}
			elseif(isset($details['avg_response_time']) && $details['avg_response_time'] =='0 S' && $details['operator']!=1 && $details['as_client']!=1){ 
				echo '0 S';
			}else{ 
				echo $vis_language['TXTNOTRESPONDED'];
			}
            echo '</td><td>';
            if($details['pause_rtime']!=''){
            	echo "NA";
            }elseif(isset($details['status_id']) &&($details['status_id']==4 || $details['status_id']==3)){
			echo (isset($details['avg_resolution_time']) && $details['avg_resolution_time'] !='' )?$details['avg_resolution_time']:$vis_language['MSGNOTRESOLVED'];
			} else { 
			echo  (isset($details['resolution_sla']) && $details['resolution_sla'] !='' ) ? $details['resolution_sla']: $vis_language['TXTNOTMAINTAIN'];
			}	
            echo '</td><td>';
            echo ($details['pause_rtime']!='')? 'NA':$details['response_sla'];
            echo "</td><td>";                          
            if($details['pause_rtime']!=''){
            	echo "NA";
            }elseif((isset($details['resolution_sla']) && $details['resolution_sla']==$vis_language['TXTOVERDUE']) || !isset($details['resolution_sla'])){
				echo $vis_language['TXTNOTMAINTAIN'];
			}else{	
				echo (isset($details['resolution_sla']) && $details['resolution_sla'] !='' ) ? $details['resolution_sla']: $vis_language['TXTNOTMAINTAIN'];
			}			
            echo "</td></tr>";
        } ?>
</tbody>
</table>
<?php
break;
case 'sla_plan_based_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
		        <th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
				<th><?php echo $vis_language['TXTDEPARTMENT'];?></th>
				<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
				<th><?php echo $vis_language['TXTSLAPLAN'];?></th>
				<th><?php echo 'Applied SLA date';?></th>
		        <th><?php echo $vis_language['TXTSTATUS'];?></th>
				<th><?php echo $vis_language['TXTCLIENT'].' '.strtolower($vis_language['TXTEMAIL']);?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++){ 
				$sla_name = ($report[$i]['sla_name']!= '') ? $report[$i]['sla_name'] : $vis_language['TXTCUSTDUETIME'];
				?>
				<tr role="row">
					<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $report[$i]['ticket_hash'];?>/<?php echo $report[$i]['ticket_id'];?>"><?php echo $report[$i]['ticket_hash'];?></a></td>
					<td><?php echo $report[$i]['subject'];?></td>
					<td><?php echo format_datetime($report[$i]['receive_date']);?></td>
					<td><?php echo $report[$i]['department_name'];?></td>
					<td><?php echo ($report[$i]['group_name']==NULL)? 'Default':$report[$i]['group_name'];?></td>
					<td><?php echo $sla_name;?></td>
					<td><?php echo ($report[$i]['entry_date']==NULL)? format_datetime($report[$i]['receive_date']):format_datetime($report[$i]['entry_date']);?></td>
					<td><?php echo $report[$i]['status_name'];?></td>
					<td><?php echo $report[$i]['email'];?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>
<?php
break;
case 'organization_sla_report':
?>
<table class="table table-hover table-striped">
<thead>
    <tr role="row">
        <th><?php echo $vis_language['TXTTICKETHASH'];?></th>
        <th><?php echo $vis_language['TXTSUBJECT'];?></th>
        <th><?php echo $vis_language['TXTCREATIONDATE'];?></th>                     
        <th><?php echo $vis_language['TXTCLIENT'].' '.$vis_language['TXTEMAIL'];?></th>
        <th><?php echo $vis_language['TXTORGANIZATION'];?></th>
        <th><?php echo $vis_language['TXTSLAPLAN'];?></th>
        <th><?php echo $vis_language['TXTSTATUS'];?></th>
        <th><?php echo $vis_language['TXTAVGRESPONSE'];?></th>
        <th><?php echo $vis_language['TXTRESOLUTIONTIME'];?></th>
        <th><?php echo $vis_language['TXTRESPONSESLA'];?></th>
        <th><?php echo $vis_language['TXTRESOLUTIONTSLA'];?></th>
    </tr>
</thead>
<tbody>
    <?php  
        foreach($report_new as $ticket_id => $details)
        {                            
            $resolution_flag = ($details['pause_rtime']!='') ? $details['pause_rtime']:'';
            if(isset($details['slapause_diff'])){ $sla_diff = $details['slapause_diff'];}else{ $sla_diff=0;}
            if((isset($details['timestamp'])&&($details['timestamp']==0 || $details['timestamp']<0)) && $details['count']!=0){
                $timestamp = count_remain_time(round(($details['timestamp']-$sla_diff)));             
            }elseif($details['count']==0){
                $timestamp = $vis_language['TXTNOTRESPONDED'];
            }else{
                $timestamp = count_remain_time(round(($details['timestamp']-$sla_diff) ));
            }
            if($details['pause_rtime']!=''){  $timestamp = "NA"; }else { $timestamp  = $timestamp;}
            $setUndue =0;
            $sla_name = ($details['sla_name']!= '') ? $details['sla_name'] : $vis_language['TXTCUSTDUETIME'];
            echo '<tr><td><a href="#/ticket/ticket_details/'.$details['ticket_hash'].'/'.$details['ticket_id'].'" target="_blank">'.$details['ticket_hash'].'</a></td><td>'.$details['subject'].'</td><td>'.format_datetime($details['ticket_entry']).'</td><td><a href="#/client/client_details/'.$details['first_name'].'/'.$details['client_id'].'" target="_blank">'.$details['email'].'</a></td><td>'.$details['group_name'].'</td><td>'.$sla_name.'</td>
            <td>'.$details['status_name'].'</td><td>';
            $resolution_time = (isset($details['tot_post_and_reply_time']) && $details['tot_post_and_reply_time'] !=0 )?count_remain_time(round($details['tot_post_and_reply_time'])): $vis_language['TXTNOTMAINTAIN'];
			if($details['pause_rtime']!=''){ echo "NA"; }
			elseif(isset($details['avg_response_time']) && $details['avg_response_time'] !=0)
			{
				echo $details['avg_response_time'];
			}
			elseif(isset($details['avg_response_time']) && $details['avg_response_time'] =='0 S' && $details['operator']!=1 && $details['as_client']!=1){ 
				echo '0 S';
			}else{ 
				echo $vis_language['TXTNOTRESPONDED'];
			}
            echo '</td><td>';
 			if($details['pause_rtime']!=''){ echo "NA"; }
 			elseif(isset($details['status_id']) &&($details['status_id']==4 || $details['status_id']==3)){
			echo (isset($details['avg_resolution_time']) && $details['avg_resolution_time'] !='' )?$details['avg_resolution_time']:$vis_language['MSGNOTRESOLVED']; //$resolution_time;
			} else { 
			echo  (isset($details['resolution_sla']) && $details['resolution_sla'] !='' ) ? $details['resolution_sla']: $vis_language['TXTNOTMAINTAIN'];
			}	
            echo '</td><td>';
            	echo $details['response_sla'];
            echo "</td><td>";      
            if($details['pause_rtime']!=''){ echo "NA"; }
            elseif((isset($details['resolution_sla']) && $details['resolution_sla']==$vis_language['TXTOVERDUE']) || !isset($details['resolution_sla'])){
				echo $vis_language['TXTNOTMAINTAIN'];
			}else{	
				echo (isset($details['resolution_sla']) && $details['resolution_sla'] !='' ) ? $details['resolution_sla']: $vis_language['TXTNOTMAINTAIN'];
			}			
            echo "</td></tr>";
        } ?>
</tbody>
</table>
<?php
break;
case 'ticket_closed_by_user_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
		<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
		<th><?php echo $vis_language['TXTSUBJECT'];?></th>
		<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
		<th><?php echo $vis_language['TXTSTAFFNAME'];?></th>
		<th><?php echo $vis_language['TXTEMAIL'];?></th>
		<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
		</tr>
	</thead>
	<tbody>
	<?php  
	foreach($report as $ticket_id => $details){ ?>
	<tr role="row">
		<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $details['ticket_hash'];?>/<?php echo $details['ticket_id'];?>"><?php echo $details['ticket_hash']?></a></td>
		<td><?php echo $details['subject'];?></td>
		<td><?php echo $details['first_name'].'  '.$details['last_name'];?></td>
		<td><?php echo $details['fname'].'  '.$details['lname'];?></td>
		<td><?php echo $details['email'];?></td>
		<td><?php echo format_datetime($details['receive_date']);?></td>
	</tr><?php
	}
	?>
	</tbody>
</table>
<?php 
break;
case 'staff_leaderboard_first_avgresponse_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
		<th><?php echo $vis_language['TXTSTAFFNAME'];?></th>
		<th><?php echo $vis_language['TXTSOLVEDTICKETS'];?></th>
		<th><?php echo $vis_language['AVGFIRSTREPLY'];?></th>
		</tr>
	</thead>
	<tbody>
	<?php
	foreach($report as $reports){ ?>
		<tr role="row">
			<td><?php echo $reports['staff_name'];?></td>
			<td><?php echo $reports['total_ticket_count'];?></td>
			<td><?php echo $reports['avgFirstresponse'];?></td>
		</tr><?php
	} ?>
	</tbody>
</table>
<?php 
break;
case 'ticket_viewed_by_staff_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
		<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
		<th><?php echo $vis_language['TXTSUBJECT'];?></th>
		<th><?php echo $vis_language['TXTVIEWBYSTAFFDATE'];?></th>
		</tr>
	</thead>
	<tbody>
	<?php
	foreach($report as $ticket_id => $details){ ?>
		<tr role="row">
			<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $details['ticket_hash'];?>/<?php echo $details['ticket_id'];?>"><?php echo $details['ticket_hash']?></a></td>
			<td><?php echo $details['subject'];?></td>
			<td><?php echo format_datetime($details['entry_date']);?></td>
		</tr><?php
	}
	?>
	</tbody>
</table>
<?php 
break;
case 'sla_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">		
		<th><?php if($filter1==0) {	echo $vis_language['TXTINCISERVICEHASH']; }			
        		  elseif($filter1==2) { echo $vis_language['TXTSERVICEREQHASH']; }
				  else { echo $vis_language['TXTTICKETHASH']; } ?></th>
		<th><?php echo $vis_language['TXTSUBJECT'];?></th>
		<th><?php echo $vis_language['TXTCLIENT'].' '.strtolower($vis_language['TXTEMAIL']);?></th>
		<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
		<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
		<th><?php echo $vis_language['TXTSTATUS'];?></th>
		<th><?php echo $vis_language['TXTSLAPLAN'];?></th>
		<th><?php echo $vis_language['TXTAVGRESPONSE'];?></th>
		<th><?php echo $vis_language['TXTRESOLUTIONTIME'];?></th>
		<th><?php echo $vis_language['TXTRESPONSESLA'];?></th>
		<th><?php echo $vis_language['TXTRESOLUTIONTSLA'];?></th>
		</tr>
	</thead>
	<tbody>
	<?php
		foreach($report_new as $ticket_id => $details)
		{ 
			$checkresponded="";
			$resolution_flag = ($details['pause_rtime']!='') ?  $vis_language['TXTSLAPAUSED']:'';
			if(isset($details['slapause_diff'])){ $sla_diff = $details['slapause_diff'];}else{ $sla_diff=0;}							
			if((isset($details['timestamp'])&&($details['timestamp']==0 || $details['timestamp']<0)) && $details['count']!=0){
				if(($details['resolve_time'] < 0 || $details['remain_resolve'] < 0) && $details['status_id']!=3 && $details['status_id']!=4)
				{
					$timestamp = $vis_language['TXTUNDUE'];
				}
				else
				{
					$timestamp = '0 S';
				}
			}
			elseif($details['count']==0)
			{
				$timestamp = $vis_language['TXTNOTRESPONDED'];
			}
			else
			{
				
				$timestamp = count_remain_time(round(($details['timestamp']-$sla_diff)/$details['count']));
			}
			if($details['pause_rtime']!=''){  $timestamp = $vis_language['TXTSLAPAUSED']; }else { $timestamp  = $timestamp;}
			$setUndue = 0;
			$sla_name = ($details['sla_name']!= '')?$details['sla_name']:$vis_language['TXTCUSTDUETIME'];
			echo '<tr><td ><a href="#/ticket/ticket_details/'.$details['ticket_hash'].'/'.$details['ticket_id'].'" target="_blank">'.$details['ticket_hash'].'</a> </td><td >'.$details['subject'].'</td><td ><a href="#/client/client_details/'.$details['first_name'].'/'.$details['client_id'].'" target="_blank">'.$details['email'].'</a></td><td >'.$details['group_name'].'</td><td >'.format_datetime($details['ticket_entry']).'</td>
			<td>'.$details['status_name'].'</td><td>'.$sla_name.'</td><td >';
			
			$resolution_time = (isset($details['tot_post_and_reply_time']) && $details['tot_post_and_reply_time'] !=0 )?count_remain_time(round($details['tot_post_and_reply_time'])): $vis_language['TXTNOTMAINTAIN'];
			if($details['pause_rtime']!=''){  echo 'NA'; }
			elseif(isset($details['avg_response_time']) && $details['avg_response_time'] !=0)
			{
				echo $details['avg_response_time'];
			}
			elseif(isset($details['avg_response_time']) && $details['avg_response_time'] =='0 S' && $details['operator']!=1 && $details['as_client']!=1){ 
				echo '0 S';
			}else{ 
				echo $vis_language['TXTNOTRESPONDED'];
			}
			echo '</td><td>';
			if($details['pause_rtime']!=''){  echo 'NA'; }
			elseif(isset($details['status_id']) &&($details['status_id']==4 || $details['status_id']==3)){
			echo (isset($details['avg_resolution_time']) && $details['avg_resolution_time'] !='' )?$details['avg_resolution_time']:$vis_language['MSGNOTRESOLVED']; //$resolution_time;
			} else { 
			echo  (isset($details['resolution_sla']) && $details['resolution_sla'] !='' ) ? $details['resolution_sla']: $vis_language['TXTNOTMAINTAIN'];
			}	
			echo '</td><td>';			
				echo $details['response_sla'];
			echo "</td><td>";
			if($details['pause_rtime']!=''){  echo 'NA'; }
			elseif((isset($details['resolution_sla']) && $details['resolution_sla']==$vis_language['TXTOVERDUE']) || !isset($details['resolution_sla'])){
				echo $vis_language['TXTNOTMAINTAIN'];
			}else{	
				echo (isset($details['resolution_sla']) && $details['resolution_sla'] !='' ) ? $details['resolution_sla']: $vis_language['TXTNOTMAINTAIN'];
			}									
			echo "</td></tr>";
						} ?>
	</tbody>
</table>
<?php 
break;
case 'ticket_escalation_staff_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
		<th> <?php echo $vis_language['TXTTICKETHASH'];?></th>
		<th> <?php echo $vis_language['TXTSUBJECT'];?></th>
		<th> <?php echo $vis_language['TXTCREATIONDATE'];?></th>
		<th> <?php echo $vis_language['TXTASSIGNTO'];?></th>
		<th> <?php echo $vis_language['TXTASSIGNEDON'];?></th>
		</tr>
	</thead>
	<tbody>
	  <?php
		foreach($report_new as $ticket_id => $details) {
			$details['first_name'] = isset($details['first_name'])?$details['first_name']:'';
			$details['last_name'] = isset($details['last_name'])?$details['last_name']:'';
			$details['entry_date'] = isset($details['entry_date'])?$details['entry_date']:'';
			$details['new_info'] =$details['first_name']. ' '.$details['last_name'];
			$info=$details['new_info'];
			echo '<tr><td><a href="#/ticket/ticket_details/'.$details['ticket_hash'].'/'.$details['ticket_id'].'">'.$details['ticket_hash'].'</a></td><td>'.$details['subject'].'</td><td>'.format_datetime($details['receive_date']).'</td><td >'.$info.'</td><td>'.format_datetime($details['entry_date']).'</td></tr>';
		} ?>
	</tbody>
</table>
<?php 
break;
case 'ticket_escalation_department_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
		<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
		<th><?php echo $vis_language['TXTSUBJECT'];?></th>
		<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
		<th><?php echo $vis_language['TXTASSIGNTO'];?></th>
		<th><?php echo $vis_language['TXTASSIGNEDON'];?></th>
		</tr>
	</thead>
	<tbody>
	  <?php
		foreach($report as $ticket_id => $details) {
			echo '<tr><td class="txt_nowrap"><a href="#/ticket/ticket_details/'.$details['ticket_hash'].'/'.$details['ticket_id'].'">'.$details['ticket_hash'].'</a></td><td class="txt_nowrap">'.$details['subject'].'</td><td class="txt_nowrap">'.format_datetime($details['receive_date']).'</td><td class="txt_nowrap">'.$details['new_info'].'</td><td class="txt_nowrap">'.format_datetime($details['entry_date']).'</td></tr>';
		} ?>
	</tbody>
</table>
<?php 
break;
case 'unauthchange_report':
?>
    <table class="table table-hover table-striped">
    <thead>
        <tr role="row">
            <th><?php echo $vis_language['TXTNAME'];?></th>
                            <th><?php echo 'CI '.$vis_language['TXTTYPE'];?></th>
                            <th><?php echo $vis_language['TXTOPERATION'];?></th>
                            <th><?php echo $vis_language['TXTOPERATOR'];?></th>
                            <th><?php echo $vis_language['TXTDOMAIN'];?></th>
        </tr>
    </thead>
    <tbody>
        <?php
                        for($i=0;$i<count($report);$i++){ ?>
                            <tr role="row">
                                <td><a target="_blank" href="#/cmdb/cmdb_details/<?php echo $report[$i]['name'];?>/<?php echo $report[$i]['assets_id'];?>"><?php echo $report[$i]['name'];?></a></td>
                                <td><?php echo $report[$i]['ci_type'];?></td>
                                <td><?php echo $report[$i]['operation'];?></td>
                                <td><?php echo $report[$i]['operator'];?></td>
                                <td><?php echo $report[$i]['domain'];?></td>
                            </tr><?php
                        }
                        ?>
    </tbody>
    </table>
<?php
break;
case 'client_with_maximum_reply_ticket_report':
?>
    <table class="table table-hover table-striped">
	    <thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTCLIENT'];?></th>
				<th><?php echo $vis_language['TXTCLIENTTYPE'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTCONTACT'];?></th>
				<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
				<th><?php echo $vis_language['TXTTOTALREPLIEDTICKET'];?></th>
			</tr>
	    </thead>
	    <tbody>
	        <?php
				foreach($report as $ticket_id => $details) 
					{
						echo '<tr>
						<td> '.$details['first_name'].' '.$details['last_name'].' </td>';
						if($details['client_type']==0){
							echo '<td> '.$vis_language['TXTEMAILCLIENT'] .' </td>';
							}else{
							echo '<td> '.$vis_language['TXTCALLCLIENT'] .' </td>';
						}
						echo '<td><a href="#/client/client_details/'.$details['first_name'].'/'.$details['client_id'].'" target="_blank">'.$details['email'].'</a></td>
						<td>'.$details['contact_number'].'</td>
						<td>'.$details['group_name'].'</td>
						<td>'.$details['total_ticket_reply_count'].'</td>';
						'</tr>';
					} 
			?>
	    </tbody>
    </table>
<?php
break;
case 'staff_leaderboard_avgresponse_maintain_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
			<th><?php echo $vis_language['TXTSTAFFNAME'];?></th>
			<th><?php echo  $vis_language['TXTTOTALTICKETSREPLIED'];?></th>
			<th><?php echo  $vis_language['TXTTOTAL'].' ' .strtolower($vis_language['TXTPOST']);?></th>
			<th><?php echo $vis_language['TXTAVGRESPONSE'];?></th>
			<th><?php echo  $vis_language['TXTAVGSLATIME'];?></th>
			</tr>
		</thead>
		<tbody>
		<?php  
		foreach($report1 as $reports){
			if(isset($details['slapause_diff'])){ $sla_diff = $details['slapause_diff'];}else{ $sla_diff = 0;} ?>
			<tr role="row">
				<td><?php echo $reports['staff_name'];?></td>
				<td><?php echo $reports['totady_relycount'];?></td>
				<td><?php echo  $reports['post_count'];?></td>
				<td><?php echo $reports['avgresponsetime'];?></td>
				<td><?php echo $reports['avgresponsesla'];?></td>
			</tr><?php
		}
		?>
		</tbody>
	</table>
<?php
break;
case 'time_track_based_on_bill_rate_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
			<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
			<th><?php echo $vis_language['TXTSUBJECT'];?></th>
			<th><?php echo $vis_language['TXTDESCRIPTION'];?></th>
			<th><?php echo $vis_language['TXTSTAFF'];?></th>
			<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
			<th><?php echo $vis_language['TXTEMAIL'];?></th>
			<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
			<th><?php echo $vis_language['TXTBILLTIME'].' ('.$vis_language['TXTMIN'].')';?></th>
			<th><?php echo $vis_language['TXTWORKTIME'].' ('.$vis_language['TXTMIN'].')';?></th>
			<th><?php echo $vis_language['TXTAMOUNT'].' ('.$currency.')';?></th>
			</tr>
		</thead>
		<tbody>
			<?php  
			foreach($report as $ticket_id => $details){ ?>
			<tr role="row">
				<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $details['ticket_hash'];?>/<?php echo $details['ticket_id'];?>" target="_blank"><?php echo $details['ticket_hash']?></a></td>
				<td><?php echo $details['subject'];?></td>
				<td><?php echo $details['description'];?></td>
				<td><?php echo $details['staff_name'];?></td>
				<td><?php echo $details['client_name'];?></td>
				<td><a href="#/client/client_details/<?php echo $details['client_name'].'/'.$details['client_id']; ?>" target="_blank" ><?php echo $details['email'];?></a></td>
				<td><?php echo format_datetime($details['created_date']);?></td>
				<td><?php echo $details['bill_time'];?></td>
				<td><?php echo $details['work_time'];?></td>
				<td><?php echo $details['amount'];?></td>
			</tr><?php
			}
			?>
		</tbody>
	</table>
<?php 
break;
case 'livechat_tickets_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTCREATEDATE'];?></th>
				<th><?php echo $vis_language['TXTDEPARTMENT'];?></th>
				<th><?php echo $vis_language['CHNLNAME'];?></th>
				<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTORGANIZATION'];?></th> 
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++) { ?>
				<tr role="row">
					<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $report[$i]['ticket_hash']?>/<?php echo $report[$i]['ticket_id']?>"><?php echo $report[$i]['ticket_hash']?></a></td>
					<td><?php echo $report[$i]['subject'];?></td>
					<td><?php echo format_datetime($report[$i]['receive_date']);?></td>
					<td><?php echo $report[$i]['department_name'];?></td>
					<td><?php echo $report[$i]['channel_name'];?></td>
					<td><?php echo $report[$i]['first_name'].' '.$report[$i]['last_name'];?></td>
					<td><?php echo $report[$i]['email'];?></td>
					<td><?php echo $report[$i]['group_name'];?></td>
 				</tr><?php
			}
			?>
		</tbody>
	</table>
<?php 
break;
case 'livechat_rating':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTCREATEDATE'];?></th>
				<th><?php echo $vis_language['TXTDEPARTMENT'];?></th>
				<th><?php echo $vis_language['CHNLNAME'];?></th>
				<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTORGANIZATION'];?></th> 
				<th><?php echo $vis_language['TXTCHATRATING'];?></th> 
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++) { ?>
				<tr role="row">
					<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $report[$i]['ticket_hash']?>/<?php echo $report[$i]['ticket_id']?>"><?php echo $report[$i]['ticket_hash']?></a></td>
					<td><?php echo $report[$i]['subject'];?></td>
					<td><?php echo format_datetime($report[$i]['receive_date']);?></td>
					<td><?php echo $report[$i]['department_name'];?></td>
					<td><?php echo $report[$i]['channel_name'];?></td>
					<td><?php echo $report[$i]['first_name'].' '.$report[$i]['last_name'];?></td>
					<td><?php echo $report[$i]['email'];?></td>
					<td><?php echo $report[$i]['group_name'];?></td>
					<td><?php echo $report[$i]['rating'];?></td>
 				</tr><?php
			}
			?>
		</tbody>
	</table>
<?php 
break;
case 'livechat_departmentwise_chat_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTDEPARTMENT'];?></th>
				<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTSTATUS'];?></th>
				<th><?php echo $vis_language['TXTMISSCHATREASON'];?></th>
				<th><?php echo $vis_language['TXTINITIATEDATE'];?></th>
				<th><?php echo $vis_language['TXTSTARTDATE'];?></th>
				<th><?php echo $vis_language['TXTENDDATE'];?></th>
				<th><?php echo $vis_language['TXTTOTDURATION'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++) { 
				//if(strpos($report[$i]['description'], "Missed chat") !== false)
				if($report[$i]['operation_id']==11 || $report[$i]['operation_id']==14 || $report[$i]['operation_id']==15 || $report[$i]['operation_id']==16 || ($report[$i]['operation_id']==13 && $report[$i]['operator']==4)){
					$status = $vis_language['TXTMISSEDCHAT'];
					$status_reson = $report[$i]['description'];
				} else{
					$status = $vis_language['TXTACTIVECHAT'];
					$status_reson = '-';
				} ?>
				<tr role="row">
					<td><?php if($report[$i]['ticket_id']!=0){ ?><a target="_blank" href="#/ticket/ticket_details/<?php echo $report[$i]['ticket_hash']?>/<?php echo $report[$i]['ticket_id']?>"><?php echo $report[$i]['ticket_hash']?></a><?php }else{ echo'--'; }?></td>
					<td><?php echo $report[$i]['department_name'];?></td>
					<td><?php echo $report[$i]['first_name'].' '.$report[$i]['last_name'];?></td>
					<td><?php echo $report[$i]['email'];?></td>
					<td><?php echo $status;?></td>
					<td><?php echo $status_reson;?></td>
					<td><?php echo format_datetime($report[$i]['initiate_time']);?></td>
					<td><?php echo ($report[$i]['start_time']!=0)?format_datetime($report[$i]['start_time']):'-';?></td>
					<td><?php echo ($report[$i]['start_time']!=0)?format_datetime($report[$i]['end_time']):'-';?></td>
					<td><?php echo ($report[$i]['start_time']!=0)?count_remain_time($report[$i]['end_time'] - $report[$i]['start_time']):'-'; ?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>	
<?php 
break;
case '

':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTDEPARTMENT'];?></th>
				<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTSTATUS'];?></th>
				<th><?php echo $vis_language['TXTMISSCHATREASON'];?></th>
				<th><?php echo $vis_language['TXTINITIATEDATE'];?></th>
				<th><?php echo $vis_language['TXTSTARTDATE'];?></th>
				<th><?php echo $vis_language['TXTENDDATE'];?></th>
				<th><?php echo $vis_language['TXTTOTDURATION'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++) {
					$status = $vis_language['TXTMISSEDCHAT'];
				  ?>
				<tr role="row">
					<td><?php if($report[$i]['ticket_id']!=0){ ?><a target="_blank" href="#/ticket/ticket_details/<?php echo $report[$i]['ticket_hash']?>/<?php echo $report[$i]['ticket_id']?>"><?php echo $report[$i]['ticket_hash']?></a><?php }else{ echo'--'; }?></td>
					<td><?php echo $report[$i]['department_name'];?></td>
					<td><?php echo $report[$i]['first_name'].' '.$report[$i]['last_name'];?></td>
					<td><?php echo $report[$i]['email'];?></td>
					<td><?php echo $status;?></td>
					<td><?php echo $report[$i]['description'];?></td>
					<td><?php echo format_datetime($report[$i]['initiate_time']);?></td>
					<td><?php echo ($report[$i]['start_time']!=0)?format_datetime($report[$i]['start_time']):'-';?></td>
					<td><?php echo ($report[$i]['start_time']!=0)?format_datetime($report[$i]['end_time']):'-';?></td>
					<td><?php echo ($report[$i]['start_time'] !=0)?count_remain_time($report[$i]['end_time'] - $report[$i]['start_time']):'-'; ?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>
<?php 
break;
case 'missed_chat_staffwise_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTDEPARTMENT'];?></th>
				<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTSTATUS'];?></th>
				<th><?php echo $vis_language['TXTMISSCHATREASON'];?></th>
				<th><?php echo $vis_language['TXTINITIATEDATE'];?></th>
				<th><?php echo $vis_language['TXTSTARTDATE'];?></th>
				<th><?php echo $vis_language['TXTENDDATE'];?></th>
				<th><?php echo $vis_language['TXTTOTDURATION'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++) {
					$status = $vis_language['TXTMISSEDCHAT'];
				  ?>
				<tr role="row">
					<td><?php if($report[$i]['ticket_id']!=0){ ?><a target="_blank" href="#/ticket/ticket_details/<?php echo $report[$i]['ticket_hash']?>/<?php echo $report[$i]['ticket_id']?>"><?php echo $report[$i]['ticket_hash']?></a><?php }else{ echo'--'; }?></td>
					<td><?php echo $report[$i]['department_name'];?></td>
					<td><?php echo $report[$i]['first_name'].' '.$report[$i]['last_name'];?></td>
					<td><?php echo $report[$i]['email'];?></td>
					<td><?php echo $status;?></td>
					<td><?php echo $report[$i]['description'];?></td>
					<td><?php echo format_datetime($report[$i]['initiate_time']);?></td>
					<td><?php echo ($report[$i]['start_time']!=0)?format_datetime($report[$i]['start_time']):'-';?></td>
					<td><?php echo ($report[$i]['start_time']!=0)?format_datetime($report[$i]['end_time']):'-';?></td>
					<td><?php echo ($report[$i]['start_time'] !=0)?count_remain_time($report[$i]['end_time'] - $report[$i]['start_time']):'-'; ?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>	
<?php 
break;
case 'missed_chat_departmentwise_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTDEPARTMENT'];?></th>
				<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTSTATUS'];?></th>
				<th><?php echo $vis_language['TXTMISSCHATREASON'];?></th>
				<th><?php echo $vis_language['TXTINITIATEDATE'];?></th>
				<th><?php echo $vis_language['TXTSTARTDATE'];?></th>
				<th><?php echo $vis_language['TXTENDDATE'];?></th>
				<th><?php echo $vis_language['TXTTOTDURATION'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++) {
					$status = $vis_language['TXTMISSEDCHAT'];
				  ?>
				<tr role="row">
					<td><?php if($report[$i]['ticket_id']!=0){ ?><a target="_blank" href="#/ticket/ticket_details/<?php echo $report[$i]['ticket_hash']?>/<?php echo $report[$i]['ticket_id']?>"><?php echo $report[$i]['ticket_hash']?></a><?php }else{ echo'--'; }?></td>
					<td><?php echo $report[$i]['department_name'];?></td>
					<td><?php echo $report[$i]['first_name'].' '.$report[$i]['last_name'];?></td>
					<td><?php echo $report[$i]['email'];?></td>
					<td><?php echo $status;?></td>
					<td><?php echo $report[$i]['description'];?></td>
					<td><?php echo format_datetime($report[$i]['initiate_time']);?></td>
					<td><?php echo ($report[$i]['start_time']!=0)?format_datetime($report[$i]['start_time']):'-';?></td>
					<td><?php echo ($report[$i]['start_time']!=0)?format_datetime($report[$i]['end_time']):'-';?></td>
					<td><?php echo ($report[$i]['start_time'] !=0)?count_remain_time($report[$i]['end_time'] - $report[$i]['start_time']):'-'; ?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>	
<?php 
break;
case 'staff_forward_chat_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTDEPARTMENT'];?></th>
				<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th> 
				<th><?php echo $vis_language['TXTFORWARDON'];?></th>
				<th><?php echo $vis_language['TXTFORWARDBY'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++) { ?>
				<tr role="row">
					<td><?php if($report[$i]['ticket_id']!=0){ ?><a target="_blank" href="#/ticket/ticket_details/<?php echo $report[$i]['ticket_hash']?>/<?php echo $report[$i]['ticket_id']?>"><?php echo $report[$i]['ticket_hash']?></a><?php }else{ echo'--'; }?></td>
					<td><?php echo $report[$i]['department_name'];?></td>
					<td><?php echo $report[$i]['first_name'].' '.$report[$i]['last_name'];?></td>
					<td><?php echo $report[$i]['email'];?></td> 
					<td><?php echo format_datetime($report[$i]['forward_time']);?></td>
					<td><?php echo $report[$i]['forward_by'];?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>	
<?php 
break;
case 'active_chat_staffwise_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTDEPARTMENT'];?></th>
				<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTSTATUS'];?></th>
				<th><?php echo $vis_language['TXTSTARTDATE'];?></th>
				<th><?php echo $vis_language['TXTENDDATE'];?></th>
				<th><?php echo $vis_language['TXTTOTDURATION'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++) {
					$status = $vis_language['TXTACTIVECHAT'];
				  ?>
				<tr role="row">
					<td><?php if($report[$i]['ticket_id']!=0){ ?><a target="_blank" href="#/ticket/ticket_details/<?php echo $report[$i]['ticket_hash']?>/<?php echo $report[$i]['ticket_id']?>"><?php echo $report[$i]['ticket_hash']?></a><?php }else{ echo'--'; }?></td>
					<td><?php echo $report[$i]['department_name'];?></td>
					<td><?php echo $report[$i]['first_name'].' '.$report[$i]['last_name'];?></td>
					<td><?php echo $report[$i]['email'];?></td>
					<td><?php echo $status;?></td>
					<td><?php echo format_datetime($report[$i]['start_time']);?></td>
					<td><?php echo format_datetime($report[$i]['end_time']);?></td>
					<td><?php echo count_remain_time($report[$i]['end_time'] - $report[$i]['start_time']); ?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>	
<?php 
break;
case 'staff_productivity_time_spent':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTDEPARTMENT'];?></th>
				<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th> 
				<th><?php echo $vis_language['TXTJOINDATE'];?></th>
				<th><?php echo $vis_language['TXTLEFTDATE'];?></th>
				<th><?php echo $vis_language['TXTPRODUCTIVETIME'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++) { ?>
				<tr role="row">
					<td><?php if($report[$i]['ticket_id']!=0){ ?><a target="_blank" href="#/ticket/ticket_details/<?php echo $report[$i]['ticket_hash']?>/<?php echo $report[$i]['ticket_id']?>"><?php echo $report[$i]['ticket_hash']?></a><?php }else{ echo'--'; }?></td>
					<td><?php echo $report[$i]['department_name'];?></td>
					<td><?php echo $report[$i]['first_name'].' '.$report[$i]['last_name'];?></td>
					<td><?php echo $report[$i]['email'];?></td> 
					<td><?php echo format_datetime($report[$i]['start_time']);?></td>
					<td><?php echo format_datetime($report[$i]['end_time']);?></td> 
					<td><?php echo count_remain_time($report[$i]['end_time'] - $report[$i]['start_time']); ?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>	
<?php
break;
case 'active_chat_departmentwise_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTDEPARTMENT'];?></th>
				<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTSTATUS'];?></th>
				<th><?php echo $vis_language['TXTSTARTDATE'];?></th>
				<th><?php echo $vis_language['TXTENDDATE'];?></th>
				<th><?php echo $vis_language['TXTTOTDURATION'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++) {
					$status = $vis_language['TXTACTIVECHAT'];
				  ?>
				<tr role="row">
					<td><?php if($report[$i]['ticket_id']!=0){ ?><a target="_blank" href="#/ticket/ticket_details/<?php echo $report[$i]['ticket_hash']?>/<?php echo $report[$i]['ticket_id']?>"><?php echo $report[$i]['ticket_hash']?></a><?php }else{ echo'--'; }?></td>
					<td><?php echo $report[$i]['department_name'];?></td>
					<td><?php echo $report[$i]['first_name'].' '.$report[$i]['last_name'];?></td>
					<td><?php echo $report[$i]['email'];?></td>
					<td><?php echo $status;?></td>
					<td><?php echo format_datetime($report[$i]['start_time']);?></td>
					<td><?php echo format_datetime($report[$i]['end_time']);?></td>
					<td><?php echo count_remain_time($report[$i]['end_time'] - $report[$i]['start_time']); ?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>	
<?php
break;
case 'task_summary_report':
?>
	<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTSTAFF'];?></th>
			<th><?php echo $vis_language['TXTTOTAL'];?></th>
			<th><?php echo $vis_language['TXTINPROGRESS'];?></th>
			<th><?php echo $vis_language['TXTOVERDUE'];?></th>
			<th><?php echo $vis_language['TXTCANCELED'];?></th>
			<th><?php echo $vis_language['TXTNOTSTARTED'];?></th>
			<th><?php echo $vis_language['TXTCOMPLETED'];?></th>
		</tr>
	</thead>
	<tbody>
		<?php 
			foreach($report as $details)
			{ ?>
				<tr role="row">
					<td ><?=$details['first_name'].' '.$details['last_name']; ?></td> 
					<td ><?=$details['total']; ?></td> 
					<td ><?=$details['inprogress']; ?></td> 
					<td ><?=$details['overdue']; ?></td> 
					<td ><?=$details['cancelled']; ?></td> 
					<td ><?=$details['notstarted']; ?></td>
					<td ><?=$details['completed']; ?></td> 
				</tr>
			<?php } ?>
	</tbody>
	</table>
	<?php 
break;

case 'livechat_visitor_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
			    <th class="text-nowrap"><?php echo $vis_language['TXTDOMAIN']; ?></th>
			    <th class="text-nowrap">visited pages</th>
			    <th class="text-nowrap"><?php echo $vis_language['TXTNAME']; ?></th>
			    <th class="text-nowrap"><?php echo isset($vis_language['TXTREFERRAL'])?$vis_language['TXTREFERRAL']:''; ?></th>		
			    <th class="text-nowrap"><?php echo isset($vis_language['TXTIPADDRESS'])?$vis_language['TXTIPADDRESS']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTCOUNTRY'])?$vis_language['TXTCOUNTRY']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTCITY'])?$vis_language['TXTCITY']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTTIMEZONE'])?$vis_language['TXTTIMEZONE']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTBROWSER'])?$vis_language['TXTBROWSER']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTVISITS'])?$vis_language['TXTVISITS']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTDEVICE'])?$vis_language['TXTDEVICE']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTOS'])?$vis_language['TXTOS']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTUSERAGENT'])?$vis_language['TXTUSERAGENT']:''; ?></th>
				<th class="text-nowrap"><?php echo "Last visit time"; ?></th>
				<th class="text-nowrap"><?php echo isset($vis_language['TXTCONTINENT'])?$vis_language['TXTCONTINENT']:''; ?></th>		
			</tr>
		</thead>
		<tbody>
			<?php
			 for($c=0;$c<count($visitor_details);$c++) { ?>
			<tr role="row">
				<?php if(isset($visitor_details[$c]['domain_name'])){ ?>
				<td><a href="javascript:void(0)" class="text-inherit"><?php echo $visitor_details[$c]['domain_name']; ?></a></td> <?php }else{ ?>
				<td> </td>
				<?php  } 
					$visitorpagelist = '';
					$dupvisitor=$visitorpagecnt=array();
					$visitorpage = explode(',',$visitor_details[$c]['history']);
					//echo "<pre>";print_r($visitorpage);
					$vct=1;$visitcnt=0;
					for($i=0;$i<count($visitorpage);$i++) {
						if(!in_array($visitorpage[$i],$dupvisitor)) {
							$vct=1;
							$dupvisitor[] = $visitorpage[$i];
							$visitorpagecnt[$visitorpage[$i]] = $vct;					
						} else {
							$visitcnt = $visitorpagecnt[$visitorpage[$i]];
							$visitcnt++;		
							$visitorpagecnt[$visitorpage[$i]] = $visitcnt;
						}			
					}
					foreach($visitorpagecnt as $key=>$val) {
						$visitorpagelist.= $key." (".$val.")<br>";
					}?>
 					<td><a href="javascript:void(0)" class="text-inherit"><?php echo $visitorpagelist; ?></a></td>
				<?php	
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['name'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['referral'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['ip'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['country'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['city'].'</a></td>';  
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['timezone'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['browser'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['visits'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['device'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['os'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['useragent'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. format_datetime_rpt($visitor_details[$c]['last_visit_time'],$staff_id).'</a></td>';
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['continent'].'</a></td>';
					
				?>
			</tr>
			<?php } ?>
		</tbody>
	</table>

<?php break;

case 'virtual_agent_helpful_yesno':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
			    <th class="text-nowrap"><?php echo $vis_language['TXTDOMAIN']; ?></th>
			    <th class="text-nowrap"><?php echo $vis_language['TXTAGENTNAME']; ?></th>
			    <th class="text-nowrap"><?php echo $vis_language['VAFEEDBACKISHELPFULNO']; ?></th>
			    <th class="text-nowrap"><?php echo $vis_language['VAFEEDBACKISHELPFULYES']; ?></th>		
			</tr>
		</thead>	
		<tbody>
			<?php
			 for($c=0;$c<count($visitor_details);$c++) { ?>
			<tr role="row">
				<?php if(isset($visitor_details[$c]['domain_name'])){ ?>
				<td><a href="javascript:void(0)" class="text-inherit"><?php echo $visitor_details[$c]['domain_name']; ?></a></td> <?php }else{ ?>
				<td> </td>
				<?php  } 					
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['avatar_name'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['responseno'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['responseyes'].'</a></td>'; 
				?>
			</tr>
			<?php } ?>
		</tbody>
	</table>

<?php   break;
case 'referal_based_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
			    <th class="text-nowrap"><?php echo $vis_language['TXTDOMAIN']; ?></th>
			    <th class="text-nowrap">visited pages</th>
			    <th class="text-nowrap"><?php echo $vis_language['TXTNAME']; ?></th>
			    <th class="text-nowrap"><?php echo isset($vis_language['TXTREFERRAL'])?$vis_language['TXTREFERRAL']:''; ?></th>		
			    <th class="text-nowrap"><?php echo isset($vis_language['TXTIPADDRESS'])?$vis_language['TXTIPADDRESS']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTCOUNTRY'])?$vis_language['TXTCOUNTRY']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTCITY'])?$vis_language['TXTCITY']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTTIMEZONE'])?$vis_language['TXTTIMEZONE']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTBROWSER'])?$vis_language['TXTBROWSER']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTVISITS'])?$vis_language['TXTVISITS']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTDEVICE'])?$vis_language['TXTDEVICE']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTOS'])?$vis_language['TXTOS']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTUSERAGENT'])?$vis_language['TXTUSERAGENT']:''; ?></th>
				<th class="text-nowrap"><?php echo "Last visit time"; ?></th>
				<th class="text-nowrap"><?php echo isset($vis_language['TXTCONTINENT'])?$vis_language['TXTCONTINENT']:''; ?></th>		
			</tr>
		</thead>
		<tbody>
			<?php
			 for($c=0;$c<count($visitor_details);$c++) { ?>
			<tr role="row">
				<?php if(isset($visitor_details[$c]['domain_name'])){ ?>
				<td><a href="javascript:void(0)" class="text-inherit"><?php echo $visitor_details[$c]['domain_name']; ?></a></td> <?php }else{ ?>
				<td> </td>
				<?php  } 
					$visitorpagelist = '';
					$dupvisitor=$visitorpagecnt=array();
					$visitorpage = explode(',',$visitor_details[$c]['history']);
					//echo "<pre>";print_r($visitorpage);
					$vct=1;$visitcnt=0;
					for($i=0;$i<count($visitorpage);$i++) {
						if(!in_array($visitorpage[$i],$dupvisitor)) {
							$vct=1;
							$dupvisitor[] = $visitorpage[$i];
							$visitorpagecnt[$visitorpage[$i]] = $vct;					
						} else {
							$visitcnt = $visitorpagecnt[$visitorpage[$i]];
							$visitcnt++;		
							$visitorpagecnt[$visitorpage[$i]] = $visitcnt;
						}			
					}
					foreach($visitorpagecnt as $key=>$val) {
						$visitorpagelist.= $key." (".$val.")<br>";
					}?>
 					<td><a href="javascript:void(0)" class="text-inherit"><?php echo $visitorpagelist; ?></a></td>
				<?php	
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['name'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['referral'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['ip'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['country'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['city'].'</a></td>';  
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['timezone'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['browser'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['visits'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['device'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['os'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['useragent'].'</a></td>';
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. format_datetime_rpt($visitor_details[$c]['last_visit_time'],$staff_id).'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['continent'].'</a></td>';
				?>
			
			</tr>
			<?php } ?>
		</tbody>
	</table>
<?php   break;
case 'visitor_based_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
			    <th class="text-nowrap"><?php echo $vis_language['TXTDOMAIN']; ?></th>
			    <th class="text-nowrap">visited pages</th>
			    <th class="text-nowrap"><?php echo $vis_language['TXTNAME']; ?></th>
			    <th class="text-nowrap"><?php echo isset($vis_language['TXTREFERRAL'])?$vis_language['TXTREFERRAL']:''; ?></th>		
			    <th class="text-nowrap"><?php echo isset($vis_language['TXTIPADDRESS'])?$vis_language['TXTIPADDRESS']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTCOUNTRY'])?$vis_language['TXTCOUNTRY']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTCITY'])?$vis_language['TXTCITY']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTTIMEZONE'])?$vis_language['TXTTIMEZONE']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTBROWSER'])?$vis_language['TXTBROWSER']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTVISITS'])?$vis_language['TXTVISITS']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTDEVICE'])?$vis_language['TXTDEVICE']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTOS'])?$vis_language['TXTOS']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTUSERAGENT'])?$vis_language['TXTUSERAGENT']:''; ?></th>
				<th class="text-nowrap"><?php echo "Last visit time"; ?></th>
				<th class="text-nowrap"><?php echo isset($vis_language['TXTCONTINENT'])?$vis_language['TXTCONTINENT']:''; ?></th>		
			</tr>
		</thead>
		<tbody>
			<?php
			 for($c=0;$c<count($visitor_details);$c++) { ?>
			<tr role="row">
				<?php if(isset($visitor_details[$c]['domain_name'])){ ?>
				<td><a href="javascript:void(0)" class="text-inherit"><?php echo $visitor_details[$c]['domain_name']; ?></a></td> <?php }else{ ?>
				<td> </td>
				<?php  } 
					$visitorpagelist = '';
					$dupvisitor=$visitorpagecnt=array();
					$visitorpage = explode(',',$visitor_details[$c]['history']);
					//echo "<pre>";print_r($visitorpage);
					$vct=1;$visitcnt=0;
					for($i=0;$i<count($visitorpage);$i++) {
						if(!in_array($visitorpage[$i],$dupvisitor)) {
							$vct=1;
							$dupvisitor[] = $visitorpage[$i];
							$visitorpagecnt[$visitorpage[$i]] = $vct;					
						} else {
							$visitcnt = $visitorpagecnt[$visitorpage[$i]];
							$visitcnt++;		
							$visitorpagecnt[$visitorpage[$i]] = $visitcnt;
						}			
					}
					foreach($visitorpagecnt as $key=>$val) {
						$visitorpagelist.= $key." (".$val.")<br>";
					}?>
 					<td><a href="javascript:void(0)" class="text-inherit"><?php echo $visitorpagelist; ?></a></td>
				<?php	
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['name'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['referral'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['ip'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['country'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['city'].'</a></td>';  
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['timezone'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['browser'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['visits'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['device'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['os'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['useragent'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. format_datetime_rpt($visitor_details[$c]['last_visit_time'],$staff_id).'</a></td>';
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['continent'].'</a></td>';
				
				?>
			
			</tr>
			<?php } ?>
		</tbody>
	</table>
<?php   break;
case 'view_visitor_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
			    <th class="text-nowrap"><?php echo $vis_language['TXTDOMAIN']; ?></th>
			    <th class="text-nowrap">visited pages</th>
			    <th class="text-nowrap"><?php echo $vis_language['TXTNAME']; ?></th>
			    <th class="text-nowrap"><?php echo isset($vis_language['TXTREFERRAL'])?$vis_language['TXTREFERRAL']:''; ?></th>		
			    <th class="text-nowrap"><?php echo isset($vis_language['TXTIPADDRESS'])?$vis_language['TXTIPADDRESS']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTCOUNTRY'])?$vis_language['TXTCOUNTRY']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTCITY'])?$vis_language['TXTCITY']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTTIMEZONE'])?$vis_language['TXTTIMEZONE']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTBROWSER'])?$vis_language['TXTBROWSER']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTVISITS'])?$vis_language['TXTVISITS']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTDEVICE'])?$vis_language['TXTDEVICE']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTOS'])?$vis_language['TXTOS']:''; ?></th>	
				<th class="text-nowrap"><?php echo isset($vis_language['TXTUSERAGENT'])?$vis_language['TXTUSERAGENT']:''; ?></th>
				<th class="text-nowrap"><?php echo "Last visit time"; ?></th>
				<th class="text-nowrap"><?php echo isset($vis_language['TXTCONTINENT'])?$vis_language['TXTCONTINENT']:''; ?></th>		
			</tr>
			
		</thead>
		<tbody>
			<?php
			 for($c=0;$c<count($visitor_details);$c++) { ?>
			<tr role="row">
			    <?php if(isset($visitor_details[$c]['domain_name'])){ ?>
				<td><a href="javascript:void(0)" class="text-inherit"><?php echo $visitor_details[$c]['domain_name']; ?></a></td> <?php }else{ ?>
				<td> </td>
				<?php  } 
					$visitorpagelist = '';
					$dupvisitor=$visitorpagecnt=array();
					$visitorpage = explode(',',$visitor_details[$c]['history']);
					//echo "<pre>";print_r($visitorpage);
					$vct=1;$visitcnt=0;
					for($i=0;$i<count($visitorpage);$i++) {
						if(!in_array($visitorpage[$i],$dupvisitor)) {
							$vct=1;
							$dupvisitor[] = $visitorpage[$i];
							$visitorpagecnt[$visitorpage[$i]] = $vct;					
						} else {
							$visitcnt = $visitorpagecnt[$visitorpage[$i]];
							$visitcnt++;		
							$visitorpagecnt[$visitorpage[$i]] = $visitcnt;
						}			
					}
					foreach($visitorpagecnt as $key=>$val) {
						$visitorpagelist.= $key." (".$val.")<br>";
					}?>
 					<td><a href="javascript:void(0)" class="text-inherit"><?php echo $visitorpagelist; ?></a></td>
				<?php	
				//for($j=0; $j < $view_info1['view_count']; $j++){
					//if(isset($visitor_details[$c]['name'])){
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['name'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['referral'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['ip'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['country'].'</a></td>';
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['city'].'</a></td>';  
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['timezone'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['browser'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['visits'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['device'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['os'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['useragent'].'</a></td>'; 
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. format_datetime_rpt($visitor_details[$c]['last_visit_time'],$staff_id).'</a></td>';
					echo '<td><a href="javascript:void(0)" class="text-inherit">'. $visitor_details[$c]['continent'].'</a></td>';
									
				?>
			
			</tr>
			<?php } ?>
		</tbody>
	</table>	
<?php 
break;
case 'livechat_staffwise_chat_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTDEPARTMENT'];?></th>
				<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTSTATUS'];?></th>
				<th><?php echo $vis_language['TXTMISSCHATREASON'];?></th>
				<th><?php echo $vis_language['TXTINITIATEDATE'];?></th>
				<th><?php echo $vis_language['TXTSTARTDATE'];?></th>
				<th><?php echo $vis_language['TXTENDDATE'];?></th>
				<th><?php echo $vis_language['TXTTOTDURATION'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++) { 
				if($report[$i]['operation_id']==11 || $report[$i]['operation_id']==14 || $report[$i]['operation_id']==15 || $report[$i]['operation_id']==16 || ($report[$i]['operation_id']==13 && $report[$i]['operator']==4)){
					$status = $vis_language['TXTMISSEDCHAT'];
					$status_reson = $report[$i]['description'];
				} else{
					$status = $vis_language['TXTACTIVECHAT'];
					$status_reson = '-';
				} ?>
				<tr role="row">
					<td><?php if($report[$i]['ticket_id']!=0){ ?><a target="_blank" href="#/ticket/ticket_details/<?php echo $report[$i]['ticket_hash']?>/<?php echo $report[$i]['ticket_id']?>"><?php echo $report[$i]['ticket_hash']?></a><?php }else{ echo'--'; }?></td>
					<td><?php echo $report[$i]['department_name'];?></td>
					<td><?php echo $report[$i]['first_name'].' '.$report[$i]['last_name'];?></td>
					<td><?php echo $report[$i]['email'];?></td>
					<td><?php echo $status;?></td>
					<td><?php echo $status_reson;?></td>
					<td><?php echo format_datetime($report[$i]['initiate_time']);?></td>
					<td><?php echo ($report[$i]['start_time']!=0)?format_datetime($report[$i]['start_time']):'-';?></td>
					<td><?php echo ($report[$i]['start_time']!=0)?format_datetime($report[$i]['end_time']):'-';?></td>
					<td><?php echo ($report[$i]['start_time']!=0)?count_remain_time($report[$i]['end_time'] - $report[$i]['start_time']):'-'; ?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>	
<?php
break;
case 'client_wise_chat_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
				<th><?php echo $vis_language['TXTDEPARTMENT'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTSTATUS'];?></th>
				<th><?php echo $vis_language['TXTSTARTDATE'];?></th>
				<th><?php echo $vis_language['TXTENDDATE'];?></th>
				<th><?php echo $vis_language['TXTTOTDURATION'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++) { 
				if($report[$i]['operation_id']==11 || $report[$i]['operation_id']==14 || $report[$i]['operation_id']==15 || $report[$i]['operation_id']==16 || ($report[$i]['operation_id']==13 && $report[$i]['operator']==4)){
					$status = $vis_language['TXTMISSEDCHAT'];
					$status_reson = $report[$i]['description'];
				} else{
					$status = $vis_language['TXTACTIVECHAT'];
					$status_reson = '-';
				}
				?>
				<tr role="row">
					<td><?php if($report[$i]['ticket_id']!=0){ ?><a target="_blank" href="#/ticket/ticket_details/<?php echo $report[$i]['ticket_hash']?>/<?php echo $report[$i]['ticket_id']?>"><?php echo $report[$i]['ticket_hash']?></a><?php }else{ echo'--'; }?></td>
					<td><?php echo $report[$i]['subject'];?></td>
					<td><?php echo $report[$i]['first_name'].' '.$report[$i]['last_name'];?></td>
					<td><?php echo $report[$i]['department_name'];?></td>
					<td><?php echo $report[$i]['email'];?></td>
					<td><?php echo $status;?></td>
					<td><?php if($report[$i]['end_time']>0 && $report[$i]['start_time']){ echo format_datetime($report[$i]['start_time']); }else{ echo "-"; } ?></td>
					<td><?php if($report[$i]['end_time']>0 && $report[$i]['start_time']){ echo format_datetime($report[$i]['end_time']); }else{ echo "-"; } ?></td>
					<td><?php if($report[$i]['end_time']>0 && $report[$i]['start_time']){ echo count_remain_time($report[$i]['end_time'] - $report[$i]['start_time']); }else{ echo "-"; } ?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>	
<?php
break;
case 'organization_wise_chat_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
				<?php /*<th><?php echo $vis_language['TXTSTARTDATE'];?></th>
				<th><?php echo $vis_language['TXTENDDATE'];?></th>*/?>

				<th><?php echo $vis_language['TXTSTATUS'];?></th>
				<th><?php echo $vis_language['TXTMISSCHATREASON'];?></th>
				<th><?php echo $vis_language['TXTINITIATEDATE'];?></th>
				<th><?php echo $vis_language['TXTTOTDURATION'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++) { ?>
				<tr role="row">
					<td><?php if($report[$i]['ticket_id']!=0){ ?><a target="_blank" href="#/ticket/ticket_details/<?php echo $report[$i]['ticket_hash']?>/<?php echo $report[$i]['ticket_id']?>"><?php echo $report[$i]['ticket_hash']?></a><?php }else{ echo'--'; }?></td>
					<td><?php echo $report[$i]['subject'];?></td>
					<td><?php echo $report[$i]['first_name'].' '.$report[$i]['last_name'];?></td>
					<td><?php echo $report[$i]['email'];?></td>
					<td><?php echo $report[$i]['group_name'];?></td>

					<?php if($report[$i]['operation_id']==11 || $report[$i]['operation_id']==14 || $report[$i]['operation_id']==15 || $report[$i]['operation_id']==16 || ($report[$i]['operation_id']==13 && $report[$i]['operator']==4)){
					$status = $vis_language['TXTMISSEDCHAT'];
					$status_reson = $report[$i]['description'];
					} else{
						$status = $vis_language['TXTACTIVECHAT'];
						$status_reson = '-';
					}
					?>
					<td><?php echo $status; ?></td>
					<td><?php echo $status_reson;?></td>
					<td><?php echo format_datetime_rpt($report[$i]['initiate_time'],$staff_id); ?></td>
					<td><?php if($report[$i]['end_time']>0 && $report[$i]['start_time']>0){ echo count_remain_time($report[$i]['end_time'] - $report[$i]['start_time']); }else{ echo "-"; } ?></td>
					<?php /*<td><?php if($report[$i]['end_time']>0 && $report[$i]['start_time']){ echo format_datetime($report[$i]['start_time']); }else{ echo "-"; } ?></td>
					<td><?php if($report[$i]['end_time']>0 && $report[$i]['start_time']){ echo format_datetime($report[$i]['end_time']); }else{ echo "-"; } ?></td>
					<td><?php if($report[$i]['end_time']>0 && $report[$i]['start_time']){ echo count_remain_time($report[$i]['end_time'] - $report[$i]['start_time']); }else{ echo "-"; } ?></td> */?>
				</tr><?php
			}
			?>
		</tbody>
	</table>	
<?php
break;
case 'time_spent_by_client':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTDEPARTMENT'];?></th>
				<th><?php echo $vis_language['TXTCLIENTNAME'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th> 
				<th><?php echo $vis_language['TXTSTARTDATE'];?></th>
				<th><?php echo $vis_language['TXTENDDATE'];?></th>
				<th><?php echo 'Spent time';?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++) { 
				?>
				<tr role="row">
					<td><?php if($report[$i]['ticket_id']!=0){ ?><a target="_blank" href="#/ticket/ticket_details/<?php echo $report[$i]['ticket_hash']?>/<?php echo $report[$i]['ticket_id']?>"><?php echo $report[$i]['ticket_hash']?></a><?php }else{ echo'--'; }?></td>
					<td><?php echo $report[$i]['department_name'];?></td>
					<td><?php echo $report[$i]['first_name'].' '.$report[$i]['last_name'];?></td>
					<td><?php echo $report[$i]['email'];?></td> 
					<td><?php echo ($report[$i]['start_time']!=0)?format_datetime($report[$i]['start_time']):'-'; ?></td>
					<td><?php echo ($report[$i]['start_time']!=0)?format_datetime($report[$i]['end_time']):'-'; ?></td>
					<td><?php echo ($report[$i]['start_time']!=0)?count_remain_time($report[$i]['end_time'] - $report[$i]['start_time']):'-';  ?></td>
				</tr><?php
			}
			?>
		</tbody>
	</table>	
<?php
break;
case 'client_with_max_chats':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTCLIENT'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTTOTALCHAT'];?></th>
			</tr>
	    </thead>
	    <tbody>
	        <?php
	        rsort($report_new);
	        $limnk1='';
					$limnk2='';

				for($i1=0;$i1<count($report_new);$i1++)
				{
					$limnk1 = (isset($report_new[$i1]['first_name'])?$report_new[$i1]['first_name']:'').'/'.(isset($report_new[$i1]['client_id'])?$report_new[$i1]['client_id']:'');
					$limnk2 = (isset($report_new[$i1]['first_name'])?$report_new[$i1]['first_name']:'').' ' .(isset($report_new[$i1]['last_name'])?$report_new[$i1]['last_name']:'');
					?><tr>
					<td><?php echo $limnk2;?></td>
					<td><a href="#/client/client_details/<?=$limnk1?>" target="_blank"><?php echo (isset($report_new[$i1]['email'])?$report_new[$i1]['email']:'');?></a></td>
					<td><?php echo (isset($report_new[$i1]['max_lc_count'])?$report_new[$i1]['max_lc_count']:'');?></td>
					</tr>
					<?php 			 
				}
			?>
	    </tbody>
	</table>	
<?php
break;
case 'prechat_custom_field_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTCLIENT'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTFIELDNAME'];?></th>
				<th><?php echo $vis_language['TXTFLDVAL'];?></th>
			</tr>
	    </thead>
	    <tbody>
	        <?php
			for($i=0;$i<count($report_new);$i++) { 
				?>
				<tr role="row">
					<td><?php if($report_new[$i]['ticket_id']!=0){ ?><a target="_blank" href="#/ticket/ticket_details/<?php echo $report_new[$i]['ticket_hash']?>/<?php echo $report_new[$i]['ticket_id']?>"><?php echo $report_new[$i]['ticket_hash']?></a><?php }else{ echo'--'; }?></td>
					<?/*<td><?php echo $report_new[$i]['department_name'];?></td>*/?>
					<td><?php echo $report_new[$i]['first_name'].' '.$report_new[$i]['last_name'];?></td>
					<td><?php echo $report_new[$i]['email'];?></td> 
					<td><?php echo $report_new[$i]['field_name']; ?></td>
					<td><?php echo $report_new[$i]['field_value']; ?></td>
				</tr><?php
			}
			?>
	    </tbody>
	</table>	
<?php
break;
case 'visitor_navigation_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTPAGE'].' '.$vis_language['TXTTITLE'];?></th>
				<th><?php echo $vis_language['TXTPAGEURL'];?></th>
				<th><?php echo $vis_language['TXTNOOFHITS'];?></th>
			</tr>
	    </thead>
	    <tbody>
	        <?php
			for($i=0;$i<count($visitor_details);$i++) { 
				?>
				<tr role="row">
					<td><?php echo $visitor_details[$i]['pagetitle'];?></td>
					<td><?php echo $visitor_details[$i]['pageurl'];?></td> 
					<td><?php echo $visitor_details[$i]['page_cnt']; ?></td>
				</tr><?php
			}
			?>
	    </tbody>
	</table>	
<?php
break;
case 'actual_departmentwise_sla_report':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
				<th><?php echo $vis_language['TXTSUBJECT'];?></th>
				<th><?php echo $vis_language['TXTDEPARTMENT'];?></th>
				<th><?php echo $vis_language['TXTSTATUS'];?></th>				
				<th><?php echo $vis_language['TXTDUETIME'];?></th>
				<th><?php echo $vis_language['TXTRESPONSESLA'];?></th>
				<th><?php echo $vis_language['TXTTOTAL'].' '.lcfirst($vis_language['TXTREPLIED']);?></th>
			</tr>
	    </thead>
	    <tbody>
	        <?php
			foreach($report as $details) { 
				?>
				<tr role="row">
					<td><a target="_blank" href="#/ticket/ticket_details/<?php echo $details['ticket_hash']?>/<?php echo $details['ticket_id']?>"><?php echo $details['ticket_hash']?></a></td>
					<td><?php echo $details['subject'];?></td> 
					<td><?php echo $details['department_name']; ?></td>
					<td><?php echo $details['status_name']; ?></td>
					
					<?php   $time=$details['total_time']*60;
							 $ret=count_remain_time($time); ?>
					<td><?php echo ($details['total_time']!=-1)?$ret:0; ?></td>
					<td><?php echo ($details['sla_maintains']=='1')?$vis_language['TXTMAINTAIN']:$vis_language['TXTNOTMAINTAIN']; ?></td>
					<td><?php  echo $details['total_count']; ?></td>
			<?php }
			?>
	    </tbody>
	</table>	
<?php
break;

case 'all_staff_chat_count':
?>
	<table class="table table-hover table-striped">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTSTAFFNAME'];?></th> 
				<th><?php echo $vis_language['TXTACTIVECHAT']; ?></th> 
				<th><?php echo $vis_language['TXTMISSEDCHAT']; ?></th> 
			</tr>
		</thead>
		<tbody>
			<?php
			for($i=0;$i<count($report);$i++) {					 
				  ?>
				<tr role="row"> 
					<td><?php echo $report[$i]['first_name'].' '.$report[$i]['last_name'];?></td> 
					<td><?php echo $report[$i]['completed_chat'];?></td> 
					<td><?php echo $report[$i]['missed_chat'];?></td>				 
				</tr><?php
			}
			?>
		</tbody>
	</table>	
<?php 
break;
case 'acknowledgement_report':
?>
<table class="table table-hover table-striped">
	<thead>
		<tr role="row">
			<th><?php echo $vis_language['TXTTICKETHASH'];?></th>
			<th><?php echo $vis_language['TXTCREATIONDATE'];?></th>
			<th><?php echo $vis_language['TXTASSETNAME'];?></th>
			<th><?php echo $vis_language['TXTCITYPE'];?></th>
			<th><?php echo $vis_language['TXTMANAGEDBY'];?></th>
			<th><?php echo "Used by";//$vis_language['TXTLOCATION'];?></th>
		</tr>
	</thead>
	<tbody>
		  <?php
			for($i=0;$i<count($report);$i++) {					 
				  ?>
				<tr role="row"> 
					<td><?php echo $report[$i]['ticket_hash'];?></td> 
					<td><?php echo format_datetime($report[$i]['receive_date']);?></td> 
					<td><a href="#/cmdb/assets_details/<?php echo rawurlencode(str_replace('.', '',str_replace('/', '', $report[$i]['name']))).'/'.$report[$i]['assets_id']; ?>" target="_blank"><?php echo $report[$i]['name'];?></a></td>	
					<td><?php echo $report[$i]['CNAME'];?></td> 
					<td><?php echo $report[$i]['fname'];?></td> 
					<td><?php echo $report[$i]['clnt_fname'];?></td> 
				</tr><?php
			}
			?>
	</tbody>
	</table>
<?php break;
case 'chat_survey_report':
?>
	<table class="table table-hover table-striped" id="datatable">
		<thead>
			<tr role="row">
				<th><?php echo $vis_language['TXTCLIENT'];?></th>
				<th><?php echo $vis_language['TXTEMAIL'];?></th>
				<th><?php echo $vis_language['TXTORGANIZATION'];?></th>
				<th><?php echo $vis_language['TXTCHATSURVEY'];?></th>
				<th><?php echo $vis_language['TXTCHATSURVEYDATE'];?></th>
				<th><?php echo $vis_language['TXTCHATSURVEYFIELD'];?></th>
				<th></th>
			</tr>
		</thead>
		<tbody> 
		<?php
			if($client_details!=-1){
			for($i=0;$i<count($client_details);$i++) {
				?><tr><?php echo '<td target="_blank" class="txt_nowrap"><a href="#/client/client_details/'.$client_details[$i]['first_name'].' '.$client_details[$i]['last_name'].'/'.$client_details[$i]['client_id'].'">'.$client_details[$i]['first_name'].' '.$client_details[$i]['last_name'].'</a></td><td class="txt_nowrap"><a target="_blank" href="#/client/client_details/'.$client_details[$i]['first_name'].' '.$client_details[$i]['last_name'].'/'.$client_details[$i]['client_id'].'">'.$client_details[$i]['email'].'</a></td><td class="txt_nowrap">'.$client_details[$i]['group_name'].'</td><td class="txt_nowrap">'.$custom_group_details_select[0]['customgroup_name'].'</td><td class="txt_nowrap">'.format_datetime($client_details[$i]['entry_date']).'</td>';?>
				<td class="txt_nowrap"><a class="text-muted link" data-toggle="ajaxModal" data-modal-arguments="vis_module=report&vis_operation=display_client_chat_survey&vis_client_id=<?php echo $client_details[$i]['client_id'];?>&vis_survey_id=<?php echo $survey_id;?>&vis_static_area=vis_survey_display_form&vis_dataids='<?php echo base64_encode($client_details[$i]['dataids']);?>'" title="<?php echo $vis_language['TXTVIEW'];?>" href="javascript:void(0);" ><?php  echo $vis_language['TXTVIEW'];?></a></td><td class="txt_nowrap"><a href="index.php?vis_module=report&vis_operation=export_chat_survey&vis_type=pdf&vis_client_id=<?php echo $client_details[$i]['client_id'];?>&vis_survey_id=<?php echo $survey_id;?>&vis_survey_dt=<?php echo format_datetime($dataArr[$client_details[$i]['client_id']]);?>&vis_dataids='<?php echo base64_encode($client_details[$i]['dataids']);?>'" target="_blank" class="link"><?php echo $vis_language['TXTEXPORTTOPDF'];?></a>
				</td></tr>
		   <?php }
			}?>
		</tbody>
	</table>	
<?php } ?> 


	
