#MAC AGENT SCANNING BY VISIONHELPDESK
PORTAL_URL='https://YOURDOMAIN.com'
REGI_KEY='REGISTRATION_KEY';
VIS_STAFF_USERNAME='USERNAME'
VIS_STAFF_PASSWORD='PASSWORD'
VIS_DOMAIN_ID=''
API_URL=PORTAL_URL+'/api/index.php?vis_reg_key='+REGI_KEY;
VIS_STAFF_ID=''
VIS_USEDBY_TYPE=''

import urllib3
import sys
import hashlib
import json
import requests
import os
import socket
import requests
import subprocess
import time
import datetime
import re
import base64

requests.packages.urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)
BASE_DIR=os.path.dirname(os.path.abspath(__file__))
settingfilename=BASE_DIR+'/settings.txt'
class Vision:
	username='';
	password='';
	reg_key='';
	
	def __init__(self):
		self.username='';
		self.password='';
		self.reg_key='';
		
	def get_data(self):
		print("Authenticating...")
		global REGI_KEY,API_URL,VIS_STAFF_USERNAME,VIS_STAFF_PASSWORD,VIS_STAFF_ID,VIS_USEDBY_TYPE,VIS_DOMAIN_ID
		self.reg_key=REGI_KEY
		api_url_base = API_URL+'&vis_module=cmdb&vis_operation=verify_key&vis_encode=json';
		headers = {'Content-Type': 'application/json','Authorization': 'Bearer {0}'}
		response = requests.get(api_url_base, headers=headers, verify=False)
		if response.status_code == 200:
			try:
				res=json.loads(response.content.decode('utf-8'));
				VIS_DOMAIN_ID=str(res['res'])
				if VIS_DOMAIN_ID==0 or VIS_DOMAIN_ID=='':
					print("Invalid registration key.")
					return False
				else:
					if VIS_STAFF_PASSWORD!='' and VIS_STAFF_USERNAME!='':
						self.username=VIS_STAFF_USERNAME;
						self.password = hashlib.md5(str(VIS_STAFF_PASSWORD).encode('utf-8')).hexdigest()
						vis_integratepassword=encodepass(self.password);
						api_url_base=PORTAL_URL+'/api/index.php?vis_txtusername='+self.username+'&vis_txtuserpass='+self.password+'&vis_integratepassword='+vis_integratepassword+'&vis_module=staff&vis_operation=get_staff_details&vis_encode=json';
						headers = {'Content-Type': 'application/json','Authorization': 'Bearer {0}'}
						response = requests.get(api_url_base, headers=headers, verify=False)
						if response.status_code == 200:
							try:
								res=json.loads(response.content.decode('utf-8'));
								VIS_STAFF_ID=res[0]['staff_id']
								if VIS_STAFF_ID==0:
									VIS_USEDBY_TYPE='3'
									return True;
								else:
									VIS_USEDBY_TYPE='2'
									return True;
							except:
								VIS_STAFF_ID=0
								VIS_USEDBY_TYPE='3'
								return True;
						else:
							VIS_STAFF_ID=0;
							VIS_USEDBY_TYPE='3'
							return True;
					else:
						VIS_STAFF_ID=0;
						VIS_USEDBY_TYPE='3'
						return True;
					return True;
			except:
				print("Invalid registration key.")
				return False
		else:
			print("Invalid registration key.")
			return False

	def self_scan(self):
		global REGI_KEY,API_URL,LINKURL,VIS_STAFF_USERNAME,VIS_STAFF_PASSWORD,VIS_STAFF_ID,VIS_USEDBY_TYPE,VIS_DOMAIN_ID
		output=''
		CONN=""
		xmlfilename=self.generate_filename(CONN)
		#xmlfilename+='.xml'
		filetoupload=self.execute_shell(CONN);
		api_url_base = API_URL+'&vis_module=cmdb&vis_operation=upload_xml&vis_encode=json'
		filetoupload = base64.b64encode(filetoupload.encode('utf-8',errors = 'strict'));
		filetoupload=filetoupload.decode('utf-8');
		pload={'filedata':filetoupload,'filename':xmlfilename}
		r = requests.post(api_url_base, pload)
		res=r.json()
		if res['res']=='1':
			if res['msg']=='success':
				if res['responcecode']=='0003':
					print('Ooops! It looks like you tried to add more assets beyond what you already purchased. Please contact support and we will get you sorted out.')
				else:
					print('Asset added successfully')
					self.set_cron("")
			else:
				print(res['msg'])
		else:
			print('Failed')
			
	def execute_shell(self,CONN):
		print("---------------------------------------------")
		print("Scanning...")
		global REGI_KEY,API_URL,LINKURL,VIS_STAFF_ID,VIS_USEDBY_TYPE,VIS_DOMAIN_ID
		output='';
		output="<?xml version='1.0' encoding='UTF-8'?><resultset><row><vis_domain>"+VIS_DOMAIN_ID+"</vis_domain><vis_staff_id>"+str(VIS_STAFF_ID)+"</vis_staff_id>";
		nacount=[]
		nacountzero=''
		cmd=CONN+" networksetup -listallhardwareports | awk '/Hardware Port:/{getline; print $2}'"
		process=subprocess.Popen(CONN+" networksetup", stdout=subprocess.PIPE,shell=True,stderr=subprocess.PIPE)
		p1, _ = process.communicate()
		if process.returncode==0:
			p1=subprocess.Popen(cmd, stdout=subprocess.PIPE,shell=True)
			for line in p1.stdout:
				nacount.append((line.decode("utf-8")).strip())
		if len(nacount)<=0:
			nacountzero=''
		else:
			nacountzero=nacount[0]                
		status, na_ip = getstatusoutput(CONN+" ifconfig "+nacountzero+" | grep 'inet ' | awk -F' ' '{print $2}' | awk '{print $1}'")
		statusnic, na_mac = getstatusoutput(CONN+" ifconfig "+nacountzero+" | grep 'ether ' | cut -d ' ' -f 2")
		status, hostname = getstatusoutput(CONN+" hostname")
		assetname=hostname.replace('.', '_')
		assetname=assetname.replace(' ', '')
		assetname=assetname.strip()+na_mac.strip();
		assetname=assetname.replace(' ','')
		output+= "<vis_name>";
		output+=assetname.strip()
		output+="</vis_name>";
		output+= "<vis_description>"
		status,desc=getstatusoutput(CONN+" name -a")
		output+=desc.strip()
		output+="</vis_description><vis_usedby>"+str(VIS_STAFF_ID)+"</vis_usedby><vis_usedbytype>"+str(VIS_USEDBY_TYPE)+"</vis_usedbytype><vis_managed_by>"+str(VIS_STAFF_ID)+"</vis_managed_by><vis_impact_id>1</vis_impact_id><vis_location_id></vis_location_id><vis_assigned_on></vis_assigned_on><audit_date>"+datetime.datetime.now().strftime('%b %d, %G %I:%M%p')+"</audit_date><w_year></w_year><w_month></w_month><w_expiry></w_expiry><asset_state>1</asset_state><cost></cost><salvage></salvage><depreciation_type></depreciation_type><useful_life></useful_life><barcode></barcode>"
		output+= "<vis_hostname>";
		output+=hostname.strip()
		output+="</vis_hostname>";
		status, whoami = getstatusoutput(CONN+" logname")
		whoami=whoami.strip();
		if whoami=='':
		    status, whoami = getstatusoutput(CONN+" whoami")
		    whoami=whoami.strip();
		if whoami=='':
		    status, whoami = getstatusoutput(CONN+" id -u -n")
		    whoami=whoami.strip();
		whoami1=whoami.split('\\');
		if len(whoami1)>1:
		    whoami=whoami1[1];
		else:
		    whoami=whoami;
		output+="<vis_pcuser>"+whoami+"</vis_pcuser>"
		output+="<mac_addr>"+na_mac+"</mac_addr>"
		output+="<main_os>Mac</main_os>";
		output+="<computer_type>Desktop</computer_type>";
		output+="<sp></sp><service_tag></service_tag>";
		output+="<model>";
		status, model = getstatusoutput(CONN+" system_profiler SPHardwareDataType | grep 'Model Name' |cut -d ':' -f 2")
		output+=model.strip()
		output+="</model>";
		
		output+="<vendor>";
		#status, vendor = getstatusoutput(CONN+" cat /sys/devices/virtual/dmi/id/sys_vendor")
		#output+=vendor
		output+="</vendor>";
		
		output+="<asset_tag>";
		status, asset_tag = getstatusoutput(CONN+" system_profiler SPHardwareDataType | awk '/Serial/ {print $4}'")
		if status==0:
			output+=asset_tag.strip()
		output+="</asset_tag>";
		
		output+="<serial_key>";
		status, serial_key = getstatusoutput(CONN+" system_profiler SPHardwareDataType | awk '/Serial/ {print $4}'")
		if status==0:
			output+=serial_key.strip()
		output+="</serial_key>";
		
		output+="<manufacturer>";
		#status, manufacturer = getstatusoutput(CONN+" dmidecode -s system-manufacturer")
		#if status==0:
		#       output+=manufacturer
		output+="Apple Inc.</manufacturer>";
		
		output+="<ip_addr>";
		output+= na_ip.strip()
		output+="</ip_addr>";
		
		output+="<subnet_mask>";
		status, subnet_mask = getstatusoutput(CONN+" system_profiler SPNetworkDataType | awk '/SubnetMask/ {print $2}' | head -1")
		output+=subnet_mask.strip()
		output+="</subnet_mask>";
		
		output+="<os>";
		status, os = getstatusoutput(CONN+" system_profiler SPSoftwareDataType | grep 'System Version' | cut -d ':' -f 2 ")
		output+=os.strip()
		output+="</os>";
		output+="<virtual_memory>";
		#status1, virtual_memory1 = getstatusoutput(CONN+" getconf _AVPHYS_PAGES",2)
		#status2, virtual_memory2 = getstatusoutput(CONN+" getconf PAGE_SIZE",2)
		#if status1==0 and status2==0:
		#       virtual_memory=float(virtual_memory1) * float(virtual_memory2)/(1024 * 1024)
		#       output+=str(virtual_memory)+' MB'
		output+="</virtual_memory>";
		
		output+="<total_memory>";
		status, total_memory = getstatusoutput(CONN+" system_profiler SPHardwareDataType | grep 'Memory' |cut -d ':' -f 2")
		if status==0:
			#total_memory=float(total_memory)
			output+=total_memory
		output+="</total_memory>";
		
		output+="<acqui_date>";
		#status, rmpexist = getstatusoutput(CONN+" rpm -qi setup")
		#if status==0:
		#       status, acqui_date = getstatusoutput(CONN+" rpm -qi setup | grep 'Install Date' | cut -d ':' -f 2 | awk '{print $3 " " $2 "," $4}'")
		#else:
		#       status, acqui_date = getstatusoutput(CONN+" ls -ld /var/log/installer /|tail -1|awk '{print $6 "+'" "'+" $7 "+'","'+" $8}'")
		#output+=acqui_date;
		output+=datetime.datetime.now().strftime('%b %d, %G')+"</acqui_date>";
		print("Scanning processors..")
		output+="<processors><group><processor_info>";
		status, processor_info = getstatusoutput(CONN+" system_profiler SPHardwareDataType | grep 'Processor Name'| cut -d ':' -f 2")
		output+=processor_info.strip()
		output+="</processor_info><processor_mfg>";
		#status, processor_mfg = getstatusoutput(CONN+" dmidecode -t 4 | grep 'Manufacturer' | cut -d ':' -f 2 | cut -d '@' -f 1")
		#output+=processor_mfg.strip()
		output+="</processor_mfg><processor_speed>";
		status, processor_speed = getstatusoutput(CONN+" system_profiler SPHardwareDataType | grep 'Processor Speed'| cut -d ':' -f 2")
		output+=processor_speed.strip()
		output+="</processor_speed><processor_cores>";
		status, processor_cores = getstatusoutput(CONN+" system_profiler SPHardwareDataType | grep 'Total Number of Cores'| cut -d ':' -f 2")
		output+=processor_cores.strip()
		output+="</processor_cores>";
		output+="<processor_l2cachesize>";
		status, processor_l2cachesize = getstatusoutput(CONN+" system_profiler SPHardwareDataType | grep 'L2 Cache'| cut -d ':' -f 2")
		output+=processor_l2cachesize.strip()
		output+="</processor_l2cachesize>";
		output+="<processor_l3cachesize>";
		status, processor_l3cachesize = getstatusoutput(CONN+" system_profiler SPHardwareDataType | grep 'L3 Cache'| cut -d ':' -f 2")
		output+=processor_l3cachesize.strip()
		output+="</processor_l3cachesize>";
		output+="<processor_datawidth>";
		#status, processor_datawidth = getstatusoutput(CONN+" lscpu | grep 'Core(s) per socket' | cut -d ':' -f 2 | cut -d '@' -f 1")
		#output+=processor_datawidth
		output+="</processor_datawidth>";
		output+="<processor_voltage>";
		#status, processor_voltage = getstatusoutput(CONN+" dmidecode -t 4 | grep Voltage | cut -d ':' -f 2 | cut -d '@' -f 1")
		#output+=processor_voltage
		output+="</processor_voltage>"; 
		output+="<processor_status>";
		#status, processor_status = getstatusoutput(CONN+" dmidecode -t 4 | grep Status | cut -d ':' -f 2 | cut -d '@' -f 1")
		#output+=processor_status
		output+="</processor_status>";
		output+="<processor_processorid>";
		#status, processor_processorid = getstatusoutput(CONN+" dmidecode -t 4 | grep ID | cut -d ':' -f 2 | cut -d '@' -f 1")
		#output+=processor_processorid
		output+="</processor_processorid>";
		output+="</group></processors>";
		print("Scanning BIOS..")
		output+="<bios><group>";
		output+="<bios_name>BIOS Ver:";
		status, bios_name = getstatusoutput(CONN+"  system_profiler SPHardwareDataType | grep 'Boot ROM Version'| cut -d ':' -f 2")
		output+=bios_name.strip()
		output+="</bios_name>";
		output+="<bios_manufac>";
		#status, bios_manufac = getstatusoutput(CONN+" dmidecode -t 0 | grep Vendor | cut -d ':' -f 2 | cut -d '@' -f 1")
		#output+=bios_manufac
		output+="</bios_manufac>";
		output+="<bios_info>";
		#status, bios_info = getstatusoutput(CONN+" dmidecode -t 0 | grep 'BIOS Revision' | cut -d ':' -f 2 | cut -d '@' -f 1")
		#output+=bios_info
		output+="</bios_info>";
		output+="</group></bios>";
		print("Scanning display devices..")
		output+="<display><group>";
		output+="<dm_name>";
		status, dm_name = getstatusoutput(CONN+"  system_profiler SPDisplaysDataType |sed -e '1,/Displays/d' | head -n 1 | cut -d ':' -f 1")
		output+=dm_name.strip()
		output+="</dm_name>";
		output+="<dm_desp>";
		status, dm_desp = getstatusoutput(CONN+" system_profiler SPDisplaysDataType |sed -e '1,/Displays/d' | tail -f")
		#output+=dm_desp.strip()
		output+="</dm_desp>";
		output+="<dm_manufa>";
		status, dm_manufa = getstatusoutput(CONN+" system_profiler SPDisplaysDataType | grep 'Vendor' | cut -d ':' -f 2")
		output+=dm_manufa.strip()
		output+="</dm_manufa>";
		output+="</group></display>";
		print("Scanning physical memory..")
		status, meminfor = getstatusoutput(CONN+" system_profiler SPMemoryDataType | grep 'BANK'")
		bankdet= meminfor.splitlines()
		i = 0
		output+="<physicalmemory>";
		while i < len(bankdet):
			status, pm_attr = getstatusoutput(CONN+" system_profiler SPMemoryDataType | sed -e '1,/BANK "+str(i)+"/d' | head -n 8 | grep Size | cut -d ':' -f 2")
			status, pm_partnum = getstatusoutput(CONN+" system_profiler SPMemoryDataType | sed -e '1,/BANK "+str(i)+"/d' | head -n 8 | grep 'Part Number' | cut -d ':' -f 2")
			status, pm_serialnum = getstatusoutput(CONN+" system_profiler SPMemoryDataType | sed -e '1,/BANK "+str(i)+"/d' | head -n 8 | grep 'Serial Number' | cut -d ':' -f 2")
			status, pm_speed = getstatusoutput(CONN+" system_profiler SPMemoryDataType | sed -e '1,/BANK "+str(i)+"/d' | head -n 8 | grep Speed | cut -d ':' -f 2")
			status, pm_name = getstatusoutput(CONN+" system_profiler SPMemoryDataType | grep 'BANK "+str(i)+"' | cut -d ':' -f 1")
			output+="<group><pm_name>";
			pm_name= pm_name .replace("/","-")
			output+=pm_name.strip()
			output+="</pm_name>";
			output+="<pm_serialnum>";
			output+=pm_serialnum.strip()
			output+="</pm_serialnum>";
			output+="<pm_partnum>";
			output+=pm_partnum.strip()
			output+="</pm_partnum>";
			output+="<pm_speed>";
			output+=pm_speed.strip()
			output+="</pm_speed>";
			output+="<pm_attr>";
			output+= 'Size : '+pm_attr.strip()
			output+="</pm_attr></group>";
			i = i + 1;
		output+="</physicalmemory>";
		print("Scanning harddisk..")
		output+="<harddisk><group>";
		status, hd_model = getstatusoutput(CONN+" diskutil info /dev/disk0 | grep 'Device / Media Name' | cut -d ':' -f 2")
		bnk= hd_model.strip()
		status, hd_capacity = getstatusoutput(CONN+" system_profiler SPSerialATADataType | sed -e '1,/"+ bnk +"/d' | head -n 8 | grep 'Capacity' | cut -d ':' -f 2")
		status, hd_serialno = getstatusoutput(CONN+" system_profiler SPSerialATADataType | sed -e '1,/"+ bnk +"/d' | head -n 8 | grep 'Serial' | cut -d ':' -f 2")
		output+="<hd_capacity>"+ hd_capacity.strip()+"</hd_capacity>";
		output+="<hd_serialno>"+ hd_serialno.strip() +"</hd_serialno>";
		output+="<hd_model>"+ hd_model.strip() +"</hd_model>";
		output+="</group>";
		output+="</harddisk>";
		print("Scanning network adapter..")
		output+="<networkadapter>";
		hwport=nacount=macadd=[]
		cmd=CONN+" networksetup -listallhardwareports | awk '/Hardware Port:/' | cut -d ':' -f 2"
		process=subprocess.Popen(CONN+" networksetup", stdout=subprocess.PIPE,shell=True,stderr=subprocess.PIPE)
		p1, _ = process.communicate()
		if process.returncode==0:
			p1=subprocess.Popen(cmd, stdout=subprocess.PIPE,shell=True)
			for line in p1.stdout:
				hwport=(line.decode("utf-8")).strip()
				statusnic, na_nic1 = getstatusoutput(CONN+" networksetup -listallhardwareports | awk '/Hardware Port: "+ hwport +"/{getline; print $2}'")
				na_nic1= na_nic1.strip();
				na_nic= na_nic1.strip()+" ("+ hwport+")";
				statusnic, na_mac = getstatusoutput(CONN+" networksetup -listallhardwareports | awk '/Device: "+ na_nic1 +"/{getline; print $3}'")
				na_mac = na_mac.strip();                
				status, na_ip = getstatusoutput(CONN+" ifconfig "+ na_nic1 +" | grep 'inet ' | awk -F' ' '{print $2}' | awk '{print $1}'")
				output+="<group><na_nic>"+ na_nic +"</na_nic>";
				output+="<na_ip>"+na_ip.strip()+"</na_ip>";
				output+="<na_subnet></na_subnet>";
				output+="<na_mac>"+na_mac.strip()+"</na_mac>";
				output+="<na_gateway>";
				#status, na_gateway = getstatusoutput(CONN+" route -n | grep 'UG[ \t]' | awk '{print $2}'")
				#output+=na_gateway;
				output+="</na_gateway>"
				output+="<na_dhcp></na_dhcp><na_dhcp_server></na_dhcp_server><na_network></na_network>";
				output+="</group>";   
		output+="</networkadapter>";
		output+="<software>"; 
		print("Scanning software..")
		statusinst, installedsw = getstatusoutput(CONN+" system_profiler SPApplicationsDataType ")
		softdata= installedsw.splitlines()
		softwarenames =[]
		for s in softdata:
			if s.endswith(":") :
				softwarenames.append(s) 
		for f in softwarenames:
			name=''
			desc=''
			version=''
			install_path=''
			install_dt=''
			soft_manufacturer=''
			res=f.split(':')
			name=res[0].strip()
			if name != 'Applications' : 
				index=softdata.index(f);
				appdata1=[]
				for x in range(0, 8):
					ind = index + x
					appdata1.append(softdata[ind])
							
				appdata1 =striplist(appdata1)
				arr=[ln for ln in appdata1 if ln.startswith("Version")]
				if type(arr) in (tuple, list) and len(arr)>0: 
					version = [ln for ln in appdata1 if ln.startswith("Version")][0].split(':')[1]
				
				arr=[ln for ln in appdata1 if ln.startswith("Location")]
				if type(arr) in (tuple, list) and len(arr)>0: 
					install_path = [ln for ln in appdata1 if ln.startswith("Location")][0].split(':')[1]
				
				arr=[ln for ln in appdata1 if ln.startswith("Last Modified")]
				if type(arr) in (tuple, list) and len(arr)>0: 
					install_dt = [ln for ln in appdata1 if ln.startswith("Last Modified")][0].split(':')[1]
					install_dt=install_dt.split(',')
					install_dt=install_dt[0].strip()
					install_dt= install_dt.split('/')
					install_dt=install_dt[2].strip()+"-"+install_dt[1].strip()+"-"+install_dt[0].strip()    

				
				arr=[ln for ln in appdata1 if ln.startswith("Obtained from")]
				if type(arr) in (tuple, list) and len(arr)>0: 
					soft_manufacturer = [ln for ln in appdata1 if ln.startswith("Obtained from")][0].split(':')[1]
			
				desc=''

				output+="<group><soft_name>"+name.strip()+"</soft_name><soft_description>"+desc.strip()+"</soft_description><license_expiry></license_expiry><install_date>"+install_dt.strip()+"</install_date><license_type></license_type><install_path>"+install_path.strip()+"</install_path><license_key></license_key><soft_cost></soft_cost><version>"+version.strip()+"</version><soft_type></soft_type><soft_cate></soft_cate><soft_manufacturer>"+soft_manufacturer.strip()+"</soft_manufacturer></group>";
		output+="</software>"; 
		output+="</row></resultset>";
		output=output.replace("&","and")
		print("Scanning completed")
		print("---------------------------------------------")
		return output;

	def generate_filename(self,CONN):
		global settingfilename;
		filename=''
		if os.path.exists(settingfilename):
			with open(settingfilename) as f:
				for line in f:
					filename=line.strip()
			if filename=='':
				status, hostname = getstatusoutput(CONN+" hostname")
				if status==0:
					ts = int(time.time())
					filename=hostname.strip()+str(ts)
					filename=filename.replace(' ','');
					filename=filename.replace('.','_');
					with open(settingfilename, 'w') as f:
						f.write(filename)
		else:
			status, hostname = getstatusoutput(CONN+" hostname")
			if status==0:
				ts = int(time.time())
				filename=hostname.strip()+str(ts)
				filename=filename.replace(' ','');
				filename=filename.replace('.','_');
				with open(settingfilename, 'w') as f:
					f.write(filename)
		filename=filename.replace(':', '')
		filename=filename.replace('.', '_')
		filename=filename.replace(' ', '')
		filename=filename.strip();
		return filename;
		
	def check_scan_request(self):
		global REGI_KEY,API_URL,LINKURL,VIS_STAFF_USERNAME,VIS_STAFF_PASSWORD,VIS_STAFF_ID,VIS_USEDBY_TYPE,VIS_DOMAIN_ID,settingfilename
		CONN=''
		filename=''
		if os.path.exists(settingfilename):
			with open(settingfilename) as f:
				for line in f:
					filename=line.strip()
		
		xmlfilename=filename.strip()
		if xmlfilename!='':
			api_url_base = API_URL+'&vis_module=cmdb&vis_operation=check_scan_request&xmlfilename='+xmlfilename+'&vis_domain_id='+VIS_DOMAIN_ID;
			headers = {'Content-Type': 'application/json','Authorization': 'Bearer {0}'}
			response = requests.get(api_url_base, headers=headers, verify=False)
			if response.status_code == 200:
					try:
						res=json.loads(response.content.decode('utf-8'))
						if res['res']=="1":
							self.self_scan();
						else:
							print('Not requested')
					except:
						print('Not requested')
			else:
				print('Not requested')
		else:
			print('Filename not found')
		return True;

	def set_cron(self,CONN):
		CONN='';
		print("---------------------------------------------")
		print("Setting cron jobs..")
		try:
			status, whoami = getstatusoutput(CONN+" whoami")
			whoami=whoami.strip();
			status, pythonpath = getstatusoutput(CONN+" which python3")
			pythonpath=pythonpath.strip();
			pypath=os.path.realpath(__file__)
			crondata='';
			xmlfilename=''
			filename=''
			if os.path.exists(settingfilename):
				with open(settingfilename) as f:
					for line in f:
						filename=line.strip()
						xmlfilename=filename.strip()
			cronfilenm='com.'+whoami+'.vhdreqcron_'+xmlfilename
			whereidplist='/Library/LaunchDaemons/'
			if os.path.exists(whereidplist+ cronfilenm+'.plist'):
				print("Set already : "+whereidplist+ cronfilenm+'.plist')
			else:
				crondata+='<?xml version="1.0" encoding="UTF-8"?><!DOCTYPE plist PUBLIC "-//Apple Computer//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd"> <plist version="1.0"><dict><key>Label</key><string>'+ cronfilenm +'</string><key>ProgramArguments</key><array><string>/usr/local/bin/python3</string><string>'+pypath+'</string><string> -a </string></array><key>StartInterval</key><integer>60</integer><key>StandardErrorPath</key><string>/tmp/vhdreqerr.log</string><key>StandardOutPath</key><string>/tmp/vhdreqout.log</string></dict></plist>'
				cronf= cronfilenm+'.plist'
				status, movefile = getstatusoutput(CONN+" launchctl unload "+ whereidplist+cronf)
				with open(BASE_DIR+'/'+cronf, 'w') as f:
					f.write(crondata)
				status, movefile = getstatusoutput(CONN+" cp -f "+BASE_DIR+"/"+cronf+" "+ whereidplist)
				status, movefile = getstatusoutput(CONN+" launchctl load "+ whereidplist+cronf)
				

			crondata='';
			cronfilenm='com.'+whoami+'.vhdscancron_'+xmlfilename
			if os.path.exists(whereidplist+ cronfilenm+'.plist'):
				print("Set already : "+whereidplist+ cronfilenm+'.plist')
			else:
				crondata+='<?xml version="1.0" encoding="UTF-8"?><!DOCTYPE plist PUBLIC "-//Apple Computer//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd"> <plist version="1.0"><dict><key>Label</key><string>'+ cronfilenm +'</string><key>ProgramArguments</key><array><string>/usr/local/bin/python3</string><string>'+pypath+'</string></array><key>StartInterval</key><integer>3600</integer><key>StandardErrorPath</key><string>/tmp/vhdscanerr.log</string><key>StandardOutPath</key><string>/tmp/vhdscanout.log</string></dict></plist>'
				cronf= cronfilenm+'.plist'
				status, movefile = getstatusoutput(CONN+" launchctl unload "+whereidplist+cronf)
				with open(BASE_DIR+'/'+cronf, 'w') as f:
					f.write(crondata)
				status, movefile = getstatusoutput(CONN+" cp -f "+BASE_DIR+"/"+cronf+" "+ whereidplist)
				status, movefile = getstatusoutput(CONN+" launchctl load "+ whereidplist + cronf)
			status, movefile = getstatusoutput(CONN+" launchctl load "+ whereidplist + 'com.'+whoami+'.vhdreqcron.plist')
			status, movefile = getstatusoutput(CONN+" launchctl load "+ whereidplist + 'com.'+whoami+'.vhdscancron.plist')
			
		except:
			print("")
		print("---------------------------------------------")
							
def encodepass(pwd):
	txtpass = pwd;
	manual_pass = "vhd" + txtpass + "dhv";
	manual_pass=''.join(reversed(manual_pass));
	Str = base64.b64encode(manual_pass.encode('utf-8',errors = 'strict'));
	vis_integratepassword=Str.decode('utf-8');
	return vis_integratepassword;

def getstatusoutput(command,rtype="1"):
	process=subprocess.Popen(command, stdout=subprocess.PIPE,shell=True,stderr=subprocess.PIPE)
	output, _ = process.communicate()
	if rtype=="1":
		return (process.returncode, output.decode('utf-8'))
	return (process.returncode, output)

def striplist(l):
    return([x.strip() for x in l])

def main():
	obj=Vision();
	arguments = sys.argv[1:]
	count = len(arguments)
	if count>0:
		if obj.get_data() :
			print("Authentication successful")
			if sys.argv[1].strip()=="-a": 
				print(datetime.datetime.now().strftime('%b %d, %G %I:%M%p') +" Checking scan request")
				obj.check_scan_request();
				status, whoami = getstatusoutput("whoami")
				whoami=whoami.strip();
				whereidplist='/Library/LaunchDaemons/'
				status, movefile = getstatusoutput(" launchctl load "+ whereidplist + 'com.'+whoami+'.vhdreqcron.plist')
				status, movefile = getstatusoutput(" launchctl load "+ whereidplist + 'com.'+whoami+'. vhdscancron.plist')
		else:
			print("Authentication failed")
	else:
		if obj.get_data():
			print("Authentication successful")
			obj.self_scan();
			status, whoami = getstatusoutput("whoami")
			whoami=whoami.strip();
			whereidplist='/Library/LaunchDaemons/'
			status, movefile = getstatusoutput(" launchctl load "+ whereidplist + 'com.'+whoami+'.vhdreqcron.plist')
			status, movefile = getstatusoutput(" launchctl load "+ whereidplist + 'com.'+whoami+'. vhdscancron.plist')
		else:
			print("Authentication failed")
		
if __name__ == "__main__":
	sys.exit(main())
