<?php

class PHPExcel_Writer_Excel5_Font
{
    private $colorIndex;

    private $font;

    public function __construct(PHPExcel_Style_Font $font = null)
    {
        $this->colorIndex = 0x7FFF;
        $this->font = $font;
    }

    public function setColorIndex($colorIndex)
    {
        $this->colorIndex = $colorIndex;
    }

    public function writeFont()
    {
        $font_outline = 0;
        $font_shadow = 0;

        $icv = $this->colorIndex; // Index to color palette
        if ($this->font->getSuperScript()) {
            $sss = 1;
        } elseif ($this->font->getSubScript()) {
            $sss = 2;
        } else {
            $sss = 0;
        }
        $bFamily = 0; // Font family
        $bCharSet = PHPExcel_Shared_Font::getCharsetFromFontName($this->font->getName()); // Character set

        $record = 0x31;        // Record identifier
        $reserved = 0x00;    // Reserved
        $grbit = 0x00;        // Font attributes
        if ($this->font->getItalic()) {
            $grbit |= 0x02;
        }
        if ($this->font->getStrikethrough()) {
            $grbit |= 0x08;
        }
        if ($font_outline) {
            $grbit |= 0x10;
        }
        if ($font_shadow) {
            $grbit |= 0x20;
        }

        $data = pack(
            "vvvvvCCCC",
            $this->font->getSize() * 20,
            $grbit,
            $icv,
            self::mapBold($this->font->getBold()),
            $sss,
            self::mapUnderline($this->font->getUnderline()),
            $bFamily,
            $bCharSet,
            $reserved
        );
        $data .= PHPExcel_Shared_String::UTF8toBIFF8UnicodeShort($this->font->getName());

        $length = strlen($data);
        $header = pack("vv", $record, $length);

        return($header . $data);
    }

    private static function mapBold($bold)
    {
        if ($bold) {
            return 0x2BC;  //  700 = Bold font weight
        }
        return 0x190;      //  400 = Normal font weight
    }

    private static $mapUnderline = array(
        PHPExcel_Style_Font::UNDERLINE_NONE              => 0x00,
        PHPExcel_Style_Font::UNDERLINE_SINGLE            => 0x01,
        PHPExcel_Style_Font::UNDERLINE_DOUBLE            => 0x02,
        PHPExcel_Style_Font::UNDERLINE_SINGLEACCOUNTING  => 0x21,
        PHPExcel_Style_Font::UNDERLINE_DOUBLEACCOUNTING  => 0x22,
    );

    private static function mapUnderline($underline)
    {
        if (isset(self::$mapUnderline[$underline])) {
            return self::$mapUnderline[$underline];
        }
        return 0x00;
    }
}
