$(function () {
    var device;

    log("Requesting Access Token...");
    // Using a relative link to access the Voice Token function
    $.getJSON("../plugins/twilio/twilionewclient/token.php?key="+twiliokey+'"')
        .then(function (data) {
            log("Got a token.");
            console.log("Token: " + data.token);

            // Setup Twilio.Device
            device = new Twilio.Device(data.token, {
                // Set Opus as our preferred codec. Opus generally performs better, requiring less bandwidth and
                // providing better audio quality in restrained network conditions. Opus will be default in 2.0.
                codecPreferences: ["opus", "pcmu"],
                // Use fake DTMF tones client-side. Real tones are still sent to the other end of the call,
                // but the client-side DTMF tones are fake. This prevents the local mic capturing the DTMF tone
                // a second time and sending the tone twice. This will be default in 2.0.
                fakeLocalDTMF: true,
                // Use `enableRingingState` to enable the device to emit the `ringing`
                // state. The TwiML backend also needs to have the attribute
                // `answerOnBridge` also set to true in the `Dial` verb. This option
                // changes the behavior of the SDK to consider a call `ringing` starting
                // from the connection to the TwiML backend to when the recipient of
                // the `Dial` verb answers.
                enableRingingState: true,
                debug: false,
            });

            device.on("ready", function (device) {
                log("Twilio.Device Ready!");
                document.getElementById('call-controls').style.display = 'block';
            });

            device.on("error", function (error) {
                log("Twilio.Device Error: " + error.message);
            });


            /*device.on("incoming", function (conn) {
                console.log(conn.parameters)
                log("Incoming connection from " + conn.parameters.From);
                $("#callerNumber").text(conn.parameters.From)
                $("#txtPhoneNumber").text(conn.parameters.From)

                $('#modal-incomming-call').modal('show')

                $('.btnReject').bind('click', function () {
                    $('.modal').modal('hide')
                    log("Rejected call ...");
                    conn.reject();
                })

                $('.btnAcceptCall').bind('click', function () {
                    $('.modal').modal('hide')
                    log("Accepted call ...");
                    conn.accept();
                })

            });*/

                $('#button-call').bind('click', function () {
                    var params = {
                          To: document.getElementById('phone-number').value,
                          From: document.getElementById('vis_twilio_number').value,
                           Direction: 'outbound-api'
                        };
                     console.log('Calling ' + params.To + '...');  
                        console.log('Calling from ' + params.From + '...'); 
                     var outcon = device.connect({params,rtcConstraints: { audio: { deviceId: 'default' } },}); 
                        document.getElementById('button-call').style.display = 'none';
                document.getElementById('button-hangup').style.display = 'inline'; 
                })
            $('#button-hangup').bind('click', function () {
                    log('Hanging up...');
                    device.disconnectAll();
                    location.reload();
                })
        device.on("connect", function (conn) {
                log('Successfully established call ! ');
                document.getElementById('button-call').style.display = 'none';
                document.getElementById('button-hangup').style.display = 'inline';
            });

            device.on("disconnect", function (conn) {
                log("Call ended.");
                document.getElementById('button-call').style.display = 'inline';
                document.getElementById('button-hangup').style.display = 'none';
                location.reload();
            });

        })
        .fail(function (err) {
            console.log(err);
            log("Could not get a token from server!");
        });

    // Bind button to make call
    // Bind button to make call
  /*document.getElementById('button-call').onclick = function () {
    // get the phone number to connect the call to
    var params = {
      To: document.getElementById('phone-number').value,
      From: document.getElementById('vis_twilio_number').value,
       Direction: 'outbound-api'
    };

    console.log('Calling ' + params.To + '...');
    Twilio.Device.connect(params);
  };

  // Bind button to hangup call
  document.getElementById('button-hangup').onclick = function () {
    log('Hanging up...');
    Twilio.Device.disconnectAll();
    location.reload();
  };*/

    // Activity log
    function log(message) {
        console.log("Visionlog: -"+message);
        //var logDiv = document.getElementById("log");
        //logDiv.innerHTML += "<p>&gt;&nbsp;" + message + "</p>";
        //logDiv.scrollTop = logDiv.scrollHeight;
    }

});
