<?php
include('./vendor/autoload.php');
include('./config.php');

use Twilio\Twiml;

$response = new Twiml;

// get the phone number from the page request parameters, if given
if (isset($_REQUEST['To']) && strlen($_REQUEST['To']) > 0) {
    $number = htmlspecialchars($_REQUEST['To']);
    $dial = $response->dial(array('callerId' => $TWILIO_CALLER_ID));
    
    // wrap the phone number or client name in the appropriate TwiML verb
    // by checking if the number given has only digits and format symbols
    if (preg_match("/^[\d\+\-\(\) ]+$/", $number)) {
        $dial->number($number);
    } else {
        $dial->client($number);
    }
} else {
    $response->say("Thanks for calling!");
}

header('Content-Type: text/xml');
echo $response;
$time = date('Y-d-m h:i:s')."_".time();
//mail("amolvision@outlook.com","twilio client demo".$time,base64_encode($response));
