<?php
/**
 * Represents one or more cards of content.
 * Uses siteCardBlockType to store settings of individual cards.
 */
class siteMenuT1BlockType extends siteBlockType
{
    public $elements = [   
        'main' => 'site-block-menu',
        'wrapper' => 'site-block-menu-wrapper',
        ];

    public function __construct(array $options=[])
    {
        $options['type'] = 'site.Menu.';
        parent::__construct($options);
    }

    public function getExampleBlockData()
    {
        $hseq = (new siteVerticalSequenceBlockType())->getEmptyBlockData();
        $hseq->data['is_horizontal'] = true;
        $hseq->data['is_complex'] = 'only_columns';
        $hseq->data['indestructible'] = true;
        
        //$column_count = ifset($this->options, 'columns', 2);

        $columns_arr = array();
        $logo_column = (new siteMenuLogoT1BlockType())->getExampleBlockData();
        $logo_column->data['column'] = 'st-8-mb st-6-tb st-4 st-4-lp';
        
        $contacts_column = (new siteMenuContactsT1BlockType())->getExampleBlockData();
        $contacts_column->data['column'] = "st-4-mb st-6-tb st-8 st-8-lp";

        $burger_contacts_column = (new siteMenuContactsT1BlockType(['is_burger_column' => true]))->getExampleBlockData();
        $burger_contacts_column->data['column'] = "st-12-tb st-12-mb st-0-lp st-0";

        $hseq->addChild($logo_column, 'col1');
        $hseq->addChild($contacts_column, 'col2');
        $hseq->addChild($burger_contacts_column, 'col3');

        $result = $this->getEmptyBlockData();
        $result->addChild($hseq, '');

        $column_props = array();
        $column_props[$this->elements['main']] = ['padding-top' => "p-t-0", 'padding-bottom' => "p-b-0", 'padding-left' => "p-l-blc", 'padding-right' => "p-r-blc"];
        $column_props[$this->elements['wrapper']] = ['padding-top' => "p-t-10", 'padding-bottom' => "p-b-10", 'flex-align-vertical' => "x-c", 'max-width' => "cnt"];

        $result->data = ['block_props' => $column_props, 'wrapper_props' => ['justify-align' => "y-j-cnt", 'flex-align-vertical' => "x-c"]];
        //$result->data['columns'] = $columns_arr;
        $result->data['elements'] = $this->elements;
       
        $app_template_prop = array();
        $app_template_prop['disabled'] = false;
        $app_template_prop['active'] = false;

        $result->data['app_template'] = $app_template_prop;
        $result->data['assets'] = [
            'css' => '[data-column-class]:has(#bitms){display:none;}#itms svg{cursor:pointer;}.menublc-expanded{height:100dvh;background-color:var(--white));}',
            'js' => "const menublc = document.querySelector('.site-block-menu:has(#bitms)');
            const bmenu = document.querySelector('[data-column-class]:has(#bitms)');
            const icn_bar = document.querySelector('#icn-bar');
            const icn_cls = document.querySelector('#icn-cls');
            document.querySelectorAll('#itms svg').forEach(function(item){
                item.addEventListener('click', function(){ 
            const is_bmenu_hidden = bmenu.style.display === 'none'; 
            bmenu.style.display = (is_bmenu_hidden ? 'inherit' : 'none'); 
            menublc.classList.toggle('menublc-expanded', is_bmenu_hidden);
            icn_bar.classList.toggle('d-n', is_bmenu_hidden);
            icn_cls.classList.toggle('d-n', !is_bmenu_hidden);
            });
            });",
        ];

        return $result;
    }

    public function render(siteBlockData $data, bool $is_backend, array $tmpl_vars=[])
    {
        return parent::render($data, $is_backend, $tmpl_vars + [
            'children' => array_reduce($data->getRenderedChildren($is_backend), 'array_merge', []),
        ]);
    }

    public function getRawBlockSettingsFormConfig()
    {
        return [
            'type_name' => _w('Block'),
            'type_name_original' => _w('Menu'),
            'sections' => [
                [   'type' => 'MenuToggleGroup',
                    'name' => _w('Menu toggle'),
                ],
                [   'type' => 'ColumnsGroup',
                    'name' => _w('Columns'),
                ],
                [   'type' => 'ColumnsAlignVerticalGroup',
                    'name' => _w('Vertical alignment'),
                ],
                [   'type' => 'MenuDecorationGroup',
                    'name' => _w('Decoration'),
                ],
                [  'type' => 'TabsWrapperGroup',
                    'name' => _w('Tabs'),
                ],
                [   'type' => 'MaxWidthToggleGroup',
                    'name' => _w('Max width'),
                ],
                [   'type' => 'BackgroundColorGroup',
                    'name' => _w('Background'),
                ],
                [   'type' => 'PaddingGroup',
                    'name' => _w('Padding'),
                ],
                [   'type' => 'MarginGroup',
                    'name' => _w('Margin'),
                ],
                [   'type' => 'BorderGroup',
                    'name' => _w('Border'),
                ],
                [   'type' => 'BorderRadiusGroup',
                    'name' => _w('Angle'),
                ],
                [   'type' => 'ShadowsGroup',
                    'name' => _w('Shadows'),
                ],
                [   'type' => 'IdGroup',
                    'name' => _w('Identifier (ID)'),
                ],
            ],
            'elements' => $this->elements,
            'semi_headers' => [
                'main' => _w('Whole block'),
                'wrapper' => _w('Container'),
            ]
        ] + parent::getRawBlockSettingsFormConfig();
    }

        /**
     * Создаёт ряд
     *
     * @param array $props
     * @param array $content
     * @return siteBlockData
     */
    public function createRow(array $props, array $content): siteBlockData {
        $row = (new siteRowBlockType())->getExampleBlockData();
        $row->data['block_props'] = $props['block_props'] ?? [];
        $row->data['wrapper_props'] = $props['wrapper_props'] ?? [];
        $row->data['inline_props'] = $props['inline_props'] ?? [];
        $row->data['id'] = $props['id'] ?? '';

        $hseq = reset($row->children['']);

        foreach ($content as $item) {
            $hseq->addChild($item);
        }

        return $row;
    }


    /**
     * Создаёт подколонку
     *
     * @param array $params
     * @param array $content
     * @return siteBlockData
     */
    public function createSubColumn(array $params, $content): siteBlockData {
        $sub_column = (new siteSubColumnBlockType())->getExampleBlockData();
        $sub_column->data['block_props'] = $params['block_props'] ?? [];
        $sub_column->data['wrapper_props'] = $params['wrapper_props'] ?? [];
        $sub_column->data['inline_props'] = $params['inline_props'] ?? [];
        $sub_column->data['id'] = $params['id'] ?? '';

        $vseq = reset($sub_column->children['']);
 
         foreach ($content as $item) {
            $vseq->addChild($item);
        }

        return $sub_column;
    }
}
