
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `webmail982`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]adav_addressbookchanges`
--

CREATE TABLE `[[dbprefix]]adav_addressbookchanges` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uri` varbinary(255) NOT NULL,
  `synctoken` int(11) unsigned NOT NULL,
  `addressbookid` int(11) unsigned NOT NULL,
  `operation` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `addressbookid_synctoken` (`addressbookid`,`synctoken`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]adav_addressbooks`
--

CREATE TABLE `[[dbprefix]]adav_addressbooks` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `principaluri` varbinary(255) DEFAULT NULL,
  `displayname` varchar(255) DEFAULT NULL,
  `uri` varbinary(255) DEFAULT NULL,
  `description` text,
  `synctoken` int(11) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `principaluri` (`principaluri`(100),`uri`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]adav_cache`
--

CREATE TABLE `[[dbprefix]]adav_cache` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(255) DEFAULT NULL,
  `calendaruri` varchar(255) DEFAULT NULL,
  `type` tinyint(4) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `starttime` int(11) DEFAULT NULL,
  `eventid` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]adav_calendarchanges`
--

CREATE TABLE `[[dbprefix]]adav_calendarchanges` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uri` varbinary(255) NOT NULL,
  `synctoken` int(11) unsigned NOT NULL,
  `calendarid` int(11) unsigned NOT NULL,
  `operation` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `calendarid_synctoken` (`calendarid`,`synctoken`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]adav_calendarinstances`
--

CREATE TABLE `[[dbprefix]]adav_calendarinstances` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `calendarid` int(10) unsigned NOT NULL,
  `principaluri` varbinary(100) DEFAULT NULL,
  `access` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1 = owner, 2 = read, 3 = readwrite',
  `displayname` varchar(100) DEFAULT NULL,
  `uri` varbinary(255) DEFAULT NULL,
  `description` text,
  `calendarorder` int(11) unsigned NOT NULL DEFAULT '0',
  `calendarcolor` varbinary(10) DEFAULT NULL,
  `timezone` text,
  `transparent` tinyint(1) NOT NULL DEFAULT '0',
  `share_href` varbinary(100) DEFAULT NULL,
  `share_displayname` varchar(100) DEFAULT NULL,
  `share_invitestatus` tinyint(1) NOT NULL DEFAULT '2' COMMENT '1 = noresponse, 2 = accepted, 3 = declined, 4 = invalid',
  `public` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `principaluri` (`principaluri`,`uri`),
  UNIQUE KEY `calendarid` (`calendarid`,`principaluri`),
  UNIQUE KEY `calendarid_2` (`calendarid`,`share_href`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]adav_calendarobjects`
--

CREATE TABLE `[[dbprefix]]adav_calendarobjects` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `calendardata` mediumblob,
  `uri` varbinary(255) DEFAULT NULL,
  `calendarid` int(10) unsigned NOT NULL,
  `lastmodified` int(11) unsigned DEFAULT NULL,
  `etag` varbinary(32) DEFAULT NULL,
  `size` int(11) unsigned NOT NULL,
  `componenttype` varbinary(8) DEFAULT NULL,
  `firstoccurence` int(11) unsigned DEFAULT NULL,
  `lastoccurence` int(11) unsigned DEFAULT NULL,
  `uid` varbinary(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `calendarid` (`calendarid`,`uri`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]adav_calendars`
--

CREATE TABLE `[[dbprefix]]adav_calendars` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `synctoken` int(10) unsigned NOT NULL DEFAULT '1',
  `components` varbinary(21) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]adav_calendarsubscriptions`
--

CREATE TABLE `[[dbprefix]]adav_calendarsubscriptions` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uri` varbinary(255) NOT NULL,
  `principaluri` varbinary(100) NOT NULL,
  `source` text,
  `displayname` varchar(100) DEFAULT NULL,
  `refreshrate` varchar(10) DEFAULT NULL,
  `calendarorder` int(11) unsigned NOT NULL DEFAULT '0',
  `calendarcolor` varbinary(10) DEFAULT NULL,
  `striptodos` tinyint(1) DEFAULT NULL,
  `stripalarms` tinyint(1) DEFAULT NULL,
  `stripattachments` tinyint(1) DEFAULT NULL,
  `lastmodified` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `principaluri` (`principaluri`,`uri`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]adav_cards`
--

CREATE TABLE `[[dbprefix]]adav_cards` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `addressbookid` int(11) unsigned NOT NULL,
  `carddata` mediumblob,
  `uri` varbinary(255) DEFAULT NULL,
  `lastmodified` int(11) unsigned DEFAULT NULL,
  `etag` varbinary(32) DEFAULT NULL,
  `size` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `addressbookid_index` (`addressbookid`),
  KEY `lastmodified_index` (`lastmodified`),
  KEY `uri_index` (`uri`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]adav_groupmembers`
--

CREATE TABLE `[[dbprefix]]adav_groupmembers` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `principal_id` int(11) unsigned NOT NULL,
  `member_id` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]ADAV_GROUPMEMBERS_MEMBER_ID_PRINCIPAL_ID_INDEX` (`principal_id`,`member_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]adav_locks`
--

CREATE TABLE `[[dbprefix]]adav_locks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner` varchar(100) DEFAULT NULL,
  `timeout` int(10) unsigned DEFAULT NULL,
  `created` int(11) DEFAULT NULL,
  `token` varbinary(100) DEFAULT NULL,
  `scope` tinyint(4) DEFAULT NULL,
  `depth` tinyint(4) DEFAULT NULL,
  `uri` varbinary(1000) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `token` (`token`),
  KEY `uri` (`uri`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]adav_propertystorage`
--

CREATE TABLE `[[dbprefix]]adav_propertystorage` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `path` varbinary(1024) NOT NULL,
  `name` varbinary(100) NOT NULL,
  `valuetype` int(10) unsigned DEFAULT NULL,
  `value` mediumblob,
  PRIMARY KEY (`id`),
  UNIQUE KEY `path_property` (`path`(600),`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]adav_reminders`
--

CREATE TABLE `[[dbprefix]]adav_reminders` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user` varchar(100) NOT NULL,
  `calendaruri` varchar(255) DEFAULT NULL,
  `eventid` varchar(255) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `starttime` int(11) DEFAULT NULL,
  `allday` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]adav_schedulingobjects`
--

CREATE TABLE `[[dbprefix]]adav_schedulingobjects` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `principaluri` varbinary(255) DEFAULT NULL,
  `calendardata` mediumblob,
  `uri` varbinary(255) DEFAULT NULL,
  `lastmodified` int(11) unsigned DEFAULT NULL,
  `etag` varbinary(32) DEFAULT NULL,
  `size` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contacts`
--

CREATE TABLE `[[dbprefix]]contacts` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `UUID` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `IdUser` int(11) NOT NULL DEFAULT '0',
  `IdTenant` int(11) NOT NULL DEFAULT '0',
  `Storage` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `AddressBookId` int(11) DEFAULT NULL,
  `FullName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `UseFriendlyName` tinyint(1) NOT NULL DEFAULT '1',
  `PrimaryEmail` int(11) NOT NULL DEFAULT '0',
  `PrimaryPhone` int(11) NOT NULL DEFAULT '1',
  `PrimaryAddress` int(11) NOT NULL DEFAULT '0',
  `ViewEmail` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `FirstName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `LastName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `NickName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Skype` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Facebook` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `PersonalEmail` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `PersonalAddress` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `PersonalCity` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `PersonalState` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `PersonalZip` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `PersonalCountry` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `PersonalWeb` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `PersonalFax` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `PersonalPhone` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `PersonalMobile` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `BusinessEmail` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `BusinessCompany` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `BusinessAddress` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `BusinessCity` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `BusinessState` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `BusinessZip` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `BusinessCountry` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `BusinessJobTitle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `BusinessDepartment` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `BusinessOffice` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `BusinessPhone` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `BusinessFax` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `BusinessWeb` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `OtherEmail` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Notes` text COLLATE utf8mb4_unicode_ci,
  `BirthDay` int(11) NOT NULL DEFAULT '0',
  `BirthMonth` int(11) NOT NULL DEFAULT '0',
  `BirthYear` int(11) NOT NULL DEFAULT '0',
  `ETag` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Auto` tinyint(1) NOT NULL DEFAULT '0',
  `Frequency` int(11) NOT NULL DEFAULT '0',
  `DateModified` datetime DEFAULT NULL,
  `Properties` json DEFAULT NULL,
  `CreatedAt` timestamp NULL DEFAULT NULL,
  `UpdatedAt` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `contacts_iduser_index` (`IdUser`),
  KEY `contacts_idtenant_index` (`IdTenant`),
  KEY `contacts_uuid_index` (`UUID`),
  KEY `contacts_storage_index` (`Storage`),
  KEY `contacts_frequency_index` (`Frequency`),
  FULLTEXT KEY `contacts_fullname_index` (`FullName`),
  FULLTEXT KEY `contacts_viewemail_index` (`ViewEmail`),
  FULLTEXT KEY `contacts_personalemail_index` (`PersonalEmail`),
  FULLTEXT KEY `contacts_businessemail_index` (`BusinessEmail`),
  FULLTEXT KEY `contacts_businesscompany_index` (`BusinessCompany`),
  FULLTEXT KEY `contacts_otheremail_index` (`OtherEmail`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contacts_addressbooks`
--

CREATE TABLE `[[dbprefix]]contacts_addressbooks` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `UUID` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `UserId` int(11) NOT NULL DEFAULT '0',
  `Name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `CreatedAt` timestamp NULL DEFAULT NULL,
  `UpdatedAt` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `contacts_addressbooks_userid_index` (`UserId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contacts_cards`
--

CREATE TABLE `[[dbprefix]]contacts_cards` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `CardId` int(11) NOT NULL DEFAULT '0',
  `AddressBookId` int(11) NOT NULL DEFAULT '0',
  `FullName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `PrimaryEmail` int(11) NOT NULL DEFAULT '0',
  `ViewEmail` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `FirstName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `LastName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `PersonalEmail` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `BusinessEmail` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `OtherEmail` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `BusinessCompany` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Frequency` int(11) NOT NULL DEFAULT '0',
  `IsGroup` tinyint(1) NOT NULL DEFAULT '0',
  `Properties` json DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `contacts_cards_cardid_index` (`CardId`),
  KEY `contacts_cards_addressbookid_index` (`AddressBookId`),
  KEY `contacts_cards_isgroup_index` (`IsGroup`),
  KEY `contacts_cards_frequency_index` (`Frequency`),
  FULLTEXT KEY `contacts_cards_fullname_index` (`FullName`),
  FULLTEXT KEY `contacts_cards_viewemail_index` (`ViewEmail`),
  FULLTEXT KEY `contacts_cards_personalemail_index` (`PersonalEmail`),
  FULLTEXT KEY `contacts_cards_businessemail_index` (`BusinessEmail`),
  FULLTEXT KEY `contacts_cards_businesscompany_index` (`BusinessCompany`),
  FULLTEXT KEY `contacts_cards_otheremail_index` (`OtherEmail`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contacts_ctags`
--

CREATE TABLE `[[dbprefix]]contacts_ctags` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `UserId` int(11) NOT NULL DEFAULT '0',
  `Storage` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `CTag` int(11) NOT NULL DEFAULT '0',
  `CreatedAt` timestamp NULL DEFAULT NULL,
  `UpdatedAt` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `contacts_ctags_userid_index` (`UserId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contacts_groups`
--

CREATE TABLE `[[dbprefix]]contacts_groups` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `UUID` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `IdUser` int(11) NOT NULL DEFAULT '0',
  `Name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `IsOrganization` tinyint(1) NOT NULL DEFAULT '0',
  `Email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Company` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Street` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `City` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `State` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Zip` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Country` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Phone` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Fax` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Web` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Events` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Properties` json DEFAULT NULL,
  `CreatedAt` timestamp NULL DEFAULT NULL,
  `UpdatedAt` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `contacts_groups_iduser_index` (`IdUser`),
  FULLTEXT KEY `contacts_groups_name_index` (`Name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contacts_group_contact`
--

CREATE TABLE `[[dbprefix]]contacts_group_contact` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `GroupId` int(10) unsigned NOT NULL,
  `ContactId` int(10) unsigned NOT NULL,
  PRIMARY KEY (`Id`),
  KEY `contacts_group_contact_groupid_index` (`GroupId`),
  KEY `contacts_group_contact_contactid_index` (`ContactId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contacts_group_events`
--

CREATE TABLE `[[dbprefix]]contacts_group_events` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `GroupUUID` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `CalendarUUID` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `EventUUID` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `CreatedAt` timestamp NULL DEFAULT NULL,
  `UpdatedAt` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]core_auth_tokens`
--

CREATE TABLE `[[dbprefix]]core_auth_tokens` (
  `Id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `UserId` int(11) NOT NULL DEFAULT '0',
  `AccountId` int(11) DEFAULT NULL,
  `AccountType` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Token` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `LastUsageDateTime` int(11) NOT NULL DEFAULT '0',
  `CreatedAt` timestamp NULL DEFAULT NULL,
  `UpdatedAt` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `core_auth_tokens_userid_index` (`UserId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]core_channels`
--

CREATE TABLE `[[dbprefix]]core_channels` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Login` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Properties` json DEFAULT NULL,
  `CreatedAt` timestamp NULL DEFAULT NULL,
  `UpdatedAt` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]core_channels`
--

INSERT INTO `[[dbprefix]]core_channels` VALUES
(1, 'Default', '', '', NULL, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]core_groups`
--

CREATE TABLE `[[dbprefix]]core_groups` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TenantId` int(11) NOT NULL DEFAULT '0',
  `Name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Properties` json DEFAULT NULL,
  `CreatedAt` timestamp NULL DEFAULT NULL,
  `UpdatedAt` timestamp NULL DEFAULT NULL,
  `IsAll` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`Id`),
  KEY `core_groups_tenantid_index` (`TenantId`),
  FULLTEXT KEY `ccore_groups_name_index` (`Name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]core_group_user`
--

CREATE TABLE `[[dbprefix]]core_group_user` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `GroupId` int(10) unsigned NOT NULL,
  `UserId` int(10) unsigned NOT NULL,
  PRIMARY KEY (`Id`),
  KEY `core_group_user_groupid_index` (`GroupId`),
  KEY `core_group_user_userid_index` (`UserId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]core_min_hashes`
--

CREATE TABLE `[[dbprefix]]core_min_hashes` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `HashId` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `UserId` bigint(20) DEFAULT NULL,
  `Hash` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `ExpireDate` int(11) DEFAULT '0',
  `CreatedAt` timestamp NULL DEFAULT NULL,
  `UpdatedAt` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `min_hash_index` (`Hash`),
  KEY `core_min_hashes_userid_index` (`UserId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]core_tenants`
--

CREATE TABLE `[[dbprefix]]core_tenants` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IdChannel` int(11) NOT NULL DEFAULT '0',
  `IsDisabled` tinyint(1) NOT NULL DEFAULT '0',
  `IsDefault` tinyint(1) NOT NULL DEFAULT '0',
  `Name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `WebDomain` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `UserCountLimit` int(11) NOT NULL DEFAULT '0',
  `Capa` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `AllowChangeAdminEmail` tinyint(1) NOT NULL DEFAULT '1',
  `AllowChangeAdminPassword` tinyint(1) NOT NULL DEFAULT '1',
  `Expared` int(11) NOT NULL DEFAULT '0',
  `PayUrl` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `IsTrial` tinyint(1) NOT NULL DEFAULT '0',
  `LogoUrl` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `CalendarNotificationEmailAccount` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `InviteNotificationEmailAccount` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Properties` json DEFAULT NULL,
  `CreatedAt` timestamp NULL DEFAULT NULL,
  `UpdatedAt` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`Id`),
  FULLTEXT KEY `ccore_tenants_name_index` (`Name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]core_tenants`
--

INSERT INTO `[[dbprefix]]core_tenants` VALUES
(1, 1, 0, 1, 'Default', '', '', 0, '', 1, 1, 0, '', 0, '', '', '', NULL, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]core_users`
--

CREATE TABLE `[[dbprefix]]core_users` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `UUID` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `PublicId` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `IdTenant` int(11) NOT NULL DEFAULT '0',
  `IsDisabled` tinyint(1) NOT NULL DEFAULT '0',
  `IdSubscription` int(11) NOT NULL DEFAULT '0',
  `Role` int(11) NOT NULL DEFAULT '2',
  `LastLogin` datetime DEFAULT NULL,
  `LastLoginNow` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `LoginsCount` int(11) NOT NULL DEFAULT '0',
  `Note` text COLLATE utf8mb4_unicode_ci,
  `Language` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `TimeFormat` int(11) NOT NULL DEFAULT '1',
  `DateFormat` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Question1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Question2` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Answer1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Answer2` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `SipEnable` tinyint(1) NOT NULL DEFAULT '1',
  `SipImpi` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `SipPassword` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `DesktopNotifications` tinyint(1) NOT NULL DEFAULT '0',
  `Capa` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `CustomFields` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `FilesEnable` tinyint(1) NOT NULL DEFAULT '1',
  `EmailNotification` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `PasswordResetHash` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `WriteSeparateLog` tinyint(1) NOT NULL DEFAULT '0',
  `TokensValidFromTimestamp` int(11) NOT NULL DEFAULT '0',
  `DefaultTimeZone` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Properties` json DEFAULT NULL,
  `CreatedAt` timestamp NULL DEFAULT NULL,
  `UpdatedAt` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`Id`),
  UNIQUE KEY `core_users_publicid_unique` (`PublicId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]core_user_blocks`
--

CREATE TABLE `[[dbprefix]]core_user_blocks` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `UserId` int(11) DEFAULT NULL,
  `Email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `IpAddress` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ErrorLoginsCount` int(11) NOT NULL DEFAULT '0',
  `Time` int(11) NOT NULL DEFAULT '0',
  `CreatedAt` timestamp NULL DEFAULT NULL,
  `UpdatedAt` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cpanel_aliases`
--

CREATE TABLE `[[dbprefix]]cpanel_aliases` (
  `Id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `IdUser` int(11) NOT NULL DEFAULT '0',
  `IdAccount` int(11) NOT NULL DEFAULT '0',
  `Email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ForwardTo` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `FriendlyName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `UseSignature` tinyint(1) NOT NULL DEFAULT '0',
  `Signature` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `CreatedAt` timestamp NULL DEFAULT NULL,
  `UpdatedAt` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mail_accounts`
--

CREATE TABLE `[[dbprefix]]mail_accounts` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IsDisabled` tinyint(1) NOT NULL DEFAULT '0',
  `IdUser` int(11) NOT NULL DEFAULT '0',
  `UseToAuthorize` tinyint(1) NOT NULL DEFAULT '0',
  `Email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `FriendlyName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `IncomingLogin` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `IncomingPassword` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `IncludeInUnifiedMailbox` tinyint(1) NOT NULL DEFAULT '0',
  `UseSignature` tinyint(1) NOT NULL DEFAULT '0',
  `Signature` mediumblob,
  `ServerId` int(10) unsigned NOT NULL DEFAULT '0',
  `FoldersOrder` mediumblob,
  `UseThreading` tinyint(1) NOT NULL DEFAULT '0',
  `SaveRepliesToCurrFolder` tinyint(1) NOT NULL DEFAULT '0',
  `ShowUnifiedMailboxLabel` tinyint(1) NOT NULL DEFAULT '0',
  `UnifiedMailboxLabelText` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `UnifiedMailboxLabelColor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `XOAuth` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `CreatedAt` timestamp NULL DEFAULT NULL,
  `UpdatedAt` timestamp NULL DEFAULT NULL,
  `Properties` json DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `mail_accounts_serverid_foreign` (`ServerId`),
  KEY `mail_accounts_iduser_index` (`IdUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mail_identities`
--

CREATE TABLE `[[dbprefix]]mail_identities` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IdUser` int(11) NOT NULL DEFAULT '0',
  `IdAccount` int(11) NOT NULL DEFAULT '0',
  `Default` tinyint(1) NOT NULL DEFAULT '0',
  `Email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `FriendlyName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `UseSignature` tinyint(1) NOT NULL DEFAULT '0',
  `Signature` mediumblob,
  `CreatedAt` timestamp NULL DEFAULT NULL,
  `UpdatedAt` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `mail_identities_iduser_index` (`IdUser`),
  KEY `mail_identities_idaccount_index` (`IdAccount`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mail_refresh_folders`
--

CREATE TABLE `[[dbprefix]]mail_refresh_folders` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IdAccount` int(11) NOT NULL DEFAULT '0',
  `FolderFullName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `AlwaysRefresh` tinyint(1) NOT NULL DEFAULT '0',
  `CreatedAt` timestamp NULL DEFAULT NULL,
  `UpdatedAt` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `mail_refresh_folders_idaccount_index` (`IdAccount`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mail_servers`
--

CREATE TABLE `[[dbprefix]]mail_servers` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TenantId` int(11) NOT NULL DEFAULT '0',
  `Name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `IncomingServer` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `IncomingPort` int(11) NOT NULL DEFAULT '143',
  `IncomingUseSsl` tinyint(1) NOT NULL DEFAULT '0',
  `OutgoingServer` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `OutgoingPort` int(11) NOT NULL DEFAULT '25',
  `OutgoingUseSsl` tinyint(1) NOT NULL DEFAULT '0',
  `SmtpAuthType` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `SmtpLogin` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `SmtpPassword` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `OwnerType` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'account',
  `Domains` text COLLATE utf8mb4_unicode_ci,
  `EnableSieve` tinyint(1) NOT NULL DEFAULT '0',
  `SievePort` int(11) NOT NULL DEFAULT '4190',
  `EnableThreading` tinyint(1) NOT NULL DEFAULT '1',
  `UseFullEmailAddressAsLogin` tinyint(1) NOT NULL DEFAULT '1',
  `SetExternalAccessServers` tinyint(1) NOT NULL DEFAULT '0',
  `ExternalAccessImapServer` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ExternalAccessImapPort` int(11) NOT NULL DEFAULT '143',
  `ExternalAccessImapAlterPort` int(11) NOT NULL DEFAULT '0',
  `ExternalAccessSmtpServer` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ExternalAccessSmtpPort` int(11) NOT NULL DEFAULT '25',
  `ExternalAccessSmtpAlterPort` int(11) NOT NULL DEFAULT '0',
  `ExternalAccessPop3Server` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ExternalAccessPop3Port` int(11) NOT NULL DEFAULT '110',
  `ExternalAccessPop3AlterPort` int(11) NOT NULL DEFAULT '0',
  `OAuthEnable` tinyint(1) NOT NULL DEFAULT '0',
  `OAuthName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `OAuthType` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `OAuthIconUrl` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `CreatedAt` timestamp NULL DEFAULT NULL,
  `UpdatedAt` timestamp NULL DEFAULT NULL,
  `ExternalAccessImapUseSsl` tinyint(1) NOT NULL DEFAULT '0',
  `ExternalAccessPop3UseSsl` tinyint(1) NOT NULL DEFAULT '0',
  `ExternalAccessSmtpUseSsl` tinyint(1) NOT NULL DEFAULT '0',
  `Properties` json DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `mail_servers_tenantid_index` (`TenantId`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]mail_servers`
--

INSERT INTO `[[dbprefix]]mail_servers` VALUES
(1, 0, '[[site_name]]', '[[in_host_server]]', [[in_m_port]], [[in_ssl]], '[[out_host_server]]', [[out_m_port]], [[out_ssl]], '2', '', '[[smtp_pass]]', 'superadmin', '*', 0, 4190, 1, 1, 0, '', 143, 0, '', 25, 0, '', 110, 0, 0, '', '', '', '[[regtime]]', '[[regtime]]', 0, 0, 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mail_system_folders`
--

CREATE TABLE `[[dbprefix]]mail_system_folders` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IdAccount` int(11) NOT NULL DEFAULT '0',
  `FolderFullName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Type` int(11) NOT NULL DEFAULT '0',
  `CreatedAt` timestamp NULL DEFAULT NULL,
  `UpdatedAt` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `mail_system_folders_idaccount_index` (`IdAccount`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mail_trusted_senders`
--

CREATE TABLE `[[dbprefix]]mail_trusted_senders` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IdUser` int(11) NOT NULL DEFAULT '0',
  `Email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `CreatedAt` timestamp NULL DEFAULT NULL,
  `UpdatedAt` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `mail_trusted_senders_iduser_index` (`IdUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]migrations`
--

CREATE TABLE `[[dbprefix]]migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=51 ;

--
-- Dumping data for table `[[dbprefix]]migrations`
--

INSERT INTO `[[dbprefix]]migrations` VALUES
(1, '2021_05_28_000000_create_users_table', 1),
(2, '2021_05_31_000000_create_tenants_table', 1),
(3, '2021_06_01_161027_create_channels_table', 1),
(4, '2021_06_01_174146_create_identities_table', 1),
(5, '2021_06_01_174155_create_servers_table', 1),
(6, '2021_06_01_174204_create_senders_table', 1),
(7, '2021_06_01_174302_create_system_folders_table', 1),
(8, '2021_06_01_174311_create_refresh_folders_table', 1),
(9, '2021_06_04_163909_create_contacts_table', 1),
(10, '2021_06_04_213031_create_groups_table', 1),
(11, '2021_06_16_082716_create_user_blocks_table', 1),
(12, '2021_06_16_181521_create_mail_accounts_table', 1),
(13, '2021_06_17_121251_create_group_contact_table', 1),
(14, '2021_06_22_094700_create_ctags_table', 1),
(15, '2021_06_29_083240_create_min_hashes_table', 1),
(16, '2021_06_29_153524_create_auth_tokens_table', 1),
(17, '2021_06_30_083257_create_oauth_accounts_table', 1),
(18, '2021_06_30_090544_create_tables', 1),
(19, '2021_07_01_090932_create_user_groups_table', 1),
(20, '2021_07_05_183347_create_used_devices_table', 1),
(21, '2021_07_05_183443_create_web_authn_keys_table', 1),
(22, '2021_07_06_051949_create_aliases_table', 1),
(23, '2021_07_20_120500_create_group_events_table', 1),
(24, '2021_09_27_131825_alter_mail_accounts_table', 1),
(25, '2022_01_12_065340_alter_contacts_table', 1),
(26, '2022_01_12_102346_create_contacts_addressbooks_table', 1),
(27, '2022_02_21_173842_create_core_groups_table', 1),
(28, '2022_02_22_144823_create_core_group_user_table', 1),
(29, '2022_03_04_165340_alter_oauth_accounts_table', 1),
(30, '2022_03_18_065340_alter_groups_table_add_isall_column', 1),
(31, '2022_03_18_102346_create_contacts_indexes', 1),
(32, '2022_03_21_081746_create_mail_indexes', 1),
(33, '2022_04_04_135951_create_contacts_fulltext_indexes', 1),
(34, '2022_04_05_090442_update_mail_indexes', 1),
(35, '2022_04_05_183315_create_core_fulltext_indexes', 1),
(36, '2022_04_28_135713_alter_mail_servers_table', 1),
(37, '2022_06_09_143701_delete_user_groups_table', 1),
(38, '2022_06_29_115844_alter_user_blocks_table_add_userid_column', 1),
(39, '2022_09_12_084813_alter_user_blocks_table_change_userid_column_order', 1),
(40, '2022_09_13_105133_alter_users_table_drop_datecreated_column', 1),
(41, '2023_04_25_154456_alter_users_table_update_timeformat_column', 1),
(42, '2023_07_07_154402_alter_contacts_table_drop_columns', 1),
(43, '2023_07_11_192210_alter_used_devices_table_add_device_custom_name_column', 1),
(44, '2023_09_26_144011_create_contacts_cards_table', 1),
(45, '2023_10_17_104033_populate_contacts_cards_table', 1),
(46, '2023_12_04_120840_add_dav_indexies', 1),
(47, '2023_12_26_124548_copy_data_to_contacts_cards_table', 1),
(48, '2024_04_17_205916_alter_users_table_add_note_column', 1),
(49, '2024_07_18_150957_alter_mail_servers_table_add_properties_column', 1),
(50, '2024_09_20_111457_alter_core_auth_token_table_add_columns', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]oauth_accounts`
--

CREATE TABLE `[[dbprefix]]oauth_accounts` (
  `Id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `IdUser` int(11) NOT NULL DEFAULT '0',
  `IdSocial` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `AccessToken` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `RefreshToken` text COLLATE utf8mb4_unicode_ci,
  `Scopes` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `Disabled` tinyint(1) NOT NULL DEFAULT '0',
  `AccountType` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'oauth',
  `CreatedAt` timestamp NULL DEFAULT NULL,
  `UpdatedAt` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]security_used_devices`
--

CREATE TABLE `[[dbprefix]]security_used_devices` (
  `Id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `UserId` bigint(20) NOT NULL DEFAULT '0',
  `DeviceId` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `DeviceName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `DeviceCustomName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `AuthToken` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `CreationDateTime` int(11) NOT NULL DEFAULT '0',
  `LastUsageDateTime` int(11) NOT NULL DEFAULT '0',
  `TrustTillDateTime` int(11) NOT NULL DEFAULT '0',
  `DeviceIP` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `CreatedAt` timestamp NULL DEFAULT NULL,
  `UpdatedAt` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]security_web_authn_keys`
--

CREATE TABLE `[[dbprefix]]security_web_authn_keys` (
  `Id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `UserId` bigint(20) NOT NULL DEFAULT '0',
  `Name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `KeyData` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `CreationDateTime` int(11) NOT NULL DEFAULT '0',
  `LastUsageDateTime` int(11) NOT NULL DEFAULT '0',
  `CreatedAt` timestamp NULL DEFAULT NULL,
  `UpdatedAt` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `[[dbprefix]]contacts_group_contact`
--
ALTER TABLE `[[dbprefix]]contacts_group_contact`
  ADD CONSTRAINT `contacts_group_contact_contactid_foreign` FOREIGN KEY (`ContactId`) REFERENCES `[[dbprefix]]contacts` (`Id`) ON DELETE CASCADE,
  ADD CONSTRAINT `contacts_group_contact_groupid_foreign` FOREIGN KEY (`GroupId`) REFERENCES `[[dbprefix]]contacts_groups` (`Id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]core_group_user`
--
ALTER TABLE `[[dbprefix]]core_group_user`
  ADD CONSTRAINT `core_group_user_groupid_foreign` FOREIGN KEY (`GroupId`) REFERENCES `[[dbprefix]]core_groups` (`Id`) ON DELETE CASCADE,
  ADD CONSTRAINT `core_group_user_userid_foreign` FOREIGN KEY (`UserId`) REFERENCES `[[dbprefix]]core_users` (`Id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]mail_accounts`
--
ALTER TABLE `[[dbprefix]]mail_accounts`
  ADD CONSTRAINT `mail_accounts_serverid_foreign` FOREIGN KEY (`ServerId`) REFERENCES `[[dbprefix]]mail_servers` (`Id`);

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
