<?php
/**
 * This code is licensed under AGPLv3 license or Afterlogic Software License
 * if commercial version of the product was purchased.
 * For full statements of the licenses see LICENSE-AFTERLOGIC and LICENSE-AGPL3 files.
 */

namespace Aurora\System\Enums;

/**
 * @license https://www.gnu.org/licenses/agpl-3.0.html AGPL-3.0
 * @license https://afterlogic.com/products/common-licensing Afterlogic Software License
 * @copyright Copyright (c) 2019, Afterlogic Corp.
 */
class DateFormat extends AbstractEnumeration
{
    public const DD_MONTH_YYYY = 'DD Month YYYY';
    public const MMDDYYYY = 'MM/DD/YYYY';
    public const DDMMYYYY = 'DD/MM/YYYY';
    public const MMDDYY = 'MM/DD/YY';
    public const DDMMYY = 'DD/MM/YY';

    /**
     * @var array
     */
    protected $aConsts = array(
        'DD Month YYYY' => self::DD_MONTH_YYYY,
        'MM/DD/YYYY' => self::MMDDYYYY,
        'DD/MM/YYYY' => self::DDMMYYYY,
        'MM/DD/YY' => self::MMDDYY,
        'DD/MM/YY' => self::DDMMYY
    );
}
