<?php
/**
 * This code is licensed under AGPLv3 license or Afterlogic Software License
 * if commercial version of the product was purchased.
 * For full statements of the licenses see LICENSE-AFTERLOGIC and LICENSE-AGPL3 files.
 */

namespace MailSo\Cache;

/**
 * @license https://www.gnu.org/licenses/agpl-3.0.html AGPL-3.0
 * @license https://afterlogic.com/products/common-licensing Afterlogic Software License
 * @copyright Copyright (c) 2019, Afterlogic Corp.
 *
 * @category MailSo
 * @package Cache
 */
interface DriverInterface
{
    /**
     * @param string $sKey
     * @param string $sValue
     *
     * @return bool
     */
    public function Set($sKey, $sValue);

    /**
     * @param string $sKey
     *
     * @return string
     */
    public function get($sKey);

    /**
     * @param string $sKey
     *
     * @return void
     */
    public function Delete($sKey);

    /**
     * @param int $iTimeToClearInHours = 24
     *
     * @return bool
     */
    public function gc($iTimeToClearInHours = 24);
}
