
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `webtrees221`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block`
--

CREATE TABLE `[[dbprefix]]block` (
  `block_id` int(11) NOT NULL AUTO_INCREMENT,
  `gedcom_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `xref` varchar(20) DEFAULT NULL,
  `location` enum('main','side') DEFAULT NULL,
  `block_order` int(11) NOT NULL,
  `module_name` varchar(32) NOT NULL,
  PRIMARY KEY (`block_id`),
  KEY `[[dbprefix]]block_module_name_index` (`module_name`),
  KEY `[[dbprefix]]block_gedcom_id_index` (`gedcom_id`),
  KEY `[[dbprefix]]block_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_setting`
--

CREATE TABLE `[[dbprefix]]block_setting` (
  `block_id` int(11) NOT NULL,
  `setting_name` varchar(32) NOT NULL,
  `setting_value` longtext NOT NULL,
  PRIMARY KEY (`block_id`,`setting_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]change`
--

CREATE TABLE `[[dbprefix]]change` (
  `change_id` int(11) NOT NULL AUTO_INCREMENT,
  `change_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` enum('accepted','pending','rejected') NOT NULL DEFAULT 'pending',
  `gedcom_id` int(11) NOT NULL,
  `xref` varchar(20) NOT NULL,
  `old_gedcom` longtext NOT NULL,
  `new_gedcom` longtext NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `[[dbprefix]]change_gedcom_id_status_xref_index` (`gedcom_id`,`status`,`xref`),
  KEY `[[dbprefix]]change_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]dates`
--

CREATE TABLE `[[dbprefix]]dates` (
  `d_day` tinyint(4) NOT NULL,
  `d_month` char(5) DEFAULT NULL,
  `d_mon` tinyint(4) NOT NULL,
  `d_year` smallint(6) NOT NULL,
  `d_julianday1` mediumint(9) NOT NULL,
  `d_julianday2` mediumint(9) NOT NULL,
  `d_fact` varchar(15) NOT NULL,
  `d_gid` varchar(20) NOT NULL,
  `d_file` int(11) NOT NULL,
  `d_type` enum('@#DGREGORIAN@','@#DJULIAN@','@#DHEBREW@','@#DFRENCH R@','@#DHIJRI@','@#DROMAN@','@#DJALALI@') NOT NULL,
  KEY `[[dbprefix]]dates_d_day_index` (`d_day`),
  KEY `[[dbprefix]]dates_d_month_index` (`d_month`),
  KEY `[[dbprefix]]dates_d_mon_index` (`d_mon`),
  KEY `[[dbprefix]]dates_d_year_index` (`d_year`),
  KEY `[[dbprefix]]dates_d_julianday1_index` (`d_julianday1`),
  KEY `[[dbprefix]]dates_d_julianday2_index` (`d_julianday2`),
  KEY `[[dbprefix]]dates_d_gid_index` (`d_gid`),
  KEY `[[dbprefix]]dates_d_file_index` (`d_file`),
  KEY `[[dbprefix]]dates_d_type_index` (`d_type`),
  KEY `[[dbprefix]]dates_d_fact_d_gid_index` (`d_fact`,`d_gid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]dates`
--

INSERT INTO `[[dbprefix]]dates` VALUES
(1, 'JAN', 1, 1850, 2396759, 2396759, 'BIRT', 'X1', 1, '@#DGREGORIAN@');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]default_resn`
--

CREATE TABLE `[[dbprefix]]default_resn` (
  `default_resn_id` int(11) NOT NULL AUTO_INCREMENT,
  `gedcom_id` int(11) NOT NULL,
  `xref` varchar(20) DEFAULT NULL,
  `tag_type` varchar(15) DEFAULT NULL,
  `resn` enum('none','privacy','confidential','hidden') NOT NULL,
  `comment` varchar(255) DEFAULT NULL,
  `updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`default_resn_id`),
  UNIQUE KEY `[[dbprefix]]default_resn_gedcom_id_xref_tag_type_unique` (`gedcom_id`,`xref`,`tag_type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=13 ;

--
-- Dumping data for table `[[dbprefix]]default_resn`
--

INSERT INTO `[[dbprefix]]default_resn` VALUES
(1, -1, NULL, 'SSN', 'confidential', NULL, '[[regtime]]'),
(2, -1, NULL, 'SOUR', 'privacy', NULL, '[[regtime]]'),
(3, -1, NULL, 'REPO', 'privacy', NULL, '[[regtime]]'),
(4, -1, NULL, 'SUBM', 'confidential', NULL, '[[regtime]]'),
(5, -1, NULL, 'SUBN', 'confidential', NULL, '[[regtime]]'),
(6, 1, NULL, 'SSN', 'confidential', NULL, '[[regtime]]'),
(7, 1, NULL, 'SOUR', 'privacy', NULL, '[[regtime]]'),
(8, 1, NULL, 'REPO', 'privacy', NULL, '[[regtime]]'),
(9, 1, NULL, 'SUBM', 'confidential', NULL, '[[regtime]]'),
(10, 1, NULL, 'SUBN', 'confidential', NULL, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]families`
--

CREATE TABLE `[[dbprefix]]families` (
  `f_id` varchar(20) NOT NULL,
  `f_file` int(11) NOT NULL,
  `f_husb` varchar(20) DEFAULT NULL,
  `f_wife` varchar(20) DEFAULT NULL,
  `f_gedcom` longtext NOT NULL,
  `f_numchil` int(11) NOT NULL,
  PRIMARY KEY (`f_id`,`f_file`),
  UNIQUE KEY `[[dbprefix]]families_f_file_f_id_unique` (`f_file`,`f_id`),
  KEY `[[dbprefix]]families_f_husb_index` (`f_husb`),
  KEY `[[dbprefix]]families_f_wife_index` (`f_wife`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]favorite`
--

CREATE TABLE `[[dbprefix]]favorite` (
  `favorite_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `gedcom_id` int(11) NOT NULL,
  `xref` varchar(20) DEFAULT NULL,
  `favorite_type` enum('INDI','FAM','SOUR','REPO','OBJE','NOTE','URL') NOT NULL,
  `url` varchar(255) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `note` varchar(1000) DEFAULT NULL,
  PRIMARY KEY (`favorite_id`),
  KEY `[[dbprefix]]favorite_user_id_index` (`user_id`),
  KEY `[[dbprefix]]favorite_gedcom_id_user_id_index` (`gedcom_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gedcom`
--

CREATE TABLE `[[dbprefix]]gedcom` (
  `gedcom_id` int(11) NOT NULL AUTO_INCREMENT,
  `gedcom_name` varchar(255) NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`gedcom_id`),
  UNIQUE KEY `[[dbprefix]]gedcom_gedcom_name_unique` (`gedcom_name`),
  KEY `[[dbprefix]]gedcom_sort_order_index` (`sort_order`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]gedcom`
--

INSERT INTO `[[dbprefix]]gedcom` VALUES
(-1, 'DEFAULT_TREE', 0),
(1, 'tree1', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gedcom_chunk`
--

CREATE TABLE `[[dbprefix]]gedcom_chunk` (
  `gedcom_chunk_id` int(11) NOT NULL AUTO_INCREMENT,
  `gedcom_id` int(11) NOT NULL,
  `chunk_data` longtext NOT NULL,
  `imported` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`gedcom_chunk_id`),
  KEY `[[dbprefix]]gedcom_chunk_gedcom_id_imported_index` (`gedcom_id`,`imported`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gedcom_setting`
--

CREATE TABLE `[[dbprefix]]gedcom_setting` (
  `gedcom_id` int(11) NOT NULL,
  `setting_name` varchar(32) NOT NULL,
  `setting_value` varchar(255) NOT NULL,
  PRIMARY KEY (`gedcom_id`,`setting_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]gedcom_setting`
--

INSERT INTO `[[dbprefix]]gedcom_setting` VALUES
(1, 'CONTACT_USER_ID', '1'),
(1, 'imported', '1'),
(1, 'REQUIRE_AUTHENTICATION', ''),
(1, 'title', '[[site_name]]'),
(1, 'WEBMASTER_USER_ID', '1');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]hit_counter`
--

CREATE TABLE `[[dbprefix]]hit_counter` (
  `gedcom_id` int(11) NOT NULL,
  `page_name` varchar(32) NOT NULL,
  `page_parameter` varchar(32) NOT NULL,
  `page_count` int(11) NOT NULL,
  PRIMARY KEY (`gedcom_id`,`page_name`,`page_parameter`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]individuals`
--

CREATE TABLE `[[dbprefix]]individuals` (
  `i_id` varchar(20) NOT NULL,
  `i_file` int(11) NOT NULL,
  `i_rin` varchar(20) NOT NULL,
  `i_sex` enum('U','M','F') NOT NULL,
  `i_gedcom` longtext NOT NULL,
  PRIMARY KEY (`i_id`,`i_file`),
  UNIQUE KEY `[[dbprefix]]individuals_i_file_i_id_unique` (`i_file`,`i_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]individuals`
--

INSERT INTO `[[dbprefix]]individuals` VALUES
('X1', 1, 'X1', 'M', '0 @X1@ INDI\n1 NAME John /DOE/\n1 SEX M\n1 BIRT\n2 DATE 01 JAN 1850\n2 NOTE Edit this individual and replace their details with your own.');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]link`
--

CREATE TABLE `[[dbprefix]]link` (
  `l_file` int(11) NOT NULL,
  `l_from` varchar(20) NOT NULL,
  `l_type` varchar(15) NOT NULL,
  `l_to` varchar(20) NOT NULL,
  PRIMARY KEY (`l_from`,`l_file`,`l_type`,`l_to`),
  UNIQUE KEY `[[dbprefix]]link_l_to_l_file_l_type_l_from_unique` (`l_to`,`l_file`,`l_type`,`l_from`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]log`
--

CREATE TABLE `[[dbprefix]]log` (
  `log_id` int(11) NOT NULL AUTO_INCREMENT,
  `log_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `log_type` enum('auth','config','debug','edit','error','media','search') NOT NULL,
  `log_message` longtext NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `gedcom_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `[[dbprefix]]log_log_time_index` (`log_time`),
  KEY `[[dbprefix]]log_log_type_index` (`log_type`),
  KEY `[[dbprefix]]log_ip_address_index` (`ip_address`),
  KEY `[[dbprefix]]log_user_id_index` (`user_id`),
  KEY `[[dbprefix]]log_gedcom_id_index` (`gedcom_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=54 ;

--
-- Dumping data for table `[[dbprefix]]log`
--

INSERT INTO `[[dbprefix]]log` VALUES
(1, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "1"', '[[clientip]]', NULL, NULL),
(2, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "2"', '[[clientip]]', NULL, NULL),
(3, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "3"', '[[clientip]]', NULL, NULL),
(4, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "4"', '[[clientip]]', NULL, NULL),
(5, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "5"', '[[clientip]]', NULL, NULL),
(6, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "6"', '[[clientip]]', NULL, NULL),
(7, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "7"', '[[clientip]]', NULL, NULL),
(8, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "8"', '[[clientip]]', NULL, NULL),
(9, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "9"', '[[clientip]]', NULL, NULL),
(10, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "10"', '[[clientip]]', NULL, NULL),
(11, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "11"', '[[clientip]]', NULL, NULL),
(12, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "12"', '[[clientip]]', NULL, NULL),
(13, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "13"', '[[clientip]]', NULL, NULL),
(14, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "14"', '[[clientip]]', NULL, NULL),
(15, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "15"', '[[clientip]]', NULL, NULL),
(16, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "16"', '[[clientip]]', NULL, NULL),
(17, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "17"', '[[clientip]]', NULL, NULL),
(18, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "18"', '[[clientip]]', NULL, NULL),
(19, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "19"', '[[clientip]]', NULL, NULL),
(20, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "20"', '[[clientip]]', NULL, NULL),
(21, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "21"', '[[clientip]]', NULL, NULL),
(22, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "22"', '[[clientip]]', NULL, NULL),
(23, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "23"', '[[clientip]]', NULL, NULL),
(24, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "24"', '[[clientip]]', NULL, NULL),
(25, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "25"', '[[clientip]]', NULL, NULL),
(26, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "26"', '[[clientip]]', NULL, NULL),
(27, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "27"', '[[clientip]]', NULL, NULL),
(28, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "28"', '[[clientip]]', NULL, NULL),
(29, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "29"', '[[clientip]]', NULL, NULL),
(30, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "30"', '[[clientip]]', NULL, NULL),
(31, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "31"', '[[clientip]]', NULL, NULL),
(32, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "32"', '[[clientip]]', NULL, NULL),
(33, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "33"', '[[clientip]]', NULL, NULL),
(34, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "34"', '[[clientip]]', NULL, NULL),
(35, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "35"', '[[clientip]]', NULL, NULL),
(36, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "36"', '[[clientip]]', NULL, NULL),
(37, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "37"', '[[clientip]]', NULL, NULL),
(38, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "38"', '[[clientip]]', NULL, NULL),
(39, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "39"', '[[clientip]]', NULL, NULL),
(40, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "40"', '[[clientip]]', NULL, NULL),
(41, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "41"', '[[clientip]]', NULL, NULL),
(42, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "42"', '[[clientip]]', NULL, NULL),
(43, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "43"', '[[clientip]]', NULL, NULL),
(44, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "44"', '[[clientip]]', NULL, NULL),
(45, '[[regtime]]', 'config', 'Site preference "WT_SCHEMA_VERSION" set to "45"', '[[clientip]]', NULL, NULL),
(49, '[[regtime]]', 'config', 'Tree preference "imported" set to "1"', '[[clientip]]', 1, 1),
(50, '[[regtime]]', 'config', 'Tree preference "title" set to "[[site_name]]"', '[[clientip]]', 1, 1),
(51, '[[regtime]]', 'config', 'Tree preference "REQUIRE_AUTHENTICATION" set to ""', '[[clientip]]', 1, 1),
(52, '[[regtime]]', 'config', 'Tree preference "CONTACT_USER_ID" set to "1"', '[[clientip]]', 1, 1),
(53, '[[regtime]]', 'config', 'Tree preference "WEBMASTER_USER_ID" set to "1"', '[[clientip]]', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]media`
--

CREATE TABLE `[[dbprefix]]media` (
  `m_id` varchar(20) NOT NULL,
  `m_file` int(11) NOT NULL,
  `m_gedcom` longtext,
  PRIMARY KEY (`m_file`,`m_id`),
  UNIQUE KEY `[[dbprefix]]media_m_id_m_file_unique` (`m_id`,`m_file`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]media_file`
--

CREATE TABLE `[[dbprefix]]media_file` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `m_id` varchar(20) NOT NULL,
  `m_file` int(11) NOT NULL,
  `multimedia_file_refn` varchar(248) NOT NULL,
  `multimedia_format` varchar(4) NOT NULL,
  `source_media_type` varchar(15) NOT NULL,
  `descriptive_title` varchar(248) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]media_file_m_id_m_file_index` (`m_id`,`m_file`),
  KEY `[[dbprefix]]media_file_m_file_m_id_index` (`m_file`,`m_id`),
  KEY `[[dbprefix]]media_file_m_file_multimedia_file_refn_index` (`m_file`,`multimedia_file_refn`),
  KEY `[[dbprefix]]media_file_m_file_multimedia_format_index` (`m_file`,`multimedia_format`),
  KEY `[[dbprefix]]media_file_m_file_source_media_type_index` (`m_file`,`source_media_type`),
  KEY `[[dbprefix]]media_file_m_file_descriptive_title_index` (`m_file`,`descriptive_title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message`
--

CREATE TABLE `[[dbprefix]]message` (
  `message_id` int(11) NOT NULL AUTO_INCREMENT,
  `sender` varchar(64) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `user_id` int(11) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `body` longtext NOT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`message_id`),
  KEY `[[dbprefix]]message_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]module`
--

CREATE TABLE `[[dbprefix]]module` (
  `module_name` varchar(32) NOT NULL,
  `status` enum('enabled','disabled') NOT NULL DEFAULT 'enabled',
  `tab_order` int(11) DEFAULT NULL,
  `menu_order` int(11) DEFAULT NULL,
  `sidebar_order` int(11) DEFAULT NULL,
  `footer_order` int(11) DEFAULT NULL,
  PRIMARY KEY (`module_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]module`
--

INSERT INTO `[[dbprefix]]module` VALUES
('ahnentafel_report', 'enabled', NULL, NULL, NULL, NULL),
('ancestors_chart', 'enabled', NULL, NULL, NULL, NULL),
('austrian-history', 'disabled', NULL, NULL, NULL, NULL),
('austrian-presidents', 'disabled', NULL, NULL, NULL, NULL),
('bdm_report', 'enabled', NULL, NULL, NULL, NULL),
('bing-maps', 'disabled', NULL, NULL, NULL, NULL),
('bing-webmaster-tools', 'disabled', NULL, NULL, NULL, NULL),
('birth_report', 'enabled', NULL, NULL, NULL, NULL),
('branches_list', 'enabled', NULL, NULL, NULL, NULL),
('british-monarchs', 'disabled', NULL, NULL, NULL, NULL),
('british-prime-ministers', 'disabled', NULL, NULL, NULL, NULL),
('british-social-history', 'disabled', NULL, NULL, NULL, NULL),
('calendar-menu', 'enabled', NULL, NULL, NULL, NULL),
('cemetery_report', 'enabled', NULL, NULL, NULL, NULL),
('change_report', 'enabled', NULL, NULL, NULL, NULL),
('charts', 'enabled', NULL, NULL, NULL, NULL),
('charts-menu', 'enabled', NULL, NULL, NULL, NULL),
('check-for-new-version', 'enabled', NULL, NULL, NULL, NULL),
('ckeditor', 'enabled', NULL, NULL, NULL, NULL),
('clippings', 'enabled', NULL, NULL, NULL, NULL),
('clouds', 'enabled', NULL, NULL, NULL, NULL),
('colors', 'enabled', NULL, NULL, NULL, NULL),
('compact-chart', 'enabled', NULL, NULL, NULL, NULL),
('contact-links', 'enabled', NULL, NULL, NULL, NULL),
('custom-css-js', 'disabled', NULL, NULL, NULL, NULL),
('czech-leaders', 'disabled', NULL, NULL, NULL, NULL),
('death_report', 'enabled', NULL, NULL, NULL, NULL),
('descendancy', 'enabled', NULL, NULL, NULL, NULL),
('descendancy_chart', 'enabled', NULL, NULL, NULL, NULL),
('descendancy_report', 'enabled', NULL, NULL, NULL, NULL),
('dutch_monarchs', 'disabled', NULL, NULL, NULL, NULL),
('dutch_prime_ministers', 'disabled', NULL, NULL, NULL, NULL),
('esri-maps', 'disabled', NULL, NULL, NULL, NULL),
('extra_info', 'enabled', NULL, NULL, NULL, NULL),
('fab', 'enabled', NULL, NULL, NULL, NULL),
('fact_sources', 'enabled', NULL, NULL, NULL, NULL),
('family_book_chart', 'enabled', NULL, NULL, NULL, NULL),
('family_group_report', 'enabled', NULL, NULL, NULL, NULL),
('family_list', 'enabled', NULL, NULL, NULL, NULL),
('family_nav', 'enabled', NULL, NULL, NULL, NULL),
('fan_chart', 'enabled', NULL, NULL, NULL, NULL),
('faq', 'enabled', NULL, NULL, NULL, NULL),
('fix-add-death', 'enabled', NULL, NULL, NULL, NULL),
('fix-ceme-tag', 'enabled', NULL, NULL, NULL, NULL),
('fix-duplicate-links', 'enabled', NULL, NULL, NULL, NULL),
('fix-name-slashes-spaces', 'enabled', NULL, NULL, NULL, NULL),
('fix-name-tags', 'enabled', NULL, NULL, NULL, NULL),
('fix-place-names', 'enabled', NULL, NULL, NULL, NULL),
('fix-prim-tag', 'enabled', NULL, NULL, NULL, NULL),
('fix-search-and-replace', 'enabled', NULL, NULL, NULL, NULL),
('fix-wt-obje-sort', 'enabled', NULL, NULL, NULL, NULL),
('french-history', 'disabled', NULL, NULL, NULL, NULL),
('gedcom_block', 'enabled', NULL, NULL, NULL, NULL),
('gedcom_favorites', 'enabled', NULL, NULL, NULL, NULL),
('gedcom_news', 'enabled', NULL, NULL, NULL, NULL),
('gedcom_stats', 'enabled', NULL, NULL, NULL, NULL),
('GEDFact_assistant', 'enabled', NULL, NULL, NULL, NULL),
('geonames', 'disabled', NULL, NULL, NULL, NULL),
('google-analytics', 'disabled', NULL, NULL, NULL, NULL),
('google-maps', 'disabled', NULL, NULL, NULL, NULL),
('google-webmaster-tools', 'disabled', NULL, NULL, NULL, NULL),
('here-maps', 'disabled', NULL, NULL, NULL, NULL),
('hit-counter', 'enabled', NULL, NULL, NULL, NULL),
('hourglass_chart', 'enabled', NULL, NULL, NULL, NULL),
('html', 'enabled', NULL, NULL, NULL, NULL),
('individual_ext_report', 'enabled', NULL, NULL, NULL, NULL),
('individual_list', 'enabled', NULL, NULL, NULL, NULL),
('individual_report', 'enabled', NULL, NULL, NULL, NULL),
('language-af', 'enabled', NULL, NULL, NULL, NULL),
('language-ar', 'enabled', NULL, NULL, NULL, NULL),
('language-bg', 'enabled', NULL, NULL, NULL, NULL),
('language-bs', 'enabled', NULL, NULL, NULL, NULL),
('language-ca', 'enabled', NULL, NULL, NULL, NULL),
('language-cs', 'enabled', NULL, NULL, NULL, NULL),
('language-cy', 'disabled', NULL, NULL, NULL, NULL),
('language-da', 'enabled', NULL, NULL, NULL, NULL),
('language-de', 'enabled', NULL, NULL, NULL, NULL),
('language-dv', 'disabled', NULL, NULL, NULL, NULL),
('language-el', 'enabled', NULL, NULL, NULL, NULL),
('language-en-AU', 'disabled', NULL, NULL, NULL, NULL),
('language-en-GB', 'enabled', NULL, NULL, NULL, NULL),
('language-en-US', 'enabled', NULL, NULL, NULL, NULL),
('language-es', 'enabled', NULL, NULL, NULL, NULL),
('language-et', 'enabled', NULL, NULL, NULL, NULL),
('language-eu', 'disabled', NULL, NULL, NULL, NULL),
('language-fa', 'disabled', NULL, NULL, NULL, NULL),
('language-fi', 'enabled', NULL, NULL, NULL, NULL),
('language-fo', 'disabled', NULL, NULL, NULL, NULL),
('language-fr', 'enabled', NULL, NULL, NULL, NULL),
('language-fr-CA', 'disabled', NULL, NULL, NULL, NULL),
('language-gl', 'enabled', NULL, NULL, NULL, NULL),
('language-he', 'enabled', NULL, NULL, NULL, NULL),
('language-hi', 'enabled', NULL, NULL, NULL, NULL),
('language-hr', 'enabled', NULL, NULL, NULL, NULL),
('language-hu', 'enabled', NULL, NULL, NULL, NULL),
('language-id', 'disabled', NULL, NULL, NULL, NULL),
('language-is', 'enabled', NULL, NULL, NULL, NULL),
('language-it', 'enabled', NULL, NULL, NULL, NULL),
('language-ja', 'disabled', NULL, NULL, NULL, NULL),
('language-jv', 'disabled', NULL, NULL, NULL, NULL),
('language-ka', 'enabled', NULL, NULL, NULL, NULL),
('language-kk', 'enabled', NULL, NULL, NULL, NULL),
('language-ko', 'disabled', NULL, NULL, NULL, NULL),
('language-ku', 'disabled', NULL, NULL, NULL, NULL),
('language-ln', 'disabled', NULL, NULL, NULL, NULL),
('language-lt', 'enabled', NULL, NULL, NULL, NULL),
('language-lv', 'disabled', NULL, NULL, NULL, NULL),
('language-mi', 'disabled', NULL, NULL, NULL, NULL),
('language-mr', 'disabled', NULL, NULL, NULL, NULL),
('language-ms', 'disabled', NULL, NULL, NULL, NULL),
('language-nb', 'disabled', NULL, NULL, NULL, NULL),
('language-ne', 'disabled', NULL, NULL, NULL, NULL),
('language-nl', 'enabled', NULL, NULL, NULL, NULL),
('language-nn', 'disabled', NULL, NULL, NULL, NULL),
('language-oc', 'disabled', NULL, NULL, NULL, NULL),
('language-pl', 'enabled', NULL, NULL, NULL, NULL),
('language-pt', 'enabled', NULL, NULL, NULL, NULL),
('language-pt-BR', 'disabled', NULL, NULL, NULL, NULL),
('language-ro', 'disabled', NULL, NULL, NULL, NULL),
('language-ru', 'enabled', NULL, NULL, NULL, NULL),
('language-sk', 'enabled', NULL, NULL, NULL, NULL),
('language-sl', 'disabled', NULL, NULL, NULL, NULL),
('language-sq', 'disabled', NULL, NULL, NULL, NULL),
('language-sr', 'disabled', NULL, NULL, NULL, NULL),
('language-sr-Latn', 'disabled', NULL, NULL, NULL, NULL),
('language-su', 'disabled', NULL, NULL, NULL, NULL),
('language-sv', 'enabled', NULL, NULL, NULL, NULL),
('language-sw', 'disabled', NULL, NULL, NULL, NULL),
('language-ta', 'disabled', NULL, NULL, NULL, NULL),
('language-th', 'disabled', NULL, NULL, NULL, NULL),
('language-tl', 'disabled', NULL, NULL, NULL, NULL),
('language-tr', 'enabled', NULL, NULL, NULL, NULL),
('language-tt', 'disabled', NULL, NULL, NULL, NULL),
('language-uk', 'enabled', NULL, NULL, NULL, NULL),
('language-ur', 'disabled', NULL, NULL, NULL, NULL),
('language-uz', 'disabled', NULL, NULL, NULL, NULL),
('language-vi', 'enabled', NULL, NULL, NULL, NULL),
('language-yi', 'disabled', NULL, NULL, NULL, NULL),
('language-zh-Hans', 'enabled', NULL, NULL, NULL, NULL),
('language-zh-Hant', 'enabled', NULL, NULL, NULL, NULL),
('legacy-urls', 'enabled', NULL, NULL, NULL, NULL),
('lifespans_chart', 'enabled', NULL, NULL, NULL, NULL),
('lightbox', 'enabled', NULL, NULL, NULL, NULL),
('lists-menu', 'enabled', NULL, NULL, NULL, NULL),
('location_list', 'enabled', NULL, NULL, NULL, NULL),
('logged_in', 'enabled', NULL, NULL, NULL, NULL),
('login_block', 'enabled', NULL, NULL, NULL, NULL),
('low_countries_rulers', 'disabled', NULL, NULL, NULL, NULL),
('map-link-bing', 'enabled', NULL, NULL, NULL, NULL),
('map-link-google', 'enabled', NULL, NULL, NULL, NULL),
('map-link-openstreetmap', 'enabled', NULL, NULL, NULL, NULL),
('map-location-geonames', 'disabled', NULL, NULL, NULL, NULL),
('map-location-nominatim', 'disabled', NULL, NULL, NULL, NULL),
('map-location-ors', 'disabled', NULL, NULL, NULL, NULL),
('mapbox', 'disabled', NULL, NULL, NULL, NULL),
('marriage_report', 'enabled', NULL, NULL, NULL, NULL),
('matomo-analytics', 'disabled', NULL, NULL, NULL, NULL),
('media', 'enabled', NULL, NULL, NULL, NULL),
('media_list', 'enabled', NULL, NULL, NULL, NULL),
('minimal', 'enabled', NULL, NULL, NULL, NULL),
('missing_facts_report', 'enabled', NULL, NULL, NULL, NULL),
('notes', 'enabled', NULL, NULL, NULL, NULL),
('note_list', 'enabled', NULL, NULL, NULL, NULL),
('nz-leaders', 'disabled', NULL, NULL, NULL, NULL),
('occupation_report', 'enabled', NULL, NULL, NULL, NULL),
('openrouteservice', 'disabled', NULL, NULL, NULL, NULL),
('openstreetmap', 'enabled', NULL, NULL, NULL, NULL),
('pedigree-map', 'enabled', NULL, NULL, NULL, NULL),
('pedigree_chart', 'enabled', NULL, NULL, NULL, NULL),
('pedigree_report', 'enabled', NULL, NULL, NULL, NULL),
('personal_facts', 'enabled', NULL, NULL, NULL, NULL),
('places', 'enabled', NULL, NULL, NULL, NULL),
('places_list', 'enabled', NULL, NULL, NULL, NULL),
('powered-by-webtrees', 'enabled', NULL, NULL, NULL, NULL),
('privacy-policy', 'enabled', NULL, NULL, NULL, NULL),
('random_media', 'enabled', NULL, NULL, NULL, NULL),
('recent_changes', 'enabled', NULL, NULL, NULL, NULL),
('relationships_chart', 'enabled', NULL, NULL, NULL, NULL),
('relatives', 'enabled', NULL, NULL, NULL, NULL),
('relative_ext_report', 'enabled', NULL, NULL, NULL, NULL),
('reports-menu', 'enabled', NULL, NULL, NULL, NULL),
('repository_list', 'enabled', NULL, NULL, NULL, NULL),
('review_changes', 'enabled', NULL, NULL, NULL, NULL),
('search-menu', 'enabled', NULL, NULL, NULL, NULL),
('share-anniversary', 'enabled', NULL, NULL, NULL, NULL),
('share-url', 'enabled', NULL, NULL, NULL, NULL),
('sitemap', 'disabled', NULL, NULL, NULL, NULL),
('sources_tab', 'enabled', NULL, NULL, NULL, NULL),
('source_list', 'enabled', NULL, NULL, NULL, NULL),
('statcounter', 'disabled', NULL, NULL, NULL, NULL),
('statistics_chart', 'enabled', NULL, NULL, NULL, NULL),
('stories', 'enabled', NULL, NULL, NULL, NULL),
('submitter_list', 'disabled', NULL, NULL, NULL, NULL),
('theme_select', 'enabled', NULL, NULL, NULL, NULL),
('timeline_chart', 'enabled', NULL, NULL, NULL, NULL),
('todays_events', 'enabled', NULL, NULL, NULL, NULL),
('todo', 'enabled', NULL, NULL, NULL, NULL),
('top10_givnnames', 'enabled', NULL, NULL, NULL, NULL),
('top10_pageviews', 'enabled', NULL, NULL, NULL, NULL),
('top10_surnames', 'enabled', NULL, NULL, NULL, NULL),
('tree', 'enabled', NULL, NULL, NULL, NULL),
('trees-menu', 'enabled', NULL, NULL, NULL, NULL),
('upcoming_events', 'enabled', NULL, NULL, NULL, NULL),
('us-presidents', 'disabled', NULL, NULL, NULL, NULL),
('user_blog', 'enabled', NULL, NULL, NULL, NULL),
('user_favorites', 'enabled', NULL, NULL, NULL, NULL),
('user_messages', 'enabled', NULL, NULL, NULL, NULL),
('user_welcome', 'enabled', NULL, NULL, NULL, NULL),
('webtrees', 'enabled', NULL, NULL, NULL, NULL),
('xenea', 'enabled', NULL, NULL, NULL, NULL),
('yahrzeit', 'enabled', NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]module_privacy`
--

CREATE TABLE `[[dbprefix]]module_privacy` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `module_name` varchar(32) NOT NULL,
  `gedcom_id` int(11) NOT NULL,
  `interface` varchar(255) NOT NULL,
  `access_level` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]module_privacy_ix1` (`gedcom_id`,`module_name`,`interface`),
  UNIQUE KEY `[[dbprefix]]module_privacy_ix2` (`module_name`,`gedcom_id`,`interface`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]module_setting`
--

CREATE TABLE `[[dbprefix]]module_setting` (
  `module_name` varchar(32) NOT NULL,
  `setting_name` varchar(32) NOT NULL,
  `setting_value` longtext NOT NULL,
  PRIMARY KEY (`module_name`,`setting_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]name`
--

CREATE TABLE `[[dbprefix]]name` (
  `n_file` int(11) NOT NULL,
  `n_id` varchar(20) NOT NULL,
  `n_num` int(11) NOT NULL,
  `n_type` varchar(15) NOT NULL,
  `n_sort` varchar(255) NOT NULL,
  `n_full` varchar(255) NOT NULL,
  `n_surname` varchar(255) DEFAULT NULL,
  `n_surn` varchar(255) DEFAULT NULL,
  `n_givn` varchar(255) DEFAULT NULL,
  `n_soundex_givn_std` varchar(255) DEFAULT NULL,
  `n_soundex_surn_std` varchar(255) DEFAULT NULL,
  `n_soundex_givn_dm` varchar(255) DEFAULT NULL,
  `n_soundex_surn_dm` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`n_id`,`n_file`,`n_num`),
  KEY `[[dbprefix]]name_n_full_n_id_n_file_index` (`n_full`,`n_id`,`n_file`),
  KEY `[[dbprefix]]name_n_surn_n_file_n_type_n_id_index` (`n_surn`,`n_file`,`n_type`,`n_id`),
  KEY `[[dbprefix]]name_n_givn_n_file_n_type_n_id_index` (`n_givn`,`n_file`,`n_type`,`n_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]name`
--

INSERT INTO `[[dbprefix]]name` VALUES
(1, 'X1', 0, 'NAME', 'DOE,John', 'John DOE', 'DOE', 'DOE', 'John', 'J500', 'D000', '160000:460000:560000:156000:456000:556000', '300000');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]news`
--

CREATE TABLE `[[dbprefix]]news` (
  `news_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `gedcom_id` int(11) DEFAULT NULL,
  `subject` varchar(255) NOT NULL,
  `body` text NOT NULL,
  `updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`news_id`),
  KEY `[[dbprefix]]news_user_id_updated_index` (`user_id`,`updated`),
  KEY `[[dbprefix]]news_gedcom_id_updated_index` (`gedcom_id`,`updated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]other`
--

CREATE TABLE `[[dbprefix]]other` (
  `o_id` varchar(20) NOT NULL,
  `o_file` int(11) NOT NULL,
  `o_type` varchar(15) NOT NULL,
  `o_gedcom` longtext NOT NULL,
  PRIMARY KEY (`o_id`,`o_file`),
  UNIQUE KEY `[[dbprefix]]other_o_file_o_id_unique` (`o_file`,`o_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]other`
--

INSERT INTO `[[dbprefix]]other` VALUES
('HEAD', 1, 'HEAD', '0 HEAD\n1 SOUR webtrees\n1 DEST webtrees\n1 GEDC\n2 VERS 5.5.1\n2 FORM LINEAGE-LINKED\n1 CHAR UTF-8\n1 DATE [[gedrec]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]placelinks`
--

CREATE TABLE `[[dbprefix]]placelinks` (
  `pl_p_id` int(11) NOT NULL,
  `pl_gid` varchar(20) NOT NULL,
  `pl_file` int(11) NOT NULL,
  PRIMARY KEY (`pl_p_id`,`pl_gid`,`pl_file`),
  KEY `[[dbprefix]]placelinks_pl_p_id_index` (`pl_p_id`),
  KEY `[[dbprefix]]placelinks_pl_gid_index` (`pl_gid`),
  KEY `[[dbprefix]]placelinks_pl_file_index` (`pl_file`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]places`
--

CREATE TABLE `[[dbprefix]]places` (
  `p_id` int(11) NOT NULL AUTO_INCREMENT,
  `p_place` varchar(150) NOT NULL,
  `p_parent_id` int(11) DEFAULT NULL,
  `p_file` int(11) NOT NULL,
  `p_std_soundex` longtext,
  `p_dm_soundex` longtext,
  PRIMARY KEY (`p_id`),
  UNIQUE KEY `[[dbprefix]]places_p_parent_id_p_file_p_place_unique` (`p_parent_id`,`p_file`,`p_place`),
  KEY `[[dbprefix]]places_p_file_p_place_index` (`p_file`,`p_place`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]place_location`
--

CREATE TABLE `[[dbprefix]]place_location` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) DEFAULT NULL,
  `place` varchar(120) NOT NULL,
  `latitude` double DEFAULT NULL,
  `longitude` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]place_location_parent_id_place_unique` (`parent_id`,`place`),
  UNIQUE KEY `[[dbprefix]]place_location_place_parent_id_unique` (`place`,`parent_id`),
  KEY `[[dbprefix]]place_location_latitude_index` (`latitude`),
  KEY `[[dbprefix]]place_location_longitude_index` (`longitude`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]session`
--

CREATE TABLE `[[dbprefix]]session` (
  `session_id` varchar(256) NOT NULL,
  `session_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `user_id` int(11) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `session_data` longtext NOT NULL,
  PRIMARY KEY (`session_id`),
  KEY `[[dbprefix]]session_session_time_index` (`session_time`),
  KEY `[[dbprefix]]session_user_id_ip_address_index` (`user_id`,`ip_address`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]session`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]site_setting`
--

CREATE TABLE `[[dbprefix]]site_setting` (
  `setting_name` varchar(32) NOT NULL,
  `setting_value` varchar(2000) NOT NULL,
  PRIMARY KEY (`setting_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]site_setting`
--

INSERT INTO `[[dbprefix]]site_setting` VALUES
('LANGUAGE', '[[language]]'),
('WT_SCHEMA_VERSION', '45');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sources`
--

CREATE TABLE `[[dbprefix]]sources` (
  `s_id` varchar(20) NOT NULL,
  `s_file` int(11) NOT NULL,
  `s_name` varchar(255) NOT NULL,
  `s_gedcom` longtext NOT NULL,
  PRIMARY KEY (`s_id`,`s_file`),
  UNIQUE KEY `[[dbprefix]]sources_s_file_s_id_unique` (`s_file`,`s_id`),
  KEY `[[dbprefix]]sources_s_name_index` (`s_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user`
--

CREATE TABLE `[[dbprefix]]user` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(32) NOT NULL,
  `real_name` varchar(64) NOT NULL,
  `email` varchar(64) NOT NULL,
  `password` varchar(128) NOT NULL,
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `[[dbprefix]]user_user_name_unique` (`user_name`),
  UNIQUE KEY `[[dbprefix]]user_email_unique` (`email`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]user`
--

INSERT INTO `[[dbprefix]]user` VALUES
(-1, 'DEFAULT_USER', 'DEFAULT_USER', 'DEFAULT_USER', 'DEFAULT_USER'),
(1, '[[admin_username]]', '[[admin_realname]]', '[[admin_email]]', '[[admin_pass]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_gedcom_setting`
--

CREATE TABLE `[[dbprefix]]user_gedcom_setting` (
  `user_id` int(11) NOT NULL,
  `gedcom_id` int(11) NOT NULL,
  `setting_name` varchar(32) NOT NULL,
  `setting_value` varchar(255) NOT NULL,
  PRIMARY KEY (`user_id`,`gedcom_id`,`setting_name`),
  KEY `[[dbprefix]]user_gedcom_setting_gedcom_id_index` (`gedcom_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_setting`
--

CREATE TABLE `[[dbprefix]]user_setting` (
  `user_id` int(11) NOT NULL,
  `setting_name` varchar(32) NOT NULL,
  `setting_value` varchar(255) NOT NULL,
  PRIMARY KEY (`user_id`,`setting_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]user_setting`
--

INSERT INTO `[[dbprefix]]user_setting` VALUES
(1, 'canadmin', '1'),
(1, 'language', '[[language]]'),
(1, 'sessiontime', '[[timestamp]]'),
(1, 'verified', '1'),
(1, 'verified_by_admin', '1'),
(1, 'visibleonline', '1');

--
-- Constraints for dumped tables
--

--
-- Constraints for table `[[dbprefix]]block`
--
ALTER TABLE `[[dbprefix]]block`
  ADD CONSTRAINT `[[dbprefix]]block_gedcom_id_foreign` FOREIGN KEY (`gedcom_id`) REFERENCES `[[dbprefix]]gedcom` (`gedcom_id`),
  ADD CONSTRAINT `[[dbprefix]]block_module_name_foreign` FOREIGN KEY (`module_name`) REFERENCES `[[dbprefix]]module` (`module_name`),
  ADD CONSTRAINT `[[dbprefix]]block_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]user` (`user_id`);

--
-- Constraints for table `[[dbprefix]]block_setting`
--
ALTER TABLE `[[dbprefix]]block_setting`
  ADD CONSTRAINT `[[dbprefix]]block_setting_block_id_foreign` FOREIGN KEY (`block_id`) REFERENCES `[[dbprefix]]block` (`block_id`);

--
-- Constraints for table `[[dbprefix]]change`
--
ALTER TABLE `[[dbprefix]]change`
  ADD CONSTRAINT `[[dbprefix]]change_gedcom_id_foreign` FOREIGN KEY (`gedcom_id`) REFERENCES `[[dbprefix]]gedcom` (`gedcom_id`),
  ADD CONSTRAINT `[[dbprefix]]change_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]user` (`user_id`);

--
-- Constraints for table `[[dbprefix]]default_resn`
--
ALTER TABLE `[[dbprefix]]default_resn`
  ADD CONSTRAINT `[[dbprefix]]default_resn_gedcom_id_foreign` FOREIGN KEY (`gedcom_id`) REFERENCES `[[dbprefix]]gedcom` (`gedcom_id`);

--
-- Constraints for table `[[dbprefix]]favorite`
--
ALTER TABLE `[[dbprefix]]favorite`
  ADD CONSTRAINT `[[dbprefix]]favorite_gedcom_id_foreign` FOREIGN KEY (`gedcom_id`) REFERENCES `[[dbprefix]]gedcom` (`gedcom_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]favorite_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]user` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]gedcom_chunk`
--
ALTER TABLE `[[dbprefix]]gedcom_chunk`
  ADD CONSTRAINT `[[dbprefix]]gedcom_chunk_gedcom_id_foreign` FOREIGN KEY (`gedcom_id`) REFERENCES `[[dbprefix]]gedcom` (`gedcom_id`);

--
-- Constraints for table `[[dbprefix]]gedcom_setting`
--
ALTER TABLE `[[dbprefix]]gedcom_setting`
  ADD CONSTRAINT `[[dbprefix]]gedcom_setting_gedcom_id_foreign` FOREIGN KEY (`gedcom_id`) REFERENCES `[[dbprefix]]gedcom` (`gedcom_id`);

--
-- Constraints for table `[[dbprefix]]hit_counter`
--
ALTER TABLE `[[dbprefix]]hit_counter`
  ADD CONSTRAINT `[[dbprefix]]hit_counter_gedcom_id_foreign` FOREIGN KEY (`gedcom_id`) REFERENCES `[[dbprefix]]gedcom` (`gedcom_id`);

--
-- Constraints for table `[[dbprefix]]log`
--
ALTER TABLE `[[dbprefix]]log`
  ADD CONSTRAINT `[[dbprefix]]log_gedcom_id_foreign` FOREIGN KEY (`gedcom_id`) REFERENCES `[[dbprefix]]gedcom` (`gedcom_id`),
  ADD CONSTRAINT `[[dbprefix]]log_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]user` (`user_id`);

--
-- Constraints for table `[[dbprefix]]message`
--
ALTER TABLE `[[dbprefix]]message`
  ADD CONSTRAINT `[[dbprefix]]message_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]user` (`user_id`);

--
-- Constraints for table `[[dbprefix]]module_privacy`
--
ALTER TABLE `[[dbprefix]]module_privacy`
  ADD CONSTRAINT `[[dbprefix]]module_privacy_gedcom_id_foreign` FOREIGN KEY (`gedcom_id`) REFERENCES `[[dbprefix]]gedcom` (`gedcom_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]module_privacy_module_name_foreign` FOREIGN KEY (`module_name`) REFERENCES `[[dbprefix]]module` (`module_name`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]module_setting`
--
ALTER TABLE `[[dbprefix]]module_setting`
  ADD CONSTRAINT `[[dbprefix]]module_setting_module_name_foreign` FOREIGN KEY (`module_name`) REFERENCES `[[dbprefix]]module` (`module_name`);

--
-- Constraints for table `[[dbprefix]]news`
--
ALTER TABLE `[[dbprefix]]news`
  ADD CONSTRAINT `[[dbprefix]]news_gedcom_id_foreign` FOREIGN KEY (`gedcom_id`) REFERENCES `[[dbprefix]]gedcom` (`gedcom_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]news_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]user` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]place_location`
--
ALTER TABLE `[[dbprefix]]place_location`
  ADD CONSTRAINT `[[dbprefix]]place_location_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `[[dbprefix]]place_location` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]user_gedcom_setting`
--
ALTER TABLE `[[dbprefix]]user_gedcom_setting`
  ADD CONSTRAINT `[[dbprefix]]user_gedcom_setting_gedcom_id_foreign` FOREIGN KEY (`gedcom_id`) REFERENCES `[[dbprefix]]gedcom` (`gedcom_id`),
  ADD CONSTRAINT `[[dbprefix]]user_gedcom_setting_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]user` (`user_id`);

--
-- Constraints for table `[[dbprefix]]user_setting`
--
ALTER TABLE `[[dbprefix]]user_setting`
  ADD CONSTRAINT `[[dbprefix]]user_setting_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]user` (`user_id`);

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
