
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `xmb191209`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]attachments`
--

CREATE TABLE `[[dbprefix]]attachments` (
  `aid` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT '0',
  `filename` varchar(120) NOT NULL DEFAULT '',
  `filetype` varchar(120) NOT NULL DEFAULT '',
  `filesize` varchar(120) NOT NULL DEFAULT '',
  `attachment` longblob NOT NULL,
  `downloads` int(11) NOT NULL DEFAULT '0',
  `img_size` varchar(9) NOT NULL,
  `parentid` int(11) NOT NULL DEFAULT '0',
  `subdir` varchar(15) NOT NULL,
  `uid` int(11) NOT NULL DEFAULT '0',
  `updatetime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`aid`),
  KEY `pid` (`pid`),
  KEY `parentid` (`parentid`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]banned`
--

CREATE TABLE `[[dbprefix]]banned` (
  `ip1` smallint(6) NOT NULL DEFAULT '0',
  `ip2` smallint(6) NOT NULL DEFAULT '0',
  `ip3` smallint(6) NOT NULL DEFAULT '0',
  `ip4` smallint(6) NOT NULL DEFAULT '0',
  `dateline` int(11) NOT NULL DEFAULT '0',
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `ip1` (`ip1`),
  KEY `ip2` (`ip2`),
  KEY `ip3` (`ip3`),
  KEY `ip4` (`ip4`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]buddys`
--

CREATE TABLE `[[dbprefix]]buddys` (
  `username` varchar(32) NOT NULL DEFAULT '',
  `buddyname` varchar(32) NOT NULL DEFAULT '',
  KEY `username` (`username`(8))
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]captchaimages`
--

CREATE TABLE `[[dbprefix]]captchaimages` (
  `imagehash` varchar(32) NOT NULL DEFAULT '',
  `imagestring` varchar(12) NOT NULL DEFAULT '',
  `dateline` int(11) NOT NULL DEFAULT '0',
  KEY `dateline` (`dateline`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]favorites`
--

CREATE TABLE `[[dbprefix]]favorites` (
  `tid` int(11) NOT NULL DEFAULT '0',
  `username` varchar(32) NOT NULL DEFAULT '',
  `type` varchar(32) NOT NULL DEFAULT '',
  KEY `tid` (`tid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forums`
--

CREATE TABLE `[[dbprefix]]forums` (
  `type` varchar(15) NOT NULL DEFAULT '',
  `fid` smallint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL DEFAULT '',
  `status` varchar(15) NOT NULL DEFAULT '',
  `lastpost` varchar(54) NOT NULL DEFAULT '',
  `moderator` varchar(100) NOT NULL DEFAULT '',
  `displayorder` smallint(6) NOT NULL DEFAULT '0',
  `description` text,
  `allowsmilies` char(3) NOT NULL DEFAULT '',
  `allowbbcode` char(3) NOT NULL DEFAULT '',
  `userlist` text NOT NULL,
  `theme` smallint(6) NOT NULL DEFAULT '0',
  `posts` int(11) NOT NULL DEFAULT '0',
  `threads` int(11) NOT NULL DEFAULT '0',
  `fup` smallint(6) NOT NULL DEFAULT '0',
  `postperm` varchar(11) NOT NULL DEFAULT '0,0,0,0',
  `allowimgcode` char(3) NOT NULL DEFAULT '',
  `attachstatus` varchar(15) NOT NULL DEFAULT '',
  `password` varchar(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`fid`),
  KEY `fup` (`fup`),
  KEY `type` (`type`),
  KEY `displayorder` (`displayorder`),
  KEY `status` (`status`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]forums`
--

INSERT INTO `[[dbprefix]]forums` VALUES
('forum', 1, 'Default Forum', 'on', '', '', 0, 'This is the default forum created during installation<br />To create or modify forums go to the forum section of the administration panel', 'yes', 'yes', '', 0, 0, 0, 0, '31,31,31,63', 'yes', 'on', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]hold_attachments`
--

CREATE TABLE `[[dbprefix]]hold_attachments` (
  `aid` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT '0',
  `filename` varchar(120) NOT NULL DEFAULT '',
  `filetype` varchar(120) NOT NULL DEFAULT '',
  `filesize` varchar(120) NOT NULL DEFAULT '',
  `attachment` longblob NOT NULL,
  `downloads` int(11) NOT NULL DEFAULT '0',
  `img_size` varchar(9) NOT NULL,
  `parentid` int(11) NOT NULL DEFAULT '0',
  `subdir` varchar(15) NOT NULL,
  `uid` int(11) NOT NULL DEFAULT '0',
  `updatetime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`aid`),
  KEY `pid` (`pid`),
  KEY `parentid` (`parentid`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]hold_favorites`
--

CREATE TABLE `[[dbprefix]]hold_favorites` (
  `tid` int(11) NOT NULL DEFAULT '0',
  `username` varchar(32) NOT NULL DEFAULT '',
  `type` varchar(32) NOT NULL DEFAULT '',
  KEY `tid` (`tid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]hold_posts`
--

CREATE TABLE `[[dbprefix]]hold_posts` (
  `fid` smallint(6) NOT NULL DEFAULT '0',
  `tid` int(11) NOT NULL DEFAULT '0',
  `pid` int(11) NOT NULL AUTO_INCREMENT,
  `author` varchar(32) NOT NULL DEFAULT '',
  `message` text NOT NULL,
  `subject` tinytext NOT NULL,
  `dateline` int(11) NOT NULL DEFAULT '0',
  `icon` varchar(50) DEFAULT NULL,
  `usesig` varchar(15) NOT NULL DEFAULT '',
  `useip` varchar(39) NOT NULL DEFAULT '',
  `bbcodeoff` varchar(15) NOT NULL DEFAULT '',
  `smileyoff` varchar(15) NOT NULL DEFAULT '',
  `newtid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pid`),
  KEY `fid` (`fid`),
  KEY `dateline` (`dateline`),
  KEY `author` (`author`(8)),
  KEY `thread_optimize` (`tid`,`dateline`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]hold_threads`
--

CREATE TABLE `[[dbprefix]]hold_threads` (
  `tid` int(11) NOT NULL AUTO_INCREMENT,
  `fid` smallint(6) NOT NULL DEFAULT '0',
  `subject` varchar(128) NOT NULL DEFAULT '',
  `icon` varchar(75) NOT NULL DEFAULT '',
  `lastpost` varchar(54) NOT NULL DEFAULT '',
  `views` bigint(20) NOT NULL DEFAULT '0',
  `replies` int(11) NOT NULL DEFAULT '0',
  `author` varchar(32) NOT NULL DEFAULT '',
  `closed` varchar(15) NOT NULL DEFAULT '',
  `topped` tinyint(4) NOT NULL DEFAULT '0',
  `pollopts` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tid`),
  KEY `lastpost` (`lastpost`),
  KEY `author` (`author`(8)),
  KEY `closed` (`closed`),
  KEY `forum_optimize` (`fid`,`topped`,`lastpost`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]hold_vote_desc`
--

CREATE TABLE `[[dbprefix]]hold_vote_desc` (
  `vote_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `topic_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`vote_id`),
  KEY `topic_id` (`topic_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]hold_vote_results`
--

CREATE TABLE `[[dbprefix]]hold_vote_results` (
  `vote_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `vote_option_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `vote_option_text` varchar(255) NOT NULL DEFAULT '',
  `vote_result` int(11) NOT NULL DEFAULT '0',
  KEY `vote_option_id` (`vote_option_id`),
  KEY `vote_id` (`vote_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lang_base`
--

CREATE TABLE `[[dbprefix]]lang_base` (
  `langid` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `devname` varchar(20) NOT NULL,
  PRIMARY KEY (`langid`),
  UNIQUE KEY `devname` (`devname`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COMMENT='List of Installed Languages' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]lang_base`
--

INSERT INTO `[[dbprefix]]lang_base` VALUES
(1, 'English');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lang_keys`
--

CREATE TABLE `[[dbprefix]]lang_keys` (
  `phraseid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `langkey` varchar(30) NOT NULL,
  PRIMARY KEY (`phraseid`),
  UNIQUE KEY `langkey` (`langkey`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COMMENT='List of Translation Variables' AUTO_INCREMENT=1297 ;

--
-- Dumping data for table `[[dbprefix]]lang_keys`
--

INSERT INTO `[[dbprefix]]lang_keys` VALUES
(1, 'charset'),
(2, 'iso639'),
(3, 'language'),
(4, '4spaces'),
(5, 'addressname'),
(6, 'addressupdate'),
(7, 'addtime'),
(8, 'addtoaddresses'),
(9, 'addtobuddies'),
(10, 'add_buddy'),
(11, 'adminemail'),
(12, 'adminoption'),
(13, 'adminprofilechange'),
(14, 'adminverifyemail'),
(15, 'admin_edituseraccount'),
(16, 'admin_main_settings1'),
(17, 'admin_main_settings10'),
(18, 'admin_main_settings2'),
(19, 'admin_main_settings3'),
(20, 'admin_main_settings4'),
(21, 'admin_main_settings5'),
(22, 'admin_main_settings6'),
(23, 'admin_main_settings7'),
(24, 'admin_main_settings8'),
(25, 'admin_main_settings9'),
(26, 'admin_rename_fail'),
(27, 'admin_rename_success'),
(28, 'admin_rename_txt'),
(29, 'admin_rename_userfrom'),
(30, 'admin_rename_userto'),
(31, 'admin_rename_warn_self'),
(32, 'allowrankedit'),
(33, 'alreadyreg'),
(34, 'alreadyvoted'),
(35, 'altadmintools'),
(36, 'altavatar'),
(37, 'altboardlogo'),
(38, 'altclosedtopic'),
(39, 'alteditpost'),
(40, 'alteditsettings'),
(41, 'altemailuser'),
(42, 'altfaq'),
(43, 'altfindposts'),
(44, 'altfolder'),
(45, 'altgetip'),
(46, 'althotfolder'),
(47, 'althotredfolder'),
(48, 'altlastpost'),
(49, 'altmemberlist'),
(50, 'altmsnyes'),
(51, 'altnormalfolder'),
(52, 'altpollpercentage'),
(53, 'altpostmood'),
(54, 'altpostnewthread'),
(55, 'altquote'),
(56, 'altredfolder'),
(57, 'altreportpost'),
(58, 'altrules'),
(59, 'altsearch'),
(60, 'altstats'),
(61, 'alttodayposts'),
(62, 'alttopthread'),
(63, 'altu2umember'),
(64, 'altviewprofile'),
(65, 'altvisitsite'),
(66, 'analyze'),
(67, 'and'),
(68, 'anystatus'),
(69, 'asc'),
(70, 'attachimginpost'),
(71, 'attachmanwhereauthor'),
(72, 'attachmanwheredaysold'),
(73, 'attachmanwheredlcountgreater'),
(74, 'attachmanwheredlcountsmaller'),
(75, 'attachmanwhereforum'),
(76, 'attachmanwherename'),
(77, 'attachmanwheresizegreater'),
(78, 'attachmanwheresizesmaller'),
(79, 'attachmaxdims'),
(80, 'attachmaxsize'),
(81, 'attachmaxtotal'),
(82, 'attachment'),
(83, 'attachmentm'),
(84, 'attachments'),
(85, 'attachments_num_restored'),
(86, 'attachments_num_stored'),
(87, 'attachmore'),
(88, 'attachtoobig'),
(89, 'attach_delete_ays'),
(90, 'attach_delete_done'),
(91, 'autoinsertposticons'),
(92, 'autoinsertsmilies'),
(93, 'avatar_too_big'),
(94, 'aweek'),
(95, 'backto'),
(96, 'backtovote'),
(97, 'backup_tools'),
(98, 'bademail'),
(99, 'badinfo'),
(100, 'badname'),
(101, 'badrcpt'),
(102, 'bad_request'),
(103, 'bad_token'),
(104, 'banboth'),
(105, 'bannedmessage'),
(106, 'banpost'),
(107, 'banu2u'),
(108, 'bbcodeinfo'),
(109, 'bbcodeoff'),
(110, 'bbcode_advmode'),
(111, 'bbcode_helpmode'),
(112, 'bbcode_help_bold'),
(113, 'bbcode_help_center'),
(114, 'bbcode_help_code'),
(115, 'bbcode_help_color'),
(116, 'bbcode_help_email'),
(117, 'bbcode_help_font'),
(118, 'bbcode_help_image'),
(119, 'bbcode_help_italic'),
(120, 'bbcode_help_link'),
(121, 'bbcode_help_list'),
(122, 'bbcode_help_quote'),
(123, 'bbcode_help_size'),
(124, 'bbcode_help_underline'),
(125, 'bbcode_help_youtube'),
(126, 'bbcode_normode'),
(127, 'bbcode_prompt_bold'),
(128, 'bbcode_prompt_center'),
(129, 'bbcode_prompt_code'),
(130, 'bbcode_prompt_color'),
(131, 'bbcode_prompt_email_desc'),
(132, 'bbcode_prompt_email_email'),
(133, 'bbcode_prompt_email_error'),
(134, 'bbcode_prompt_font'),
(135, 'bbcode_prompt_image'),
(136, 'bbcode_prompt_italic'),
(137, 'bbcode_prompt_link_desc'),
(138, 'bbcode_prompt_link_url'),
(139, 'bbcode_prompt_link_url_error'),
(140, 'bbcode_prompt_list_end'),
(141, 'bbcode_prompt_list_error'),
(142, 'bbcode_prompt_list_item'),
(143, 'bbcode_prompt_list_start'),
(144, 'bbcode_prompt_quote'),
(145, 'bbcode_prompt_size'),
(146, 'bbcode_prompt_underline'),
(147, 'bbcode_prompt_youtube'),
(148, 'bbinsert'),
(149, 'bbname'),
(150, 'beenfound'),
(151, 'beginning'),
(152, 'buddyaddedmsg'),
(153, 'buddyalreadyonlist'),
(154, 'buddylistupdated'),
(155, 'buddywarnaddself'),
(156, 'bumpthreadmsg'),
(157, 'byte'),
(158, 'cannotmergesamethread'),
(159, 'cantsplit'),
(160, 'cantthreadprune'),
(161, 'captchacaseon'),
(162, 'captchacharset'),
(163, 'captchacodecase'),
(164, 'captchacodelength'),
(165, 'captchacodeshadow'),
(166, 'captchaimagebg'),
(167, 'captchaimagecolor'),
(168, 'captchaimagedots'),
(169, 'captchaimagefonts'),
(170, 'captchaimageheight'),
(171, 'captchaimageinvalid'),
(172, 'captchaimagelines'),
(173, 'captchaimagemaxfont'),
(174, 'captchaimageminfont'),
(175, 'captchaimagetype'),
(176, 'captchaimagewidth'),
(177, 'captchaindebug'),
(178, 'captchapoststatus'),
(179, 'captcharegstatus'),
(180, 'captchasearchstatus'),
(181, 'captchastatus'),
(182, 'captchaverification'),
(183, 'cb_advmode'),
(184, 'cb_fomatting'),
(185, 'cb_helpmode'),
(186, 'cb_insert_bold'),
(187, 'cb_insert_centered'),
(188, 'cb_insert_code'),
(189, 'cb_insert_email'),
(190, 'cb_insert_hyperlink'),
(191, 'cb_insert_image'),
(192, 'cb_insert_italics'),
(193, 'cb_insert_list'),
(194, 'cb_insert_quote'),
(195, 'cb_insert_underlined'),
(196, 'cb_insert_youtube'),
(197, 'cb_normalmode'),
(198, 'censorupdate'),
(199, 'checkall'),
(200, 'checkspelling'),
(201, 'closedmsg'),
(202, 'closemsgques'),
(203, 'closethreadmsg'),
(204, 'complete_threadprune'),
(205, 'confirmDeletePosts'),
(206, 'confirmDeleteUser'),
(207, 'continue_button'),
(208, 'cookies_disabled'),
(209, 'coppastatus'),
(210, 'coppa_directions'),
(211, 'coppa_explained'),
(212, 'coppa_fail'),
(213, 'coppa_title'),
(214, 'copythread'),
(215, 'copythreadmsg'),
(216, 'copythreadto'),
(217, 'cprestricted'),
(218, 'cpsearch'),
(219, 'cpwodump'),
(220, 'cp_deleteposts'),
(221, 'cp_subscription'),
(222, 'currentip'),
(223, 'dateformat'),
(224, 'day1'),
(225, 'day100'),
(226, 'day15'),
(227, 'day30'),
(228, 'day5'),
(229, 'day60'),
(230, 'daysold'),
(231, 'db_backup'),
(232, 'defaultTimezoneDesc'),
(233, 'deleteaborted'),
(234, 'deletebutton'),
(235, 'deletecolon'),
(236, 'deletecurrent'),
(237, 'deletethread'),
(238, 'deletethreadmsg'),
(239, 'delete_all_themes'),
(240, 'desc'),
(241, 'developedby'),
(242, 'devices'),
(243, 'devices_category'),
(244, 'device_agent_hdr'),
(245, 'device_delete_btn'),
(246, 'device_id_hdr'),
(247, 'device_login_date'),
(248, 'device_this'),
(249, 'dotfolders'),
(250, 'doublee'),
(251, 'dump_attachments'),
(252, 'editbuddylist'),
(253, 'editedby'),
(254, 'editpostmsg'),
(255, 'editprofile_backtocp'),
(256, 'editprofile_lastlogin'),
(257, 'editprofile_lockout'),
(258, 'editprofile_loginfaildate'),
(259, 'editprofile_loginfails'),
(260, 'editprofile_minfo'),
(261, 'editprofile_postsdeleted'),
(262, 'editprofile_regdate'),
(263, 'editprofile_regip'),
(264, 'editprofile_sessfaildate'),
(265, 'editprofile_sessfails'),
(266, 'editprofile_userid'),
(267, 'editprosearch'),
(268, 'emailpw'),
(269, 'emailrestricted'),
(270, 'emailverify'),
(271, 'emptythreadmsg'),
(272, 'Enable_Page_load'),
(273, 'Enable_PHP_SQL'),
(274, 'Enable_Queries'),
(275, 'Enable_Server_Load'),
(276, 'error'),
(277, 'errormovingthreads'),
(278, 'evalbestmember'),
(279, 'evalindexstats'),
(280, 'evalipmask'),
(281, 'evalnobestmember'),
(282, 'evaloffset'),
(283, 'evalstats1'),
(284, 'evalstats10'),
(285, 'evalstats11'),
(286, 'evalstats12'),
(287, 'evalstats13'),
(288, 'evalstats14'),
(289, 'evalstats15'),
(290, 'evalstats2'),
(291, 'evalstats3'),
(292, 'evalstats4'),
(293, 'evalstats5'),
(294, 'evalstats6'),
(295, 'evalstats7'),
(296, 'evalstats8'),
(297, 'evalstats9'),
(298, 'evaltrevlt'),
(299, 'evalu2ustaffquota'),
(300, 'evaluqinfo'),
(301, 'evaluqinfo_over'),
(302, 'evalusercpwelcome'),
(303, 'existingip'),
(304, 'export_fid_expl'),
(305, 'export_fid_not_there'),
(306, 'export_tid_expl'),
(307, 'export_tid_not_there'),
(308, 'favaddedmsg'),
(309, 'favonlistmsg'),
(310, 'favsdeletedmsg'),
(311, 'featurewarning'),
(312, 'filecorrupt'),
(313, 'fileuploaderror1'),
(314, 'fileuploaderror2'),
(315, 'fileuploaderror3'),
(316, 'fileuploaderror4'),
(317, 'fileuploaderror5'),
(318, 'fileuploaderror6'),
(319, 'fileuploaderror7'),
(320, 'fileuploaderror8'),
(321, 'floodprotect'),
(322, 'floodprotect_u2u'),
(323, 'fnasorry'),
(324, 'fnasorry2'),
(325, 'fnasorry3'),
(326, 'folderlist'),
(327, 'foldermsg'),
(328, 'foldersupdate'),
(329, 'foldersupdateerror'),
(330, 'footer_options'),
(331, 'forgotpw'),
(332, 'forumjumpselect'),
(333, 'forumnotempty'),
(334, 'forumpermissions'),
(335, 'forumpruned'),
(336, 'forumpw'),
(337, 'forumpwinfo'),
(338, 'found'),
(339, 'general'),
(340, 'generic_file'),
(341, 'generic_missing'),
(342, 'google_captcha_directions'),
(343, 'google_captcha_fail'),
(344, 'google_captcha_onoff'),
(345, 'google_captcha_secretkey'),
(346, 'google_captcha_sitekey'),
(347, 'gotobottom'),
(348, 'gototop'),
(349, 'guestpostingonmsg'),
(350, 'gzipcompression'),
(351, 'helpbar'),
(352, 'hidden'),
(353, 'hide_banned_users'),
(354, 'hottopiceval'),
(355, 'ignorelist'),
(356, 'ignoremsg'),
(357, 'ignoreupdate'),
(358, 'images_https_only'),
(359, 'imdeletedmsg'),
(360, 'imgdir'),
(361, 'imgdiradm'),
(362, 'impossiblebanall'),
(363, 'imsavedmsg'),
(364, 'imsentmsg'),
(365, 'indexShowBarCats'),
(366, 'indexShowBarDesc'),
(367, 'indexShowBarNone'),
(368, 'indexShowBarTop'),
(369, 'index_stats'),
(370, 'insertdata'),
(371, 'invalidFilename'),
(372, 'invalidforumpw'),
(373, 'invalidip'),
(374, 'invalidtid'),
(375, 'invertselection'),
(376, 'ipbandisable'),
(377, 'ipbanenable'),
(378, 'ipreg'),
(379, 'ipwarning'),
(380, 'key'),
(381, 'langimportfail'),
(382, 'langimportsuccess'),
(383, 'last50todayeval'),
(384, 'lastactive'),
(385, 'lastreply1'),
(386, 'lastsadmin'),
(387, 'lastyear'),
(388, 'launchbuddylist'),
(389, 'leaveuntouched'),
(390, 'location'),
(391, 'locktopic'),
(392, 'loggedin'),
(393, 'loggedinuser'),
(394, 'login_audit_mail'),
(395, 'login_lockout'),
(396, 'login_trusted'),
(397, 'logs'),
(398, 'logsdump_confirm'),
(399, 'look_feel'),
(400, 'lostpw_bad_token'),
(401, 'lostpw_body_eval'),
(402, 'lostpw_in24hrs'),
(403, 'lostpw_success'),
(404, 'lpoststats'),
(405, 'max_addresses_per_entry'),
(406, 'max_attachment_size'),
(407, 'max_avatar_size_h'),
(408, 'max_avatar_size_w'),
(409, 'max_daily_regs'),
(410, 'max_onlinetodaycount'),
(411, 'max_regs'),
(412, 'mcpread'),
(413, 'mcpuid'),
(414, 'memberisoff'),
(415, 'memberison'),
(416, 'memcpmood'),
(417, 'memcp_otherinfo'),
(418, 'memcp_otheroptions'),
(419, 'memposts'),
(420, 'mergethreadmsg'),
(421, 'mergewithmsg'),
(422, 'message'),
(423, 'misconlinetoday'),
(424, 'misconlinetoday2'),
(425, 'moderation_actions'),
(426, 'moderation_anonq'),
(427, 'moderation_approve'),
(428, 'moderation_approved'),
(429, 'moderation_approve_all'),
(430, 'moderation_ays_appr'),
(431, 'moderation_ays_dele'),
(432, 'moderation_canceled'),
(433, 'moderation_delete'),
(434, 'moderation_deleted'),
(435, 'moderation_delete_all'),
(436, 'moderation_delete_ban'),
(437, 'moderation_empty'),
(438, 'moderation_hold'),
(439, 'moderation_meta_name'),
(440, 'moderation_new_member'),
(441, 'moderation_new_memq'),
(442, 'moderation_new_replies'),
(443, 'moderation_new_threads'),
(444, 'moderation_notice_eval'),
(445, 'moderation_notice_single'),
(446, 'moderation_replies_eval'),
(447, 'moderation_replies_single'),
(448, 'moderation_setting'),
(449, 'moderation_threads_eval'),
(450, 'moderation_threads_single'),
(451, 'modlog_bump'),
(452, 'modlog_close'),
(453, 'modlog_copy'),
(454, 'modlog_empty'),
(455, 'modlog_merge'),
(456, 'modlog_move'),
(457, 'modlog_open'),
(458, 'modlog_split'),
(459, 'modlog_threadprune'),
(460, 'modlog_top'),
(461, 'modlog_untop'),
(462, 'month1'),
(463, 'month3'),
(464, 'month6'),
(465, 'mood'),
(466, 'moresmilies'),
(467, 'moved'),
(468, 'moveques'),
(469, 'movethreadmsg'),
(470, 'movetodb'),
(471, 'movetodb_done'),
(472, 'movetodisk'),
(473, 'movetodisk_done'),
(474, 'multipnote'),
(475, 'multmodnote'),
(476, 'mysql_tools'),
(477, 'navstats'),
(478, 'navtodaysposts'),
(479, 'newposts'),
(480, 'newrestriction'),
(481, 'newrestrictionwhy'),
(482, 'newslettersubmit'),
(483, 'newsreccopy'),
(484, 'newsubject'),
(485, 'newswait'),
(486, 'newtemplate'),
(487, 'newu2u1'),
(488, 'newu2u2'),
(489, 'nextsearch'),
(490, 'noadminsession'),
(491, 'noadminsession2'),
(492, 'noadminsession3'),
(493, 'noadminsession4'),
(494, 'noban'),
(495, 'nobuddyselected'),
(496, 'noedit'),
(497, 'nofavsmsg'),
(498, 'nomember'),
(499, 'nomoodtext'),
(500, 'nonewposts'),
(501, 'noposts'),
(502, 'noPostsTimePeriod'),
(503, 'nopoststoday'),
(504, 'nopruneforums'),
(505, 'noresults'),
(506, 'nosearchq'),
(507, 'nosubmsg'),
(508, 'nothingfound'),
(509, 'notifyonreg'),
(510, 'notloggedin'),
(511, 'notpermitted'),
(512, 'nou2umsg'),
(513, 'no_buddies'),
(514, 'no_poll'),
(515, 'no_templates'),
(516, 'no_url_fopen'),
(517, 'numberusing'),
(518, 'onlinebuddy'),
(519, 'onlinebuddyadd'),
(520, 'onlinebuddyadd2u2u'),
(521, 'onlinebuddydelete'),
(522, 'onlinebuddyedit'),
(523, 'onlinecatunknown'),
(524, 'onlinecoppa'),
(525, 'onlinecp'),
(526, 'onlineeditnoprofile'),
(527, 'onlineeditprofile'),
(528, 'onlinefaq'),
(529, 'onlineforumdisplay'),
(530, 'onlineindex'),
(531, 'onlinelogin'),
(532, 'onlinelogout'),
(533, 'onlinelostpw'),
(534, 'onlinemanagefolders'),
(535, 'onlinememcp'),
(536, 'onlinememcpfav'),
(537, 'onlinememcppro'),
(538, 'onlinememcpsub'),
(539, 'onlinememlist'),
(540, 'onlinenoforum'),
(541, 'onlinenoprofile'),
(542, 'onlinenothread'),
(543, 'onlineonlinetoday'),
(544, 'onlineother'),
(545, 'onlinepostedit'),
(546, 'onlinepostnewthread'),
(547, 'onlinepostreply'),
(548, 'onlinereg'),
(549, 'onlinereport'),
(550, 'onlinesearch'),
(551, 'onlinestats'),
(552, 'onlinetodaysposts'),
(553, 'onlinetoday_status'),
(554, 'onlinetools'),
(555, 'onlinetopicadmin'),
(556, 'onlineu2udelete'),
(557, 'onlineu2uignore'),
(558, 'onlineu2uint'),
(559, 'onlineu2usend'),
(560, 'onlineu2uview'),
(561, 'onlineunknown'),
(562, 'onlineviewcat'),
(563, 'onlineviewpro'),
(564, 'onlineviewthread'),
(565, 'onlinevote'),
(566, 'onlinewhosonline'),
(567, 'opennew'),
(568, 'opentopic'),
(569, 'optimize'),
(570, 'optional'),
(571, 'origpostedby'),
(572, 'o_attachments_found'),
(573, 'o_attach_submit'),
(574, 'o_polls_found'),
(575, 'o_poll_submit'),
(576, 'o_posts_found'),
(577, 'o_threads_found'),
(578, 'parenopt'),
(579, 'piconexists'),
(580, 'picons'),
(581, 'piconshlp'),
(582, 'plaintext'),
(583, 'plogtuf'),
(584, 'poll'),
(585, 'pollanswers'),
(586, 'pollprefix'),
(587, 'polls'),
(588, 'pollvotenotselected'),
(589, 'posticonsadded'),
(590, 'postip'),
(591, 'postmsg'),
(592, 'postnothing'),
(593, 'postpermerr'),
(594, 'postpoll'),
(595, 'postword'),
(596, 'privforummsg'),
(597, 'profileword'),
(598, 'pruneby'),
(599, 'pruneclosed'),
(600, 'pruneexactly'),
(601, 'prunefids'),
(602, 'prunefrom'),
(603, 'prunelessthan'),
(604, 'prunemorethan'),
(605, 'prunenormal'),
(606, 'pruneposttypes'),
(607, 'prunetopped'),
(608, 'pruneusers'),
(609, 'pspell_needed'),
(610, 'pwchange'),
(611, 'pwnomatch'),
(612, 'pwnote'),
(613, 'queries'),
(614, 'quickjump_status'),
(615, 'quickreply'),
(616, 'quickreply_status'),
(617, 'rankinfo'),
(618, 'rankingsupdate'),
(619, 'raw_mysql'),
(620, 'reason'),
(621, 'refreshbuddylist'),
(622, 'refreshpage'),
(623, 'regeneratethumbnail'),
(624, 'regged'),
(625, 'reggedonly'),
(626, 'registerrulestitle'),
(627, 'regoptional'),
(628, 'regques'),
(629, 'reg_on'),
(630, 'reg_today'),
(631, 'renamefile'),
(632, 'repair'),
(633, 'replace'),
(634, 'replacedby'),
(635, 'replies'),
(636, 'replymsg'),
(637, 'reportmessage'),
(638, 'reportmsg'),
(639, 'reportpoststatus'),
(640, 'reportsubject'),
(641, 'required'),
(642, 'resetSigDesc'),
(643, 'restore_attachments'),
(644, 'restricted'),
(645, 'restrictedname'),
(646, 'restrictedupdate'),
(647, 'rulesoninfo'),
(648, 'searchbody'),
(649, 'searchguesterror'),
(650, 'searchinvalid'),
(651, 'searchsubject'),
(652, 'searchusermsg'),
(653, 'search_advanced'),
(654, 'secure_login'),
(655, 'security_subject'),
(656, 'selecttemplate'),
(657, 'seperatebycomma'),
(658, 'showsubforums'),
(659, 'showtopics'),
(660, 'show_logs_in_threads'),
(661, 'sigbbcode'),
(662, 'sightml'),
(663, 'smcols'),
(664, 'smdir'),
(665, 'smileyinsert'),
(666, 'smilieexists'),
(667, 'smiliepreview'),
(668, 'smilies'),
(669, 'smiliesadded'),
(670, 'smilieupdate'),
(671, 'smtotal'),
(672, 'sortby'),
(673, 'space_cats'),
(674, 'spellingchecker'),
(675, 'spellingcomplete'),
(676, 'spell_checker'),
(677, 'splitthreadmsg'),
(678, 'srchbyforum'),
(679, 'srchfilter_double'),
(680, 'startticker'),
(681, 'statistics'),
(682, 'stats4'),
(683, 'stats_incomplete'),
(684, 'status'),
(685, 'stopticker'),
(686, 'subaddedmsg'),
(687, 'subdefault'),
(688, 'subjectInTitle'),
(689, 'submitvote'),
(690, 'subonlistmsg'),
(691, 'subsdeletedmsg'),
(692, 'superadmin'),
(693, 'superadminonly'),
(694, 'templatedelconfirm'),
(695, 'templateempty'),
(696, 'templateexists'),
(697, 'templatename'),
(698, 'templaterestoreconfirm'),
(699, 'templates'),
(700, 'templatesdelete'),
(701, 'templatesrestoredone'),
(702, 'templatesupdate'),
(703, 'testnothingchos'),
(704, 'text12hour'),
(705, 'text24hour'),
(706, 'textadd2u2u'),
(707, 'textadded'),
(708, 'textaddfav'),
(709, 'textadmin'),
(710, 'textadminoptions'),
(711, 'textagree'),
(712, 'textaim'),
(713, 'textall'),
(714, 'textallforumsandsubs'),
(715, 'textallow'),
(716, 'textallowavatars'),
(717, 'textalpha'),
(718, 'textaltbg1'),
(719, 'textaltbg2'),
(720, 'textanonymous'),
(721, 'textanonymousposting'),
(722, 'textapr'),
(723, 'textat'),
(724, 'textattachedimg'),
(725, 'textattachman'),
(726, 'textattachmentsupdate'),
(727, 'textattachsearchresults'),
(728, 'textaug'),
(729, 'textauthor'),
(730, 'textavastatus'),
(731, 'textavatar'),
(732, 'textavatarurl'),
(733, 'textaverages'),
(734, 'textbanfrom'),
(735, 'textbanfrompost'),
(736, 'textbanfromu2u'),
(737, 'textbanip'),
(738, 'textbanned'),
(739, 'textbannedip'),
(740, 'textbbcode'),
(741, 'textbbcodeis'),
(742, 'textbboffreason'),
(743, 'textbbrules'),
(744, 'textbbrulestxt'),
(745, 'textbday'),
(746, 'textbgcolor'),
(747, 'textbigsize'),
(748, 'textbio'),
(749, 'textboardlogo'),
(750, 'textboardurl'),
(751, 'textborder'),
(752, 'textborderwidth'),
(753, 'textbriefsummary'),
(754, 'textbstatus'),
(755, 'textbstatusdefault'),
(756, 'textbuddylist'),
(757, 'textbumpthread'),
(758, 'textby'),
(759, 'textcantmove'),
(760, 'textcatcolor'),
(761, 'textcatsonly'),
(762, 'textcattextcolor'),
(763, 'textcensorfind'),
(764, 'textcensorreplace'),
(765, 'textcensors'),
(766, 'textcheck'),
(767, 'textclosethread'),
(768, 'textcode'),
(769, 'textcp'),
(770, 'textcplogs'),
(771, 'textcusstatus'),
(772, 'textdec'),
(773, 'textdelete'),
(774, 'textdeleteposts'),
(775, 'textdeleteques'),
(776, 'textdeleteselectedfavs'),
(777, 'textdeleteselectedsubs'),
(778, 'textdeletethread'),
(779, 'textdesc'),
(780, 'textdetails'),
(781, 'textdissmileys'),
(782, 'textdownload'),
(783, 'textdownloadcount1'),
(784, 'textdownloadcount2'),
(785, 'textdownloads'),
(786, 'textdownloadtemps'),
(787, 'textedit'),
(788, 'textediton'),
(789, 'texteditpost'),
(790, 'texteditpro'),
(791, 'textemail'),
(792, 'textemailnotify'),
(793, 'textemailonu2u'),
(794, 'textemptyquery'),
(795, 'textemptythread'),
(796, 'textemptytrash'),
(797, 'textfaq'),
(798, 'textfaq1'),
(799, 'textfaq10'),
(800, 'textfaq11'),
(801, 'textfaq12'),
(802, 'textfaq13'),
(803, 'textfaq14'),
(804, 'textfaq15'),
(805, 'textfaq16'),
(806, 'textfaq17'),
(807, 'textfaq18'),
(808, 'textfaq19'),
(809, 'textfaq2'),
(810, 'textfaq20'),
(811, 'textfaq21'),
(812, 'textfaq3'),
(813, 'textfaq4'),
(814, 'textfaq5'),
(815, 'textfaq6'),
(816, 'textfaq7'),
(817, 'textfaq8'),
(818, 'textfaq9'),
(819, 'textfaqans1'),
(820, 'textfaqans10'),
(821, 'textfaqans11'),
(822, 'textfaqans12'),
(823, 'textfaqans13'),
(824, 'textfaqans14'),
(825, 'textfaqans15'),
(826, 'textfaqans16'),
(827, 'textfaqans17'),
(828, 'textfaqans19'),
(829, 'textfaqans2'),
(830, 'textfaqans21'),
(831, 'textfaqans3'),
(832, 'textfaqans4'),
(833, 'textfaqans5'),
(834, 'textfaqans6'),
(835, 'textfaqans7'),
(836, 'textfaqans8'),
(837, 'textfaqans9'),
(838, 'textfaqextra'),
(839, 'textfaqstatus'),
(840, 'textfavorites'),
(841, 'textfeb'),
(842, 'textfilename'),
(843, 'textfilesbase'),
(844, 'textfilesize'),
(845, 'textfilesminsize'),
(846, 'textfilespath'),
(847, 'textfilesperpost'),
(848, 'textfilessizeh'),
(849, 'textfilessizew'),
(850, 'textfilessubdir'),
(851, 'textfilessubdir1'),
(852, 'textfilessubdir2'),
(853, 'textfilesthumbh'),
(854, 'textfilesthumbw'),
(855, 'textfilesurlpath'),
(856, 'textfilesurlpath1'),
(857, 'textfilesurlpath2'),
(858, 'textfilesurlpath3'),
(859, 'textfilesurlpath4'),
(860, 'textfilesurlpath5'),
(861, 'textfixlastposts'),
(862, 'textfixmemposts'),
(863, 'textfixmoods'),
(864, 'textfixoattachments'),
(865, 'textfixopolls'),
(866, 'textfixoposts'),
(867, 'textfixothreads'),
(868, 'textfixposts'),
(869, 'textfixthread'),
(870, 'textflood'),
(871, 'textfolders'),
(872, 'textfont'),
(873, 'textforum'),
(874, 'textforumname'),
(875, 'textforumopts'),
(876, 'textforums'),
(877, 'textforumupdate'),
(878, 'textforward'),
(879, 'textforwardu2utoemail'),
(880, 'textfrom'),
(881, 'textfwd'),
(882, 'textgetip'),
(883, 'textgetnews'),
(884, 'textgo'),
(885, 'textguest1'),
(886, 'textguests'),
(887, 'textheader'),
(888, 'textheadertext'),
(889, 'texthemename'),
(890, 'texthidepriv'),
(891, 'texthmem'),
(892, 'texthmems'),
(893, 'texthottopic'),
(894, 'texthtml'),
(895, 'texthtmlis'),
(896, 'texticon'),
(897, 'texticq'),
(898, 'textillegalquery'),
(899, 'textimgcode'),
(900, 'textimgcodeis'),
(901, 'textimporttheme'),
(902, 'textinforum'),
(903, 'textinthread'),
(904, 'textinvisible'),
(905, 'textip'),
(906, 'textipaddress'),
(907, 'textipban'),
(908, 'textipresolve'),
(909, 'textipupdate'),
(910, 'textjan'),
(911, 'textjul'),
(912, 'textjun'),
(913, 'textlanguage'),
(914, 'textlastpost'),
(915, 'textlatestfavs'),
(916, 'textlatestu2us'),
(917, 'textlfrom'),
(918, 'textlink'),
(919, 'textlist'),
(920, 'textlocation'),
(921, 'textloggedinas'),
(922, 'textlogin'),
(923, 'textlogin_incorrect'),
(924, 'textlogout'),
(925, 'textlogsdump'),
(926, 'textlostpw'),
(927, 'textlostpwnote'),
(928, 'textlostpwnote2'),
(929, 'textmanagefolders'),
(930, 'textmar'),
(931, 'textmarkedunread'),
(932, 'textmay'),
(933, 'textmem'),
(934, 'textmemberlist'),
(935, 'textmembers'),
(936, 'textmemberstoday'),
(937, 'textmembersupdate'),
(938, 'textmembertoday'),
(939, 'textmemliststatus'),
(940, 'textmergethread'),
(941, 'textmesperday'),
(942, 'textmessage'),
(943, 'textminilogout'),
(944, 'textmod'),
(945, 'textmodby'),
(946, 'textmoderator'),
(947, 'textmodlogs'),
(948, 'textmods'),
(949, 'textmodupdate'),
(950, 'textmoreopts'),
(951, 'textmovemethod'),
(952, 'textmovemethod1'),
(953, 'textmovemethod2'),
(954, 'textmovesucc'),
(955, 'textmoveto'),
(956, 'textmpp'),
(957, 'textmsn'),
(958, 'textmyhome'),
(959, 'textnever'),
(960, 'textnewcode'),
(961, 'textnewforum'),
(962, 'textnewgroup'),
(963, 'textnewip'),
(964, 'textnewmember'),
(965, 'textnewmember2'),
(966, 'textnewpassword'),
(967, 'textnewpicon'),
(968, 'textnewpoll'),
(969, 'textnewrank'),
(970, 'textnewsletter'),
(971, 'textnewsmilie'),
(972, 'textnewsubf'),
(973, 'textnewtheme'),
(974, 'textnewu2ubody'),
(975, 'textnewu2uemail'),
(976, 'textno'),
(977, 'textnoaction'),
(978, 'textnocat'),
(979, 'textnofolder'),
(980, 'textnoforum'),
(981, 'textnoforumsexist'),
(982, 'textnoguestposting'),
(983, 'textnomur'),
(984, 'textnone'),
(985, 'textnonechosen'),
(986, 'textnopassword'),
(987, 'textnopostsyet'),
(988, 'textnosub'),
(989, 'textnosubject'),
(990, 'textnothread'),
(991, 'textnousername'),
(992, 'textnov'),
(993, 'textoct'),
(994, 'textoff'),
(995, 'textoffline'),
(996, 'textoftotposts'),
(997, 'textoldpassword'),
(998, 'texton'),
(999, 'textonline'),
(1000, 'textopenthread'),
(1001, 'textoptions'),
(1002, 'textor'),
(1003, 'textorder'),
(1004, 'textpages'),
(1005, 'textpassword'),
(1006, 'textpasswordcf'),
(1007, 'textpendinglogin'),
(1008, 'textpermission1'),
(1009, 'textpermission2'),
(1010, 'textpermission3'),
(1011, 'textpermission41'),
(1012, 'textpermission42'),
(1013, 'textpersonalfeat'),
(1014, 'textphp'),
(1015, 'textpickfolder'),
(1016, 'textpoll'),
(1017, 'textpost'),
(1018, 'textpostnew'),
(1019, 'textpostnum'),
(1020, 'textposton'),
(1021, 'textpostread'),
(1022, 'textpostreply'),
(1023, 'textposts'),
(1024, 'textpowered'),
(1025, 'textppp'),
(1026, 'textpreview'),
(1027, 'textpreviewu2u'),
(1028, 'textprintver'),
(1029, 'textprofforumma'),
(1030, 'textproflastpost'),
(1031, 'textprofor'),
(1032, 'textprune'),
(1033, 'textprunethread'),
(1034, 'textpw1'),
(1035, 'textpw2'),
(1036, 'textpwincorrect'),
(1037, 'textquote'),
(1038, 'textre'),
(1039, 'textread'),
(1040, 'textreason'),
(1041, 'textregdate'),
(1042, 'textreggedonly'),
(1043, 'textregister'),
(1044, 'textregistered'),
(1045, 'textremoteimages'),
(1046, 'textreplies'),
(1047, 'textreply'),
(1048, 'textreplytrash'),
(1049, 'textreportpost'),
(1050, 'textrestoredeftemps'),
(1051, 'textretypepw'),
(1052, 'textsaveog'),
(1053, 'textsaveu2u'),
(1054, 'textsearch'),
(1055, 'textsearchfor'),
(1056, 'textsearchstatus'),
(1057, 'textseconds'),
(1058, 'textselectu2u'),
(1059, 'textsendadmin'),
(1060, 'textsendall'),
(1061, 'textsendmod'),
(1062, 'textsendstaff'),
(1063, 'textsendsupermod'),
(1064, 'textsendto'),
(1065, 'textsendu2u'),
(1066, 'textsendvia'),
(1067, 'textsent'),
(1068, 'textsep'),
(1069, 'textserverload'),
(1070, 'textsettings'),
(1071, 'textsettingsupdate'),
(1072, 'textshowemail'),
(1073, 'textsig'),
(1074, 'textsite'),
(1075, 'textsitename'),
(1076, 'textsiteurl'),
(1077, 'textsmiliecode'),
(1078, 'textsmiliefile'),
(1079, 'textsmilies'),
(1080, 'textsmiliesare'),
(1081, 'textsortby'),
(1082, 'textspace'),
(1083, 'textsplitthread'),
(1084, 'textsql'),
(1085, 'textsrchemail'),
(1086, 'textsrchip'),
(1087, 'textsrchuname'),
(1088, 'textsrchusr'),
(1089, 'textstars'),
(1090, 'textstats'),
(1091, 'textstatsstatus'),
(1092, 'textstatus'),
(1093, 'textsubbody'),
(1094, 'textsubforums'),
(1095, 'textsubject'),
(1096, 'textsubmit'),
(1097, 'textsubmitchanges'),
(1098, 'textsubscribe'),
(1099, 'textsubscriptions'),
(1100, 'textsubsubject'),
(1101, 'textsupermod'),
(1102, 'texttabletext'),
(1103, 'texttext'),
(1104, 'texttheme'),
(1105, 'textthemefile'),
(1106, 'textthemeimportfail'),
(1107, 'textthemeimportsuccess'),
(1108, 'textthemename'),
(1109, 'texttime'),
(1110, 'texttimeformat'),
(1111, 'textto'),
(1112, 'texttodaystatus'),
(1113, 'texttop'),
(1114, 'texttopicreview'),
(1115, 'texttopics'),
(1116, 'texttopthread'),
(1117, 'texttpp'),
(1118, 'texttrashemptied'),
(1119, 'textu2u'),
(1120, 'textu2uaddressbook'),
(1121, 'textu2udrafts'),
(1122, 'textu2ufolder'),
(1123, 'textu2uinbox'),
(1124, 'textu2uincoming'),
(1125, 'textu2umarkunread'),
(1126, 'textu2umessenger'),
(1127, 'textu2umoveto'),
(1128, 'textu2unonefound'),
(1129, 'textu2unotsent'),
(1130, 'textu2uoptions'),
(1131, 'textu2uoutbox'),
(1132, 'textu2uoutgoing'),
(1133, 'textu2uprevsaved'),
(1134, 'textu2usavedon'),
(1135, 'textu2utoemail'),
(1136, 'textu2utoemailsent'),
(1137, 'textu2utrash'),
(1138, 'textunbanip'),
(1139, 'textunread'),
(1140, 'textunregistered'),
(1141, 'textuntopthread'),
(1142, 'textupgrade'),
(1143, 'textuseboa'),
(1144, 'textusedefault'),
(1145, 'textuseoldu2u'),
(1146, 'textusercp'),
(1147, 'textuserlist'),
(1148, 'textuserman'),
(1149, 'textusername'),
(1150, 'textuserranks'),
(1151, 'textusesig'),
(1152, 'textviewpro'),
(1153, 'textviews'),
(1154, 'textvote'),
(1155, 'textwidth'),
(1156, 'textwithstatus'),
(1157, 'textyahoo'),
(1158, 'textyes'),
(1159, 'textyesip'),
(1160, 'textyourpw'),
(1161, 'textyourpwis'),
(1162, 'themes'),
(1163, 'themeupdate'),
(1164, 'theme_already_exists'),
(1165, 'threads'),
(1166, 'thumbnail'),
(1167, 'th_action'),
(1168, 'th_ip'),
(1169, 'th_time'),
(1170, 'th_url'),
(1171, 'th_username'),
(1172, 'tickercode'),
(1173, 'tickercontents'),
(1174, 'tickername'),
(1175, 'timemsg'),
(1176, 'timezone1'),
(1177, 'timezone10'),
(1178, 'timezone11'),
(1179, 'timezone12'),
(1180, 'timezone13'),
(1181, 'timezone14'),
(1182, 'timezone15'),
(1183, 'timezone16'),
(1184, 'timezone17'),
(1185, 'timezone18'),
(1186, 'timezone19'),
(1187, 'timezone2'),
(1188, 'timezone20'),
(1189, 'timezone21'),
(1190, 'timezone22'),
(1191, 'timezone23'),
(1192, 'timezone24'),
(1193, 'timezone25'),
(1194, 'timezone26'),
(1195, 'timezone27'),
(1196, 'timezone28'),
(1197, 'timezone29'),
(1198, 'timezone3'),
(1199, 'timezone30'),
(1200, 'timezone31'),
(1201, 'timezone32'),
(1202, 'timezone33'),
(1203, 'timezone34'),
(1204, 'timezone35'),
(1205, 'timezone36'),
(1206, 'timezone37'),
(1207, 'timezone4'),
(1208, 'timezone5'),
(1209, 'timezone6'),
(1210, 'timezone7'),
(1211, 'timezone8'),
(1212, 'timezone9'),
(1213, 'tocont'),
(1214, 'todaydays'),
(1215, 'todaygo'),
(1216, 'todayshow'),
(1217, 'tools'),
(1218, 'tool_completed'),
(1219, 'tool_forumtotal'),
(1220, 'tool_lastpost'),
(1221, 'tool_logs'),
(1222, 'tool_mempost'),
(1223, 'tool_mood'),
(1224, 'tool_threadtotal'),
(1225, 'tool_u2u'),
(1226, 'tool_whosonline'),
(1227, 'too_few_pollopts'),
(1228, 'topmsgques'),
(1229, 'toppedpost'),
(1230, 'toppedprefix'),
(1231, 'topthreadmsg'),
(1232, 'topuntop'),
(1233, 'translations'),
(1234, 'translation_delete'),
(1235, 'translation_import'),
(1236, 'translation_name'),
(1237, 'translation_phrase'),
(1238, 'translation_select'),
(1239, 'translation_update'),
(1240, 'u2uadmin_noperm'),
(1241, 'u2ualert1'),
(1242, 'u2ualert2'),
(1243, 'u2ualert3'),
(1244, 'u2ualert4'),
(1245, 'u2ualert5'),
(1246, 'u2ualert6'),
(1247, 'u2ublocked'),
(1248, 'u2udump'),
(1249, 'u2udump_confirm'),
(1250, 'u2uempty'),
(1251, 'u2umsgempty'),
(1252, 'u2unotloggedin'),
(1253, 'u2uquota'),
(1254, 'u2ureachedquota'),
(1255, 'u2ureadstatus'),
(1256, 'uncheckall'),
(1257, 'upgrade'),
(1258, 'upgradenote'),
(1259, 'upgraderesults'),
(1260, 'upgradesuccess'),
(1261, 'uploadinstead'),
(1262, 'usercpeditpromsg'),
(1263, 'userip'),
(1264, 'usernamechars'),
(1265, 'username_length_invalid'),
(1266, 'userprofilemood'),
(1267, 'verificationnote'),
(1268, 'viaemail'),
(1269, 'viau2u'),
(1270, 'view'),
(1271, 'viewcompleteinbox'),
(1272, 'viewresults'),
(1273, 'votemsg'),
(1274, 'welcomelogout'),
(1275, 'welcomeunreg'),
(1276, 'welcomeunregnotify'),
(1277, 'what_tickerdelay'),
(1278, 'what_tickerstatus'),
(1279, 'whocanpost'),
(1280, 'whocanpost11'),
(1281, 'whocanpost12'),
(1282, 'whocanpost13'),
(1283, 'whocanpost14'),
(1284, 'whocanpost21'),
(1285, 'whocanpost22'),
(1286, 'whocanpost23'),
(1287, 'whocanpost24'),
(1288, 'whoodump_confirm'),
(1289, 'whosoneval'),
(1290, 'whosonline'),
(1291, 'whosonlinetoday'),
(1292, 'whosonline_on'),
(1293, 'whoview'),
(1294, 'xmb'),
(1295, 'xmbforum'),
(1296, 'xmbgroup');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lang_text`
--

CREATE TABLE `[[dbprefix]]lang_text` (
  `langid` tinyint(3) unsigned NOT NULL,
  `phraseid` smallint(5) unsigned NOT NULL,
  `cdata` blob NOT NULL,
  PRIMARY KEY (`langid`,`phraseid`),
  KEY `phraseid` (`phraseid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Translation Table';

--
-- Dumping data for table `[[dbprefix]]lang_text`
--

INSERT INTO `[[dbprefix]]lang_text` VALUES
(1, 1, 'ISO-8859-1'),
(1, 2, 'en'),
(1, 3, 'English'),
(1, 4, '&nbsp;&nbsp;&nbsp;&nbsp;'),
(1, 5, 'Address:'),
(1, 6, 'Update'),
(1, 7, 'To crank the base time up, or down, input a number here. Time will be raised, or lowered by this amount for everyone. Put X to add time, or -X to subtract.'),
(1, 8, 'Add To Address Book'),
(1, 9, 'Add to Address Book'),
(1, 10, 'Add more addresses'),
(1, 11, 'Administrator E-Mail:'),
(1, 12, 'Administration Option:'),
(1, 13, 'Thank you, you have successfully changed a member''s profile content.'),
(1, 14, 'Verify User''s E-mail Address'),
(1, 15, 'Edit User''s Account'),
(1, 16, 'Board Details'),
(1, 17, '3rd-Party Features'),
(1, 18, 'Default Settings'),
(1, 19, 'Modules'),
(1, 20, 'Cosmetic Options'),
(1, 21, 'User Control'),
(1, 22, 'Other'),
(1, 23, 'Captcha Image Settings'),
(1, 24, 'File Attachment Settings'),
(1, 25, 'Front Page Options'),
(1, 26, 'Could not rename user. Either the user does not exist, or there''s more than one.'),
(1, 27, 'Successfully renamed user.'),
(1, 28, 'Rename User'),
(1, 29, 'From: '),
(1, 30, 'To: '),
(1, 31, 'Warning: You have changed your own username, and thus will be logged out now. To log back in, please use your new username with your (old) password.'),
(1, 32, 'Prevent Staff Post Editing?:<br /><span class="smalltxt">(To prevent staff from editing posts by other staff set status to ON)</span>'),
(1, 33, 'That name and/ or e-mail has already been registered, please try again.'),
(1, 34, 'You have already voted in this poll!'),
(1, 35, 'Administration Tools'),
(1, 36, 'Avatar'),
(1, 37, 'Board Logo'),
(1, 38, 'Closed Topic'),
(1, 39, 'Edit Post'),
(1, 40, 'Edit Forum Settings'),
(1, 41, 'E-Mail User'),
(1, 42, 'Frequently Asked Questions'),
(1, 43, 'View All Posts By User'),
(1, 44, 'Folder'),
(1, 45, 'Get IP'),
(1, 46, 'Hot Folder'),
(1, 47, 'Hot Red Folder'),
(1, 48, 'Go to last post'),
(1, 49, 'View member list'),
(1, 50, 'This user has MSN Messenger'),
(1, 51, 'Normal Folder'),
(1, 52, '-'),
(1, 53, 'Depicts mood of post'),
(1, 54, 'Post new thread'),
(1, 55, 'Reply With Quote'),
(1, 56, 'Red Folder'),
(1, 57, 'Report Post to Administrator'),
(1, 58, 'Board Rules'),
(1, 59, 'Search the forums'),
(1, 60, 'Forum Stats'),
(1, 61, 'Today''s Posts'),
(1, 62, 'Top Thread'),
(1, 63, 'U2U Member'),
(1, 64, 'View user''s profile'),
(1, 65, 'Visit user''s homepage'),
(1, 66, 'Analyze Tables'),
(1, 67, 'and'),
(1, 68, 'Any status'),
(1, 69, 'Ascending'),
(1, 70, 'Show Thumbnails in Posts:'),
(1, 71, 'and author is:'),
(1, 72, 'and where post is this many days old:'),
(1, 73, 'and download count is greater than:'),
(1, 74, 'and download count is smaller than:'),
(1, 75, 'and forum is:'),
(1, 76, 'Where filename contains:'),
(1, 77, 'and size is greater than (bytes):'),
(1, 78, 'and size is smaller than (bytes):'),
(1, 79, 'Image limit is'),
(1, 80, 'Upload size limit is'),
(1, 81, 'Multiple upload size limit per submission is'),
(1, 82, 'Attachment:'),
(1, 83, 'Multi-Attach:'),
(1, 84, 'Attachments'),
(1, 85, 'attachments restored'),
(1, 86, 'attachments stored'),
(1, 87, 'Click here to upload another file'),
(1, 88, 'The attachment you are trying to upload is too big.'),
(1, 89, 'Are you sure you want to delete this attachment?'),
(1, 90, 'Attachment Deleted'),
(1, 91, 'Insert all post icons from smilies directory'),
(1, 92, 'Insert all smilies from smilies directory'),
(1, 93, 'Your avatar is too big! The maximum allowed avatar size on this board is: '),
(1, 94, 'a week'),
(1, 95, 'Back to:'),
(1, 96, 'Back to Voting'),
(1, 97, 'Backup &amp; Restoration Tools'),
(1, 98, 'Invalid e-mail address'),
(1, 99, 'Wrong username and e-mail.'),
(1, 100, 'Invalid username'),
(1, 101, 'Recipient does not exist'),
(1, 102, 'Your request was not understood.  Please refresh and then try again.'),
(1, 103, 'The form you submitted was expired or not understood.  Please refresh the form and then try again.'),
(1, 104, 'U2U/Posting'),
(1, 105, 'You are banned. You may not view the forums, post, make new topics, send U2U''s or edit your posts.'),
(1, 106, 'Posting'),
(1, 107, 'U2U'),
(1, 108, 'You can use BB Code, a simplified version of HTML, in your posts to create certain effects.<br /><br /> [b]Text here[/b] &nbsp; (Bold Text)<br /><br /> [i]Text here[/i] &nbsp; (Italicized Text)<br /><br /> [u]Text here[/u] &nbsp; (Underlined Text)<br /><br /> [url]http://www.php.net[/url] &nbsp; (Link)<br /><br /> [url=http://www.php.net]Home Page of PHP[/url] &nbsp; (Link)<br /><br /> [pid]12345[/pid] &nbsp; (Post Link)<br /><br /> [email]noreply@example.com[/email] &nbsp; (E-Mail Link)<br /><br /> [email=noreply@example.com]E-mail Me![/email] &nbsp; (E-Mail Link)<br /><br /> [quote]Text here[/quote] &nbsp; (Quoted Text)<br /><br /> [code]Text here[/code] &nbsp; (Text With Preserved Formatting)<br /><br /> [img]http://www.php.net/gifs/php_logo.gif[/img] &nbsp; (Image)<br /><br /> [img=50x50]http://www.php.net/gifs/php_logo.gif[/img] &nbsp; (Resized Image)<br /><br /> [youtube]fHxO0UdpoxM[/youtube] &nbsp; (YouTube Video)<br /><br /> [color=red]This color is red[/color] &nbsp; (Colored Text)<br /><br /> [size=3]This font size is 3[/size] &nbsp; (Sized Text)<br /><br /> [font=Tahoma]This font is Tahoma[/font] &nbsp; (Different Font Than Default)<br /><br /> [align=center]This is centered[/align] &nbsp; (Aligned Text)<br /><br /> [list]<br /> [*]List Item #1<br /> [*]List Item #2<br /> [/list] &nbsp; (List)'),
(1, 109, 'Turn BBCode off?'),
(1, 110, 'Advanced Mode\\nThe BB Code will be inserted without options as soon as you hit the button.'),
(1, 111, 'Help Mode\\nClick on any of the formatting buttons for a description and instructions.'),
(1, 112, 'Bold Tag\\nMakes the enclosed text bold.\\nUsage: [b]This is some bold text[/b]'),
(1, 113, 'Centered tag\\nCenters the enclosed text.\\nUsage: [align=center]This text is centered[/align]'),
(1, 114, 'Code Tag\\nPreserves the formatting of whitespace and some special characters.\\nUseful for posting code.\\nUsage: [code]$this = ''My code block'';[/code]'),
(1, 115, 'Color Tag\\nSets the text color. Any named color can be used.\\nUsage: [color=red]This is some \\"red\\" text[/color]'),
(1, 116, 'E-mail Tag\\nTurns an e-mail address into a mailto hyperlink.\\nUsage: [email]someone@anywhere.com[/email]\\nUsage: [email=someone@anywhere.com]link text[/email]'),
(1, 117, 'Font Tag\\nSets the font face for the enclosed text.\\nUsage: [font=Arial]The font of this text is Arial[/font]'),
(1, 118, 'Image Tag\\nInserts an image into the post.\\nUsage: [img]http://www.anywhere.com/image.gif[/img]'),
(1, 119, 'Italicize Tag\\nMakes the enclosed text italicized.\\nUsage: [i]This is some italicized text[/i]'),
(1, 120, 'Hyperlink Tag\\nTurns an URL into a hyperlink.\\nUsage: [url]http://www.anywhere.com[/url]\\nUsage: [url=http://www.anywhere.com]link text[/url]'),
(1, 121, 'List Tag\\nBuilds a bulleted, numbered, or alphabetical list.\\nUsage: [list]\\n[*]item1\\n[*]item2\\n[*]item3\\n[/list]'),
(1, 122, 'Quote tag\\nQuotes the enclosed text to reference something specific that someone has posted.\\nUsage: [quote]This is a quote[/quote]'),
(1, 123, 'Size Tag\\nSets the text size.\\n\\nUsage: The size given will be a relative size, relative to the default board size.\\n Eg. default text size is 12pt, setting[size=-3]This is size -3pt text[/size]\\n will provide a text of size 9pt (because 12pt-3pt = 9pt)'),
(1, 124, 'Underline Tag\\nUnderlines the enclosed text.\\nUsage: [u]This text is underlined[/u]'),
(1, 125, 'YouTube Tag\\nInserts a YouTube video.\\nUsage: [youtube]videoID[/youtube]'),
(1, 126, 'Normal Mode\\nPopups will bring you step by step through the process of inserting BB Code.'),
(1, 127, 'Please enter the text that should be bolded.'),
(1, 128, 'Please enter the text that should be centered.'),
(1, 129, 'Please enter the code snippet.'),
(1, 130, 'Please enter the text that should be colored '),
(1, 131, 'What name should be shown\\nIf this field is empty the e-mail address will be visible.'),
(1, 132, 'What e-mail address should be linked to?'),
(1, 133, 'You entered an invalid e-mail address, please try again.'),
(1, 134, 'Please enter the text to be in '),
(1, 135, 'Please enter the URL to the image you wish to insert.'),
(1, 136, 'Please enter the text that should be italicized.'),
(1, 137, 'What name should be shown?\\nIf this Field is left empty, the URL will be shown'),
(1, 138, 'Please enter the URL for the hyperlink.'),
(1, 139, 'This does not appear to be a well-formed URL. Please enter a valid url.'),
(1, 140, 'List Item:\\nLeave this blank to End the List'),
(1, 141, 'ERROR!\\nThe only possible values for type of list are: blank, ''A'' and ''1''.'),
(1, 142, 'Your selected text has been parsed, would you like to include this phrase in the list?\\nYou can also enter a new item which will be placed after the previous element, and before the next (from your selection)\\n\\n'),
(1, 143, 'Please select your list type\\n (''A'' for alphabetic, ''1'' for numeric) You can leave this field blank'),
(1, 144, 'Please enter the text you want quoted.'),
(1, 145, 'Please enter the text to be size '),
(1, 146, 'Please enter the text that should be underlined.'),
(1, 147, 'Please paste the video ID of the YouTube video you would like to use.'),
(1, 148, 'Auto BB Code Inserter:'),
(1, 149, 'Forum Name:'),
(1, 150, 'accounts have been found, matching the given query:'),
(1, 151, 'the beginning'),
(1, 152, ' has been added to your address book. You will now be taken to it.'),
(1, 153, 'is already in your address book.'),
(1, 154, 'Your address book has been updated, you will now be taken to it.'),
(1, 155, 'Adding yourself to your address book may be discontinued in future versions.'),
(1, 156, 'Thank you, the topic has been bumped. You are now being forwarded back to the thread list.'),
(1, 157, 'byte(s)'),
(1, 158, 'I am sorry, but it is impossible to merge a thread with itself.'),
(1, 159, 'This topic cannot be split as there are no replies.'),
(1, 160, 'This topic cannot be pruned as there are no replies.'),
(1, 161, 'This code is case-sensitive.'),
(1, 162, 'Code Characters:'),
(1, 163, 'Case Sensitive Code:'),
(1, 164, 'Code Length:'),
(1, 165, 'Code Shadow:'),
(1, 166, 'Image Background(s):'),
(1, 167, 'Use Full Color:'),
(1, 168, 'Number of Random Dots:'),
(1, 169, 'Image Font(s):'),
(1, 170, 'Image Height:'),
(1, 171, 'The image verification code that you entered was incorrect. Please enter the code exactly how it appears in the image.'),
(1, 172, 'Number of Random Lines:'),
(1, 173, 'Max Font Size:'),
(1, 174, 'Min Font Size:'),
(1, 175, 'Image Type:'),
(1, 176, 'Image Width:'),
(1, 177, 'Captcha features are not available in DEBUG mode.'),
(1, 178, 'Anonymous Posting Status:'),
(1, 179, 'Registration Status:'),
(1, 180, 'Anonymous Searching Status:'),
(1, 181, 'Main Status:'),
(1, 182, 'Captcha Image Verification'),
(1, 183, 'Advanced'),
(1, 184, 'Formatting Mode:'),
(1, 185, 'Help'),
(1, 186, 'Insert Bold text'),
(1, 187, 'Insert Centered text'),
(1, 188, 'Insert Code Formatted text'),
(1, 189, 'Insert E-mail Hyperlink'),
(1, 190, 'Insert a Hyperlink'),
(1, 191, 'Insert an Image'),
(1, 192, 'Insert Italicized text'),
(1, 193, 'Insert List'),
(1, 194, 'Insert Quoted text'),
(1, 195, 'Insert Underlined text'),
(1, 196, 'Insert YouTube Video'),
(1, 197, 'Normal'),
(1, 198, 'Censored words updated successfully!'),
(1, 199, 'Check All'),
(1, 200, 'Check Spelling'),
(1, 201, 'Sorry, this topic is closed. No new replies are accepted.'),
(1, 202, 'Close topic on reply?'),
(1, 203, 'Thank you, the topic has been closed/ opened. You are now being forwarded back to the thread list.'),
(1, 204, 'Thank you, the topic has been pruned. You are now being forwarded back to the thread list'),
(1, 205, 'You are about to delete all this user''s posts. Are you sure you wish to continue?'),
(1, 206, 'The following members will be deleted:'),
(1, 207, 'Continue'),
(1, 208, 'Your web browser settings are blocking cookies.  To login or register, please enable cookies, refresh the page, and then re-enter your details.'),
(1, 209, 'COPPA Compliancy Status:'),
(1, 210, 'What is your age?'),
(1, 211, 'This information is a required part our registration process.  We will not share your answer.'),
(1, 212, 'Sorry, we are unable to provide this service to individuals under the age specified by the USA COPPA regulation.'),
(1, 213, 'Age Question'),
(1, 214, 'Copy Thread'),
(1, 215, 'This thread has been copied. Redirecting you to the original forum.'),
(1, 216, 'Copy thread to'),
(1, 217, 'Restriction Manager'),
(1, 218, 'Search'),
(1, 219, 'Clear Whos Online'),
(1, 220, 'Delete Posts'),
(1, 221, 'Newsletter Subscription?'),
(1, 222, 'Your current IP Address is'),
(1, 223, 'Date Format (mm/dd/yyyy, dd-mm-yy, etc):'),
(1, 224, 'last day'),
(1, 225, 'last 100 days'),
(1, 226, 'last 15 days'),
(1, 227, 'last 30 days'),
(1, 228, 'last 5 days'),
(1, 229, 'last 60 days'),
(1, 230, 'Days Old'),
(1, 231, 'Database Backup'),
(1, 232, 'Default TimeZone'),
(1, 233, 'The delete action was aborted due to a protection error.'),
(1, 234, 'Delete'),
(1, 235, 'Delete:'),
(1, 236, '&nbsp;Delete current file.'),
(1, 237, 'Delete Thread'),
(1, 238, 'Thank you, the topic has been deleted. You are now being forwarded back to the thread list.'),
(1, 239, 'You can not delete your last theme! Your board won''t work without it!'),
(1, 240, 'Descending'),
(1, 241, 'Developed By'),
(1, 242, 'Devices'),
(1, 243, 'Devices Currently Logged In - You may safely delete them to force a logout.'),
(1, 244, 'Browser'),
(1, 245, 'Delete Selected Devices'),
(1, 246, 'ID'),
(1, 247, 'Login Date'),
(1, 248, 'Current'),
(1, 249, '''dot'' Folders:<br /><span class="smalltxt">Do you want to show dots on folders for the users that have posted in them?</span>'),
(1, 250, 'Allow duplicate mails?'),
(1, 251, 'Dump Attachments'),
(1, 252, 'Edit Address Book'),
(1, 253, 'Edited by...:<br /><span class="smalltxt">Select "on" if you want the "edited by..." message to appear when a post has been edited.</span>'),
(1, 254, 'Thank you, your message has been edited. You are now being forwarded to the thread'),
(1, 255, 'Return to Administration Panel'),
(1, 256, 'Last Login:'),
(1, 257, 'User is locked out. Check here to reset:'),
(1, 258, 'Failed Login Date:'),
(1, 259, 'Failed Login Count:'),
(1, 260, 'More Info'),
(1, 261, 'All posts and threads for this user have been successfully deleted from the board.'),
(1, 262, 'Registration Date:'),
(1, 263, 'Sign up IP:'),
(1, 264, 'Failed Session Date:'),
(1, 265, 'Failed Session Count:'),
(1, 266, 'Username ID:'),
(1, 267, 'Search'),
(1, 268, 'Your password request has been received, and details sent to your e-mail address on record.'),
(1, 269, 'Sorry, this e-mail address cannot be used to register on these forums.'),
(1, 270, 'E-mail verification (e-mail random password)?'),
(1, 271, 'Thank you, the thread has been emptied. You are now being forwarded back to the thread list.'),
(1, 272, 'Enable Page-loadtimes'),
(1, 273, 'Enable PHP/SQL Calculation'),
(1, 274, 'Enable Queries'),
(1, 275, 'Enable Server Load'),
(1, 276, 'Error'),
(1, 277, 'You did not select target forum or subforum. Please go back and try again.'),
(1, 278, 'Member of the Day is <strong>$membesthtml</strong> with <strong>$bestmemberpost</strong> posts'),
(1, 279, '<strong>$threads</strong> topics / <strong>$posts</strong> posts / <strong>$members</strong> members'),
(1, 280, '<br />This IP is currently banned with a mask ($ipmask).<br />If you click on <em>Unban IP</em>, you will also unban all IP addresses included in this mask.'),
(1, 281, 'Nobody has posted today, and as such there is no best member.'),
(1, 282, 'Time Offset (GMT time is currently $currdate)'),
(1, 283, 'On the $bbname, there are:'),
(1, 284, '$forumpost posts per forum'),
(1, 285, '$threadreply replies per thread'),
(1, 286, '$postsday posts per day'),
(1, 287, '$membersday new members per day'),
(1, 288, '<strong>5 Latest Topics:</strong><br /> $latest'),
(1, 289, '$mapercent of all members have posted.'),
(1, 290, '$posts posts'),
(1, 291, '$threads topics'),
(1, 292, '$forums forums ($forumsa active)'),
(1, 293, '$members members'),
(1, 294, '<strong>Top 5 most viewed topics:</strong><br /> $viewmost'),
(1, 295, '<strong>Top 5 most replied to topics:</strong><br /> $replymost'),
(1, 296, 'The most popular forum is $popforum with $pop[posts] posts and $pop[threads] topics'),
(1, 297, '$mempost posts per member'),
(1, 298, 'This is a long topic, click <a href=''$threadlink''>here</a> to review it.'),
(1, 299, 'You have $u2ucount U2Us with no limits.'),
(1, 300, 'You have $u2ucount U2Us. This is $percent% of the maximum, the maximum is set to $u2uquota.'),
(1, 301, '<strong>Note! You cannot send any U2Us before you lessen the number of your current U2Us.</strong><br />You have $u2ucount U2Us. The maximum is set to $u2uquota.'),
(1, 302, 'Hello $xmbuser, welcome to your user control panel. Here you can edit your profile, board options, send/ read your U2U messages, view your favorite threads and more.'),
(1, 303, 'This IP Address is already banned'),
(1, 304, 'To which forum (fid) should all orphaned threads be moved?'),
(1, 305, 'No forum was specified to send the orphaned threads to.'),
(1, 306, 'To which thread (tid) should all orphaned posts be moved?'),
(1, 307, 'No thread was specified to send the orphaned posts to.'),
(1, 308, 'The thread has successfully been added to your favorites list. You will now be taken to it.'),
(1, 309, 'The selected thread is already on your favorites list.'),
(1, 310, 'The selected threads have successfully been removed from your favorites list, you will now be taken back to it.'),
(1, 311, 'Warning'),
(1, 312, 'The file you are trying to download appears corrupt. File download aborted.'),
(1, 313, 'XMB Error: The Attachment Storage Path setting appears to be invalid.'),
(1, 314, 'You have attached the maximum number of files allowed per post.'),
(1, 315, 'There appears to be an invalid URL in one of the IMG links in your message.'),
(1, 316, 'One of the IMG links in your message points to a non-image file.'),
(1, 317, 'The image you uploaded exceeds our width and height limits.  Please re-size the image and try again.'),
(1, 318, 'Sorry, the file you uploaded exceeds our size limit.'),
(1, 319, 'XMB Error: Could not find a temporary directory for remote attachments.'),
(1, 320, 'Sorry, there was a problem attaching one of your files or images to this message.'),
(1, 321, 'You are not allowed to post this frequently.  Flood protection is triggered when more than one post is submitted in an unexpected manner.  Check if your post is already saved or try again in a few moments.'),
(1, 322, 'You are not allowed to send messages this frequently.  Flood protection is triggered when more than one message is submitted in an unexpected manner.  Check if your message is already saved or try again in a few moments.'),
(1, 323, 'Sorry, this feature is currently not available...'),
(1, 324, 'We apologize for the inconvenience.'),
(1, 325, 'We apologize for the inconvenience.<br />The board administrator has disabled this option, and it cannot be used at this time. If you believe you have received this message in error, please contact the board webmaster'),
(1, 326, 'Manage Folders'),
(1, 327, 'Separate all folders by commas (i.e. "Folder 1, Folder 2").'),
(1, 328, 'Folders list successfully updated.'),
(1, 329, 'The following folders were not deleted because they still contained u2us:'),
(1, 330, 'Footer Options:'),
(1, 331, 'Forgot password?'),
(1, 332, 'Select A Forum'),
(1, 333, 'The selected forum is not empty.  A forum must be empty to perform this action.'),
(1, 334, 'Forum Permissions:'),
(1, 335, 'Forum successfully pruned'),
(1, 336, 'Password:<br /><span class="smalltxt">(leave blank for none)</span>'),
(1, 337, 'This forum is password protected. To view this forum you need to enter the correct password below.'),
(1, 338, 'Found'),
(1, 339, 'General'),
(1, 340, 'File to Upload:'),
(1, 341, 'The item you requested could not be found.'),
(1, 342, 'Please complete the challenge.  After the check mark appears, click the Continue button.'),
(1, 343, 'The server was unable to validate your results.  Please try again.'),
(1, 344, 'Use Google reCAPTCHA for Registration<br /><ul class=''smalltxt''><li>Stronger bot protection.</li><li>Doesn''t stop human spammers.</li><li>Installs 3rd-party code on the registration page.</li></ul>'),
(1, 345, 'reCAPTCHA Secret Key'),
(1, 346, 'reCAPTCHA Site Key'),
(1, 347, 'Go To Bottom'),
(1, 348, 'Go To Top'),
(1, 349, '<br />Anonymous Posting is on for this forum.<br /><span class="smalltxt"> Do not enter a username or password to post anonymously.</span>'),
(1, 350, 'Use Gzip Page Compression'),
(1, 351, 'Help'),
(1, 352, 'Invisible'),
(1, 353, 'Hide Banned Members<br /><span class=''smalltxt''>Removes public profiles, links, and stats.</span>'),
(1, 354, 'more than $hottopic replies'),
(1, 355, 'Ignore List'),
(1, 356, 'Ignore List:<br /><span class="smalltxt">Separate names with commas (i.e. "Person 1, Person 2,"). Make sure you leave a comma after the last name.</span>'),
(1, 357, 'Ignore list updated successfully!'),
(1, 358, 'Avatars and [img] Tags HTTPS Only:<br /><span class="smalltxt">Helps prevent browser security warnings.</span>'),
(1, 359, 'U2U(s) successfully deleted. You will now be taken to your IM list.'),
(1, 360, 'Image Directory:'),
(1, 361, 'Admin Image Directory:'),
(1, 362, 'You can not ban <strong>all</strong> ips from your board!!'),
(1, 363, 'Your U2U message has been saved. You will now be taken to your drafts folder.'),
(1, 364, 'Your U2U message has been sent. You will now be taken back to your inbox.'),
(1, 365, 'In all categories'),
(1, 366, 'Where should, in the forumlist, the tableheader be shown?'),
(1, 367, 'Nowhere'),
(1, 368, 'Top of the page only'),
(1, 369, 'Index Stats Bar Status:<br /><span class="smalltxt">This option will enable/disable the stats bar on index.</span>'),
(1, 370, 'Insert your Data'),
(1, 371, 'Invalid Filename'),
(1, 372, 'The password you entered is invalid.'),
(1, 373, 'Invalid IP Address Format'),
(1, 374, 'Thread cannot be merged.  Invalid Thread ID (tid)'),
(1, 375, 'Invert Selection'),
(1, 376, 'Disable IP Banning'),
(1, 377, 'Enable IP Banning'),
(1, 378, 'Allow maximum 1 user to register per ip per day?'),
(1, 379, '<br /><strong>Warning!</strong> Your IP Address is on the list. You''ll be permanently banned if you log out.'),
(1, 380, 'Key: '),
(1, 381, 'The language could not be imported.'),
(1, 382, 'The language imported successfully.'),
(1, 383, 'Last $onlinetodaycount Members Who Have Visited Today (if applicable)'),
(1, 384, 'Last active:'),
(1, 385, 'on'),
(1, 386, 'You just tried to de-admin the last remaining Super Administrator. This is a dangerous thing to do. Once de-admin''d, it is not possible anymore to reset one''s status back to Super Administrator'),
(1, 387, 'last year'),
(1, 388, 'Open Address Book'),
(1, 389, '&nbsp;Leave current file untouched'),
(1, 390, 'Location'),
(1, 391, 'A closed topic'),
(1, 392, 'Logged in as'),
(1, 393, 'Logged In User:'),
(1, 394, 'The following member account received too many bad login attempts and is temporarily locked out.'),
(1, 395, 'Your password is temporarily locked due to too many guesses.'),
(1, 396, 'Trust This Device - Stay logged in'),
(1, 397, 'Logs'),
(1, 398, 'Are you sure you want to empty the logs?'),
(1, 399, 'Look &amp; Feel'),
(1, 400, 'The password reset link that you used is expired.  You may request a new reset after 24 hours.'),
(1, 401, 'Hello $name,\n\nA password reset request was received for your lost login details.  To set a new password, you must follow the link below.\n\n$link\n\nThis link will expire after one use, or 24 hours, whichever is first.'),
(1, 402, 'You have already requested your password once in the last 24 hours.<br />You can not request it again in the same 24-hour period.'),
(1, 403, 'Your new password is ready to use.  You may proceed to the login page.'),
(1, 404, 'last post'),
(1, 405, 'Due to server-protection, it is not allowed to save more than 10 addresses at one time.'),
(1, 406, 'Maximum File Size (in bytes):'),
(1, 407, 'The maximum avatar Height (in pixels):'),
(1, 408, 'The maximum avatar Width (in pixels):'),
(1, 409, 'Maximum number of new registrations per day.<br /><span class=''smalltxt''>Set to 0 for unlimited registrations per day.</span>'),
(1, 410, 'Maximum number of members to show in who''s online today on index.'),
(1, 411, 'Maximum registrations per day reached, please wait 24 hours.'),
(1, 412, 'Read?'),
(1, 413, 'UID'),
(1, 414, 'Member Is Offline'),
(1, 415, 'Member Is <strong>Online</strong>'),
(1, 416, 'Your Current Mood:'),
(1, 417, 'Other Information'),
(1, 418, 'Other Options'),
(1, 419, 'Posts'),
(1, 420, 'Thank you, the topics have been merged. You are now being forwarded back to the thread list.'),
(1, 421, 'TID of the topic to be merged and deleted:<br /><span class="smalltxt">viewthread.php?tid=48, the tid would be 48</span>'),
(1, 422, 'Message'),
(1, 423, 'The following '),
(1, 424, ' members have visited today...'),
(1, 425, 'Actions'),
(1, 426, 'Anonymous Posting Queue'),
(1, 427, 'Approve'),
(1, 428, 'Approved'),
(1, 429, 'Approve All'),
(1, 430, 'Are you sure you want to approve all new posts by $user and allow them to post without moderation?'),
(1, 431, 'Are you sure you want to delete all new posts by $user?'),
(1, 432, 'Canceled'),
(1, 433, 'Delete'),
(1, 434, 'Deleted'),
(1, 435, 'Delete All'),
(1, 436, 'Delete All and Ban User'),
(1, 437, 'Empty'),
(1, 438, 'Thank you for posting.  Your message will be reviewed by a staff member before it is displayed in the forum.'),
(1, 439, 'Quarantine Panel'),
(1, 440, 'New Member'),
(1, 441, 'New Members Queue'),
(1, 442, 'New Replies'),
(1, 443, 'New Threads'),
(1, 444, 'There are $result new posts in the <a href=''quarantine.php''>Quarantine Panel</a>.'),
(1, 445, 'There is one new post in the <a href=''quarantine.php''>Quarantine Panel</a>.'),
(1, 446, 'Your $result new replies are pending.  They will be listed in this thread after they are reviewed by a staff member.'),
(1, 447, 'Your new reply is pending.  It will be listed in this thread after it is reviewed by a staff member.'),
(1, 448, 'New User Quarantine<br /><span class=''smalltxt''>All posts are held for review until the user is approved by staff.</span>'),
(1, 449, 'Your $result new threads are pending.  They will be listed in this forum after they are reviewed by a staff member.'),
(1, 450, 'Your new thread is pending.  It will be listed in this forum after it is reviewed by a staff member.'),
(1, 451, 'Thread Bumped'),
(1, 452, 'Thread Closed'),
(1, 453, 'Thread Copied'),
(1, 454, 'Thread Emptied'),
(1, 455, 'Threads Merged'),
(1, 456, 'Thread Moved'),
(1, 457, 'Thread Opened'),
(1, 458, 'Thread Split'),
(1, 459, 'Thread Pruned'),
(1, 460, 'Thread Topped'),
(1, 461, 'Thread Untopped'),
(1, 462, 'a month'),
(1, 463, '3 months'),
(1, 464, '6 months'),
(1, 465, 'Mood:'),
(1, 466, 'More smilies'),
(1, 467, 'Moved:'),
(1, 468, 'Move?'),
(1, 469, 'Thank you, the topic has been moved. You are now being forwarded back to the thread list.'),
(1, 470, 'Move to Database'),
(1, 471, 'The attachment file was moved successfully to the database.'),
(1, 472, 'Move to Disk'),
(1, 473, 'The attachment was moved successfully to a separate file on disk.'),
(1, 474, 'Note: To ban multiple IP addresses at once, replace any of the 4 parts of the IP with a * (ex: 220.194.45.*)'),
(1, 475, 'Note: To make multiple moderators, separate moderators with a comma (including a space) (ex: Moderator 1, Moderator 2)'),
(1, 476, 'Database Tools'),
(1, 477, 'Stats'),
(1, 478, 'Today''s Posts'),
(1, 479, 'New posts in this forum since last active'),
(1, 480, 'To restrict the use of a username or e-mail address, enter the details below'),
(1, 481, 'You may wish to restrict the use of a certain names such as admin, owner etc'),
(1, 482, 'Your newsletter has been submitted'),
(1, 483, 'Receive a copy of the newsletter'),
(1, 484, 'New Thread Subject:'),
(1, 485, 'Wait a few seconds after this many mails have been sent'),
(1, 486, 'New'),
(1, 487, 'You have'),
(1, 488, 'new U2U message(s)'),
(1, 489, '[Next Page]'),
(1, 490, 'No Administration Login Session Found.'),
(1, 491, 'Welcome to the administration control panel, currently running.'),
(1, 492, 'Please enter your username and password which currently has administration status.'),
(1, 493, 'If you still have issues logging in, please contact the board webmaster.'),
(1, 494, 'Nothing'),
(1, 495, 'You did not select a user to add to your address book.'),
(1, 496, 'Sorry, you are not allowed to edit or delete this post.'),
(1, 497, 'You currently do not have any favorites on your favorites list.'),
(1, 498, 'No member selected'),
(1, 499, 'No Mood'),
(1, 500, 'No new posts in this forum since last active'),
(1, 501, 'There are no topics in this forum'),
(1, 502, 'No posts have been made in the specified time period'),
(1, 503, 'No posts have been made in the last 24 hours'),
(1, 504, 'No forums have been selected to be pruned'),
(1, 505, 'No matches were found'),
(1, 506, 'Nothing to search for...'),
(1, 507, 'You are currently not subscribed to any threads.'),
(1, 508, 'No misspelled words found'),
(1, 509, 'Notify (Super-)Administrator on new registrations'),
(1, 510, 'Not logged in'),
(1, 511, 'You are not permitted to perform this operation.'),
(1, 512, 'You currently do not have any U2U Messages in your inbox.'),
(1, 513, 'There are no addresses in your address book'),
(1, 514, 'This is not a poll!'),
(1, 515, 'templates.xmb was not found.'),
(1, 516, 'This feature has been disabled by the allow_url_fopen directive in your server''s PHP configuration.'),
(1, 517, 'Used:'),
(1, 518, 'Viewing address book'),
(1, 519, 'Adding user(s) to address book'),
(1, 520, 'Adding user(s) to U2U'),
(1, 521, 'Deleting user(s) from address book'),
(1, 522, 'Editing address book'),
(1, 523, 'Viewing an unknown category'),
(1, 524, 'Reading coppa license'),
(1, 525, 'Using the administration panel'),
(1, 526, 'Editing an unknown profile'),
(1, 527, 'Editing $user''s profile'),
(1, 528, 'Reading the FAQ'),
(1, 529, 'Viewing forum: '),
(1, 530, 'Browsing the index'),
(1, 531, 'Logging in'),
(1, 532, 'Logging out'),
(1, 533, 'Recovering lost password'),
(1, 534, 'Managing U2U folders'),
(1, 535, 'Viewing user control panel'),
(1, 536, 'Viewing favorite threads'),
(1, 537, 'Updating personal profile'),
(1, 538, 'Viewing subscribed threads'),
(1, 539, 'Viewing member list'),
(1, 540, 'Viewing an unknown forum'),
(1, 541, 'Viewing an unknown profile'),
(1, 542, 'Viewing an unknown thread'),
(1, 543, 'Viewing members who have been online today'),
(1, 544, 'Other'),
(1, 545, 'Editing a post'),
(1, 546, 'Posting a new thread'),
(1, 547, 'Replying to a thread'),
(1, 548, 'Registering'),
(1, 549, 'Reporting a post to the admin'),
(1, 550, 'Searching the forums'),
(1, 551, 'Viewing forum statistics'),
(1, 552, 'Viewing today''s posts'),
(1, 553, 'Who''s online today status:'),
(1, 554, 'Administrating the board'),
(1, 555, 'Moderating the board'),
(1, 556, 'Deleting a U2U'),
(1, 557, 'Adding user to ignore list'),
(1, 558, 'Viewing U2U messenger'),
(1, 559, 'Sending a U2U'),
(1, 560, 'Reading a U2U'),
(1, 561, 'Performing an unknown action'),
(1, 562, 'Viewing category: '),
(1, 563, 'Viewing $member''s profile'),
(1, 564, 'Reading thread: '),
(1, 565, 'Voting'),
(1, 566, 'Viewing members online'),
(1, 567, 'An open topic with new posts'),
(1, 568, 'An open topic'),
(1, 569, 'Optimize Tables'),
(1, 570, 'Optional:'),
(1, 571, 'Originally posted by'),
(1, 572, ' orphaned attachments found and deleted.'),
(1, 573, 'Delete all orphaned attachments'),
(1, 574, ' orphaned polls found and deleted.'),
(1, 575, 'Delete all orphaned polls'),
(1, 576, ' orphaned posts found and reallocated.'),
(1, 577, ' orphaned threads found and reallocated'),
(1, 578, '(optional)'),
(1, 579, 'PostIcon already exists'),
(1, 580, 'Post Icons'),
(1, 581, '<span class="smalltxt">To add a reserved post icon, add ''rsvd'' to the icon''s name.</span>'),
(1, 582, 'Plain Text'),
(1, 583, 'This feature is not available while you are logged in.  Please <a href=''misc.php?action=logout''>logout</a> before trying again.'),
(1, 584, 'Poll:'),
(1, 585, 'Poll Answers (Type 1 per line):'),
(1, 586, 'pollsmall.gif'),
(1, 587, 'Polls'),
(1, 588, 'You have not selected a poll option.'),
(1, 589, 'Post Icons Have Been Added.'),
(1, 590, 'Search for posts made by users with the following IP'),
(1, 591, 'Thank you, your post has been submitted. You are now being forwarded to the thread.'),
(1, 592, 'You have not entered a subject and message. Please go back and do so.'),
(1, 593, 'You don''t have permission to post in this forum.'),
(1, 594, 'This post contains a poll'),
(1, 595, 'Search for Censored Words in posts'),
(1, 596, 'Sorry, you are not permitted to view this forum'),
(1, 597, 'Search for keyword in a user-profile'),
(1, 598, 'Prune By: '),
(1, 599, 'Closed Posts'),
(1, 600, 'Exactly'),
(1, 601, 'These Fids: '),
(1, 602, 'Prune From: '),
(1, 603, 'Less Than'),
(1, 604, 'More Than'),
(1, 605, 'Normal Posts'),
(1, 606, 'Prune these: '),
(1, 607, 'Topped Posts'),
(1, 608, 'The number of days after which a new user, who has never logged in, will be deleted.<br /><span class=''smalltxt''>Set to 0 to disable.</span>'),
(1, 609, '(<strong>This feature can not be turned on until your host installs the pspell/aspell extension!</strong>)'),
(1, 610, 'Change Password'),
(1, 611, 'Passwords do not match'),
(1, 612, 'Enter new password if changing, otherwise leave blank.'),
(1, 613, 'Queries'),
(1, 614, 'Quick Jump Status:<br /><span class="smalltxt">This option enables/disables the Quick Jump feature when selecting forums and categories in the header and footer.</span>'),
(1, 615, 'Quick Reply'),
(1, 616, 'Quick Reply Status:<br /><span class="smalltxt">This option enables/disables the Quick Reply feature when viewing threads.</span>'),
(1, 617, 'Based on the number of posts you have, you are assigned to a rank. Each rank has its own status and its own amount of stars. Below are the user rank settings for this board:'),
(1, 618, 'User rankings updated successfully!'),
(1, 619, 'Insert Raw SQL'),
(1, 620, 'Reason:'),
(1, 621, 'Refresh Address Book'),
(1, 622, 'Refresh Page'),
(1, 623, 'Regenerate Thumbnail'),
(1, 624, 'Thank you for registering. We have logged you in and are forwarding you to the main page.'),
(1, 625, 'You must be registered to view these boards.'),
(1, 626, 'Registration Terms'),
(1, 627, 'Optional fields on registration status:<br /><span class="smalltxt">This option enables/disables optional fields on registration such as AIM, BIO, ICQ, Signatures etc.</span>'),
(1, 628, 'Need to register?'),
(1, 629, 'Allow User Registration'),
(1, 630, 'You have already registered today, you can re-register again in 24 hours.<br />'),
(1, 631, '&nbsp;Rename current file to:'),
(1, 632, 'Repair Tables'),
(1, 633, 'Replace'),
(1, 634, 'Replace with'),
(1, 635, 'Replies'),
(1, 636, 'Thank you, your post has been submitted. You are now being forwarded to your post.'),
(1, 637, 'The following post has been reported by a user, please inspect it:'),
(1, 638, 'Thank you, the post has been reported. You are now being forwarded back to the thread page'),
(1, 639, 'Report Post Status:'),
(1, 640, 'Reported post...'),
(1, 641, 'Required:'),
(1, 642, 'Should "use signature" in posts be automatically reset when the signature is removed and/or readded?'),
(1, 643, 'Restore Attachments'),
(1, 644, 'Sorry, you are unable to register this name as it is currently reserved. Please try again..'),
(1, 645, 'Current usernames &amp; e-mail addresses not allowed'),
(1, 646, 'Restricted usernames updated successfully!'),
(1, 647, 'The board administrator has requested that all new registered users must agree to the following terms before registering and using the services on this board. Please read the following terms and if you agree to them, select the "I agree" button found at the bottom of the terms.'),
(1, 648, 'Post body and subject.'),
(1, 649, 'Anonymous users are limited to only one page of search results.'),
(1, 650, 'That search text is not allowed.  Please try a different keyword.'),
(1, 651, 'Subject only.'),
(1, 652, '<a href="search.php?srchuname=*USER*&amp;searchsubmit=a&amp;f=all&amp;srchfrom=0">Search</a> for all posts by this user'),
(1, 653, 'Advanced Search'),
(1, 654, 'Secure Login - increased security on public computers'),
(1, 655, 'Security Event'),
(1, 656, 'Please select a template...'),
(1, 657, 'Separate multiple entries using commas'),
(1, 658, 'Sub-forums on index status:<br /><span class="smalltxt">This will enable or disable sub-forums display on index.</span>'),
(1, 659, 'Show topics from'),
(1, 660, 'Show moderator logs when viewing threads?'),
(1, 661, 'BB Code in Sigs:'),
(1, 662, 'HTML in Sigs:'),
(1, 663, 'No. Clickable Smilies Columns'),
(1, 664, 'Smilie Directory:'),
(1, 665, 'Auto Smiley Inserter:'),
(1, 666, 'Smilie already exists'),
(1, 667, 'Preview'),
(1, 668, 'Smilies'),
(1, 669, 'Smilies Have Been Added.'),
(1, 670, 'Smilies Updated'),
(1, 671, 'Total Visible Clickable Smilies:'),
(1, 672, ' and sort them by'),
(1, 673, 'Spaced Categories Status:'),
(1, 674, 'Spellcheck'),
(1, 675, 'Spellcheck complete'),
(1, 676, 'Spellchecker '),
(1, 677, 'Thank you, the topic has been split. You are now being forwarded back to the thread list.'),
(1, 678, 'in (forum):'),
(1, 679, 'Show only one post per thread?'),
(1, 680, 'Resume'),
(1, 681, 'Statistics'),
(1, 682, 'Please welcome our newest member'),
(1, 683, 'Could not generate board statistics, stats can not be viewed during the first 24 hours of the board''s existence, or when no posts/members are found.'),
(1, 684, 'Status'),
(1, 685, 'Pause'),
(1, 686, 'You have successfully subscribed to the thread. You will now be taken to your subscriptions list.'),
(1, 687, 'Subscribe to replies by default?'),
(1, 688, 'Show thread subject in page title'),
(1, 689, 'Submit Vote'),
(1, 690, 'You are already subscribed to this thread.'),
(1, 691, 'The selected threads have successfully been removed from your subscriptions list, you will now be taken back to it.'),
(1, 692, 'Super Administrator'),
(1, 693, 'This function can only be used by Super-Administrators'),
(1, 694, 'Are you sure you want to delete the selected template?'),
(1, 695, 'Template name can not be empty!'),
(1, 696, 'Template name already exists!'),
(1, 697, 'Template Name:'),
(1, 698, 'Are you sure you want to restore the templates to their default state in <strong>templates.xmb</strong>? <strong>templates.xmb</strong> must be in your forums directory for this to work!'),
(1, 699, 'Templates'),
(1, 700, 'Template deleted successfully'),
(1, 701, 'All templates have been restored to the ones in templates.xmb'),
(1, 702, 'Templates updated successfully!'),
(1, 703, 'No action chosen.'),
(1, 704, '12 Hours'),
(1, 705, '24 Hours'),
(1, 706, 'Use Addresses'),
(1, 707, 'Added:'),
(1, 708, 'Add to Favorites'),
(1, 709, 'Administrator'),
(1, 710, 'Admin Options:'),
(1, 711, 'I Agree'),
(1, 712, 'Aim:'),
(1, 713, 'All'),
(1, 714, 'All Forums and Sub-Forums'),
(1, 715, 'Allow:'),
(1, 716, 'Avatars:'),
(1, 717, 'Alphabetical'),
(1, 718, 'Alternating Color #1:'),
(1, 719, 'Alternating Color #2:'),
(1, 720, 'Anonymous'),
(1, 721, 'Anonymous Posting'),
(1, 722, 'April'),
(1, 723, 'at'),
(1, 724, 'has attached this image:'),
(1, 725, 'Attachments'),
(1, 726, 'Attachments Updated Successfully'),
(1, 727, 'Attachment Search Results'),
(1, 728, 'August'),
(1, 729, 'Author:'),
(1, 730, 'Avatar:'),
(1, 731, 'Avatar:'),
(1, 732, 'Avatar URL:'),
(1, 733, 'Averages:'),
(1, 734, 'Banned From'),
(1, 735, 'You are unable to post a new topic or reply to current posts, as your posting privileges have been removed.'),
(1, 736, 'You are unable to send a message, as you are banned from U2U services.'),
(1, 737, 'Ban IP'),
(1, 738, 'Banned'),
(1, 739, '<br />This IP is currently banned.'),
(1, 740, 'BB Code'),
(1, 741, '<a href=''faq.php?page=messages#7''>BB Code</a> is'),
(1, 742, 'If your BB is off please enter a reason'),
(1, 743, 'Board Rules'),
(1, 744, 'If rules are on, please enter your rules:'),
(1, 745, 'Birthday:'),
(1, 746, 'Background (Enter a hex code or an image name):'),
(1, 747, 'Big Font:'),
(1, 748, 'Bio:'),
(1, 749, 'Board Logo URL (or local image name):'),
(1, 750, 'Full Board URL:'),
(1, 751, 'Border Color:'),
(1, 752, 'Border Width:'),
(1, 753, 'Brief Account Summary For'),
(1, 754, 'Board Status:'),
(1, 755, 'This message board is currently turned off.'),
(1, 756, 'Address Book'),
(1, 757, 'Bump Thread'),
(1, 758, 'by'),
(1, 759, 'You cannot move this U2U to the selected location.'),
(1, 760, 'Category Color (Enter a hex code or an image name):'),
(1, 761, 'Categories Only On Main Page?'),
(1, 762, 'Category Text Color:'),
(1, 763, 'Find'),
(1, 764, 'Replace With'),
(1, 765, 'Censors'),
(1, 766, 'Check Tables'),
(1, 767, 'Close Thread'),
(1, 768, 'Code:'),
(1, 769, 'Administration Panel'),
(1, 770, 'Control Panel Logs'),
(1, 771, 'Custom Status'),
(1, 772, 'December'),
(1, 773, '! Delete this message !'),
(1, 774, 'Delete Posts'),
(1, 775, 'Delete'),
(1, 776, 'Delete Selected Favorites'),
(1, 777, 'Delete Selected Subscriptions'),
(1, 778, 'Delete Thread'),
(1, 779, 'Description:'),
(1, 780, 'Details'),
(1, 781, 'Disable Smilies?'),
(1, 782, 'Download'),
(1, 783, 'This file has been downloaded'),
(1, 784, 'times'),
(1, 785, 'Downloads:'),
(1, 786, 'Backup All'),
(1, 787, 'Edit'),
(1, 788, 'Edited on'),
(1, 789, 'Edit Post'),
(1, 790, 'Edit Profile'),
(1, 791, 'E-Mail'),
(1, 792, 'Receive e-mail on reply?'),
(1, 793, 'Receive e-mail notification on new U2U'),
(1, 794, 'Empty upgrade submissions are not permitted. Please go back and try again.'),
(1, 795, 'Empty Thread'),
(1, 796, 'Empty'),
(1, 797, 'FAQ'),
(1, 798, 'Is registration required?'),
(1, 799, 'Where can I view all the members?'),
(1, 800, 'How do I post a new message?'),
(1, 801, 'Can I reply to a message?'),
(1, 802, 'Is it possible to delete a message?'),
(1, 803, 'How do I edit one of my posts?'),
(1, 804, 'Can I insert an attachment?'),
(1, 805, 'Where do I log out?'),
(1, 806, 'What are smilies?'),
(1, 807, 'How can I create and vote in polls?'),
(1, 808, 'What is BB code?'),
(1, 809, 'Does this forum use cookies?'),
(1, 810, 'Can I become a moderator?'),
(1, 811, 'What are User Ranks?'),
(1, 812, 'How do I add a signature?'),
(1, 813, 'How do I get my own picture (avatar) under my name?'),
(1, 814, 'How can lost passwords be recovered?'),
(1, 815, 'What is U2U?'),
(1, 816, 'Where do I log in?'),
(1, 817, 'How do I search the board?'),
(1, 818, 'How do I U2U a member?'),
(1, 819, 'That depends on the board settings because administrators can change the settings so that you have to be registered to view posts. You also usually have to be registered to reply and start new posts but this does depend on the board settings. To register <a href=''member.php?action=reg''>click here</a>.<br /><br />It is advised that you register so you can receive e-mails from the administrator.'),
(1, 820, 'You can view all the members by clicking on the <a href="misc.php?action=list">Members List</a> button in the menu.'),
(1, 821, 'When inside of a forum, clicking on ''Post new Topic'' or the image that represents that, will allow you to post. You need to fill in your information, a topic and a message, then click on the ''Post New Topic'' button.'),
(1, 822, 'Yes, this is done the same as posting a new one, except that you must be in a Topic, and you need to click ''Post Reply'' instead of ''Post new Topic''.'),
(1, 823, 'Yes, click the ''Edit'' button on one of your own topics, and then select the ''! Delete this message !'' check box, and click ''Edit Post''. You can not delete a post if it is the first post in the thread.'),
(1, 824, 'You can edit a post by clicking on the ''Edit Post'' button above your message. You can only edit your own posts and sometimes this feature is disabled.'),
(1, 825, 'Yes you can insert an attachment with any of your posts. The file size of the attachment must be under 1 Megabyte for it to be accepted. You can attach a file on the New Post and Post Reply pages with the upload field.'),
(1, 826, 'Smilies are the little faces to the right of the input for message. They display graphical faces instead of simply a <strong>:)</strong>.<br />Here is a list of current supported smilies:'),
(1, 827, 'You can create a poll by visiting the forum you want to post the poll in and click on Start Poll. The screen following after you click the button is just like a normal new thread page but has an extra box for Poll Answers. You should enter one answer per line.<br /><br />You can vote on polls in threads by visiting the thread with the poll in it and selecting the option you want to vote for, then clicking the submit button. You can only vote on a poll once, so once you vote, you cant change your mind.<br /><br />The Administrator could have disabled this option for each forum.'),
(1, 828, 'Most of the time the answer is no, but ask your Admin.'),
(1, 829, 'Yes. This board uses cookies to store your login information, last visit, and threads that you have visited. We do this to make it easier for you so you can see which posts contain new replies and so you do not have to enter your username and password when posting or other certain things.<br /><br />If you logout, your cookies will be cleared. To logout <a href="misc.php?action=logout">click here</a>.'),
(1, 830, 'You can logout by clicking Logout at the top of the page. When you logout the cookies that store your username and password will be removed and you will become a Guest or Anonymous user.'),
(1, 831, 'To add a signature to your posts you have to log into your <a href="memcp.php">profile</a> and insert into the signature text box the signature you wish to use.<br /><br />BB Code may be turned off or on. This can affect what you can insert into your signature.'),
(1, 832, 'Again in your <a href="memcp.php">profile</a> there is a place for an ''Avatar'' and avatar is the image under your name. Check with your Admin about the size of your avatar, it''s usually considered common courtesy to use one under 150 pixels wide.'),
(1, 833, 'If you have forgotten your password, do not worry. Head over to the <a href="misc.php?action=lostpw">lost password section</a> and fill in the form and your password will be e-mailed to you.'),
(1, 834, 'U2U means User to User. It is a simple messaging client that you can use to send messages to fellow members on this board. You can check your U2U inbox by <a href="u2u.php" onclick="Popup(this.href, ''Window'', 700, 450); return false;">clicking here</a> or going to your <a href="memcp.php">profile</a>.<br /><br />The board administrator might have disabled this function for certain users.'),
(1, 835, 'There is a button that says ''Login'' in the menu at the top, clicking this button will take you to the login page, where you can login. Here you simply input your username, and your password, click the login button, and that''s it!'),
(1, 836, 'By clicking on the ''Search'' button in the menu. Then inputting what you wish to search for, you can restrict where you search with the drop down lists.'),
(1, 837, 'First click on the <a href="u2u.php" onclick="Popup(this.href, ''Window'', 700, 450); return false;">U2U</a> button in the menu, another smaller window will pop-up, from there you can access the ''Send a U2U'' screen, by clicking on it at the top. Place the user''s name in the ''To'' field, and then insert a subject and a message and click ''Send''. '),
(1, 838, 'Extra'),
(1, 839, 'FAQ Status:'),
(1, 840, 'Favorites'),
(1, 841, 'February'),
(1, 842, 'Filename:'),
(1, 843, 'Attachment Virtual URL:<br /><span class="smalltxt">Optional, base URL if different from $full_url.</span>'),
(1, 844, 'Filesize:'),
(1, 845, 'Attachment Minimum Storage Size:<br /><span class="smalltxt">Storage Path is ignored for files<br />smaller than this many bytes.</span>'),
(1, 846, 'Attachment Storage Path:<br /><span class="smalltxt">Optional, disk storage location for new files.</span>'),
(1, 847, 'Maximum Files Per Post:'),
(1, 848, 'Maximum Image Height:'),
(1, 849, 'Maximum Image Width:'),
(1, 850, 'Attachment Subdirectory Scheme:'),
(1, 851, 'Year/Month'),
(1, 852, 'Year/Month/Day'),
(1, 853, 'Maximum Thumbnail Height:'),
(1, 854, 'Maximum Thumbnail Width:'),
(1, 855, 'Attachment URL Format:<br /><span class="smalltxt">For Advanced Webmasters Only</span>'),
(1, 856, '____(default) /files.php?pid=$pid&amp;aid=$aid'),
(1, 857, '(+MultiViews) /files/$pid/$aid/'),
(1, 858, '(+MultiViews) /files/$aid/$filename'),
(1, 859, '(mod_rewrite) /$pid/$aid/'),
(1, 860, '(mod_rewrite) /$aid/$filename'),
(1, 861, 'Fix Last Posts'),
(1, 862, 'Fix Member Post Totals'),
(1, 863, 'Reset Blank Moods'),
(1, 864, 'Fix Orphaned Attachments'),
(1, 865, 'Fix Orphaned Polls'),
(1, 866, 'Fix Orphaned Posts'),
(1, 867, 'Fix Orphaned Threads'),
(1, 868, 'Fix Forum Totals'),
(1, 869, 'Fix Thread Totals'),
(1, 870, 'Seconds to wait until next post is allowed (flood control)'),
(1, 871, 'Folders'),
(1, 872, 'Font:'),
(1, 873, 'Forum:'),
(1, 874, 'Forum Name:'),
(1, 875, 'Forum Options:'),
(1, 876, 'Forums'),
(1, 877, 'Forums updated successfully!'),
(1, 878, 'Forward'),
(1, 879, 'Send to my e-mail'),
(1, 880, 'From:'),
(1, 881, 'Fwd:'),
(1, 882, 'Get IP'),
(1, 883, 'Receive newsletters from the admin?'),
(1, 884, 'Display Results'),
(1, 885, 'Guest'),
(1, 886, 'Guests'),
(1, 887, 'Header Color:'),
(1, 888, 'Header Text Color:'),
(1, 889, 'Theme Name:'),
(1, 890, 'Private forums hidden to unauthorized users?'),
(1, 891, 'Invisible Member'),
(1, 892, 'Invisible Members'),
(1, 893, 'Replies required for hot topic:'),
(1, 894, 'HTML'),
(1, 895, 'HTML is'),
(1, 896, 'Icon:'),
(1, 897, 'ICQ:'),
(1, 898, 'The query you used is not allowed.'),
(1, 899, 'IMG Code'),
(1, 900, '[img] Code is'),
(1, 901, 'Import Theme'),
(1, 902, 'in forum:'),
(1, 903, 'In Thread:'),
(1, 904, 'Browse the board invisible'),
(1, 905, 'IP'),
(1, 906, 'IP Address:'),
(1, 907, 'IP Banning'),
(1, 908, 'DNS Lookup'),
(1, 909, 'IP Banning updated successfully!'),
(1, 910, 'January'),
(1, 911, 'July'),
(1, 912, 'June'),
(1, 913, 'Language:'),
(1, 914, 'Last Post:'),
(1, 915, 'Latest Five Favorites With New Replies'),
(1, 916, 'Latest Five U2U Messages'),
(1, 917, 'from:'),
(1, 918, 'Link Color:'),
(1, 919, 'List'),
(1, 920, 'Location:'),
(1, 921, 'Logged in as'),
(1, 922, 'Login'),
(1, 923, 'Login Details Incorrect'),
(1, 924, 'Logout'),
(1, 925, 'Clear Control Panel Logs'),
(1, 926, 'Recover Lost Password'),
(1, 927, 'Please enter both your <strong>Username</strong> and your <strong>e-mail address</strong>.'),
(1, 928, 'Please enter your <strong>current username</strong> and <strong>new password</strong>.  Then confirm the new password by entering it again.'),
(1, 929, 'Manage Folders'),
(1, 930, 'March'),
(1, 931, 'U2U message(s) has been marked unread.'),
(1, 932, 'May'),
(1, 933, 'Member'),
(1, 934, 'Member List'),
(1, 935, 'Members'),
(1, 936, ' members have visited the site today'),
(1, 937, 'Members updated successfully!'),
(1, 938, ' member has visited the site today '),
(1, 939, 'Member List Status:'),
(1, 940, 'Merge Thread'),
(1, 941, 'messages per day'),
(1, 942, 'Message:'),
(1, 943, '<span class="smalltxt">[<a href="misc.php?action=logout">logout</a>]</span>'),
(1, 944, 'Moderator'),
(1, 945, 'Forum Moderators:'),
(1, 946, 'Moderator:');
INSERT INTO `[[dbprefix]]lang_text` VALUES
(1, 947, 'Moderator Logs'),
(1, 948, 'Moderators'),
(1, 949, 'Moderators updated successfully!'),
(1, 950, 'More Options...'),
(1, 951, 'Move Method:'),
(1, 952, 'Move Thread'),
(1, 953, 'Move thread and leave redirect in previous forum'),
(1, 954, 'U2U(s) moved successfully.'),
(1, 955, 'Move thread to:'),
(1, 956, 'Members Per Page'),
(1, 957, 'MSN:'),
(1, 958, 'My Home'),
(1, 959, 'Never'),
(1, 960, 'New'),
(1, 961, 'New Forum'),
(1, 962, 'New Category'),
(1, 963, 'New IP:'),
(1, 964, '[NOTIFY] New Member signup'),
(1, 965, 'A new member has registered on your board. This notification e-mail has been sent because the "Notify (Super)Admins on new registrations"-option is turned ON in Settings. To stop receiving these notifications, turn it OFF.'),
(1, 966, 'New Password'),
(1, 967, 'New Post Icon:'),
(1, 968, 'New Poll'),
(1, 969, 'New Rank:'),
(1, 970, 'Newsletter'),
(1, 971, 'New Smilie'),
(1, 972, 'New Sub-Forum'),
(1, 973, 'New Theme'),
(1, 974, 'has sent you a new U2U.\nTo stop receiving these notifications, please login to your user control panel.\n\nYou can read the U2U by going to\n\n'),
(1, 975, 'You received a new U2U'),
(1, 976, 'No'),
(1, 977, 'Sorry, you are not authorized to perform this action'),
(1, 978, '- No Category -'),
(1, 979, 'No folder selected'),
(1, 980, 'The forum you have chosen does not exist.'),
(1, 981, 'No forums exist.'),
(1, 982, 'Anonymous posting is not enabled for this forum. You will have to <a href=''member.php?action=reg''>register</a> to post in this forum.'),
(1, 983, 'You can not mark an outgoing U2U unread'),
(1, 984, 'None'),
(1, 985, 'No U2Us chosen.'),
(1, 986, 'You did not enter a password.'),
(1, 987, 'No posts made yet.'),
(1, 988, 'no subject'),
(1, 989, 'You entered no subject. Please go back and do so now.'),
(1, 990, 'The topic you have chosen does not exist.'),
(1, 991, 'You did not enter a username'),
(1, 992, 'November'),
(1, 993, 'October'),
(1, 994, 'Off'),
(1, 995, 'Offline'),
(1, 996, 'of total posts'),
(1, 997, 'Old Password'),
(1, 998, 'On'),
(1, 999, 'Online'),
(1, 1000, 'Open Thread'),
(1, 1001, 'Options:'),
(1, 1002, 'OR'),
(1, 1003, 'Order:'),
(1, 1004, 'Pages:'),
(1, 1005, 'Password:'),
(1, 1006, 'Confirm Password:'),
(1, 1007, 'Pending First Login'),
(1, 1008, 'Normal'),
(1, 1009, 'Admins'),
(1, 1010, 'Admins/Mods'),
(1, 1011, 'No Posting'),
(1, 1012, 'No Viewing'),
(1, 1013, 'Your Personal Features'),
(1, 1014, 'PHP:'),
(1, 1015, 'Pick a folder'),
(1, 1016, 'Poll:'),
(1, 1017, 'Post:'),
(1, 1018, 'Post New Topic'),
(1, 1019, 'Post Number'),
(1, 1020, 'posted on'),
(1, 1021, 'Posting &amp; Reading Messages'),
(1, 1022, 'Post Reply'),
(1, 1023, 'Posts:'),
(1, 1024, 'Powered By XMB'),
(1, 1025, 'Posts Per Page:'),
(1, 1026, 'Preview Post'),
(1, 1027, 'Preview U2U'),
(1, 1028, 'Printable Version'),
(1, 1029, 'Forum most active in:'),
(1, 1030, 'Last Post:'),
(1, 1031, 'Profile for'),
(1, 1032, 'Prune'),
(1, 1033, 'Prune Thread'),
(1, 1034, 'Sorry, the username/password you have entered appears to be incorrect.'),
(1, 1035, 'Please try again.'),
(1, 1036, 'You entered an incorrect password'),
(1, 1037, 'Quote:'),
(1, 1038, 'Re:'),
(1, 1039, 'Read'),
(1, 1040, 'Please use this form to alert the forum administrators of rule infractions or unacceptable behavior. By doing so you help to keep our forums a nice place to visit!<br />Thank you!<br /><br /> <strong>Note:</strong> This form is not to be used to alert the administrators that you have not received a reply to your post!'),
(1, 1041, 'Registration Date'),
(1, 1042, 'Allow only registered users to view boards?'),
(1, 1043, 'Register'),
(1, 1044, 'Registered:'),
(1, 1045, 'Attach Remote Images:<br /><span class="smalltxt">Converts [img] to attachment to help prevent https errors.</span>'),
(1, 1046, 'Replies:'),
(1, 1047, 'Reply'),
(1, 1048, 'Reply and delete'),
(1, 1049, 'Report Post'),
(1, 1050, 'Restore All'),
(1, 1051, 'Retype Password:'),
(1, 1052, 'Save outgoing U2Us in your Outbox'),
(1, 1053, 'Save U2U'),
(1, 1054, 'Search'),
(1, 1055, 'Search for:'),
(1, 1056, 'Search Status:'),
(1, 1057, 'seconds'),
(1, 1058, 'Select'),
(1, 1059, 'Administrators'),
(1, 1060, 'All Registered Members'),
(1, 1061, 'Moderators'),
(1, 1062, 'All Forum Staff'),
(1, 1063, 'Super Moderators'),
(1, 1064, 'Send To:'),
(1, 1065, 'Send U2U'),
(1, 1066, 'Send Via:'),
(1, 1067, 'Sent:'),
(1, 1068, 'September'),
(1, 1069, 'Server Load:'),
(1, 1070, 'Settings'),
(1, 1071, 'Settings updated successfully!'),
(1, 1072, 'Make e-mail address viewable by others?'),
(1, 1073, 'Signature:'),
(1, 1074, 'Site:'),
(1, 1075, 'Site Name:'),
(1, 1076, 'Full Site URL:'),
(1, 1077, 'Code'),
(1, 1078, 'File'),
(1, 1079, 'Smilies'),
(1, 1080, 'Smilies are'),
(1, 1081, 'Sort By:'),
(1, 1082, 'Table Spacing:'),
(1, 1083, 'Split Thread'),
(1, 1084, 'SQL:'),
(1, 1085, 'Search for e-mail:'),
(1, 1086, 'Search for ip:'),
(1, 1087, 'by (username):'),
(1, 1088, 'Search for user:'),
(1, 1089, 'Stars:'),
(1, 1090, 'Stats'),
(1, 1091, 'Statistics Status:'),
(1, 1092, 'Avatar &amp; Member Status:'),
(1, 1093, 'has replied to a thread you subscribed to.\nTo stop receiving these notifications, please login to your user control panel.\n\nYou can visit the thread by going to\n\n'),
(1, 1094, 'Sub-Forums:'),
(1, 1095, 'Subject:'),
(1, 1096, 'Submit'),
(1, 1097, 'Submit Changes'),
(1, 1098, 'Subscribe'),
(1, 1099, 'Subscriptions'),
(1, 1100, 'New Reply To Subscribed Thread'),
(1, 1101, 'Super Moderator'),
(1, 1102, 'Table Text Color:'),
(1, 1103, 'Text Color:'),
(1, 1104, 'Theme:'),
(1, 1105, 'Theme File:<br /><span class="smalltxt">(must be valid!)</span>'),
(1, 1106, 'The theme could not be imported.'),
(1, 1107, 'The theme has been been imported successfully.'),
(1, 1108, 'Theme Name:'),
(1, 1109, 'Time:'),
(1, 1110, 'Time Format:'),
(1, 1111, 'To:'),
(1, 1112, 'Today''s Posts Status:'),
(1, 1113, 'Top Table Color (Enter a hex code or an image name):'),
(1, 1114, 'Topic Review'),
(1, 1115, 'Topics:'),
(1, 1116, 'Top Thread'),
(1, 1117, 'Topics Per Page:'),
(1, 1118, 'Trash emptied'),
(1, 1119, 'Send U2U'),
(1, 1120, 'Address Book'),
(1, 1121, 'Drafts'),
(1, 1122, 'Folder:'),
(1, 1123, 'U2U Inbox'),
(1, 1124, 'Incoming U2Us'),
(1, 1125, 'Mark unread'),
(1, 1126, 'U2U Messenger'),
(1, 1127, 'Move to'),
(1, 1128, 'No U2Us found.'),
(1, 1129, 'This U2U has not yet been sent'),
(1, 1130, 'Options'),
(1, 1131, 'U2U Outbox'),
(1, 1132, 'Outgoing U2Us'),
(1, 1133, 'Saved U2Us'),
(1, 1134, 'Saved:'),
(1, 1135, 'You have requested the following U2U:'),
(1, 1136, 'U2U has been sent to your e-mail.'),
(1, 1137, 'Trash'),
(1, 1138, 'Unban IP'),
(1, 1139, 'Not Read'),
(1, 1140, 'Unregistered'),
(1, 1141, 'Untop Thread'),
(1, 1142, 'Upgrade'),
(1, 1143, 'Using the Board'),
(1, 1144, '--Use Default--'),
(1, 1145, 'Use the old U2U messenger?'),
(1, 1146, 'User Control Panel'),
(1, 1147, 'User Access List (separate with comma):'),
(1, 1148, 'User Maintenance'),
(1, 1149, 'Username'),
(1, 1150, 'User Ranks'),
(1, 1151, 'Use signature?'),
(1, 1152, 'View Profile'),
(1, 1153, 'Views:'),
(1, 1154, 'Vote:'),
(1, 1155, 'Table Width:'),
(1, 1156, 'with this status:'),
(1, 1157, 'Yahoo:'),
(1, 1158, 'Yes'),
(1, 1159, 'This user had an ip of'),
(1, 1160, 'Your Login Information'),
(1, 1161, 'This is an automatic e-mail. Your new login credentials can be found below:'),
(1, 1162, 'Themes'),
(1, 1163, 'Themes updated successfully!'),
(1, 1164, 'A theme with this name already exists!'),
(1, 1165, 'Threads'),
(1, 1166, 'Thumbnail'),
(1, 1167, 'Action:'),
(1, 1168, 'IP:'),
(1, 1169, 'Time:'),
(1, 1170, 'URL:'),
(1, 1171, 'Username:'),
(1, 1172, 'Code Language in Newsticker'),
(1, 1173, 'News In Newsticker:'),
(1, 1174, 'News &amp; Updates'),
(1, 1175, 'Processed in'),
(1, 1176, '(GMT -12:00) Kwajalein Island'),
(1, 1177, '(GMT -3:30) Newfoundland'),
(1, 1178, '(GMT -3:00) Brasilia, Buenos Aires, Rio de Janeiro, S&atilde;o Paulo'),
(1, 1179, '(GMT -2:00) Mid-Atlantic, Fernando de Noronha'),
(1, 1180, '(GMT -1:00) Azores, Cape Verde Islands'),
(1, 1181, '(GMT) Dublin, Edinburgh, Lisbon, London, Monrovia'),
(1, 1182, '(GMT +1:00) Amsterdam, Berlin, Brussels, Madrid, Paris, Rome'),
(1, 1183, '(GMT +2:00) Cairo, Helsinki, Kaliningrad, South Africa'),
(1, 1184, '(GMT +3:00) Baghdad, Riyadh, Moscow, Nairobi'),
(1, 1185, '(GMT +3:30) Tehran'),
(1, 1186, '(GMT +4:00) Abu Dhabi, Baku, Muscat, Tbilisi'),
(1, 1187, '(GMT -11:00) Midway Island, Samoa'),
(1, 1188, '(GMT +4:30) Kabul'),
(1, 1189, '(GMT +5:00) Ekaterinburg, Islamabad, Karachi, Tashkent'),
(1, 1190, '(GMT +5:30) Bombay, Calcutta, Madras, New Delhi'),
(1, 1191, '(GMT +5:45) Kathmandu'),
(1, 1192, '(GMT +6:00) Almaty, Bishkek, Dhaka, Omsk, Thimphu'),
(1, 1193, '(GMT +6:30) Rangoon'),
(1, 1194, '(GMT +7:00) Bangkok, Hanoi, Jakarta, Krasnoyarsk'),
(1, 1195, '(GMT +8:00) Beijing, Hong Kong, Perth, Singapore, Taipei'),
(1, 1196, '(GMT +9:00) Osaka, Sapporo, Seoul, Tokyo, Yakutsk'),
(1, 1197, '(GMT +9:30) Adelaide, Darwin'),
(1, 1198, '(GMT -10:00) Hawaii'),
(1, 1199, '(GMT +10:00) Canberra, Guam, Melbourne, Sydney, Vladivostok'),
(1, 1200, '(GMT +11:00) Magadan, New Caledonia, Solomon Islands'),
(1, 1201, '(GMT +12:00) Auckland, Fiji, Kamchatka Krai, Marshall Islands'),
(1, 1202, '(GMT +13:00) Kingdom of Tonga'),
(1, 1203, '(GMT +14:00) Christmas Island'),
(1, 1204, '(GMT +12:45) Chatham Islands'),
(1, 1205, '(GMT +10:30) Lord Howe Island'),
(1, 1206, '(GMT -9:30) Marquesas Islands'),
(1, 1207, '(GMT -9:00) Anchorage, Fairbanks'),
(1, 1208, '(GMT -8:00) Pacific Time (US &amp; Canada), Tijuana'),
(1, 1209, '(GMT -7:00) Mountain Time (US &amp; Canada), Arizona'),
(1, 1210, '(GMT -6:00) Central Time (US &amp; Canada), Mexico City, Central America'),
(1, 1211, '(GMT -5:00) Eastern Time (US &amp; Canada), Bogot&aacute;, Lima, Quito'),
(1, 1212, '(GMT -4:00) Atlantic Time (Canada), Caracas, La Paz, Santiago'),
(1, 1213, 'to continue.'),
(1, 1214, 'days'),
(1, 1215, 'Go!'),
(1, 1216, 'Show thread activity from the past'),
(1, 1217, 'Tools'),
(1, 1218, 'Tool Request Completed!'),
(1, 1219, 'Fixed Forum Totals'),
(1, 1220, 'Fixed Last Posts'),
(1, 1221, 'Logs Cleared'),
(1, 1222, 'Fixed Member Post Numbers'),
(1, 1223, 'Moods Updated'),
(1, 1224, 'Fixed Thread Totals'),
(1, 1225, 'U2Us Cleared'),
(1, 1226, 'Whos Online Cleared'),
(1, 1227, 'You have put in too few poll-answers. The minimum amount is 2.'),
(1, 1228, 'Top this topic?'),
(1, 1229, 'This post is topped'),
(1, 1230, 'pin.gif'),
(1, 1231, 'You have successfully topped/untopped the message. You will now be taken back to the thread list.'),
(1, 1232, 'Top/Untop'),
(1, 1233, 'Translations'),
(1, 1234, 'Translation(s) deleted.'),
(1, 1235, 'Install New Language'),
(1, 1236, 'Translation Name'),
(1, 1237, 'Phrase Name'),
(1, 1238, 'Please select a phrase...'),
(1, 1239, 'Phrase text saved successfully.'),
(1, 1240, 'You do not have permission to use this feature.'),
(1, 1241, 'U2U Alert Feature'),
(1, 1242, 'On Every Page'),
(1, 1243, 'On Index Only'),
(1, 1244, 'No Alert'),
(1, 1245, ' unread U2U message. Would you like to view it now?'),
(1, 1246, ' unread U2U messages. Would you like to view them now?'),
(1, 1247, 'The would-be recipient of this U2U has blocked you, so you can''t send this message.'),
(1, 1248, 'Clear All U2Us'),
(1, 1249, 'Are you sure you want to Delete all u2u''s?'),
(1, 1250, 'The U2U you are trying to save is empty.'),
(1, 1251, 'The U2U you are trying to send is empty.'),
(1, 1252, 'You must be logged in or registered to use U2U'),
(1, 1253, 'U2U Quota:'),
(1, 1254, 'You have reached the U2U quota limit. You must delete some u2us before you can send any'),
(1, 1255, 'Status:'),
(1, 1256, 'Uncheck All'),
(1, 1257, 'Insert your SQL data below'),
(1, 1258, 'Note: $table_something is automatically substituted by xmb with the real table name (eg xmb_something), you do not have to do this yourself (you can though!).'),
(1, 1259, 'Query Results:'),
(1, 1260, 'Query successful!'),
(1, 1261, '&nbsp;Upload this file instead:'),
(1, 1262, 'You have successfully edited your profile. Taking you back to the user control panel.'),
(1, 1263, 'Search for user with the following IP address'),
(1, 1264, 'Usernames may contain printable characters except []''&lt;&gt;\\|&quot;,@'),
(1, 1265, 'The length of the username you supplied is invalid. Please ensure it is a minimum of 3 characters and a maximum of 32 characters.'),
(1, 1266, 'Current Mood:'),
(1, 1267, 'Please enter the text contained within the image into the textbox below it. This process is used to prevent automated bots.'),
(1, 1268, 'Via E-mail'),
(1, 1269, 'Via U2U'),
(1, 1270, 'View'),
(1, 1271, 'View Complete Inbox'),
(1, 1272, 'View Results'),
(1, 1273, 'Thank you, your vote has been submitted. You are now being forwarded back to the thread'),
(1, 1274, '[logout]'),
(1, 1275, 'If you are not registered or logged in, you may still be able to view forums and topics, but you will not have access to your user control panel or settings'),
(1, 1276, 'You Are Not Registered Or Not Logged In'),
(1, 1277, 'News Delay:'),
(1, 1278, 'News Ticker:'),
(1, 1279, 'Who Can Post?'),
(1, 1280, 'All users can post new topics'),
(1, 1281, '<strong>Administrators</strong> can post new topics'),
(1, 1282, '<strong>Administrators and Moderators can post new topics</strong>'),
(1, 1283, 'No new topics are allowed'),
(1, 1284, 'all users can reply.'),
(1, 1285, 'Administrators can reply.'),
(1, 1286, 'Administrators and Moderators can reply.'),
(1, 1287, 'no replies are allowed.'),
(1, 1288, 'Are you sure you want to empty the whosonline?'),
(1, 1289, 'There are currently $guestn, $membern and $hiddenn browsing $bbname'),
(1, 1290, 'Who''s Online'),
(1, 1291, 'Who''s Online Today'),
(1, 1292, 'Who''s online in index status:'),
(1, 1293, 'Who Can View This Forum?'),
(1, 1294, 'XMB'),
(1, 1295, '<abbr title="eXtreme Message Board">XMB</abbr> Forum Software'),
(1, 1296, 'The XMB Group');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]logs`
--

CREATE TABLE `[[dbprefix]]logs` (
  `username` varchar(32) NOT NULL,
  `action` varchar(64) NOT NULL DEFAULT '',
  `fid` smallint(6) NOT NULL DEFAULT '0',
  `tid` int(11) NOT NULL DEFAULT '0',
  `date` int(11) NOT NULL DEFAULT '0',
  KEY `username` (`username`(8)),
  KEY `action` (`action`(8)),
  KEY `fid` (`fid`),
  KEY `tid` (`tid`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]members`
--

CREATE TABLE `[[dbprefix]]members` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(32) NOT NULL DEFAULT '',
  `password` varchar(32) NOT NULL DEFAULT '',
  `regdate` int(11) NOT NULL DEFAULT '0',
  `postnum` mediumint(9) NOT NULL DEFAULT '0',
  `email` varchar(60) NOT NULL DEFAULT '',
  `site` varchar(75) NOT NULL DEFAULT '',
  `aim` varchar(40) NOT NULL DEFAULT '',
  `status` varchar(35) NOT NULL DEFAULT '',
  `location` varchar(50) NOT NULL DEFAULT '',
  `bio` text NOT NULL,
  `sig` text NOT NULL,
  `showemail` varchar(15) NOT NULL DEFAULT '',
  `timeoffset` decimal(4,2) NOT NULL DEFAULT '0.00',
  `icq` varchar(30) NOT NULL DEFAULT '',
  `avatar` varchar(120) DEFAULT NULL,
  `yahoo` varchar(40) NOT NULL DEFAULT '',
  `customstatus` varchar(250) NOT NULL DEFAULT '',
  `theme` smallint(6) NOT NULL DEFAULT '0',
  `bday` varchar(10) NOT NULL DEFAULT '0000-00-00',
  `langfile` varchar(40) NOT NULL DEFAULT '',
  `tpp` smallint(6) NOT NULL DEFAULT '0',
  `ppp` smallint(6) NOT NULL DEFAULT '0',
  `newsletter` char(3) NOT NULL DEFAULT '',
  `regip` varchar(39) NOT NULL DEFAULT '',
  `timeformat` int(11) NOT NULL DEFAULT '0',
  `msn` varchar(40) NOT NULL DEFAULT '',
  `ban` varchar(15) NOT NULL DEFAULT '0',
  `dateformat` varchar(10) NOT NULL DEFAULT '',
  `ignoreu2u` text NOT NULL,
  `lastvisit` int(10) unsigned NOT NULL DEFAULT '0',
  `mood` varchar(128) NOT NULL DEFAULT 'Not Set',
  `pwdate` int(11) NOT NULL DEFAULT '0',
  `invisible` set('1','0') DEFAULT '',
  `u2ufolders` text NOT NULL,
  `saveogu2u` char(3) NOT NULL DEFAULT '',
  `emailonu2u` char(3) NOT NULL DEFAULT '',
  `useoldu2u` char(3) NOT NULL DEFAULT '',
  `u2ualert` tinyint(4) NOT NULL DEFAULT '0',
  `bad_login_date` int(10) unsigned NOT NULL DEFAULT '0',
  `bad_login_count` int(10) unsigned NOT NULL DEFAULT '0',
  `bad_session_date` int(10) unsigned NOT NULL DEFAULT '0',
  `bad_session_count` int(10) unsigned NOT NULL DEFAULT '0',
  `sub_each_post` varchar(3) NOT NULL DEFAULT 'no',
  `waiting_for_mod` varchar(3) NOT NULL DEFAULT 'no',
  PRIMARY KEY (`uid`),
  UNIQUE KEY `userunique` (`username`),
  KEY `status` (`status`),
  KEY `postnum` (`postnum`),
  KEY `email` (`email`),
  KEY `regdate` (`regdate`),
  KEY `lastvisit` (`lastvisit`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]members`
--

INSERT INTO `[[dbprefix]]members` VALUES
(1, '[[admin_username]]', '[[admin_pass]]', [[timestamp]], 0, '[[admin_email]]', '', '', 'Super Administrator', '', '', '', 'no', 0.00, '', '', '', '', 0, '0000-00-00', 'English', 30, 30, '', '[[clientip]]', 12, '', '', 'dd-mm-yyyy', '', 0, '', [[timestamp]], '0', '', 'yes', 'no', 'no', 0, 0, 0, 0, 0, 'no', 'no');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]posts`
--

CREATE TABLE `[[dbprefix]]posts` (
  `fid` smallint(6) NOT NULL DEFAULT '0',
  `tid` int(11) NOT NULL DEFAULT '0',
  `pid` int(11) NOT NULL AUTO_INCREMENT,
  `author` varchar(32) NOT NULL DEFAULT '',
  `message` text NOT NULL,
  `subject` tinytext NOT NULL,
  `dateline` int(11) NOT NULL DEFAULT '0',
  `icon` varchar(50) DEFAULT NULL,
  `usesig` varchar(15) NOT NULL DEFAULT '',
  `useip` varchar(39) NOT NULL DEFAULT '',
  `bbcodeoff` varchar(15) NOT NULL DEFAULT '',
  `smileyoff` varchar(15) NOT NULL DEFAULT '',
  PRIMARY KEY (`pid`),
  KEY `fid` (`fid`),
  KEY `dateline` (`dateline`),
  KEY `author` (`author`(8)),
  KEY `thread_optimize` (`tid`,`dateline`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ranks`
--

CREATE TABLE `[[dbprefix]]ranks` (
  `title` varchar(100) NOT NULL DEFAULT '',
  `posts` mediumint(9) DEFAULT '0',
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `stars` smallint(6) NOT NULL DEFAULT '0',
  `allowavatars` char(3) NOT NULL DEFAULT '',
  `avatarrank` varchar(90) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `title` (`title`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=10 ;

--
-- Dumping data for table `[[dbprefix]]ranks`
--

INSERT INTO `[[dbprefix]]ranks` VALUES
('Newbie', 0, 1, 1, 'yes', ''),
('Junior Member', 2, 2, 2, 'yes', ''),
('Member', 100, 3, 3, 'yes', ''),
('Senior Member', 500, 4, 4, 'yes', ''),
('Posting Freak', 1000, 5, 5, 'yes', ''),
('Moderator', -1, 6, 6, 'yes', ''),
('Super Moderator', -1, 7, 7, 'yes', ''),
('Administrator', -1, 8, 8, 'yes', ''),
('Super Administrator', -1, 9, 9, 'yes', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]restricted`
--

CREATE TABLE `[[dbprefix]]restricted` (
  `name` varchar(32) NOT NULL DEFAULT '',
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `case_sensitivity` enum('0','1') NOT NULL DEFAULT '1',
  `partial` enum('0','1') NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]restricted`
--

INSERT INTO `[[dbprefix]]restricted` VALUES
('Anonymous', 1, '0', '0'),
('xguest123', 2, '0', '0');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sessions`
--

CREATE TABLE `[[dbprefix]]sessions` (
  `token` varchar(32) NOT NULL,
  `username` varchar(32) NOT NULL,
  `login_date` int(10) unsigned NOT NULL,
  `expire` int(10) unsigned NOT NULL,
  `regenerate` int(10) unsigned NOT NULL,
  `replaces` varchar(32) NOT NULL,
  `agent` varchar(255) NOT NULL,
  PRIMARY KEY (`token`),
  KEY `username` (`username`),
  KEY `replaces` (`replaces`(6)),
  KEY `expire` (`expire`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]settings`
--

CREATE TABLE `[[dbprefix]]settings` (
  `name` varchar(32) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `[[dbprefix]]settings`
--

INSERT INTO `[[dbprefix]]settings` VALUES
('addtime', '0'),
('adminemail', '[[admin_email]]'),
('allowrankedit', 'on'),
('attachimgpost', 'on'),
('attach_remote_images', 'off'),
('authorstatus', 'on'),
('avastatus', 'on'),
('bbinsert', 'on'),
('bbname', '[[site_name]]'),
('bboffreason', ''),
('bbrules', 'off'),
('bbrulestxt', ''),
('bbstatus', 'on'),
('captcha_status', 'on'),
('captcha_reg_status', 'on'),
('captcha_post_status', 'on'),
('captcha_search_status', 'off'),
('captcha_code_charset', 'A-Z'),
('captcha_code_length', '8'),
('captcha_code_casesensitive', 'off'),
('captcha_code_shadow', 'off'),
('captcha_image_type', 'png'),
('captcha_image_width', '250'),
('captcha_image_height', '50'),
('captcha_image_bg', ''),
('captcha_image_dots', '0'),
('captcha_image_lines', '70'),
('captcha_image_fonts', ''),
('captcha_image_minfont', '16'),
('captcha_image_maxfont', '25'),
('captcha_image_color', 'off'),
('catsonly', 'off'),
('coppa', 'off'),
('dateformat', 'dd-mm-yyyy'),
('def_tz', '0.00'),
('dotfolders', 'on'),
('doublee', 'off'),
('editedby', 'off'),
('emailcheck', 'off'),
('faqstatus', 'on'),
('filesperpost', '10'),
('files_min_disk_size', '9216'),
('files_storage_path', ''),
('files_subdir_format', '1'),
('file_url_format', '1'),
('files_virtual_url', ''),
('floodctrl', '5'),
('footer_options', 'queries-phpsql-loadtimes-totaltime'),
('google_captcha', 'off'),
('google_captcha_sitekey', ''),
('google_captcha_secret', ''),
('gzipcompress', 'on'),
('hideprivate', 'on'),
('hide_banned', 'off'),
('hottopic', '20'),
('images_https_only', 'off'),
('indexshowbar', '2'),
('index_stats', 'on'),
('ipreg', 'on'),
('ip_banning', 'off'),
('langfile', 'English'),
('maxattachsize', '256000'),
('maxdayreg', '25'),
('max_avatar_size', '100x100'),
('max_image_size', '1000x1000'),
('max_thumb_size', '200x200'),
('memberperpage', '45'),
('memliststatus', 'on'),
('notifyonreg', 'off'),
('onlinetodaycount', '50'),
('onlinetoday_status', 'on'),
('postperpage', '25'),
('pruneusers', '0'),
('quarantine_new_users', 'off'),
('quickjump_status', 'on'),
('quickreply_status', 'on'),
('regoptional', 'off'),
('regstatus', 'on'),
('regviewonly', 'off'),
('reportpost', 'on'),
('resetsigs', 'off'),
('schema_version', '9'),
('searchstatus', 'on'),
('showsubforums', 'off'),
('show_logs_in_threads', 'off'),
('sigbbcode', 'on'),
('sitename', '[[domhost]]'),
('siteurl', '[[softurl]]/'),
('smcols', '4'),
('smileyinsert', 'on'),
('smtotal', '16'),
('space_cats', 'off'),
('spellcheck', 'off'),
('stats', 'on'),
('subject_in_title', 'off'),
('theme', '1'),
('tickercode', 'html'),
('tickercontents', '<strong>Welcome to your new XMB Forum!</strong>\nWe recommend changing your forums <a href="[[softurl]]/cp.php?action=settings">settings</a> first.'),
('tickerdelay', '4000'),
('tickerstatus', 'on'),
('timeformat', '12'),
('todaysposts', 'on'),
('topicperpage', '30'),
('u2uquota', '600'),
('whosonlinestatus', 'on');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]smilies`
--

CREATE TABLE `[[dbprefix]]smilies` (
  `type` varchar(15) NOT NULL DEFAULT '',
  `code` varchar(40) NOT NULL DEFAULT '',
  `url` varchar(40) NOT NULL DEFAULT '',
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=40 ;

--
-- Dumping data for table `[[dbprefix]]smilies`
--

INSERT INTO `[[dbprefix]]smilies` VALUES
('smiley', ':)', 'smile.gif', 1),
('smiley', ':(', 'sad.gif', 2),
('smiley', ':thumbdown:', 'thumbdown.gif', 3),
('smiley', ';)', 'wink.gif', 4),
('smiley', ':cool:', 'cool.gif', 5),
('smiley', ':mad:', 'mad.gif', 6),
('smiley', ':punk:', 'punk.gif', 7),
('smiley', ':blush:', 'blush.gif', 8),
('smiley', ':love:', 'love.gif', 9),
('smiley', ':ninja:', 'ninja.gif', 10),
('smiley', ':fake sniffle:', 'fake_sniffle.gif', 11),
('smiley', ':smilegrin:', 'smilegrin.gif', 12),
('smiley', ':kiss:', 'kiss.gif', 13),
('smiley', ':no:', 'no.gif', 14),
('smiley', ':post:', 'post.gif', 15),
('smiley', ':lol:', 'lol.gif', 16),
('smiley', ':sniffle:', 'sniffle.gif', 17),
('smiley', ':starhit:', 'starhit.gif', 18),
('smiley', ':yes:', 'yes.gif', 19),
('smiley', ':grind:', 'grind.gif', 20),
('smiley', ':crazy:', 'crazy.gif', 21),
('smiley', ':spin:', 'spin.gif', 22),
('smiley', ':exclamation:', 'exclamation.gif', 23),
('smiley', ':bigsmile:', 'bigsmile.gif', 24),
('smiley', ':smirk:', 'smirk.gif', 25),
('smiley', ':borg:', 'borg.gif', 26),
('smiley', ':rolleyes:', 'rolleyes.gif', 27),
('smiley', ':info:', 'info.gif', 28),
('smiley', ':question:', 'question.gif', 29),
('smiley', ':thumbup:', 'thumbup.gif', 30),
('smiley', ':dork:', 'dork.gif', 31),
('picon', '', 'cool.gif', 32),
('picon', '', 'mad.gif', 33),
('picon', '', 'thumbup.gif', 34),
('picon', '', 'thumbdown.gif', 35),
('picon', '', 'post.gif', 36),
('picon', '', 'exclamation.gif', 37),
('picon', '', 'info.gif', 38),
('picon', '', 'question.gif', 39);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]templates`
--

CREATE TABLE `[[dbprefix]]templates` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL DEFAULT '',
  `template` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=222 ;

--
-- Dumping data for table `[[dbprefix]]templates`
--

INSERT INTO `[[dbprefix]]templates` VALUES
(1, 'admintool_editprofile', '<form method=\\"post\\" action=\\"editprofile.php?user=$userrecode\\" name=\\"reg\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td colspan=\\"2\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[texteditpro] - $lang[required]</strong></font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">{$lang[\\''textusername\\'']}</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">{$member[\\''username\\'']}</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textemail]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"newemail\\" size=\\"25\\" value=\\"$member[email]\\" /><br /><a href=\\"https://gsuite.tools/verify-email?email=$member[email]\\" onclick=\\"window.open(this.href); return false;\\">$lang[adminverifyemail]</a></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">{$lang[\\''textstatus\\'']}</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><select name=\\"status\\">\n<option value=\\"Super Administrator\\" $sadminselect>{$lang[\\''superadmin\\'']}</option>\n<option value=\\"Administrator\\" $adminselect>{$lang[\\''textadmin\\'']}</option>\n<option value=\\"Super Moderator\\" $smodselect>{$lang[\\''textsupermod\\'']}</option>\n<option value=\\"Moderator\\" $modselect>{$lang[\\''textmod\\'']}</option>\n<option value=\\"Member\\" $memselect>{$lang[\\''textmem\\'']}</option>\n<option value=\\"Banned\\" $banselect>{$lang[\\''textbanned\\'']}</option>\n</select></td>\n</tr>\n<tr>\n<td colspan=\\"2\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[pwchange] - $lang[optional]</strong></font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textnewpassword]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"password\\" name=\\"newpassword\\" size=\\"25\\" />&nbsp;$lang[pwnote]</td>\n</tr>\n<tr>\n<td colspan=\\"2\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[texteditpro] - $lang[optional]</strong></font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">{$lang[\\''textcusstatus\\'']}:</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"cusstatus\\" size=\\"25\\" value=\\"$custout\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textsite]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"newsite\\" size=\\"25\\" value=\\"$member[site]\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textaim]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"newaim\\" size=\\"25\\" value=\\"$member[aim]\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[texticq]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"newicq\\" size=\\"25\\" value=\\"$member[icq]\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textyahoo]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"newyahoo\\" size=\\"25\\" value=\\"$member[yahoo]\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textmsn]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"newmsn\\" size=\\"25\\" value=\\"$member[msn]\\"/></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textlocation]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"newlocation\\" size=\\"25\\" value=\\"$member[location]\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[userprofilemood]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"newmood\\" size=\\"25\\" value=\\"$member[mood]\\" /></td>\n</tr>\n$avatar\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textbio]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><textarea rows=\\"5\\" cols=\\"45\\" name=\\"newbio\\">\n$member[bio]</textarea></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textsig]<br /><span class=\\"smalltxt\\">$lang[texthtmlis] $htmlis<br />$lang[textbbcodeis] $bbcodeis</span></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><textarea rows=\\"5\\" cols=\\"45\\" name=\\"newsig\\">\n$member[sig]</textarea></td>\n</tr>\n<tr>\n<td colspan=\\"2\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[texteditpro] - $lang[textoptions]</strong></font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[texttheme]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$themelist</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textlanguage]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$langfileselect</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textbday]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n<select name=\\"month\\">\n<option value=\\"\\" $sel[0]>&nbsp;</option>\n<option value=\\"1\\" $sel[1]>$lang[textjan]</option>\n<option value=\\"2\\" $sel[2]>$lang[textfeb]</option>\n<option value=\\"3\\" $sel[3]>$lang[textmar]</option>\n<option value=\\"4\\" $sel[4]>$lang[textapr]</option>\n<option value=\\"5\\" $sel[5]>$lang[textmay]</option>\n<option value=\\"6\\" $sel[6]>$lang[textjun]</option>\n<option value=\\"7\\" $sel[7]>$lang[textjul]</option>\n<option value=\\"8\\" $sel[8]>$lang[textaug]</option>\n<option value=\\"9\\" $sel[9]>$lang[textsep]</option>\n<option value=\\"10\\" $sel[10]>$lang[textoct]</option>\n<option value=\\"11\\" $sel[11]>$lang[textnov]</option>\n<option value=\\"12\\" $sel[12]>$lang[textdec]</option>\n</select>\n$dayselect\n<input type=\\"text\\" name=\\"year\\" size=\\"4\\" value=\\"$year\\" />\n</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[texttpp]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"tppnew\\" size=\\"4\\" value=\\"$member[tpp]\\" /> </td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textppp]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"pppnew\\" size=\\"4\\" value=\\"$member[ppp]\\" /> </td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textoptions]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n<input type=\\"checkbox\\" name=\\"newshowemail\\" value=\\"yes\\" $checked /> $lang[textshowemail]<br />\n<input type=\\"checkbox\\" name=\\"newsubs\\" value=\\"yes\\" $subschecked /> {$lang[\\''subdefault\\'']}<br />\n<input type=\\"checkbox\\" name=\\"newnewsletter\\" value=\\"yes\\" $newschecked /> $lang[textgetnews]<br />\n<input type=\\"checkbox\\" name=\\"newinv\\" value=\\"1\\" $invchecked /> $lang[textinvisible]<br />\n<input type=\\"checkbox\\" name=\\"useoldu2u\\" value=\\"yes\\" $uou2uchecked /> $lang[textuseoldu2u]<br />\n<input type=\\"checkbox\\" name=\\"saveogu2u\\" value=\\"yes\\" $ogu2uchecked /> $lang[textsaveog]<br />\n<input type=\\"checkbox\\" name=\\"emailonu2u\\" value=\\"yes\\" $eouchecked /> $lang[textemailonu2u]<br />\n<input type=\\"text\\" name=\\"timeoffset1\\" size=\\"3\\" value=\\"$member[timeoffset]\\" /> $textoffset\n</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[u2ualert1]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n<select name=\\"u2ualert\\">\n<option value=\\"2\\" $u2uasel2>$lang[u2ualert2]</option>\n<option value=\\"1\\" $u2uasel1>$lang[u2ualert3]</option>\n<option value=\\"0\\" $u2uasel0>$lang[u2ualert4]</option>\n</select>\n</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[texttimeformat]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"radio\\" value=\\"24\\" name=\\"timeformatnew\\" $check24 />&nbsp;$lang[text24hour]&nbsp;<input type=\\"radio\\" value=\\"12\\" name=\\"timeformatnew\\" $check12 />&nbsp;$lang[text12hour]</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[dateformat]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"dateformatnew\\" size=\\"25\\" value=\\"$member[dateformat]\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[editprofile_minfo]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n <strong>{$lang[\\''editprofile_userid\\'']}</strong> $member[uid]<br />\n {$lang[\\''editprofile_lastlogin\\'']} $lastlogdate<br />\n {$lang[\\''editprofile_regdate\\'']} $registerdate<br />\n {$lang[\\''editprofile_regip\\'']} <a href=\\"https://whois.domaintools.com/$member[regip]\\" onclick=\\"window.open(this.href); return false;\\">$member[regip]</a><br />\n {$lang[\\''editprofile_loginfails\\'']} $loginfails<br />\n {$lang[\\''editprofile_loginfaildate\\'']} $loginfaildate<br />\n {$lang[\\''editprofile_sessfails\\'']} $sessfails<br />\n {$lang[\\''editprofile_sessfaildate\\'']} $sessfaildate\n</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[editprosearch]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$lang[searchusermsg]</td>\n</tr>\n<tr class=\\"ctrtablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" colspan=\\"2\\"><input type=\\"submit\\" class=\\"submit\\" name=\\"editsubmit\\" value=\\"$lang[texteditpro]\\"/></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(2, 'buddylist', '<!DOCTYPE html PUBLIC \\"-//W3C//DTD XHTML 1.0 Transitional//EN\\" \\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\\">\n<html>\n<head>\n<meta http-equiv=\\"Content-Type\\" content=\\"text/html; charset={$lang[\\''charset\\'']}\\" />\n<meta name=\\"viewport\\" content=\\"width=500, initial-scale=1\\" />\n$css\n<title>$bbname - $lang[textpowered]</title>\n<script language=\\"JavaScript\\" type=\\"text/javascript\\" src=\\"./js/popup.js\\"></script>\n</head>\n<body text=\\"{$THEME[\\''text\\'']}\\">\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"100%\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><strong><font color=\\"{$THEME[\\''cattext\\'']}\\">$lang[textbuddylist]</font></strong></td>\n</tr>\n<tr>\n<td class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">\n<table width=\\"98%\\">\n<tr>\n<td class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" colspan=\\"2\\"><strong>$lang[textonline]</strong></td>\n</tr>\n$buddys[online]\n<tr>\n<td class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" colspan=\\"2\\"><strong>$lang[textoffline]</strong></td>\n</tr>\n$buddys[offline]\n</table>\n</td>\n</tr>\n<tr>\n<td class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><strong><a href=\\"buddy.php\\">$lang[refreshbuddylist]</a></strong></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"100%\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"ctrtablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\"><font class=\\"mediumtxt\\"><a href=\\"buddy.php?action=edit\\">$lang[editbuddylist]</a></font></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</body>\n</html>\n\n'),
(3, 'buddylist_buddy_offline', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"75%\\"><a href=\\"member.php?action=viewpro&amp;member=$recodename\\">{$buddy[\\''buddyname\\'']}</a></td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\"><a href=\\"u2u.php?action=send&amp;username=$recodename\\" onclick=\\"Popup(this.href, \\''Window\\'', 700, 450); return false;\\">$lang[textoffline]</a></td>\n</tr>\n\n'),
(4, 'buddylist_buddy_online', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"75%\\"><a href=\\"member.php?action=viewpro&amp;member=$recodename\\">{$buddy[\\''buddyname\\'']}</a></td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\"><a href=\\"u2u.php?action=send&amp;username=$recodename\\" onclick=\\"Popup(this.href, \\''Window\\'', 700, 450); return false;\\">$buddystatus</a></td>\n</tr>\n\n'),
(5, 'buddylist_edit', '<!DOCTYPE html PUBLIC \\"-//W3C//DTD XHTML 1.0 Transitional//EN\\" \\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\\">\n<html>\n<head>\n<meta http-equiv=\\"Content-Type\\" content=\\"text/html; charset={$lang[\\''charset\\'']}\\" />\n<meta name=\\"viewport\\" content=\\"width=500, initial-scale=1\\" />\n$css\n<title>$bbname - $lang[textpowered]</title>\n<script type=\\"text/javascript\\" language=\\"JavaScript\\" src=\\"./js/buddylistedit.js\\"></script>\n</head>\n<body text=\\"{$THEME[\\''text\\'']}\\">\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"95%\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<form method=\\"post\\" action=\\"buddy.php?action=delete\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\" colspan=\\"2\\"><strong><font color=\\"{$THEME[\\''cattext\\'']}\\">$lang[editbuddylist]</font></strong></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" width=\\"5%\\" align=\\"center\\"><strong>$lang[deletecolon]</strong></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><strong>$lang[addressname]</strong></td>\n</tr>\n$buddys\n<tr>\n<td class=\\"tablerow\\" colspan=\\"2\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"submit\\" class=\\"submit\\" name=\\"editsubmit\\" value=\\"{$lang[\\''addressupdate\\'']}\\" /><br /></td>\n</tr>\n</table>\n</form>\n</td>\n</tr>\n</table>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"95%\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<form method=\\"post\\" action=\\"buddy.php?action=add\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\" colspan=\\"2\\"><strong><font color=\\"{$THEME[\\''cattext\\'']}\\">$lang[addtoaddresses]</font></strong></td>\n</tr>\n<tr>\n<td class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n<div id=\\"addresses\\">\n<div id=\\"address_add\\">\n<input type=\\"text\\" name=\\"buddys[]\\" size=\\"20\\"/>\n</div>\n</div>\n</td>\n</tr>\n<tr>\n<td class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\"><a href=\\"#\\" onclick=\\"javascript:add();return false;\\">&raquo; $lang[add_buddy]</a></td>\n</tr>\n<tr>\n<td class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"submit\\" class=\\"submit\\" name=\\"editsubmit\\" value=\\"{$lang[\\''addressupdate\\'']}\\" /><br /></td>\n</tr>\n</table>\n</form>\n</td>\n</tr>\n</table>\n</body>\n</html>\n\n'),
(6, 'buddylist_edit_buddy', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" align=\\"center\\"><input type=\\"checkbox\\" name=\\"delete[]\\" value=\\"$buddy[buddyname]\\" /></td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$buddy[buddyname]</td>\n</tr>\n\n'),
(7, 'buddylist_message', '<!DOCTYPE html PUBLIC \\"-//W3C//DTD XHTML 1.0 Strict//EN\\" \\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\\"><html>\n<head>\n<meta http-equiv=\\"Content-Type\\" content=\\"text/html; charset={$lang[\\''charset\\'']}\\" />\n<meta name=\\"viewport\\" content=\\"width=500, initial-scale=1\\" />\n$css\n<title>$bbname - $lang[textpowered]</title>\n</head>\n<body text=\\"{$THEME[\\''text\\'']}\\">\n<table cellspacing=\\"2\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"ctrtablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\"><font class=\\"mediumtxt\\">$message$redirectjs</font></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</body>\n</html>\n\n'),
(8, 'buddy_u2u', '<!DOCTYPE html PUBLIC \\"-//W3C//DTD XHTML 1.0 Transitional//EN\\" \\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\\">\n<html>\n<head>\n<meta http-equiv=\\"Content-Type\\" content=\\"text/html; charset={$lang[\\''charset\\'']}\\" />\n<meta name=\\"viewport\\" content=\\"width=500, initial-scale=1\\" />\n$css\n<script type=\\"text/javascript\\" language=\\"JavaScript\\" src=\\"./js/buddy.js\\"></script>\n<title>$bbname - $lang[textbuddylist] - $lang[textpowered]</title>\n</head>\n<body text=\\"{$THEME[\\''text\\'']}\\">\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"95%\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"header\\">$lang[textbuddylist]</td>\n</tr>\n<tr>\n<td class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">\n<form action=\\"#\\" onsubmit=\\"javascript:add();\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table width=\\"98%\\">\n<tr>\n<td class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" colspan=\\"2\\"><strong>$lang[textonline]</strong></td>\n</tr>\n$buddys[online]\n<tr>\n<td class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" colspan=\\"2\\"><strong>$lang[textoffline]</strong></td>\n</tr>\n$buddys[offline]\n</table>\n<br />\n<input type=\\"submit\\" name=\\"submit\\" value=\\"$lang[textadd2u2u]\\" />\n</form>\n</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</body>\n</html>\n\n'),
(9, 'buddy_u2u_inv', '<tr class=\\"tablerow\\" >\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"75%\\"><input type=\\"checkbox\\" name=\\"users\\" value=\\"$buddyout\\" /> <a href=\\"member.php?action=viewpro&amp;member=$recodename\\">$buddyout</a></td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[hidden]</td>\n</tr>\n\n'),
(10, 'buddy_u2u_off', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"75%\\"><input type=\\"checkbox\\" name=\\"users\\" value=\\"$buddyout\\" /> <a href=\\"member.php?action=viewpro&amp;member=$recodename\\">$buddyout</a></td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textoffline]</td>\n</tr>\n\n'),
(11, 'buddy_u2u_on', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"75%\\"><input type=\\"checkbox\\" name=\\"users\\" value=\\"$buddyout\\" /> <a href=\\"member.php?action=viewpro&amp;member=$recodename\\">$buddyout</a></td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textonline]</td>\n</tr>\n\n'),
(12, 'cp_dump_query_top', '<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n <tr>\n  <td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n   <table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n    <tr bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"tablerow\\">\n     <td colspan=\\"$numfields\\"><strong>{$lang[\\''upgraderesults\\'']}</strong>&nbsp;$command</td>\n    </tr>\n\n'),
(13, 'cp_dump_query_bottom', '</table>\n  </td>\n </tr>\n</table>\n\n'),
(14, 'css', '/* XMB Stylesheet */\nbody {\n    scrollbar-arrow-color: {$THEME[\\''header\\'']};\n    scrollbar-base-color: {$THEME[\\''altbg1\\'']};\n    text-align: left;\n    {$THEME[\\''bgcode\\'']}\n}\n\na {\n    color: {$THEME[\\''link\\'']};\n    text-decoration: none;\n}\n\na:hover, .category a:hover {\n    text-decoration: underline;\n}\n\n.category a {\n    color: {$THEME[\\''cattext\\'']};\n    text-decoration: none;\n}\n\nform {\n    margin: 0px;\n}\n\nhr {\n    color:  {$THEME[\\''bordercolor\\'']};\n    background-color: {$THEME[\\''bordercolor\\'']};\n    border: 0px;\n    height: 1px;\n}\n\n#tickertoggle {\n    color: {$THEME[\\''cattext\\'']};\n}\n\ntable.code {\n    border: 1px solid {$THEME[\\''bordercolor\\'']};\n    margin: 15px auto 10px auto;\n}\n\ntd.code {\n    background-color: {$THEME[\\''header\\'']};\n    border-bottom: 1px solid {$THEME[\\''bordercolor\\'']};\n    color: {$THEME[\\''headertext\\'']};\n    font-family: {$THEME[\\''font\\'']};\n    font-size: {$THEME[\\''fontsize\\'']};\n    font-weight: bold;\n    height: 20px;\n    padding-left: 5px;\n}\n\ncode {\n    background-color: {$THEME[\\''altbg2\\'']};\n    color: {$THEME[\\''tabletext\\'']};\n    font-size: {$THEME[\\''fontsize\\'']};\n    padding: 10px 5px 10px 5px;\n    white-space: pre;\n    display: block;\n    width: 600px;\n    max-height: 400px;\n    overflow: auto;\n}\n\ntable.quote {\n    border: 1px solid {$THEME[\\''bordercolor\\'']};\n    margin: 15px 5% 10px 5%;\n    width: 80%;\n}\n\ntd.quote {\n    background-color: {$THEME[\\''header\\'']};\n    border-bottom: 1px solid {$THEME[\\''bordercolor\\'']};\n    color: {$THEME[\\''headertext\\'']};\n    font-family: {$THEME[\\''font\\'']};\n    font-size: {$THEME[\\''fontsize\\'']};\n    font-weight: bold;\n    height: 20px;\n    padding-left: 5px;\n}\n\ntd.quotemessage {\n    background-color: {$THEME[\\''altbg2\\'']};\n    color: {$THEME[\\''tabletext\\'']};\n    font-family: {$THEME[\\''font\\'']};\n    font-size: {$THEME[\\''fontsize\\'']};\n    padding: 10px 0 20px 5px;\n}\n\ntextarea, select, input, object {\n    background-color: {$THEME[\\''altbg1\\'']};\n    border: 1px solid {$THEME[\\''bordercolor\\'']};\n    color: {$THEME[\\''tabletext\\'']};\n    font-family: Verdana, arial, helvetica, sans-serif;\n    font-size: 12px;\n    font-weight: normal;\n    table-layout: fixed;\n}\n\n.category {\n    {$THEME[\\''catcss\\'']}\n    font-family: {$THEME[\\''font\\'']};\n    font-size: {$THEME[\\''fontsize\\'']};\n    table-layout: fixed;\n    text-align: left;\n}\n\n.ctrcategory {\n    {$THEME[\\''catcss\\'']}\n    font-family: {$THEME[\\''font\\'']};\n    font-size: {$THEME[\\''fontsize\\'']};\n    table-layout: fixed;\n    text-align: center;\n}\n\n.ctrtablerow {\n    color: {$THEME[\\''tabletext\\'']};\n    font-family: {$THEME[\\''font\\'']};\n    font-size: {$THEME[\\''fontsize\\'']};\n    table-layout: fixed;\n    text-align: center;\n}\n\n.header {\n    background-color: {$THEME[\\''header\\'']};\n    color: {$THEME[\\''headertext\\'']};\n    font-family: Verdana;\n    font-size: 10px;\n    font-weight: bold;\n    table-layout: fixed;\n}\n\n.header2 {\n    background-color: {$THEME[\\''altbg1\\'']};\n    font-family: Verdana;\n    font-size: 11px;\n    font-weight: bold;\n    table-layout: fixed;\n}\n\n.mediumtxt {\n    color: {$THEME[\\''tabletext\\'']};\n    font-family: {$THEME[\\''font\\'']};\n    font-size: {$THEME[\\''fontsize\\'']};\n    font-weight: normal;\n    table-layout: fixed;\n}\n\n.multi {\n    font-family: {$THEME[\\''font\\'']};\n    font-size: 11px;\n    table-layout: fixed;\n}\n\n.nav {\n    font-family: {$THEME[\\''font\\'']};\n    font-size: {$THEME[\\''fontsize\\'']};\n    font-weight: bold;\n    table-layout: fixed;\n}\n\n.navtd {\n    background-color: {$THEME[\\''header\\'']};\n    color: {$THEME[\\''headertext\\'']};\n    font-family: {$THEME[\\''font\\'']};\n    font-size: 11px;\n    table-layout: fixed;\n    text-decoration: none;\n}\n\n.navtd2 {\n    background-color: {$THEME[\\''header\\'']};\n    color: {$THEME[\\''headertext\\'']};\n    font-family: {$THEME[\\''font\\'']};\n    font-size: 9px;\n    table-layout: fixed;\n    text-decoration: none;\n}\n\n.post {\n    font-family: {$THEME[\\''font\\'']};\n    font-size: {$THEME[\\''font3\\'']};\n    font-weight: normal;\n}\n\n.rghttablerow {\n    color: {$THEME[\\''tabletext\\'']};\n    font-family: {$THEME[\\''font\\'']};\n    font-size: {$THEME[\\''fontsize\\'']};\n    table-layout: fixed;\n    text-align: right;\n}\n\n.lastpostcell {\n    color: {$THEME[\\''tabletext\\'']};\n    table-layout: fixed;\n    text-align: right;\n    padding: 0;\n}\n\n.lastpostcell img {\n    padding-left: 0.5em;\n    padding-right: 0.5em;\n}\n\n.tablelinks .lastpostcell a {\n    padding-top: 1.5em;\n    padding-bottom: 1.5em;\n}\n\n.sig {\n    border-top: 1px dashed {$THEME[\\''bordercolor\\'']};\n    padding: 13px 0 0 3px;\n    font-family: {$THEME[\\''font\\'']};\n    font-size: {$THEME[\\''fontsize\\'']};\n}\n\n.smalltxt {\n    font-family: {$THEME[\\''font\\'']};\n    font-size: {$THEME[\\''font1\\'']};\n    table-layout: fixed;\n}\n\n.subject {\n    font-family: {$THEME[\\''font\\'']};\n    font-size: {$THEME[\\''fontsize\\'']};\n    font-weight: bold;\n}\n\n.submit {\n    text-align: center;\n}\n\n.tablerow {\n    color: {$THEME[\\''tabletext\\'']};\n    font-family: {$THEME[\\''font\\'']};\n    font-size: {$THEME[\\''fontsize\\'']};\n    table-layout: fixed;\n}\n\n.status_Super_Administrator {\n    text-decoration: underline;\n    font-weight: bold;\n    color: {$THEME[\\''tabletext\\'']};\n    font-family: Verdana;\n    font-size: 10px;\n    font-style: italic;\n}\n\n.status_Administrator {\n    text-decoration: underline;\n    font-weight: bold;\n    color: {$THEME[\\''tabletext\\'']};\n    font-family: Verdana;\n    font-size: 10px;\n}\n\n.status_Super_Moderator {\n    text-decoration: none;\n    font-weight: bold;\n    color: {$THEME[\\''tabletext\\'']};\n    font-family: Verdana;\n    font-size: 10px;\n    font-style: italic;\n}\n\n.status_Moderator {\n    text-decoration: none;\n    font-weight: bold;\n    color: {$THEME[\\''tabletext\\'']};\n    font-family: Verdana;\n    font-size: 10px;\n}\n\n.status_Member, .status_Banned {\n    text-decoration: none;\n    font-weight: normal;\n    color: {$THEME[\\''tabletext\\'']};\n    font-family: Verdana;\n    font-size: 10px;\n}\n\n.tablelinks td {\n    overflow: hidden;\n}\n.tablelinks td a {\n    display: block;\n    width: 100%;\n    margin: -1em;\n    padding: 1em;\n}\n.tablelinks .plainlinks a, .tablelinks .multi a {\n    display: inline;\n    width: unset;\n    margin: 0;\n    padding: 0;\n}\n.video {\n    border: none;\n    height: 344px;\n    width: 600px;\n}\n@media screen and (min-width: 1200px) {\n    code {\n        width: 800px;\n    }\n}\n@media screen and (min-width: 1500px) {\n    code {\n        width: 1100px;\n    }\n}\n@media screen and (min-width: 1850px) {\n    code {\n        width: 1400px;\n    }\n}\n@media screen and (max-width: 850px) {\n    .video {\n        height: 300px;\n        width: 425px;\n    }\n    code {\n        width: 425px;\n    }\n}\n@media screen and (max-width: 600px) {\n    .video {\n        height: 300px;\n        width: 350px;\n    }\n    code {\n        width: 350px;\n    }\n}\n\n'),
(15, 'email_html_footer', '</body>\n</html>\n\n'),
(16, 'email_html_header', '<!DOCTYPE html PUBLIC \\"-//W3C//DTD XHTML 1.0 Transitional//EN\\" \\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\\">\n<html>\n<head>\n<base href=\\"$full_url\\" />\n<meta http-equiv=\\"Content-Type\\" content=\\"text/html; charset={$lang[\\''charset\\'']}\\" />\n<title>$bbname &gt; $lang[textu2utoemail]</title>\n$css\n</head>\n<body style=\\"color: {$THEME[\\''text\\'']};\\">\n\n'),
(17, 'error', '$header\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\" bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<tr>\n<td>\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[error]</strong></font></td>\n</tr>\n<tr>\n<td class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$message</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n\n'),
(18, 'error_nologinsession', '<form method=\\"post\\" action=\\"misc.php?action=login\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<input type=\\"hidden\\" name=\\"hide\\" value=\\"2\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\" colspan=\\"2\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[noadminsession]</strong></font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\"><strong>$lang[error]</strong></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><span class=\\"smalltxt\\"><strong>$lang[noadminsession]</strong></span><br />\n<span class=\\"smalltxt\\"><strong>$lang[noadminsession2]</strong></span><br />\n<span class=\\"smalltxt\\">$lang[noadminsession3]</span><br />\n<span class=\\"smalltxt\\">$lang[noadminsession4]</span></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textusername]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"username\\" size=\\"30\\" maxlength=\\"40\\" />  </td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textpassword]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"password\\" name=\\"password\\" size=\\"25\\" />  <br />\n</td>\n</tr>\n<tr class=\\"ctrtablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" colspan=\\"2\\"><input type=\\"submit\\" class=\\"submit\\" name=\\"loginsubmit\\" value=\\"$lang[textlogin]\\" /></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(19, 'faq', '<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><a href=\\"./faq.php?page=usermaint\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textuserman]</strong></font></a></td>\n</tr>\n<tr>\n<td class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">\n<ul>\n<li><a href=\\"faq.php?page=usermaint#1\\">$lang[textfaq1]</a></li>\n<li><a href=\\"faq.php?page=usermaint#2\\">$lang[textfaq2]</a></li>\n<li><a href=\\"faq.php?page=usermaint#3\\">$lang[textfaq3]</a></li>\n<li><a href=\\"faq.php?page=usermaint#4\\">$lang[textfaq4]</a></li>\n<li><a href=\\"faq.php?page=usermaint#5\\">$lang[textfaq5]</a></li>\n<li><a href=\\"faq.php?page=usermaint#6\\">$lang[textfaq6]</a></li>\n</ul>\n</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><a href=\\"./faq.php?page=using\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textuseboa]</strong></font></a></td>\n</tr>\n<tr>\n<td class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">\n<ul>\n<li><a href=\\"faq.php?page=using#1\\">$lang[textfaq7]</a></li>\n<li><a href=\\"faq.php?page=using#2\\">$lang[textfaq16]</a></li>\n<li><a href=\\"faq.php?page=using#3\\">$lang[textfaq8]</a></li>\n<li><a href=\\"faq.php?page=using#4\\">$lang[textfaq9]</a></li>\n<li><a href=\\"faq.php?page=using#5\\">$lang[textfaq10]</a></li>\n<li><a href=\\"faq.php?page=using#6\\">$lang[textfaq20]</a></li>\n<li><a href=\\"faq.php?page=using#7\\">$lang[textfaq21]</a></li>\n</ul>\n</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><a href=\\"./faq.php?page=messages\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textpostread]</strong></font></a></td>\n</tr>\n<tr>\n<td class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">\n<ul>\n<li><a href=\\"faq.php?page=messages#1\\">$lang[textfaq11]</a></li>\n<li><a href=\\"faq.php?page=messages#2\\">$lang[textfaq12]</a></li>\n<li><a href=\\"faq.php?page=messages#3\\">$lang[textfaq13]</a></li>\n<li><a href=\\"faq.php?page=messages#4\\">$lang[textfaq14]</a></li>\n<li><a href=\\"faq.php?page=messages#5\\">$lang[textfaq15]</a></li>\n<li><a href=\\"faq.php?page=messages#6\\">$lang[textfaq17]</a></li>\n<li><a href=\\"faq.php?page=messages#7\\">$lang[textfaq19]</a></li>\n<li><a href=\\"faq.php?page=messages#8\\">$lang[textfaq18]</a></li>\n</ul>\n</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n\n'),
(20, 'faq_forumrules', '<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textbbrules]</strong></font></td>\n</tr>\n<tr>\n<td class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$SETTINGS[bbrulestxt]</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n\n'),
(21, 'faq_messages', '<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textpostread]</strong></font></td>\n</tr>\n<tr>\n<td width=\\"100%\\" class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">\n<ul>\n<li><a href=\\"#1\\">$lang[textfaq11]</a></li>\n<li><a href=\\"#2\\">$lang[textfaq12]</a></li>\n<li><a href=\\"#3\\">$lang[textfaq13]</a></li>\n<li><a href=\\"#4\\">$lang[textfaq14]</a></li>\n<li><a href=\\"#5\\">$lang[textfaq15]</a></li>\n<li><a href=\\"#6\\">$lang[textfaq17]</a></li>\n<li><a href=\\"#7\\">$lang[textfaq19]</a></li>\n<li><a href=\\"#8\\">$lang[textfaq18]</a></li>\n</ul>\n</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong><a name=\\"1\\"></a>$lang[textfaq11]</strong></font></td>\n</tr>\n<tr>\n<td width=\\"100%\\" class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textfaqans11]</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong><a name=\\"2\\"></a> $lang[textfaq12]</strong></font></td>\n</tr>\n<tr>\n<td width=\\"100%\\" class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textfaqans12]</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong><a name=\\"3\\"></a> $lang[textfaq13]</strong></font></td>\n</tr>\n<tr>\n<td width=\\"100%\\" class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textfaqans13]</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong><a name=\\"4\\"></a> $lang[textfaq14]</strong></font></td>\n</tr>\n<tr>\n<td width=\\"100%\\" class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textfaqans14]</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong><a name=\\"5\\"></a> $lang[textfaq15]</strong></font></td>\n</tr>\n<tr>\n<td width=\\"100%\\" class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textfaqans15]</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong><a name=\\"6\\"></a> $lang[textfaq17]</strong></font></td>\n</tr>\n<tr>\n<td width=\\"100%\\" class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textfaqans16]\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"50%\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr class=\\"header\\">\n<td width=\\"25%\\">$lang[textsmiliecode]</td>\n<td width=\\"75%\\">$lang[smiliepreview]</td>\n</tr>\n$smilierows\n</table>\n</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong><a name=\\"7\\"></a> $lang[textfaq19]</strong></font></td>\n</tr>\n<tr>\n<td width=\\"100%\\" class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[bbcodeinfo]</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong><a name=\\"8\\"></a> $lang[textfaq18]</strong></font></td>\n</tr>\n<tr>\n<td width=\\"100%\\" class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textfaqans17]</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</table>\n\n'),
(22, 'faq_messages_smilierow', '<tr class=\\"tablerow\\">\n<td width=\\"25%\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$smilie[code]</td>\n<td width=\\"75%\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" align=\\"center\\"><img src=\\"{$THEME[\\''smdir\\'']}/$smilie[url]\\" alt=\\"$smilie[code]\\" /></td>\n</tr>\n\n'),
(23, 'faq_usermaint', '<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textuserman]</strong></font></td>\n</tr>\n<tr>\n<td width=\\"100%\\" class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">\n<ul>\n<li><a href=\\"#1\\">$lang[textfaq1]</a></li>\n<li><a href=\\"#2\\">$lang[textfaq2]</a></li>\n<li><a href=\\"#3\\">$lang[textfaq3]</a></li>\n<li><a href=\\"#4\\">$lang[textfaq4]</a></li>\n<li><a href=\\"#5\\">$lang[textfaq5]</a></li>\n<li><a href=\\"#6\\">$lang[textfaq6]</a></li>\n</ul>\n</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong><a name=\\"1\\"></a>$lang[textfaq1]</strong></font></td>\n</tr>\n<tr>\n<td width=\\"100%\\" class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textfaqans1]</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong><a name=\\"2\\"></a>$lang[textfaq2]</strong></font></td>\n</tr>\n<tr>\n<td width=\\"100%\\" class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textfaqans2]</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong><a name=\\"3\\"></a>$lang[textfaq3]</strong></font></td></tr>\n<tr>\n<td width=\\"100%\\" class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textfaqans3]</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong><a name=\\"4\\"></a>$lang[textfaq4]</strong></font></td>\n</tr>\n<tr>\n<td width=\\"100%\\" class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textfaqans4]</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong><a name=\\"5\\"></a>$lang[textfaq5]</strong></font></td>\n</tr>\n<tr>\n<td width=\\"100%\\" class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textfaqans5]</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong><a name=\\"6\\"></a>$lang[textfaq6]</strong></font></td>\n</tr>\n<tr>\n<td width=\\"100%\\" class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textfaqans6]</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n\n');
INSERT INTO `[[dbprefix]]templates` VALUES
(24, 'faq_using', '<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textuseboa]</strong></font></td>\n</tr>\n<tr>\n<td width=\\"100%\\" class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">\n<ul>\n<li><a href=\\"#1\\">$lang[textfaq7]</a></li>\n<li><a href=\\"#2\\">$lang[textfaq16]</a></li>\n<li><a href=\\"#3\\">$lang[textfaq8]</a></li>\n<li><a href=\\"#4\\">$lang[textfaq9]</a></li>\n<li><a href=\\"#5\\">$lang[textfaq10]</a></li>\n<li><a href=\\"#6\\">$lang[textfaq20]</a></li>\n<li><a href=\\"#7\\">$lang[textfaq21]</a></li>\n</ul>\n</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong><a name=\\"1\\"></a>$lang[textfaq7]</strong></font></td>\n</tr>\n<tr>\n<td width=\\"100%\\" class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textfaqans7]</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong><a name=\\"2\\"></a>$lang[textfaq16]</strong></font></td>\n</tr>\n<tr>\n<td width=\\"100%\\" class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textfaqans21]</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong><a name=\\"3\\"></a>$lang[textfaq8]</strong></font></td>\n</tr>\n<tr>\n<td width=\\"100%\\" class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textfaqans8]</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong><a name=\\"4\\"></a>$lang[textfaq9]</strong></font></td>\n</tr>\n<tr>\n<td width=\\"100%\\" class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textfaqans9]</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong><a name=\\"5\\"></a>$lang[textfaq10]</strong></font></td>\n</tr>\n<tr>\n<td width=\\"100%\\" class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textfaqans10]</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong><a name=\\"6\\"></a> $lang[textfaq20]</strong></font></td>\n</tr>\n<tr>\n<td width=\\"100%\\" class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textfaqans19]</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong><a name=\\"7\\"></a> $lang[textfaq21]</strong></font></td>\n</tr>\n<tr>\n<td width=\\"100%\\" class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[rankinfo]</td>\n</tr>\n<tr>\n<td width=\\"100%\\" class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"50%\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"2\\" width=\\"100%\\">\n$rankrows\n</table>\n</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n\n'),
(25, 'faq_using_rankrow', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$ranks[title]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$stars</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$ranks[posts] $lang[memposts]</td>\n</tr>\n\n'),
(26, 'feature_statistics', '<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textstats]</strong></font></td>\n</tr>\n<tr bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"tablerow\\">\n<td>\n<strong>$stats1</strong>\n<br />\n$stats2\n<br />\n$stats3\n<br />\n$stats4\n<br />\n$stats5\n<br />\n<br />\n$stats6\n<br />\n<br />\n$stats7\n<br />\n<br />\n$stats14\n<br />\n<br />\n$stats8\n<br />\n<br />\n</td>\n</tr>\n<tr bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"tablerow\\">\n<td>\n<strong>$lang[textaverages]</strong>\n<br />\n$stats9\n<br />\n$stats10\n<br />\n$stats11\n<br />\n$stats12\n<br />\n$stats13\n<br />\n$stats15\n<br />\n<br />\n<br />\n$bestmember\n</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n\n'),
(27, 'footer', '<br />\n<table cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\" bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<tr>\n<td>\n<table width=\\"100%\\" cellspacing=\\"0\\" cellpadding=\\"0\\">\n<tr>\n<td class=\\"nav\\" style=\\"padding-bottom: 1px\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">&nbsp;<a href=\\"./\\">$bbname</a>$navigation</td>\n<td class=\\"tablerow\\" align=\\"right\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$quickjump&nbsp;</td>\n<td align=\\"right\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" width=\\"2%\\"><a href=\\"#top\\" title=\\"$lang[gototop]\\"><img src=\\"{$THEME[\\''imgdir\\'']}/arrow_up.gif\\" style=\\"margin-right: 3px\\" border=\\"0\\" alt=\\"$lang[gototop]\\" /></a></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr class=\\"ctrtablerow\\">\n<td class=\\"smalltxt\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n$versionlong\n<br />\n<a href=\\"https://www.xmbforum2.com/\\" onclick=\\"window.open(this.href); return false;\\"><strong>{$lang[\\''xmbforum\\'']}</strong></a>&nbsp;&copy; $copyright $lang[xmbgroup]\n<br />\n$footerstuff[totaltime]\n$footerstuff[querynum]\n$footerstuff[phpsql]\n$footerstuff[load]\n$footerstuff[querydump]\n</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<a id=\\"bottom\\" name=\\"bottom\\"></a>\n</body>\n</html>\n\n'),
(28, 'footer_load', '[$lang[textserverload] <strong>$load[0]</strong>]\n\n'),
(29, 'footer_phpsql', '[$lang[textphp] <strong>$php_duration%</strong> - $lang[textsql] <strong>$db_duration%</strong>]\n\n'),
(30, 'footer_querynum', '[$lang[queries]: <strong>$querynum</strong>]\n\n'),
(31, 'footer_totaltime', '[$lang[timemsg]: <strong>$totaltime</strong> $lang[textseconds]]\n\n'),
(32, 'forumdisplay', '$subforums\n<table width=\\"{$THEME[\\''tablewidth\\'']}\\" cellspacing=\\"0\\" cellpadding=\\"0\\" align=\\"center\\">\n<tr>\n<td class=\\"post\\" align=\\"right\\">&nbsp;$newtopiclink$newpolllink</td>\n</tr>\n</table>\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\" bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<tr>\n<td>\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\" class=\\"tablelinks\\">\n$multipage\n<tr class=\\"header\\" align=\\"center\\">\n<td width=\\"4%\\">&nbsp;</td>\n<td width=\\"4%\\">$lang[texticon]</td>\n<td width=\\"47%\\">$lang[textsubject]</td>\n<td width=\\"14%\\">$lang[textauthor]</td>\n<td width=\\"6%\\">$lang[textreplies]</td>\n<td width=\\"6%\\">$lang[textviews]</td>\n<td width=\\"19%\\">$lang[textlastpost]</td>\n</tr>\n$threadlist\n<tr>\n<td colspan=\\"7\\" class=\\"ctrtablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n$sortby\n</td>\n</tr>\n$multipage\n</table>\n</td>\n</tr>\n</table>\n<table width=\\"{$THEME[\\''tablewidth\\'']}\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" align=\\"center\\" style=\\"margin-top: 3px\\">\n<tr>\n<td class=\\"post\\" align=\\"right\\">&nbsp;$newtopiclink$newpolllink</td>\n</tr>\n</table>\n<br />\n<table width=\\"{$THEME[\\''tablewidth\\'']}\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" align=\\"center\\"><tr>\n<td class=\\"tablerow\\"><img src=\\"{$THEME[\\''imgdir\\'']}/red_folder.gif\\" alt=\\"$lang[altredfolder]\\" />&nbsp;$lang[opennew] (&nbsp;\n<img src=\\"{$THEME[\\''imgdir\\'']}/hot_red_folder.gif\\" alt=\\"$lang[althotredfolder]\\" />&nbsp;$hottopic&nbsp;)<br />\n<img src=\\"./images/pixel.gif\\" width=\\"1\\" height=\\"4\\" alt=\\"*\\" /><br/>\n<img src=\\"{$THEME[\\''imgdir\\'']}/folder.gif\\" alt=\\"$lang[altfolder]\\" />&nbsp;$lang[opentopic] (&nbsp;\n<img src=\\"{$THEME[\\''imgdir\\'']}/hot_folder.gif\\" alt=\\"$lang[althotfolder]\\" />&nbsp;$hottopic&nbsp;)<br />\n<img src=\\"./images/pixel.gif\\" width=\\"1\\" height=\\"4\\" alt=\\"*\\" /><br/>\n<img src=\\"{$THEME[\\''imgdir\\'']}/lock_folder.gif\\" alt=\\"$lang[altclosedtopic]\\" />&nbsp;$lang[locktopic]</td>\n</tr>\n</table>\n\n'),
(33, 'forumdisplay_admin', '$subforums\n<table width=\\"{$THEME[\\''tablewidth\\'']}\\" cellspacing=\\"0\\" cellpadding=\\"0\\" align=\\"center\\">\n<tr>\n<td class=\\"post\\" align=\\"right\\">&nbsp;$newtopiclink$newpolllink</td>\n</tr>\n</table>\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\" bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<tr>\n<td>\n<form method=\\"post\\" name=\\"geatneet\\" action=\\"topicadmin.php?fid=$forum[fid]\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\" class=\\"tablelinks\\">\n$multipage\n<tr class=\\"header\\" align=\\"center\\">\n<td width=\\"4%\\">$fadminlink</td>\n<td width=\\"4%\\">$lang[texticon]</td>\n<td width=\\"45%\\">$lang[textsubject]</td>\n<td width=\\"6%\\">$lang[topuntop]</td>\n<td width=\\"12%\\">$lang[textauthor]</td>\n<td width=\\"6%\\">$lang[textreplies]</td>\n<td width=\\"6%\\">$lang[textviews]</td>\n<td width=\\"10%\\">$lang[textlastpost]</td>\n<td width=\\"4%\\">$lang[deletecolon]</td>\n<td><input type=\\"checkbox\\" onclick=\\"invertSelection(\\''geatneet\\'', \\''tid[]\\''); return false;\\" /></td>\n</tr>\n$threadlist\n<tr>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"tablerow\\" colspan=\\"10\\">\n<table border=\\"0\\" cellspacing=\\"0\\" cellpadding=\\"0\\" width=\\"100%\\">\n<tr>\n<td class=\\"tablerow\\" align=\\"right\\">\n<input type=\\"hidden\\" name=\\"fid\\" value=\\"$fid\\" />\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<label class=\\"mediumtxt\\"><strong>$lang[textadminoptions]</strong>\n<select name=\\"action\\">\n<option value=\\"\\" selected=\\"selected\\"></option>\n<option value=\\"bump\\">$lang[textbumpthread]</option>\n<option value=\\"f_close\\">$lang[textclosethread]</option>\n<option value=\\"copy\\">$lang[copythread]</option>\n<option value=\\"delete\\">$lang[textdeletethread]</option>\n<option value=\\"empty\\">$lang[textemptythread]</option>\n<option value=\\"move\\">$lang[textmovemethod1]</option>\n<option value=\\"f_open\\">$lang[textopenthread]</option>\n<option value=\\"top\\">$lang[topuntop]</option>\n</select>\n</label>\n&nbsp;&nbsp;\n<input type=\\"submit\\" class=\\"submit\\" name=\\"submit\\" value=\\"$lang[textsubmitchanges]\\" />\n</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"ctrtablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n$sortby\n</td>\n</tr>\n$multipage3\n</table>\n</td>\n</tr>\n</table>\n<table width=\\"{$THEME[\\''tablewidth\\'']}\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" align=\\"center\\" style=\\"margin-top: 3px\\">\n<tr>\n<td class=\\"post\\" align=\\"right\\">&nbsp;$newtopiclink$newpolllink</td>\n</tr>\n</table>\n<br />\n<table width=\\"{$THEME[\\''tablewidth\\'']}\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" align=\\"center\\">\n<tr>\n<td class=\\"tablerow\\">\n<img src=\\"{$THEME[\\''imgdir\\'']}/red_folder.gif\\" alt=\\"$lang[altredfolder]\\" />&nbsp;$lang[opennew] (&nbsp;\n<img src=\\"{$THEME[\\''imgdir\\'']}/hot_red_folder.gif\\" alt=\\"$lang[althotredfolder]\\" />&nbsp;$hottopic&nbsp;)<br />\n<img src=\\"./images/pixel.gif\\" width=\\"1\\" height=\\"4\\" alt=\\"*\\" /><br/>\n<img src=\\"{$THEME[\\''imgdir\\'']}/folder.gif\\" alt=\\"$lang[altfolder]\\" />&nbsp;$lang[opentopic] (&nbsp;\n<img src=\\"{$THEME[\\''imgdir\\'']}/hot_folder.gif\\" alt=\\"$lang[althotfolder]\\" />&nbsp;$hottopic&nbsp;)<br />\n<img src=\\"./images/pixel.gif\\" width=\\"1\\" height=\\"4\\" alt=\\"*\\" /><br/>\n<img src=\\"{$THEME[\\''imgdir\\'']}/lock_folder.gif\\" alt=\\"$lang[altclosedtopic]\\" />&nbsp;$lang[locktopic]</td>\n</tr>\n</table>\n\n'),
(34, 'forumdisplay_multipage', '<tr class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n<td colspan=\\"7\\" class=\\"multi\\">&nbsp;$mpage</td>\n</tr>\n\n'),
(35, 'forumdisplay_multipage_admin', '<tr class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n<td colspan=\\"10\\" class=\\"multi\\">&nbsp;$mpage</td>\n</tr>\n\n'),
(36, 'forumdisplay_multipage_admin3', '<tr class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n<td class=\\"multi\\">&nbsp;$mpage</td>\n</tr>\n\n'),
(37, 'forumdisplay_newpoll', '<a href=\\"post.php?action=newthread&amp;fid=$fid&amp;poll=yes\\" title=\\"$lang[textnewpoll]\\"><img src=\\"{$THEME[\\''imgdir\\'']}/poll.gif\\" border=\\"0\\" alt=\\"$lang[textnewpoll]\\" /></a>\n\n'),
(38, 'forumdisplay_newtopic', '<a href=\\"post.php?action=newthread&amp;fid=$fid\\" title=\\"$lang[altpostnewthread]\\"><img src=\\"{$THEME[\\''imgdir\\'']}/newtopic.gif\\" border=\\"0\\" alt=\\"$lang[altpostnewthread]\\" /></a>\n\n'),
(39, 'forumdisplay_nothreads', '<tr class=\\"tablerow\\">\n<td colspan=\\"7\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$lang[noposts]</td>\n</tr>\n\n'),
(40, 'forumdisplay_nothreads_admin', '<tr class=\\"tablerow\\">\n<td colspan=\\"10\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$lang[noposts]</td>\n</tr>\n\n'),
(41, 'forumdisplay_password', '<br />\n<form method=\\"post\\" action=\\"$url\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textpassword]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"password\\" name=\\"pw\\" size=\\"25\\" /> <br /></td>\n</tr>\n<tr>\n<td class=\\"ctrtablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" colspan=\\"2\\"><input type=\\"submit\\" class=\\"submit\\" name=\\"loginsubmit\\" value=\\"$lang[textlogin]\\" /></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(42, 'forumdisplay_sortby', '<form method=\\"post\\" action=\\"forumdisplay.php?fid=$fid\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n$lang[showtopics]\n&nbsp;&nbsp;\n<select name=\\"cusdate\\">\n<option value=\\"86400\\" $check1>$lang[day1]</option>\n<option value=\\"432000\\" $check5>$lang[day5]</option>\n<option value=\\"1296000\\" $check15>$lang[day15]</option>\n<option value=\\"2592000\\" $check30>$lang[day30]</option>\n<option value=\\"5184000\\" $check60>$lang[day60]</option>\n<option value=\\"8640000\\" $check100>$lang[day100]</option>\n<option value=\\"31536000\\" $checkyear>$lang[lastyear]</option>\n<option value=\\"0\\" $checkall>$lang[beginning]</option>\n</select>\n&nbsp;&nbsp;\n$lang[sortby]\n&nbsp;&nbsp;\n<select name=\\"ascdesc\\">\n<option value=\\"ASC\\">$lang[asc]</option>\n<option value=\\"DESC\\" selected=\\"selected\\">$lang[desc]</option>\n</select>\n&nbsp;&nbsp;<input type=\\"submit\\" class=\\"submit\\" value=\\"$lang[textgo]\\" />\n</form>\n\n'),
(43, 'forumdisplay_subforum', '<tr>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"ctrtablerow\\" align=\\"center\\">$folder</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"tablerow\\"><a href=\\"forumdisplay.php?fid=$forum[fid]\\"><font class=\\"mediumtxt\\">$forum[name]</font>&nbsp;<font class=\\"smalltxt\\">$forum[moderator]</font><br /><font class=\\"smalltxt\\">$forum[description]</font></a></td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"ctrtablerow\\"><font class=\\"mediumtxt\\">$forum[threads]</font></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"ctrtablerow\\"><font class=\\"mediumtxt\\">$forum[posts]</font></td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"lastpostcell\\">$lastpostrow</td>\n</tr>\n\n'),
(44, 'forumdisplay_subforums', '<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\" class=\\"tablelinks\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\"><table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\" align=\\"center\\">\n<tr class=\\"header\\">\n<td width=\\"4%\\">&nbsp;</td>\n<td width=\\"58%\\">$lang[textforum]</td>\n<td width=\\"6%\\" align=\\"center\\">$lang[texttopics]</td>\n<td width=\\"6%\\" align=\\"center\\">$lang[textposts]</td>\n<td width=\\"19%\\">$lang[textlastpost]</td>\n</tr>\n$forumlist\n</table>\n</td>\n</tr>\n</table>\n<br />\n\n'),
(45, 'forumdisplay_subforum_lastpost', '<table cellpadding=\\"0\\" cellspacing=\\"0\\" border=\\"0\\" width=\\"100%\\">\n<tr align=\\"right\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"rghttablerow\\" nowrap=\\"nowrap\\"><a href=\\"viewthread.php?goto=lastpost&amp;fid=$forum[fid]\\" title=\\"$lang[altlastpost]\\" class=\\"smalltxt\\">$lastpost</a></td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"rghttablerow\\" nowrap=\\"nowrap\\"><a href=\\"viewthread.php?goto=lastpost&amp;fid=$forum[fid]\\" title=\\"$lang[altlastpost]\\"><img src=\\"{$THEME[\\''imgdir\\'']}/lastpost.gif\\" border=\\"0\\" alt=\\"$lang[altlastpost]\\" /></a></td>\n</tr>\n</table>\n\n'),
(46, 'forumdisplay_subforum_nolastpost', '<table cellpadding=\\"0\\" cellspacing=\\"0\\" border=\\"0\\" width=\\"100%\\">\n<tr align=\\"right\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"tablerow\\" nowrap=\\"nowrap\\"><font class=\\"smalltxt\\">$lang[textnever]</font></td>\n</tr>\n</table>\n\n'),
(47, 'forumdisplay_thread', '<tr>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"ctrtablerow\\">$folder</td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"ctrtablerow\\">$thread[icon]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"tablerow\\"><font class=\\"mediumtxt\\"><a href=\\"viewthread.php?tid=$thread[tid]\\">$prefix{$thread[\\''subject\\'']}</a></font></td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"ctrtablerow\\">$authorlink</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"ctrtablerow\\"><font class=\\"mediumtxt\\">$thread[replies]</font></td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"ctrtablerow\\"><font class=\\"mediumtxt\\">$thread[views]</font></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"lastpostcell\\">$lastpostrow</td>\n</tr>\n\n'),
(48, 'forumdisplay_thread_admin', '<tr>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"ctrtablerow\\">$folder</td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"ctrtablerow\\">$thread[icon]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"tablerow\\"><font class=\\"mediumtxt\\"><a href=\\"viewthread.php?tid=$thread[tid]\\">$prefix{$thread[\\''subject\\'']}</a></font></td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"ctrtablerow\\"><font class=\\"mediumtxt\\"><a href = \\"topicadmin.php?tid=$thread[tid]&amp;fid=$forum[fid]&amp;action=top\\">$topimage</a></font></td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"ctrtablerow\\">$authorlink</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"ctrtablerow\\"><font class=\\"mediumtxt\\">$thread[replies]</font></td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"ctrtablerow\\"><font class=\\"mediumtxt\\">$thread[views]</font></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"lastpostcell\\">$lastpostrow</td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"ctrtablerow\\"><a href=\\"topicadmin.php?tid=$thread[realtid]&amp;fid=$forum[fid]&amp;action=delete\\"><img src=\\"{$THEME[\\''admdir\\'']}/deletetopic.gif\\" alt=\\"$lang[deletethread]\\" border=\\"0\\" /></a></td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"ctrtablerow\\"><input type=\\"checkbox\\" name=\\"tid[]\\" value=\\"$thread[realtid]\\" /></td>\n</tr>\n\n'),
(49, 'forumdisplay_thread_lastpost', '<table cellpadding=\\"0\\" cellspacing=\\"0\\" border=\\"0\\" width=\\"100%\\">\n<tr align=\\"right\\">\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"rghttablerow\\" nowrap=\\"nowrap\\"><a href=\\"viewthread.php?goto=lastpost&amp;tid=$thread[tid]\\" title=\\"$lang[altlastpost]\\" class=\\"smalltxt\\">$lastpost</a></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"rghttablerow\\" nowrap=\\"nowrap\\"><a href=\\"viewthread.php?goto=lastpost&amp;tid=$thread[tid]\\" title=\\"$lang[altlastpost]\\"><img src=\\"{$THEME[\\''imgdir\\'']}/lastpost.gif\\" border=\\"0\\" alt=\\"$lang[altlastpost]\\" /></a></td>\n</tr>\n</table>\n\n'),
(50, 'functions_bbcode', '<script language=\\"JavaScript\\" type=\\"text/javascript\\">\nvar bbcode_helpmode = \\"$lang[bbcode_helpmode]\\";\nvar bbcode_advmode = \\"$lang[bbcode_advmode]\\";\nvar bbcode_normode = \\"$lang[bbcode_normode]\\";\nvar bbcode_help_email = \\"$lang[bbcode_help_email]\\";\nvar bbcode_prompt_email_desc = \\"$lang[bbcode_prompt_email_desc]\\";\nvar bbcode_prompt_email_email = \\"$lang[bbcode_prompt_email_email]\\";\nvar bbcode_prompt_email_error = \\"$lang[bbcode_prompt_email_error]\\";\nvar bbcode_help_size = \\"$lang[bbcode_help_size]\\";\nvar bbcode_prompt_size = \\"$lang[bbcode_prompt_size]\\";\nvar bbcode_help_font = \\"$lang[bbcode_help_font]\\";\nvar bbcode_prompt_font = \\"$lang[bbcode_prompt_font]\\";\nvar bbcode_help_bold = \\"$lang[bbcode_help_bold]\\";\nvar bbcode_prompt_bold = \\"$lang[bbcode_prompt_bold]\\";\nvar bbcode_help_italic = \\"$lang[bbcode_help_italic]\\";\nvar bbcode_prompt_italic = \\"$lang[bbcode_prompt_italic]\\";\nvar bbcode_help_quote = \\"$lang[bbcode_help_quote]\\";\nvar bbcode_prompt_quote = \\"$lang[bbcode_prompt_quote]\\";\nvar bbcode_help_color = \\"$lang[bbcode_help_color]\\";\nvar bbcode_prompt_color = \\"$lang[bbcode_prompt_color]\\";\nvar bbcode_help_center = \\"$lang[bbcode_help_center]\\";\nvar bbcode_prompt_center = \\"$lang[bbcode_prompt_center]\\";\nvar bbcode_help_link = \\"$lang[bbcode_help_link]\\";\nvar bbcode_prompt_link_url = \\"$lang[bbcode_prompt_link_url]\\";\nvar bbcode_prompt_link_url_error = \\"$lang[bbcode_prompt_link_url_error]\\";\nvar bbcode_prompt_link_desc = \\"$lang[bbcode_prompt_link_desc]\\";\nvar bbcode_help_image = \\"$lang[bbcode_help_image]\\";\nvar bbcode_prompt_image = \\"$lang[bbcode_prompt_image]\\";\nvar bbcode_help_code = \\"$lang[bbcode_help_code]\\";\nvar bbcode_prompt_code = \\"$lang[bbcode_prompt_code]\\";\nvar bbcode_help_list = \\"$lang[bbcode_help_list]\\";\nvar bbcode_prompt_list_item = \\"$lang[bbcode_prompt_list_item]\\";\nvar bbcode_prompt_list_start = \\"$lang[bbcode_prompt_list_start]\\";\nvar bbcode_prompt_list_error = \\"$lang[bbcode_prompt_list_error]\\";\nvar bbcode_prompt_list_end = \\"$lang[bbcode_prompt_list_end]\\";\nvar bbcode_help_underline = \\"$lang[bbcode_help_underline]\\";\nvar bbcode_prompt_underline = \\"$lang[bbcode_prompt_underline]\\";\nvar bbcode_help_youtube = \\"$lang[bbcode_help_youtube]\\";\nvar bbcode_prompt_youtube = \\"$lang[bbcode_prompt_youtube]\\";\n\nvar messageElement;\n</script>\n<script language=\\"JavaScript\\" type=\\"text/javascript\\" src=\\"./js/bbcodefns-$browser.js?v=1.9.12\\"></script>\n<script language=\\"JavaScript\\" type=\\"text/javascript\\">window.onload = loadEls;</script>\n\n'),
(51, 'functions_bbcodeinsert', '<script type=\\"text/javascript\\">$setbbcodemode</script>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[cb_fomatting]<br /><span class=\\"smalltxt\\">\n<input type=\\"radio\\" name=\\"mode\\" value=\\"2\\" onclick=\\"chmode(\\''2\\'')\\" $mode2check /> $lang[cb_normalmode]<br />\n<input type=\\"radio\\" name=\\"mode\\" value=\\"0\\" onclick=\\"chmode(\\''0\\'')\\" $mode0check /> $lang[cb_advmode]<br />\n<input type=\\"radio\\" name=\\"mode\\" value=\\"1\\" onclick=\\"chmode(\\''1\\'')\\" $mode1check /> $lang[cb_helpmode]</span></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n<select name=\\"font\\" onchange=\\"chfont(this.options[this.selectedIndex].value)\\" size=\\"1\\">\n<option value=\\"\\" id=\\"zerofont\\" selected=\\"selected\\">{$lang[\\''textfont\\'']}</option>\n<option value=\\"Andale Mono\\">Andale Mono</option>\n<option value=\\"Arial\\">Arial</option>\n<option value=\\"Arial Black\\">Arial Black</option>\n<option value=\\"Book Antiqua\\">Book Antiqua</option>\n<option value=\\"Century Gothic\\">Century Gothic</option>\n<option value=\\"Comic Sans MS\\">Comic Sans MS</option>\n<option value=\\"Courier New\\">Courier New</option>\n<option value=\\"Georgia\\">Georgia</option>\n<option value=\\"Impact\\">Impact</option>\n<option value=\\"Tahoma\\">Tahoma</option>\n<option value=\\"Times New Roman\\">Times New Roman</option>\n<option value=\\"Trebuchet MS\\">Trebuchet MS</option>\n<option value=\\"Script MT Bold\\">Script MT Bold</option>\n<option value=\\"Stencil\\">Stencil</option>\n<option value=\\"Verdana\\">Verdana</option>\n<option value=\\"Lucida Console\\">Lucida Console</option>\n</select>\n<select name=\\"size\\" onchange=\\"chsize(this.options[this.selectedIndex].value)\\" size=\\"1\\">\n<option value=\\"-2\\">-2</option>\n<option value=\\"-1\\">-1</option>\n<option value=\\"0\\" id=\\"zerosize\\" selected=\\"selected\\">0</option>\n<option value=\\"1\\">1</option>\n<option value=\\"2\\">2</option>\n<option value=\\"3\\">3</option>\n<option value=\\"4\\">4</option>\n<option value=\\"5\\">5</option>\n<option value=\\"6\\">6</option>\n</select>\n<select name=\\"color\\" onchange=\\"chcolor(this.options[this.selectedIndex].value)\\" size=\\"1\\">\n<option value=\\"\\" id=\\"zerocolor\\" selected=\\"selected\\">{$lang[\\''texttext\\'']}</option>\n<option value=\\"White\\" style=\\"color:white;\\">White</option>\n<option value=\\"Black\\" style=\\"color:black;\\">Black</option>\n<option value=\\"Red\\" style=\\"color:red;\\">Red</option>\n<option value=\\"Yellow\\" style=\\"color:yellow;\\">Yellow</option>\n<option value=\\"Pink\\" style=\\"color:pink;\\">Pink</option>\n<option value=\\"Green\\" style=\\"color:green;\\">Green</option>\n<option value=\\"Orange\\" style=\\"color:orange;\\">Orange</option>\n<option value=\\"Purple\\" style=\\"color:purple;\\">Purple</option>\n<option value=\\"Blue\\" style=\\"color:blue;\\">Blue</option>\n<option value=\\"Beige\\" style=\\"color:beige;\\">Beige</option>\n<option value=\\"Brown\\" style=\\"color:brown;\\">Brown</option>\n<option value=\\"Teal\\" style=\\"color:teal;\\">Teal</option>\n<option value=\\"Navy\\" style=\\"color:navy;\\">Navy</option>\n<option value=\\"Maroon\\" style=\\"color:maroon;\\">Maroon</option>\n<option value=\\"LimeGreen\\" style=\\"color:limegreen;\\">LimeGreen</option>\n</select>\n$spelling_lang\n<br />\n<a href=\\"javascript:bold()\\" accesskey=\\"b\\" title=\\"$lang[cb_insert_bold]\\"><img src=\\"{$THEME[\\''imgdir\\'']}/bb_bold.gif\\" border=\\"0\\" width=\\"23\\" height=\\"22\\" alt=\\"$lang[cb_insert_bold]\\" /></a>\n<a href=\\"javascript:italicize()\\" accesskey=\\"i\\" title=\\"$lang[cb_insert_italics]\\"><img src=\\"{$THEME[\\''imgdir\\'']}/bb_italicize.gif\\" border=\\"0\\" width=\\"23\\" height=\\"22\\" alt=\\"$lang[cb_insert_italics]\\" /></a>\n<a href=\\"javascript:underline()\\" accesskey=\\"u\\" title=\\"$lang[cb_insert_underlined]\\"><img src=\\"{$THEME[\\''imgdir\\'']}/bb_underline.gif\\" border=\\"0\\" width=\\"23\\" height=\\"22\\" alt=\\"$lang[cb_insert_underlined]\\" /></a>\n<a href=\\"javascript:center()\\" title=\\"$lang[cb_insert_centered]\\" ><img src=\\"{$THEME[\\''imgdir\\'']}/bb_center.gif\\" border=\\"0\\" width=\\"23\\" height=\\"22\\" alt=\\"$lang[cb_insert_centered]\\" /></a>\n<a href=\\"javascript:hyperlink()\\" title=\\"$lang[cb_insert_hyperlink]\\" ><img src=\\"{$THEME[\\''imgdir\\'']}/bb_url.gif\\" border=\\"0\\" width=\\"23\\" height=\\"22\\" alt=\\"$lang[cb_insert_hyperlink]\\" /></a>\n<a href=\\"javascript:email()\\" title=\\"$lang[cb_insert_email]\\" ><img src=\\"{$THEME[\\''imgdir\\'']}/bb_email.gif\\" border=\\"0\\" width=\\"23\\" height=\\"22\\" alt=\\"$lang[cb_insert_email]\\" /></a>\n<a href=\\"javascript:image()\\" title=\\"$lang[cb_insert_image]\\" ><img src=\\"{$THEME[\\''imgdir\\'']}/bb_image.gif\\" border=\\"0\\" width=\\"23\\" height=\\"22\\" alt=\\"$lang[cb_insert_image]\\" /></a>\n<a href=\\"javascript:code()\\" title=\\"$lang[cb_insert_code]\\" ><img src=\\"{$THEME[\\''imgdir\\'']}/bb_code.gif\\" border=\\"0\\" width=\\"23\\" height=\\"22\\" alt=\\"$lang[cb_insert_code]\\" /></a>\n<a href=\\"javascript:quote()\\" title=\\"$lang[cb_insert_quote]\\" ><img src=\\"{$THEME[\\''imgdir\\'']}/bb_quote.gif\\" border=\\"0\\" width=\\"23\\" height=\\"22\\" alt=\\"$lang[cb_insert_quote]\\" /></a>\n<a href=\\"javascript:list()\\" title=\\"$lang[cb_insert_list]\\" ><img src=\\"{$THEME[\\''imgdir\\'']}/bb_list.gif\\" border=\\"0\\" width=\\"23\\" height=\\"22\\" alt=\\"$lang[cb_insert_list]\\" /></a>\n<a href=\\"javascript:youtube()\\" title=\\"$lang[cb_insert_youtube]\\"><img src=\\"{$THEME[\\''imgdir\\'']}/bb_youtube.gif\\" border=\\"0\\" width=\\"23\\" height=\\"22\\" alt=\\"$lang[cb_insert_youtube]\\" /></a>\n</td>\n</tr>\n\n'),
(52, 'functions_bbcode_quickreply', '<script type=\\"text/javascript\\" src=\\"./js/bbcodefns-$browser.js?v=1.9.12\\"></script>\n<script type=\\"text/javascript\\">\nvar messageElement;\nloadEls();\n</script>\n\n'),
(53, 'functions_smilieinsert', '<td>\n<table align=\\"center\\">\n$smilies\n</table>\n</td>\n\n'),
(54, 'functions_smilieinsert_smilie', '<td valign=\\"top\\"><a style=\\"cursor:hand\\" onclick=\\"javascript:icon(\\''$smilie[code]\\'')\\"><img src=\\"{$THEME[\\''smdir\\'']}/$smilie[url]\\" border=\\"0\\" alt=\\"$smilie[code]\\"/></a></td>\n\n'),
(55, 'header', '<?xml version=\\"1.0\\" encoding=\\"{$lang[\\''charset\\'']}\\"?>\n<!DOCTYPE html PUBLIC \\"-//W3C//DTD XHTML 1.0 Transitional//EN\\" \\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\\">\n<html xmlns=\\"http://www.w3.org/1999/xhtml\\">\n<!-- $versionlong  -->\n<!-- Build: $versionbuild -->\n<!-- $versioncompany -->\n<head>\n$baseelement$canonical_link\n<meta http-equiv=\\"Content-Type\\" content=\\"text/html; charset={$lang[\\''charset\\'']}\\" />\n<meta name=\\"viewport\\" content=\\"width=500, initial-scale=1\\" />\n<title>{$SETTINGS[\\''bbname\\'']} $threadSubject - $versionlong</title>\n$css\n<script language=\\"JavaScript\\" type=\\"text/javascript\\" src=\\"./js/header.js?v=2\\"></script>\n</head>\n<body text=\\"{$THEME[\\''text\\'']}\\">\n$bbcodescript\n<a name=\\"top\\"></a>\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"6\\" width=\\"100%\\">\n<tr>\n<td width=\\"74%\\" {$THEME[\\''topbgcode\\'']}>\n<table border=\\"0\\" width=\\"100%\\" cellpadding=\\"0\\" cellspacing=\\"0\\">\n<tr>\n<td valign=\\"top\\" rowspan=\\"2\\">{$THEME[\\''logo\\'']}</td>\n<td align=\\"right\\" valign=\\"top\\"><font class=\\"smalltxt\\">$lastvisittext<br />$newu2umsg</font></td>\n</tr>\n<tr>\n<td align=\\"right\\" valign=\\"bottom\\"><font class=\\"smalltxt\\">$notify</font></td>\n</tr>\n</table>\n</td>\n</tr>\n<tr>\n<td class=\\"navtd\\">\n<table width=\\"100%\\" cellpadding=\\"0\\" cellspacing=\\"0\\">\n<tr>\n<td class=\\"navtd\\"><font class=\\"navtd\\">$searchlink $links $pluglink</font></td>\n<td align=\\"right\\"><a href=\\"$siteurl\\" title=\\"$sitename\\"><font class=\\"navtd\\">$lang[backto] <img src=\\"{$THEME[\\''imgdir\\'']}/top_home.gif\\" border=\\"0\\" alt=\\"$sitename\\" /></font></a></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<table cellspacing=\\"0\\" cellpadding=\\"1\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td><table width=\\"100%\\" cellspacing=\\"0\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" align=\\"center\\">\n<tr>\n<td class=\\"nav\\"> <a href=\\"./\\">$bbname</a> $navigation</td>\n<td align=\\"right\\">$quickjump</td>\n<td align=\\"right\\" width=\\"1\\"><a href=\\"#bottom\\" title=\\"$lang[gotobottom]\\"><img src=\\"{$THEME[\\''imgdir\\'']}/arrow_dw.gif\\" border=\\"0\\" alt=\\"$lang[gotobottom]\\" /></a></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n\n'),
(56, 'index', '$ticker\n$welcome\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\" align=\\"center\\" class=\\"tablelinks\\">\n$indexBarTop\n$forumlist\n</table>\n</td>\n</tr>\n</table>\n$whosonline\n$statsbar\n\n'),
(57, 'index_category', '<tr>\n<td colspan=\\"5\\" class=\\"category\\"><a href=\\"index.php?gid=$thing[cat_fid]\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$thing[cat_name]</strong></font></a></td>\n</tr>\n\n'),
(58, 'index_category_hr', '<tr class=\\"header\\" align=\\"center\\">\n<td width=\\"4%\\">&nbsp;</td>\n<td width=\\"54%\\">$lang[textforum]</td>\n<td width=\\"6%\\">$lang[texttopics]</td>\n<td width=\\"6%\\">$lang[textposts]</td>\n<td width=\\"19%\\">$lang[textlastpost]</td>\n</tr>\n\n'),
(59, 'index_category_spacer', '</table>\n</td>\n</tr>\n</table>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\" class=\\"tablelinks\\">\n\n'),
(60, 'index_forum', '<tr>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"ctrtablerow\\" width=\\"4%\\">$folder</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"tablerow\\" width=\\"54%\\"><a href=\\"./forumdisplay.php?fid=$forum[fid]\\"><font class=\\"mediumtxt\\"><strong>$forum[name]</strong></font><br /><br /><font class=\\"smalltxt\\">{$forum[\\''description\\'']}</font></a><span class=\\"smalltxt plainlinks\\">{$forum[\\''moderator\\'']}</span><font class=\\"smalltxt\\">$subforums</font></td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"ctrtablerow\\" width=\\"6%\\"><font class=\\"mediumtxt\\">$forum[threads]</font></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"ctrtablerow\\" width=\\"6%\\"><font class=\\"mediumtxt\\">$forum[posts]</font></td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"lastpostcell\\" width=\\"19%\\">$lastpostrow</td>\n</tr>\n\n'),
(61, 'index_forum_lastpost', '<table cellpadding=\\"0\\" cellspacing=\\"0\\" border=\\"0\\" width=\\"100%\\">\n<tr class=\\"rghttablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" nowrap=\\"nowrap\\"><a href=\\"./viewthread.php?goto=lastpost&amp;fid=$forum[fid]\\" title=\\"$lang[altlastpost]\\" class=\\"smalltxt\\">$lastpost</a></td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" nowrap=\\"nowrap\\"><a href=\\"./viewthread.php?goto=lastpost&amp;fid=$forum[fid]\\" title=\\"$lang[altlastpost]\\"><img src=\\"{$THEME[\\''imgdir\\'']}/lastpost.gif\\" border=\\"0\\" alt=\\"$lang[altlastpost]\\" /></a></td>\n</tr>\n</table>\n\n'),
(62, 'index_forum_nolastpost', '<table cellpadding=\\"0\\" cellspacing=\\"0\\" border=\\"0\\" width=\\"100%\\">\n<tr align=\\"right\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"tablerow\\" nowrap=\\"nowrap\\"><font class=\\"smalltxt\\">$lang[textnever]</font></td>\n</tr>\n</table>\n\n'),
(63, 'index_noforum', '<tr>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"ctrtablerow\\" colspan=\\"5\\"><font class=\\"mediumtxt\\">$lang[textnoforumsexist]</font></td>\n</tr>\n\n'),
(64, 'index_stats', '<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td align=\\"left\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textstats]:</strong></font></td>\n<td align=\\"left\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[key]</strong></font></td>\n</tr>\n<tr class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n<td width=\\"50%\\" align=\\"left\\" valign=\\"top\\">$indexstats<br />$lang[stats4] $memhtml</td>\n<td width=\\"50%\\" align=\\"left\\" valign=\\"top\\"><img src=\\"{$THEME[\\''imgdir\\'']}/red_folder.gif\\" alt=\\"$lang[altredfolder]\\" /> = $lang[newposts]<br /><img src=\\"{$THEME[\\''imgdir\\'']}/folder.gif\\" alt=\\"$lang[altnormalfolder]\\" /> = $lang[nonewposts]</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n\n'),
(65, 'index_ticker', '<script type=\\"text/javascript\\" language=\\"JavaScript\\" src=\\"./js/ticker.js\\"></script>\n<script type=\\"text/javascript\\" language=\\"JavaScript\\">\n<!--//--><![CDATA[//><!--\nvar stopticker = \\"$lang[stopticker]\\";\nvar startticker = \\"$lang[startticker]\\";\nvar delay = {$SETTINGS[\\''tickerdelay\\'']};\nvar node = \\''\\'';\nvar current = 0;\nvar running = false;\nvar contents = new Array();\n$contents\nsetTickerEvent();\n//--><!]]>\n</script>\n<table border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"0\\" cellpadding=\\"0\\" width=\\"100%\\">\n<tr>\n<td class=\\"tablerow\\" colspan=\\"2\\" width=\\"100%\\">\n<table cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" border=\\"0\\" width=\\"100%\\" align=\\"center\\">\n<tr>\n<td class=\\"category\\"><strong><font color=\\"{$THEME[\\''cattext\\'']}\\">$lang[tickername] [<a id=\\"tickertoggle\\" href=\\"javascript:tickertoggle();\\">&nbsp;</a>]</font></strong></td>\n</tr>\n<tr>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"mediumtxt\\" style=\\"height: 30px;\\"><div align=\\"center\\" id=\\"tickerdiv\\"></div></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n\n'),
(66, 'index_welcome_guest', '<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\" colspan=\\"2\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[welcomeunregnotify]</strong></font></td>\n</tr>\n<tr bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"tablerow\\">\n<td><font size=\\"1\\">$lang[welcomeunreg]</font></td>\n<td align=\\"right\\" width=\\"25%\\">\n<form method=\\"post\\" action=\\"misc.php?action=login\\" onsubmit=\\"return disableButton(this);\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<input type=\\"hidden\\" name=\\"hide\\" value=\\"2\\" />\n<table border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\">\n<tr>\n<td nowrap=\\"nowrap\\">\n<input type=\\"text\\" name=\\"username\\" size=\\"7\\" accesskey=\\"u\\" />\n<input type=\\"password\\" name=\\"password\\" size=\\"7\\" accesskey=\\"p\\" />\n<input type=\\"submit\\" class=\\"submit\\" name=\\"loginsubmit\\" value=\\"$lang[textlogin]\\" />\n</td>\n</tr>\n</table>\n</form>\n</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n\n'),
(67, 'index_welcome_member', '<table border=\\"0\\" cellspacing=\\"0\\" cellpadding=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\" align=\\"center\\">\n<tr>\n<td>\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr class=\\"category\\">\n<td colspan=\\"3\\">\n<table border=\\"0\\" cellspacing=\\"0\\" cellpadding=\\"0\\" width=\\"100%\\">\n<tr class=\\"tablerow\\">\n<td align=\\"left\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textpersonalfeat]</strong></font></td>\n<td align=\\"right\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textloggedinas] $self[username]</strong></font> <a href=\\"misc.php?action=logout\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[welcomelogout]</strong></font></a></td>\n</tr>\n</table>\n</td>\n</tr>\n<tr class=\\"ctrtablerow tablelinks\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n<td width=\\"33%\\"><a href=\\"memcp.php\\"><strong>$lang[textusercp]</strong></a></td>\n<td width=\\"33%\\"><a href=\\"u2u.php\\" onclick=\\"Popup(this.href,\\''Window\\'', 700, 450); return false;\\"><strong>{$lang[\\''textu2umessenger\\'']}</strong></a></td>\n<td width=\\"33%\\"><a href=\\"buddy.php\\" onclick=\\"Popup(this.href, \\''Window\\'', 450, 400); return false;\\"><strong>{$lang[\\''launchbuddylist\\'']}</strong></a></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n\n'),
(68, 'index_whosonline', '<br />\n<table border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"0\\" cellpadding=\\"0\\" width=\\"100%\\">\n<tr>\n<td class=\\"tablerow\\" colspan=\\"2\\" width=\\"100%\\">\n<table cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" border=\\"0\\" width=\\"100%\\" align=\\"center\\">\n<tr>\n<td colspan=\\"2\\" class=\\"category\\">\n<a href=\\"misc.php?action=online\\"><strong><font color=\\"{$THEME[\\''cattext\\'']}\\">$lang[whosonline]</font></strong></a><font color=\\"{$THEME[\\''cattext\\'']}\\"> - $memonmsg</font>\n</td>\n</tr>\n<tr>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" colspan=\\"2\\" class=\\"smalltxt\\">\n$lang[key]\n<span class=\\"status_Super_Administrator\\">$lang[superadmin]</span> - \n<span class=\\"status_Administrator\\">$lang[textsendadmin]</span> - \n<span class=\\"status_Super_Moderator\\">$lang[textsendsupermod]</span> - \n<span class=\\"status_Moderator\\">$lang[textsendmod]</span> - \n<span class=\\"status_Member\\">$lang[textsendall]</span>$hidden\n</td>\n</tr>\n<tr>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" align=\\"center\\" width=\\"4%\\">\n<img src=\\"{$THEME[\\''imgdir\\'']}/online.gif\\" alt=\\"$lang[whosonline]\\" border=\\"0\\" />\n</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"mediumtxt\\">\n$memtally&nbsp;\n</td>\n</tr>\n$whosonlinetoday\n</table>\n</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n\n'),
(69, 'index_whosonline_today', '<tr>\n<td colspan=\\"2\\" class=\\"category\\">\n<a href=\\"misc.php?action=onlinetoday\\"><strong><font color=\\"{$THEME[\\''cattext\\'']}\\">[+] $last50today</font></strong></a>\n</td>\n</tr>\n<tr>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" colspan=\\"2\\" class=\\"mediumtxt\\">\n$todaymembers&nbsp;\n</td>\n</tr>\n<tr>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" colspan=\\"2\\" class=\\"mediumtxt\\">$memontoday</td>\n</tr>\n\n'),
(70, 'lost_pw_reset', '<form method=\\"post\\" action=\\"lost.php\\" onsubmit=\\"return disableButton(this);\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"$token\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\" colspan=\\"2\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>{$lang[\\''textlostpw\\'']}</strong></font></td>\n</tr>\n<tr>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"tablerow\\" colspan=\\"2\\">{$lang[\\''textlostpwnote2\\'']}</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">{$lang[\\''textusername\\'']}</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"username\\" size=\\"25\\" maxlength=\\"25\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">{$lang[\\''textnewpassword\\'']}</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"password\\" name=\\"password1\\" size=\\"25\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">{$lang[\\''textpasswordcf\\'']}</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"password\\" name=\\"password2\\" size=\\"25\\" /><br /></td>\n</tr>\n<tr class=\\"ctrtablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" colspan=\\"2\\"><input type=\\"submit\\" class=\\"submit\\" name=\\"lostpwsubmit\\" value=\\"{$lang[\\''textsubmit\\'']}\\" /></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(71, 'member_coppa', '<form method=\\"post\\" action=\\"\\" onsubmit=\\"return disableButton(this);\\">\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\" colspan=\\"2\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>{$lang[\\''coppa_title\\'']}</strong></font></td>\n</tr>\n<tr>\n <td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"ctrtablerow\\">\n  <p>{$lang[\\''coppa_directions\\'']}\n   <select name=\\"age\\" id=\\"age\\">\n    $optionlist\n   </select>\n  </p>\n  <p>{$lang[\\''coppa_explained\\'']}</p>\n  <p>\n   <input type=\\"submit\\" class=\\"submit\\" name=\\"regsubmit\\" value=\\"{$lang[\\''continue_button\\'']}\\" />\n   <input type=\\"hidden\\" name=\\"step\\" value=\\"$stepout\\" />\n   <input type=\\"hidden\\" name=\\"token\\" value=\\"$token\\" />\n  </p>\n </td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n');
INSERT INTO `[[dbprefix]]templates` VALUES
(72, 'member_profile', '<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td colspan=\\"2\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textprofor] $member</strong></font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textusername]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">{$memberinfo[\\''username\\'']}$memberlinks</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textregistered]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$memberinfo[regdate] ($ppd $lang[textmesperday])</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textposts]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$memberinfo[postnum] ($percent% $lang[textoftotposts])</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" valign=\\"top\\">$lang[textstatus]<br />$newsitelink</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$showtitle$customstatus<br />$stars<br /><br />$rank[avatarrank]</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" valign=\\"top\\">$lang[lastactive]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$lastmembervisittext</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\"><table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td colspan=\\"2\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[memcp_otherinfo]</strong></font></td>\n</tr>\n$emailblock\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textsite]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><a href=\\"$site\\" onclick=\\"window.open(this.href); return false;\\">$site</a></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textaim]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><a href=\\"aim:goim?screenname={$memberinfo[\\''aimrecode\\'']}&amp;message=Hi+{$memberinfo[\\''aimrecode\\'']}.+Are+you+there+I+got+your+aim+name+from+a+message+board.\\">{$memberinfo[\\''aim\\'']}</a></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[texticq]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><a href=\\"icq:message?uin={$memberinfo[\\''icq\\'']}\\" onclick=\\"window.open(this.href); return false;\\">$memberinfo[icq]</a></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textyahoo]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><a href=\\"ymsgr:sendim?{$memberinfo[\\''yahoorecode\\'']}\\" onclick=\\"window.open(this.href); return false;\\">{$memberinfo[\\''yahoo\\'']}</a></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textmsn]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><a href=\\"msnim:chat?{$memberinfo[\\''msnrecode\\'']}\\" onclick=\\"window.open(this.href); return false;\\">{$memberinfo[\\''msn\\'']}</a></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textlocation]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$memberinfo[location]</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textbday]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$memberinfo[bday]</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" valign=\\"top\\">$lang[textbio]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$memberinfo[bio]</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" valign=\\"top\\">$lang[userprofilemood]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$memberinfo[mood]</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" valign=\\"top\\">$lang[textprofforumma]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$topforum</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" valign=\\"top\\">$lang[textproflastpost]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$lastpost</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td colspan=\\"2\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[memcp_otheroptions]</strong></font></td>\n</tr>\n<tr>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" colspan=\\"2\\" class=\\"tablerow\\"><strong>$lang[searchusermsg]</strong> $admin_edit</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n\n'),
(73, 'member_profile_email', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textemail]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><a href=\\"mailto:$email\\">$email</a></td>\n</tr>\n\n'),
(74, 'member_reg', '<form method=\\"post\\" action=\\"\\" onsubmit=\\"return disableButton(this);\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"$token\\" />\n<input type=\\"hidden\\" name=\\"step\\" value=\\"$stepout\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td colspan=\\"2\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textregister] - $lang[required]</strong></font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textusername]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"username\\" size=\\"25\\" maxlength=\\"25\\" /> {$lang[\\''usernamechars\\'']}</td>\n</tr>\n$pwtd\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textemail]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"email\\" size=\\"25\\" value=\\"\\" /></td>\n</tr>\n$regoptional\n<tr>\n<td colspan=\\"2\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textregister] - $lang[textoptions]</strong></font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[texttheme]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$themelist</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textlanguage]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$langfileselect</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textbday]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n<select name=\\"month\\">\n<option value=\\"0\\">&nbsp;</option>\n<option value=\\"1\\">$lang[textjan]</option>\n<option value=\\"2\\">$lang[textfeb]</option>\n<option value=\\"3\\">$lang[textmar]</option>\n<option value=\\"4\\">$lang[textapr]</option>\n<option value=\\"5\\">$lang[textmay]</option>\n<option value=\\"6\\">$lang[textjun]</option>\n<option value=\\"7\\">$lang[textjul]</option>\n<option value=\\"8\\">$lang[textaug]</option>\n<option value=\\"9\\">$lang[textsep]</option>\n<option value=\\"10\\">$lang[textoct]</option>\n<option value=\\"11\\">$lang[textnov]</option>\n<option value=\\"12\\">$lang[textdec]</option>\n</select>\n$dayselect\n<input type=\\"text\\" name=\\"year\\" size=\\"4\\" />\n</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[texttpp]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"tpp\\" value=\\"$topicperpage\\" size=\\"4\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textppp]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"ppp\\" value=\\"$postperpage\\" size=\\"4\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textshowemail]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"checkbox\\" name=\\"showemail\\" value=\\"yes\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textgetnews]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"checkbox\\" name=\\"newsletter\\" value=\\"yes\\" checked=\\"checked\\" /> </td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[u2ualert1]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n<select name=\\"u2ualert\\">\n<option value=\\"2\\">$lang[u2ualert2]</option>\n<option value=\\"1\\">$lang[u2ualert3]</option>\n<option value=\\"0\\">$lang[u2ualert4]</option>\n</select>\n</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textuseoldu2u]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"checkbox\\" name=\\"useoldu2u\\" value=\\"yes\\" />\n</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textsaveog]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"checkbox\\" name=\\"saveogu2u\\" value=\\"yes\\" checked=\\"checked\\" />\n</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textemailonu2u]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"checkbox\\" name=\\"emailonu2u\\" value=\\"yes\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[texttimeformat]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"radio\\" value=\\"24\\" name=\\"timeformatnew\\" $timeFormat24Checked/>&nbsp;$lang[text24hour]&nbsp;<input type=\\"radio\\" value=\\"12\\" name=\\"timeformatnew\\" $timeFormat12Checked />&nbsp;$lang[text12hour]</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[dateformat]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"dateformatnew\\" size=\\"25\\" value=\\"$dformatorig\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$textoffset</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n$timezones\n</td>\n</tr>\n<tr class=\\"ctrtablerow\\">\n<td colspan=\\"2\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"submit\\" class=\\"submit\\" name=\\"regsubmit\\" value=\\"$lang[textregister]\\" /></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(75, 'member_reg_avatarlist', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textavatar]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><select name=\\"newavatar\\" onchange=\\"document.images.avatarpic.src = this[this.selectedIndex].value;\\">$avatars</select> &nbsp;\n<img src=\\"./images/avatars/clear_avatar.gif\\" id=\\"avatarpic\\" align=\\"middle\\" border=\\"0\\" alt=\\"*\\" /></td>\n</tr>\n\n'),
(76, 'member_reg_avatarurl', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textavatarurl]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n<input type=\\"hidden\\" name=\\"newavatarcheck\\" id=\\"newavatarcheck\\" value=\\"no\\" />\n<input type=\\"text\\" name=\\"newavatar\\" size=\\"25\\" onblur=\\"avatarCheck(this, \\''$SETTINGS[max_avatar_size]\\'', $js_https_only)\\" />\n<p id=\\"avatarCheck\\" style=\\"display: inline;\\"></p>\n</td>\n</tr>\n\n'),
(77, 'member_reg_captcha', '<form method=\\"post\\" action=\\"\\" onsubmit=\\"return disableButton(this);\\">\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>{$lang[\\''captchaverification\\'']}</strong></font></td>\n</tr>\n<tr>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"tablerow\\">\n <p>{$lang[\\''verificationnote\\'']}</p>$casesense\n <p><img src=\\"misc.php?action=captchaimage&amp;imagehash=$imghash\\" alt=\\"{$lang[\\''captchaverification\\'']}\\" title=\\"{$lang[\\''captchaverification\\'']}\\" /></p>\n <p><input type=\\"text\\" name=\\"imgcode\\" value=\\"\\" /></p>\n</td>\n</tr>\n<tr>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"ctrtablerow\\">\n <input type=\\"submit\\" class=\\"submit\\" name=\\"gcaptcha\\" value=\\"{$lang[\\''continue_button\\'']}\\" />\n <input type=\\"hidden\\" name=\\"imghash\\" value=\\"$imghash\\" />\n <input type=\\"hidden\\" name=\\"step\\" value=\\"$stepout\\" />\n</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(78, 'member_reg_gcaptcha', '<form method=\\"post\\" action=\\"\\">\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>{$lang[\\''captchaverification\\'']}</strong></font></td>\n</tr>\n<tr>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"tablerow\\">\n <p>{$lang[\\''google_captcha_directions\\'']}</p>\n <div class=\\"g-recaptcha\\" data-sitekey=\\"{$SETTINGS[\\''google_captcha_sitekey\\'']}\\"></div>\n</td>\n</tr>\n<tr>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"ctrtablerow\\">\n <input type=\\"submit\\" class=\\"submit\\" name=\\"gcaptcha\\" value=\\"{$lang[\\''continue_button\\'']}\\" />\n <input type=\\"hidden\\" name=\\"step\\" value=\\"$stepout\\" />\n</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(79, 'member_reg_optional', '<tr>\n<td colspan=\\"2\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textregister] - $lang[optional]</strong></font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textsite]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"site\\" size=\\"25\\" value=\\"\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textaim]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"aim\\" size=\\"25\\" value=\\"\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[texticq]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"icq\\" size=\\"25\\" value=\\"\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textyahoo]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"yahoo\\" size=\\"25\\" value=\\"\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textmsn]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"msn\\" size=\\"25\\" value=\\"\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textlocation]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"location\\" size=\\"25\\" value=\\"\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[memcpmood]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"mood\\" size=\\"25\\" value=\\"\\" value=\\"\\" /></td>\n</tr>\n$avatd\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textbio]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><textarea rows=\\"5\\" cols=\\"45\\" name=\\"bio\\"></textarea></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textsig]<br /><span class=\\"smalltxt\\">$lang[texthtmlis] $htmlis<br />$lang[textbbcodeis] $bbcodeis</span></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><textarea rows=\\"5\\" cols=\\"45\\" name=\\"sig\\"></textarea></td>\n</tr>\n\n'),
(80, 'member_reg_password', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textpassword]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"password\\" name=\\"password\\" size=\\"25\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textretypepw]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"password\\" name=\\"password2\\" size=\\"25\\" /></td>\n</tr>\n\n'),
(81, 'member_reg_rules', '<form method=\\"post\\" action=\\"member.php?action=reg\\" onsubmit=\\"return disableButton(this);\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"$token\\" />\n<input type=\\"hidden\\" name=\\"step\\" value=\\"$stepout\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[registerrulestitle]</strong></font></td>\n</tr>\n<tr>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"tablerow\\">$lang[rulesoninfo]</td>\n</tr>\n<tr>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"tablerow\\">$SETTINGS[bbrulestxt]</td>\n</tr>\n<tr>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"ctrtablerow\\"><input type=\\"submit\\" class=\\"submit\\" name=\\"rulesubmit\\" value=\\"$lang[textagree]\\" /></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(82, 'memcp_devices', '<form method=\\"post\\" action=\\"memcp.php?action=devices\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td colspan=\\"6\\" class=\\"category\\" align=\\"center\\" {$THEME[\\''catbgcode\\'']}><strong><font color=\\"{$THEME[\\''cattext\\'']}\\">{$lang[\\''devices_category\\'']}</font></strong></td>\n</tr>\n<tr class=\\"header\\">\n<td width=\\"4%\\" align=\\"center\\">{$lang[\\''deletebutton\\'']}</td>\n<td width=\\"6%\\" align=\\"center\\">{$lang[\\''device_id_hdr\\'']}</td>\n<td width=\\"20%\\">{$lang[\\''device_login_date\\'']}</td>\n<td width=\\"70%\\">{$lang[\\''device_agent_hdr\\'']}</td>\n</tr>\n$current\n$other\n$devicesbtn\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(83, 'memcp_devices_button', '<tr class=\\"ctrtablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" colspan=\\"4\\"><input type=\\"submit\\" class=\\"submit\\" name=\\"devicesubmit\\" value=\\"{$lang[\\''device_delete_btn\\'']}\\" /></td>\n</tr>\n\n'),
(84, 'memcp_devices_firstrow', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\"></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" align=\\"center\\">{$lang[\\''device_this\\'']}</td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$dlogin</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$dagent</a></td>\n</tr>\n\n'),
(85, 'memcp_devices_row', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" align=\\"center\\"><input type=\\"checkbox\\" name=\\"delete$did\\" value=\\"$did\\" /></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" align=\\"center\\">$did</td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$dlogin</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$dagent</a></td>\n</tr>\n\n'),
(86, 'memcp_favs', '<form method=\\"post\\" action=\\"memcp.php?action=favorites\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\" class=\\"tablelinks\\">\n<tr>\n<td colspan=\\"6\\" class=\\"category\\" align=\\"center\\" {$THEME[\\''catbgcode\\'']}><strong><font color=\\"{$THEME[\\''cattext\\'']}\\">$lang[textfavorites]</font></strong></td>\n</tr>\n<tr class=\\"header\\">\n<td align=\\"center\\" width=\\"4%\\">$lang[deletebutton]</td>\n<td width=\\"4%\\" align=\\"center\\">$lang[texticon]</td>\n<td width=\\"43%\\">$lang[textsubject]</td>\n<td width=\\"24%\\">$lang[textforum]</td>\n<td width=\\"6%\\" align=\\"center\\">$lang[textreplies]</td>\n<td width=\\"19%\\">$lang[textlastpost]</td>\n</tr>\n$favs\n$favsbtn\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(87, 'memcp_favs_button', '<tr class=\\"ctrtablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" colspan=\\"6\\"><input type=\\"submit\\" class=\\"submit\\" name=\\"favsubmit\\" value=\\"$lang[textdeleteselectedfavs]\\" /></td>\n</tr>\n\n'),
(88, 'memcp_favs_none', '<tr>\n<td class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" colspan=\\"6\\">$lang[nofavsmsg]</td>\n</tr>\n\n'),
(89, 'memcp_favs_row', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"4%\\" align=\\"center\\"><input type=\\"checkbox\\" name=\\"delete$fav[tid]\\" value=\\"$fav[tid]\\" /></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" width=\\"4%\\" align=\\"center\\">$fav[icon]</td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"43%\\"><a href=\\"viewthread.php?tid=$fav[tid]\\">$fav[subject]</a></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" width=\\"24%\\"><a href=\\"forumdisplay.php?fid=$forum[fid]\\">$forum[name]</a></td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"6%\\" align=\\"center\\">$fav[replies]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" width=\\"19%\\"><a href=\\"viewthread.php?goto=lastpost&amp;tid={$fav[\\''tid\\'']}\\" title=\\"{$lang[\\''altlastpost\\'']}\\" class=\\"smalltxt\\">$lastpost</a></td>\n</tr>\n\n'),
(90, 'memcp_home', '<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td align=\\"center\\" colspan=\\"2\\" style=\\"padding-bottom: 3px\\"><font class=\\"mediumtxt\\">$usercpwelcome</font></td>\n</tr>\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\"><table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr class=\\"header\\">\n<td colspan=\\"6\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\">$lang[textbriefsummary] $self[username] - [$self[status]]</font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textusername]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$member[username]</td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textposts]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$member[postnum]</td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" valign=\\"top\\">$lang[mcpuid]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" valign=\\"top\\">$member[uid]</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" valign=\\"top\\">$lang[cp_subscription]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" valign=\\"top\\">$member[newsletter]</td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" valign=\\"top\\">$lang[textemail]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" valign=\\"top\\">$member[email]</td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" valign=\\"top\\">$lang[mood]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" valign=\\"top\\">$member[mood]</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" valign=\\"top\\">$lang[textstatus]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" valign=\\"top\\">$member[status]</td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" valign=\\"top\\">$lang[textavatar]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" align=\\"center\\">$member[avatar]</td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" valign=\\"top\\">$lang[texttheme]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" valign=\\"top\\">$THEME[name]</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" valign=\\"top\\">$lang[textcusstatus]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" valign=\\"top\\">$member[customstatus]</td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" valign=\\"top\\">&nbsp;</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" valign=\\"top\\">&nbsp;</td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" valign=\\"top\\">&nbsp;</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" valign=\\"top\\">&nbsp;</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<br />\n</td>\n</tr>\n</table></td>\n</tr>\n</table>\n<br />\n<table width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td valign=\\"top\\">\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"100%\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\"><table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textbuddylist]</strong></font></td>\n</tr>\n<tr>\n<td class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\"><table width=\\"98%\\">\n<tr>\n<td class=\\"ctrtablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" colspan=\\"2\\"><strong>$lang[textonline]</strong></td>\n</tr>\n$buddys[online]\n<tr>\n<td class=\\"ctrtablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" colspan=\\"2\\"><strong>$lang[textoffline]</strong></td>\n</tr>\n$buddys[offline]\n</table>\n</td>\n</tr>\n<tr>\n<td class=\\"ctrtablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><strong><a href=\\"buddy.php\\" onclick=\\"Popup(this.href, \\''Window\\'', 450, 400); return false;\\">{$lang[\\''launchbuddylist\\'']}</a></strong></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</td>\n<td valign=\\"top\\">\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"100%\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\" class=\\"tablelinks\\">\n<tr class=\\"category\\">\n<td colspan=\\"4\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textlatestu2us]</strong></font></td>\n</tr>\n<tr class=\\"header\\">\n<td>$lang[textsubject]</td>\n<td>$lang[textfrom]</td>\n<td>$lang[textsent]</td>\n<td>$lang[mcpread]</td>\n</tr>\n$messages\n<tr>\n<td colspan=\\"4\\" class=\\"header\\" valign=\\"top\\"><a href=\\"u2u.php\\" onclick=\\"Popup(this.href,\\''Window\\'', 700, 450); return false;\\">{$lang[\\''viewcompleteinbox\\'']}</a></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"100%\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\" class=\\"tablelinks\\">\n<tr class=\\"category\\">\n<td colspan=\\"5\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textlatestfavs]</strong></font></td>\n</tr>\n<tr class=\\"header\\">\n<td align=\\"center\\" width=\\"4%\\">$lang[texticon]</td>\n<td width=\\"43%\\">$lang[textsubject]</td>\n<td width=\\"24%\\">$lang[textforum]</td>\n<td align=\\"center\\" width=\\"6%\\">$lang[textreplies]</td>\n<td width=\\"19%\\">$lang[textlastpost]</td>\n</tr>\n$favs\n</table>\n</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n\n'),
(91, 'memcp_home_favs_none', '<tr>\n<td class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" colspan=\\"5\\">$lang[nofavsmsg]</td>\n</tr>\n\n'),
(92, 'memcp_home_favs_row', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" width=\\"4%\\" align=\\"center\\">$fav[icon]</td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"43%\\"><a href=\\"viewthread.php?tid=$fav[tid]\\">$fav[subject]</a></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" width=\\"24%\\"><a href=\\"forumdisplay.php?fid=$forum[fid]\\">$forum[name]</a></td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"6%\\" align=\\"center\\">$fav[replies]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" width=\\"19%\\"><a href=\\"viewthread.php?goto=lastpost&amp;tid={$fav[\\''tid\\'']}\\" title=\\"{$lang[\\''altlastpost\\'']}\\" class=\\"smalltxt\\">$lastpost</a></td>\n</tr>\n\n'),
(93, 'memcp_home_u2u_none', '<tr>\n<td class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" colspan=\\"4\\">$lang[nou2umsg]</td>\n</tr>\n\n'),
(94, 'memcp_home_u2u_row', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><a href=\\"u2u.php?action=view&amp;u2uid={$message[\\''u2uid\\'']}\\" onclick=\\"Popup(this.href, \\''Window\\'', 700, 450); return false;\\">{$message[\\''subject\\'']}</a></td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$message[msgfrom]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$senton</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$read</td>\n</tr>\n\n'),
(95, 'memcp_profile', '<form method=\\"post\\" action=\\"memcp.php?action=profile\\" name=\\"reg\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td colspan=\\"2\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[texteditpro] - $lang[required]</strong></font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">{$lang[\\''textusername\\'']}</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">{$self[\\''username\\'']}</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textemail]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"newemail\\" size=\\"25\\" value=\\"$member[email]\\" /></td>\n</tr>\n<tr>\n<td colspan=\\"2\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[pwchange] - $lang[optional]</strong></font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">{$lang[\\''textoldpassword\\'']}</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"password\\" name=\\"oldpassword\\" size=\\"25\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textnewpassword]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"password\\" name=\\"newpassword\\" size=\\"25\\" /> $lang[pwnote]</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textpasswordcf]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"password\\" name=\\"newpasswordcf\\" size=\\"25\\" /></td>\n</tr>\n$optional\n<tr>\n<td colspan=\\"2\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[texteditpro] - $lang[textoptions]</strong></font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[texttheme]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$themelist </td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textlanguage]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$langfileselect </td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textbday]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><select name=\\"month\\">\n<option value=\\"\\" $sel[0]>&nbsp;</option>\n<option value=\\"1\\" $sel[1]>$lang[textjan]</option>\n<option value=\\"2\\" $sel[2]>$lang[textfeb]</option>\n<option value=\\"3\\" $sel[3]>$lang[textmar]</option>\n<option value=\\"4\\" $sel[4]>$lang[textapr]</option>\n<option value=\\"5\\" $sel[5]>$lang[textmay]</option>\n<option value=\\"6\\" $sel[6]>$lang[textjun]</option>\n<option value=\\"7\\" $sel[7]>$lang[textjul]</option>\n<option value=\\"8\\" $sel[8]>$lang[textaug]</option>\n<option value=\\"9\\" $sel[9]>$lang[textsep]</option>\n<option value=\\"10\\" $sel[10]>$lang[textoct]</option>\n<option value=\\"11\\" $sel[11]>$lang[textnov]</option>\n<option value=\\"12\\" $sel[12]>$lang[textdec]</option>\n</select>\n$dayselect\n<input type=\\"text\\" name=\\"year\\" size=\\"4\\" value=\\"$year\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[texttpp]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"tppnew\\" size=\\"4\\" value=\\"$member[tpp]\\" /> </td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textppp]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"pppnew\\" size=\\"4\\" value=\\"$member[ppp]\\" /> </td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textshowemail]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"checkbox\\" name=\\"newshowemail\\" value=\\"yes\\" $checked /> </td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textinvisible]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"checkbox\\" name=\\"newinv\\" value=\\"1\\" $invchecked /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">{$lang[\\''subdefault\\'']}</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"checkbox\\" name=\\"newsubs\\" value=\\"yes\\" $subschecked /> </td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textgetnews]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"checkbox\\" name=\\"newnewsletter\\" value=\\"yes\\" $newschecked /> </td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[u2ualert1]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n<select name=\\"u2ualert\\">\n<option value=\\"2\\" $u2uasel2>$lang[u2ualert2]</option>\n<option value=\\"1\\" $u2uasel1>$lang[u2ualert3]</option>\n<option value=\\"0\\" $u2uasel0>$lang[u2ualert4]</option>\n</select>\n</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textuseoldu2u]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"checkbox\\" name=\\"useoldu2u\\" value=\\"yes\\" $uou2uchecked />\n</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textsaveog]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"checkbox\\" name=\\"saveogu2u\\" value=\\"yes\\" $ogu2uchecked /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textemailonu2u]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"checkbox\\" name=\\"emailonu2u\\" value=\\"yes\\" $eouchecked /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[texttimeformat]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"radio\\" value=\\"24\\" name=\\"timeformatnew\\" $check24 />&nbsp;$lang[text24hour]&nbsp;<input type=\\"radio\\" value=\\"12\\" name=\\"timeformatnew\\" $check12 />&nbsp;$lang[text12hour]</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[dateformat]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"dateformatnew\\" size=\\"25\\" value=\\"$member[dateformat]\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$textoffset</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n$timezones\n</td>\n</tr>\n<tr>\n<td class=\\"ctrtablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" colspan=\\"2\\"><input type=\\"submit\\" class=\\"submit\\" name=\\"editsubmit\\" value=\\"$lang[texteditpro]\\" /></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(96, 'memcp_profile_avatarlist', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textavatar]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$avatarbox &nbsp;<img src=\\"./images/avatars/clear_avatar.gif\\" id=\\"avatarpic\\" align=\\"middle\\" alt=\\"*\\" border=\\"0\\" /></td>\n</tr>\n\n'),
(97, 'memcp_profile_avatarurl', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">{$lang[\\''textavatarurl\\'']}</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n<input type=\\"hidden\\" name=\\"newavatarcheck\\" id=\\"newavatarcheck\\" value=\\"yes\\" />\n<input type=\\"text\\" name=\\"newavatar\\" size=\\"25\\" value=\\"{$member[\\''avatar\\'']}\\" onblur=\\"avatarCheck(this, \\''{$SETTINGS[\\''max_avatar_size\\'']}\\'', $js_https_only)\\" />\n<p id=\\"avatarCheck\\" style=\\"display: inline;\\"></p>\n</td>\n</tr>\n\n'),
(98, 'memcp_profile_optional', '<tr>\n<td colspan=\\"2\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[texteditpro] - $lang[optional]</strong></font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textsite]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"newsite\\" size=\\"25\\" value=\\"$member[site]\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textaim]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"newaim\\" size=\\"25\\" value=\\"$member[aim]\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[texticq]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"newicq\\" size=\\"25\\" value=\\"$member[icq]\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textyahoo]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"newyahoo\\" size=\\"25\\" value=\\"$member[yahoo]\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textmsn]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"newmsn\\" size=\\"25\\" value=\\"$member[msn]\\"/></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textlocation]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"newlocation\\" size=\\"25\\" value=\\"$member[location]\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[memcpmood]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"newmood\\" size=\\"25\\" value=\\"$member[mood]\\" /></td>\n</tr>\n$avatar\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textbio]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><textarea rows=\\"5\\" cols=\\"45\\" name=\\"newbio\\">\n$member[bio]</textarea></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textsig]<br /><span class=\\"smalltxt\\">$lang[texthtmlis] $htmlis<br />$lang[textbbcodeis] $bbcodeis</span></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><textarea rows=\\"5\\" cols=\\"45\\" name=\\"newsig\\">\n$member[sig]</textarea></td>\n</tr>\n\n'),
(99, 'memcp_subscriptions', '<form method=\\"post\\" action=\\"memcp.php?action=subscriptions\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\" class=\\"tablelinks\\">\n<tr>\n<td colspan=\\"6\\" class=\\"category\\" align=\\"center\\" {$THEME[\\''catbgcode\\'']}><strong><font color=\\"{$THEME[\\''cattext\\'']}\\">$lang[textsubscriptions]</font></strong></td>\n</tr>\n$multipage\n<tr class=\\"header\\">\n<td width=\\"4%\\" align=\\"center\\">$lang[deletebutton]</td>\n<td width=\\"4%\\" align=\\"center\\">$lang[texticon]</td>\n<td width=\\"43%\\">$lang[textsubject]</td>\n<td width=\\"24%\\">$lang[textforum]</td>\n<td width=\\"6%\\" align=\\"center\\">$lang[textreplies]</td>\n<td width=\\"19%\\">$lang[textlastpost]</td>\n</tr>\n$subscriptions\n$multipage\n$subsbtn\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(100, 'memcp_subscriptions_button', '<tr class=\\"ctrtablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" colspan=\\"6\\"><input type=\\"submit\\" class=\\"submit\\" name=\\"subsubmit\\" value=\\"$lang[textdeleteselectedsubs]\\" /></td>\n</tr>\n\n'),
(101, 'memcp_subscriptions_multipage', '<tr class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n<td colspan=\\"6\\" class=\\"multi\\">&nbsp;$multipage</td>\n</tr>\n\n'),
(102, 'memcp_subscriptions_none', '<tr>\n<td class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" colspan=\\"6\\">$lang[nosubmsg]</td>\n</tr>\n\n'),
(103, 'memcp_subscriptions_row', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"4%\\" align=\\"center\\"><input type=\\"checkbox\\" name=\\"delete$fav[tid]\\" value=\\"$fav[tid]\\" /></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" width=\\"4%\\" align=\\"center\\">$fav[icon]</td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"43%\\"><a href=\\"viewthread.php?tid=$fav[tid]\\">$fav[subject]</a></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><a href=\\"forumdisplay.php?fid=$forum[fid]\\">$forum[name]</a></td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"6%\\" align=\\"center\\">$fav[replies]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" width=\\"19%\\"><a href=\\"viewthread.php?goto=lastpost&amp;tid={$fav[\\''tid\\'']}\\" title=\\"{$lang[\\''altlastpost\\'']}\\" class=\\"smalltxt\\">$lastpost</a></td>\n</tr>\n\n'),
(104, 'message', '$header\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\" bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<tr>\n<td>\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[message]</strong></font></td>\n</tr>\n<tr>\n<td class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$message</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n\n'),
(105, 'misc_feature_notavailable', '<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}%\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\" colspan=\\"2\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[fnasorry]</strong></font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"8%\\" align=\\"center\\"><img src=\\"{$THEME[\\''admdir\\'']}/exclamation.gif\\" border=\\"0\\" alt=\\"$lang[featurewarning]\\" /></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$lang[fnasorry3]<br/></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n\n'),
(106, 'misc_feature_not_while_loggedin', '<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\" colspan=\\"2\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[fnasorry]</strong></font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"8%\\" align=\\"center\\"><img src=\\"{$THEME[\\''admdir\\'']}/exclamation.gif\\" border=\\"0\\" alt=\\"$lang[featurewarning]\\" /></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><span class=\\"smalltxt\\"><strong>$lang[fnasorry2]</strong></span><br />$lang[plogtuf]<br /></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n\n'),
(107, 'misc_login', '<form method=\\"post\\" action=\\"misc.php?action=login\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\" colspan=\\"2\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textlogin]</strong></font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textusername]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"username\\" size=\\"25\\" maxlength=\\"25\\" />&nbsp;<span class=\\"smalltxt\\"><a href=\\"member.php?action=reg\\">$lang[regques]</a></span></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textpassword]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"password\\" name=\\"password\\" size=\\"25\\" />&nbsp;<span class=\\"smalltxt\\"><a href=\\"misc.php?action=lostpw\\">$lang[forgotpw]</a></span><br /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">{$lang[\\''login_trusted\\'']}</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"checkbox\\" name=\\"trust\\" value=\\"yes\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textinvisible]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"checkbox\\" name=\\"hide\\" value=\\"1\\" /></td>\n</tr>\n<tr class=\\"ctrtablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" colspan=\\"2\\"><input type=\\"submit\\" class=\\"submit\\" name=\\"loginsubmit\\" value=\\"$lang[textlogin]\\" /></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(108, 'misc_login_incorrectdetails', '<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\"><table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"header\\" colspan=\\"2\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textlogin_incorrect]</strong></font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"8%\\" align=\\"center\\"><img src=\\"{$THEME[\\''admdir\\'']}/exclamation.gif\\" border=\\"0\\" alt=\\"$lang[featurewarning]\\" /></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><span class=\\"smalltxt\\"><strong>$lang[textpw1]</strong></span><br />$lang[textpw2]<br /></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n\n');
INSERT INTO `[[dbprefix]]templates` VALUES
(109, 'misc_lostpw', '<form method=\\"post\\" action=\\"misc.php?action=lostpw\\" onsubmit=\\"return disableButton(this);\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\" colspan=\\"2\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textlostpw]</strong></font></td>\n</tr>\n<tr>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"tablerow\\" colspan=\\"2\\">$lang[textlostpwnote]</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textusername]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"username\\" size=\\"25\\" maxlength=\\"25\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textemail]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"email\\" size=\\"25\\" /><br /></td>\n</tr>\n<tr class=\\"ctrtablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" colspan=\\"2\\"><input type=\\"submit\\" class=\\"submit\\" name=\\"lostpwsubmit\\" value=\\"$lang[textsubmit]\\" /></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(110, 'misc_mlist', '<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\" class=\\"tablelinks\\">\n<tr>\n<td colspan=\\"6\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textsortby]</strong></font></td>\n</tr>\n<tr class=\\"ctrtablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><a href=\\"misc.php?action=list&amp;order=username$ext\\"><strong>$lang[textalpha]</strong></a></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><a href=\\"misc.php?action=list&amp;order=status$ext\\"><strong>$lang[status]</strong></a></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><a href=\\"misc.php?action=list&amp;order=location$ext\\"><strong>{$lang[\\''location\\'']}</strong></a></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><a href=\\"misc.php?action=list$ext\\"><strong>$lang[textregdate]</strong></a></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><a href=\\"misc.php?action=list&amp;desc=desc&amp;order=postnum$ext\\"><strong>$lang[textpostnum]</strong></a></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" width=\\"10%\\"><a href=\\"misc.php?action=list$sflip$ext\\"><strong>$ascdesc</strong></a></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<form method=\\"get\\" action=\\"misc.php\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<input type=\\"hidden\\" name=\\"action\\" value=\\"list\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\" class=\\"tablelinks\\">\n<tr>\n<td colspan=\\"7\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textmemberlist]</strong></font></td>\n</tr>\n$multipage\n<tr class=\\"header\\" align=\\"center\\">\n<td width=\\"20%\\">$lang[textusername]</td>\n<td width=\\"16%\\">$lang[status]</td>\n<td width=\\"10%\\">$lang[textemail]:</td>\n<td width=\\"10%\\">$lang[textsite]</td>\n<td width=\\"19%\\">$lang[textlocation]</td>\n<td width=\\"19%\\">$lang[textregistered]</td>\n<td width=\\"5%\\">$lang[textposts]</td>\n</tr>\n$members\n<tr class=\\"ctrtablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n<td align=\\"center\\" colspan=\\"7\\">$lang[textsrchusr]&nbsp;&nbsp;<input type=\\"text\\" size=\\"15\\" name=\\"srchmem\\" value=\\"$srchmem\\" />&nbsp;&nbsp;<input type=\\"submit\\" class=\\"submit\\" value=\\"$lang[textgo]\\" /></td>\n</tr>\n$multipage\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(111, 'misc_mlist_admin', '<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\" class=\\"tablelinks\\">\n<tr>\n<td colspan=\\"6\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textsortby]</strong></font></td>\n</tr>\n<tr class=\\"ctrtablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><a href=\\"misc.php?action=list&amp;order=username$ext\\"><strong>$lang[textalpha]</strong></a></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><a href=\\"misc.php?action=list&amp;order=status$ext\\"><strong>$lang[status]</strong></a></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><a href=\\"misc.php?action=list&amp;order=location$ext\\"><strong>{$lang[\\''location\\'']}</strong></a></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><a href=\\"misc.php?action=list$ext\\"><strong>$lang[textregdate]</strong></a></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><a href=\\"misc.php?action=list&amp;desc=desc&amp;order=postnum$ext\\"><strong>$lang[textpostnum]</strong></a></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" width=\\"10%\\"><a href=\\"misc.php?action=list$sflip$ext\\"><strong>$ascdesc</strong></a></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n<form method=\\"get\\" action=\\"misc.php\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<input type=\\"hidden\\" name=\\"action\\" value=\\"list\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\" class=\\"tablelinks\\">\n<tr>\n<td colspan=\\"7\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textmemberlist]</strong></font></td>\n</tr>\n$multipage\n<tr class=\\"header\\" align=\\"center\\">\n<td width=\\"20%\\">$lang[textusername]</td>\n<td width=\\"16%\\">$lang[status]</td>\n<td width=\\"10%\\">$lang[textemail]:</td>\n<td width=\\"10%\\">$lang[textsite]</td>\n<td width=\\"19%\\">$lang[textlocation]</td>\n<td width=\\"19%\\">$lang[textregistered]</td>\n<td width=\\"5%\\">$lang[textposts]</td>\n</tr>\n$members\n<tr class=\\"ctrtablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n<td colspan=\\"7\\">$lang[textsrchusr]&nbsp;&nbsp;<input type=\\"text\\" size=\\"15\\" name=\\"srchmem\\" value=\\"$srchmem\\" />&nbsp;&nbsp;$lang[textsrchemail]&nbsp;&nbsp;<input type=\\"text\\" size=\\"15\\" name=\\"srchemail\\" value=\\"$srchemail\\" />&nbsp;&nbsp;$lang[textsrchip]&nbsp;&nbsp;<input type=\\"text\\" size=\\"15\\" name=\\"srchip\\" value=\\"$srchip\\" />&nbsp;&nbsp;<input type=\\"submit\\" class=\\"submit\\" value=\\"$lang[textgo]\\" /></td>\n</tr>\n$multipage\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(112, 'misc_mlist_multipage', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" colspan=\\"7\\" align=\\"left\\"  class=\\"multi\\">&nbsp;$multipage</td>\n</tr>\n\n'),
(113, 'misc_mlist_results_none', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" colspan=\\"7\\"><span class=\\"mediumtxt\\">$lang[noresults]</span></td>\n</tr>\n\n'),
(114, 'misc_mlist_row', '<tr>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"tablerow\\"><a href=\\"member.php?action=viewpro&amp;member=$memurl\\">$member[username]</a></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"ctrtablerow\\">$member[status]</td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"ctrtablerow\\">$email</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"ctrtablerow\\">$site</td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"tablerow\\">$member[location]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"ctrtablerow\\">$member[regdate]</td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"ctrtablerow\\">$member[postnum]</td>\n</tr>\n\n'),
(115, 'misc_mlist_row_email', '<a href=\\"mailto:$member[email]\\" title=\\"$lang[altemailuser]\\"><img src=\\"{$THEME[\\''imgdir\\'']}/email.gif\\" border=\\"0\\" alt=\\"$lang[altemailuser]\\" /></a>\n\n'),
(116, 'misc_mlist_row_site', '<a href=\\"$member[site]\\" onclick=\\"window.open(this.href); return false;\\" title=\\"$lang[altvisitsite]\\"><img src=\\"{$THEME[\\''imgdir\\'']}/site.gif\\" border=\\"0\\" alt=\\"$lang[altvisitsite]\\" /></a>\n\n'),
(117, 'misc_mlist_separator', '<tr>\n<td colspan=\\"7\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>&raquo;&nbsp;$seperator_text</strong></font></td>\n</tr>\n\n'),
(118, 'misc_online', '<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\" colspan=\\"3\\">\n<font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[whosonline]</strong></font> <font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>-</strong></font> <a href=\\"javascript:history.go(0)\\"><strong><font color=\\"{$THEME[\\''cattext\\'']}\\">$lang[refreshpage]</font></strong></a>\n</td>\n$multipage\n</tr>\n<tr class=\\"header\\" align=\\"center\\">\n<td>$lang[textusername]</td>\n<td>$lang[texttime]</td>\n<td>$lang[textlocation]</td>\n</tr>\n$onlineusers\n$multipage\n</table>\n</td>\n</tr>\n</table>\n\n'),
(119, 'misc_online_admin', '<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\" colspan=\\"4\\">\n<font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[whosonline]</strong></font> <font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>-</strong></font> <a href=\\"javascript:history.go(0)\\"><strong><font color=\\"{$THEME[\\''cattext\\'']}\\">$lang[refreshpage]</font></strong></a>\n</td>\n</tr>\n$multipage\n<tr class=\\"header\\" align=\\"center\\">\n<td>$lang[textusername]</td>\n<td>$lang[texttime]</td>\n<td>$lang[textlocation]</td>\n<td>$lang[textipaddress]</td>\n</tr>\n$onlineusers\n$multipage\n</table>\n</td>\n</tr>\n</table>\n\n'),
(120, 'misc_online_multipage', '<tr class=\\"tablerow\\">\n<td colspan=\\"3\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">&nbsp;$multipage</td>\n</tr>\n\n'),
(121, 'misc_online_multipage_admin', '<tr class=\\"tablerow\\">\n<td colspan=\\"4\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">&nbsp;$multipage</td>\n</tr>\n\n'),
(122, 'misc_online_row', '<tr bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"tablerow\\">\n<td width=\\"22%\\">$online[username]</td>\n<td align=\\"center\\" width=\\"28%\\">$onlinetime</td>\n<td>$online[location]</td>\n</tr>\n\n'),
(123, 'misc_online_row_admin', '<tr bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"tablerow\\">\n<td width=\\"18%\\">$online[username]</td>\n<td align=\\"center\\" width=\\"10%\\">$onlinetime</td>\n<td>$online[location]</td>\n<td align=\\"center\\">\n<a href=\\"https://whois.domaintools.com/$online[ip]\\" onclick=\\"window.open(this.href); return false;\\" />W</a>\n<a href=\\"https://www.net.princeton.edu/cgi-bin/traceroute.pl?target=$online[ip]\\" onclick=\\"window.open(this.href); return false;\\" />T</a>\n<a href=\\"https://mxtoolbox.com/SuperTool.aspx?action=ptr%3a$online[ip]\\" onclick=\\"window.open(this.href); return false;\\">L</a>\n<a href=\\"https://www.iptrackeronline.com/?ip_address=$online[ip]\\" onclick=\\"window.open(this.href); return false;\\">M</a> $online[ip]</a></td>\n</tr>\n\n'),
(124, 'misc_online_today', '<table border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"0\\" cellpadding=\\"0\\" width=\\"100%\\" align=\\"center\\">\n<tr>\n<td class=\\"tablerow\\" colspan=\\"2\\" width=\\"100%\\">\n<table cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" border=\\"0\\" width=\\"100%\\" align=\\"center\\">\n<tr>\n<td colspan=\\"6\\" class=\\"category\\"><strong><font color=\\"{$THEME[\\''cattext\\'']}\\">$lang[misconlinetoday] $todaymembersnum $lang[misconlinetoday2]</font></strong></td>\n</tr>\n<tr>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"ctrtablerow\\" width=\\"4%\\"><img src=\\"{$THEME[\\''imgdir\\'']}/online.gif\\" alt=\\"$lang[whosonline]\\" /></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" colspan=\\"5\\" class=\\"mediumtxt\\">$todaymembers</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n\n'),
(125, 'misc_smilies', '<table border=\\"0\\">\n<tr>$smilies</tr>\n</table>\n\n'),
(126, 'popup_footer', '</div>\n</body>\n</html>\n\n'),
(127, 'popup_header', '<?xml version=\\"1.0\\" encoding=\\"{$lang[\\''charset\\'']}\\"?>\n<!DOCTYPE html PUBLIC \\"-//W3C//DTD XHTML 1.0 Transitional//EN\\" \\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\\">\n<html xmlns=\\"http://www.w3.org/1999/xhtml\\">\n<head>\n<meta http-equiv=\\"Content-Type\\" content=\\"text/html; charset={$lang[\\''charset\\'']}\\" />\n<meta name=\\"viewport\\" content=\\"width=device-width, initial-scale=1\\" />\n$css\n<script language=\\"JavaScript\\" type=\\"text/javascript\\">\nvar messageElement = opener.document.getElementById(\\"message\\");\n</script>\n<script language=\\"JavaScript\\" type=\\"text/javascript\\" src=\\"./js/popup.js\\"></script>\n$bbcodescript\n<title>$bbname - $lang[textpowered]</title>\n</head>\n<body text=\\"{$THEME[\\''text\\'']}\\">\n<div align=\\"center\\">\n<br />\n\n'),
(128, 'post_attachmentbox', '<tr class=\\"tablerow\\">\n <td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">{$lang[\\''attachment\\'']}</td>\n <td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" id=\\"uploads\\">\n  <input type=\\"hidden\\" name=\\"MAX_FILE_SIZE\\" value=\\"{$SETTINGS[\\''maxattachsize\\'']}\\" />\n  <input type=\\"file\\" name=\\"attach1\\" size=\\"20\\" />$attachlimits\n </td>\n</tr>\n<tr class=\\"tablerow\\" id=\\"multiattachrow\\" style=\\"display: none;\\">\n <td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">{$lang[\\''attachmentm\\'']}</td>\n <td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n  <a href=\\"javascript:multiAttach()\\" id=\\"multiattachlink\\">{$lang[\\''attachmore\\'']}</a>\n </td>\n</tr>\n<script type=\\"text/javascript\\">\n <!--//--><![CDATA[//><!--\n  var uploadBoxCount = 1;\n  var uploadBoxMax = $maxuploads;\n  var uploadTotalLimits = \\''{$lang[\\''attachmaxtotal\\'']}\\'';\n\n  if (uploadBoxMax > 1) {\n    document.getElementById(\\''multiattachrow\\'').removeAttribute(\\''style\\'');\n  }\n\n  function multiAttach() {\n    var newnode = document.createElement(\\''span\\'');\n    if (uploadBoxCount < uploadBoxMax) {\n      uploadBoxCount++;\n      newnode.innerHTML = \\''<br /><input type=\\"file\\" name=\\"attach\\'' + uploadBoxCount + \\''\\" size=\\"20\\" />\\'';\n      document.getElementById(\\''uploads\\'').appendChild(newnode);\n      if (uploadBoxCount == 2 && uploadTotalLimits != \\''\\'') {\n        document.getElementById(\\''multiattachlink\\'').parentNode.innerHTML += \\''<br />\\'' + uploadTotalLimits;\n      }\n    }\n    if (uploadBoxCount >= uploadBoxMax) {\n      noMoreMultiAttach();\n    }\n  }\n\n  function noMoreMultiAttach() {\n    var multiAttachRow;\n    if (uploadBoxCount == 1) {\n      multiAttachRow = document.getElementById(\\''multiattachrow\\'');\n      multiAttachRow.parentNode.removeChild(multiAttachRow);\n    } else {\n      document.getElementById(\\''multiattachlink\\'').parentNode.innerHTML = uploadTotalLimits;\n    }\n  }\n //--><!]]>\n</script>\n\n'),
(129, 'post_attachment_orphan', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\"><strong>$lang[attachment]</strong>\n<br />\n<div style=\\"padding-left: 10px;\\">\n$lang[textfilename] <em>$postinfo[filename]</em>\n<br />\n$lang[textfilesize] <em>$postinfo[filesize] $lang[byte]</em>\n</div>\n</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n<input type=\\"radio\\" name=\\"attachment[{$postinfo[\\''aid\\'']}][action]\\" value=\\"leave\\" checked=\\"checked\\" />$lang[leaveuntouched].<br />\n<input type=\\"radio\\" name=\\"attachment[{$postinfo[\\''aid\\'']}][action]\\" value=\\"replace\\" />$lang[uploadinstead]<br />\n<input type=\\"hidden\\" name=\\"MAX_FILE_SIZE\\" value=\\"$SETTINGS[maxattachsize]\\" />\n<input type=\\"file\\" name=\\"replace_{$postinfo[\\''aid\\'']}\\" style=\\"margin-left: 2em;\\" width=\\"25\\" size=\\"25\\" /><br />\n<input type=\\"radio\\" name=\\"attachment[{$postinfo[\\''aid\\'']}][action]\\" value=\\"rename\\" />$lang[renamefile]<br />\n<input type=\\"text\\" name=\\"rename_{$postinfo[\\''aid\\'']}\\" style=\\"margin-left: 2em;\\" size=\\"22\\" value=\\"$postinfo[filename]\\"/><br />\n<input type=\\"radio\\" name=\\"attachment[{$postinfo[\\''aid\\'']}][action]\\" value=\\"delete\\" />$lang[deletecurrent]<br />\n</td>\n</tr>\n\n'),
(130, 'post_captcha', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[verificationnote]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n <img src=\\"misc.php?action=captchaimage&amp;imagehash=$imghash\\" alt=\\"$lang[captchaverification]\\" title=\\"$lang[captchaverification]\\" /><br /><br />\n <input type=\\"text\\" name=\\"imgcode\\" value=\\"\\" /><input type=\\"hidden\\" name=\\"imghash\\" value=\\"$imghash\\" /><br />\n {$lang[\\''captchacaseon\\'']}\n</td>\n</tr>\n\n'),
(131, 'post_edit', '$preview\n<form method=\\"post\\" name=\\"input\\" action=\\"post.php?action=edit&amp;fid=$fid&amp;tid=$tid&amp;pid=$pid\\" enctype=\\"multipart/form-data\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td colspan=\\"2\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[texteditpost]</strong></font></td>\n</tr>\n$loggedin\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textsubject]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"subject\\" size=\\"45\\" value=\\"$postinfo[subject]\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[texticon]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$icons</td>\n</tr>\n$bbcodeinsert\n<tr>\n<td class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" valign=\\"top\\">$lang[textmessage]<br /><span class=\\"smalltxt\\">$lang[texthtmlis] $allowhtml<br />\n$lang[textsmiliesare] $allowsmilies<br />\n$lang[textbbcodeis] $allowbbcode<br />\n$lang[textimgcodeis] $allowimgcode</span></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"tablerow\\">\n<table width=\\"100%\\">\n<tr>\n<td width=\\"70%\\" rowspan=\\"2\\"><textarea rows=\\"12\\" cols=\\"65\\" name=\\"message\\" id=\\"message\\" onselect=\\"storeCaret(this);\\" onclick=\\"storeCaret(this);\\" onkeyup=\\"storeCaret(this);\\">\n$postinfo[message]</textarea></td>\n$smilieinsert\n</tr>\n<tr><td class=\\"ctrtablerow smalltxt\\">$moresmilies</td></tr>\n</table>\n<br />\n<input type=\\"checkbox\\" name=\\"smileyoff\\" value=\\"yes\\" $offcheck2 /> $lang[textdissmileys]<br />\n<input type=\\"checkbox\\" name=\\"usesig\\" value=\\"yes\\" $offcheck3 /> $lang[textusesig]<br />\n<input type=\\"checkbox\\" name=\\"bbcodeoff\\" value=\\"yes\\" $offcheck1 /> $lang[bbcodeoff]<br />\n<input type=\\"checkbox\\" name=\\"delete\\" value=\\"yes\\" /> <strong>$lang[textdelete]</strong></td>\n</tr>\n$attachment\n<tr>\n<td colspan=\\"2\\" class=\\"ctrtablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"submit\\" class=\\"submit\\" name=\\"editsubmit\\" value=\\"$lang[texteditpost]\\" />&nbsp;<input type=\\"submit\\" class=\\"submit\\" name=\\"previewpost\\" value=\\"$lang[textpreview]\\" />&nbsp;$spelling_submit1 &nbsp;$spelling_submit2</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n$suggestions\n<input type=\\"hidden\\" name=\\"fid\\" value=\\"$fid\\" />\n<input type=\\"hidden\\" name=\\"tid\\" value=\\"$tid\\" />\n<input type=\\"hidden\\" name=\\"pid\\" value=\\"$pid\\" />\n</form>\n\n'),
(132, 'post_edit_attachment', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\"><strong>$lang[attachment]</strong>\n<br />\n<div style=\\"padding-left: 10px;\\">\n$lang[textfilename] <em>$postinfo[filename]</em>\n<br />\n$lang[textfilesize] <em>$postinfo[filesize] $lang[byte]</em>\n<br />\n$lang[textdownloads] <em>$postinfo[downloads]</em>\n<br />\n<br />\n<em>&raquo; <a href=\\"{$postinfo[\\''url\\'']}\\">$lang[textdownload]</a></em>\n</div>\n</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n<input type=\\"radio\\" name=\\"attachment[{$postinfo[\\''aid\\'']}][action]\\" value=\\"leave\\" checked=\\"checked\\" />$lang[leaveuntouched].<br />\n<input type=\\"radio\\" name=\\"attachment[{$postinfo[\\''aid\\'']}][action]\\" value=\\"replace\\" />$lang[uploadinstead]<br />\n<input type=\\"hidden\\" name=\\"MAX_FILE_SIZE\\" value=\\"$SETTINGS[maxattachsize]\\" />\n<input type=\\"file\\" name=\\"replace_{$postinfo[\\''aid\\'']}\\" style=\\"margin-left: 2em;\\" width=\\"25\\" size=\\"25\\" /><br />\n<input type=\\"radio\\" name=\\"attachment[{$postinfo[\\''aid\\'']}][action]\\" value=\\"rename\\" />$lang[renamefile]<br />\n<input type=\\"text\\" name=\\"rename_{$postinfo[\\''aid\\'']}\\" style=\\"margin-left: 2em;\\" size=\\"22\\" value=\\"$postinfo[filename]\\"/><br />\n<input type=\\"radio\\" name=\\"attachment[{$postinfo[\\''aid\\'']}][action]\\" value=\\"delete\\" />$lang[deletecurrent]<br />\n</td>\n</tr>\n\n'),
(133, 'post_loggedin', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[loggedinuser]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$self[username] $lang[textminilogout]</td>\n</tr>\n\n'),
(134, 'post_newpoll', '$preview\n<form method=\\"post\\" name=\\"input\\" action=\\"post.php?action=newthread&amp;fid=$fid&amp;poll=yes\\" enctype=\\"multipart/form-data\\" onsubmit=\\"return disableButton(this);\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td colspan=\\"2\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textpostnew]</strong></font></td>\n</tr>\n$loggedin\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textsubject]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"subject\\" size=\\"45\\" value=\\"$subject\\" /> </td>\n</tr>\n<tr class=\\"tablerow\\"><td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" valign=\\"top\\">$lang[texticon]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$icons</td>\n</tr>\n$bbcodeinsert\n<tr>\n<td class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" valign=\\"top\\">$lang[textmessage]<br /><span class=\\"smalltxt\\">\n$lang[texthtmlis] $allowhtml<br />\n$lang[textsmiliesare] $allowsmilies<br />\n$lang[textbbcodeis] $allowbbcode<br />\n$lang[textimgcodeis] $allowimgcode</span></td>\n<td class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><table width=\\"100%\\">\n<tr>\n<td width=\\"70%\\" rowspan=\\"2\\"><textarea rows=\\"12\\" cols=\\"65\\" name=\\"message\\" id=\\"message\\" onselect=\\"storeCaret(this);\\" onclick=\\"storeCaret(this);\\" onkeyup=\\"storeCaret(this);\\">\n$message</textarea></td>\n$smilieinsert\n</tr>\n<tr><td class=\\"ctrtablerow smalltxt\\">$moresmilies</td></tr>\n</table>\n<br />\n<input type=\\"checkbox\\" name=\\"smileyoff\\" value=\\"yes\\" $smileoffcheck /> $lang[textdissmileys]<br />\n<input type=\\"checkbox\\" name=\\"usesig\\" value=\\"yes\\" $usesigcheck /> $lang[textusesig]<br />\n<input type=\\"checkbox\\" name=\\"bbcodeoff\\" value=\\"yes\\" $codeoffcheck /> $lang[bbcodeoff]<br />\n<input type=\\"checkbox\\" name=\\"emailnotify\\" value=\\"yes\\" $emailnotifycheck /> $lang[textemailnotify] $topoption</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" valign=\\"top\\">$lang[pollanswers]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><textarea rows=\\"5\\" cols=\\"40\\" name=\\"pollanswers\\">\n$pollanswers</textarea></td>\n</tr>\n$attachfile\n$captchapostcheck\n<tr>\n<td class=\\"ctrtablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" colspan=\\"2\\"><input type=\\"submit\\" class=\\"submit\\" name=\\"topicsubmit\\" value=\\"$lang[textpostnew]\\" />&nbsp;<input type=\\"submit\\" class=\\"submit\\" name=\\"previewpost\\" value=\\"$lang[textpreview]\\" />&nbsp;$spelling_submit1 &nbsp;$spelling_submit2</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n$suggestions\n</form>\n\n'),
(135, 'post_newthread', '$preview\n<form method=\\"post\\" name=\\"input\\" action=\\"post.php?action=newthread&amp;fid=$fid\\" enctype=\\"multipart/form-data\\" onsubmit=\\"return disableButton(this);\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td colspan=\\"2\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textpostnew]</strong></font></td>\n</tr>\n$loggedin\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textsubject]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"subject\\" size=\\"45\\" value=\\"$subject\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" valign=\\"top\\">$lang[texticon]</td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$icons</td>\n</tr>\n$bbcodeinsert\n<tr>\n<td class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" valign=\\"top\\">$lang[textmessage]<br />\n<span class=\\"smalltxt\\">$lang[texthtmlis] $allowhtml<br />\n$lang[textsmiliesare] $allowsmilies<br />\n$lang[textbbcodeis] $allowbbcode<br />\n$lang[textimgcodeis] $allowimgcode</span></td>\n<td class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n<table width=\\"100%\\">\n<tr>\n<td width=\\"70%\\" rowspan=\\"2\\"><textarea rows=\\"12\\" cols=\\"65\\" name=\\"message\\" id=\\"message\\" onselect=\\"storeCaret(this);\\" onclick=\\"storeCaret(this);\\" onkeyup=\\"storeCaret(this);\\">\n$message</textarea></td>\n$smilieinsert\n</tr>\n<tr><td class=\\"ctrtablerow smalltxt\\">$moresmilies</td></tr>\n</table>\n<br />\n<input type=\\"checkbox\\" name=\\"smileyoff\\" value=\\"yes\\" $smileoffcheck /> $lang[textdissmileys]<br />\n<input type=\\"checkbox\\" name=\\"usesig\\" value=\\"yes\\" $usesigcheck /> $lang[textusesig]<br />\n<input type=\\"checkbox\\" name=\\"bbcodeoff\\" value=\\"yes\\" $codeoffcheck /> $lang[bbcodeoff]<br /><input\ntype=\\"checkbox\\" name=\\"emailnotify\\" value=\\"yes\\" $emailnotifycheck /> $lang[textemailnotify]\n$topoption $closeoption</td>\n</tr>\n$attachfile\n$captchapostcheck\n<tr>\n<td class=\\"ctrtablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" colspan=\\"2\\"><input type=\\"submit\\" class=\\"submit\\" name=\\"topicsubmit\\" value=\\"$lang[textpostnew]\\" />&nbsp;<input type=\\"submit\\" class=\\"submit\\" name=\\"previewpost\\" value=\\"$lang[textpreview]\\" />&nbsp;$spelling_submit1 &nbsp;$spelling_submit2</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n$suggestions\n</form>\n\n'),
(136, 'post_preview', '<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\"><table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td colspan=\\"2\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textpreview]</strong></font></td>\n</tr>\n<tr bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"tablerow\\">\n<td rowspan=\\"2\\" valign=\\"top\\" width=\\"19%\\"><font class=\\"mediumtxt\\"><strong>$username</strong></font><br /><br /></td>\n<td>$thread[icon]&nbsp;$poston</td>\n</tr>\n<tr bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"tablerow\\">\n<td><strong><font class=\\"subject\\">$dissubject</font></strong><br /><br /><font class=\\"mediumtxt\\">$message1</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n\n'),
(137, 'post_reply', '$preview\n<form method=\\"post\\" name=\\"input\\" action=\\"post.php?action=reply&amp;tid=$tid\\" enctype=\\"multipart/form-data\\" onsubmit=\\"return disableButton(this);\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\"><table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td colspan=\\"2\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textpostreply]</strong></font></td>\n</tr>\n$loggedin\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textsubject]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"subject\\" size=\\"45\\" value=\\"$subject\\" /> <small>$lang[parenopt]</small></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[texticon]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$icons</td>\n</tr>\n$bbcodeinsert\n<tr>\n<td class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" valign=\\"top\\">$lang[textmessage]<br /><span class=\\"smalltxt\\">$lang[texthtmlis] $allowhtml<br />\n$lang[textsmiliesare] $allowsmilies<br />\n$lang[textbbcodeis] $allowbbcode<br />\n$lang[textimgcodeis] $allowimgcode</span></td>\n<td class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><table width=\\"100%\\">\n<tr>\n<td width=\\"70%\\" rowspan=\\"2\\"><textarea rows=\\"12\\" cols=\\"65\\" name=\\"message\\" id=\\"message\\" onselect=\\"storeCaret(this);\\" onclick=\\"storeCaret(this);\\" onkeyup=\\"storeCaret(this);\\">\n$message</textarea></td>\n$smilieinsert\n</tr>\n<tr><td class=\\"ctrtablerow smalltxt\\">$moresmilies</td></tr>\n</table>\n<br />\n<input type=\\"checkbox\\" name=\\"smileyoff\\" value=\\"yes\\" $smileoffcheck /> $lang[textdissmileys]<br />\n<input type=\\"checkbox\\" name=\\"usesig\\" value=\\"yes\\" $usesigcheck /> $lang[textusesig]<br />\n<input type=\\"checkbox\\" name=\\"bbcodeoff\\" value=\\"yes\\" $codeoffcheck /> $lang[bbcodeoff]<br />\n<input type=\\"checkbox\\" name=\\"emailnotify\\" value=\\"yes\\" $emailnotifycheck/> $lang[textemailnotify] $closeoption</td>\n</tr>\n$attachfile\n$captchapostcheck\n<tr>\n<td class=\\"ctrtablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" colspan=\\"2\\"><input type=\\"submit\\" class=\\"submit\\" name=\\"replysubmit\\" value=\\"$lang[textpostreply]\\" />&nbsp;<input type=\\"submit\\" class=\\"submit\\" name=\\"previewpost\\" value=\\"$lang[textpreview]\\" />&nbsp;$spelling_submit1 &nbsp;$spelling_submit2</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n$suggestions\n</form>\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td colspan=\\"2\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[texttopicreview]</strong></font></td>\n</tr>\n$posts\n</table>\n</td>\n</tr>\n</table>\n\n'),
(138, 'post_reply_review_post', '<tr bgcolor=\\"$thisbg\\" class=\\"tablerow\\">\n<td rowspan=\\"2\\" valign=\\"top\\" width=\\"19%\\"><font class=\\"mediumtxt\\"><strong>$post[author]</strong></font><br /><br /></td>\n<td>$post[icon]&nbsp;$poston</td>\n</tr>\n<tr bgcolor=\\"$thisbg\\" class=\\"tablerow\\">\n<td>$post[message]<br /></td>\n</tr>\n\n'),
(139, 'post_reply_review_toolong', '<tr bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"tablerow\\">\n<td colspan=\\"2\\" valign=\\"top\\" width=\\"19%\\">$trevltmsg</td>\n</tr>\n\n'),
(140, 'search', '<form method=\\"get\\" action=\\"search.php\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td colspan=\\"2\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textsearch]</strong></font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textsearchfor]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n  <input type=\\"text\\" name=\\"srchtxt\\" size=\\"30\\" maxlength=\\"40\\" /><br />\n  <input type=\\"radio\\" name=\\"srchfield\\" value=\\"body\\" checked=\\"checked\\" />{$lang[\\''searchbody\\'']}<br />\n  <input type=\\"radio\\" name=\\"srchfield\\" value=\\"subject\\" />{$lang[\\''searchsubject\\'']}<br />\n</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textsrchuname]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"srchuname\\" size=\\"30\\" maxlength=\\"40\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[srchbyforum]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$forumselect</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[textlfrom]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n<select name=\\"srchfrom\\">\n<option value=\\"86400\\">$lang[day1]</option>\n<option value=\\"604800\\">$lang[aweek]</option>\n<option value=\\"2592000\\">$lang[month1]</option>\n<option value=\\"7948800\\">$lang[month3]</option>\n<option value=\\"15897600\\">$lang[month6]</option>\n<option value=\\"31536000\\">$lang[lastyear]</option>\n<option value=\\"0\\" $selHTML>$lang[beginning]</option>\n</select>\n</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[srchfilter_double]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"checkbox\\" name=\\"filter_distinct\\" value=\\"yes\\" checked=\\"checked\\" /></td>\n</tr>\n$captchasearchcheck\n<tr class=\\"ctrtablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" colspan=\\"2\\"><input type=\\"submit\\" class=\\"submit\\" name=\\"searchsubmit\\" value=\\"$lang[textsearch]\\" /></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(141, 'search_captcha', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[verificationnote]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n <img src=\\"misc.php?action=captchaimage&amp;imagehash=$imghash\\" alt=\\"$lang[captchaverification]\\" /><br /><br />\n <input type=\\"text\\" name=\\"imgcode\\" value=\\"\\" /><input type=\\"hidden\\" name=\\"imghash\\" value=\\"$imghash\\" /><br />\n {$lang[\\''captchacaseon\\'']}\n</td>\n</tr>\n\n'),
(142, 'search_nextlink', '<tr class=\\"mediumtxt\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">\n<td colspan=\\"2\\" align=\\"right\\"><a href=\\"search.php?page=$pagenum&amp;$ext&amp;filter_distinct=$filter_distinct&amp;searchsubmit=a\\">$lang[nextsearch]</a></td>\n</tr>\n\n'),
(143, 'search_results', '<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\" colspan=\\"2\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textsearch]</strong></font></td>\n</tr>\n$nextlink\n$searchresults\n$nextlink\n</table>\n</td>\n</tr>\n</table>\n\n'),
(144, 'search_results_none', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" colspan=\\"2\\"><span class=\\"mediumtxt\\">$lang[noresults]</span></td>\n</tr>\n\n'),
(145, 'search_results_row', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\"><strong><a href=\\"viewthread.php?tid={$post[\\''tid\\'']}&amp;goto=search&amp;pid={$post[\\''pid\\'']}\\">{$post[\\''subject\\'']}</a></strong><br />$add_pre $show $add_post</td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$poston<br />$lang[textby]: $postby</td>\n</tr>\n\n'),
(146, 'spelling_suggestion', '<br />\n<form action=\\"post.php?fid=$fid&amp;tid=$tid&amp;action=$action&amp;pid=$pid\\" method=\\"post\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" border=\\"0\\" width=\\"100%\\" align=\\"center\\">\n<tr>\n<td colspan=\\"6\\" class=\\"category\\"><font class=\\"mediumtxt\\" color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[spellingchecker]</strong></font></td>\n</tr>\n<tr class=\\"ctrtablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"50%\\">$lang[found]:</td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"50%\\">$lang[replacedby]:</td>\n</tr>\n$suggestions\n<tr>\n<td colspan=\\"2\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"tablerow\\">\n</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(147, 'spelling_suggestion_new', '<option value=\\"$suggestion\\">$suggestion</option>\n\n'),
(148, 'spelling_suggestion_no', '<br />\n<form action=\\"post.php?fid=$fid&amp;tid=$tid&amp;action=$action\\" method=\\"post\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"0\\" cellpadding=\\"0\\" width=\\"100%\\">\n<tr>\n<td class=\\"tablerow\\" colspan=\\"2\\" width=\\"100%\\">\n<table cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" border=\\"0\\" width=\\"100%\\" align=\\"center\\">\n<tr>\n<td colspan=\\"6\\" class=\\"category\\"><font class=\\"mediumtxt\\" color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[spellingchecker]</strong></font></td>\n</tr>\n<tr>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"ctrtablerow\\" colspan=\\"2\\">$lang[spellingcomplete]<br /><strong>$lang[nothingfound]</strong></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(149, 'spelling_suggestion_row', '<tr class=\\"ctrtablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"50%\\"><strong>$orig</strong></td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"50%\\"><input type=\\"hidden\\" name=\\"old_words[]\\" value=\\"$orig\\" />\n<select name=\\"replace_$orig\\">\n<option value=\\"$orig\\">--IGNORE--</option>\n$mistake\n</select>\n</td>\n</tr>\n\n'),
(150, 'timezone_control', '<select name=\\"timeoffset1\\">\n<option value=\\"-12\\"   $sel[1]>{$lang[\\''timezone1\\'']}</option>\n<option value=\\"-11\\"   $sel[2]>{$lang[\\''timezone2\\'']}</option>\n<option value=\\"-10\\"   $sel[3]>{$lang[\\''timezone3\\'']}</option>\n<option value=\\"-9.5\\"  $sel[37]>{$lang[\\''timezone37\\'']}</option>\n<option value=\\"-9\\"    $sel[4]>{$lang[\\''timezone4\\'']}</option>\n<option value=\\"-8\\"    $sel[5]>{$lang[\\''timezone5\\'']}</option>\n<option value=\\"-7\\"    $sel[6]>{$lang[\\''timezone6\\'']}</option>\n<option value=\\"-6\\"    $sel[7]>{$lang[\\''timezone7\\'']}</option>\n<option value=\\"-5\\"    $sel[8]>{$lang[\\''timezone8\\'']}</option>\n<option value=\\"-4\\"    $sel[9]>{$lang[\\''timezone9\\'']}</option>\n<option value=\\"-3.5\\"  $sel[10]>{$lang[\\''timezone10\\'']}</option>\n<option value=\\"-3\\"    $sel[11]>{$lang[\\''timezone11\\'']}</option>\n<option value=\\"-2\\"    $sel[12]>{$lang[\\''timezone12\\'']}</option>\n<option value=\\"-1\\"    $sel[13]>{$lang[\\''timezone13\\'']}</option>\n<option value=\\"0\\"     $sel[14]>{$lang[\\''timezone14\\'']}</option>\n<option value=\\"1\\"     $sel[15]>{$lang[\\''timezone15\\'']}</option>\n<option value=\\"2\\"     $sel[16]>{$lang[\\''timezone16\\'']}</option>\n<option value=\\"3\\"     $sel[17]>{$lang[\\''timezone17\\'']}</option>\n<option value=\\"3.5\\"   $sel[18]>{$lang[\\''timezone18\\'']}</option>\n<option value=\\"4\\"     $sel[19]>{$lang[\\''timezone19\\'']}</option>\n<option value=\\"4.5\\"   $sel[20]>{$lang[\\''timezone20\\'']}</option>\n<option value=\\"5\\"     $sel[21]>{$lang[\\''timezone21\\'']}</option>\n<option value=\\"5.5\\"   $sel[22]>{$lang[\\''timezone22\\'']}</option>\n<option value=\\"5.75\\"  $sel[23]>{$lang[\\''timezone23\\'']}</option>\n<option value=\\"6\\"     $sel[24]>{$lang[\\''timezone24\\'']}</option>\n<option value=\\"6.5\\"   $sel[25]>{$lang[\\''timezone25\\'']}</option>\n<option value=\\"7\\"     $sel[26]>{$lang[\\''timezone26\\'']}</option>\n<option value=\\"8\\"     $sel[27]>{$lang[\\''timezone27\\'']}</option>\n<option value=\\"9\\"     $sel[28]>{$lang[\\''timezone28\\'']}</option>\n<option value=\\"9.5\\"   $sel[29]>{$lang[\\''timezone29\\'']}</option>\n<option value=\\"10\\"    $sel[30]>{$lang[\\''timezone30\\'']}</option>\n<option value=\\"10.5\\"  $sel[36]>{$lang[\\''timezone36\\'']}</option>\n<option value=\\"11\\"    $sel[31]>{$lang[\\''timezone31\\'']}</option>\n<option value=\\"12\\"    $sel[32]>{$lang[\\''timezone32\\'']}</option>\n<option value=\\"12.75\\" $sel[35]>{$lang[\\''timezone35\\'']}</option>\n<option value=\\"13\\"    $sel[33]>{$lang[\\''timezone33\\'']}</option>\n<option value=\\"14\\"    $sel[34]>{$lang[\\''timezone34\\'']}</option>\n</select>\n\n'),
(151, 'today', '<form method=\\"post\\" action=\\"today.php\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\" class=\\"tablelinks\\">\n<tr>\n<td colspan=\\"8\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[navtodaysposts]</strong></font></td>\n</tr>\n$multipage\n<tr class=\\"header\\" align=\\"center\\">\n<td width=\\"4%\\">&nbsp;</td>\n<td width=\\"4%\\">$lang[texticon]</td>\n<td width=\\"43%\\">$lang[textsubject]</td>\n<td width=\\"14%\\">$lang[textauthor]</td>\n<td width=\\"14%\\">$lang[textforum]</td>\n<td width=\\"5%\\">$lang[textreplies]</td>\n<td width=\\"5%\\">$lang[textviews]</td>\n<td width=\\"23%\\">$lang[textlastpost]</td>\n</tr>\n$rows\n<tr class=\\"ctrtablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n<td colspan=\\"8\\">$lang[todayshow]&nbsp;&nbsp;<input type=\\"text\\" name=\\"daysold\\" size=\\"3\\" value=\\"$daysold\\" />&nbsp;&nbsp;$lang[todaydays]&nbsp;&nbsp;<input class=\\"submit\\" type=\\"submit\\" name=\\"searchsubmit\\" value=\\"$lang[todaygo]\\" /></td>\n</tr>\n$multipage\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(152, 'today_multipage', '<tr class=\\"tablerow\\">\n<td class=\\"multi\\" colspan=\\"8\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">&nbsp;$multipage</td>\n</tr>\n\n'),
(153, 'today_noposts', '<tr class=\\"ctrtablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" colspan=\\"8\\">$noPostsMessage</td>\n</tr>\n\n'),
(154, 'today_row', '<tr class=\\"tablerow\\">\n<td width=\\"4%\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"ctrtablerow\\">$folder</td>\n<td width=\\"4%\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"ctrtablerow\\">$thread[icon]</td>\n<td width=\\"43%\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"tablerow\\"><font class=\\"12px\\"><a href=\\"viewthread.php?tid=$thread[tid]\\">$prefix{$thread[\\''subject\\'']}</a></font></td>\n<td width=\\"14%\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"ctrtablerow\\">$authorlink</td>\n<td width=\\"14%\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"ctrtablerow\\"><font class=\\"11px\\"><a href=\\"forumdisplay.php?fid=$thread[fid]\\">$thread[name]</a></font></td>\n<td width=\\"5%\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"ctrtablerow\\"><font class=\\"11px\\">$thread[replies]</font></td>\n<td width=\\"5%\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"ctrtablerow\\"><font class=\\"11px\\">$thread[views]</font></td>\n<td width=\\"23%\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"lastpostcell\\">$lastpostrow</td>\n</tr>\n\n'),
(155, 'topicadmin_bump', '<form method=\\"post\\" action=\\"topicadmin.php?action=bump\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\"><table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\" colspan=\\"2\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textbumpthread]</strong></font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[loggedinuser]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" >$self[username] $lang[textminilogout]</td>\n</tr>\n<tr>\n<td colspan=\\"2\\" class=\\"ctrtablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"hidden\\" name=\\"fid\\" value=\\"$fid\\" /><input type=\\"hidden\\" name=\\"tid\\" value=\\"$tid\\" /><input type=\\"submit\\" class=\\"submit\\" name=\\"bumpsubmit\\" value=\\"$lang[textbumpthread]\\" /></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(156, 'topicadmin_copy', '<form method=\\"post\\" action=\\"topicadmin.php?action=copy\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\" colspan=\\"2\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[copythread]:</strong></font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[loggedinuser]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$self[username] $lang[textminilogout]</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[copythreadto]:</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$forumselect</td>\n</tr>\n<tr class=\\"ctrtablerow\\">\n<td colspan=\\"2\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"hidden\\" name=\\"fid\\" value=\\"$fid\\" /><input type=\\"hidden\\" name=\\"tid\\" value=\\"$tid\\" /><input type=\\"submit\\" class=\\"submit\\" name=\\"copysubmit\\" value=\\"$lang[copythread]\\" /></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n');
INSERT INTO `[[dbprefix]]templates` VALUES
(157, 'topicadmin_delete', '<form method=\\"post\\" action=\\"topicadmin.php?action=delete\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\"><table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\" colspan=\\"2\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textdeletethread]</strong></font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[loggedinuser]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$self[username] $lang[textminilogout]</td>\n</tr>\n<tr class=\\"ctrtablerow\\">\n<td colspan=\\"2\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"hidden\\" name=\\"fid\\" value=\\"$fid\\" /><input type=\\"hidden\\" name=\\"tid\\" value=\\"$tid\\" /><input type=\\"submit\\" class=\\"submit\\" name=\\"deletesubmit\\" value=\\"$lang[textdeletethread]\\" /></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(158, 'topicadmin_empty', '<form method=\\"post\\" action=\\"topicadmin.php?action=empty\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\"><table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\" colspan=\\"2\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textemptythread]</strong></font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[loggedinuser]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$self[username] $lang[textminilogout]</td>\n</tr>\n<tr>\n<td colspan=\\"2\\" class=\\"ctrtablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"hidden\\" name=\\"fid\\" value=\\"$fid\\" /><input type=\\"hidden\\" name=\\"tid\\" value=\\"$tid\\" /><input type=\\"submit\\" class=\\"submit\\" name=\\"emptysubmit\\" value=\\"$lang[textemptythread]\\" /></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(159, 'topicadmin_merge', '<form method=\\"post\\" action=\\"topicadmin.php?action=merge\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\" colspan=\\"2\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textmergethread]</strong></font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[loggedinuser]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" >$self[username] $lang[textminilogout]</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"14%\\">$lang[mergewithmsg]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"othertid\\" size=\\"10\\" /></td>\n</tr>\n<tr>\n<td colspan=\\"2\\" class=\\"ctrtablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"hidden\\" name=\\"fid\\" value=\\"$fid\\" /><input type=\\"hidden\\" name=\\"tid\\" value=\\"$tid\\" /><input type=\\"submit\\" class=\\"submit\\" name=\\"mergesubmit\\" value=\\"$lang[textmergethread]\\" /></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(160, 'topicadmin_move', '<form method=\\"post\\" action=\\"topicadmin.php?action=move\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\" colspan=\\"2\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textmovemethod1]</strong></font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[loggedinuser]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" >$self[username] $lang[textminilogout]</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textmoveto]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$forumselect</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" valign=\\"top\\">$lang[textmovemethod]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n<input type=\\"radio\\" name=\\"type\\" value=\\"normal\\" checked=\\"checked\\" /> $lang[textmovemethod1]\n<br />\n<input type=\\"radio\\" name=\\"type\\" value=\\"redirect\\" /> $lang[textmovemethod2]\n<br />\n</td>\n</tr>\n<tr>\n<td colspan=\\"2\\" class=\\"ctrtablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"hidden\\" name=\\"fid\\" value=\\"$fid\\" /><input type=\\"hidden\\" name=\\"tid\\" value=\\"$tid\\" /><input type=\\"submit\\" class=\\"submit\\" name=\\"movesubmit\\" value=\\"$lang[textmovemethod1]\\" /></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(161, 'topicadmin_openclose', '<form method=\\"post\\" action=\\"topicadmin.php?action=$action\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\"><table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\" colspan=\\"2\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textclosethread]</strong></font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[loggedinuser]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$self[username] $lang[textminilogout]</td>\n</tr>\n<tr>\n<td colspan=\\"2\\" class=\\"ctrtablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"hidden\\" name=\\"fid\\" value=\\"$fid\\" /><input type=\\"hidden\\" name=\\"tid\\" value=\\"$tid\\" /><input type=\\"submit\\" class=\\"submit\\" name=\\"closesubmit\\" value=\\"$lang[textclosethread]\\" /></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(162, 'topicadmin_split', '<form method=\\"post\\" action=\\"topicadmin.php?action=split\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\"><table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\" colspan=\\"2\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textsplitthread]</strong></font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[loggedinuser]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$self[username] $lang[textminilogout]</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"14%\\">$lang[newsubject]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"subject\\" size=\\"45\\" /></td>\n</tr>\n<tr class=\\"header\\">\n<td>$lang[moveques]</td>\n<td>$lang[textpost]</td>\n</tr>\n$posts\n<tr>\n<td colspan=\\"2\\" class=\\"ctrtablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"hidden\\" name=\\"fid\\" value=\\"$fid\\" /><input type=\\"hidden\\" name=\\"tid\\" value=\\"$tid\\" /><input type=\\"submit\\" class=\\"submit\\" name=\\"splitsubmit\\" value=\\"$lang[textsplitthread]\\" /></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(163, 'topicadmin_split_row', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\"><input type=\\"checkbox\\" name=\\"move$post[pid]\\" value=\\"$post[pid]\\" /></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><font class=\\"smalltxt\\"><strong>$post[author]</strong>\n<br />\n<br />\n$post[message]\n</font>\n</td>\n</tr>\n\n'),
(164, 'topicadmin_threadprune', '<form method=\\"post\\" action=\\"topicadmin.php?action=threadprune\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\" colspan=\\"2\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textprunethread]</strong></font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[loggedinuser]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$self[username] $lang[textminilogout]</td>\n</tr>\n<tr class=\\"header\\">\n<td>$lang[deletebutton]?</td>\n<td>$lang[textpost]</td>\n</tr>\n$posts\n<tr>\n<td colspan=\\"2\\" class=\\"ctrtablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"hidden\\" name=\\"fid\\" value=\\"$fid\\" /><input type=\\"hidden\\" name=\\"tid\\" value=\\"$tid\\" /><input type=\\"submit\\" name=\\"threadprunesubmit\\" value=\\"$lang[textprunethread]\\" /></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(165, 'topicadmin_threadprune_row', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\"><input type=\\"checkbox\\" name=\\"move$post[pid]\\" value=\\"$post[pid]\\" $disablePost /></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><font class=\\"smalltxt\\"><strong>$post[author]</strong><br /><br />$post[message]</font></td>\n</tr>\n\n'),
(166, 'topicadmin_topuntop', '<form method=\\"post\\" action=\\"topicadmin.php?action=top\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\"><table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\" colspan=\\"2\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[texttopthread]</strong></font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"22%\\">$lang[loggedinuser]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$self[username] $lang[textminilogout]</td>\n</tr>\n<tr>\n<td colspan=\\"2\\" class=\\"ctrtablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"hidden\\" name=\\"fid\\" value=\\"$fid\\" /><input type=\\"hidden\\" name=\\"tid\\" value=\\"$tid\\" /><input type=\\"submit\\" class=\\"submit\\" name=\\"topsubmit\\" value=\\" $lang[texttopthread]\\" /></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(167, 'u2u', '$u2uheader\n<table border=\\"0\\" cellspacing=\\"0\\" cellpadding=\\"0\\" width=\\"100%\\" align=\\"center\\">\n<tr>\n<td width=\\"19%\\" valign=\\"top\\" align=\\"center\\">\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"100%\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\" colspan=\\"2\\"><strong><font color=\\"{$THEME[\\''cattext\\'']}\\">$lang[textfolders]</font></strong></td>\n</tr>\n$folderlist\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" colspan=\\"2\\"><strong><a href=\\"u2u.php?action=folders\\">$lang[textmanagefolders]</a></strong></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</td>\n<td width=\\"1%\\">&nbsp;&nbsp;</td>\n<td width=\\"79%\\" valign=\\"top\\">$leftpane</td>\n</tr>\n</table>\n$u2uquotabar\n$u2ufooter\n\n'),
(168, 'u2u_drafts', '<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"$thewidth\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\"><table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr class=\\"category\\">\n<td colspan=\\"5\\"><strong><font color=\\"{$THEME[\\''cattext\\'']}\\">$lang[textu2uprevsaved]</font></strong></td>\n</tr>\n<tr class=\\"header\\">\n<td width=\\"5%\\">$lang[textselectu2u]</td>\n<td width=\\"10%\\">$lang[u2ureadstatus]</td>\n<td width=\\"40%\\">$lang[textsubject]</td>\n<td width=\\"20%\\">$lang[textto]</td>\n<td width=\\"25%\\">$lang[textu2usavedon]</td>\n</tr>\n$u2usdraft\n</table>\n</td>\n</tr>\n</table>\n\n'),
(169, 'u2u_folderlink', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\"><a href=\\"u2u.php?folder=$link\\">$value</a>$emptytrash</td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">($count)</td>\n</tr>\n\n'),
(170, 'u2u_folders', '<form method=\\"post\\" action=\\"u2u.php?action=folders\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"100%\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td colspan=\\"2\\" class=\\"category\\"><strong><font color=\\"{$THEME[\\''cattext\\'']}\\">$lang[folderlist]</font></strong></td>\n</tr>\n\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" valign=\\"top\\">$lang[foldermsg]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><textarea rows=\\"5\\" cols=\\"30\\" name=\\"u2ufolders\\">\n$self[u2ufolders]</textarea></td>\n</tr>\n<tr>\n<td class=\\"ctrtablerow\\" colspan=\\"2\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"submit\\" name=\\"folderssubmit\\" class=\\"submit\\" value=\\"$lang[textsubmitchanges]\\" /></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(171, 'u2u_footer', '<br />\n<table align=\\"center\\">\n<tr>\n<td align=\\"center\\"><font style=\\"font-size: 10px; font-family: Verdana\\">$versionlong\n<br />\n<a href=\\"https://www.xmbforum2.com/\\" onclick=\\"window.open(this.href); return false;\\"><strong>{$lang[\\''xmbforum\\'']}</strong></a>&nbsp;&copy; $copyright $lang[xmbgroup]</font></td>\n</tr>\n</table>\n</body>\n</html>\n\n'),
(172, 'u2u_header', '<!DOCTYPE html PUBLIC \\"-//W3C//DTD XHTML 1.0 Transitional//EN\\" \\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\\">\n<html>\n<head>\n<meta http-equiv=\\"Content-Type\\" content=\\"text/html; charset={$lang[\\''charset\\'']}\\" />\n<meta name=\\"viewport\\" content=\\"width=500, initial-scale=1\\" />\n<title>$bbname - $lang[textpowered]</title>\n<script language=\\"JavaScript\\" type=\\"text/javascript\\" src=\\"./js/u2uheader.js\\"></script>\n$css\n</head>\n<body text=\\"{$THEME[\\''text\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"0\\" cellpadding=\\"0\\" width=\\"100%\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"0\\" width=\\"100%\\">\n<tr>\n<td>\n<table border=\\"0\\" cellspacing=\\"0\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr class=\\"mediumtxt\\">\n<td align=\\"center\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"20%\\"><a href=\\"u2u.php\\"><img src=\\"{$THEME[\\''imgdir\\'']}/inbox.gif\\" alt=\\"$lang[textu2uinbox]\\" border=\\"0\\" /><br />$lang[textu2uinbox]</a></td>\n<td align=\\"center\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"20%\\"><a href=\\"u2u.php?folder=Outbox\\"><img src=\\"{$THEME[\\''imgdir\\'']}/outbox.gif\\" alt=\\"$lang[textu2uoutbox]\\" border=\\"0\\" /><br />$lang[textu2uoutbox]</a></td>\n<td align=\\"center\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"20%\\"><a href=\\"u2u.php?action=send\\"><img src=\\"{$THEME[\\''imgdir\\'']}/newu2u.gif\\"  alt=\\"$lang[textsendu2u]\\" border=\\"0\\" /><br />$lang[textsendu2u]</a></td>\n<td align=\\"center\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"20%\\"><a href=\\"buddy.php\\" onclick=\\"javascript:aBook();return false;\\"><img src=\\"{$THEME[\\''imgdir\\'']}/address.gif\\"  alt=\\"$lang[textu2uaddressbook]\\" border=\\"0\\" /><br />$lang[textu2uaddressbook]</a></td>\n<td align=\\"center\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"20%\\"><a href=\\"u2u.php?action=ignore\\"><img src=\\"{$THEME[\\''imgdir\\'']}/locku2u.gif\\"  alt=\\"$lang[ignorelist]\\" border=\\"0\\" /><br />$lang[ignorelist]</a></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n\n'),
(173, 'u2u_ignore', '<form method=\\"post\\" action=\\"u2u.php?action=ignore\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"$thewidth\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\" colspan=\\"2\\"><strong><font color=\\"{$THEME[\\''cattext\\'']}\\">$lang[ignorelist]</font></strong></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" valign=\\"top\\">$lang[ignoremsg]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><textarea rows=\\"5\\" cols=\\"30\\" name=\\"ignorelist\\">\n$self[ignoreu2u]</textarea></td>\n</tr>\n<tr>\n<td class=\\"ctrtablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" colspan=\\"2\\"><input type=\\"submit\\" name=\\"ignoresubmit\\" class=\\"submit\\" value=\\"$lang[textsubmitchanges]\\" /></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(174, 'u2u_inbox', '<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"$thewidth\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr class=\\"header\\">\n<td colspan=\\"5\\" class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\">$lang[textu2uincoming]</font></td>\n</tr>\n<tr class=\\"header\\">\n<td width=\\"5%\\" align=\\"center\\">$lang[textselectu2u]</td>\n<td width=\\"10%\\">$lang[u2ureadstatus]</td>\n<td width=\\"40%\\">$lang[textsubject]</td>\n<td width=\\"20%\\">$lang[textfrom]</td>\n<td width=\\"25%\\">$lang[textsent]</td>\n</tr>\n$u2usin\n</table>\n</td>\n</tr>\n</table>\n\n'),
(175, 'u2u_main', '<form method=\\"post\\" action=\\"u2u.php?action=mod\\" name=\\"u2u_main\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n$u2ulist\n<br />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"$thewidth\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\" align=\\"left\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><a href=\\"u2u.php\\" onclick=\\"setCheckboxes(\\''u2u_main\\'', true); return false;\\">$lang[checkall]</a> -\n<a href=\\"u2u.php\\" onclick=\\"setCheckboxes(\\''u2u_main\\'', false); return false;\\">$lang[uncheckall]</a> -\n<a href=\\"u2u.php\\" onclick=\\"invertSelection(\\''u2u_main\\'', \\''u2u_select[]\\''); return false;\\">$lang[invertselection]</a></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\"><input type=\\"radio\\" name=\\"modaction\\" value=\\"delete\\" /> $lang[deletebutton]</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\"><input type=\\"radio\\" name=\\"modaction\\" value=\\"move\\" /> $lang[textu2umoveto] $mtofolder<br /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\"><input type=\\"radio\\" name=\\"modaction\\" value=\\"markunread\\" /> $lang[textu2umarkunread]\n<input type=\\"hidden\\" name=\\"folder\\" value=\\"$folder\\" /></td>\n</tr>\n<tr class=\\"ctrtablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input class=\\"submit\\" type=\\"submit\\" name=\\"u2umodsubmit\\" value=\\"$lang[textsubmitchanges]\\" /></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(176, 'u2u_msg', '$u2uheader\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td width=\\"100%\\" class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$msg</td>\n</tr>\n</table></td>\n</tr>\n</table>\n<br />\n$u2ufooter\n\n'),
(177, 'u2u_old', '$u2uheader\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"header\\" align=\\"center\\">\n<a href=\\"u2u.php\\">$lang[textu2uinbox]</a> -\n<a href=\\"u2u.php?folder=Outbox\\">$lang[textu2uoutbox]</a> -\n<a href=\\"u2u.php?folder=Drafts\\">$lang[textu2udrafts]</a> -\n<a href=\\"u2u.php?folder=Trash\\">$lang[textu2utrash]</a>  (<a href=\\"u2u.php?action=emptytrash\\">$lang[textemptytrash]</a>)\n</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n$leftpane\n$u2uquotabar\n$u2ufooter\n\n'),
(178, 'u2u_outbox', '<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"$thewidth\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr class=\\"header\\">\n<td colspan=\\"5\\" class=\\"category\\"><strong><font color=\\"{$THEME[\\''cattext\\'']}\\">$lang[textu2uoutgoing]</font></strong></td>\n</tr>\n<tr class=\\"header\\">\n<td width=\\"5%\\">$lang[textselectu2u]</td>\n<td width=\\"10%\\">$lang[u2ureadstatus]</td>\n<td width=\\"40%\\">$lang[textsubject]</td>\n<td width=\\"20%\\">$lang[textto]</td>\n<td width=\\"25%\\">$lang[textsent]</td>\n</tr>\n$u2usout\n</table>\n</td>\n</tr>\n</table>\n\n'),
(179, 'u2u_printable', '<?xml version=\\"1.0\\" encoding=\\"{$lang[\\''charset\\'']}\\"?>\n<!DOCTYPE html PUBLIC \\"-//W3C//DTD XHTML 1.0 Transitional//EN\\" \\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\\">\n<html xmlns=\\"http://www.w3.org/1999/xhtml\\">\n<head>\n<meta http-equiv=\\"Content-Type\\" content=\\"text/html; charset={$lang[\\''charset\\'']}\\" />\n<meta name=\\"viewport\\" content=\\"width=500, initial-scale=1\\" />\n<style type=\\"text/css\\">\np {\nfont-size: 14px;\nfont-family: arial, verdana;\n}\n.16px {\nfont-size: 16px;\nfont-family: arial, verdana;\nfont-weight: bold;\n}\n.14px {\nfont-size: 14px;\nfont-family: arial, verdana;\nfont-weight: bold;\n}\n.13px {\nfont-size: 14px;\nfont-family: arial, verdana;\n}\ncode {\nwhite-space: pre;\n}\n</style>\n<title>$bbname - $lang[textpowered]</title>\n</head>\n<body>\n{$THEME[\\''logo\\'']}<br /><br />\n<span class=\\"16px\\">$lang[textsubject] $u2usubject<br />\n$lang[textfrom] $u2ufrom<br />\n$lang[textto] $u2uto<br />\n$lang[textu2ufolder] $u2ufolder<br />\n$lang[textsent] $u2udateline</span>\n<br />\n<p>$u2umessage</p>\n</body>\n</html>\n\n'),
(180, 'u2u_quotabar', '<br />\n<table border=\\"0\\" cellspacing=\\"0\\" cellpadding=\\"0\\" width=\\"100%\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"mediumtxt\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">\n<div align=\\"center\\">$uqinfo</div>\n<img src=\\"{$THEME[\\''imgdir\\'']}/pollbar.gif\\" width=\\"$barwidth%\\" height=\\"10\\" alt=\\"$lang[altpollpercentage]\\" />\n</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n\n'),
(181, 'u2u_row', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" align=\\"center\\"><input type=\\"checkbox\\" name=\\"u2u_select[]\\" value=\\"$u2u[u2uid]\\" /><input type=\\"hidden\\" name=\\"type$u2u[u2uid]\\" value=\\"$u2u[type]\\" /></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$u2ureadstatus</td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\"><a href=\\"u2u.php?action=view&amp;folder=$folderrecode&amp;u2uid=$u2u[u2uid]\\">$u2usubject</a></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$u2usent</td>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$u2udateline</td>\n</tr>\n\n'),
(182, 'u2u_row_none', '<tr>\n<td class=\\"tablerow\\" colspan=\\"5\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textu2unonefound]</td>\n</tr>\n\n'),
(183, 'u2u_send', '<script type=\\"text/javascript\\" language=\\"JavaScript\\">\nvar sendMode = true;\n</script>\n<form method=\\"post\\" action=\\"u2u.php?action=send\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<input name=\\"u2uid\\" type=\\"hidden\\" value=\\"$u2uid\\" />\n$u2upreview\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"$thewidth\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td width=\\"100%\\" colspan=\\"2\\" class=\\"category\\" align=\\"center\\"><strong><font color=\\"{$THEME[\\''cattext\\'']}\\">$lang[textu2u]</font></strong></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textsendto]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"msgto\\" id=\\"msgto\\" size=\\"20\\" value=\\"$username\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textsubject]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"text\\" name=\\"subject\\" size=\\"35\\" value=\\"$subject\\" /></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td valign=\\"top\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">$lang[textmessage]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><textarea rows=\\"10\\" name=\\"message\\" id=\\"message\\" cols=\\"50\\">\n$message</textarea><br /></td>\n</tr>\n<tr>\n<td valign=\\"top\\" class=\\"ctrtablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" colspan=\\"2\\">\n<input type=\\"hidden\\" name=\\"del\\" value=\\"$del\\" />\n<input type=\\"submit\\" class=\\"submit\\" name=\\"sendsubmit\\" value=\\"$lang[textsendu2u]\\" />\n<input type=\\"submit\\" class=\\"submit\\" name=\\"savesubmit\\" value=\\"$lang[textsaveu2u]\\" />\n<input type=\\"submit\\" class=\\"submit\\" name=\\"previewsubmit\\" value=\\"$lang[textpreviewu2u]\\" /></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(184, 'u2u_send_preview', '<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"$thewidth\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"header\\" colspan=\\"2\\">$lang[textsubject] $u2usubject</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"14%\\">$lang[textmessage]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$u2umessage</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<br />\n\n'),
(185, 'u2u_view', '<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"$thewidth\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"header\\" colspan=\\"2\\">$lang[textsubject] $u2usubject</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"15%\\">$lang[textfrom]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$u2ufrom</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"15%\\">$lang[textto]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$u2uto</td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"15%\\">$lang[textu2ufolder]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$u2ufolder</td>\n</tr>\n<tr>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"tablerow\\" width=\\"15%\\">$lang[textsent]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"smalltxt\\">$u2udateline</td>\n</tr>\n<tr class=\\"tablerow\\" valign=\\"top\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" width=\\"15%\\">$lang[textmessage]$u2uavatar</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$u2umessage</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<table cellspacing=\\"2\\" cellpadding=\\"2\\" border=\\"0\\" align=\\"center\\">\n<tr>\n<td align=\\"right\\" class=\\"tablerow\\"><a href=\\"u2u.php?action=printable&amp;u2uid=$u2uid\\" onclick=\\"window.open(this.href); return false;\\">$lang[textprintver]</a></td>\n</tr>\n</table>\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"$thewidth\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<form method=\\"post\\" action=\\"u2u.php?action=modif\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\"><font color=\\"{$THEME[\\''cattext\\'']}\\">$lang[textu2uoptions]</font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">\n<input type=\\"hidden\\" name=\\"u2uid\\" value=\\"$u2u[u2uid]\\" />\n<input type=\\"hidden\\" name=\\"folder\\" value=\\"$u2u[folder]\\" />\n<input type=\\"hidden\\" name=\\"type\\" value=\\"$u2u[type]\\" />\n<input type=\\"radio\\" name=\\"mod\\" value=\\"delete\\" $delchecked /> $lang[deletebutton]<br />\n$sendoptions\n<input type=\\"radio\\" name=\\"mod\\" value=\\"markunread\\" /> $lang[textu2umarkunread]<br />\n<input type=\\"radio\\" name=\\"mod\\" value=\\"sendtoemail\\" /> $lang[textforwardu2utoemail]<br />\n<input type=\\"radio\\" name=\\"mod\\" value=\\"move\\" /> $lang[textu2umoveto] $mtofolder<br /></td>\n</tr>\n<tr class=\\"ctrtablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input class=\\"submit\\" type=\\"submit\\" name=\\"u2umodsubmit\\" value=\\"$lang[textsubmitchanges]\\" /></td>\n</tr>\n</table>\n</form>\n</td>\n</tr>\n</table>\n\n'),
(186, 'viewthread', '$poll\n<table width=\\"{$THEME[\\''tablewidth\\'']}\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" align=\\"center\\">\n<tr>\n<td class=\\"smalltxt\\"><a href=\\"$printable_link\\" rel=\\"alternate\\">$lang[textprintver]</a>$memcplink</td>\n<td class=\\"post\\" align=\\"right\\" valign=\\"bottom\\">&nbsp;$newtopiclink$newpolllink$replylink</td>\n</tr>\n</table>\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n$multipage\n<tr class=\\"header\\">\n<td width=\\"18%\\">$lang[textauthor] </td>\n<td>$lang[textsubject] $thread[subject]</td>\n</tr>\n$posts\n$multipage\n</table>\n</td>\n</tr>\n</table>\n<table width=\\"{$THEME[\\''tablewidth\\'']}\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" align=\\"center\\">\n<tr>\n<td class=\\"post\\" align=\\"right\\" style=\\"padding-top: 3px\\">$newtopiclink$newpolllink$replylink</td>\n</tr>\n<tr>\n<td colspan=\\"2\\">$modoptions</td>\n</tr>\n</table>\n$quickreply\n\n'),
(187, 'viewthread_modlog', '<tr bgcolor=\\"$thisbg\\">\n<td valign=\\"top\\" class=\\"tablerow\\" style=\\"width: 18%;\\">\n<font class=\\"mediumtxt\\"><strong>$profilelink</strong></font>\n<br />\n<div class=\\"smalltxt\\"><a name=\\"pid$post[pid]\\"></a>\n$showtitle\n</div>\n</td>\n<td class=\\"tablerow\\" valign=\\"top\\" style=\\"width: 82%\\" >\n<font class=\\"mediumtxt\\">$post[message]</font></td>\n</tr>\n\n'),
(188, 'viewthread_modoptions', '<a name=\\"admintools\\"></a>\n<form action=\\"topicadmin.php?tid=$tid&amp;fid=$fid\\" method=\\"get\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<span class=\\"mediumtxt\\"><strong>$lang[textadminoptions]</strong>\n<br />\n<select name=\\"action\\" id=\\"action\\" onchange=\\"if(this.options[this.selectedIndex].value != \\''\\'') { window.location=(\\''topicadmin.php?tid=$tid&amp;fid=$fid&amp;action=\\''+this.options[this.selectedIndex].value) }\\">\n<option value=\\"\\" selected=\\"selected\\"></option>\n<option value=\\"delete\\">$lang[textdeletethread]</option>\n<option value=\\"close\\">$closeopen</option>\n<option value=\\"copy\\">$lang[copythread]</option>\n<option value=\\"move\\">$lang[textmovemethod1]</option>\n<option value=\\"top\\">$topuntop</option>\n<option value=\\"split\\">$lang[textsplitthread]</option>\n<option value=\\"merge\\">$lang[textmergethread]</option>\n<option value=\\"bump\\">$lang[textbumpthread]</option>\n<option value=\\"empty\\">$lang[textemptythread]</option>\n<option value=\\"threadprune\\">$lang[textprunethread]</option>\n</select>\n</span>\n</form>\n\n'),
(189, 'viewthread_multipage', '<tr class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">\n<td colspan=\\"2\\" class=\\"multi\\">&nbsp;$multipage</td>\n</tr>\n\n'),
(190, 'viewthread_newpoll', '<a href=\\"post.php?action=newthread&amp;fid=$fid&amp;poll=yes\\" title=\\"$lang[textpoll]\\"><img src=\\"{$THEME[\\''imgdir\\'']}/poll.gif\\" border=\\"0\\" alt=\\"$lang[textpoll]\\" /></a>\n\n'),
(191, 'viewthread_newtopic', '<a href=\\"post.php?action=newthread&amp;fid=$fid\\" title=\\"$lang[altpostnewthread]\\"><img src=\\"{$THEME[\\''imgdir\\'']}/newtopic.gif\\" border=\\"0\\" alt=\\"$lang[altpostnewthread]\\" /></a>\n\n'),
(192, 'viewthread_poll', '<form method=\\"post\\" name=\\"poll\\" action=\\"vtmisc.php?action=votepoll&amp;fid=$fid&amp;tid=$tid\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr class=\\"category\\">\n<td colspan=\\"3\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textpoll] $thread[subject] $results</strong></font></td>\n</tr>\n$pollhtml\n$buttoncode\n</table>\n</td>\n</tr>\n</table>\n</form>\n<br />\n\n'),
(193, 'viewthread_poll_options', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"radio\\" name=\\"postopnum\\" value=\\"$poll[id]\\" /><font class=\\"smalltxt\\">$poll[name]</font></td>\n</tr>\n\n'),
(194, 'viewthread_poll_options_view', '<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" width=\\"30%\\"><font class=\\"smalltxt\\">$array[name]</font></td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" width=\\"60%\\">\n<img src=\\"{$THEME[\\''imgdir\\'']}/pollbar-s.gif\\" alt=\\"$lang[altpollpercentage]\\" title=\\"$lang[altpollpercentage]\\" />$pollbar<img src=\\"{$THEME[\\''imgdir\\'']}/pollbar-e.gif\\" alt=\\"$lang[altpollpercentage]\\" title=\\"$lang[altpollpercentage]\\" />\n</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" width=\\"10%\\"><font class=\\"smalltxt\\">$array[votes] ($percentage)</font></td>\n</tr>\n\n'),
(195, 'viewthread_poll_submitbutton', '<tr>\n<td class=\\"ctrtablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" colspan=\\"3\\"><input type=\\"submit\\" class=\\"submit\\" value=\\"$lang[submitvote]\\" /></td>\n</tr>\n\n'),
(196, 'viewthread_post', '<tr bgcolor=\\"$thisbg\\">\n<td rowspan=\\"3\\" valign=\\"top\\" class=\\"tablerow\\" style=\\"width: 18%;\\">\n<font class=\\"mediumtxt\\"><strong>$profilelink</strong></font>\n<br />\n<div class=\\"smalltxt\\"><a name=\\"pid$post[pid]\\"></a>\n$showtitle\n$stars\n<br />\n<div align=\\"center\\">\n$rank[avatar]\n</div>\n<hr />\n<div align=\\"center\\">\n$avatar\n</div>\n<br />\n<br />\n$lang[textposts] $post[postnum]\n<br />\n$lang[textregistered] $tharegdate\n$location\n<br />\n$onlinenow\n<br />\n<br />\n$mood\n</div>\n<br />\n</td>\n<td valign=\\"top\\" class=\\"tablerow\\" style=\\"height: 30px; width: 82%;\\">\n<table border=\\"0\\" cellspacing=\\"0\\" cellpadding=\\"0\\" width=\\"100%\\">\n<tr>\n<td class=\\"smalltxt\\" valign=\\"top\\">$post[icon] <a href=\\"viewthread.php?tid={$post[\\''tid\\'']}&amp;goto=search&amp;pid={$post[\\''pid\\'']}\\" title=\\"$linktitle\\" rel=\\"nofollow\\">$poston</a></td>\n<td class=\\"smalltxt\\" align=\\"right\\" valign=\\"top\\">$edit$repquote$reportlink</td>\n</tr>\n</table>\n</td>\n</tr>\n<tr bgcolor=\\"$thisbg\\">\n<td class=\\"tablerow\\" valign=\\"top\\" style=\\"height: 80px; width: 82%\\" >\n<font class=\\"subject\\">\n<strong>$post[subject]</strong>\n</font>\n<br />\n<br />\n<div class=\\"mediumtxt\\">{$post[\\''message\\'']}</div>\n</td>\n</tr>\n<tr bgcolor=\\"$thisbg\\">\n<td class=\\"tablerow\\" valign=\\"bottom\\" style=\\"height: 20px; width: 82%;\\">\n<table border=\\"0\\" cellspacing=\\"0\\" cellpadding=\\"0\\" width=\\"100%\\">\n<tr>\n<td class=\\"smalltxt\\">\n$profile$email$site$search$u2u$aim$icq$msn$yahoo\n</td>\n<td align=\\"right\\">$ip</td>\n</tr>\n</table>\n</td>\n</tr>\n\n'),
(197, 'viewthread_post_aim', '<a href=\\"aim:goim?screenname=$post[aim]&amp;message=Hi+$post[aim].+Are+you+there+I+got+your+aim+name+from+a+message+board.\\" title=\\"{$lang[\\''textaim\\'']}\\"><img src=\\"{$THEME[\\''imgdir\\'']}/aim.gif\\" alt=\\"\\" border=\\"0\\" /></a>\n\n'),
(198, 'viewthread_post_attachment', '$lang[attachment] <a href=\\"{$post[\\''fileurl\\'']}\\" onclick=\\"window.open(this.href); return false;\\">$post[filename]</a> ($attachsize)\n<br />\n<font class=\\"smalltxt\\">$lang[textdownloadcount1] $downloadcount $lang[textdownloadcount2]</font>\n\n'),
(199, 'viewthread_post_attachmentimage', '<img src=\\"{$post[\\''fileurl\\'']}\\" title=\\"$post[filename] - $attachsize\\" alt=\\"$post[filename] - $attachsize\\" {$post[\\''filedims\\'']} />\n\n'),
(200, 'viewthread_post_attachmentthumb', '<a href=\\"{$post[\\''fileurl\\'']}\\" title=\\"$post[filename] - $attachsize\\" onclick=\\"window.open(this.href); return false;\\"><img src=\\"{$post[\\''thumburl\\'']}\\" alt=\\"$post[filename] - $attachsize\\" border=\\"0px\\" {$post[\\''filedims\\'']} /></a>\n\n'),
(201, 'viewthread_post_edit', '<a href=\\"post.php?action=edit&amp;fid=$fid&amp;tid=$tid&amp;pid=$post[pid]\\" title=\\"$lang[alteditpost]\\"><img src=\\"{$THEME[\\''imgdir\\'']}/edit.gif\\" border=\\"0\\" alt=\\"$lang[alteditpost]\\" /></a>\n\n'),
(202, 'viewthread_post_email', '<a href=\\"mailto:$post[email]\\" title=\\"$lang[altemailuser]\\"><img src=\\"{$THEME[\\''imgdir\\'']}/email.gif\\" border=\\"0\\" alt=\\"$lang[altemailuser]\\" /></a>\n\n'),
(203, 'viewthread_post_icq', '<a href=\\"icq:message?uin={$post[\\''icq\\'']}\\" onclick=\\"window.open(this.href); return false;\\" title=\\"{$lang[\\''texticq\\'']}\\"><img src=\\"{$THEME[\\''imgdir\\'']}/icq.gif\\" alt=\\"\\" border=\\"0\\" /></a>\n\n'),
(204, 'viewthread_post_ip', '<a href=\\"topicadmin.php?action=getip&amp;fid=$fid&amp;tid=$tid&amp;pid=$post[pid]\\" title=\\"$lang[altgetip]\\"><img src=\\"{$THEME[\\''imgdir\\'']}/ip.gif\\" border=\\"0\\" alt=\\"$lang[altgetip]\\" /></a>\n\n'),
(205, 'viewthread_post_msn', '<a href=\\"msnim:chat?{$post[\\''msn\\'']}\\" onclick=\\"window.open(this.href); return false;\\" title=\\"$lang[altmsnyes]\\"><img src=\\"{$THEME[\\''imgdir\\'']}/msn.gif\\" border=\\"0\\" alt=\\"$lang[altmsnyes]\\" /></a>\n\n'),
(206, 'viewthread_post_nosig', ''),
(207, 'viewthread_post_profile', '<a href=\\"member.php?action=viewpro&amp;member=$encodename\\" title=\\"$lang[altviewprofile]\\"><img src=\\"{$THEME[\\''imgdir\\'']}/profile.gif\\" border=\\"0\\" alt=\\"$lang[altviewprofile]\\" /></a>\n\n'),
(208, 'viewthread_post_report', '<a href=\\"vtmisc.php?action=report&amp;fid=$fid&amp;tid=$tid&amp;pid=$post[pid]\\" title=\\"$lang[altreportpost]\\"><img src=\\"{$THEME[\\''imgdir\\'']}/report.gif\\" border=\\"0\\" alt=\\"$lang[altreportpost]\\" /></a>\n\n'),
(209, 'viewthread_post_repquote', '<a href=\\"post.php?action=reply&amp;tid=$tid&amp;repquote=$post[pid]\\" title=\\"$lang[altquote]\\"><img src=\\"{$THEME[\\''imgdir\\'']}/quote.gif\\" border=\\"0\\" alt=\\"$lang[altquote]\\" /></a>\n\n'),
(210, 'viewthread_post_search', '<a href=\\"search.php?srchuname=$encodename&amp;searchsubmit=a&amp;f=all&amp;srchfrom=0\\" title=\\"$lang[altfindposts]\\"><img src=\\"{$THEME[\\''imgdir\\'']}/find.gif\\" border=\\"0\\" alt=\\"$lang[altfindposts]\\" /></a>\n\n'),
(211, 'viewthread_post_sig', '<br />\n<br />\n<br />\n<br />\n<div class=\\"sig\\">$post[sig]</div>\n\n'),
(212, 'viewthread_post_site', '<a href=\\"$post[site]\\" onclick=\\"window.open(this.href); return false;\\" title=\\"$lang[altvisitsite]\\"><img src=\\"{$THEME[\\''imgdir\\'']}/site.gif\\" border=\\"0\\" alt=\\"$lang[altvisitsite]\\" /></a>\n\n'),
(213, 'viewthread_post_u2u', '<a href=\\"u2u.php?action=send&amp;username=$encodename\\" onclick=\\"Popup(this.href, \\''Window\\'', 700, 500); return false;\\" title=\\"{$lang[\\''altu2umember\\'']}\\"><img src=\\"{$THEME[\\''imgdir\\'']}/u2u.gif\\" border=\\"0\\" alt=\\"{$lang[\\''altu2umember\\'']}\\" /></a>\n\n'),
(214, 'viewthread_post_yahoo', '<a href=\\"ymsgr:sendim?{$post[\\''yahoo\\'']}\\" onclick=\\"window.open(this.href); return false;\\" title=\\"{$lang[\\''textyahoo\\'']}\\"><img src=\\"{$THEME[\\''imgdir\\'']}/yahoo.gif\\" alt=\\"\\" border=\\"0\\" /></a>\n\n'),
(215, 'viewthread_printable', '<?xml version=\\"1.0\\" encoding=\\"{$lang[\\''charset\\'']}\\"?>\n<!DOCTYPE html PUBLIC \\"-//W3C//DTD XHTML 1.0 Transitional//EN\\" \\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\\">\n<html xmlns=\\"http://www.w3.org/1999/xhtml\\">\n<!-- $versionlong  -->\n<!-- Build: $versionbuild -->\n<!-- $versioncompany -->\n<head>\n$baseelement$canonical_link\n<meta http-equiv=\\"Content-Type\\" content=\\"text/html; charset={$lang[\\''charset\\'']}\\" />\n<meta name=\\"viewport\\" content=\\"width=500, initial-scale=1\\" />\n<title>{$SETTINGS[\\''bbname\\'']} $threadSubject - $versionlong</title>\n<style type=\\"text/css\\">\n.mediumtxt {\nfont-size: 14px;\nfont-family: arial, verdana;\n}\n\nh2, h3 {\nmargin-bottom: 0px;\nmargin-top: 0px;\n}\n\n.s14px {\nfont-size: 14px;\nfont-family: arial, verdana;\nfont-weight: bold;\n}\n\n.s13px {\nfont-size: 14px;\nfont-family: arial, verdana;\n}\n\ncode {\nwhite-space: pre-wrap;\n}\n</style>\n</head>\n<body>\n{$THEME[\\''logo\\'']}\n<br />\n<br />\n<h2><a href=\\"$threadlink\\" rev=\\"alternate\\">$thread[subject]</a></h2>\n$multipage\n$posts\n$multipage\n</body>\n</html>\n\n'),
(216, 'viewthread_printable_row', '<h3>$subject</h3><span class=\\"s14px\\">$post[author]</span> - <span class=\\"s13px\\">$poston</span><br /><br />\n<font class=\\"mediumtxt\\">$post[message]</font><hr />\n\n'),
(217, 'viewthread_quickreply', '<br />\n<a name=\\"qreply\\"></a>\n<form method=\\"post\\" name=\\"input\\" action=\\"post.php?action=reply&amp;tid=$tid\\" onsubmit=\\"return disableButton(this);\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table width=\\"{$THEME[\\''tablewidth\\'']}\\" border=\\"0\\" align=\\"center\\" cellpadding=\\"0\\" cellspacing=\\"0\\" bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<tr>\n<td><input type=\\"hidden\\" name=\\"subject\\" value=\\"\\" />\n<table width=\\"100%\\" border=\\"0\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\">\n<tr bgcolor=\\"{$THEME[\\''altbg1\\'']}\\">\n<td colspan=\\"3\\" class=\\"category\\"><div align=\\"left\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>&nbsp;&raquo;&nbsp;$lang[quickreply]</strong>$quick_name_display</font></div></td>\n</tr>\n$captchapostcheck\n<tr class=\\"quickreply\\">\n<td width=\\"8%\\" height=\\"101\\" bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" class=\\"tablerow\\"> <div align=\\"left\\"><span class=\\"smalltxt\\">$lang[texthtmlis] $allowhtml<br />\n$lang[textsmiliesare] $allowsmilies<br />\n$lang[textbbcodeis] $allowbbcode<br />\n$lang[textimgcodeis] $allowimgcode</span></div>\n$smilies\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" width=\\"56%\\" class=\\"tablerow\\">\n <div align=\\"center\\"><textarea rows=\\"10\\" cols=\\"80\\" name=\\"message\\" id=\\"message\\" onselect=\\"storeCaret(this);\\" onclick=\\"storeCaret(this);\\" onkeyup=\\"storeCaret(this);\\" style=\\"width: 100%;\\"></textarea></div>\n $quickbbcode\n</td>\n<td width=\\"20%\\" height=\\"101\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\" class=\\"tablerow\\"> <div align=\\"center\\">\n<table width=\\"100%\\" border=\\"0\\" class=\\"tablerow\\" cellspacing=\\"0\\" cellpadding=\\"0\\">\n<tr>\n<td width=\\"15%\\"> <div align=\\"left\\"><input type=\\"checkbox\\" name=\\"smileyoff\\" value=\\"yes\\" /></div></td>\n<td width=\\"85%\\"> <div align=\\"left\\">$lang[textdissmileys]</div></td>\n</tr>\n<tr $disableguest>\n<td width=\\"15%\\"> <div align=\\"left\\"><input type=\\"checkbox\\" name=\\"usesig\\" value=\\"yes\\" $usesigcheck /></div></td>\n<td width=\\"85%\\"> <div align=\\"left\\">$lang[textusesig]</div></td>\n</tr>\n<tr>\n<td width=\\"15%\\"> <div align=\\"left\\"><input type=\\"checkbox\\" name=\\"bbcodeoff\\" value=\\"yes\\" /></div></td>\n<td width=\\"85%\\"> <div align=\\"left\\">$lang[bbcodeoff] </div></td>\n</tr>\n<tr $disableguest>\n<td width=\\"15%\\"> <div align=\\"left\\"><input type=\\"checkbox\\" name=\\"emailnotify\\" value=\\"yes\\" $subcheck /></div></td>\n<td width=\\"85%\\"> <div align=\\"left\\">$lang[textemailnotify] </div></td>\n</tr>\n</table></div>\n<div align=\\"left\\">\n<br />&nbsp;&nbsp;<input type=\\"submit\\" name=\\"replysubmit\\" value=\\"$lang[textpostreply]\\" class=\\"submit\\" />\n<br /><br />&nbsp;&nbsp;<input type=\\"submit\\" name=\\"previewpost\\" value=\\"$lang[textpreview]\\" class=\\"submit\\" />\n</div></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(218, 'viewthread_quickreply_captcha', '<tr>\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" />\n<td class=\\"rghttablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">\n <img src=\\"misc.php?action=captchaimage&amp;imagehash=$imghash\\" alt=\\"$lang[captchaverification]\\" title=\\"$lang[captchaverification]\\" /><br />\n <input type=\\"text\\" name=\\"imgcode\\" value=\\"\\" /><input type=\\"hidden\\" name=\\"imghash\\" value=\\"$imghash\\" /><br />\n {$lang[\\''captchacaseon\\'']}\n</td>\n<td class=\\"tablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\">$lang[verificationnote]</td>\n</tr>\n\n'),
(219, 'viewthread_reply', '<a href=\\"./post.php?action=reply&amp;tid=$tid\\" title=\\"$lang[textpostreply]\\"><img src=\\"{$THEME[\\''imgdir\\'']}/reply.gif\\" border=\\"0\\" alt=\\"$lang[textpostreply]\\" /></a>\n\n'),
(220, 'vtmisc_report', '<form method=\\"post\\" name=\\"input\\" action=\\"vtmisc.php?action=report\\">\n<input type=\\"hidden\\" name=\\"token\\" value=\\"\\" />\n<table cellspacing=\\"0\\" cellpadding=\\"0\\" border=\\"0\\" width=\\"{$THEME[\\''tablewidth\\'']}\\" align=\\"center\\">\n<tr>\n<td bgcolor=\\"{$THEME[\\''bordercolor\\'']}\\">\n<table border=\\"0\\" cellspacing=\\"{$THEME[\\''borderwidth\\'']}\\" cellpadding=\\"{$THEME[\\''tablespace\\'']}\\" width=\\"100%\\">\n<tr>\n<td class=\\"category\\" colspan=\\"2\\"><font color=\\"{$THEME[\\''cattext\\'']}\\"><strong>$lang[textreportpost]</strong></font></td>\n</tr>\n<tr class=\\"tablerow\\">\n<td bgcolor=\\"{$THEME[\\''altbg1\\'']}\\" valign=\\"top\\" width=\\"19%\\">$lang[textreason]</td>\n<td bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><textarea rows=\\"9\\" cols=\\"45\\" name=\\"reason\\"></textarea>\n</tr>\n<tr>\n<td colspan=\\"2\\" class=\\"ctrtablerow\\" bgcolor=\\"{$THEME[\\''altbg2\\'']}\\"><input type=\\"hidden\\" name=\\"tid\\" value=\\"$tid\\" /><input type=\\"hidden\\" name=\\"fid\\" value=\\"$fid\\" /><input type=\\"hidden\\" name=\\"pid\\" value=\\"$pid\\" /><input type=\\"submit\\" class=\\"submit\\" name=\\"reportsubmit\\" value=\\"$lang[textreportpost]\\" /></td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n</form>\n\n'),
(221, '\n', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]themes`
--

CREATE TABLE `[[dbprefix]]themes` (
  `themeid` smallint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL DEFAULT '',
  `bgcolor` varchar(25) NOT NULL DEFAULT '',
  `altbg1` varchar(15) NOT NULL DEFAULT '',
  `altbg2` varchar(15) NOT NULL DEFAULT '',
  `link` varchar(15) NOT NULL DEFAULT '',
  `bordercolor` varchar(15) NOT NULL DEFAULT '',
  `header` varchar(15) NOT NULL DEFAULT '',
  `headertext` varchar(15) NOT NULL DEFAULT '',
  `top` varchar(15) NOT NULL DEFAULT '',
  `catcolor` varchar(15) NOT NULL DEFAULT '',
  `tabletext` varchar(15) NOT NULL DEFAULT '',
  `text` varchar(15) NOT NULL DEFAULT '',
  `borderwidth` varchar(15) NOT NULL DEFAULT '',
  `tablewidth` varchar(15) NOT NULL DEFAULT '',
  `tablespace` varchar(15) NOT NULL DEFAULT '',
  `font` varchar(40) NOT NULL DEFAULT '',
  `fontsize` varchar(40) NOT NULL DEFAULT '',
  `boardimg` varchar(128) DEFAULT NULL,
  `imgdir` varchar(120) NOT NULL DEFAULT '',
  `admdir` varchar(120) NOT NULL DEFAULT 'images/admin',
  `smdir` varchar(120) NOT NULL DEFAULT 'images/smilies',
  `cattext` varchar(15) NOT NULL DEFAULT '',
  `version` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`themeid`),
  KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]themes`
--

INSERT INTO `[[dbprefix]]themes` VALUES
(1, 'XMB Davis', 'bg.gif', '#FFFFFF', '#f4f7f8', '#24404b', '#86a9b6', '#d3dfe4', '#24404b', 'topbg.gif', 'catbar.gif', '#000000', '#000000', '1px', '97%', '5px', 'Tahoma, Arial, Helvetica, Verdana', '11px', 'logo.gif', 'images/davis', 'images/admin', 'images/smilies', '#163c4b', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]threads`
--

CREATE TABLE `[[dbprefix]]threads` (
  `tid` int(11) NOT NULL AUTO_INCREMENT,
  `fid` smallint(6) NOT NULL DEFAULT '0',
  `subject` varchar(128) NOT NULL DEFAULT '',
  `icon` varchar(75) NOT NULL DEFAULT '',
  `lastpost` varchar(54) NOT NULL DEFAULT '',
  `views` bigint(20) NOT NULL DEFAULT '0',
  `replies` int(11) NOT NULL DEFAULT '0',
  `author` varchar(32) NOT NULL DEFAULT '',
  `closed` varchar(15) NOT NULL DEFAULT '',
  `topped` tinyint(4) NOT NULL DEFAULT '0',
  `pollopts` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tid`),
  KEY `lastpost` (`lastpost`),
  KEY `author` (`author`(8)),
  KEY `closed` (`closed`),
  KEY `forum_optimize` (`fid`,`topped`,`lastpost`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tokens`
--

CREATE TABLE `[[dbprefix]]tokens` (
  `token` varchar(32) NOT NULL,
  `username` varchar(32) NOT NULL,
  `action` varchar(32) NOT NULL,
  `object` varchar(32) NOT NULL,
  `expire` int(10) unsigned NOT NULL,
  PRIMARY KEY (`token`),
  KEY `expire` (`expire`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]u2u`
--

CREATE TABLE `[[dbprefix]]u2u` (
  `u2uid` bigint(20) NOT NULL AUTO_INCREMENT,
  `msgto` varchar(32) NOT NULL DEFAULT '',
  `msgfrom` varchar(32) NOT NULL DEFAULT '',
  `type` set('incoming','outgoing','draft') NOT NULL DEFAULT '',
  `owner` varchar(32) NOT NULL DEFAULT '',
  `folder` varchar(32) NOT NULL DEFAULT '',
  `subject` varchar(64) NOT NULL DEFAULT '',
  `message` text NOT NULL,
  `dateline` int(11) NOT NULL DEFAULT '0',
  `readstatus` set('yes','no') NOT NULL DEFAULT '',
  `sentstatus` set('yes','no') NOT NULL DEFAULT '',
  PRIMARY KEY (`u2uid`),
  KEY `msgto` (`msgto`(8)),
  KEY `msgfrom` (`msgfrom`(8)),
  KEY `folder` (`folder`(8)),
  KEY `readstatus` (`readstatus`),
  KEY `owner` (`owner`(8))
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]vote_desc`
--

CREATE TABLE `[[dbprefix]]vote_desc` (
  `vote_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `topic_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`vote_id`),
  KEY `topic_id` (`topic_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]vote_results`
--

CREATE TABLE `[[dbprefix]]vote_results` (
  `vote_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `vote_option_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `vote_option_text` varchar(255) NOT NULL DEFAULT '',
  `vote_result` int(11) NOT NULL DEFAULT '0',
  KEY `vote_option_id` (`vote_option_id`),
  KEY `vote_id` (`vote_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]vote_voters`
--

CREATE TABLE `[[dbprefix]]vote_voters` (
  `vote_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `vote_user_id` mediumint(9) NOT NULL DEFAULT '0',
  `vote_user_ip` varchar(39) NOT NULL DEFAULT '',
  KEY `vote_id` (`vote_id`),
  KEY `vote_user_id` (`vote_user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]whosonline`
--

CREATE TABLE `[[dbprefix]]whosonline` (
  `username` varchar(32) NOT NULL DEFAULT '',
  `ip` varchar(39) NOT NULL DEFAULT '',
  `time` int(11) NOT NULL DEFAULT '0',
  `location` varchar(150) NOT NULL DEFAULT '',
  `invisible` set('1','0') DEFAULT '0',
  KEY `username` (`username`(8)),
  KEY `ip` (`ip`),
  KEY `time` (`time`),
  KEY `invisible` (`invisible`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]words`
--

CREATE TABLE `[[dbprefix]]words` (
  `find` varchar(60) NOT NULL DEFAULT '',
  `replace1` varchar(60) NOT NULL DEFAULT '',
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `find` (`find`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=25 ;

--
-- Dumping data for table `[[dbprefix]]words`
--

INSERT INTO `[[dbprefix]]words` VALUES
('cock', '[b]****[/b]', 1),
('dick', '[b]****[/b]', 2),
('fuck', '[b][Censored][/b]', 3),
('shit', '[b][Censored][/b]', 4),
('faggot', '[b][Censored][/b]', 5),
('bitch', '[b][Censored][/b]', 6),
('whore', '[b][Censored][/b]', 7),
('mofo', '[b][Censored][/b]', 8),
('shite', '[b][Censored][/b]', 9),
('asshole', '[b][Censored][/b]', 10),
('dumbass', '[b][Censored][/b]', 11),
('blowjob', '[b][Censored][/b]', 12),
('porn', '[b][Censored][/b]', 13),
('masturbate', '[b][Censored][/b]', 14),
('masturbation', '[b][Censored][/b]', 15),
('jackoff', '[b][Censored][/b]', 16),
('jack off', '[b][Censored][/b]', 17),
('s h i t', '[b][Censored][/b]', 18),
('f u c k', '[b][Censored][/b]', 19),
('f a g g o t', '[b][Censored][/b]', 20),
('b i t c h', '[b][Censored][/b]', 21),
('cunt', '[b][Censored][/b]', 22),
('c u n t', '[b][Censored][/b]', 23),
('damn', 'dang', 24);

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
