<?php

/**
 * Manages data collectors. DebugBar provides an array-like access  to collectors by name.
 *
 * @package Log
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 */

namespace App\Debug\DebugBar;

use App\Layout;

/**
 * Manages data collectors. DebugBar provides an array-like access  to collectors by name.
 */
class DebugBar extends \DebugBar\DebugBar
{
	/**
	 * Returns a JavascriptRenderer for this instance.
	 *
	 * @param string $baseUrl
	 * @param string $basePath
	 *
	 * @return JavascriptRenderer
	 */
	public function getJavascriptRenderer($baseUrl = null, $basePath = null)
	{
		if (null === $this->jsRenderer) {
			$this->jsRenderer = new JavascriptRenderer($this, $baseUrl, $basePath);
			$this->jsRenderer->setOptions([
				'enable_jquery_noconflict' => false,
			]);
			$this->jsRenderer->disableVendor('jquery');
		}
		return $this->jsRenderer;
	}

	/**
	 * Renders the html to include needed assets.
	 *
	 * @return string
	 */
	public function loadScripts()
	{
		return $this->getJavascriptRenderer(Layout::getPublicUrl('vendor/php-debugbar/php-debugbar/src/DebugBar/Resources'))->renderHead();
	}
}
