<?php
/**
 * Service for build queries used in Query Generator
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Łukasz Krawczyk <l.krawczyk@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Builder;

use App\Report\Model\Query;

final class QueryBuilder
{
	public function __construct(
		private readonly ExpressionBuilder $expressionBuilder,
		private readonly FilterGroupBuilder $filterGroupBuilder,
	) {
	}

	/** Build query */
	public function build(array $data): Query
	{
		$firstRow = $data[0];

		$query = new Query($firstRow['query_id'], $firstRow['modulename']);

		foreach ($data as $row) {
			$query->addExpression($this->expressionBuilder->build($row, $query));
			$this->buildFilterGroup($row, $query);
		}

		return $query;
	}

	/** Build filter group */
	private function buildFilterGroup(array $row, Query $query): void
	{
		if (null !== $row['filter_group_id']) {
			$this->filterGroupBuilder->build($row, $query);
		}
	}
}
