<?php
/**
 * Interface provided required methods for formulas
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Łukasz Krawczyk <l.krawczyk@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Formula;

use App\Report\Enums\FunctionType;

/** FormulaProcessor interface */
interface FormulaProcessor
{
	/** Process data with provided function */
	public function process(array $data, FunctionType $function): float;

	/** Check if formula is supported */
	public function supports(FunctionType $function): bool;
}
