<?php
/**
 * Custom service mapper
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Łukasz Krawczyk <l.krawczyk@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Resources\Config;

use App\Report\Decorator\ReportData\FormulaReportDataDecorator;
use App\Report\Decorator\ReportDataDecorator;
use App\Report\Factory\Field\YetiForceFieldFactory;
use App\Report\Factory\FieldFactory;
use App\Report\Formula\Processor\DifferenceProcessor;
use App\Report\Formula\Processor\ProductProcessor;
use App\Report\Formula\Processor\QuotientProcessor;
use App\Report\Formula\Processor\SumProcessor;
use App\Report\Mapper\Filter\QueryGeneratorFilterMapper;
use App\Report\Mapper\FilterMapper;
use App\Report\Provider\FieldsProvider;
use App\Report\Provider\QueryGeneratorFieldsProvider;
use App\Report\Provider\QueryGeneratorReportProvider;
use App\Report\Provider\ReportProvider;
use App\Report\Repository\Field\YiiFieldRepository;
use App\Report\Repository\FieldRepository;
use App\Report\Repository\Template\YiiTemplateRepository;
use App\Report\Repository\TemplateRepository;
use App\Report\Sanitizer\ReportFieldSanitizer;
use App\Report\Sanitizer\ReportSanitizer;
/** Services class */
final class Services
{
	/** @var array|string[] declare custom service map */
	private static array $services = [
		//inline declarations
		SumProcessor::class => SumProcessor::class,
		DifferenceProcessor::class => DifferenceProcessor::class,
		ProductProcessor::class => ProductProcessor::class,
		QuotientProcessor::class => QuotientProcessor::class,

		//interface mapping
		FieldRepository::class => YiiFieldRepository::class,
		FieldsProvider::class => QueryGeneratorFieldsProvider::class,
		FilterMapper::class => QueryGeneratorFilterMapper::class,
		ReportDataDecorator::class => FormulaReportDataDecorator::class,
		ReportProvider::class => QueryGeneratorReportProvider::class,
		FieldFactory::class => YetiForceFieldFactory::class,
		ReportSanitizer::class => ReportFieldSanitizer::class,
		TemplateRepository::class => YiiTemplateRepository::class,
	];

	/** Get services definitions */
	public static function getDefinitions(): array
	{
		return self::$services;
	}

	/** Get service by class name */
	public static function getDefinition(string $class): ?string
	{
		return self::$services[$class] ?? null;
	}
}
