<?php

declare(strict_types=1);

use App\Report\Provider\FieldsProvider;
use App\Report\Provider\ReportProvider;
use App\Report\Report;
use App\User;

final class ReportTemplate_GetPreview_Action extends ReportTemplate_Save_Action
{
	/** {@inheritdoc} */
	public function process(App\Request $request)
	{
		$this->saveRecord($request);
		$reportId = $this->record->getId();
		$previewData = Report::get(ReportProvider::class)->provide($reportId, User::getCurrentUserId(), true);
		$previewHeaders = Report::get(FieldsProvider::class)->provide(
			$reportId,
			\count($previewData) > 0 ? $previewData[0] : [],
		);

		$this->record->delete();

		$response = new Vtiger_Response();
		$response->setResult(['previewData' => $previewData, 'previewHeadersData' => $previewHeaders]);
		$response->emit();
	}
}
