<?php
/**
 * Settings map config view file.
 *
 * @package   Settings
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 */

use App\Map\Coordinates;
use App\Map\Layer;
use App\Map\Routing;

/**
 * Settings map config view class.
 */
class Settings_Map_Config_View extends Settings_Vtiger_Index_View
{
	/** {@inheritdoc} */
	public function process(App\Request $request): void
	{
		$viewer = $this->getViewer($request);

		$viewer->assign('COORDINATES_ROWS', Coordinates::getConfigs());
		$viewer->assign('ROUTING_ROWS', Routing::getConfigs());
		$viewer->assign('TILE_LAYER_ROWS', Layer::getConfigs());

		$qualifiedModuleName = $request->getModule(false);
		$viewer->assign('QUALIFIED_MODULE', $qualifiedModuleName);

		$viewer->view('Config.tpl', $qualifiedModuleName);
	}
}
