<?php

/**
 * OAuth authorization action file.
 *
 * @package Action
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */

use App\Mail\Account\Repository;
use App\Mail\Account\Repository\AccountPrivateRepository;

/**
 * OAuth authorization action class.
 */
class Users_OAuth_Action extends \App\Controller\Action
{
	/** {@inheritdoc} */
	public function checkPermission(App\Request $request)
	{
		$recordId = $request->getInteger('record');
		$repository = new \App\Mail\Account\Repository\AccountPrivateRepository();
		$accountEntity = $repository->findByUserId($recordId);

		$userModel = \App\User::getCurrentUserModel();
		if ((int) $userModel->getId() !== $recordId || !$accountEntity || !$accountEntity->isPrivate()) {
			throw new \App\Exceptions\NoPermittedToRecord('ERR_NO_PERMISSIONS_FOR_THE_RECORD', 406);
		}
	}

	/** {@inheritdoc} */
	public function process(App\Request $request)
	{
		$recordId = $request->getInteger('record');
		$class = AccountPrivateRepository::class;

		$repository = (new Repository())->get($class);
		$accountEntity = $repository->findByUserId($recordId);
		$mailAccount = new \App\Mail\Account($accountEntity, $repository);
		$oauthProvider = $mailAccount->getOAuthProvider();

		$state = $oauthProvider->getState();
		$options = ['login_hint' => $mailAccount->getLogin()];
		if (!$accountEntity->getRefreshToken() || !$accountEntity->getPassword()) {
			$options['prompt'] = 'consent';
		}
		$url = $oauthProvider->getAuthorizationUrl($options);

		$hash = sha1($state);
		\App\Session::set("OAuth.State.{$hash}", [
			'state' => $state,
			'recordId' => $accountEntity->getId(),
			'redirectUri' => \App\Config::main('site_URL') . "index.php?module=Users&view=PreferenceDetail&record={$recordId}&tab=mailbox",
			'repositoryClass' => $class
		]);

		header('location: ' . $url);
		exit;
	}

	/** {@inheritdoc} */
	public function validateRequest(App\Request $request)
	{
		$request->validateReadAccess();
	}
}
