'use strict';

/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/"use strict";function _typeof(o){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(o){return typeof o}:function(o){return o&&"function"==typeof Symbol&&o.constructor===Symbol&&o!==Symbol.prototype?"symbol":typeof o},_typeof(o)}window.AppConnector={/**
	 * Sends a pjax request (push state +ajax)
	 * The function is deferred. it will be resolved on success and error on failure
	 *  Success - if request is success it will send you data that it recieved
	 *  error - it will send two parameters first gives string regarding error
	 *                   Second gives you error object if exists
	 *
	 *  @return - deferred promise
	 */requestPjax:function requestPjax(params){return AppConnector._request(params,!0)},/**
	 *  Sends ajax request to the specified url.
	 *  The function is deferred. it will be resolved on success and error on failure
	 *  Success - if request is success it will send you data that it recieved
	 *  error - it will send two parameters first gives string regarding error
	 *                   Second gives you error object if exists
	 *
	 *  @return - deferred promise
	 */request:function request(params,rawData){return AppConnector._request(params,!1,rawData)},_request:function _request(params,pjaxMode,rawData){var aDeferred=jQuery.Deferred();"undefined"==typeof rawData&&(rawData=!1),"undefined"==typeof pjaxMode&&(pjaxMode=!1),"undefined"==typeof params&&(params={});var index,callerParams,fullUrl="";//caller has send only data
if("undefined"==typeof params.data||rawData){if("string"!=typeof params)callerParams=$.extend({},params);else if(callerParams=fullUrl=params,index=callerParams.indexOf("?"),-1!==index){var subStr=callerParams.substr(0,index+1);//need to replace only "index.php?" or "?"
callerParams=callerParams.replace(subStr,"");}params={},params.data=callerParams;}//Make the request as post by default
//By default we expect json from the server
if(("undefined"==typeof params.type||rawData)&&(params.type="POST"),("undefined"==typeof params.jsonp||rawData)&&(params.jsonp=!1),"undefined"==typeof params.dataType||rawData){var data=params.data;//view will return html
params.dataType="json",data.hasOwnProperty("view")?params.dataType="html":"string"==typeof data&&-1!==data.indexOf("&view=")&&(params.dataType="html"),"undefined"!=typeof params.url&&-1!==params.url.indexOf("&view=")&&(params.dataType="html");}//If url contains params then seperate them and make them as data
if("undefined"!=typeof params.url&&-1!==params.url.indexOf("?")){fullUrl=params.url;var urlSplit=params.url.split("?"),queryString=urlSplit[1];params.url=urlSplit[0];var queryParameters=queryString.split("&");for(index=0;index<queryParameters.length;index++){var queryParam=queryParameters[index],queryParamComponents=queryParam.split("=");params.data[queryParamComponents[0]]=queryParamComponents[1];}}return (("undefined"==typeof params.url||0>=params.url.length)&&(params.url="index.php"),params.success=function(data){null!==data&&"object"===_typeof(data)&&data.error&&(app.errorLog(data.error),data.error.message&&Vtiger_Helper_Js.showMessage({text:data.error.message,type:"error"})),aDeferred.resolve(data);},params.error=function(jqXHR,textStatus,errorThrown){var action=jqXHR.getResponseHeader("yf-action");if("logout"===action&&(window.location.href="index.php"),CONFIG.debug)if(406===jqXHR.status){"-".repeat(150);console.warn("%cYetiForce debug mode!!!","color: red; font-family: sans-serif; font-size: 1.5em; font-weight: bolder; text-shadow: #000 1px 1px;"),console.error("Error: "+errorThrown,"\n------------------------------------------------------------------------------------------------------------------------------------------------------\nTrace:\n------------------------------------------------------------------------------------------------------------------------------------------------------\n"+(jqXHR.responseJSON?jqXHR.responseJSON.error.trace:""),"\n------------------------------------------------------------------------------------------------------------------------------------------------------\nParams:\n------------------------------------------------------------------------------------------------------------------------------------------------------\n"+JSON.stringify(params,null,"\t"));}else app.errorLog(jqXHR,textStatus,errorThrown);"error"==textStatus&&jqXHR.responseJSON&&(textStatus=jqXHR.responseJSON.error.message),aDeferred.reject(textStatus,errorThrown,jqXHR);},""===params.data)?(app.showNotify({type:"error",title:app.vtranslate("JS_ERROR")}),aDeferred.reject()):(jQuery.ajax(params),pjaxMode&&app.changeUrl(params),aDeferred.promise())},/**
	 * Send form data
	 * @param {string} url
	 * @param {object} postData
	 * @param {object} formAttr
	 */requestForm:function requestForm(url){var postData=1<arguments.length&&arguments[1]!==void 0?arguments[1]:{},formAttr=2<arguments.length&&arguments[2]!==void 0?arguments[2]:{};$.extend(formAttr,{method:"post",action:url,style:"display:none;"});var form=$("<form></form>",formAttr);"undefined"!=typeof csrfMagicName&&(postData[csrfMagicName]=csrfMagicToken),$.each(postData,function(index,value){var isMultiple="object"===_typeof(value)&&value.length&&"[]"===index.slice(-2),item=document.createElement(isMultiple?"select":"input");if(item.setAttribute("type","hidden"),item.setAttribute("name",index),isMultiple)for(var i in item.setAttribute("multiple","multiple"),value){var option=document.createElement("option");option.setAttribute("value",value[i]),option.setAttribute("selected",!0),item.appendChild(option);}else item.setAttribute("value",value);form.append(item);}),$("body").append(form),form.trigger("submit"),form.remove();}};
//# sourceMappingURL=Connector.min.js.map
