# YetiForce Change Log

## 7.0.4 2025.03.24

- Fix: Permissions to manually trigger workflow actions from the record card.
- Fix: Updates of data in the "Values from the related module" fields (case of deleting only relationships).
- Fix: Export to XLS (GitHub #89)
- Fix: View record state in the user card.
- Fix: Respecting certificate validation configurable in mail and SMTP server panels. (GitHub #91)
- Fix: Generating queries for reference fields created in non-base tables (GitHub #85)
- Fix: Calculating the progress of work on projects and project milestone.
- Fix: Generating Gantt charts (php `deprecated` issue).
- Fix: [Workflow] Division expression for empty fields (e.g. Unsupported operand types: string / int)
- Fix: [Mail scanner] Decoding the email subject (GitHub #25).
- Fix: [Mail scanner] Parsing an image where the imagick extension is not installed.
- Fix: SMTP connection without encryption (GitHub #57). Check your SMTP configuration and if you didn't have encryption set, set it to TLS.
- Fix: SLA policy without set criteria are not respected when determining ticket handling times (GitHub #101).
- Fix: Generating advanced block records based on field mapping functionality (GitHub #97,#86).
- Fix: Global search button styles (GitHub #93).
- Fix: System update history dashboard widget (PHP Deprecated notice).
- Fix: Displaying "Favorites" icons in the Modules-Relations panel.
- Fix: Delay when getting back to YetiForce tab on Firefox (GitHub #77)
- Fix: Generating PDF documents using the default YetiForcePDF engine.
- Fix: [Workflow] Saving Reply-To field values in email sending actions.
- Fix: Virtual fields on "Chart from filter" widgets.
- Fix: Parsing email content when displaying. The case of emails containing many images in their content.
- Fix: Reset password with token.

- Enh: PDFViewer widget height configuration.
- Enh: Calculating the progress of work on projects without the project milestone.
- Enh: Possibility to delete values in a record for picklist fields via workflow actions.

- Chg: [Mail scanner] SVG files are skipped by default, no more warnings (GitHub #25).
- Chg: Updated dependent libraries [composer] (including `php-debugbar`, `yetiforcepdf` and others).
- Chg: Updated dependent libraries [yarn].
- Chg: Global system currency is set as default in advanced blocks, not from user preference as it was before.
- Chg: Global search - operator list button, available in GUI via GLOBAL_SEARCH_OPERATOR_SELECT configuration parameter (config/Search.php). By default it is inactive.

## 7.0.3 2025.01.22

- Fix: Dav integration when debugging is enabled.
- Fix: Downloading emails using the Outlook Integration Panel
- Fix: Search operators in quick filters (use of <> etc. GitHub #24)
- Fix: Reports module - related module field use in condition
- Fix: Update related record workflow task (case of a reference field working for several modules)
- Fix: Excluded SharedOwner field type from Additional data sources in calendar view
- Fix: PDF filter conditions for multitree field type (template settings)
- Fix: Redundant cleaning of document source content in wysiwyg fields (PDF template | Twig)
- Fix: Merging records
- Fix: Decode session data (warning when running cron job GitHub #7)
  `session.serialize_handler` - add `php_serialize` and drop `php_binary`
- Fix: Permissions for creating system notifications from workflow
- Fix: Permissions to send email notifications from workflow
- Fix: Minor fixes to element placement in the report template edit view
- Fix: Displaying inventory fields in reports (advanced block)
- Fix: YetiForce CLI methods when there is no migrations directory (Doctrine)
- Fix: Selection of modules in the basic field of the advanced block. Limit increased. (Setting)
- Fix: Extended auto formatting period in advanced block fields
- Fix: Rename/delete picklist value for multipicklist field (Settings)
- Fix: Record numbering, taking into account values from other fields (advanced record numbering)
- Fix: Deprecated messages for project hierarchy. Case when there is no data in the hierarchy
- Fix: Calendar - showing a list of days (tabs) with the number of events in the day view with the timeline turned off (`dayGridDay` mode)
- Fix: Query generation in special cases: document widget, data encryption (GitHub #67)
- Fix: TextParser function RelatedRecordsData available in PDF templates
- Fix: Mass download of documents from the list of related records. Added additional validators and messages. Improved deletion of generated temporary files.
- Fix: Removing workflow actions
- Fix: Allow to display system templates on workflow email templates list
- Fix: Data formatting when automatically completing fields from Products/Services in advanced blocks.
- Fix: Error messages when mandatory reference fields are added to an advanced block.
- Fix: Verification of shared permissions in cron processes.
- Fix: Minor improvements to the progress field update on projects and milestones.
- Fix: Removing a record label from temporary cache when the record does not exist.
- Fix: Sorting in the function that lists related records in PDF (GitHub #65)
- Fix: Completing comments when mass adding products/services with a description (GitHub #63)
- Fix: Advanced block: improved marking of the icon indicating having a comment when adding a Product/Service
- Fix: Workflow - "does not contain" operator with empty value (GitHub #61)
- Fix: Deleting the lib_roundcube.zip file after installing the library (GitHub #59)
- Fix: Improved completion of reference fields from the ChangeValueHandler event
- Fix: Incorrect display of all-day events on the graphical calendar (GitHub #48)
- Fix: Mail scanner: by default, emails without an addressee, i.e. with a hidden `to` section, are skipped.
- Fix: Mail Scanner: Email receipt date now takes into account time zone differences. (GitHub #6)
- Fix: Create an all-day calendar entry assigned to a group. (GitHub #11)
- Fix: Displaying special characters in the graphical calendar view. (GitHub #12)
- Fix: SLA Policy tab in Service Contract doesn't show values correctly for `Templates` option (GitHub #13)
- Fix: Handling records with removed links in advanced blocks (GitHub #73)
- Fix: Generating a record using the mapping functionality in the advanced block scope
- Fix: Displaying a calendar for the datetime field on record summary widgets
- Fix: Minor correction of default value for "Is Converted From Lead" field from 'no' to 0.
- Fix: Handling empty folders or moved emails from scanned mailboxes

- Enh: Add ability to set filters order in menu configuration
- Enh: Add ability to filter by user role in workflow
- Enh: Support for ">= <= < >" characters in quick record list filters for currency fields (GitHub #24)
- Enh: Add ability to filter by Total time field in workflow
- Enh: Verification before deleting records used in advanced blocks (Products/Services)
- Enh: Add row summary for "Chart from filter" widget, tabular mode

- Chg: Action button placements (PDF template - edit view)
- Chg: Improving the process of calculating user permissions. Optimized the process and disabled permissions recalculation for inactive users.
- Chg: Auto-population of reference fields from base record in record edit view (quick create). This functionality was removed in YF6.5 and is now restored.
- Chg: Unification of the way of previewing content from description fields in modal windows. In some places, the modal window was narrow and a scroll appeared, which made viewing the content difficult.
- Chg: Upgrade Roundcube Webmail dependency to version 1.6.9. This library needs to be updated manually in admin panel.
- Chg: Updated dependent libraries.

- Rem: Removed system notifications related to RBL

## 7.0.2 2024.09.11

- Enh: Ability to configure where summaries are displayed in advanced blocks
- Enh: Extended filtering and sorting capabilities in the workflow action list
- Enh: Added ability to autocomplete geographic coordinates for the Coordinates field directly from the map view (Locations module)
- Enh: Added userPrincipalName for SSO verification (Microsoft Entra)
- Enh: Extended IMAP connection class to move emails to another folder (backend only)

- Fix: Default modern interface: Advanced block, widgets, etc.
- Fix: Displaying a multipicklist value in record list view
- Fix: (PDF) Page numbering for the chromium engine
- Fix: (Mail Scanner) Eliminates the image download error for outdated URLs
- Fix: (Mail Scanner) Error scanning empty mailbox folders
- Fix: DebugBar
- Fix: Display error messages for Record Collector
- Fix: Data update for MultiReference fields. The case of non-existent entries.
- Fix: Link for the Coordinates field in the records list view
- Fix: Creating a duplicate when completing data based on a RecordCollector from a workflow action
- Fix: Automatic change of currency symbol in currency fields, based on the settings of the currency picklist field (module: Payments In, Payments Out)
- Fix: Value for a double type field is no longer rounded when displayed.
- Fix: Support for php8 in workflow conditions
- Fix: Hierarchy in the sales opportunity module including archived records
- Fix: Possibility to change the login password after authenticating with another method, e.g. SSO
- Fix: YetiForce CLI methods when there is no migration (Doctrine)
- Fix: Record preview: Listing fields on widgets
- Fix: Content Sensitive help in Layout Editor hangs (#17505)
- Fix: Sum fields in related list view (#17482)
- Fix: Dav authentication (php8 support)
- Fix: Logger for Dav integration
- Fix: Permission type to generate mapped field records
- Fix: Comment display (edit/preview)
- Fix: Conflict of interests panel (DataTable)
- Fix: Quick edit of the MultipicklistTags field
- Fix: Displaying users who have been permanently removed from the system
- Fix: Calculating progress on service contracts with inactive date fields
- Fix: Displaying buttons in the calendar creation view
- Fix: PDFViewer widget (support php8.3)
- Fix: Exporting advanced module data
- Fix: Displaying buttons in popover for multiImage fields
- Fix: Displaying badges element in record link popover
- Fix: Communication via imap in smtp settings
- Fix: Autocomplete values from deleted records
- Fix: Data Summary widget responsiveness
- Fix: Calculating amounts in the tax modal window (advanced block)
- Fix: Deleting advanced block elements when creating new entries for default rows (advanced block)
- Fix: Related list paginate total records amount
- Fix: Timeline widget layout for better responsiveness
- Fix: Viewing currency rates when no source bank is specified (admin panel)
- Fix: Display columns in report template
- Fix: Added some missing translations
- Fix: Events for Additional data sources in Calendar view filters
- Fix: Import data
- Fix: Incorrect message when removing shared permissions (Module access panel)
- Fix: Displaying content in the workflow action list (double encoding #16590)
- Fix: Displaying data from other modules on the calendar (Calendar extra data sources)
- Fix: Negative values in the geographic coordinates field (Locations module)
- Fix: Unused buttons from pointer map modal window (Locations module)
- Fix: Adjusting action buttons in tile view (css)
- Fix: Updated dependent libraries (composer)
- Fix: Validation of access keys in the map providers configuration
- Fix: Reset password from CLI (incorrect variable typing in dependent library)
- Fix: Widget type "Chart from filter". Improved chart links and data for Tabular widgets
- Fix: Minor fixes (typing, variable declaration, etc. | PHP8.3)
- Fix: Identification of scanned email type (Internal, Sent, Received)

- Chg: Roundcube email client update (#99 Upgrade imports button style)
- Chg: Record status marking restored in record list view
- Chg: Error messages from collector record elements
- Chg: Improved ConfReport (panel with basic configuration of server parameters)
- Chg: Error handling for imap connections (SMTP)
- Chg: Mandatory pdf template in Send pdf action in workflow
- Chg: Default timeout for http requests from 10 to 60 seconds
- Chg: The "Short Name" field in the Account module can now be deactivated

- Rem: Removed WebDAV configurations. Code cleanup as this functionality was never implemented.

## 7.0.1 2024.05.09

- Enh: Frees up space by removing unnecessary files and folders from dependencies
- Enh: Add CLI installation process
- Enh: Management of dynamic properties in workflow tasks
- Enh: Conditioning on the ID field in QueryGenerator
- Enh: Add a language header to http request
- Enh: Improved address search for Google geocode to localnumber field
- Enh: Expansion of the query condition builder mechanism

- Chg: Changed the method of generating PDF documents to make them more easily accessible from the API
- Chg: Changed default phone number format for phone parser from NATIONAL to INTERNATIONAL
- Chg: Changed quick export of data to a file to simplify the generation of these files by the API
- Chg: Improved verification of several parameters in ConfReport
- Chg: Improved installation of update packages from the CLI
- Chg: Updated dependencies

- Fix: Default modern interface
- Fix: A panel listing the history of downloaded emails (#17428)
- Fix: Relation before/after link for source handler trigger
- Fix: Virtual fields conditions
- Fix: Adding comments from the widget
- Fix: Creating relations for reporting
- Fix: Related module column names in query results
- Fix: Module export
- Fix: Report preview data in quick preview from a modal window
- Fix: SMSAPI message length calculation
- Fix: Prevent loops when changing separator (User preferences)
- Fix: Add missing permissions to the status picklist value in the Vendor enquiries module
- Fix: Set default query operator for Reference field
- Fix: PHP8 deprecated warnings (Workflow)
- Fix: Prevent system warnings from being sent when there is no SMTP configuration
- Fix: Changing the password for an email account in the email scanner panel
- Fix: List of related modules available when creating a report
- Fix: Quick file export for a virtual field
- Fix: Skip inventory fields for related modules (Report)
- Fix: Latest emails widget on dashboard
