<?php
/**
 * Container configuration for DB package file
 *
 * @package \App\Db
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mateusz Slominski <m.slominski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Db;

use App\Config;
use Yii;

/**
 * Container configuration for DB package class
 */
class ContainerConfiguration
{
	/**
	 * Initialize configuration
	 *
	 * @return void
	 * @throws \yii\base\InvalidConfigException
	 */
	public static function init()
	{
		Yii::$container = new \yii\di\Container();
		Yii::setLogger(Yii::createObject('App\Log'));
	}
}
