<?php
/**
 * File generator interface class
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Leszek Koziatek <l.koziatek@yetiforce.com>
 */
declare(strict_types=1);

namespace App\DocumentBuilder;

/** FileGeneratorInterface class  */
interface FileGeneratorInterface
{
	/** Generate file */
	public function generate(string $filename, array $data, array $headers = [], array $groupedBy = []): void;

	/** Get file path */
	public function getFilePath(string $filename): string;
}
